import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Item
{
    id : itemInput
    property alias inputText : textInput.text;
    property alias titleText : textTitle.text;
    property int mobileView : tepee.mobileRes;
    property bool passwordChar : false;
    property bool inline : true;
    property int offset : (mobileRes < 80) ? 3 : -2
    property bool line_edit;
    property string vColor : "lightsteelblue"
    property string bColor : "#F80000"
    property string inColor : vColor;
    // width : contentRec.width / 5;
    // height : (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15

    function clearInput()
    {
        textInput.text = "";
    }


    function inputRight(ok)
    {
        inColor = vColor;
        if (!ok)
            inColor = bColor;
    }

    Text
    {
        id : textTitle
       // anchors.horizontalCenter: parent.horizontalCenter
        text : "Title :"
        font.pointSize: tepee.textSize
        width: text.length * (font.pointSize + offset)
        color : "white"
    }

    Rectangle
    {
        id : textInputRec
        width: itemInput.width;
        height: (inline) ? itemInput.height : itemInput.height - (textTitle.height + 5)
        anchors.left : (inline) ? textTitle.right : itemInput.left
        anchors.leftMargin: (inline) ? 0 :  1
        anchors.top: (inline) ? textTitle.top : textTitle.bottom
        border.width: 3
        border.color: "#4b4b4b"
        color: "lightsteelblue"
        radius: 5




        Flickable {
            id: flick
            anchors.fill : parent
            anchors.topMargin : (mobileView == 139) ? 5 : (mobileView == 80) ? 3 : 0
            anchors.leftMargin: 8
            contentWidth: textInput.paintedWidth
            contentHeight: textInput.paintedHeight
            clip: true



            function ensureVisible(r)
            {
                if (contentX >= r.x)
                    contentX = r.x;
                else if (contentX+width <= r.x+r.width)
                    contentX = r.x+r.width-width;
                if (contentY >= r.y)
                    contentY = r.y;
                else if (contentY+height <= r.y+r.height)
                    contentY = r.y+r.height-height;
            }

            TextEdit {
                id: textInput
                width: flick.width
                height: flick.height
                focus: true
                font.pointSize: tepee.textSize
                text: "Enter text here..."
                color: "white"
                wrapMode: TextEdit.Wrap
                onCursorRectangleChanged: flick.ensureVisible(cursorRectangle)
                onActiveFocusChanged:
                {
                    if (textInput.activeFocus)
                        textInputRec.color = "#009900";
                    else
                        textInputRec.color = inColor;
                }
            }
        }

        MouseArea
        {
            anchors.fill: parent
            onClicked:
            {
                if (!textInput.activeFocus)
                {
                    textInput.forceActiveFocus();
                    textInput.openSoftwareInputPanel();
                    textInput.selectAll()
                }
                else
                {
                    textInput.focus = false;
                }

            }
        }
    }
}
