import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Item
{
    id : itemInput
    property alias inputText : textInput.text;
    property alias titleText : textTitle.text;
    property int mobileView : tepee.mobileRes;
    property bool passwordChar : false;
    property bool inline : true;
    property int offset : (mobileRes < 80) ? 3 : -2
    property bool line_edit;
    property string vColor : "#009900"
    property string bColor : "#F80000"
    property string inColor : vColor;
    property bool   isBeingEdited : false;
    property bool   isCorrect : true;


    height : (mobileView == 139) ? ((inline) ?  60 : 110) : (mobileView == 80) ? ((inline) ? 40 : 80) : ((inline) ? 30 : 70)


    function clearInput()
    {
        textInput.text = "";
    }

    function inputRight(ok)
    {
        inColor = vColor;
        if (!ok)
            inColor = bColor;
        isCorrect = ok;
    }

    Text
    {
        id : textTitle
        //anchors.centerIn: parent
        text : "Title :"
        font.pointSize: tepee.textSize
        width: text.length * (font.pointSize + offset)
//        width: text.length * (2 * font.pointSize + offset) //ANDROID
        color : "white"
    }

    Rectangle
    {
        id : textInputRec
        width: itemInput.width;
        height: (inline) ? itemInput.height : itemInput.height - (textTitle.height + 5)
        anchors.left : (inline) ? textTitle.right : itemInput.left
        anchors.leftMargin: (inline) ? 0 :  1
        anchors.top: (inline) ? textTitle.top : textTitle.bottom
        border.width: 3
        border.color: "#4b4b4b"
        color: isBeingEdited ? inColor : (isCorrect) ? "lightsteelblue" : inColor;
        radius: 5

        TextInput
        {
            id: textInput
            anchors
            {
                left : parent.left
                right : parent.right
                verticalCenter : parent.verticalCenter
                leftMargin : 5
                rightMargin : 5
            }

            font.pointSize: tepee.textSize
            text: "Enter text here..."
            color: "white"
            clip : true
            focus: true
            echoMode: passwordChar ? TextInput.Password : TextInput.Normal
            onActiveFocusChanged:
            {
//                console.log(isBeingEdited);
                if (textInput.activeFocus)
                    isBeingEdited = true;
                else
                    isBeingEdited = false;
            }
        }

        MouseArea
        {
            anchors.fill: parent
            onClicked:
            {
                if (!textInput.activeFocus)
                {
                    textInput.forceActiveFocus();
                    textInput.openSoftwareInputPanel();
//                    textInput.selectAll();
                }
                else
                {
                    textInput.focus = false;
                }
            }
        }
    }
}
