
var mDate = new Date();
console.log("CURRENT DAY " + mDate.getDay());
function    setNewDate(dateElem)
{
    mDate = dateElem;
}

function    setCurrentDate(dayNum, monthNum, yearNum)
{
    mDate = new Date(yearNum, monthNum, dayNum);
}

function    getYear()
{
    return mDate.getFullYear();
}

function    getMonthNum()
{
    return  mDate.getMonth();
}

function    getDayNum()
{
    return mDate.getDate();
}

function    setCurYearDate(num)
{
    mDate.setFullYear(num);
}

function    setDayOfMonthNum(num)
{
    mDate.setDate(num);
}

function    setMonthNum(num)
{
    mDate.setMonth(num);
}

function    getDayOfWeekNum()
{
    return mDate.getDay();
}

function    getDayOfWeekName(num, getCur)
{
    if (getCur)
        num = getDayOfWeekNum();
    var     dayNames = ["Sunday", "Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
    return dayNames[num];
}

function    getMonthName(num, getCur)
{
    if (getCur)
        num = getMonthNum();
    var     monthNames = ["January","February","March","April","May","June","July","August","September","October","November","December"];
    return monthNames[num];
}

function    getNumberOfDaysInMonth()
{
    var tmpDate = new Date(mDate.getFullYear(), mDate.getMonth(), 32);
    return (32 - tmpDate.getDate());
}

function    generateMonthModel(listModelName)
{
    var tmpDate = new Date(mDate.getFullYear(), 0, 1);
    var curDate = new Date();
    var i = 0;
    listModelName.clear();
    while (i < 12)
    {
        tmpDate.setMonth(i);
        listModelName.append({"monthNum" : i, "monthName" : getMonthName(i), "isCurMonth" : (curDate.getFullYear() == tmpDate.getFullYear() && curDate.getMonth() == tmpDate.getMonth())});
        i++;
    }
}

function    generateYearModel(listModelName)
{
    var i = 0;
    var tmpDate = new Date(mDate.getFullYear() - 100, 1, 1);
    listModelName.clear();
    while (i < 100)
    {
        tmpDate.setFullYear(tmpDate.getFullYear() + 1)
        listModelName.append({"yearNum" : tmpDate.getFullYear()});
        i++;
    }
}

function    generateDayInMonthModel(listModelName)
{
    var i = 0;
    var max = getNumberOfDaysInMonth();
    var tmpDate = new Date(mDate.getFullYear(), mDate.getMonth(), 1);
    var curDate = new Date();
    listModelName.clear();
    while (i < max)
    {
        tmpDate.setDate(++i);
        listModelName.append({"dayNum" : i,
                              "isToday" : ((tmpDate.getMonth() == curDate.getMonth()) &&
                                              (tmpDate.getDate() == curDate.getDate()) &&
                                              (tmpDate.getFullYear() == curDate.getFullYear())),
                              "dayName" : getDayOfWeekName(tmpDate.getDay())});
    }
}
