import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import webthumbnail 1.0

Item
{
    id : thumbnail_item
    property alias title : textT.text;
    property alias url : web.url;
    property int mobileView : tepee.mobileRes;
    property int radius : 15;
    property variant context;
    signal thumbnailMaximized

    WebThumbnail
    {
        id : web
        clip : true
        width : parent.width
        height : parent.height
        radius : parent.radius
        smooth : true
        context : parent.context
        opacity : (web.status == WebThumbnail.Ready) ? 1.0 : 0
        scale : (web.status == WebThumbnail.Ready) ? 1.0 : 0
        Behavior on scale {
            NumberAnimation { duration: 450; easing.type: Easing.OutQuad }
        }
        Behavior on opacity {
            NumberAnimation { duration: 350; easing.type: Easing.OutQuad }
        }
    }
    Rectangle
    {
        id : loadingrec
        anchors.fill: parent
        radius: parent.radius
        smooth : true
//        gradient :
//            Gradient {
//            GradientStop {position : 0.0; color : "#00FF33"}
//            GradientStop {position : 1.0; color : "#00FF99"}
//        }
        color : "transparent"
        opacity:  (web.status == WebThumbnail.Ready) ? 0 : 1.0
        Text
        {
            anchors.centerIn: parent
            color : "white"
            text : web.progress
        }

        BusyIndicator
        {
            anchors.centerIn: parent
            id : busyi
            on : (opacity == 1.0) ? true : false;
        }
        Behavior on opacity {
            NumberAnimation { duration: 350; easing.type: Easing.OutQuad }
        }
    }

    Text
    {
        id : textT
//        maximumLineCount: 1
        clip : true
        anchors.centerIn: parent
        font.pointSize: (mobileView == 139) ? 45 : (mobileView == 80) ? 30 : 12
        color: "#00CC00"
    }
}
