#ifndef CONNECTION_H
#define CONNECTION_H

#include <QTcpSocket>
#include <QString>
#include <QHostAddress>
#include <QSqlDatabase>
#include <QDataStream>
#include <QtSql>
#include <QCryptographicHash>
#include <iostream>
#include <QObject>
#include "CircularBuff.h"

class Connection : public QTcpSocket
{
    Q_OBJECT
signals:
    void            recvData(unsigned char *, int);
    void            analyseCommand();
    void            connectionLost();
public slots:
    unsigned char * readCircularBuff(int *len);
    void            closeConnection();
    void            openConnection(QString, int);
    void            writeCircularBuff(unsigned char *, int len);
    void            clearReadBuff(int);
    void            clearWriteBuff(int);

public:
    Connection();
    ~Connection();



private slots :
    bool            writeSocket();
    bool            readSocket();

private:
    QHostAddress    servAddr;
    int             servPort;
    CircularBuff    *readBuff;
    CircularBuff    *writeBuff;
    bool            isConnected;
};
#endif // CONNECTION_H
