#include "connection.h"

Connection::Connection() : QTcpSocket()
{
    std::cout << "CONNECTION CREATED" << std::endl;
    this->isConnected = false;
    this->readBuff = new CircularBuff;
    this->writeBuff = new CircularBuff;
    // SIGNAL TO READ DATA WHEN SOMETHING IS ON SOCKET
    QObject::connect(this, SIGNAL(readyRead()), this, SLOT(readSocket()));
    // SIGNAL TO CLOSE PROPERLY CONNECTION WHEN DISCONNECTED
    QObject::connect(this, SIGNAL(disconnected()), this, SLOT(closeConnection()));
    // SIGNAL TO TRIGGERED LOST CONNECTION SIGNAL WHEN SOCKET DISCONNECTED
    QObject::connect(this, SIGNAL(disconnected()), this, SIGNAL(connectionLost()));
}

Connection::~Connection()
{
    this->closeConnection();
    delete this->readBuff;
    delete this->writeBuff;
}

void Connection::openConnection(QString a, int port)
{
    std::cout << "SHOULD ESTABLISH CONNECTION NOW" << std::endl;
    if (!this->isConnected)
    {
        std::cout << "VALUE A = " << a.toStdString() << " PORT = " << port << std::endl;
        this->servAddr = QHostAddress(a);
        this->servPort = port;
        this->connectToHost(a, this->servPort);
        std::cout << this->errorString().toStdString() << std::endl;
        std::cout << "VALUR HOSTADRESS " << this->servAddr.toString().toStdString() << std::endl;
        if (this->waitForConnected(2000))
        {
            this->isConnected = true;
            std::cout << "********************CONNECTION ESTABLISHED *************************" << std::endl;
        }
        else
            emit(disconnected());
    }
    else
        emit (connected());
}

void Connection::closeConnection()
{
    std::cout << "DISCONNECTING" << std::endl;
    this->isConnected = false;
    this->disconnectFromHost();
    this->close();
}

unsigned char*  Connection::readCircularBuff(int *len)
{
    return (this->readBuff->readFromBuff(len));
}

void            Connection::writeCircularBuff(unsigned char *d, int len)
{
    std::cout << "BEFORE WROTE TO CIRCBUFF " << len << std::endl;
    this->writeBuff->addToBuff(d, len);
    std::cout << "WROTE TO CIRCBUFF" << std::endl;
    this->writeSocket();
}

void            Connection::clearReadBuff(int o)
{
    this->readBuff->clearBuff(o);
}

void            Connection::clearWriteBuff(int o)
{
    this->writeBuff->clearBuff(o);
}

bool  Connection::writeSocket()
{
    std::cout << "WRITING" << std::endl;
    int                 diff;
    unsigned char       *data = this->writeBuff->readFromBuff(&diff);
    int                 i = 0;

    if ((i = this->writeData((const char *)data, diff)) == -1)
        return false;
    this->writeBuff->clearBuff(i);
    this->flush();
    delete []data;
    return true;
}

bool Connection::readSocket()
{
    unsigned char buff[256];
    int           i = 0;

    memset(buff, 0, 256);
    while((i = this->read((char *)buff, 255)) > 0)
    {
        this->readBuff->addToBuff(buff, i);
        memset(buff, 0, 256);
        std::cout << "i = " << i << std::endl;
        if (i < 255)
            break;
        std::cout << "READING ON SOCKET " << i << std::endl;
    }
    if (i <= 0)
        return false;
    std::cout << "DATA TO BE READ FROM BUFF " <<  this->readBuff->getSizeOfCurData() << std::endl;
    emit(recvData(this->readBuff->readFromBuff(NULL), this->readBuff->getSizeOfCurData()));
    return true;
}
