#ifndef APPCONTROLER_H
#define APPCONTROLER_H

#include <QString>
#include <QVariant>
#include <QObject>
#include <QMetaType>
#include "notelogic.h"
#include "bookmarklogic.h"
#include "agendalogic.h"
#include "contactlogic.h"
#include "connectionthread.h"
#include "weatherlogic.h"
#include "filelogic.h"
#include "eventlogic.h"
#include <QDesktopServices>
class AppControler : public QObject
{
    Q_OBJECT

private :
    NoteLogic           *notes;
    AgendaLogic         *agenda;
    ContactLogic        *contacts;
    ConnectionThread    *cT;
    BookMarkLogic       *books;
    weatherlogic        *weather;
    Filelogic           *fileftp;
    eventLogic          *event;

    QString             userName;
    QString             userPass;
    QString             background;
    QString             country;
    QString             city;
    QString             countryDefaults;
    QString             cityDefaults;

    QString             firstNameUser;
    QString             lastNameUser;
    QString             emailUser;
    QString             hNumUser;
    QString             cNumUser;
    QString             addressUser;

    QColor              styleColor;
    double              styleOpacity;
    QUrl                servAddr;
    int                 servPort;
    bool                connect;
    bool                isSetting;
    bool                isInfo;
    bool                visibilityUser;
    qint64              donefile;
    qint64              totalfile;

public:
    AppControler();
    ~AppControler();

    void  initDBLoading();

    void  LoadBMfromDBApp();
    void  LoadNotefromDBApp();
    void  LoadContactfromDBApp();
    void  LoadTasksfromDBApp();
    void  LoadEventfromDBApp();
    void  LoadInfoUserDBApp();


    Q_INVOKABLE void  LoadLocationWeatherfromDBApp();
    Q_INVOKABLE void  LoadWeatherfromDBapp();
    // FTP
    Q_INVOKABLE void connectToFtp();
    Q_INVOKABLE ListModel * getfileftpMod();
    Q_INVOKABLE void dowloadFile(QString);
    Q_INVOKABLE void delFile(QString name, int id);
    Q_INVOKABLE qint64 getDone();
    Q_INVOKABLE qint64 getTotal();
    Q_INVOKABLE void setDone(qint64);
    Q_INVOKABLE void setTotal(qint64);
    Q_INVOKABLE void openFile(QString);
    Q_INVOKABLE QString getDirFtp();
    Q_INVOKABLE void uploadFile(QString);
    Q_INVOKABLE void listFile();
    // NOTES
    Q_INVOKABLE ListModel* getClientNotes();
    Q_INVOKABLE bool addNote(QString, QString);
    Q_INVOKABLE void editNote(QString, QString, int);
    Q_INVOKABLE void removeNote(int);

    // WEATHER
    Q_INVOKABLE void setWeatherDay(int numday , int nummonth, int numyear , QString nameday, QString namemonth, int highttemp, int lowtemp, QString conditions, QString country, QString city);
    Q_INVOKABLE void  deleteDBWeather(QString, QString);
    Q_INVOKABLE void addNewLocation(QString, QString);
    Q_INVOKABLE ListModel * getweatherMod();
    Q_INVOKABLE ListModel * getweatherLocationMod();
    Q_INVOKABLE void deleteWeatherFromListViewAp();
    Q_INVOKABLE void deleteWeatherLocationFromListView();
    Q_INVOKABLE void deleteWeatherLocationFromDb(QString, QString);

    // BOOKMARKS
    Q_INVOKABLE ListModel * getBookMarksMod();
    Q_INVOKABLE bool        addBookMark(QString, QString);
    Q_INVOKABLE void        editBookMark(QString, QString, int);
    Q_INVOKABLE void        removeBookMark(int);

    // EVENT
    Q_INVOKABLE ListModel * getEventModel();
    Q_INVOKABLE void        addEvent(QString title_, QString description_, QString country_, QString city_, QString date_, QString hour_, QString creatorFName_, QString creatorLName_, QString contactList_);
    Q_INVOKABLE void        editEvent(QString title_, QString description_, QString country_, QString city_, QString date_, QString hour_, QString creatorFName_, QString creatorLName_, QString contactList_, int id);
    Q_INVOKABLE void        removeEvent(int id);

    //AGENDA

    Q_INVOKABLE void        addTask(QString t, QString c, int hs, int ms, int ds, int mts, int ys, int he, int me, int de, int mte, int ye);
    Q_INVOKABLE void        editTask(QString t, QString c, int hs, int ms, int ds, int mts, int ys, int he, int me, int de, int mte, int ye, int id);
    Q_INVOKABLE void        rmTask(int id);
    Q_INVOKABLE ListModel * getTaskModel();
    Q_INVOKABLE ListModel * getWeekTaskModel();
    Q_INVOKABLE void        setTaskModelDate(int currentDay, int currentMonth, int currentYear);


    //CONTACTS
    Q_INVOKABLE ListModel * getContactsMod();
    Q_INVOKABLE bool        addContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, bool fr, QString uc);
    Q_INVOKABLE void        editContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, int id);
    Q_INVOKABLE void        removeContact(int id);
    // SETTINGS
    Q_INVOKABLE void        setServerSetting(QString u, QString p, QString add, QString po, QString ba,  QColor cS, double opacity);
    Q_INVOKABLE void        checkSetting();
    Q_INVOKABLE bool        getSettingSet();
    Q_INVOKABLE QString     getUsername();
    Q_INVOKABLE QString     getpassword();
    Q_INVOKABLE QString     getAdress();
    Q_INVOKABLE QString     getPort();
    Q_INVOKABLE QString     getBackGround();
    Q_INVOKABLE QString     getCountry();
    Q_INVOKABLE QString     getCity();
    Q_INVOKABLE QString     getCountryDefaults();
    Q_INVOKABLE QString     getCityDefaults();
    Q_INVOKABLE QColor      getStyleColor();
    Q_INVOKABLE double      getStyleOpacity();
    Q_INVOKABLE void        setCountry(QString);
    Q_INVOKABLE void        setCity(QString);
    Q_INVOKABLE void        setCountryDefaults(QString);
    Q_INVOKABLE void        setCityDefaults(QString);
    // CONNECTION MANAGER
    Q_INVOKABLE void        syncWithServer();
    Q_INVOKABLE bool        restoreModelsFromDB();
    // INFO USER
    Q_INVOKABLE   void   setInfoUser(QString firstName, QString lastName, QString email, QString hnum, QString cnum, QString addr, bool visibility);
    Q_INVOKABLE   QString   getUserFirstName() const;
    Q_INVOKABLE   QString   getUserLastName() const;
    Q_INVOKABLE   QString   getUserHNum() const;
    Q_INVOKABLE   QString   getUserCNum() const;
    Q_INVOKABLE   QString   getUserEmail() const;
    Q_INVOKABLE   QString   getUserAddress() const;
    Q_INVOKABLE   bool      getUserVisibility() const;

signals:
    void queryApp(QString q, int);
    void synchingProgress(QVariant);
public slots:
    void retQuerySetting(QList<QSqlRecord>,int);
    void updateDataProgress(qint64,qint64);
    
};


#endif // APPCONTROLER_H
