 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtQuick 1.1
import "HourLogic.js" as HourLogic

Item
{
    property int currentHour : 0;
    property int currentMin : 0;
    property bool backButton : false;

    signal backButtonClicked();

    width : main_win_rec.width - (2 * tepee.mobileRes)
    height : main_win_rec.height - (2 * tepee.mobileRes)


    function    updateTimeInf()
    {
        currentHour = HourLogic.getHour();
        currentMin = HourLogic.getMinute();
    }

    function    setSelectedTime(hour, min)
    {
        if (hour >= 12)
        {
            am_pm_selector.am = false;
            hour -= 12;
        }
        else
            am_pm_selector.am = true;
        view.currentIndex = hour;
        viewMin.currentIndex = min;
    }

    Gradient
    {
        id : blue_black_grad
        GradientStop {position : 0.0; color : "#000033"}
        GradientStop {position : 1.0; color : tepee.elemBackColor}
    }

    Gradient
    {
        id : qt_green_grad
        GradientStop {position : 0.0; color : "#01DF01"}
        GradientStop {position : 1.0; color : "#298A08"}
    }

    Gradient
    {
        id : highlight_grad
        GradientStop {position : 0.0; color : tepee.highLightColor}
        GradientStop {position : 1.0; color : tepee.highLightColor2}
    }
    Component.onCompleted:
    {
        updateTimeInf();
        HourLogic.generateTwelveHourModel(hourModel);
        HourLogic.generateMinuteModel(minModel);
    }

    Path
    {
        id : circle_path
        property int width : view.height
        property int height : view.height
        property int pathMargin: tepee.mobileRes
        property real rx: ry // circle_path.width / 2 - pathMargin
        property real ry: height / 2 - pathMargin
        property real magic: 0.551784
        property real mx: rx * magic
        property real my: ry * magic
        property real cx: width / 2
        property real cy: height / 2
        startX: circle_path.cx + circle_path.rx; startY: circle_path.cy
        PathCubic { // first quadrant arc
            control1X: circle_path.cx + circle_path.rx; control1Y: circle_path.cy + circle_path.my
            control2X: circle_path.cx + circle_path.mx; control2Y: circle_path.cy + circle_path.ry
            x: circle_path.cx; y: circle_path.cy + circle_path.ry
        }
        PathCubic { // second quadrant arc
            control1X: circle_path.cx - circle_path.mx; control1Y: circle_path.cy + circle_path.ry
            control2X: circle_path.cx - circle_path.rx; control2Y: circle_path.cy + circle_path.my
            x: circle_path.cx - circle_path.rx; y: circle_path.cy
        }
        PathCubic { // third quadrant arc
            control1X: circle_path.cx - circle_path.rx; control1Y: circle_path.cy - circle_path.my
            control2X: circle_path.cx - circle_path.mx; control2Y: circle_path.cy - circle_path.ry
            x: circle_path.cx; y: circle_path.cy - circle_path.ry
        }
        PathCubic { // forth quadrant arc
            control1X: circle_path.cx + circle_path.mx; control1Y: circle_path.cy - circle_path.ry
            control2X: circle_path.cx + circle_path.rx; control2Y: circle_path.cy - circle_path.my
            x: circle_path.cx + circle_path.rx; y: circle_path.cy
        }
    }

    // SELECTED HOUR
    Item
    {
        width : tepee.mobileRes
        height : tepee.mobileRes
        anchors
        {
            horizontalCenter : parent.horizontalCenter
            bottom : parent.bottom
            bottomMargin : tepee.mobileRes
        }
        Rectangle
        {
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            radius : 360
            anchors.fill: parent
            border
            {
                width : 2
                color : "grey"
            }
        }
        Text
        {
            id : tmp_time_disp
            text : ((currentHour < 10) ? "0" : "") + currentHour + " : " + ((currentMin < 10) ? "0" : "") + currentMin;
            color : "white"
            anchors.centerIn: parent
            font.pointSize: tepee.textSize
        }
    }


    // HOUR PICKER
    Item
    {
        id : hour_pick_item
        width : parent.width / 2
        height : width
        anchors.right: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter

        ListModel
        {
            id : hourModel;
        }

        Rectangle
        {
            id : back_hour_rec
            anchors
            {
                fill : parent
                margins : tepee.mobileRes / 2
            }
            color : tepee.elemBackColor
            radius : 360
            smooth : true
            opacity : tepee.elemBackOpacity
            border
            {
                color : "grey"
                width : 1
            }
        }
        PathView
        {
            id : view
            model : hourModel
            anchors.fill: parent
            pathItemCount: 12
            delegate : hour_del
            path : circle_path
        }
        Rectangle
        {
            property bool am : true;
            id : am_pm_selector
            scale : (am_pm_sel_ma.pressed) ? 0.9 : 1.0
            width : tepee.mobileRes
            height : tepee.mobileRes
            anchors.centerIn: back_hour_rec
            anchors.margins: tepee.mobileRes
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 360
            smooth : true
            border
            {
                color : "grey"
                width : 1
            }
            MouseArea
            {
                id : am_pm_sel_ma
                anchors.fill: parent
                onClicked:
                {
                    am_pm_selector.am = !am_pm_selector.am;
                }
            }
            Text
            {
                font.pointSize: tepee.textSize
                anchors.centerIn: parent
                color : "white"
                text : (am_pm_selector.am) ? "AM" : "PM"
            }
        }

    }

    // BACK BUTTON
    Button
    {
        id : back_button
        anchors
        {
            horizontalCenter : parent.horizontalCenter
            top : parent.bottom
            topMargin : - tepee.mobileRes / 2
        }

        resImg : tepee.mobileRes
        numId : 173
        text : "Back"
        buttonColor: "blue"
        buttonShape: "round"
        opacity : backButton ? 1 : 0
        onButtonClicked:
        {
            backButtonClicked();
        }
    }



    // MINUTES PICKER
    Item
    {
        id : min_pick_item
        width : parent.width / 2
        height : width
        anchors.left: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter
        ListModel
        {
            id : minModel;
        }
        Rectangle
        {
            id : back_min_rec
            anchors
            {
                fill : parent
                margins : tepee.mobileRes / 2
            }
            color : tepee.elemBackColor
            radius : 360
            smooth : true
            opacity : tepee.elemBackOpacity
            border
            {
                color : "grey"
                width : 1
            }
        }
        PathView
        {
            id : viewMin
            model : minModel
            anchors.fill: parent
            pathItemCount: 12
            delegate : min_del
            path : circle_path
        }
    }


    Component
    {
        id : hour_del
        Item
        {
            id : hour_item
            property bool currentHour : PathView.isCurrentItem;
            onCurrentHourChanged:
            {
                if (currentHour)
                {
                    HourLogic.setHour(hour_val_txt.text);
                    updateTimeInf();
                }
            }
            width : tepee.mobileRes / 2
            height : tepee.mobileRes / 2
            opacity : PathView.isCurrentItem ? 1 : 0.8
            scale : hour_del_ma.pressed ? (PathView.isCurrentItem ? 1.4 : 0.9) : (PathView.isCurrentItem ? 1.6 : 1.0)
            z: y
            Rectangle
            {
                anchors.fill: parent
                //                color : hour_item.PathView.isCurrentItem ? "red" : "green"
                gradient : hour_item.PathView.isCurrentItem ? qt_green_grad : blue_black_grad
                opacity : 0.6
                radius : 360
                smooth : true
                border
                {
                    color : "grey"
                    width : (hour_item.PathView.isCurrentItem) ? 3 : 1
                }
            }
            Text
            {
                id : hour_val_txt
                anchors.centerIn: parent
                color : "white"
                font.pointSize: tepee.textSize
                text : (am_pm_selector.am ? hourVal : hourVal + 12);
            }
            MouseArea
            {
                id : hour_del_ma
                anchors.fill: parent
                onClicked:
                {
                    view.currentIndex = index;
                }
            }
        }
    }

    Component
    {
        id : min_del
        Item
        {
            id : min_item
            property bool currentMin : PathView.isCurrentItem;
            onCurrentMinChanged:
            {
                if (currentMin)
                {
                    HourLogic.setMinute(minVal);
                    updateTimeInf();
                }
            }
            width : tepee.mobileRes / 2
            height : tepee.mobileRes / 2
            opacity : PathView.isCurrentItem ? 1 : 0.8
            scale : min_del_ma.pressed ? (PathView.isCurrentItem ? 1.4 : 0.9) : (PathView.isCurrentItem ? 1.6 : 1.0)
            z: y
            Rectangle
            {
                anchors.fill: parent
                //                color : min_item.PathView.isCurrentItem ? "blue" : "orange"
                gradient : min_item.PathView.isCurrentItem ? qt_green_grad : blue_black_grad
                opacity : 0.6
                radius : 360
                smooth : true
                border
                {
                    color : "grey"
                    width : (min_item.PathView.isCurrentItem) ? 3 : 1
                }
            }
            Text
            {
                id : min_val_txt
                anchors.centerIn: parent
                color : "white"
                font.pointSize: tepee.textSize
                text : minVal
            }
            MouseArea
            {
                id : min_del_ma
                anchors.fill: parent
                onClicked:
                {
                    viewMin.currentIndex = index;
                }
            }
        }
    }

}
