//import QtQuick 1.1
import QtWebKit 1.0
 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5


Item
{
    id : setting_menu_item
    property int mobileView : tepee.mobileRes
    property string backGroundPath : tepee.backgroundImg;
    property real   syncProg : tepee.syncProg;

    width: main_win_rec.width - (2 * mobileView)
    height: main_win_rec.height - (2 * mobileView)
    y : mobileView
    x : mobileView

    onSyncProgChanged:
    {
        if (tepee.syncProg == 1.0)
            reloadInfoUser();
    }

    function    reloadInfoUser()
    {
        firstname.inputText = apCtrl.getUserFirstName();
        lastname.inputText = apCtrl.getUserLastName();
        cellnum.inputText = apCtrl.getUserCNum();
        homenum.inputText = apCtrl.getUserHNum();
        address.inputText = apCtrl.getUserAddress();
        email.inputText = apCtrl.getUserEmail();
        visibilitycheckbox.selected = apCtrl.getUserVisibility();
    }


    states:
        [
        State
        {
            name: "Synching"
            when: busyi.on
            PropertyChanges { target: contentRec; opacity: 0.5 }
        }
    ]

    Rectangle
    {
        id : contentRec
        Behavior on opacity {NumberAnimation { duration : 500 }}
        width: main_win_rec.width - (2 * mobileView)
        height: main_win_rec.height - (2 * mobileView)
        color : "transparent"
        Rectangle
        {
            anchors.fill : parent
            opacity : tepee.elemBackOpacity
            color : tepee.elemBackColor
            smooth : true
            radius : 45
            border.color : "grey"
            border.width : 2
        }

        ColorPicker
        {
            id : elem_color_picker
            anchors.fill: parent
            anchors.margins: tepee.mobileRes / 2
            opacity : 0;
            function clearColPick()
            {
                flickElemSettings.opacity = 1;
                elem_color_picker.opacity = 0;
            }

            onOkPressed:
            {
                clearColPick();
                tepee.elemBackColor = selectedColor;
                tepee.elemBackOpacity = selectedOpacity;
            }

            onCancelPressed:
            {
                clearColPick();
            }
        }

        BrowserLoader
        {
            id : fileBackSelectLoader
            filename_loader : "C:/Users/";
            filterSearch_loader: ["*.png", "*.jpg"];
            anchors.fill: parent;
            anchors.margins: tepee.mobileRes / 2
            cellHeight: tepee.mobileRes
            Behavior on opacity {NumberAnimation {duration : 500}}
            opacity: 0
            showPic : true
            onClearViewChanged: parent.clearBrowser(clearView);
            onSelectedNameChanged:
            {
                backGroundPath = selectedName;
                tepee.backgroundImg = backGroundPath;
                parent.clearBrowser(true);
            }
        }

        function    clearBrowser(clear)
        {
            if (clear)
            {
                flickElemSettings.opacity = 1;
                fileBackSelectLoader.opacity = 0;
                fileBackSelectLoader.source = "";
            }
        }

        Flickable
        {
            id : flickElemSettings
            anchors.fill: parent
            contentWidth : contentRec.width;
            contentHeight: contentRec.height + 800;
            flickableDirection: Flickable.VerticalFlick
            Behavior on opacity {NumberAnimation {duration : 500}}
            //        boundsBehavior: Flickable.StopAtBounds
            clip : true
            Text
            {
                id : titleSet
                text : "Settings"
                anchors.top : parent.top
                anchors.horizontalCenter : parent.horizontalCenter
                anchors.topMargin: 10
                color : "white"
                font.pointSize: (mobileView == 139) ? 35 : (mobileView == 80) ? 18 : 10
            }

            TextBox
            {
                id : userNameBox
                titleText : "Username :    "
                width : parent.width / 5
                inputText : apCtrl.getUsername()
                mobileView : setting_menu_item.mobileView
                anchors.top : titleSet.bottom
                anchors.topMargin: 15
                anchors.left :parent.left
                anchors.leftMargin : tepee.mobileRes / 4
            }

            TextBox
            {
                width : parent.width / 5
                id : passwdBox
                titleText : "Password :    "
                inputText : apCtrl.getpassword()
                mobileView : setting_menu_item.mobileView
                anchors.top : titleSet.bottom
                anchors.topMargin: 15
                passwordChar : true
                x : parent.width / 2 + tepee.mobileRes / 3

            }

            TextBox
            {
                width : parent.width / 5
                id : serverAddr
                titleText : "Host Address :"
                inputText : apCtrl.getAdress()
                mobileView : setting_menu_item.mobileView
                anchors.top : userNameBox.bottom
                anchors.topMargin: 15
                anchors.left :parent.left
                anchors.leftMargin : tepee.mobileRes / 4
            }

            TextBox
            {
                id : serverPort
                width : contentRec.width / 5
                titleText : "Server Port : "
                inputText : apCtrl.getPort()
                mobileView : setting_menu_item.mobileView
                anchors.top : userNameBox.bottom
                anchors.topMargin: 15
                anchors.left: passwdBox.left
            }
            TextBox
            {
                id : firstname
                width : contentRec.width / 5
                titleText : "FirstName :   "
                inputText : apCtrl.getUserFirstName();
                mobileView : setting_menu_item.mobileView
                anchors.top : background_select_rec.bottom
                anchors.topMargin : tepee.mobileRes
                anchors.left: serverAddr.left
            }
            TextBox
            {
                id : lastname
                width : contentRec.width / 5
                titleText : "LastName :    "
                inputText : apCtrl.getUserLastName();
                mobileView : setting_menu_item.mobileView
                anchors.top : firstname.top
                anchors.left: passwdBox.left
            }


            TextBox
            {
                id : homenum
                width : contentRec.width / 5
                titleText : "Home Number : "
                inputText : apCtrl.getUserHNum();
                mobileView : setting_menu_item.mobileView
                anchors.top : firstname.bottom
                anchors.topMargin: 15
                anchors.left: serverAddr.left
            }
            TextBox
            {
                id : cellnum
                width : contentRec.width / 5
                titleText : "Cell Number : "
                inputText : apCtrl.getUserCNum();
                mobileView : setting_menu_item.mobileView
                anchors.top : firstname.bottom
                anchors.topMargin: 15
                anchors.left: passwdBox.left
            }
            TextBox
            {
                id : email
                width : contentRec.width / 4
                titleText : "Email :       "
                inputText : apCtrl.getUserEmail();
                mobileView : setting_menu_item.mobileView
                anchors.top : cellnum.bottom
                anchors.topMargin: 15
                anchors.left: serverAddr.left
            }
            TextBox
            {
                id : address
                width : contentRec.width / 2
                titleText : "Address :     "
                inputText : apCtrl.getUserAddress();
                mobileView : setting_menu_item.mobileView
                anchors.top : email.bottom
                anchors.topMargin: 15
                anchors.left: serverAddr.left
            }
            Text
            {
                id : visibilityText;
                text : "Public Visibility : "
                color : "white"
                font.pointSize: tepee.textSize
                anchors
                {
                    top : cellnum.bottom
                    topMargin : 15
                    left : cellnum.left
                }
            }
            CheckBox
            {
                id : visibilitycheckbox
                width :  (tepee.screenSize === "large") ? tepee.mobileRes / 3 : tepee.mobileRes / 2
                height : width
                selected: apCtrl.getUserVisibility();
                anchors
                {
                    verticalCenter : visibilityText.verticalCenter
                    left : visibilityText.right
                    leftMargin : tepee.mobileRes / 4
                }
            }

            Button
            {
                id : syncButton; buttonColor: "green"; buttonShape: "round"
                numId: 1;
                text: "Sync";
                resImg: mobileView;
                clickActionState: ""
                anchors
                {
                    horizontalCenter : parent.horizontalCenter
                    top : serverAddr.bottom
                    topMargin : tepee.mobileRes
                }

                onButtonClicked:
                {
                    console.log("SYNC PRESSED");
                    //                    sync_page_load.source = "syncPage.qml";
                    apCtrl.syncWithServer();
                }
                opacity : 1
            }

            Rectangle
            {
                id : background_select_rec
                scale : back_select_ma.pressed ? 0.9 : 1.0
                anchors
                {
                    top : serverAddr.bottom
                    right : parent.right
                    margins : tepee.mobileRes
                }
                width : parent.width / 5
                height : parent.width / 5
                radius : 15
                color : "transparent"
                border
                {
                    color : "grey"
                    width : 8
                }

                Image {
                    id: back_img_prev
                    anchors.fill: parent
                    source: backGroundPath
                }
                Text
                {
                    anchors.centerIn: parent
                    color :  "white"
                    text: "BackGround Picture"
                    font.pointSize: tepee.textSize
                }
                MouseArea
                {
                    id : back_select_ma
                    anchors.fill: parent
                    onClicked:
                    {
                        flickElemSettings.opacity = 0;
                        fileBackSelectLoader.clearView = false;
                        fileBackSelectLoader.source = "FileBrowser.qml";
                        fileBackSelectLoader.opacity = 1;
                    }
                }
            }

            Rectangle
            {
                width : tepee.mobileRes
                height : tepee.mobileRes
                color : tepee.elemBackColor
                scale : color_rec_ma.pressed ? 0.9 : 1
                anchors
                {
                    verticalCenter : background_select_rec.verticalCenter
                    left : parent.left
                    leftMargin : tepee.mobileRes
                }
                radius : 15
                border
                {
                    width : 2
                    color : "grey"
                }

                MouseArea
                {
                    id : color_rec_ma
                    anchors.fill: parent
                    onClicked:
                    {
                        flickElemSettings.opacity = 0;
                        elem_color_picker.opacity = 1;
                    }
                }
            }

            Button
            {
                id : buttonApplySet; buttonColor: "blue"; buttonShape: "rectangle"
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.top : address.bottom
                anchors.topMargin : tepee.mobileRes
                numId: 1;
                text: "Apply";
                resImg: mobileView;
                clickActionState: ""
                onButtonClicked:
                {
                    main_win_rec.username = userNameBox.inputText;
                    main_win_rec.passwd = passwdBox.inputText;
                    apCtrl.deleteWeatherLocationFromListView();
                    apCtrl.setServerSetting(userNameBox.inputText, passwdBox.inputText, serverAddr.inputText, serverPort.inputText, backGroundPath, tepee.elemBackColor, tepee.elemBackOpacity);
                    apCtrl.setInfoUser(firstname.inputText, lastname.inputText, homenum.inputText, cellnum.inputText, email.inputText, address.inputText, visibilitycheckbox.selected);
                }
                opacity : 1
            }
        }

        ScrollBar
        {
            id: verticalScrollBar
            width: 12; height: flickElemSettings.height - 12
            anchors.right: flickElemSettings.right
            opacity: 0
            orientation: Qt.Vertical
            position: flickElemSettings.visibleArea.yPosition
            pageSize: flickElemSettings.visibleArea.heightRatio
        }

        states:
            [
            State
            {
                name: "ShowBars"
                when: flickElemSettings.movingVertically
                PropertyChanges { target: verticalScrollBar; opacity: 1 }
            }
        ]
    }

    BusyIndicator
    {
        anchors.centerIn: parent
        width : tepee.mobileRes * 2
        height : width
        id : busyi
        on : (syncProg < 1.0) ? true : false;
    }

    Loader
    {
        id : sync_page_load
        anchors.fill: parent
    }
}


