 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtQuick 1.1
import "ContactSearchRequest.js" as ContactSearch

Item
{
    id : search_box_item
    property bool   querying : false;
    property alias  inText : textInput.text

    signal contactSelected(string username, string firstname, string lastname, string email, string cnum, string hnum, string addr);
    signal backPressed();
    // INPUT BAR
    Item
    {
        id : search_bar_item
//        height : tepee.mobileRes
        height : (tepee.screenSize == "large") ? 55 : (tepee.screenSize == "medium") ? 50 : 35
        anchors
        {
            top : parent.top
            left : parent.left
            right : parent.right
            rightMargin : 2 * tepee.mobileRes
            leftMargin : 2 * tepee.mobileRes
            topMargin : tepee.mobileRes / 2
        }

        Rectangle
        {
            id : search_rec
            radius : 5
            color : "white"
            smooth : true
            opacity : 0.4
            border
            {
                width : 2
                color : "black"
            }

            anchors
            {
                fill : parent
            }
        }

        // VALIDATE BUTTOn
        Rectangle
        {
            Image
            {
                id : validate_contact_img
                anchors.centerIn: parent
                source: "ui_svg/search.png";
                smooth: true
                scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
            }
            color : "transparent"
            scale : validate_ma.pressed ? 0.9 : 1
            width : tepee.mobileRes / 2
            anchors
            {
                right : search_rec.right
                top : search_rec.top
                bottom : search_rec.bottom
            }
            MouseArea
            {
                id : validate_ma
                anchors.fill: parent
                onClicked:
                {
                    textInput.accepted();
                }
            }
        }


        TextInput
        {
            id : textInput
            anchors.centerIn: search_rec
            text: "Search Here"
            color : "white"
            font.pointSize: tepee.textSize
            onAccepted:
            {
                ContactSearch.searchContact(textInput.text, searchBoxResultModel, search_box_item)
                querying = true;
            }
        }
    }

    BusyIndicator
    {
        anchors.centerIn: parent
        width : tepee.mobileRes * 2
        height : width
        id : busyi
        on : querying;
    }

    // RESULT LIST MODEL WHICH HAS TO BE FILLED BY THE RESULT OF WAHT IS SEARCHED
    ListModel
    {
        id : searchBoxResultModel
    }

    Item
    {
        id : result_item
        Behavior on opacity {NumberAnimation {duration : 500}}
        anchors
        {
            top : search_bar_item.bottom
            left : parent.left
            right : parent.right
            bottom : parent.bottom
            leftMargin : tepee.mobileRes
            rightMargin : tepee.mobileRes
            topMargin : tepee.mobileRes / 2
            bottomMargin : tepee.mobileRes / 2
        }

        states:
            [
            State
            {
                name: "Synching"
                when: busyi.on
                PropertyChanges { target: result_item; opacity: 0.5 }
            }
        ]

        Rectangle
        {
            id : result_rec
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
            anchors.fill: parent
        }

        Button
        {
            anchors.top : result_rec.bottom
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.topMargin:  - tepee.mobileRes / 2
            buttonColor: "blue"
            buttonShape: "round"
            resImg: tepee.mobileRes
            numId : 136
            text : "Back"
            opacity : 1
            onButtonClicked:
            {
                backPressed();
            }
        }

        ListView
        {
            id : result_search_listview
            anchors.fill : result_rec
            clip : true
            model : searchBoxResultModel
            delegate: result_component
            spacing : tepee.mobileRes / 16
            highlight: highlight_result
        }
    }

    Component
    {
        id : result_component
        Item
        {
            height : tepee.mobileRes / 2
            width : parent.width
            scale : result_c_ma.pressed ? 0.9 : 1
            Rectangle
            {
                anchors.fill: parent
                radius : 15
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
            }
            MouseArea
            {
                id : result_c_ma
                anchors.fill: parent
                onClicked:
                {
                    contactSelected(username, firstname, lastname, mail, cellphone, homephone, adress);
                }
            }

            Text
            {
                anchors.centerIn: parent
                color : "white"
                font.pointSize: tepee.textSize
                text : firstname + " " + lastname
            }
        }
    }
    Component
    {
        id : highlight_result
        Rectangle
        {
            height : tepee.mobileRes / 2
            width : width
            opacity : 0.4
            radius : 15
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
        }
    }


}
