#include <iostream>
#include <QtGui/QApplication>
//#include <QGLWidget>
#include <QWidget>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <QObject>
#include <QDesktopWidget>
#include <QGraphicsObject>
#include <QRect>
#include <QCoreApplication>
#include <QMessageBox>
#include "qmlapplicationviewer.h"
//#include <QContactManager>
//#include <QContact>
#include "appcontroler.h"
#include "webpreviewelem.h"

//FOR SYMBIAN ONLY INCLUDE QtQuick 1.0 OTHERWISE IT WON'T WORK ON THE DEVICE


Q_DECL_EXPORT int main(int argc, char *argv[])
{
    std::cout << "main 0"<< std::endl;
    //#ifdef Q_WS_MAEMO_5
    //    QApplication::setGraphicsSystem("native");
    //#else
    QApplication::setGraphicsSystem("raster"); // BEST RENDERING OVERALL FOR ALL PLATEFORMS (OPENGL A BIT BETTER ON WINDOWS)
    //  QApplication::setGraphicsSystem("opengl"); // use this but for simulator doesn't work
    //#endif


    QApplication         app(argc, argv);
    QmlApplicationViewer view; //SAME AS QDECLARATIVEVIEW BUT ALLOW ORIENTATION LOCK
    view.setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape); //lock orientation in landscape
    QDeclarativeContext *ctx;
    QDesktopWidget      *my_desktop;
    QObject             *object;
    AppControler         Ap;


    std::cout << "main 1"<< std::endl;
    view.setAttribute(Qt::WA_NoSystemBackground);
    std::cout << "main 2"<< std::endl;
    ctx = view.rootContext();
    std::cout << "main 3"<< std::endl;
    ctx->setContextProperty("apCtrl", &Ap);
    std::cout << "main 4"<< std::endl;
    //AJOUTER CHAQUE MODEL DE DONNER AU CONTEXT POUR Y AVOIR ACCES EN QML
    // MODEL FILE FTP
    ctx->setContextProperty("fileftpModel", Ap.getfileftpMod());
    std::cout << "main 5"<< std::endl;
    // MODEL WEATHER
    ctx->setContextProperty("weatherModel", Ap.getweatherMod());
    ctx->setContextProperty("weatherLocationModel", Ap.getweatherLocationMod());
    // MODEL DE NOTES
    ctx->setContextProperty("noteModel", Ap.getClientNotes());
    // MODEL DE BOOKMARKS
    ctx->setContextProperty("bookmarkModel", Ap.getBookMarksMod());
    // MODEL FOR TASK OF WEEK
    ctx->setContextProperty("weekTaskModel", Ap.getWeekTaskModel());
    // MODEL FOR CURRENT TASK
    ctx->setContextProperty("taskModel", Ap.getTaskModel());
    // MODEL FOR CONTACTS
//    ListModel*t = Ap.getContactsMod();
    ctx->setContextProperty("contactModel", Ap.getContactsMod());
//    ctx->setContextProperty("contactModel2", t);

    // MODEL FOR EVENT
    ctx->setContextProperty("eventModel", Ap.getEventModel());


    // REGISTER TYPE OF WEBPREVIEW ELEM TO BE IMPORTED IN QML
    qmlRegisterType<ThumbnailLoader>("webthumbnail", 1, 0, "WebThumbnailLoader");
    qmlRegisterType<webPreviewElem>("webthumbnail", 1, 0, "WebThumbnail");

    view.setSource(QUrl(QLatin1String("qrc:/qml/tepee/main.qml")));
    object = view.rootObject();

    //PERFORMANCE SHOULD IMPROVE ON MAEMO BUT NOT SATISFYING
    //    #ifdef Q_WS_MAEMO_5
    //        QGLFormat format =  QGLFormat::defaultFormat();
    //        format.setSampleBuffers(false);
    //        QGLWidget *glWidget = new QGLWidget(format);
    //        glWidget->setAutoFillBackground(false);
    //        view.setViewport(glWidget);
    //    #endif
    my_desktop = QApplication::desktop();

    object->setProperty("width", my_desktop->screenGeometry(-1).width());
    object->setProperty("height", my_desktop->screenGeometry(-1).height());

    QObject::connect(&Ap, SIGNAL(synchingProgress(QVariant)), object, SLOT(synchingProgress(QVariant)));
    QObject::connect((QObject*)view.engine(), SIGNAL(quit()), &app, SLOT(quit()));
    Ap.initDBLoading(); // LOAD DATA FRON DATABASE
    view.show();
    view.showFullScreen();
    return app.exec();
}
