#ifndef FILELOGIC_H
#define FILELOGIC_H
#include <QString>
#include <QHostAddress>
#include <QFtp>
#include "listmodel.h"
#include <iostream>
#include <QObject>
#include <QList>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QFile>
#include <QDir>

class FileRcvElem : public ListItem
{
    Q_OBJECT
public :
    enum FileRoles
    {
        namefileRole = Qt::UserRole + 1,
        sizefileRole,
        luRole,
        filercvIdRole
    };
    FileRcvElem(QObject *p = 0);
    FileRcvElem(QString name, qint64 size, QDateTime , QObject *parent = 0);

    // INHEITED METHODES
    int id() const;
    QVariant data(int role) const;
    QHash<int, QByteArray> roleNames() const;
    //////////////////////////////////////////

    QString getfilename() const;
    qint64 getsizefile() const;
    QDateTime getlu() const;
    int getfilercvId()const;

private :
    static int nextId;

    int filercvId;
    QDateTime lu;
    QString filename;
    qint64 sizefile;
};

class Filelogic : public QObject
{
    Q_OBJECT
private:
    QFtp *ftp;
    ListModel   *filercvMod;
    QFile *file;
    QString DirFtp;
public:
    Filelogic();
    void connectToFtp(QString , QString, QUrl);
    ListModel* getfileftpMod();
    void dowloadFile(QString name);
    void delFile(QString name, int id);
    QString getDirFtp();
    void uploadFile(QString);
    void listFile();
public slots:
    void rcvStateChange(int);
    void endCommand(bool);
    void startCommand(int);
    void listinfoaff( const QUrlInfo & i);
    void datatransaff(qint64 done,qint64 total);
signals:
   void dataProgress(qint64,qint64);

};

#endif // FILELOGIC_H
