#ifndef EVENTLOGIC_H
#define EVENTLOGIC_H

#include <QObject>
#include <QVariant>
#include <QDateTime>
#include <QStringList>
#include <QSqlRecord>
#include "listmodel.h"
#include "contactlogic.h"

class eventElem : public ListItem
{
    Q_OBJECT

signals :
    void SendQueryEvent(QString, int);

    public:
        enum    EventRoles
        {
            titleEvent = Qt::UserRole + 1,
            descriptionEvent,
            countryEvent,
            cityEvent,
            dateEvent,
            hourEvent,
            creatorFNameEvent,
            creatorLNameEvent,
            contactsEvent,
            idEvent
        };


        eventElem(QObject *p = 0);
        eventElem(QString title, QString description, QString country, QString city,
                  QString date, QString hour, QString creatorFName, QString creatorLName,
                  QString contactList, QString idTime);

        int         id() const;
        QVariant    data(int role) const;
        QHash<int, QByteArray>  roleNames() const;

        QString     getEventContacts() const;
        QString     getEventCountry() const;
        QString     getEventCity() const;
        QString     getEventDescription() const;
        QString     getEventTitle() const;
        QString     getEventDate() const;
        QString     getEventHour() const;
        QString     getEventIdTime() const;
        QString     getEventCreatorFName() const;
        QString     getEventCreatorLName() const;


        void        setEventTitle(QString);
        void        setEventDescription(QString);
        void        setEventCountry(QString);
        void        setEventCity(QString);
        void        setEventHour(QString);
        void        setEventDate(QString);
        void        setEventCreatorLName(QString);
        void        setEventCreatorFName(QString);
        void        setEventContactList(QString);

    private :
        int         eventId;
        static      int nextId;

        QString     country;
        QString     city;
        QString     description;
        QString     title;
        QString     date;
        QString     hour;
        QString     idTime;
        QString     creatorFName;
        QString     creatorLName;
        QString     contacts;
};

class eventLogic : public QObject
{
Q_OBJECT
signals:
    void    SendQueryEvent(QString query, int);
private :
    ListModel   *eventModel;

public :
    eventLogic(QObject *p = 0);
    ListModel   *getEventModel();
    void        addEvent(QString title, QString description, QString country, QString city,
                         QString date, QString hour, QString creatorFName, QString creatorLName,
                         QString contactList);
    void        editEvent(QString title, QString description, QString country, QString city,
                          QString date, QString hour, QString creatorFName, QString creatorLName,
                          QString contactList, int id);
    void        rmEvent(int id);
    void        loadEventsFromDB();
public  slots :
    void        rcvEvent(QList<QSqlRecord>, int);
};

#endif // EVENTLOGIC_H
