#ifndef CONTACTLOGIC_H
#define CONTACTLOGIC_H

#include <QDateTime>
#include "listmodel.h"
#include <QSqlRecord>
#include "Description.h"
#include <sstream>
#include <iostream>

class ContactElem : public ListItem
{
    Q_OBJECT
public :
    enum ContactRoles
    {
        contactRFName = Qt::UserRole + 1,
        contactRLName,
        contactREmail,
        contactRAddress,
        contactRNumberHome,
        contactRNumberCell,
        contactRImgSrc,
        contactRBirthDay,
        contactRFriend,
        contactRId,
        contactUsername
    };

    ContactElem(QObject *p = 0);
    ContactElem(QString tId, QString fname, QString lname, QString email = "",
                QString addr_ = "", QString hnum = "", QString cnum = "",
                QString img = "", QDate b = QDate::currentDate(), bool f = false, QString username = "",  QObject *p = 0);

    //INHERITED METHODS
    int     id() const;
    QVariant    data(int role) const;
    QHash<int, QByteArray> roleNames() const;

    QDate   getBirthDay() const;
    QString getFirstName() const;
    QString getLastName() const;
    QString getAddr()     const;
    QString getEmailAddr()  const;
    QString getHomeNum()    const;
    QString getCellNum()    const;
    QString getImgSrc()     const;
    QString getTimeId()     const;
    QString getUsername()   const;
    bool    getFriend()     const;

    void    setBirthDay(QDate a);
    void    setFirstName(QString s);
    void    setLastName(QString s);
    void    setEmailAddr(QString s);
    void    setHomeNum(QString s);
    void    setCellNum(QString s);
    void    setAddr(QString s);
    void    setImgSrc(QString s);
    void    setFriend(bool);
    void    setUserName(QString s);

private :
    QDate   birthDay;
    QString firstname;
    QString lastname;
    QString email_addr;
    QString addr;
    QString homeNum;
    QString cellNum;
    QString imgSrc;
    QString IdTime;
    QString userName;
    bool    Friend;
    int     cId;
    bool    isFriend;
    static  int nextId;
};

class ContactLogic : public QObject
{
    Q_OBJECT
    ListModel   *contactMod;
public:
    ContactLogic();
    ListModel*  getContactModel();
    bool        addContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, bool fr, QString uc);
    void        editContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, int id);
    void        removeContact(int id);
    void LoadContactfromDB();
signals :
       void SendQueryContact(QString query, int);
public slots:
    void rcvContact(QList<QSqlRecord> q, int i);

};

#endif // CONTACTLOGIC_H
