#include "contactlogic.h"
//#include <QContactManager>

int ContactElem::nextId = 0;

ContactElem::ContactElem(QObject *p) : ListItem(p)
{
    this->cId = ContactElem::nextId++;
}

ContactElem::ContactElem(QString idT, QString fname, QString lname, QString email, QString addr_, QString hnum,
                         QString cnum, QString img, QDate b, bool f, QString username, QObject *p) : ListItem(p)
{
    this->cId = ContactElem::nextId++;
    this->setFirstName(fname);
    this->setLastName(lname);
    this->setEmailAddr(email);
    this->setAddr(addr_);
    this->setHomeNum(hnum);
    this->setCellNum(cnum);
    this->setImgSrc(img);
    this->setBirthDay(b);
    this->setFriend(f);
    this->setUserName(username);
    this->IdTime = idT;
}

int     ContactElem::id()const
{
    return this->cId;
}

QVariant ContactElem::data(int role) const
{
    switch(role)
    {
    case contactRFName :
        return this->getFirstName();
    case contactRLName :
        return this->getLastName();
    case contactREmail :
        return this->getEmailAddr();
    case contactRAddress :
        return this->getAddr();
    case contactRNumberHome :
        return this->getHomeNum();
    case contactRNumberCell :
        return this->getCellNum();
    case contactRImgSrc :
        return this->getImgSrc();
    case contactRBirthDay :
        return this->getBirthDay();
    case contactRFriend :
        return this->getFriend();
    case contactRId :
        return this->id();
    case contactUsername :
        return this->getUsername();
    default : return QVariant();
    }
}

QHash<int, QByteArray>  ContactElem::roleNames() const
{
    QHash<int, QByteArray> roles;
    roles[contactRFName] = "contact_firstname";
    roles[contactRLName] = "contact_lastname";
    roles[contactREmail] = "contact_email";
    roles[contactRAddress] = "contact_address";
    roles[contactRNumberHome] = "contact_homenumber";
    roles[contactRNumberCell] = "contact_cellnumber";
    roles[contactRImgSrc] = "contact_imgsrc";
    roles[contactRBirthDay] = "contact_birthday";
    roles[contactRId] = "contact_id";
    roles[contactRFriend] = "contact_friend";
    roles[contactUsername] = "contact_username";
    return roles;
}

QDate       ContactElem::getBirthDay() const
{
    return this->birthDay;
}

QString     ContactElem::getTimeId() const
{
    return this->IdTime;
}

QString     ContactElem::getFirstName() const
{
    return this->firstname;
}

QString     ContactElem::getLastName() const
{
    return this->lastname;
}

QString     ContactElem::getAddr() const
{
    return this->addr;
}

QString     ContactElem::getEmailAddr() const
{
    return this->email_addr;
}

QString     ContactElem::getHomeNum() const
{
    return this->homeNum;
}

QString     ContactElem::getCellNum() const
{
    return this->cellNum;
}

QString     ContactElem::getImgSrc() const
{
    return this->imgSrc;
}

QString     ContactElem::getUsername() const
{
    return this->userName;
}

bool    ContactElem::getFriend() const
{
    return this->isFriend;
}

void        ContactElem::setBirthDay(QDate a)
{
    this->birthDay = a;
}

void        ContactElem::setFirstName(QString s)
{
    this->firstname = s;
}

void        ContactElem::setLastName(QString s)
{
    this->lastname = s;
}

void        ContactElem::setAddr(QString s)
{
    this->addr = s;
}

void        ContactElem::setEmailAddr(QString s)
{
    this->email_addr = s;
}

void        ContactElem::setHomeNum(QString s)
{
    this->homeNum = s;
}

void        ContactElem::setCellNum(QString s)
{
    this->cellNum = s;
}

void        ContactElem::setImgSrc(QString s)
{
    this->imgSrc = s;
}

void        ContactElem::setFriend(bool s)
{
    this->isFriend = s;
}

void        ContactElem::setUserName(QString s)
{
    this->userName =  s;
}

ContactLogic::ContactLogic() : QObject()
{
    this->contactMod = new ListModel(new ContactElem());
}

ListModel*  ContactLogic::getContactModel()
{
    return this->contactMod;
}


void ContactLogic::rcvContact(QList<QSqlRecord> q, int i)
{
    if (i == FILLCONTACT)
    {
        this->contactMod->removeRows(0, this->contactMod->rowCount());
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        while (it != q.end())
        {
            bool friendstatus;
            if ((*it).value("friend").toInt() == FRIEND)
            {
                friendstatus = true;
                std::cout <<"LOGIC CONTAT FRIENDSTATUS TRUE" << std::endl;
            }
            else
            {
                friendstatus = false;
                std::cout <<"LOGIC CONTAT FRIENDSTATUS FALSE" << std::endl;
            }
            if ((*it).value("status").toInt() != DEL)
                this->contactMod->appendRow(new ContactElem((*it).value("id").toString(), (*it).value("firstname").toString().toStdString().c_str(),
                                                            (*it).value("lastname").toString().toStdString().c_str(),
                                                            (*it).value("email").toString().toStdString().c_str(),
                                                            (*it).value("adress").toString().toStdString().c_str(),
                                                            (*it).value("homephone").toString().toStdString().c_str(),
                                                            (*it).value("cellphone").toString().toStdString().c_str(),
                                                            (*it).value("imgsrc").toString().toStdString().c_str(),
                                                            QDate::fromString((*it).value("birthday").toString(), "dd/MM/yyyy"), friendstatus, (*it).value("usernamecontact").toString(), this->contactMod));
            ++it;
        }
    }
}

void ContactLogic::LoadContactfromDB()
{

    QString t = "SELECT * FROM contact";
    emit(SendQueryContact(t, FILLCONTACT));
}

bool        ContactLogic::addContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, bool fr, QString uc)
{
    if (f.isEmpty() || l.isEmpty())
        return false;
    QString curTime = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");

    this->contactMod->appendRow(new ContactElem(curTime, f, l, e, a, h, c, i, d, fr, uc));
    QString query;
    query = "INSERT INTO contact (id, lastup, firstname, lastname, email, adress, homephone, cellphone, imgsrc, birthday, status, friend, usernamecontact) VALUES ('";
    query += curTime;
    query += "', '";
    query += curTime;
    query += "', '";
    query += f.toStdString().c_str();
    query += "', '";
    query += l.toStdString().c_str();
    query += "', '";
    query += e.toStdString().c_str();
    query += "', '";
    query += a.toStdString().c_str();
    query += "', '";
    query += h.toStdString().c_str();
    query += "', '";
    query += c.toStdString().c_str();
    query += "', '";
    query += i.toStdString().c_str();
    query += "', '";
    query += d.toString("dd/MM/yyyy");
    query += "', ";
    query += QString::number(MODIF);
    query += ", ";
    if (fr)
        query += QString::number(FRIEND);
    else
        query += QString::number(NOTFRIEND);

    query += ", '";
    query += uc;
    query += "');";
    emit (SendQueryContact(query, SETCONTACT));
    return true;
}

void        ContactLogic::editContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, int id)
{
    if (f.isEmpty() || l.isEmpty())
        return ;
    ContactElem *C = (ContactElem *)this->contactMod->find(id);
    if (C != NULL)
    {
        QString query;
        query = "UPDATE contact SET firstname ='";
        query+= f;
        query += "' , lastname = '";
        query +=  l;
        query += "' , lastup = '";
        query +=  QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "' , email = '";
        query +=  e;
        query += "' , adress= '";
        query +=  a;
        query += "' , homephone = '";
        query +=  h;
        query += "' , cellphone = '";
        query +=  c;
        query += "' , imgsrc = '";
        query +=  i;
        query += "' , birthday = '";
        query +=  d.toString("dd/mm/yyyy");
        query += "', status = ";
        query += QString::number(MODIF);
        query += " WHERE id = '";
        query += C->getTimeId();
        query += "' AND status != ";
        query += QString::number(DEL);
        emit (SendQueryContact(query, SETCONTACT));
        C->setFirstName(f);
        C->setLastName(l);
        C->setEmailAddr(e);
        C->setAddr(a);
        C->setHomeNum(h);
        C->setCellNum(c);
        C->setImgSrc(i);
        C->setBirthDay(d);
        this->contactMod->updateModelFromElem(C);
    }
}

void        ContactLogic::removeContact(int id)
{
    ListItem    *c = this->contactMod->find(id);
    if (c == NULL)
        return ;
    int row = this->contactMod->getRowFromItem(c);
    if (row > -1)
    {
        QString query;
        ContactElem *C = (ContactElem *)c;
        query = "UPDATE contact SET status =";
        query+= QString::number(DEL);
        query += ", lastup ='";
        query +=  QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "' WHERE id = '";
        query += C->getTimeId();
        query += "'";
        emit (SendQueryContact(query, SETCONTACT));
        this->contactMod->removeRow(row);
    }
}
