#include "CircularBuff.h"
#include <iostream>

CircularBuff::CircularBuff()
{
	this->beg = 0;
	this->end = 0;
	memset(this->buff, 0, CIRC_BUFF_SIZE);
}

CircularBuff::~CircularBuff()
{

}

void CircularBuff::addToBuff(unsigned char *s, size_t len)
{
	size_t i = 0;
	size_t idx = this->end;

	//  std::cout << "SIZE ----------------> " << sizeof(*s) / sizeof(unsigned char) << " " << len << std::endl;

	//std::cout << "Adding to Buff [CircularBuff::addToBuff] deb = " << this->beg << " end = " << this->end;
	while (i < len)
	{
		this->buff[idx] = s[i];
		i++;
		idx++;
		idx %= CIRC_BUFF_SIZE;
	}
	this->end = idx;
	//std::cout << " ---> deb = " << this->beg << " end = " << this->end << std::endl;
}

int CircularBuff::getSizeOfCurData()
{
	int diff = 0;

        (this->end >= this->beg) ? (diff = this->end - this->beg) :
		(diff = CIRC_BUFF_SIZE - this->beg + this->end);
	return (diff);
}

unsigned char *CircularBuff::readFromBuff(int *size)
{
	unsigned char *cpy;
	size_t idx = this->beg;
	int i = 0;
	int diff;

        (this->end >= this->beg) ? (diff = this->end - this->beg) :
		(diff = CIRC_BUFF_SIZE - this->beg + this->end);

        if (diff == 0)
        {
                if (size != NULL)
                    *size = 0;
                //std::cout << "ON VA RETURN PQRCEQUE DIFF = 0" << std::endl;
                return (NULL);
        }
	// std::cout << "Reading From Buff diff = " << diff << std::endl;;
	cpy = new unsigned char [diff];
	//std::cout << "Reading From Buff [CircularBuff::readFromBuff] deb = " << this->beg << " end = " << this->end;
	while (i < diff)
	{
		cpy[i] = this->buff[idx];
		i++;
		idx++;
		idx %= CIRC_BUFF_SIZE;
	}
	//std::cout << " ---> deb = " << this->beg << " end = " << this->end << std::endl;
	//std::cout << "Reading From Buff i = " << i << std::endl;
	if (size != NULL)
		*size = i;
	return (cpy);
}

void CircularBuff::clearBuff(int offset)
{
    int i = 0;
    while (i < offset)
    {
        this->buff[this->beg] = 0;
        this->beg++;
	this->beg %= CIRC_BUFF_SIZE;
        i++;
    }
	//std::cout << "Clearing Buff [CircularBuff::clearBuff]" << std::endl;
}

