using GLib;
using Gtk;

public class Tear.Drawer : Tear.OvBox { // This is translation to Vala from libview, copyright of VMWare.

	public double goal;
	
	private double step;
	private uint period;
	private bool timer_pending;
	private uint timer_id;
   
	public signal void on_before_hide ();
	public signal void on_before_show ();
	public signal void on_hide ();
	public signal void on_show ();
   
    public Drawer ( string side ) {
        base.orientation = orientation;
    }
    
	construct {
		this.period = 10;
		this.step = 0.2;
		this.timer_pending = false;
	}
	
	public bool on_timer() {
		double fraction;
	
		fraction = this.get_fraction ();
	   /*
	    * Comparing double values with '==' is most of the time a bad idea, due to
	    * the inexact representation of values in binary (see
	    * http://www2.hursley.ibm.com/decimal/decifaq1.html and http://boost.org/libs/test/doc/components/test_tools/floating_point_comparison.html).
	    * But in this particular case it is legitimate. --hpreg
	    */
		if (this.goal == fraction) {
			this.timer_pending = false;
		  
			if (this.goal == 0)
				on_hide();
			else
				on_show();
		    return false;
		}
	
		this.set_fraction( this.goal > fraction ? double.min( fraction + this.step, this.goal ) : double.max ( fraction - this.step, this.goal ) );
		return true;
	}
	
	public void set_speed( uint period, double step) {
		return_if_fail( this != null );
	
		this.period = period;
		if (this.timer_pending) {
			Source.remove( this.timer_id );
			this.timer_id = Timeout.add( this.period, on_timer );
		}
		this.step = step;
	}
	
	public void set_goal ( double goal ) {
		return_if_fail( this != null );
		return_if_fail( goal >= 0 && goal <= 1 );
	
		if (goal == this.goal)
	   		return;
	
		if (goal == 0)
			on_before_hide();
		else
			on_before_show();
			
		this.goal = goal;
		if (this.timer_pending == false) {
			this.timer_id = Timeout.add( this.period, on_timer );
			this.timer_pending = true;
		}
	}

	public bool set_goal_bool () {
		double goal = 1;
		return_if_fail( this != null );
		return_if_fail( goal >= 0 && goal <= 1 );
 	
		if (goal == this.goal)
	   		return false;
	
		if (goal == 0)
			on_before_hide();
		else
			on_before_show();
			
		this.goal = goal;
		if (this.timer_pending == false) {
			this.timer_id = Timeout.add( this.period, on_timer );
			this.timer_pending = true;
		}
		return false;
	}

	public uint get_close_time() {
		return_val_if_fail ( this != null, 0 );
	
		return this.period * ((uint)(1 / this.step) + 1);
	}
	
}
