using GLib;
using DBus;
using Hildon;
using MCE;
using Gtk;
using Osso;

public class Tear.Service : GLib.Object {

	public bool oneinstance;
	public Osso.Context context;
	public DBus.RawConnection connection;
	public Tear.Server server;
	
#if FREMANTLE
	private DBus.Connection syscon;
	private dynamic DBus.Object mce;
#endif
	private DBus.RawError error;
	
	public string startup_uri { get; construct; }
	
    public Service (string uri = "") {
        this.startup_uri = uri;
    }

#if FREMANTLE
	public bool enable_accelerometer ( Gdk.Event event ) {
//		string orientation, stand, face;
//		int x, y, z;

		this.mce.req_accelerometer_enable += mce_handler; //( out orientation, out stand, out face, out x, out y, out z );
		
		return false;
	}
	
	public bool disable_accelerometer ( Gdk.Event event ) {
		this.mce.req_accelerometer_disable(); 
		
		return false;
	}

	public static void mce_handler ( /*Connection conn,*/ string orientation, string stand, string face, int x, int y, int z ) {
		
		PortraitFlags? flags = null; 
		
		var message = new MessageDialog(get_topmost_window(), DialogFlags.MODAL, MessageType.QUESTION, ButtonsType.OK, 
											   orientation);
		message.show();
		
		switch (orientation) {
			case ORIENTATION_PORTRAIT:
				flags = PortraitFlags.REQUEST | PortraitFlags.SUPPORT;
				break;
			case ORIENTATION_PORTRAIT_INVERTED:
				break;
			case ORIENTATION_LANDSCAPE:
				break;
			case ORIENTATION_LANDSCAPE_INVERTED:
				break;
		}
		
		Hildon.gtk_window_set_portrait_flags ( get_topmost_window(), flags );
	}
#endif

	construct {
		oneinstance = true;
		
		context = new Osso.Context(Config.PACKAGE, Config.VERSION, false, null);
		
        if (context.display_state_on () != Osso.Status.OK) 
            warning("Error: Osso Initialize failed.\n");

#if FREMANTLE 

//	    try {
//		    this.connection = context.get_sys_dbus_connection();
//			this.syscon = this.connection.get_g_connection();  
//			
//	        this.mce = this.syscon.get_object (SERVICE, SIGNAL_IF, SIGNAL_PATH);
//	        
//	        this.mce.sig_device_orientation_ind += mce_handler;
//	    } catch (DBus.Error e) {
////			var message = new MessageDialog.with_markup(get_topmost_window(), DialogFlags.MODAL, MessageType.QUESTION, ButtonsType.OK, 
////							   e.message);
////			message.run();
//	    }

#endif

	    try {
	        var conn = DBus.Bus.get( BusType.SESSION );
	        
			connection = DBus.RawBus.get( BusType.SESSION, ref error );
	
	        dynamic DBus.Object bus = conn.get_object ("org.freedesktop.DBus",
	                                                   "/org/freedesktop/DBus",
	                                                   "org.freedesktop.DBus");

			if (DEBUG)
	        	warning ( "Got on the Bus" );
	        
	        uint request_name_result = bus.RequestName ("com.nokia.Tear", (uint) 0);
	
	        if (request_name_result == DBus.RequestNameReply.PRIMARY_OWNER) {
				if (DEBUG)
					warning ( "Starting Server" );
				
	            server = new Tear.Server ();
	            conn.register_object ("/com/nokia/tear", server);
	
	        } else {        
				if (DEBUG)
					warning ( "Starting Client" );
				
	            dynamic DBus.Object server_object = conn.get_object ("com.nokia.Tear",
	                                                                 "/com/nokia/tear",
	                                                                 "com.nokia.Tear");
	
	            server_object.open_address ( (string) startup_uri );
	            oneinstance = false;
	        }
	    } catch (DBus.Error e) {
	        stderr.printf ("Oops: %s\n", e.message);
	    }
	}
}
