# License: This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

# credits 
# code: Tony Day

import pydrumbase
from pygame import *

keymap = []
for i in range(256):
    keymap.append([0])

keymap[ord('q')] = [0]
keymap[ord('w')] = [1]
keymap[ord('e')] = [2]
keymap[ord('r')] = [3]
keymap[ord('t')] = [4]
keymap[ord('y')] = [5]
keymap[ord('u')] = [6]

keymap[ord('a')] = [0]
keymap[ord('s')] = [0,1]
keymap[ord('d')] = [0,2]
keymap[ord('f')] = [0,3]
keymap[ord('g')] = [0,4]
keymap[ord('h')] = [0,5]
keymap[ord('j')] = [0,6]

keymap[ord('z')] = [0,1]
keymap[ord('x')] = [1]
keymap[ord('c')] = [1,2]
keymap[ord('v')] = [1,3]
keymap[ord('b')] = [1,4]
keymap[ord('n')] = [1,5]
keymap[ord('m')] = [1,6]


class PGKeyAudioEvent(pydrumbase.AudioEvent):

    internalqueue =[]
    def handleevent(self, event):
        if event.type == KEYDOWN:
            if event.key <= 255:
                self.internalqueue.extend(keymap[event.key]) 
            else:            
                self.internalqueue.append(0) 
            return True       
        return False

    def process(self):
        retsnds = self.internalqueue
        self.internalqueue =[]
        return retsnds
