#!/usr/bin/env python

# License: This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

# credits 
# code: Tony Day
# drumkit by Pbroks13 (Own work) [CC-BY-3.0 (www.creativecommons.org/licences/by/3.0)], via wikimedia Commons
# drum wavs downloaded from drumsamples.org (which is all the accrediation I have) 

import os, sys, pygame, math, random, ConfigParser
from pygame.locals import *
import gst
import struct
import gobject
import wave
import array
import Numeric
import threading
import time
import datetime
import pydrumbase

from pydrumaccel import *
from pydrumkeyboard import *
from pydrumscreen import *
from pydrummetronome import *
from pymixer import *
from pydrumsoundmanager import *

gobject.threads_init()

bpp=16
playsounds=True
numsoundgroups=7

def main():
    global drumsound
    global appdir
    appdir = sys.argv[0]
    appdir = os.path.dirname(appdir)
    appdir =os.path.abspath(appdir)
    print "PATH: " + appdir
    pygame.init()
    pygame.display.set_caption('Take it away Marco')

    pygame.mouse.set_visible(False)

#    flags=0 
    flags=FULLSCREEN
    screen=pygame.display.set_mode((800,480),flags,bpp)
    print pygame.display.get_driver()
    print pygame.display.get_surface()

    soundmanager = SoundManager(appdir+'/sounds')
    play(screen,soundmanager)

#def playsound (mixer, num):
#    mixer.playsound(num + (numsoundgroups*random.randrange(0,4)))             

def play(screen,mixer):
    global drumsound

    background = pygame.image.load(appdir + '/dsnn2.jpg')
    screen.blit(background,(0,20))
    for i in range(3):
        for j in range(numsoundgroups):
            pygame.draw.rect(screen, (127,127,200),(550+(80*i),5 +(70*j),70,60))    

    font = pygame.font.Font(None, 48)
    text = font.render('Accelerometer', True, (64,64,64), (0,0,0))        
    text.set_colorkey((0,0,0))
    textRect = text.get_rect(centerx=380,centery=30)
    screen.blit(text,textRect)

    pygame.display.flip()

    accelaudioevent = AccelAudioEvent()
    accelaudioevent.active = False

    pgkeyaudioevent = PGKeyAudioEvent()
    pgkeyaudioevent.active = True

    pgscreenpressaudioevent = PGScreenPressAudioEvent()
    pgscreenpressaudioevent.active = True

    maaudioevent = MNAudioEvent()
    maaudioevent.active=False

    mixer.init_audio()
    active=True
    playaccel=False
#    playaccel=True

    clock = pygame.time.Clock()
    cords1 = (0,0,0)
    cords2 = (0,0,0)
    audioevents =[
        accelaudioevent,
        pgkeyaudioevent,
        pgscreenpressaudioevent,
        maaudioevent]

    lastplayed=[0,0,0]
    run = 0

    tps = 200
    t1 = datetime.datetime.utcnow()
    while True:
        run +=1        
        clock.tick(tps)
 
        for event in pygame.event.get():

            for ae in audioevents:
                ae.handleevent(event)

            if event.type == QUIT:
                print str(t1.ctime())
                print str(datetime.datetime.utcnow().ctime())
                print "run " + str(run) + " times"               
                mixer.endgracefully                
                return False

            elif event.type == MOUSEBUTTONDOWN:
                if (event.pos[0] >= textRect.x):
                  if (event.pos[0] <= textRect.x +textRect.width):
                    if (event.pos[1] >= textRect.top ): 
                     if (event.pos[1] <= textRect.top + textRect.height):
                        playaccel= not playaccel
                        accelaudioevent.active = playaccel

                        if playaccel:
                            clr = (255,255,255)
                        else:
                            clr = (64,64,64)

                        font = pygame.font.Font(None, 48)
                        text = font.render('Accelerometer', True, clr, (0,0,0))        
                        text.set_colorkey((0,0,0))
                        textRect = text.get_rect(centerx=380,centery=30)
                        screen.blit(text,textRect)
                        pygame.display.flip()                    

            elif event.type == pygame.ACTIVEEVENT:
                print "Active changed"
                if active:
                    tps=10
                    mixer.pause()
                    active=False
                else:
                    tps=200
                    mixer.play()
                    active=False

        for ae in audioevents:
            if ae.active:
                playarray = ae.process()
                for j in range(len(playarray)):
                    mixer.playsound(playarray[j])
   
        mixer.process()


if __name__ == "__main__":
    main()