import pydrumbase
from pygame import *

keymap = []
for i in range(256):
    keymap.append([0])

keymap[ord('q')] = [0]
keymap[ord('w')] = [1]
keymap[ord('e')] = [2]
keymap[ord('r')] = [3]
keymap[ord('t')] = [4]
keymap[ord('y')] = [5]

keymap[ord('a')] = [0]
keymap[ord('s')] = [0,1]
keymap[ord('d')] = [0,2]
keymap[ord('f')] = [0,3]
keymap[ord('g')] = [0,4]
keymap[ord('h')] = [0,5]

keymap[ord('a')] = [0,1]
keymap[ord('s')] = [1]
keymap[ord('d')] = [1,2]
keymap[ord('f')] = [1,3]
keymap[ord('g')] = [1,4]
keymap[ord('h')] = [1,5]


class PGKeyAudioEvent(pydrumbase.AudioEvent):

    internalqueue =[]
    def handleevent(self, event):
        if event.type == KEYDOWN:
            if event.key <= 255:
                self.internalqueue.extend(keymap[event.key]) 
            else:            
                self.internalqueue.append(0) 
            return True       
        return False

    def process(self):
        retsnds = self.internalqueue
        self.internalqueue =[]
        return retsnds
