# License: This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

# credits 
# code: Tony Day

# unit for good (ish) realtime(ish) low-latency (ha-right) 
# sound streaming via python on the n900 (though code should work
# on other platforms - untested).


import os, sys, pygame, math, random, ConfigParser
from pygame.locals import *
import gst
import struct
import gobject
import wave
import array
import Numeric
import numpy
import threading
import time
import datetime


class AudioMixer():
# These can be adjusted before a call to init_audio
    sendsperreq=1
    nullss=256
    sendsize=nullss
    minlatency=0
    maxlatency=8
    stepsamples=1
    rate=22050
    numsources=8

    lock=threading.Lock()
    soundbuffers=[]
    soundqueue=[]
    
    class Channel(): 
        def __init__(self, parent, id):
            self.id = id
            self.parent = parent

        def need_data(self,src,length):
            for i in range(self.parent.sendsperreq):            
                self.parent.need_data(src,length,self.id)
    
    def __init__(self):
        pass

    def addwavs():
        pass

    def process(self):
        pass

    def initpygamemixer(self):
        pygame.mixer.pre_init(self.rate,-16,1,1024)
        pygame.mixer.init()    

    def releasepygamemixer(self):
        pygame.mixer.quit()    


    def createsoundarray(self,file):
        sound =pygame.mixer.Sound(file) 
        pygame.sndarray.use_arraytype('numeric')
        frmar = pygame.sndarray.array(sound)
        resultarray = array.array('h')
        for i in range(0,len(frmar),self.stepsamples):
            resultarray.append(frmar[i][0][0])
        return resultarray

    def createbrokenarray(self,file):
        resultarray = []
        fullarray = self.createsoundarray(file) 
        while len(fullarray)%self.sendsize != 0:
            fullarray.append(0)       
        cnt = len(fullarray)/self.sendsize
        for i in range(cnt):
            currarray = array.array('h')
            for j in range(self.sendsize):
                currarray.append(fullarray[(i*self.sendsize)+j])
            buff = gst.Buffer(currarray)
            resultarray.append(buff)

        return resultarray

    def endgracefully(self):
        self.pipeline.set_state(gst.STATE_NULL)
        wait(1000)   

    def init_audio(self):
        self.pipeline = gst.Pipeline("mypipeline")
        self.chain = []
        self.count = 0

        self.adder = gst.element_factory_make("adder","audiomixer")
        
        self.pipeline.add(self.adder)

        self.testwave = wave.open('/opt/inner-spin/sounds/1count.wav', 'r')
        self.testwave.rewind
        print 'framerate: ' + str(self.testwave.getframerate())
        print 'sampwidth: ' + str(self.testwave.getsampwidth())
        print 'channels: ' + str(self.testwave.getnchannels())
        print 'frames: ' + str(self.testwave.getnframes())

        self.initpygamemixer()

        self.nullbuffer =[]

        nullarray = array.array('h')
        for i in range(self.nullss):
            nullarray.append(0)

        self.nullarray = nullarray
        for i in range(self.numsources):                    
            self.nullbuffer.append(gst.Buffer(nullarray))

        for i in range(self.numsources):
            self.source= gst.element_factory_make("appsrc")
            channel = self.Channel(self,i)            
            caps = gst.Caps(
               'audio/x-raw-int,'
               'endianness=(int)1234,'
               'channels=(int)1,'
               'width=(int)16,'
               'depth=(int)16,'
               'signed=(boolean)true,'
               'rate=(int)' +str(self.rate)
               )
            self.source.set_property('caps', caps)
            self.source.set_property('min-latency', self.minlatency) 
            self.source.set_property('max-latency', self.maxlatency) 
            self.source.set_property('blocksize', self.nullss) 
            self.source.set_property('is-live', True) 
            self.pipeline.add(self.source)
            self.source.link(self.adder)
            self.soundqueue.append([-1,0])
            self.source.connect('need-data', channel.need_data)

        self.sink= gst.element_factory_make("autoaudiosink")
        self.pipeline.add(self.sink)
        self.adder.link(self.sink)        

        self.releasepygamemixer()

        self.pipeline.set_state(gst.STATE_PLAYING)   

    def pause(self):
        self.pipeline.set_state(gst.STATE_PAUSED)   

    def play(self):
        self.pipeline.set_state(gst.STATE_PLAYING)   

    def addwav(self, filename):
        self.soundbuffers.append(self.createbrokenarray(filename))
        return len(self.soundbuffers) -1

    def playsound(self,id):
        self.lock.acquire()
        bestsq = 0
        bestleft =8000000
        for i in range(self.numsources):
            if self.soundqueue[i][0] == -1:
                bestleft = 0
                bestsq=i
            elif len(self.soundbuffers[self.soundqueue[i][0]])- self.soundqueue[i][1] < bestleft:
                bestleft = len(self.soundbuffers[self.soundqueue[i][0]])- self.soundqueue[i][1]
                bestsq=i
                
        self.soundqueue[bestsq]=([id,0])     
        tst = self.soundqueue[bestsq][0]        
        self.lock.release()
        return True


    def need_data(self,src,length,id):
        self.lock.acquire()
        snd = self.soundqueue[id][0]
        if not (snd == -1):   
            pos =self.soundqueue[id][1]
            if (pos+1) >= len(self.soundbuffers[self.soundqueue[id][0]]):
                self.soundqueue[id]=[-1,0]
                val = self.soundqueue[id][0]
            else:
                self.soundqueue[id][1] = pos + 1

        self.lock.release()

        if (snd == -1):        
            src.emit('push-buffer',self.nullbuffer[id])
        else:
            src.emit('push-buffer',self.soundbuffers[snd][pos])
