#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *
from PyQt4.QtMobility.QtLocation import *
from PyQt4.QtMobility.QtBearer import *

import station
import dijkstra
import classes

_RAYON = station._RAYON
_TEMPS_ANIM = 1000
_FLEUVE = True

global graph
graph = {}

  
            

class Ui_MainWindow(QMainWindow):

    m_logfileInUse = False

    m_latitude = -1000
    m_longitude = -1000
    
    m_accuracy = False


    def closeEvent(self,event):
        self.m_location.stopUpdates()
        self.m_session.close()
#        print 'closing'
        QMainWindow.closeEvent (self, event)


    def __init__(self, parent = None):
        super(Ui_MainWindow, self).__init__()
        # QGeoPositionInfoSource
        self.m_location = QGeoPositionInfoSource.createDefaultSource(self)

        if self.m_location == 0:
            nmeaLocation = QNmeaPositionInfoSource(QNmeaPositionInfoSource.SimulationMode, self)
            logFile = QFile("nmealog.txt", self)
            nmeaLocation.setDevice(logFile)
            self.m_location = nmeaLocation
            self.m_logfileInUse = True
    
        # Listen gps position changes
        self.m_location.positionUpdated.connect(self.positionUpdated)

        if self.m_logfileInUse:
            QMessageBox.information(self, self.tr("Rtap"), self.tr("No GPS support detected, using GPS data from a sample log file instead."))
    
        manager = QNetworkConfigurationManager()
        canStartIAP = (manager.capabilities() and QNetworkConfigurationManager.CanStartAndStopInterfaces)
        cfg = manager.defaultConfiguration()
        if not cfg.isValid() or (not canStartIAP and cfg.state() != QNetworkConfiguration.Active):
            QMessageBox.information(self, self.tr("Rtap"), self.tr("Available Access Points not found."))
            return

        self.m_session = QNetworkSession(cfg, self)
        self.m_session.opened.connect(self.networkSessionOpened)

    # Start listening GPS position updates    
    def networkSessionOpened(self):
#        print 'a'
        self.m_location.startUpdates()
#        print 'b'

    def positionUpdated(self, gpsPos):
        if gpsPos.isValid():
            coord = gpsPos.coordinate()
            self.m_latitude = coord.latitude()
            self.m_longitude = coord.longitude()
            self.gps.setPos( (self.m_longitude*10-20)*500,-(self.m_latitude*10-488)*700)
            graph["GPS"].setPosXY(self.m_longitude, self.m_latitude)
            if gpsPos.attribute(QGeoPositionInfo.HorizontalAccuracy) < 80 or gpsPos.attribute(QGeoPositionInfo.VerticalAccuracy) < 80:
                self.gpsButton.setPix('Good')
            else:
                self.gpsButton.setPix('On')
    
    def addGPS(self):
        self.scene.addItem(self.gps)
        self.gps.state = True
        QObject.disconnect(self.gpsButton, SIGNAL("gpsOn"), self.addGPS)
        
    def closeSession(self):
        self.m_location.stopUpdates()
#        QTimer.singleShot(0, self.m_location.stopUpdates)
        QTimer.singleShot(0, self.m_session.close)
#        self.scene.removeItem(self.gps) 

    def gpsCenter(self):

        self.view.goTo(QPointF(self.gps.x(),self.gps.y()),self.view.getScale())
        self.view.animPar.start()
        
    def play(self):

        n = len(self.Chemin) - 1
        i = 1
        if n == 0:
            return
        else:
            self.panAction.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_video_stop.png"))
            self.view.animSeq.stop()
            self.view.animSeq.clear()
            
            #Anim Center

            animCenter = QPropertyAnimation (self.view, "center")
            animCenter.setDuration(_TEMPS_ANIM*2)
            animCenter.setEasingCurve(QEasingCurve.OutQuad)
            animCenter.setKeyValueAt(0, self.view.getCenter())
            animCenter.setKeyValueAt(1, QPointF(  graph[self.Chemin[0]].x(),  graph[self.Chemin[0]].y() ))


            #Anime Zoom    
            
            val = (5./self.view.getScale())**(.2)
            animZoom = QPropertyAnimation (self.view, "scaling")
            animZoom.setDuration(_TEMPS_ANIM*2)
            animZoom.setEasingCurve(QEasingCurve.Linear)
            animZoom.setKeyValueAt(0, val)
            animZoom.setKeyValueAt(1, val)

            animParIn = QParallelAnimationGroup()
            animParIn.addAnimation(animCenter)
            animParIn.addAnimation(animZoom)

            #Start anim
            self.view.animSeq.addAnimation(animParIn)
            self.view.animSeq.addPause(_TEMPS_ANIM/2)
            
            minH = graph[self.Chemin[0]].x()
            maxH = graph[self.Chemin[0]].x()
            minV = graph[self.Chemin[0]].y()
            maxV = graph[self.Chemin[0]].y()

            #Follow stations
            while i < n+1:
                anim = QPropertyAnimation (self.view, "center")
                anim.setDuration(_TEMPS_ANIM)
                anim.setEasingCurve(QEasingCurve.InOutCubic)
                anim.setKeyValueAt(0, graph[self.Chemin[i-1]].pos()  )
                anim.setKeyValueAt(1, graph[self.Chemin[i]].pos()  )
                self.view.animSeq.addAnimation(anim)
                minH = min(minH,graph[self.Chemin[i]].x())
                maxH = max(maxH,graph[self.Chemin[i]].x())
                minV = min(minV,graph[self.Chemin[i]].y())
                maxV = max(maxV,graph[self.Chemin[i]].y())
                i += 1
    

            #Anim UnCenter 

            animUnCenter = QPropertyAnimation (self.view, "center")
            animUnCenter.setDuration(_TEMPS_ANIM*2)
            animUnCenter.setEasingCurve(QEasingCurve.OutQuad)
            animUnCenter.setKeyValueAt(0, graph[self.Chemin[-1]].pos())
            
            dx = abs(maxH - minH)
            dy = abs(maxV - minV)
            
            x = (maxH + minH)/2
            y = (maxV + minV)/2
            animUnCenter.setKeyValueAt(1, QPointF(  x,  y ))

            #Anime UnZoom    
            
            w = self.width()
            h = self.height()
            Sx = (w/(dx+10))
            Sy = (h/(dy+10))
            S = max(min(Sx,Sy,5.0),.21)


            val = ((S) /5.)**(.15)

            
            animUnZoom = QPropertyAnimation (self.view, "scaling")
            animUnZoom.setDuration(_TEMPS_ANIM*2)
            animUnZoom.setEasingCurve(QEasingCurve.Linear)
            animUnZoom.setKeyValueAt(0, val)
            animUnZoom.setKeyValueAt(1, val)

            animParOut = QParallelAnimationGroup()
            animParOut.addAnimation(animUnCenter)
            animParOut.addAnimation(animUnZoom)

            self.view.animSeq.addPause(_TEMPS_ANIM/2)
            self.view.animSeq.addAnimation(animParOut)



            QObject.disconnect(self.panAction, SIGNAL("play"), self.play)
            QObject.connect(self.panAction, SIGNAL("play"), self.stop)
            self.view.animSeq.finished.connect(self.stop)
            self.view.animSeq.start()

    def stop(self):
        if self.view.animSeq.state() != QAbstractAnimation.Stopped:
            self.view.animSeq.stop()
        
        self.panAction.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        QObject.disconnect(self.panAction, SIGNAL("play"), self.view.animSeq.stop)
        QObject.connect(self.panAction, SIGNAL("play"), self.play)

        
    def search(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
        self.view.mousePressEvent(QMouseEvent ( QEvent.MouseButtonPress, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.view.mouseReleaseEvent(QMouseEvent ( QEvent.MouseButtonRelease, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.stop()
        self.panDepart.hide()
        self.panArrivee.hide()
        self.panAction.hide()
        self.gpsButton.hide()
        self.Temps.hide()

        cherche = classes.diagSearch(graph ,self.view)
        QObject.connect(self, SIGNAL("orientationChanged"), cherche.rotate)
        QObject.connect(cherche, SIGNAL("selected(QString)"), self.searchProcess)
        cherche.show()
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)

    def searchProcess(self,text):
        self.panDepart.show()
        self.panArrivee.show()
        self.panAction.show()
        self.gpsButton.show()

        if text != "":
            self.setSelec(text)
            self.view.goTo(graph[str(text)].pos(),self.view.getScale())
            self.view.animPar.start()

        
                    
    def selecLignes(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
        self.view.mousePressEvent(QMouseEvent ( QEvent.MouseButtonPress, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.view.mouseReleaseEvent(QMouseEvent ( QEvent.MouseButtonRelease, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.stop()
        self.panDepart.hide()
        self.panArrivee.hide()
        self.panAction.hide()
        self.gpsButton.hide()
        self.Temps.hide()

        graph.clear()
        boole = (self.view.width() < self.view.height())
        ligne = classes.diagLigne(self.Lignes,boole,self.view)
        QObject.connect(ligne,SIGNAL("selection(PyQt_PyObject)"),self.selecLignesProcess)
        QObject.connect(self, SIGNAL("orientationChanged"), ligne.rotate)
        ligne.show()
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
        
    def selecLignesProcess(self,liste):
        reload(station)
        self.Lignes = liste
        self.buildGraph()
        self.drawGraph()
        if len(self.Lignes) < 5:
            for stop in graph:
                if stop[-1] != ']':
                    nom = QGraphicsTextItem (stop,graph[stop])
                    nom.setFont(QFont ( "Nokia Sans",_RAYON/2  ,63 ))
                    nom.setDefaultTextColor(graph[stop].color.color().lighter())

        self.panDepart.show()
        self.panArrivee.show()
        self.panAction.show()
        self.gpsButton.show()
        
        dep,arr = self.Selec
        self.Selec = '',''
        #self.deselec(self.Selec[0])
        #self.deselec(self.Selec[1])
        #if dep in graph:
        #    self.setSelec(dep)
        #if arr in graph:
        #     self.setSelec(arr)
        self.panDepart.playX(self.width())
        self.panAction.playX(self.width())
        self.panArrivee.playX(self.width())
        if dep in graph:
            self.setSelec(dep)
        if arr in graph:
            if self.Selec[0] != '':
                self.setSelec(arr)
            else:
                self.Selec = ('GPS','')
                self.setSelec(arr)
                self.deselec('GPS')

    def about(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
        self.view.mousePressEvent(QMouseEvent ( QEvent.MouseButtonPress, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.view.mouseReleaseEvent(QMouseEvent ( QEvent.MouseButtonRelease, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.stop()
        self.panDepart.hide()
        self.panArrivee.hide()
        self.panAction.hide()
        self.gpsButton.hide()
        self.Temps.hide()

        about = classes.diagAbout(self.view)
        QObject.connect(self, SIGNAL("orientationChanged"), about.rotate)
        QObject.connect(about,SIGNAL("closing()"),self.endMenu)
        about.show()
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)



    def aide(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
        self.view.mousePressEvent(QMouseEvent ( QEvent.MouseButtonPress, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.view.mouseReleaseEvent(QMouseEvent ( QEvent.MouseButtonRelease, QPoint(0,0), Qt.LeftButton, Qt.LeftButton, Qt.NoModifier ))
        self.stop()
        self.panDepart.hide()
        self.panArrivee.hide()
        self.panAction.hide()
        self.gpsButton.hide()
        self.Temps.hide()

        aide = classes.diagAide(self.view)
        QObject.connect(self, SIGNAL("orientationChanged"), aide.rotate)
        QObject.connect(aide,SIGNAL("closing()"),self.endMenu)
        aide.show()
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)

    def endMenu(self):
        self.panDepart.show()
        self.panArrivee.show()
        self.panAction.show()
        self.gpsButton.show()


    def setSelec(self,Name):
        
        Nom = str(Name)
        
        w = self.width()
        h = self.height()
        if self.panAction.toggle:
            if self.Selec[0] != Nom and Nom != self.Selec[1]:
                for value in graph:
                    graph[value].deselec()
                self.gps.deselec()
                for item in self.CheminItem:
                    self.scene.removeItem(item)
                self.scene.unblur()
                self.panDepart.playX(w)
                self.panArrivee.playX(w)
                self.panAction.playX(w)
            
                self.Selec = (Nom,'')
            
                self.panDepart.playX(w,Nom)
                graph[Nom].selec() 
            
            self.scene.update()
        else:
            if Nom == self.Selec[0] or Nom == self.Selec[1]:
                self.colorise()
                    
            elif self.Selec[0] == '':
                self.Selec = (Nom,self.Selec[1])
                graph[Nom].selec()
                self.scene.update()

                self.panDepart.playX(w,Nom)
                if self.Selec[1] != '':
                    self.panAction.playX(w,Nom)
            
            elif self.Selec[0] == Nom and self.Selec[1] == '':
                return 
        
            else:
                if self.Selec[0] != Nom and Nom != self.Selec[1]:
                    self.deselec(self.Selec[1])
                    self.Selec = (self.Selec[0],Nom)
                    
                    graph[Nom].selec()
                    self.scene.update()
                
                    self.panArrivee.playX(w,Nom)
                    self.panAction.playX(w,Nom)
                    

        
    def rectSelec(self,p):
        point = self.view.mapFromScene(p)
        rect = self.view.mapToScene(QRect(point.x()-10.,point.y()-10.,20.,20.))
        liste = self.scene.items(rect)
        listeNom = []
        for element in liste:
            if element.type() == 65536:
                listeNom += [element.name]
            elif element.type() == 4:
                listeNom += ['GPS']

        
        if len(listeNom) == 1:
            self.setSelec(listeNom[0])
            if listeNom[0] == 'GPS':
                self.gps.selec()
        elif len(listeNom) > 1:
            Selec , ok = QInputDialog.getItem ( self.view, 'Liste de stations' , "Choisir la station :", listeNom, 0, False)
            if ok:
                self.setSelec(Selec)
                if Selec == 'GPS':
                    self.gps.selec()
                

    def gpsSearch(self,p):
        point = self.view.mapFromScene(p)
        proche = []
        k = 1
        while proche == []:
            r = QRect(point.x()-k*10.,point.y()-k*10.,k*20.,k*20.)
            rect = self.view.mapToScene(r)
            liste = self.scene.items(rect)
            for element in liste:
                if element.type() == 65536 and element.name != "GPS":
                    proche += [element]
            k += 1
        listeNom = []
        for element in proche:
            if element.type() == 65536:
                listeNom += [element.name]
        if len(listeNom) == 1:
            return listeNom[0]
        elif len(listeNom) > 1:
            Selec , ok = QInputDialog.getItem ( self.view, 'Liste de stations' , "Choisir la station :", listeNom, 0, False)
            if ok:
                return Selec
        
    def deselec(self,Nom):
        w = self.width()
        h = self.height()
        self.scene.unblur()
        for item in self.CheminItem:
            self.scene.removeItem(item)
        self.CheminItem=[]
        self.Temps.hide()
        
        
        for value in graph:
                graph[value].deselec()
        self.scene.update()
        if Nom == self.Selec[0]:
            self.Selec = ('',self.Selec[1])
            if self.Selec[1] != '':
                graph[self.Selec[1]].selec()
            self.panDepart.playX(w)
            self.panAction.playX(w)
        else:
            self.Selec = (self.Selec[0],'')
            if self.Selec[0] != '':
                graph[self.Selec[0]].selec()
            self.panArrivee.playX(w)
            self.panAction.playX(w)
        if Nom == 'GPS':
            self.gps.deselec()
        
        
        
    def colorise(self):
        self.scene.blur()
        self.CheminItem = []

        if self.Selec[0] == 'GPS':
            proche = self.gpsSearch(self.gps.pos())
            graph['GPS'].addCorres(str(proche))
            self.Chemin , tps = dijkstra.algo(str(proche),self.Selec[1],graph)
            self.Chemin = ['GPS'] + self.Chemin
        elif  self.Selec[1] == 'GPS':
            proche = self.gpsSearch(self.gps.pos())
            self.Chemin ,tps = dijkstra.algo(self.Selec[0],str(proche),graph) 
            self.Chemin += ["GPS"]
            graph[str(proche)].addCorres("GPS")
        else:
            self.Chemin, tps = dijkstra.algo(self.Selec[0],self.Selec[1],graph)

        dep = self.Chemin[0]
        for dest in self.Chemin[1:]:
            idx = graph[dep].corres.index(dest)
            line = QGraphicsLineItem ( 
                    graph[dep].x() + _RAYON/2, 
                    graph[dep].y() + _RAYON/2, 
                    graph[dest].x() + _RAYON/2, 
                    graph[dest].y() + _RAYON/2, 
                    )
            line.setPen(QPen(graph[dep].corresColor[idx], _RAYON/2))
            self.CheminItem.append(line)
            dep = dest
        dep = self.Chemin[0]
        for dest in self.Chemin:
            gradient = QRadialGradient(graph[dest].x(),graph[dest].y(), _RAYON*1.5)
            try:
                idx = graph[dest].corres.index(dep)

                gradient.setColorAt(0, graph[dest].corresColor[idx].lighter(200))
                gradient.setColorAt(1, graph[dest].corresColor[idx])
            except ValueError:
                gradient.setColorAt(0, graph[dest].color.color().lighter(200))
                gradient.setColorAt(1, graph[dest].color.color())
            except AttributeError:
                gradient.setColorAt(0, graph[dest].color.color())
                gradient.setColorAt(1, graph[dest].color.color())
                
            ellipse = QGraphicsEllipseItem (graph[dest].x(), graph[dest].y(), _RAYON, _RAYON)

            ellipse.setPen(QPen( gradient, _RAYON/2))
            ellipse.setBrush(QBrush(gradient))
            self.CheminItem.append(ellipse)
            dep = dest
        dep = self.Chemin[0]

        minH = graph[self.Chemin[0]].x()
        maxH = graph[self.Chemin[0]].x()
        minV = graph[self.Chemin[0]].y()
        maxV = graph[self.Chemin[0]].y()

        for dest in self.Chemin:
            if not dest[:-4] in graph[dep].name or dest == dep:
                if dest[-1] == ']':
                    txt = QGraphicsTextItem (dest[:-4])
                else:
                    txt = QGraphicsTextItem (dest)
                txt.setPos(graph[dest].pos())
                txt.setFont(QFont ( "Nokia Sans",_RAYON/2 ,63 ))
    
                try:
                    idx = graph[dest].corres.index(dep)
    
                    txt.setDefaultTextColor(graph[dest].corresColor[idx])
                except ValueError:
                    txt.setDefaultTextColor(graph[dest].color.color())
                except AttributeError:
                    txt.setDefaultTextColor(graph[dest].color.color())
                    
                if dest[-1] == ']':
                    txtOmbre = QGraphicsTextItem (dest[:-4])
                else:
                    txtOmbre = QGraphicsTextItem (dest)
                txtOmbre.setPos(graph[dest].x()-.25, graph[dest].y()+.25)
                txtOmbre.setDefaultTextColor(Qt.black)
                txtOmbre.setFont(QFont ( "Nokia Sans",_RAYON/2 ,63 ))
    
                self.CheminItem.append(txtOmbre)
                self.CheminItem.append(txt)

                minH = min(minH,graph[dest].x())
                maxH = max(maxH,graph[dest].x())
                minV = min(minV,graph[dest].y())
                maxV = max(maxV,graph[dest].y())

            dep = dest

        for item in self.CheminItem:
            self.scene.addItem(item)
        self.scene.update()
        self.panAction.toggling()

        self.Temps.setText("Environ "+ str(int(tps/60)) + " min.")
        self.Temps.resize(200,40)
        self.Temps.show()
        self.animTemps.setKeyValueAt(0, QPoint(10, -50) )
        self.animTemps.setKeyValueAt(1, QPoint(10, 0) )
        self.animTemps.start()
    

            #Anim UnCenter 

        animUnCenter = QPropertyAnimation (self.view, "center")
        animUnCenter.setDuration(_TEMPS_ANIM)
        animUnCenter.setEasingCurve(QEasingCurve.OutQuad)
        animUnCenter.setKeyValueAt(0, self.view.getCenter())
            
        dx = abs(maxH - minH)
        dy = abs(maxV - minV)
            
        x = (maxH + minH)/2
        y = (maxV + minV)/2
        animUnCenter.setKeyValueAt(1, QPointF(  x,  y ))

            #Anime UnZoom    
            
        w = self.width()
        h = self.height()
        Sx = (w/(dx+10))
        Sy = (h/(dy+10))
        S = max(min(Sx,Sy,5.0),.21)

        val = ((S) /self.view.getScale())**(.1)
            
        animUnZoom = QPropertyAnimation (self.view, "scaling")
        animUnZoom.setDuration(_TEMPS_ANIM)
        animUnZoom.setEasingCurve(QEasingCurve.Linear)
        animUnZoom.setKeyValueAt(0, val)
        animUnZoom.setKeyValueAt(1, val)

        animParOut = QParallelAnimationGroup()
        animParOut.addAnimation(animUnCenter)
        animParOut.addAnimation(animUnZoom)
        
        self.view.animSeq.stop()
        self.view.animSeq.clear()
        self.view.animSeq.addAnimation(animParOut)
        self.view.animSeq.start()

        try:
            graph[str(proche)].removeCorres("GPS")
        except UnboundLocalError:
            return
        
        

    def orientationChanged(self, i):
        self.emit(SIGNAL("orientationChanged"))
        self.panArrivee.move(self.panArrivee.x(),self.view.height()-70)
        self.panAction.move(self.panAction.x(),self.view.height()/2-48)
        self.view.translate(-150,200)
        
        self.gpsButton.move(0,self.view.height()-64)

        if self.panDepart.state :
            self.panDepart.move(self.view.width()-min(290,self.panDepart.width()),self.panDepart.y())
        if self.panArrivee.state :
            self.panArrivee.move(self.view.width()-min(290,self.panArrivee.width()),self.panArrivee.y())
        if self.panAction.state :
            self.panAction.move(self.view.width()-100,self.panAction.y())
            self.panAction.animMargin.start()

    def buildGraph(self):
        toFix = []
        graph.clear()
        for it in self.Lignes:
            ligne = station.FullListe[it]
            for stop in ligne:
                if stop in graph:
                    for dest in ligne[stop].corres:
                        graph[stop].addCorres(dest,ligne[stop].color.color())
                else:
                    graph[stop] = ligne[stop]
        graph['GPS'] = station.GPS['GPS']

        
    def drawGraph(self):
        for item in self.scene.items():
            self.scene.removeItem(item)
        if _FLEUVE:
            self.drawFleuve()
        #Segment entre stations
        for dep in graph:
            k = 0
            while k < len(graph[dep].corres):
                dest = graph[dep].corres[k]
                try:
                    self.scene.addLine ( 
                        graph[dep].x() + _RAYON/2, 
                        graph[dep].y() + _RAYON/2, 
                        graph[dest].x() + _RAYON/2, 
                        graph[dest].y() + _RAYON/2, 
                        QPen(graph[dep].corresColor[k], _RAYON/4)
                        )        
                except KeyError:
                    graph[dep].removeCorres(dest)
#                    print dep, graph[dep].corres

                try:
                    if graph[dep].corresColor[k] == graph[dep].corresColor[k+1] and graph[dep].corresColor[k] != station.LigneM:
                        k += 2
                    else:
                        k += 1
                except IndexError:
                    k += 1

        #Stations
        for value in graph:
            try:
                if value[-1] != "]" and value != 'GPS':
                    self.scene.addItem(graph[value])
                       
            except IndexError:
                self.scene.addItem(graph[value])
        #Gps
        if self.gps.state:
            self.scene.addItem(self.gps)

                
    def drawFleuve(self):
        #Fleuve
        fleuve = QPainterPath()
        fleuve.moveTo(station.SeineX[0], station.SeineY[0])
        l = len(station.SeineX)
        k = 1
        while k != l:
            fleuve.lineTo(station.SeineX[k], station.SeineY[k])
            k += 1

        fleuve.moveTo(station.OiseX[0], station.OiseY[0])
        l = len(station.OiseX)
        k = 1
        while k != l:
            fleuve.lineTo(station.OiseX[k], station.OiseY[k])
            k += 1

        fleuve.moveTo(station.MarneX[0], station.MarneY[0])
        l = len(station.MarneX)
        k = 1
        while k != l:
            fleuve.lineTo(station.MarneX[k], station.MarneY[k])
            k += 1
           
        fleuve.moveTo(station.SeineIleX[0], station.SeineIleY[0])
        l = len(station.SeineIleX)
        k = 1
        while k != l:
            fleuve.lineTo(station.SeineIleX[k], station.SeineIleY[k])
            k += 1
           
        self.scene.addPath(fleuve, QPen( QColor(165,191,221), _RAYON*.8))

    
    def setupUi(self, app):
        self.setWindowTitle("Rtap")
        self.resize(800,480)

        self.centralWidget = QWidget(self)
        self.Selec = ('','')
        self.CheminItem = []
        self.Chemin = []
        self.Lignes = range(25)#[station.GPS] + station.Metro + station.Rer+ station.Tram


########## GPS

#        self.gps = graph["GPS"]
        self.gps = classes.Gps()

########## Scene
        
        self.scene = classes.Carte(self)
#        self.scene.setSceneRect(-815.90800894434585, -2585.2493331816809, 5397.5130039461728, 3900.3854289115216)
        
        self.buildGraph()
        self.drawGraph()

        QObject.connect(self.scene, SIGNAL("dblclicked(QPointF)"), self.rectSelec)
        self.scene.setBackgroundBrush(self.palette().shadow().color())
########## View
        self.view = classes.Fond(self.scene)
        self.view.setDragMode(1)
        self.view.setVerticalScrollBarPolicy ( Qt.ScrollBarAlwaysOff )
        self.view.setHorizontalScrollBarPolicy ( Qt.ScrollBarAlwaysOff )

########## Panneaux

        self.panDepart = classes.PanStation(self.view)
        self.panDepart.setGeometry(900,0,250,180)
        QObject.connect(self.panDepart, SIGNAL("released(QString)"), self.deselec)
        self.panDepart.setStyleSheet("background-color: qlineargradient(x1:3, y1:-1, x2:0, y2:1, stop:0 palette(light),  stop:1 palette(highlight)) ; color: palette(highlighted-text) ;border-left:3px solid palette(highlight); border-bottom:3px solid palette(highlight);")
        self.panDepart.show()


        self.panArrivee = classes.PanStation(self.view)
        self.panArrivee.setGeometry(900,app.desktop().screenGeometry().height()-126,250,180)
        QObject.connect(self.panArrivee, SIGNAL("released(QString)"), self.deselec)
        self.panArrivee.setStyleSheet("background-color: qlineargradient(x1:3, y1:2, x2:0, y2:0, stop:0 palette(light),  stop:1 palette(highlight)) ; color: palette(highlighted-text) ;border-left:3px solid palette(highlight); border-top:3px solid palette(highlight);")
        self.panArrivee.show()

        self.panAction = classes.PanAction(self.view)
        self.panAction.setGeometry(900,app.desktop().screenGeometry().height()/2-56-20,80,80)
        QObject.connect(self.panAction, SIGNAL("colorise"), self.colorise)
        QObject.connect(self.panAction, SIGNAL("play"), self.play)
        self.panAction.show()
        self.panAction.animMargin.start()
        
########## Temps
        self.Temps = QLabel(self.view)
        self.animTemps = QPropertyAnimation (self.Temps, "pos")
        self.animTemps.setDuration(_TEMPS_ANIM/3)
        self.animTemps.setEasingCurve(QEasingCurve.OutQuad)
        
########## GPS Button

        self.gpsButton = classes.GpsButton(self.view)
        QObject.connect(self.gpsButton, SIGNAL("gpsOn"), self.m_session.open)
        QObject.connect(self.gpsButton, SIGNAL("gpsOn"), self.addGPS)
        QObject.connect(self.gpsButton, SIGNAL("gpsOff"), self.closeSession)
        QObject.connect(self.gpsButton, SIGNAL("gpsCenter"), self.gpsCenter)
        self.gpsButton.setGeometry(0,app.desktop().screenGeometry().height()-64-56,64,64)
        self.gpsButton.show()

######### Menu

        menubar = QMenuBar(self)
        self.setMenuBar(menubar)
        
        menuChercher = QAction("Recherche",self)
        menubar.addAction(menuChercher)
        QObject.connect(menuChercher, SIGNAL("triggered()"), self.search)

        menuLignes = QAction("Lignes",self)
        menubar.addAction(menuLignes)
        QObject.connect(menuLignes, SIGNAL("triggered()"), self.selecLignes)

        menuAide = QAction("Aide",self)
        menubar.addAction(menuAide)
        QObject.connect(menuAide, SIGNAL("triggered()"), self.aide)

        menuAbout = QAction("\xc0 Propos",self)
        menubar.addAction(menuAbout)
        QObject.connect(menuAbout, SIGNAL("triggered()"), self.about)

#########

        if app.desktop().screenGeometry().width() < app.desktop().screenGeometry().height():
            self.view.centerOn(1900.,-500) 
        else:
            self.view.centerOn(1750.,-400)
        self.view.show()
        self.view.update()

        self.setCentralWidget(self.view)

        QObject.connect(app.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        
        

