#!/usr/bin/env python
# -*- coding: utf-8 -*-


from PyQt4.QtGui import *
from PyQt4.QtCore import *

LigneM = Qt.lightGray

Ligne1 = QColor(255,205,9)
Ligne2 = QColor(12,110,183)
Ligne3 =QColor(155,153,58)
Ligne3b = QColor(137,211,220)
Ligne4 = QColor(187,75,156)
Ligne5 = QColor(246,143,77)
Ligne6 = QColor(120,198,150)
Ligne7 = QColor(245,158,179)
Ligne7b = QColor(120,198,152)
Ligne8 = QColor(197,163,204)
Ligne9 = QColor(206,200,43)
Ligne10 = QColor(224,176,58)
Ligne11 = QColor(141,102,58)
Ligne12 = QColor(2,141,91)
Ligne13 = QColor(137,211,222)
Ligne14 = QColor(103,47,143)

RERA = QColor(237,26,42)
RERB = QColor(88,142,210)
RERC = QColor(240,207,17)
RERD = QColor(23,174,101)
RERE = QColor(211,101,186)
_RAYON = 10.

class Station(QGraphicsItem):   
    def __init__(self, name, corres, x, y, color, correscolor):
        super(Station, self).__init__()
        
        self.name = name
        self.corres = corres
        self.corresColor = correscolor
        self.posY = -(x*10-488)*700
        self.posX = (y*10-20)*500
        #self.posX = (x)*50
        #self.posY = (y)*50
        self.colorIni = QBrush(color)
        self.color = QBrush(color)
        self.pen = QPen(Qt.NoPen)
        self.penIni = self.pen
        
    def setPos(self,x,y):
        self.posY = -(y*10-488)*700
        self.posX = (x*10-20)*500
        
    def Pos(self):
        return QPointF(self.posX,self.posY)
        
        
    def setColor(self,color):
        self.color = color
        
    def setPen(self,pen):
        self.pen = pen
        self.penIni = self.pen
        
    def addCorres(self,corres,color=LigneM):
        self.corres += [corres]
        self.corresColor += [color]
        self.color = QBrush(LigneM)
        self.colorIni = QBrush(LigneM)
        
    def removeCorres(self,corres):
        try:
            idx = self.corres.index(corres)
            self.corres.pop(idx)
            self.corresColor.pop(idx)
        except ValueError:
            print 'il y etait pas!'
            
    def listCorres(self,color):
        l = []
        for i in range(len(self.corres)):
            if self.corresColor[i] == color:
                l.append(self.corres[i])
        return l
    
    def changeColor(self,color):
        if self.color == self.colorIni:
            self.color = QBrush(color)
        else:
            self.color = self.colorIni
        

    def selec(self):
        gradient = QRadialGradient(self.posX,self.posY, _RAYON*1.5)
        gradient.setColorAt(0, self.color.color().lighter(200))
        gradient.setColorAt(1, self.color.color())
        self.pen = QPen( gradient, _RAYON)
        
   
    def deselec(self):
        self.pen = self.penIni
        self.color = self.colorIni

        
    def boundingRect(self):
        return QRectF(self.posX, self.posY, _RAYON, _RAYON)
        
        
    def paint(self, painter, option, widget):
        painter.setRenderHint(QPainter.Antialiasing)
        gradient = QRadialGradient(self.posX,self.posY, _RAYON*2.5)
        gradient.setColorAt(1, self.color.color().darker(300))
        gradient.setColorAt(0, self.color.color())
        painter.setBrush(gradient)
        painter.setPen(self.pen)
        painter.drawEllipse(self.posX, self.posY, _RAYON, _RAYON)
        painter.setPen(Qt.black)
        #font= painter.font() 
        #font = QFont ( "Nokia Sans",_RAYON/2  )
        #font.setPointSize ( _RAYON/3 )
        #painter.setFont(font)
        #painter.drawText(self.posX + _RAYON*1.1, self.posY + _RAYON*1.1, self.name)


##############Fleuves

SeineX = [4574.05, 4491.655, 4103.7, 3954.355, 3986.97, 3926.89, 3748.36, 3727.76, 3730.335, 3860.8, 3757.8, 3412.76, 3343.24, 3255.69, 2996.485, 2902.925, 2675.475, 2648.01, 2740.705, 2649.725, 2487.505, 2421.415, 2398.245, 2420.99, 1941.195, 2008.57, 2223.15, 2185.385, 2121.44, 2059.64, 2108.995, 2048.485, 2035.18, 1951.065, 1911.585, 1874.675, 1839.055, 1804.725, 1766.53, 1734.345, 1703.875, 1687.565, 1649.585, 1589.72, 1508.18, 1459.47, 1438.01, 1377.5, 1301.755, 1243.82, 1204.125, 1135.89, 1117.435, 1121.08, 1158.42, 1215.28, 1283.515, 1326.22, 1436.08, 1601.735, 1643.575, 1707.735, 1678.765, 1535.215, 1454.75, 1302.83, 1070.44, 943.415, 873.03, 779.045, 685.92, 549.02, 598.805, 867.025, 836.985, 353.755, 237.885, 134.45, 92.83, 14.725, -11.025, -357.78, -808.389 ]

SeineY = [2971.227, 3020.031, 2854.026, 2873.178, 2758.287, 2702.455, 2708.839, 2547.762, 2536.597, 2338.945, 2197.951, 2213.876, 1888.264, 1840.524, 1982.995, 1896.223, 1819.839, 1734.719, 1636.901, 1584.422, 1626.562, 1609.867, 1554.21, 1306.655, 856.093, 668.101, 488.537, 384.72, 332.423, 236.18, 85.33, -33.404, -123.6129, -178.997, -222.11, -266.399, -304.759, -341.131, -358.925, -372.764, -394.898, -408.338, -420.392, -446.2849, -444.108, -419.209, -389.361, -326.109, -218.743, -171.878, -157.045, -199.759, -289.338, -374.143, -483.042, -544.096, -624.694, -671.1109, -725.018, -812.882, -831.243, -950.453, -1011.626, -1058.582, -1056.209, -1002.743, -814.856, -741.412, -720.475, -558.1239, -499.919, -616.196, -823.935, -1074.164, -1278.872, -1298.584, -1121.897, -1035.888, -912.758, -1172.388, -1284.388, -1436.554, -1295.427 ] 

SeineIleX = [1687.565, 1709.45, 1752.795, 1802.255, 1804.725]

SeineIleY = [-408.338, -402.586, -385.485, -357.507, -341,131]

OiseX = [350.325, 358.905, 179.52, 259.34, 358.865, 432.72, 501.385, 666.18, 847.28, 1023.235, 1101.34, 1297.035, 1476.42, 1774.255, 1830.9, 1844.635, 1998.27, 2103.845, 2278.94, 2434.29, 2550.165, 2601.66, 3081.455, 3136.385]

OiseY = [-1300.95, -1407.35, -1607.55, -1683.92, -1552.39, -1542.1, -1721.79, -1869.77, -1847.72, -1989.47, -2288.37, -2322.18, -2459.73, -2414.93, -2577.61, -2802.24, -2822.68, -2861.95, -3160.92, -3249.54, -3370.92, -3475.29, -3537.94, -3671.15]


MarneX = [2041.185, 2257.05, 2340.305, 2377.215, 2475.49, 2551.02, 2607.67, 2611.53, 2550.165, 2400.39, 2345.455, 2343.31, 2419.7, 2554.455, 2587.93, 2567.76, 2557.89, 2578.06, 2835.98, 2822.245, 2987.04, 3073.73, 3186.6, 3308.905, 3450.1, 3766.815, 3834.62, 3836.335, 3795.135, 3674.975, 3653.09, 3600.73, 3580.99, 3622.62, 3674.545, 3817.455, 3905, 3906.29, 3902.855, 3954.355, 4005.425, 4032.89, 4143.61, 4164.64, 4196.335, 4166.785, 4210.13, 4236.735, 4256.475, 4383.505, 4376.64, 4405.825, 4439.295, 4495.945, 4574.05]

MarneY = [-120.848, -110.166, -30.632, 88.8930, 110.271, 113.435, 67.515, -26.6769, -71.3930, -94.3389, -140.623, -190.071, -220.129, -203.9169, -238.721, -273.5179, -332.437, -359.716, -388.9689, -438.382, -466.438, -417.431, -403.991, -522.165, -560.490, -586.572, -646.618, -712.579, -730.744, -724.822, -714.952, -721.2659, -750.491, -852.362, -867.3629, -842.492, -915.523, -962.493, -1022.476, -1038.261, -1026.025, -801.038, -767.865, -744.569, -720.0829, -698.362, -707.049, -754.838, -866.971, -1039.045, -1091.125, -1099.805, -998.011, -945.917, -971.173]

##############Ligne

GPS = {'GPS' : Station('GPS', [] , 48.858743,2.347383 , Qt.red , [] )}

Metro1 = {'La Defense - Grande Arche [M]' : Station('La Defense - Grande Arche [M]', ['Esplanade de La Defense','La Defense - Grande Arche'] , 48.8919458, 2.237716 , Ligne1 , [Ligne1,LigneM] ) , 
'La Defense - Grande Arche' : Station('La Defense - Grande Arche', ['La Defense - Grande Arche [M]'] ,    	48.8920139, 2.2379331  , LigneM , [LigneM] ) , 
'Esplanade de La Defense' : Station('Esplanade de La Defense', ['Pont de Neuilly','La Defense - Grande Arche [M]'] , 48.8882286, 2.2493898, Ligne1 , [Ligne1,Ligne1] ) , 
'Pont de Neuilly' : Station('Pont de Neuilly', ['Les Sablons','Esplanade de La Defense'] , 48.8855801, 2.25779, Ligne1 , [Ligne1,Ligne1] ) , 
'Les Sablons' : Station('Les Sablons', ['Porte Maillot','Pont de Neuilly'] , 	48.8811205, 2.2717733, Ligne1 , [Ligne1,Ligne1] ) , 
'Porte Maillot' : Station('Porte Maillot', ['Argentine','Les Sablons'] , 	48.8781189, 2.2815392, Ligne1 , [Ligne1,Ligne1] ) , 
'Argentine' : Station('Argentine', ['Charles de Gaulle - Etoile','Porte Maillot'] , 	48.875713, 2.2891932, Ligne1 , [Ligne1,Ligne1] ) , 
'Charles de Gaulle - Etoile' : Station('Charles de Gaulle - Etoile', ['George V','Argentine'] , 48.8736879, 2.2954454, Ligne1 , [Ligne1,Ligne1] ) , 
'George V' : Station('George V', ['Franklin D.Roosevelt','Charles de Gaulle - Etoile'] ,	48.8717698, 2.3012386 , Ligne1 , [Ligne1,Ligne1] ) , 
'Franklin D.Roosevelt' : Station('Franklin D.Roosevelt', ['Champs-Elysees Clemenceau','George V'] , 48.8689538, 2.3101679, Ligne1 , [Ligne1,Ligne1] ) , 
'Champs-Elysees Clemenceau' : Station('Champs-Elysees Clemenceau', ['Concorde [1]','Franklin D.Roosevelt'] , 	48.8678333, 2.3137075, Ligne1 , [Ligne1,Ligne1] ) , 
'Concorde [1]' : Station('Concorde [1]', ['Tuileries','Champs-Elysees Clemenceau','Concorde'] , 48.8664075, 2.322138, Ligne1 , [Ligne1,Ligne1,LigneM] ) , 
'Concorde' : Station('Concorde', ['Concorde [1]'] ,	48.8664075, 2.322138 , LigneM , [LigneM] ) , 
'Tuileries' : Station('Tuileries', ['Palais Royal - Musee du Louvre','Concorde [1]'] ,	48.8643585, 2.3298436 , Ligne1 , [Ligne1,Ligne1] ) , 
'Palais Royal - Musee du Louvre' : Station('Palais Royal - Musee du Louvre', ['Louvre - Rivoli','Tuileries'] , 48.8621984, 2.3366252 , Ligne1 , [Ligne1,Ligne1] ) , 
'Louvre - Rivoli' : Station('Louvre - Rivoli', ['Chatelet','Palais Royal - Musee du Louvre'] , 48.8607697, 2.3409358, Ligne1 , [Ligne1,Ligne1] ) , 
'Chatelet' : Station('Chatelet', ['Hotel de Ville','Louvre - Rivoli'] , 48.858743,2.347383, Ligne1 , [Ligne1,Ligne1] ) , 
'Hotel de Ville' : Station('Hotel de Ville', ['Saint-Paul','Chatelet'] , 48.8572265, 2.3521708, Ligne1 , [Ligne1,Ligne1] ) , 
'Saint-Paul' : Station('Saint-Paul', ['Bastille','Hotel de Ville'] , 	48.855214, 2.3606657, Ligne1 , [Ligne1,Ligne1] ) , 
'Bastille' : Station('Bastille', ['Gare de Lyon [1]','Saint-Paul'] , 48.8520122, 2.3686542, Ligne1 , [Ligne1,Ligne1] ) , 
'Gare de Lyon [1]' : Station('Gare de Lyon [1]', ['Reuilly-Diderot','Bastille','Gare de Lyon'] , 48.8454843, 2.3728519 , Ligne1 , [Ligne1,Ligne1,LigneM] ) , 
'Gare de Lyon' : Station('Gare de Lyon', ['Gare de Lyon [1]'] ,   48.8452 , 2.373   , LigneM , [LigneM] ) , 
'Reuilly-Diderot' : Station('Reuilly-Diderot', ['Nation','Gare de Lyon [1]'] , 	48.8472696, 2.3866995, Ligne1 , [Ligne1,Ligne1] ) , 
'Nation' : Station('', ['Porte de Vincennes','Reuilly-Diderot'] , 48.8483272, 2.395841 , Ligne1 , [Ligne1,Ligne1] ) , 
'Porte de Vincennes' : Station('Porte de Vincennes', ['Saint-Mande - Tourelle','Nation'] , 	48.8474233, 2.4072293, Ligne1 , [Ligne1,Ligne1] ) , 
'Saint-Mande - Tourelle' : Station('Saint-Mande - Tourelle', ['Berault','Porte de Vincennes'] , 48.8461657, 2.4193071, Ligne1 , [Ligne1,Ligne1] ) , 
'Berault' : Station('Berault', ['Chateau de Vincennes','Saint-Mande - Tourelle'] , 	48.8453197, 2.4286587, Ligne1 , [Ligne1,Ligne1] ) , 
'Chateau de Vincennes' : Station('Chateau de Vincennes', ['Berault'] , 48.8441956, 2.4399969, Ligne1 , [Ligne1] )}

Metro2 = {'Porte Dauphine' : Station('Porte Dauphine', ['Victor Hugo'] , 	48.8714638, 2.2768954, Ligne2 , [Ligne2] ) , 
'Victor Hugo' : Station('Victor Hugo', ['Charles de Gaulle - Etoile','Porte Dauphine'] , 	48.8698038, 2.2854485, Ligne2 , [Ligne2,Ligne2] ) , 
'Charles de Gaulle - Etoile' : Station('Charles de Gaulle - Etoile', ['Ternes','Victor Hugo'] ,48.8736879, 2.2954454 , Ligne2 , [Ligne2,Ligne2] ) , 
'Ternes' : Station('Ternes', ['Courcelles','Charles de Gaulle - Etoile'] , 48.8780508, 2.2982339, Ligne2 , [Ligne2,Ligne2] ) , 
'Courcelles' : Station('Courcelles', ['Monceau','Ternes'] ,	48.8792716, 2.3033776, Ligne2 , [Ligne2,Ligne2] ) , 
'Monceau' : Station('Monceau', ['Villiers','Courcelles'] ,	48.880492, 2.3091249 , Ligne2 , [Ligne2,Ligne2] ) , 
'Villiers' : Station('Villiers', ['Rome','Monceau'] ,	48.8812626, 2.3155318 , Ligne2 , [Ligne2,Ligne2] ) , 
'Rome' : Station('Rome', ['Place de Clichy','Villiers'] , 48.8824265, 2.3221246, Ligne2 , [Ligne2,Ligne2] ) , 
'Place de Clichy' : Station('Place de Clichy', ['Blanche','Rome'] , 48.8835165, 2.3274515, Ligne2 , [Ligne2,Ligne2] ) , 
'Blanche' : Station('Blanche', ['Pigalle','Place de Clichy'] , 48.8834198, 2.3338283, Ligne2 , [Ligne2,Ligne2] ) , 
'Pigalle' : Station('Pigalle', ['Anvers','Blanche'] ,	48.8823612, 2.3373703 , Ligne2 , [Ligne2,Ligne2] ) , 
'Anvers' : Station('Anvers', ['Barbes - Rochechouart','Pigalle'] ,	48.8829026, 2.3443344 , Ligne2 , [Ligne2,Ligne2] ) , 
'Barbes - Rochechouart' : Station('Barbes - Rochechouart', ['La Chapelle','Anvers',] , 	48.8837884, 2.3503457, Ligne2 , [Ligne2,Ligne2] ) , 
'La Chapelle' : Station('La Chapelle', ['Stalingrad [2]','Barbes - Rochechouart','Gare du Nord'] , 48.8844216, 2.3602786, Ligne2 , [Ligne2,Ligne2,LigneM] ) , 
'Gare du Nord' : Station('Gare du Nord', ['La Chapelle'] , 	48.8801863, 2.356, LigneM , [LigneM] ) , 
'Stalingrad [2]' : Station('Stalingrad [2]', ['Jaures','La Chapelle','Stalingrad'] , 48.884287, 2.3659442, Ligne2 , [Ligne2,Ligne2,LigneM] ) , 
'Stalingrad' : Station('Stalingrad', ['Stalingrad [2]'] , 48.884, 2.3659442, LigneM , [LigneM] ) , 
'Jaures' : Station('Jaures', ['Colonel Fabien','Stalingrad [2]'] ,	48.8815632, 2.3702378 , Ligne2 , [Ligne2,Ligne2] ) , 
'Colonel Fabien' : Station('Colonel Fabien', ['Belleville','Jaures'] , 48.8774398, 2.3708174, Ligne2 , [Ligne2,Ligne2] ) , 
'Belleville' : Station('Belleville', ['Couronnes','Colonel Fabien'] , 	48.8720463, 2.3769849, Ligne2 , [Ligne2,Ligne2] ) , 
'Couronnes' : Station('Couronnes', ['Menilmontant','Belleville'] , 	48.8692947, 2.380173, Ligne2 , [Ligne2,Ligne2] ) , 
'Menilmontant' : Station('Menilmontant', ['Pere Lachaise','Couronnes'] , 	48.86649, 2.3833323, Ligne2 , [Ligne2,Ligne2] ) ,
'Pere Lachaise' : Station('Pere Lachaise', ['Philippe Auguste','Menilmontant'] , 48.8628581, 2.3874149, Ligne2 , [Ligne2,Ligne2] ) , 
'Philippe Auguste' : Station('Philippe Auguste', ['Alexandre Dumas','Pere Lachaise'] , 	48.8579976, 2.3909487, Ligne2 , [Ligne2,Ligne2] ) , 
'Alexandre Dumas' : Station('Alexandre Dumas', ['Avron','Philippe Auguste'] , 	48.856264, 2.3945621, Ligne2 , [Ligne2,Ligne2] ) , 
'Avron' : Station('Avron', ['Nation','Alexandre Dumas'] , 48.8514805, 2.3982271, Ligne2 , [Ligne2,Ligne2] ) , 
'Nation' : Station('Nation', ['Avron'] , 48.8483272, 2.395841 , Ligne2 , [Ligne2] )}

Metro3 = {'Pont de Levallois' : Station('Pont de Levallois', ['Anatole France'] ,48.897207, 2.2805328 , Ligne3 , [Ligne3] ) , 
'Anatole France' : Station('Anatole France', ['Louise Michel','Pont de Levallois'] , 48.8921077, 2.2852229, Ligne3 , [Ligne3,Ligne3] ) , 
'Louise Michel' : Station('Louise Michel', ['Porte de Champerret','Anatole France'] , 	48.8887892, 2.2878755, Ligne3 , [Ligne3,Ligne3] ) , 
'Porte de Champerret' : Station('Porte de Champerret', ['Pereire','Louise Michel'] , 	48.8856871, 2.2926417, Ligne3 , [Ligne3,Ligne3] ) , 
'Pereire' : Station('Pereire', ['Wagram','Porte de Champerret'] ,48.884677, 2.2979973 , Ligne3 , [Ligne3,Ligne3] ) , 
'Wagram' : Station('Wagram', ['Malesherbes','Pereire'] , 	48.8840698, 2.3042722, Ligne3 , [Ligne3,Ligne3] ) , 
'Malesherbes' : Station('Malesherbes', ['Villiers','Wagram'] , 48.8825546, 2.3110868, Ligne3 , [Ligne3,Ligne3] ) , 
'Villiers' : Station('Villiers', ['Europe','Malesherbes'] , 48.8812626, 2.3155318, Ligne3 , [Ligne3,Ligne3] ) , 
'Europe' : Station('Europe', ['Saint-Lazare','Villiers'] , 	48.8787437, 2.3224519, Ligne3 , [Ligne3,Ligne3] ) , 
'Saint-Lazare' : Station('Saint-Lazare', ['Havre - Caumartin','Europe'] , 48.875563, 2.3241726, Ligne3 , [Ligne3,Ligne3] ) , 
'Havre - Caumartin' : Station('Havre - Caumartin', ['Opera','Saint-Lazare'] , 48.8737533, 2.3272664, Ligne3 , [Ligne3,Ligne3] ) , 
'Opera' : Station('Opera', ['Quatre-Septembre','Havre - Caumartin'] ,48.8707693, 2.3322643 , Ligne3 , [Ligne3,Ligne3] ) , 
'Quatre-Septembre' : Station('Quatre-Septembre', ['Bourse','Opera'] ,	48.8695654, 2.3367072 , Ligne3 , [Ligne3,Ligne3] ) , 
'Bourse' : Station('Bourse', ['Sentier','Quatre-Septembre'] ,	48.8686692, 2.3412605 , Ligne3 , [Ligne3,Ligne3] ) , 
'Sentier' : Station('Sentier', ['Reaumur - Sebastopol','Bourse'] , 	48.8676419, 2.3463248 , Ligne3 , [Ligne3,Ligne3] ) , 
'Reaumur - Sebastopol' : Station('Reaumur - Sebastopol', ['Arts et Metiers','Sentier'] , 48.866302, 2.3524557, Ligne3, [Ligne3,Ligne3] ) , 
'Arts et Metiers' : Station('Arts et Metiers', ['Temple','Reaumur - Sebastopol'] , 	48.8654878, 2.3563464, Ligne3 , [Ligne3,Ligne3] ) , 
'Temple' : Station('Temple', ['Republique','Arts et Metiers'] , 	48.8660492, 2.3620193, Ligne3 , [Ligne3,Ligne3] ) , 
'Republique' : Station('Republique', ['Parmentier','Temple'] , 	48.8673061, 2.364598, Ligne3 , [Ligne3,Ligne3] ) , 
'Parmentier' : Station('Parmentier', ['Rue Saint-Maur','Republique'] , 	48.8652193, 2.3747542, Ligne3 , [Ligne3,Ligne3] ) , 
'Rue Saint-Maur' : Station('Rue Saint-Maur', ['Pere Lachaise','Parmentier'] , 48.864302, 2.3794597, Ligne3 , [Ligne3,Ligne3] ) , 
'Pere Lachaise' : Station('Pere Lachaise', ['Gambetta','Rue Saint-Maur'] ,	48.8628581, 2.3874149, Ligne3 , [Ligne3,Ligne3] ) , 
'Gambetta' : Station('Gambetta', ['Porte de Bagnolet','Pere Lachaise'] , 	48.86486, 2.3985306, Ligne3 , [Ligne3,Ligne3] ) , 
'Porte de Bagnolet' : Station('Porte de Bagnolet', ['Galieni','Gambetta'] , 48.8642074, 2.4084874, Ligne3 , [Ligne3,Ligne3] ) , 
'Galieni' : Station('Galieni', ['Porte de Bagnolet'] , 	48.8652463, 2.4165383, Ligne3 , [Ligne3] )}

Metro3b = {'Porte des Lilas' : Station('Porte des Lilas', ['Saint-Fargeau'] , 48.8770405, 2.406492, Ligne3b , [Ligne3b] ) , 
'Saint-Fargeau' : Station('Saint-Fargeau', ['Pelleport','Porte des Lilas'] , 	48.8715165, 2.4040581, Ligne3b , [Ligne3b,Ligne3b] ) , 
'Pelleport' : Station('Pelleport', ['Gambetta','Saint-Fargeau'] , 48.8680444, 2.4014574, Ligne3b , [Ligne3b,Ligne3b] ) , 
'Gambetta' : Station('Gambetta', ['Pelleport'] , 	48.86486, 2.3985306, Ligne3b , [Ligne3b] )}

Metro4 = {'Porte de Clignancourt' : Station('Porte de Clignancourt', ['Simplon'] , 48.8973767, 2.3447674, Ligne4 , [Ligne4] ) , 
'Simplon' : Station('Simplon', ['Marcadet Poissoniers','Porte de Clignancourt'] , 	48.8937935, 2.3477372, Ligne4 , [Ligne4,Ligne4] ) , 
'Marcadet Poissoniers' : Station('Marcadet Poissoniers', ['Chateau Rouge', 'Simplon'] , 48.891564, 2.349618 , Ligne4 , [Ligne4,Ligne4] ) ,
'Chateau Rouge' : Station('Chateau Rouge', ['Barbes - Rochechouart','Marcadet Poissoniers'] , 48.8872585, 2.3498228, Ligne4 , [Ligne4,Ligne4] ) , 
'Barbes - Rochechouart' : Station('Barbes - Rochechouart', ['Gare du Nord [4]','Chateau Rouge'] , 48.8837884, 2.3503457, Ligne4 , [Ligne4,Ligne4] ) , 
'Gare du Nord [4]' : Station('Gare du Nord [4]', ['Gare de L\'Est','Barbes - Rochechouart','Gare du Nord'] , 	48.8801863, 2.3542034, Ligne4 , [Ligne4,Ligne4,LigneM] ) , 
'Gare du Nord' : Station('Gare du Nord', ['Gare du Nord [4]'] , 	48.8801863, 2.356, LigneM , [LigneM] ) , 
'Gare de L\'Est' : Station('Gare de L\'Est', ['Chateau d\'Eau','Gare du Nord [4]'] , 48.875955, 2.3574461, Ligne4 , [Ligne4,Ligne4] ) , 
'Chateau d\'Eau' : Station('Chateau d\'Eau', ['Strasbourg - Saint-Denis [4]','Gare de L\'Est'] , 48.8723097, 2.3558518, Ligne4 , [Ligne4,Ligne4] ) , 
'Strasbourg - Saint-Denis [4]' : Station('Strasbourg - Saint-Denis [4]', ['Reaumur - Sebastopol','Chateau d\'Eau','Strasbourg - Saint-Denis'] , 	48.8694199, 2.3544678, Ligne4 , [Ligne4,Ligne4,LigneM] ) , 
'Strasbourg - Saint-Denis' : Station('Strasbourg - Saint-Denis', ['Strasbourg - Saint-Denis [4]'] ,  	48.8694199, 2.3544678    , LigneM , [LigneM] ) , 
'Reaumur - Sebastopol' : Station('Reaumur - Sebastopol', ['Etienne Marcel','Strasbourg - Saint-Denis [4]'] , 	48.866302, 2.3524557, Ligne4 , [Ligne4,Ligne4] ) , 
'Etienne Marcel' : Station('Etienne Marcel', ['Les Halles','Reaumur - Sebastopol'] , 	48.8638408, 2.3487041, Ligne4 , [Ligne4,Ligne4] ) , 
'Les Halles' : Station('Les Halles', ['Chatelet','Etienne Marcel','Chatelet-les-Halles'] , 	48.8624251, 2.3469649, Ligne4 , [Ligne4,Ligne4,LigneM] ) , 
'Chatelet-les-Halles' : Station('Chatelet-les-Halles', ['Les Halles','Chatelet'] ,  	48.8618606, 2.3471814    , LigneM , [LigneM,LigneM] ) , 
'Chatelet' : Station('Chatelet', ['Cite','Les Halles','Chatelet-les-Halles' ] , 	48.858115, 2.3467592, Ligne4 , [Ligne4,Ligne4,LigneM] ) , 
'Cite' : Station('Cite', ['Saint-Michel','Chatelet'] ,	48.8551566, 2.3471977 , Ligne4 , [Ligne4,Ligne4] ) , 
'Saint-Michel' : Station('Saint-Michel', ['Odeon','Cite','Saint-Michel Notre-Dame'] , 	48.8535657, 2.3443622, Ligne4 , [Ligne4,Ligne4,LigneM] ) , 
'Saint-Michel Notre-Dame' : Station('Saint-Michel Notre-Dame', ['Saint-Michel'] ,   	48.8534338, 2.345551   , LigneM , [LigneM] ) , 
'Odeon' : Station('Odeon', ['Saint-Germain-des-Pres','Saint-Michel'] , 	48.8520899, 2.3395308, Ligne4 , [Ligne4,Ligne4] ) , 
'Saint-Germain-des-Pres' : Station('Saint-Germain-des-Pres', ['Saint-Sulpice','Odeon'] , 	48.8536264, 2.333328, Ligne4 , [Ligne4,Ligne4] ) , 
'Saint-Sulpice' : Station('Saint-Sulpice', ['Saint-Placide','Saint-Germain-des-Pres'] , 	48.8514725, 2.3311829, Ligne4 , [Ligne4,Ligne4] ) , 
'Saint-Placide' : Station('Saint-Placide', ['Montparnasse Bienvenue','Saint-Sulpice'] , 	48.8470711, 2.3270822, Ligne4 , [Ligne4,Ligne4] ) , 
'Montparnasse Bienvenue' : Station('Montparnasse Bienvenue', ['Vavin','Saint-Placide'] , 	48.843971, 2.3243262, Ligne4 , [Ligne4,Ligne4] ) , 
'Vavin' : Station('Vavin', ['Raspail','Montparnasse Bienvenue'] , 48.8421852, 2.3289966, Ligne4 , [Ligne4,Ligne4] ) , 
'Raspail' : Station('Raspail', ['Denfert-Rochereau [4]','Vavin'] , 48.8389018, 2.3312032, Ligne4 , [Ligne4,Ligne4] ) , 
'Denfert-Rochereau [4]' : Station('Denfert-Rochereau [4]', ['Mouton-Duvernet','Raspail','Denfert-Rochereau'] , 	48.8341453, 2.333, Ligne4 , [Ligne4,Ligne4,LigneM] ) , 
'Denfert-Rochereau' : Station('Denfert-Rochereau', ['Denfert-Rochereau [4]'] , 48.83375, 2.333, LigneM , [LigneM] ) , #48.8330932, 2.3331828
'Mouton-Duvernet' : Station('Mouton-Duvernet', ['Alesia','Denfert-Rochereau [4]'] ,	48.8313954, 2.3301258, Ligne4 , [Ligne4,Ligne4] ) , 
'Alesia' : Station('Alesia', ['Porte d\'Orleans','Mouton-Duvernet'] , 	48.8278464, 2.3268746, Ligne4 , [Ligne4,Ligne4] ) , 
'Porte d\'Orleans' : Station('Porte d\'Orleans', ['Alesia'] , 	48.82288, 2.3256282, Ligne4 , [Ligne4] )}

Metro5 = {'Bobigny - Pablo Picasso' : Station('Bobigny - Pablo Picasso', ['Bobigny-Pantin Raymond Queneau'] , 	48.9068469, 2.449644, Ligne5 , [Ligne5] ) , 
'Bobigny-Pantin Raymond Queneau' : Station('Bobigny-Pantin Raymond Queneau', ['Eglise de Pantin','Bobigny - Pablo Picasso'] , 48.895749, 2.4257844, Ligne5 , [Ligne5,Ligne5] ) , 
'Eglise de Pantin' : Station('Eglise de Pantin', ['Hoche','Bobigny-Pantin Raymond Queneau'] , 	48.8932335, 2.413176, Ligne5 , [Ligne5,Ligne5] ) , 
'Hoche' : Station('Hoche', ['Porte de Pantin','Eglise de Pantin'] , 	48.891198, 2.4025577, Ligne5 , [Ligne5,Ligne5] ) , 
'Porte de Pantin' : Station('Porte de Pantin', ['Ourcq','Hoche'] ,	48.8885434, 2.3927045 , Ligne5 , [Ligne5,Ligne5] ) , 
'Ourcq' : Station('Ourcq', ['Laumiere','Porte de Pantin'] , 	48.8869632, 2.3867135, Ligne5 , [Ligne5,Ligne5] ) ,
'Laumiere' : Station('Laumiere', ['Jaures','Ourcq'] , 	48.8850187, 2.3795672, Ligne5 , [Ligne5,Ligne5] ) , 
'Jaures' : Station('Jaures', ['Stalingrad [S]','Laumiere'] , 	48.8815632, 2.3702378, Ligne5 , [Ligne5,Ligne5] ) , 
'Stalingrad [S]' : Station('Stalingrad [S]', ['Gare du Nord [5]','Jaures','Stalingrad'] , 48.884, 2.3659442, Ligne5 , [Ligne5,Ligne5,LigneM] ) , 
'Stalingrad' : Station('Stalingrad', ['Stalingrad [S]'] , 48.884, 2.3659442, LigneM , [LigneM] ) , 
'Gare du Nord [5]' : Station('Gare du Nord [5]', ['Gare de L\'Est','Stalingrad [S]','Gare du Nord'] , 	48.8801863, 2.3548034, Ligne5 , [Ligne5,Ligne5,LigneM] ) , 
'Gare du Nord' : Station('Gare du Nord', ['Gare du Nord [5]'] , 	48.8801863, 2.356, LigneM , [LigneM] ) , 
'Gare de L\'Est' : Station('Gare de L\'Est', ['Jacques Bonsergent ','Gare du Nord [5]'] , 48.875955, 2.3579461, Ligne5 , [Ligne5,Ligne5] ) , 
'Jacques Bonsergent ' : Station('Jacques Bonsergent ', ['Republique','Gare de L\'Est'] , 	48.8707855, 2.3611531, Ligne5 , [Ligne5,Ligne5] ) ,
'Republique' : Station('Republique', ['Oberkampf','Jacques Bonsergent '] , 	48.8673061, 2.364598, Ligne5 , [Ligne5,Ligne5] ) , 
'Oberkampf' : Station('Oberkampf', ['Richard Lenoir','Republique'] ,	48.8635343, 2.3699602 , Ligne5 , [Ligne5,Ligne5] ) , 
'Richard Lenoir' : Station('Richard Lenoir', ['Breguet-Sabin','Oberkampf'] , 	48.8602039, 2.3721323, Ligne5 , [Ligne5,Ligne5] ) , 
'Breguet-Sabin' : Station('Breguet-Sabin', ['Bastille','Richard Lenoir'] , 	48.8566261, 2.3705808, Ligne5 , [Ligne5,Ligne5] ) , 
'Bastille' : Station('Bastille', ['Quai de la Rapee','Breguet-Sabin'] , 48.8531671, 2.3689677, Ligne5 , [Ligne5,Ligne5] ) , 
'Quai de la Rapee' : Station('Quai de la Rapee', ['Gare d\'Austerlitz','Bastille'] , 	48.846474, 2.3659107, Ligne5 , [Ligne5,Ligne5] ) ,
'Gare d\'Austerlitz' : Station('Gare d\'Austerlitz', ['Saint-Marcel','Quai de la Rapee'] , 	48.8423263, 2.3655037, Ligne5 , [Ligne5,Ligne5] ) , 
'Saint-Marcel' : Station('Saint-Marcel', ['Campo-Formio','Gare d\'Austerlitz'] ,	48.8382823, 2.3608293 , Ligne5 , [Ligne5,Ligne5] ) , 
'Campo-Formio' : Station('Campo-Formio', ['Place d\'Italie','Saint-Marcel'] , 	48.8356584, 2.3588519, Ligne5 , [Ligne5,Ligne5] ) , 
'Place d\'Italie' : Station('Place d\'Italie', ['Campo-Formio'] , 	48.8314109, 2.3555391, Ligne5 , [Ligne5] )}

Metro6 = {'Charles de Gaulle - Etoile' : Station('Charles de Gaulle - Etoile', ['Kleber'] , 48.8736879, 2.2954454, Ligne6 , [Ligne6] ) , 
'Kleber' : Station('Kleber', ['Boissiere','Charles de Gaulle - Etoile'] , 48.8713645, 2.2935159, Ligne6 , [Ligne6,Ligne6] ) , 
'Boissiere' : Station('Boissiere', ['Trocadero','Kleber'] , 	48.8669099, 2.2902715, Ligne6 , [Ligne6,Ligne6] ) , 
'Trocadero' : Station('Trocadero', ['Passy','Boissiere'] , 	48.8630266, 2.2870524, Ligne6 , [Ligne6,Ligne6] ) , 
'Passy' : Station('Passy', ['Bir-Hakeim','Trocadero'] , 48.8573769, 2.2859072, Ligne6 , [Ligne6,Ligne6] ) , 
'Bir-Hakeim' : Station('Bir-Hakeim', ['Dupleix','Passy'] , 	48.8538901, 2.2893771, Ligne6 , [Ligne6,Ligne6] ) , 
'Dupleix' : Station('Dupleix', ['La Motte-Picquet Grenelle','Bir-Hakeim'] , 48.850409, 2.293655, Ligne6 , [Ligne6,Ligne6] ) , 
'La Motte-Picquet Grenelle' : Station('La Motte-Picquet Grenelle', ['Cambronne','Dupleix'] , 	48.8487835, 2.2988277, Ligne6 , [Ligne6,Ligne6] ) , 
'Cambronne' : Station('Cambronne', ['Sevres Lecourbe','La Motte-Picquet Grenelle'] , 48.8475186, 2.3029504, Ligne6 , [Ligne6,Ligne6] ) , 
'Sevres Lecourbe' : Station('Sevres Lecourbe', ['Pasteur','Cambronne'] , 48.8456025, 2.3096074, Ligne6 , [Ligne6,Ligne6] ) , 
'Pasteur' : Station('Pasteur', ['Montparnasse Bienvenue','Sevres Lecourbe'] , 48.8426472, 2.3128099, Ligne6 , [Ligne6,Ligne6] ) , 
'Montparnasse Bienvenue' : Station('Montparnasse Bienvenue', ['Edgar Quinet','Pasteur'] , 48.8419217, 2.3206828, Ligne6 , [Ligne6,Ligne6] ) , 
'Edgar Quinet' : Station('Edgar Quinet', ['Raspail','Montparnasse Bienvenue'] , 	48.8410654, 2.3249923, Ligne6 , [Ligne6,Ligne6] ) , 
'Raspail' : Station('Raspail', ['Denfert-Rochereau [6]','Edgar Quinet'] , 48.8389018, 2.3308032, Ligne6 , [Ligne6,Ligne6] ) , 
'Denfert-Rochereau [6]' : Station('Denfert-Rochereau [6]', ['St Jacques','Raspail','Denfert-Rochereau'] , 48.8341453, 2.3324, Ligne6 , [Ligne6,Ligne6,LigneM] ) , 
'Denfert-Rochereau' : Station('Denfert-Rochereau', ['Denfert-Rochereau [6]'] , 48.83375, 2.333, LigneM , [LigneM] ) , #48.8330932, 2.3331828
'St Jacques' : Station('St Jacques', ['Glaciere','Denfert-Rochereau [6]'] , 48.8330168, 2.3366295, Ligne6 , [Ligne6,Ligne6] ) , 
'Glaciere' : Station('Glaciere', ['Corvisart','St Jacques'] , 48.8311116, 2.3434618, Ligne6 , [Ligne6,Ligne6] ) , 
'Corvisart' : Station('Corvisart', ['Place d\'Italie','Glaciere'] , 48.8297785, 2.3504704, Ligne6 , [Ligne6,Ligne6] ) , 
'Place d\'Italie' : Station('Place d\'Italie', ['Nationale','Corvisart'] , 48.8314109, 2.3555391, Ligne6 , [Ligne6,Ligne6] ) , 
'Nationale' : Station('Nationale', ['Chevaleret','Place d\'Italie'] , 48.8331919, 2.3628662, Ligne6 , [Ligne6,Ligne6] ) , 
'Chevaleret' : Station('Chevaleret', ['Quai de la Gare','Nationale'] , 48.8349482, 2.3680926, Ligne6 , [Ligne6,Ligne6] ) , 
'Quai de la Gare' : Station('Quai de la Gare', ['Bercy','Chevaleret'] , 	48.837075, 2.3729129, Ligne6 , [Ligne6,Ligne6] ) , 
'Bercy' : Station('Bercy', ['Dugommier','Quai de la Gare'] , 	48.8401067, 2.3799581, Ligne6 , [Ligne6,Ligne6] ) , 
'Dugommier' : Station('Dugommier', ['Daumesnil','Bercy'] , 48.8388865, 2.3897836, Ligne6 , [Ligne6,Ligne6] ) , 
'Daumesnil' : Station('Daumesnil', ['Bel-Air','Dugommier'] , 48.8395253, 2.3958919, Ligne6 , [Ligne6,Ligne6] ) , 
'Bel-Air' : Station('Bel-Air', ['Picpus','Daumesnil'] , 48.8413342, 2.4008884, Ligne6 , [Ligne6,Ligne6] ) , 
'Picpus' : Station('Picpus', ['Nation','Bel-Air'] , 	48.8448796, 2.4014945, Ligne6 , [Ligne6,Ligne6] ) , 
'Nation' : Station('Nation', ['Picpus'] , 48.8483272, 2.395841, Ligne6 , [Ligne6] )}

Metro7 = {'La Courneuve - 8 mai 1945' : Station('La Courneuve - 8 mai 1945', ['Fort d\'Aubervilliers'] , 	48.9208846, 2.4106497, Ligne7 , [Ligne7] ) , 
'Fort d\'Aubervilliers' : Station('Fort d\'Aubervilliers', ['Aubervilliers - Pantin - Quatre Chemins','La Courneuve - 8 mai 1945'] , 	48.9145136, 2.404204, Ligne7 , [Ligne7,Ligne7] ) ,
'Aubervilliers - Pantin - Quatre Chemins' : Station('Aubervilliers - Pantin - Quatre Chemins', ['Porte de la Villette','Fort d\'Aubervilliers'] , 	48.9036536, 2.3921656, Ligne7 , [Ligne7,Ligne7] ) , 
'Porte de la Villette' : Station('Porte de la Villette', ['Corentin Cariou','Aubervilliers - Pantin - Quatre Chemins'] , 	48.8974296, 2.3854377, Ligne7 , [Ligne7,Ligne7] ) , 
'Corentin Cariou' : Station('Corentin Cariou', ['Crimee','Porte de la Villette'] , 	48.8945067, 2.3821116, Ligne7 , [Ligne7,Ligne7] ) , 
'Crimee' : Station('Crimee', ['Riquet','Corentin Cariou'] , 	48.8904888, 2.3767001, Ligne7 , [Ligne7,Ligne7] ) , 
'Riquet' : Station('Riquet', ['Stalingrad [S]','Crimee'] , 	48.8885069, 2.3740693, Ligne7 , [Ligne7,Ligne7] ) , 
'Stalingrad [S]' : Station('Stalingrad [S]', ['Louis Blanc','Riquet','Stalingrad'] , 48.884, 2.3659442, Ligne7 , [Ligne7,Ligne7,LigneM] ) , 
'Stalingrad' : Station('Stalingrad', ['Stalingrad [S]'] , 48.884, 2.3659442, LigneM , [LigneM] ) , 
'Louis Blanc' : Station('Louis Blanc', ['Chateau Landon','Stalingrad [S]'] , 	48.8814188, 2.3654808, Ligne7 , [Ligne7,Ligne7] ) , 
'Chateau Landon' : Station('Chateau Landon', ['Gare de L\'Est','Louis Blanc'] , 	48.8789208, 2.3623079, Ligne7 , [Ligne7,Ligne7] ) , 
'Gare de L\'Est' : Station('Gare de L\'Est', ['Poissonniere','Chateau Landon'] , 	48.875955, 2.3579461, Ligne7 , [Ligne7,Ligne7] ) , 
'Poissonniere' : Station('Poissonniere', ['Cadet','Gare de L\'Est'] ,	48.8772835, 2.349272, Ligne7 , [Ligne7,Ligne7] ) , 
'Cadet' : Station('Cadet', ['Le Peletier','Poissonniere'] ,	48.8759682, 2.3441565, Ligne7 , [Ligne7,Ligne7] ) , 
'Le Peletier' : Station('Le Peletier', ['Chaussee d\'Antin (La Fayette)','Cadet'] , 	48.8749537, 2.3402103, Ligne7 , [Ligne7,Ligne7] ) ,
'Chaussee d\'Antin (La Fayette)' : Station('Chaussee d\'Antin (La Fayette)', ['Opera','Le Peletier'] , 	48.8730612, 2.3333207, Ligne7 , [Ligne7,Ligne7] ) , 
'Opera' : Station('Opera', ['Pyramides','Chaussee d\'Antin (La Fayette)'] , 	48.8707693, 2.3322643, Ligne7 , [Ligne7,Ligne7] ) , 
'Pyramides' : Station('Pyramides', ['Palais Royal - Musee du Louvre','Opera'] , 	48.8656737, 2.3344599, Ligne7 , [Ligne7,Ligne7] ) , 
'Palais Royal - Musee du Louvre' : Station('Palais Royal - Musee du Louvre', ['Pont Neuf','Pyramides'] , 	48.8621984, 2.3366252, Ligne7 , [Ligne7,Ligne7] ) , 
'Pont Neuf' : Station('Pont Neuf', ['Chatelet M7 M11','Palais Royal - Musee du Louvre'] , 	48.8585901, 2.3424101, Ligne7 , [Ligne7,Ligne7] ) , 
'Chatelet M7 M11' : Station('Chatelet M7 M11', ['Pont Marie','Pont Neuf','Chatelet'] , 	48.857247,2.347126, Ligne7 , [Ligne7,Ligne7,LigneM] ) , 
'Chatelet' : Station('Chatelet', ['Chatelet M7 M11' ] , 	48.858115, 2.3467592, LigneM , [LigneM] ) , 
'Pont Marie' : Station('Pont Marie', ['Sully - Morland','Chatelet M7 M11'] ,	48.8535245, 2.3570872 , Ligne7 , [Ligne7,Ligne7] ) , 
'Sully - Morland' : Station('Sully - Morland', ['Jussieu','Pont Marie'] , 	48.851263, 2.3622044, Ligne7 , [Ligne7,Ligne7] ) ,
'Jussieu' : Station('Jussieu', ['Place Monge','Sully - Morland'] , 	48.8460116, 2.3549579, Ligne7 , [Ligne7,Ligne7] ) , 
'Place Monge' : Station('Place Monge', ['Censier Daubenton','Jussieu'] , 	48.8429311, 2.3521239, Ligne7 , [Ligne7,Ligne7] ) , 
'Censier Daubenton' : Station('Censier Daubenton', ['Les Gobelins','Place Monge'] ,	48.8406731, 2.3517801 , Ligne7 , [Ligne7,Ligne7] ) , 
'Les Gobelins' : Station('Les Gobelins', ['Place d\'Italie','Censier Daubenton'] , 	48.8357235, 2.3524541, Ligne7 , [Ligne7,Ligne7] ) , 
'Place d\'Italie' : Station('Place d\'Italie', ['Tolbiac','Les Gobelins'] , 	48.8314109, 2.3555391, Ligne7 , [Ligne7,Ligne7] ) , 
'Tolbiac' : Station('Tolbiac', ['Maison Blanche','Place d\'Italie'] ,	48.8261434, 2.3573719 , Ligne7 , [Ligne7,Ligne7] ) ,
'Maison Blanche' : Station('Maison Blanche', ['Le Kremlin-Bicetre','Tolbiac','Porte d\'Italie'] , 	48.8225268, 2.3585049, Ligne7 , [Ligne7,Ligne7,Ligne7] ) , 
'Le Kremlin-Bicetre' : Station('Le Kremlin-Bicetre', ['Villejuif Leo Lagrange','Maison Blanche'] , 	48.8102884, 2.3622196, Ligne7 , [Ligne7,Ligne7] ) , 
'Villejuif Leo Lagrange' : Station('Villejuif Leo Lagrange', ['Villejuif Paul Vaillant Couturier','Le Kremlin-Bicetre'] , 	48.8051272, 2.3637793, Ligne7 , [Ligne7,Ligne7] ) , 
'Villejuif Paul Vaillant Couturier' : Station('Villejuif Paul Vaillant Couturier', ['Villejuif Louis Aragon','Villejuif Leo Lagrange'] , 	48.7960835, 2.3684011, Ligne7 , [Ligne7,Ligne7] ) , 
'Villejuif Louis Aragon' : Station('Villejuif Louis Aragon', ['Villejuif Paul Vaillant Couturier'] , 48.7869402, 2.3674198, Ligne7 , [Ligne7] ) , 
'Porte d\'Italie' : Station('Porte d\'Italie', ['Porte de Choisy','Maison Blanche'] ,	48.8201302, 2.3605818 , Ligne7 , [Ligne7,Ligne7] ) ,
'Porte de Choisy' : Station('Porte de Choisy', ['Pierre et Marie Curie','Porte d\'Italie'] , 	48.8201086, 2.3647992, Ligne7 , [Ligne7,Ligne7] ) , 
'Pierre et Marie Curie' : Station('Pierre et Marie Curie', ['Mairie d\'Ivry','Porte de Choisy'] , 	48.8159011, 2.3773455, Ligne7 , [Ligne7,Ligne7] ) , 
'Mairie d\'Ivry' : Station('Mairie d\'Ivry', ['Pierre et Marie Curie'] , 	48.8109282, 2.383979, Ligne7 , [Ligne7] )}

Metro7b = {'Louis Blanc' : Station('Louis Blanc', ['Jaures'] ,	48.8814188, 2.3654808 , Ligne7b , [Ligne7b,Ligne7b] ) , 
'Jaures' : Station('Jaures', ['Bolivar','Louis Blanc'] , 	48.8815632, 2.3702378, Ligne7b , [Ligne7b,Ligne7b] ) , 
'Bolivar' : Station('Bolivar', ['Buttes Chaumont','Jaures'] , 48.8809098, 2.374189, Ligne7b , [Ligne7b,Ligne7b] ) ,
'Buttes Chaumont' : Station('Buttes Chaumont', ['Botzaris','Bolivar'] ,	48.8778172, 2.3812985 , Ligne7b , [Ligne7b,Ligne7b] ) , 
'Botzaris' : Station('Botzaris', ['Place des Fetes','Buttes Chaumont'] , 48.8796021, 2.3890954, Ligne7b , [Ligne7b,Ligne7b] ) , 
'Place des Fetes' : Station('Place des Fetes', ['Pre Saint-Gervais'] , 	48.8766403, 2.3927856, Ligne7b , [Ligne7b] ) , 
'Pre Saint-Gervais' : Station('Pre Saint-Gervais', ['Danube'] , 48.880001, 2.398934, Ligne7b , [Ligne7b] ) , 
'Danube' : Station('Danube', ['Botzaris'] , 	48.8819653, 2.3935696, Ligne7b , [Ligne7b] )}

Metro8 = {'Creteil - Prefecture (Hotel de Ville)' : Station('Creteil - Prefecture (Hotel de Ville)', ['Creteil Universite'] , 	48.779827, 2.4594438, Ligne8 , [Ligne8] ) , 
'Creteil Universite' : Station('Creteil Universite', ['Creteil - L\'Echat','Creteil - Prefecture (Hotel de Ville)'] , 	48.7899079, 2.4505143, Ligne8 , [Ligne8,Ligne8] ) , 
'Creteil - L\'Echat' : Station('Creteil - L\'Echat', ['Maisons-Alfort - Les Juiliottes','Creteil Universite'] , 		48.7963595, 2.4492526, Ligne8 , [Ligne8,Ligne8] ) , 
'Maisons-Alfort - Les Juiliottes' : Station('Maisons-Alfort - Les Juiliottes', ['Maisons-Alfort - Stade','Creteil - L\'Echat'] , 	48.8024711, 2.4466949, Ligne8 , [Ligne8,Ligne8] ) , 
'Maisons-Alfort - Stade' : Station('Maisons-Alfort - Stade', ['Ecole Veterinaire de Maisons-Alfort','Maisons-Alfort - Les Juiliottes'] ,	48.8085141, 2.4359918, Ligne8 , [Ligne8,Ligne8] ) , 
'Ecole Veterinaire de Maisons-Alfort' : Station('Ecole Veterinaire de Maisons-Alfort', ['Charenton - Ecoles (Place Aristide Briand)','Maisons-Alfort - Stade'] , 	48.815077, 2.421774, Ligne8 , [Ligne8,Ligne8] ) , 
'Charenton - Ecoles (Place Aristide Briand)' : Station('Charenton - Ecoles (Place Aristide Briand)', ['Liberte','Ecole Veterinaire de Maisons-Alfort'] , 	48.8214689, 2.4136458, Ligne8 , [Ligne8,Ligne8] ) ,
'Liberte' : Station('Liberte', ['Porte de Charenton','Charenton - Ecoles (Place Aristide Briand)'] , 	48.825941, 2.4066522, Ligne8 , [Ligne8,Ligne8] ) , 
'Porte de Charenton' : Station('Porte de Charenton', ['Porte Doree','Liberte'] , 	48.8332306, 2.4013804, Ligne8 , [Ligne8,Ligne8] ) , 
'Porte Doree' : Station('Porte Doree', ['Michel Bizot','Porte de Charenton'] , 	48.8356725, 2.4064062, Ligne8 , [Ligne8,Ligne8] ) , 
'Michel Bizot' : Station('Michel Bizot', ['Daumesnil','Porte Doree'] ,	48.8371074, 2.4024837 , Ligne8 , [Ligne8,Ligne8] ) , 
'Daumesnil' : Station('Daumesnil', ['Montgallet','Michel Bizot'] , 	48.8395253, 2.3958919, Ligne8 , [Ligne8,Ligne8] ) , 
'Montgallet' : Station('Montgallet', ['Reuilly-Diderot','Daumesnil'] , 	48.8444003, 2.3899525, Ligne8 , [Ligne8,Ligne8] ) , 
'Reuilly-Diderot' : Station('Reuilly-Diderot', ['Faidherbe-Chaligny','Montgallet'] , 	48.8472696, 2.3866995, Ligne8 , [Ligne8,Ligne8] ) , 
'Faidherbe-Chaligny' : Station('Faidherbe-Chaligny', ['Ledru-RoLin','Reuilly-Diderot'] , 	48.8500259, 2.3842705, Ligne8 , [Ligne8,Ligne8] ) , 
'Ledru-RoLin' : Station('Ledru-RoLin', ['Bastille','Faidherbe-Chaligny'] , 	48.8511781, 2.3759964, Ligne8 , [Ligne8,Ligne8] ) ,
'Bastille' : Station('Bastille', ['Chemin Vert','Ledru-RoLin'] , 	48.8531671, 2.3689677, Ligne8 , [Ligne8,Ligne8] ) , 
'Chemin Vert' : Station('Chemin Vert', ['Saint-Sebastien - Froissart','Bastille'] , 	48.8575371, 2.367997, Ligne8 , [Ligne8,Ligne8] ) , 
'Saint-Sebastien - Froissart' : Station('Saint-Sebastien - Froissart', ['Filles du Calvaire','Chemin Vert'] ,	48.8608519, 2.3671644, Ligne8 , [Ligne8,Ligne8] ) , 
'Filles du Calvaire' : Station('Filles du Calvaire', ['Republique [b]','Saint-Sebastien - Froissart'] ,	48.8632968, 2.3668726 , Ligne8 , [Ligne8,Ligne8] ) , 
'Republique [b]' : Station('Republique [b]', ['Strasbourg - Saint-Denis [8]','Filles du Calvaire','Republique'] , 	48.8668, 2.364598, Ligne8 , [Ligne8,Ligne8,LigneM] ) , 
'Republique' : Station('Republique', ['Republique [b]'] , 	48.8673061, 2.364598, LigneM , [LigneM] ) , 
'Strasbourg - Saint-Denis [8]' : Station('Strasbourg - Saint-Denis [8]', ['Bonne Nouvelle M8','Republique [b]','Strasbourg - Saint-Denis'] , 	48.8696, 2.3544678, Ligne8 , [Ligne8,Ligne8,LigneM] ) ,
'Strasbourg - Saint-Denis' : Station('Strasbourg - Saint-Denis', ['Strasbourg - Saint-Denis [8]'] ,  	48.8694199, 2.3544678    , LigneM , [LigneM] ) , 
'Bonne Nouvelle M8' : Station('Bonne Nouvelle M8', ['Grands Boulevards M8','Strasbourg - Saint-Denis [8]'] , 	48.8707504, 2.3487793, Ligne8 , [Ligne8,Ligne8] ) , 
'Grands Boulevards M8' : Station('Grands Boulevards M8', ['Richelieu Drouot','Bonne Nouvelle M8'] , 	48.8715206, 2.3432861, Ligne8 , [Ligne8,Ligne8] ) , 
'Richelieu Drouot' : Station('Richelieu Drouot', ['Opera','Grands Boulevards M8'] , 	48.8720005, 2.3402649, Ligne8 , [Ligne8,Ligne8] ) , 
'Opera' : Station('Opera', ['Madeleine [8]','Richelieu Drouot'] , 	48.8707693, 2.3322643, Ligne8 , [Ligne8,Ligne8] ) , 
'Madeleine [8]' : Station('Madeleine [8]', ['Concorde [8]','Opera','Madeleine'] , 	48.8692578, 2.3249, Ligne8 , [Ligne8,Ligne8,LigneM] ) , 
'Madeleine' : Station('Madeleine', ['Madeleine [8]'] , 	48.8692578, 2.3249203, LigneM , [LigneM] ) , 
'Concorde [8]' : Station('Concorde [8]', ['Invalides','Madeleine [8]','Concorde'] , 	48.8664075, 2.321638, Ligne8 , [Ligne8,Ligne8,LigneM] ) ,
'Concorde' : Station('Concorde', ['Concorde [8]'] ,	48.8664075, 2.322138 , LigneM , [LigneM] ) , 
'Invalides' : Station('Invalides', ['La Tour Maubourg','Concorde [8]'] ,	48.861177, 2.3148333 , Ligne8 , [Ligne8,Ligne8] ) , 
'La Tour Maubourg' : Station('La Tour Maubourg', ['Ecole Militaire','Invalides'] , 	48.857642, 2.3102242, Ligne8 , [Ligne8,Ligne8] ) , 
'Ecole Militaire' : Station('Ecole Militaire', ['La Motte-Picquet Grenelle','La Tour Maubourg'] , 	48.8543836, 2.3060528, Ligne8 , [Ligne8,Ligne8] ) , 
'La Motte-Picquet Grenelle' : Station('La Motte-Picquet Grenelle', ['Commerce','Ecole Militaire'] , 	48.8487835, 2.2988277, Ligne8 , [Ligne8,Ligne8] ) , 
'Commerce' : Station('Commerce', ['Felix Faure','La Motte-Picquet Grenelle'] , 	48.8446404, 2.2937045, Ligne8 , [Ligne8,Ligne8] ) , 
'Felix Faure' : Station('Felix Faure', ['Boucicaut','Commerce'] ,	48.8427009, 2.2919602 , Ligne8 , [Ligne8,Ligne8] ) , 
'Boucicaut' : Station('Boucicaut', ['Lourmel','Felix Faure'] , 	48.8410215, 2.2879564, Ligne8 , [Ligne8,Ligne8] ) , 
'Lourmel' : Station('Lourmel', ['Balard','Boucicaut'] , 	48.838709, 2.2821744, Ligne8 , [Ligne8,Ligne8] ) , 
'Balard' : Station('Balard', ['Lourmel'] , 	48.8363496, 2.2784721, Ligne8 , [Ligne8] )}

Metro9 = {'Pont de Sevres' : Station('Pont de Sevres', ['Billancourt'] , 	48.8296613, 2.2308732, Ligne9 , [Ligne9] ) , 
'Billancourt' : Station('Billancourt', ['Marcel Sembat','Pont de Sevres'] , 	48.8320798, 2.2382521, Ligne9 , [Ligne9,Ligne9] ) , 
'Marcel Sembat' : Station('Marcel Sembat', ['Porte de Saint-Cloud','Billancourt'] , 	48.8339081, 2.2438908, Ligne9 , [Ligne9,Ligne9] ) , 
'Porte de Saint-Cloud' : Station('Porte de Saint-Cloud', ['Exelmans','Marcel Sembat'] , 	48.8377707, 2.2565741, Ligne9 , [Ligne9,Ligne9] ) , 
'Exelmans' : Station('Exelmans', ['Michel-Ange - Molitor','Porte de Saint-Cloud'] , 	48.8430044, 2.2600472, Ligne9 , [Ligne9,Ligne9] ) , 
'Michel-Ange - Molitor' : Station('Michel-Ange - Molitor', ['Michel-Ange - Auteuil','Exelmans'] , 	48.8452505, 2.2618802, Ligne9 , [Ligne9,Ligne9] ) , 
'Michel-Ange - Auteuil' : Station('Michel-Ange - Auteuil', ['Jasmin','Michel-Ange - Molitor'] , 	48.8480038, 2.2641872, Ligne9 , [Ligne9,Ligne9] ) , 
'Jasmin' : Station('Jasmin', ['Ranelagh','Michel-Ange - Auteuil'] , 	48.8525598, 2.2681802, Ligne9 , [Ligne9,Ligne9] ) , 
'Ranelagh' : Station('Ranelagh', ['La Muette','Jasmin'] ,	48.8555764, 2.2702166 , Ligne9 , [Ligne9,Ligne9] ) , 
'La Muette' : Station('La Muette', ['Rue de la Pompe','Ranelagh'] , 	48.8580816, 2.2741958, Ligne9 , [Ligne9,Ligne9] ) , 
'Rue de la Pompe' : Station('Rue de la Pompe', ['Trocadero','La Muette'] , 	48.8640063, 2.2780859, Ligne9 , [Ligne9,Ligne9] ) , 
'Trocadero' : Station('Trocadero', ['Iena','Rue de la Pompe'] , 	48.8630266, 2.2870524, Ligne9 , [Ligne9,Ligne9] ) , 
'Iena' : Station('Iena', ['Alma Marceau','Trocadero'] , 	48.8646725, 2.2937783, Ligne9 , [Ligne9,Ligne9] ) , 
'Alma Marceau' : Station('Alma Marceau', ['Franklin D.Roosevelt','Iena'] , 	48.8649686, 2.3006256, Ligne9 , [Ligne9,Ligne9] ) , 
'Franklin D.Roosevelt' : Station('Franklin D.Roosevelt', ['Saint-Philippe du Roule','Alma Marceau'] , 	48.8689538, 2.3101679, Ligne9 , [Ligne9,Ligne9] ) , 
'Saint-Philippe du Roule' : Station('Saint-Philippe du Roule', ['Miromesnil','Franklin D.Roosevelt'] , 	48.8723362, 2.3100827, Ligne9 , [Ligne9,Ligne9] ) , 
'Miromesnil' : Station('Miromesnil', ['Saint-Augustin','Saint-Philippe du Roule'] , 48.8736768, 2.3145456, Ligne9 , [Ligne9,Ligne9] ) , 
'Saint-Augustin' : Station('Saint-Augustin', ['Havre - Caumartin','Miromesnil'] ,	48.874703, 2.3197963 , Ligne9 , [Ligne9,Ligne9] ) , 
'Havre - Caumartin' : Station('Havre - Caumartin', ['Chaussee d\'Antin (La Fayette)','Saint-Augustin'] , 	48.8737533, 2.3272664, Ligne9 , [Ligne9,Ligne9] ) , 
'Chaussee d\'Antin (La Fayette)' : Station('Chaussee d\'Antin (La Fayette)', ['Richelieu Drouot','Havre - Caumartin'] , 	48.8730612, 2.3333207, Ligne9 , [Ligne9,Ligne9] ) , 
'Richelieu Drouot' : Station('Richelieu Drouot', ['Grands Boulevards M9','Chaussee d\'Antin (La Fayette)'] , 	48.8720005, 2.3402649, Ligne9 , [Ligne9,Ligne9] ) , 
'Grands Boulevards M9' : Station('Grands Boulevards M9', ['Bonne Nouvelle M9','Richelieu Drouot'] , 	48.871, 2.3432861, Ligne9 , [Ligne9,Ligne9] ) , 
'Bonne Nouvelle M9' : Station('Bonne Nouvelle M9', ['Strasbourg - Saint-Denis [9]','Grands Boulevards M9'] ,	48.8700004, 2.3487793 , Ligne9 , [Ligne9,Ligne9] ) , 
'Strasbourg - Saint-Denis [9]' : Station('Strasbourg - Saint-Denis [9]', ['Republique [b]','Bonne Nouvelle M9','Strasbourg - Saint-Denis'] , 	48.8692, 2.3544678, Ligne9 , [Ligne9,Ligne9,LigneM] ) , 
'Strasbourg - Saint-Denis' : Station('Strasbourg - Saint-Denis', ['Strasbourg - Saint-Denis [9]'] ,  	48.8694199, 2.3544678    , LigneM , [LigneM] ) , 
'Republique [b]' : Station('Republique [b]', ['Oberkampf','Strasbourg - Saint-Denis [9]','Republique'] , 	48.8668, 2.364598, Ligne9 , [Ligne9,Ligne9,LigneM] ) , 
'Republique' : Station('Republique', ['Republique [b]'] , 	48.8673061, 2.364598, LigneM , [LigneM] ) , 
'Oberkampf' : Station('Oberkampf', ['Saint-Ambroise','Republique [b]'] ,	48.8635343, 2.3699602 , Ligne9 , [Ligne9,Ligne9] ) , 
'Saint-Ambroise' : Station('Saint-Ambroise', ['Voltaire','Oberkampf'] , 	48.8610516, 2.3747956, Ligne9 , [Ligne9,Ligne9] ) , 
'Voltaire' : Station('Voltaire', ['Charonne','Saint-Ambroise'] , 	48.858158, 2.3798044, Ligne9 , [Ligne9,Ligne9] ) , 
'Charonne' : Station('Charonne', ['Rue des Boulets','Voltaire'] ,	48.8547441, 2.3853565 , Ligne9 , [Ligne9,Ligne9] ) , 
'Rue des Boulets' : Station('Rue des Boulets', ['Nation','Charonne'] ,	48.8525808, 2.3887914 , Ligne9 , [Ligne9,Ligne9] ) , 
'Nation' : Station('Nation', ['Buzenval','Rue des Boulets'] ,	48.8483272, 2.395841 , Ligne9 , [Ligne9,Ligne9] ) , 
'Buzenval' : Station('Buzenval', ['Maraichers','Nation'] , 	48.8518166, 2.4013757, Ligne9 , [Ligne9,Ligne9] ) , 
'Maraichers' : Station('Maraichers', ['Porte de Montreuil','Buzenval'] , 	48.8527168, 2.4062388, Ligne9 , [Ligne9,Ligne9] ) , 
'Porte de Montreuil' : Station('Porte de Montreuil', ['Robespierre','Maraichers'] , 	48.8534759, 2.4105242, Ligne9 , [Ligne9,Ligne9] ) , 
'Robespierre' : Station('Robespierre', ['Croix de Chavaux','Porte de Montreuil'] , 	48.8558145, 2.4237108, Ligne9 , [Ligne9,Ligne9] ) , 
'Croix de Chavaux' : Station('Croix de Chavaux', ['Mairie de Montreuil','Robespierre'] , 	48.857946, 2.4357587, Ligne9 , [Ligne9,Ligne9] ) , 
'Mairie de Montreuil' : Station('Mairie de Montreuil', ['Croix de Chavaux'] , 	48.8625988, 2.441569, Ligne9 , [Ligne9] )}

Metro10 = {'Boulogne - Pont de Saint-Cloud' : Station('Boulogne - Pont de Saint-Cloud', ['Boulogne - Jean Jaures'], 48.840669, 2.2287175, Ligne10 , [Ligne10] ) , 
'Boulogne - Jean Jaures' : Station('Boulogne - Jean Jaures', ['Michel-Ange - Molitor', 'Boulogne - Pont de Saint-Cloud'], 	48.8420002, 2.2387333, Ligne10 , [Ligne10,Ligne10] ) , 
'Michel-Ange - Molitor' : Station('Michel-Ange - Molitor', ['Chardon Lagache' ],	48.8452505, 2.2618802 , Ligne10 , [Ligne10] ) , 
'Chardon Lagache' : Station('Chardon Lagache', ['Mirabeau'], 48.845267, 2.2672606, Ligne10 , [Ligne10] ) , 
'Mirabeau' : Station('Mirabeau', ['Javel - Andre Citroen'], 	48.8470891, 2.2728475, Ligne10 , [Ligne10] ) , 
'Eglise d\'Auteuil' : Station('Eglise d\'Auteuil', ['Michel-Ange - Auteuil'], 48.8472607, 2.2689372 , Ligne10 , [Ligne10] ) , 
'Michel-Ange - Auteuil' : Station('Michel-Ange - Auteuil', ['Porte d\'Auteuil'], 48.8480038, 2.2641872, Ligne10 , [Ligne10] ) , 
'Porte d\'Auteuil' : Station('Porte d\'Auteuil', ['Boulogne - Jean Jaures'], 48.8477655, 2.2583922, Ligne10 , [Ligne10] ) , 
'Javel - Andre Citroen' : Station('Javel - Andre Citroen', ['Eglise d\'Auteuil', 'Charles Michels'], 48.8462613, 2.2790398, Ligne10 , [Ligne10,Ligne10] ) , 
'Charles Michels' : Station('Charles Michels', ['Javel - Andre Citroen', 'Avenue Emile Zola'], 	48.8466987, 2.2859833, Ligne10 , [Ligne10,Ligne10] ) , 
'Avenue Emile Zola' : Station('Avenue Emile Zola', ['Charles Michels','La Motte-Picquet Grenelle'], 	48.8470463, 2.2953101 , Ligne10 , [Ligne10,Ligne10] ) ,  
'La Motte-Picquet Grenelle' : Station('La Motte-Picquet Grenelle', ['Avenue Emile Zola','Segur',] , 	48.8487835, 2.2988277, Ligne10 , [Ligne10,Ligne10] ) , 
'Segur' : Station('Segur', ['La Motte-Picquet Grenelle','Duroc'], 48.8470802, 2.3076354, Ligne10 , [Ligne10,Ligne10] ) , 
'Duroc' : Station('Duroc', ['Segur','Vaneau'], 48.8468543, 2.3166512, Ligne10 , [Ligne10,Ligne10] ) , 
'Vaneau' : Station('Vaneau', ['Duroc','Sevres Babylone'], 48.8491398, 2.3218984, Ligne10 , [Ligne10,Ligne10] ) , 
'Sevres Babylone' : Station('Sevres Babylone', ['Vaneau','Mabillon'], 	48.8514587, 2.3267159, Ligne10 , [Ligne10,Ligne10] ) , 
'Mabillon' : Station('Mabillon', ['Sevres Babylone','Odeon'],	48.8529427, 2.3357457 , Ligne10 , [Ligne10,Ligne10] ) , 
'Odeon' : Station('Odeon', ['Mabillon','Cluny - La Sorbonne'], 	48.8520899, 2.3395308, Ligne10 , [Ligne10,Ligne10] ) , 
'Cluny - La Sorbonne' : Station('Cluny - La Sorbonne', ['Odeon','Maubert Mutualite','Saint-Michel Notre-Dame'],	48.8508926, 2.3454617 , Ligne10 , [Ligne10,Ligne10,LigneM] ) , 
'Saint-Michel Notre-Dame' : Station('Saint-Michel Notre-Dame', ['Cluny - La Sorbonne'] ,   	48.8534338, 2.345551   , LigneM , [LigneM] ) , 
'Maubert Mutualite' : Station('Maubert Mutualite', ['Cluny - La Sorbonne','Cardinal Lemoine'], 48.8499051, 2.348746, Ligne10 , [Ligne10,Ligne10] ) , 
'Cardinal Lemoine' : Station('Cardinal Lemoine', ['Maubert Mutualite','Jussieu'], 48.8465082, 2.3517283, Ligne10 , [Ligne10,Ligne10] ) , 
'Jussieu' : Station('Jussieu', ['Cardinal Lemoine','Gare d\'Austerlitz'], 48.8460116, 2.3549579, Ligne10 , [Ligne10,Ligne10] ) , 
'Gare d\'Austerlitz' : Station('Gare d\'Austerlitz', ['Jussieu'],48.8423263, 2.3655037 , Ligne10 , [Ligne10] )}

Metro11 = {'Chatelet M7 M11' : Station('Chatelet M7 M11', ['Hotel de Ville','Chatelet'] , 	48.857247,2.347126, Ligne11 , [Ligne11,LigneM] ) , 
'Chatelet' : Station('Chatelet', ['Chatelet M7 M11' ] , 	48.858115, 2.3467592, LigneM , [LigneM] ) , 
'Hotel de Ville' : Station('Hotel de Ville', ['Rambuteau','Chatelet M7 M11'] , 	48.8572265, 2.3521708, Ligne11 , [Ligne11,Ligne11] ) , 
'Rambuteau' : Station('Rambuteau', ['Arts et Metiers','Hotel de Ville'] ,48.861274, 2.3535761 , Ligne11 , [Ligne11,Ligne11] ) , 
'Arts et Metiers' : Station('Arts et Metiers', ['Republique','Rambuteau'] , 48.8654878, 2.3563464, Ligne11 , [Ligne11,Ligne11] ) , 
'Republique' : Station('Republique', ['Goncourt','Arts et Metiers'] , 	48.8673061, 2.364598, Ligne11 , [Ligne11,Ligne11] ) ,  
'Goncourt' : Station('Goncourt', ['Belleville','Republique'] , 	48.8700162, 2.3710617, Ligne11 , [Ligne11,Ligne11] ) , 
'Belleville' : Station('Belleville', ['Pyrenees','Goncourt'] , 	48.8720463, 2.3769849, Ligne11 , [Ligne11,Ligne11] ) , 
'Pyrenees' : Station('Pyrenees', ['Jourdain','Belleville'] ,	48.8738195, 2.3849935 , Ligne11 , [Ligne11,Ligne11] ) , 
'Jourdain' : Station('Jourdain', ['Place des Fetes','Pyrenees'] ,	48.8751161, 2.3892322 , Ligne11 , [Ligne11,Ligne11] ) , 
'Place des Fetes' : Station('Place des Fetes', ['Telegraphe','Jourdain'] , 	48.8766403, 2.3927856, Ligne11 , [Ligne11,Ligne11] ) , 
'Telegraphe' : Station('Telegraphe', ['Porte des Lilas','Place des Fetes'] , 	48.8756525, 2.3991459, Ligne11 , [Ligne11,Ligne11] ) , 
'Porte des Lilas' : Station('Porte des Lilas', ['Mairie des Lilas','Telegraphe'] ,	48.8770405, 2.406492, Ligne11 , [Ligne11,Ligne11] ) , 
'Mairie des Lilas' : Station('Mairie des Lilas',['Porte des Lilas'], 	48.8797147, 2.4162805, Ligne11 , [Ligne11] )}

Metro12 = {'Porte de la Chapelle' : Station('Porte de la Chapelle', ['Marx Dormoy'] , 	48.8977084, 2.3592969, Ligne12 , [Ligne12] ) , 
'Marx Dormoy' : Station('Marx Dormoy', ['Marcadet Poissoniers','Porte de la Chapelle'] , 	48.8902891, 2.359805, Ligne12 , [Ligne12,Ligne12] ) , 
'Marcadet Poissoniers' : Station('Marcadet Poissoniers', ['Jules Joffrin', 'Marx Dormoy'] , 48.891564, 2.349618 , Ligne12 , [Ligne12,Ligne12] ) ,
'Jules Joffrin' : Station('Jules Joffrin', ['Lamarck-Caulaincourt','Marcadet Poissoniers'] , 	48.8924166, 2.3443983, Ligne12 , [Ligne12,Ligne12] ) , 
'Lamarck-Caulaincourt' : Station('Lamarck-Caulaincourt', ['Abbesses','Jules Joffrin'] , 	48.8898183, 2.3386296, Ligne12 , [Ligne12,Ligne12] ) , 
'Abbesses' : Station('Abbesses', ['Pigalle','Lamarck-Caulaincourt'] , 	48.884412, 2.3386344, Ligne12 , [Ligne12,Ligne12] ) , 
'Pigalle' : Station('Pigalle', ['Saint-Georges','Abbesses'] , 	48.8823612, 2.3373703, Ligne12 , [Ligne12,Ligne12] ) , 
'Saint-Georges' : Station('Saint-Georges', ['Notre-Dame de Lorette','Pigalle'] , 	48.8784365, 2.3376521, Ligne12 , [Ligne12,Ligne12] ) , 
'Notre-Dame de Lorette' : Station('Notre-Dame de Lorette', ['Trinite d\'Estienne d\'Orves','Saint-Georges'] , 	48.8760654, 2.3385532, Ligne12 , [Ligne12,Ligne12] ) , 
'Trinite d\'Estienne d\'Orves' : Station('Trinite d\'Estienne d\'Orves', ['Saint-Lazare','Notre-Dame de Lorette'] ,	48.8763705, 2.332631 , Ligne12 , [Ligne12,Ligne12] ) , 
'Saint-Lazare' : Station('Saint-Lazare', ['Madeleine [d]','Trinite d\'Estienne d\'Orves'] , 	48.8756733, 2.3273522, Ligne12 , [Ligne12,Ligne12] ) , 
'Madeleine [d]' : Station('Madeleine [d]', ['Concorde [d]','Saint-Lazare','Madeleine'] , 	48.8692578, 2.3249203, Ligne12 , [Ligne12,Ligne12,LigneM] ) ,
'Madeleine' : Station('Madeleine', ['Madeleine [d]'] , 	48.8692578, 2.3249203, LigneM , [LigneM] ) , 
'Concorde [d]' : Station('Concorde [d]', ['Assemblee Nationale','Madeleine [d]','Concorde'] ,	48.8664075, 2.322638 , Ligne12 , [Ligne12,Ligne12,LigneM] ) , 
'Concorde' : Station('Concorde', ['Concorde [d]'] ,	48.8664075, 2.322138 , LigneM , [LigneM] ) , 
'Assemblee Nationale' : Station('Assemblee Nationale', ['Solferino','Concorde [d]'] , 	48.8612186, 2.3203273, Ligne12 , [Ligne12,Ligne12] ) , 
'Solferino' : Station('Solferino', ['Rue du Bac','Assemblee Nationale'] , 	48.8586775, 2.3231168, Ligne12 , [Ligne12,Ligne12] ) , 
'Rue du Bac' : Station('Rue du Bac', ['Sevres Babylone','Solferino'] , 	48.8557241, 2.3256659, Ligne12 , [Ligne12,Ligne12] ) , 
'Sevres Babylone' : Station('Sevres Babylone', ['Rennes','Rue du Bac'] , 48.8514587, 2.3267159, Ligne12 , [Ligne12,Ligne12] ) , 
'Rennes' : Station('Rennes', ['Notre-Dame-des-Champs','Sevres Babylone'] , 	48.8481026, 2.3277965, Ligne12 , [Ligne12,Ligne12] ) , 
'Notre-Dame-des-Champs' : Station('Notre-Dame-des-Champs', ['Montparnasse Bienvenue','Rennes'] ,	48.8452766, 2.3286613 , Ligne12 , [Ligne12,Ligne12] ) , 
'Montparnasse Bienvenue' : Station('Montparnasse Bienvenue', ['Falguiere','Notre-Dame-des-Champs'] ,	48.843971, 2.3243262 , Ligne12 , [Ligne12,Ligne12] ) , 
'Falguiere' : Station('Falguiere', ['Pasteur','Montparnasse Bienvenue'] , 	48.8443954, 2.3175634, Ligne12 , [Ligne12,Ligne12] ) , 
'Pasteur' : Station('Pasteur', ['Volontaires','Falguiere'] , 	48.8426472, 2.3128099, Ligne12 , [Ligne12,Ligne12] ) , 
'Volontaires' : Station('Volontaires', ['Vaugirard','Pasteur'] , 	48.8415118, 2.308012, Ligne12 , [Ligne12,Ligne12] ) , 
'Vaugirard' : Station('Vaugirard', ['Convention','Volontaires'] , 	48.839625, 2.3014373, Ligne12 , [Ligne12,Ligne12] ) , 
'Convention' : Station('Convention', ['Porte de Versailles','Vaugirard'] , 	48.8372483, 2.2964937, Ligne12 , [Ligne12,Ligne12] ) , 
'Porte de Versailles' : Station('Porte de Versailles', ['Corentin Celton','Convention'] , 	48.8326135, 2.2884024, Ligne12 , [Ligne12,Ligne12] ) , 
'Corentin Celton' : Station('Corentin Celton', ['Mairie d\'Issy','Porte de Versailles'] , 	48.8270162, 2.2794048, Ligne12 , [Ligne12,Ligne12] ) , 
'Mairie d\'Issy' : Station('Mairie d\'Issy', ['Corentin Celton'] , 	48.8242325, 2.2730847, Ligne12 , [Ligne12] )}

Metro13 = {'Saint Denis Universite' : Station('Saint Denis Universite', ['Basilique de Saint Denis'] , 48.9459311, 2.3641518, Ligne13 , [Ligne13] ) , 
'Basilique de Saint Denis' : Station('Basilique de Saint Denis', ['Saint Denis Porte de Paris','Saint Denis Universite'] , 	48.9366572, 2.3590191, Ligne13 , [Ligne13,Ligne13] ) , 
'Saint Denis Porte de Paris' : Station('Saint Denis Porte de Paris', ['Carrefour Pleyel','Basilique de Saint Denis'] ,	48.9301278, 2.3563841 , Ligne13 , [Ligne13,Ligne13] ) , 
'Carrefour Pleyel' : Station('Carrefour Pleyel', ['Mairie de Saint-Ouen','Saint Denis Porte de Paris'] , 	48.9196049, 2.3429933, Ligne13 , [Ligne13,Ligne13] ) , 
'Mairie de Saint-Ouen' : Station('Mairie de Saint-Ouen', ['Garibaldi','Carrefour Pleyel'] , 	48.9118944, 2.3339725, Ligne13 , [Ligne13,Ligne13] ) , 
'Garibaldi' : Station('Garibaldi', ['Porte de Saint-Ouen','Mairie de Saint-Ouen'] , 	48.9061915, 2.3320476, Ligne13 , [Ligne13,Ligne13] ) , 
'Porte de Saint-Ouen' : Station('Porte de Saint-Ouen', ['Guy Moquet','Garibaldi'] , 	48.8973729, 2.3290349, Ligne13 , [Ligne13,Ligne13] ) , 
'Guy Moquet' : Station('Guy Moquet', ['La Fourche','Porte de Saint-Ouen'] , 	48.8927063, 2.3274728, Ligne13 , [Ligne13,Ligne13] ) , 
'Asnieres - GenneVilliers - Les Courtilles' : Station('Asnieres - GenneVilliers - Les Courtilles', ['Les Agnettes'] , 	48.9305465, 2.2836436, Ligne13 , [Ligne13] ) , 
'Les Agnettes' : Station('Les Agnettes', ['Gabriel Peri','Asnieres - GenneVilliers - Les Courtilles'] , 	48.9231172, 2.2862019, Ligne13 , [Ligne13,Ligne13] ) , 
'Gabriel Peri' : Station('Gabriel Peri', ['Mairie de Clichy','Les Agnettes'] ,	48.916248 ,  2.2948596 , Ligne13 , [Ligne13,Ligne13] ) , 
'Mairie de Clichy' : Station('Mairie de Clichy', ['Porte de Clichy','Gabriel Peri'] , 	48.9038952, 2.3053664, Ligne13 , [Ligne13,Ligne13] ) , 
'Porte de Clichy' : Station('Porte de Clichy', ['Brochant','Mairie de Clichy'] , 	48.8939713, 2.3143932, Ligne13 , [Ligne13,Ligne13] ) , 
'Brochant' : Station('Brochant', ['La Fourche','Porte de Clichy'] , 	48.890517, 2.3201235, Ligne13 , [Ligne13,Ligne13] ) , 
'La Fourche' : Station('La Fourche', ['Place de Clichy','Guy Moquet','Brochant'] , 	48.8874127, 2.3256961, Ligne13 , [Ligne13,Ligne13,Ligne13] ) , 
'Place de Clichy' : Station('Place de Clichy', ['Liege','La Fourche'] , 	48.8835165, 2.3274515, Ligne13 , [Ligne13,Ligne13] ) , 
'Liege' : Station('Liege', ['Saint-Lazare','Place de Clichy'] , 	48.8795976, 2.3270787, Ligne13 , [Ligne13,Ligne13] ) , 
'Saint-Lazare' : Station('Saint-Lazare', ['Miromesnil','Liege'] , 	48.8754744, 2.3254192, Ligne13 , [Ligne13,Ligne13] ) , 
'Miromesnil' : Station('Miromesnil', ['Champs-Elysees Clemenceau','Saint-Lazare'] , 	48.8736768, 2.3145456, Ligne13 , [Ligne13,Ligne13] ) , 
'Champs-Elysees Clemenceau' : Station('Champs-Elysees Clemenceau', ['Invalides','Miromesnil'] , 	48.8678333, 2.3137075, Ligne13 , [Ligne13,Ligne13] ) , 
'Invalides' : Station('Invalides', ['Varenne','Champs-Elysees Clemenceau'] , 	48.861177, 2.3148333, Ligne13 , [Ligne13,Ligne13] ) , 
'Varenne' : Station('Varenne', ['Saint-Francois-Xavier','Invalides'] , 	48.8568058, 2.3151577, Ligne13 , [Ligne13,Ligne13] ) , 
'Saint-Francois-Xavier' : Station('Saint-Francois-Xavier', ['Duroc','Varenne'] , 	48.8514, 2.3143901, Ligne13 , [Ligne13,Ligne13] ) , 
'Duroc' : Station('Duroc', ['Montparnasse Bienvenue','Saint-Francois-Xavier'] , 	48.8468543, 2.3166512, Ligne13 , [Ligne13,Ligne13] ) , 
'Montparnasse Bienvenue' : Station('Montparnasse Bienvenue', ['Gaite','Duroc'] , 	48.8421956, 2.3211526, Ligne13 , [Ligne13,Ligne13] ) , 
'Gaite' : Station('Gaite', ['Pernety','Montparnasse Bienvenue'] , 	48.8385876, 2.3222085, Ligne13 , [Ligne13,Ligne13] ) , 
'Pernety' : Station('Pernety', ['Plaisance','Gaite'] ,	48.8339551, 2.3180764 , Ligne13 , [Ligne13,Ligne13] ) , 
'Plaisance' : Station('Plaisance', ['Porte de Vanves','Pernety'] , 	48.8317799, 2.3140252, Ligne13 , [Ligne13,Ligne13] ) , 
'Porte de Vanves' : Station('Porte de Vanves', ['Malakoff - Plateau de Vanves','Plaisance'] , 	48.8278135, 2.3054765, Ligne13 , [Ligne13,Ligne13] ) , 
'Malakoff - Plateau de Vanves' : Station('Malakoff - Plateau de Vanves', ['Malakoff - Rue Etienne Dolet','Porte de Vanves'] , 	48.822078, 2.2979835, Ligne13 , [Ligne13,Ligne13] ) , 
'Malakoff - Rue Etienne Dolet' : Station('Malakoff - Rue Etienne Dolet', ['Chatillon-Montrouge','Malakoff - Plateau de Vanves'] , 	48.8153367, 2.2970255, Ligne13 , [Ligne13,Ligne13] ) , 
'Chatillon-Montrouge' : Station('Chatillon-Montrouge', ['Malakoff - Rue Etienne Dolet'] , 	48.810815, 2.3016518, Ligne13 , [Ligne13] )}

Metro14 = {'Saint-Lazare' : Station('Saint-Lazare', ['Madeleine [q]'] , 	48.8754744, 2.3254192, Ligne14 , [Ligne14] ) , 
'Madeleine [q]' : Station('Madeleine [q]', ['Pyramides','Saint-Lazare','Madeleine'] , 48.8692578, 2.3255203, Ligne14 , [Ligne14,Ligne14,LigneM] ) , 
'Madeleine' : Station('Madeleine', ['Madeleine [q]'] , 	48.8692578, 2.3249203, LigneM , [LigneM] ) , 
'Pyramides' : Station('Pyramides', ['Chatelet','Madeleine [q]'] , 	48.8656737, 2.3344599, Ligne14 , [Ligne14,Ligne14] ) , 
'Chatelet' : Station('Chatelet', ['Gare de Lyon [q]','Pyramides'] , 48.858743,2.347383, Ligne14 , [Ligne14,Ligne14] ) , 
'Gare de Lyon [q]' : Station('Gare de Lyon [q]', ['Bercy','Chatelet','Gare de Lyon'] , 	48.8454843, 2.3728519, Ligne14 , [Ligne14,Ligne14,LigneM] ) , 
'Gare de Lyon' : Station('Gare de Lyon', ['Gare de Lyon [q]'] ,   48.8452 , 2.373   , LigneM , [LigneM] ) , 
'Bercy' : Station('Bercy', ['Cour Saint-Emilion','Gare de Lyon [q]'] , 48.8401067, 2.3799581, Ligne14 , [Ligne14,Ligne14] ) , 
'Cour Saint-Emilion' : Station('Cour Saint-Emilion', ['Bibliotheque Francois Mitterrand', 'Bercy',] , 	48.8333982, 2.38585, Ligne14 , [Ligne14,Ligne14] ) , 
'Bibliotheque Francois Mitterrand' : Station('Bibliotheque Francois Mitterrand', ['Olympiades','Cour Saint-Emilion'] , 	48.8298519, 2.3756248, Ligne14 , [Ligne14,Ligne14] ) , 
'Olympiades' : Station('Olympiades', ['Bibliotheque Francois Mitterrand'] , 	48.8268585, 2.3662544, Ligne14 , [Ligne14] )}

Metro = [Metro1,Metro2,Metro3,Metro4,Metro5,Metro6,Metro7,Metro8,Metro9,Metro10,Metro11,Metro12,Metro13,Metro14,Metro3b,Metro7b]

RerA = {'Cergy Le Haut' : Station('Cergy Le Haut', ['Cergy Saint-Christophe'] ,  	49.048774 , 2.0124088    , RERA , [RERA] ) , 
'Cergy Saint-Christophe' : Station('Cergy Saint-Christophe', ['Cergy Le Haut','Cergy Prefecture'] ,   	49.049583, 2.0346913   , RERA , [RERA,RERA] ) , 
'Cergy Prefecture' : Station('Cergy Prefecture', ['Cergy Saint-Christophe','Neuville Universite'] ,  	49.0365298, 2.0793378    , RERA , [RERA,RERA] ) , 
'Neuville Universite' : Station('Neuville Universite', ['Cergy Prefecture','Conflans-Fin-d\'Oise'] ,  	49.0142738, 2.0782802    , RERA , [RERA,RERA] ) , 
'Conflans-Fin-d\'Oise' : Station('Conflans-Fin-d\'Oise', ['Neuville Universite','Acheres - Ville'] ,   48.9899163, 2.0740508   , RERA , [RERA,RERA] ) , 
'Acheres - Ville' : Station('Acheres - Ville', ['Conflans-Fin-d\'Oise','Maisons-Laffitte'] ,   	48.9701883, 2.0777518   , RERA , [RERA,RERA] ) , 

'Poissy' : Station('Poissy', ['Acheres-Grand Cormier'] ,   	48.933064 , 2.040206   , RERA , [RERA] ) , 
'Acheres-Grand Cormier' : Station('Acheres-Grand Cormier', ['Maisons-Laffitte','Poissy'] ,   	48.9552489, 2.09262   , RERA , [RERA,RERA] ) , 

'Maisons-Laffitte' : Station('Maisons-Laffitte', ['Acheres - Ville','Acheres-Grand Cormier','Sartrouville'] ,   	48.9458096, 2.1445481   , RERA , [RERA,RERA,RERA] ) , 
'Sartrouville' : Station('Sartrouville', ['Maisons-Laffitte','Houilles - Carrieres-Sur-Seine'] ,    	48.9378067, 2.1572739  , RERA , [RERA,RERA] ) , 
'Houilles - Carrieres-Sur-Seine' : Station('Houilles - Carrieres-Sur-Seine', ['Sartrouville','Nanterre Prefecture'] ,   	48.9203471, 2.1854282   , RERA , [RERA,RERA] ) , 

'Saint-Germain-en-Laye' : Station('Saint-Germain-en-Laye', ['Le Vesinet - Le Pecq'] ,   	48.8981518, 2.0950189   , RERA , [RERA] ) , 
'Le Vesinet - Le Pecq' : Station('Le Vesinet - Le Pecq', ['Saint-Germain-en-Laye','Le Vesinet Centre'] ,  	48.8980141, 2.1220723    , RERA , [RERA,RERA] ) , 
'Le Vesinet Centre' : Station('Le Vesinet Centre', ['Le Vesinet - Le Pecq','Chatou - Croissy'] ,    	48.890087, 2.1345588  , RERA , [RERA,RERA] ) , 
'Chatou - Croissy' : Station('Chatou - Croissy', ['Le Vesinet Centre','Rueil-Malmaison'] ,    	48.8852013, 2.156203  , RERA , [RERA,RERA] ) , 
'Rueil-Malmaison' : Station('Rueil-Malmaison', ['Chatou - Croissy','Nanterre - Ville'] ,  	48.8872413, 2.1715541   , RERA , [RERA,RERA] ) , 
'Nanterre - Ville' : Station('Nanterre - Ville', ['Rueil-Malmaison','Nanterre Universite'] ,    	48.8954627, 2.1964459  , RERA , [RERA,RERA] ) , 
'Nanterre Universite' : Station('Nanterre Universite', ['Nanterre - Ville','Nanterre Prefecture'] ,  	48.9015272, 2.2152996    , RERA , [RERA,RERA] ) , 

'Nanterre Prefecture' : Station('Nanterre Prefecture', ['Houilles - Carrieres-Sur-Seine','Nanterre Universite','La Defense - Grande Arche [R]'] ,  	48.8965744, 2.2235453    , RERA , [RERA,RERA,RERA] ) , 
'La Defense - Grande Arche [R]' : Station('La Defense - Grande Arche [R]', ['Nanterre Prefecture','Charles de Gaulle - Etoile','La Defense - Grande Arche'] ,    	48.8920139, 2.2379331  , RERA , [RERA,RERA,LigneM] ) , 
'La Defense - Grande Arche' : Station('La Defense - Grande Arche', ['La Defense - Grande Arche [R]'] ,    	48.8920139, 2.2379331  , LigneM , [LigneM] ) , 
'Charles de Gaulle - Etoile' : Station('Charles de Gaulle - Etoile', ['La Defense - Grande Arche [R]','Auber'] ,   	48.8736879, 2.2954454   , RERA , [RERA,RERA] ) , 
'Auber' : Station('Auber', ['Charles de Gaulle - Etoile','Chatelet-les-Halles','Opera','Havre - Caumartin'] ,  	48.8726843, 2.3300719    , LigneM , [RERA,RERA,LigneM,LigneM] ) , 
'Opera' : Station('Opera', ['Auber'] , 	48.8707693, 2.3322643, LigneM , [LigneM] ) , 
'Havre - Caumartin' : Station('Havre - Caumartin', ['Auber'] , 	48.8737533, 2.3272664, LigneM , [LigneM] ) , 
'Chatelet-les-Halles' : Station('Chatelet-les-Halles', ['Auber','Gare de Lyon [R]'] ,   	48.8618606, 2.3471814   , RERA , [RERA,RERA] ) , 
'Gare de Lyon [R]' : Station('Gare de Lyon [R]', ['Chatelet-les-Halles','Nation','Gare de Lyon'] ,   48.8448 , 2.3735   , RERA , [RERA,RERA,LigneM] ) , 
'Gare de Lyon' : Station('Gare de Lyon', ['Gare de Lyon [R]'] ,   48.8452 , 2.373   , LigneM , [LigneM] ) , 
'Nation' : Station('Nation', ['Gare de Lyon [R]','Vincennes'] ,   	48.8483272, 2.395841   , RERA , [RERA,RERA] ) , 
'Vincennes' : Station('Vincennes', ['Nation','Fontenay-sous-Bois','Val de Fontenay'] ,   	48.8472967, 2.4329588   , RERA , [RERA,RERA,RERA] ) , 

'Fontenay-sous-Bois' : Station('Fontenay-sous-Bois', ['Vincennes','Nogent-sur-Marne'] ,  	48.8434176, 2.4644147    , RERA , [RERA,RERA] ) , 
'Nogent-sur-Marne' : Station('Nogent-sur-Marne', ['Fontenay-sous-Bois','Joinville-le-Pont'] ,  		48.8346912, 2.4717824   , RERA , [RERA,RERA] ) , 
'Joinville-le-Pont' : Station('Joinville-le-Pont', ['Nogent-sur-Marne','Saint-Maur Creteil'] ,  	48.8208782, 2.4636031    , RERA , [RERA,RERA] ) , 
'Saint-Maur Creteil' : Station('Saint-Maur Creteil', ['Joinville-le-Pont','Parc de Saint-Maur'] ,  48.8063758, 2.4722367    , RERA , [RERA,RERA] ) , 
'Parc de Saint-Maur' : Station('Parc de Saint-Maur', ['Saint-Maur Creteil','Champigny - Saint Maur'] ,  48.805076 , 2.485608    , RERA , [RERA,RERA] ) , 
'Champigny - Saint Maur' : Station('Champigny - Saint Maur', ['Parc de Saint-Maur','La Varenne - Chennevieres'] ,    	48.8069486, 2.5099793  , RERA , [RERA,RERA] ) , 
'La Varenne - Chennevieres' : Station('La Varenne - Chennevieres', ['Champigny - Saint Maur','Sucy - Bonneuil'] ,   	48.7952095, 2.5129738   , RERA , [RERA,RERA] ) , 
'Sucy - Bonneuil' : Station('Sucy - Bonneuil', ['La Varenne - Chennevieres','Boissy Saint-Leger'] ,  	48.7707531, 2.5079977    , RERA , [RERA,RERA] ) , 
'Boissy Saint-Leger' : Station('Boissy Saint-Leger', ['Sucy - Bonneuil'] ,   	48.7525892, 2.5047511   , RERA , [RERA] ) , 

'Val de Fontenay' : Station('Val de Fontenay', ['Vincennes','Neuilly-Plaisance'] ,    48.85431 , 2.48914  , RERA , [RERA,RERA] ) , 
'Neuilly-Plaisance' : Station('Neuilly-Plaisance', ['Val de Fontenay','Bry-sur-Marne'] ,  	48.8534323, 2.5138089    , RERA , [RERA,RERA] ) , 
'Bry-sur-Marne' : Station('Bry-sur-Marne', ['Neuilly-Plaisance','Noisy-le-Grand'] ,   	48.8446359, 2.5261501   , RERA , [RERA,RERA] ) , 
'Noisy-le-Grand' : Station('Noisy-le-Grand', ['Bry-sur-Marne','Noisy Champs'] ,   	48.8406852, 2.5458661   , RERA , [RERA,RERA] ) , 
'Noisy Champs' : Station('Noisy Champs', ['Noisy-le-Grand','Noisiel Le Luzard'] ,   	48.8427731, 2.5790492   , RERA , [RERA,RERA] ) , 
'Noisiel Le Luzard' : Station('Noisiel Le Luzard', ['Noisy Champs','Lognes'] ,   	48.8434831, 2.6163935   , RERA , [RERA,RERA] ) , 
'Lognes' : Station('Lognes', ['Noisiel Le Luzard','Torcy'] ,   	48.8391017, 2.6336867   , RERA , [RERA,RERA] ) , 
'Torcy' : Station('Torcy', ['Lognes','Bussy-Saint-Georges'] , 	48.839553, 2.6543891     , RERA , [RERA,RERA] ) , 
'Bussy-Saint-Georges' : Station('Bussy-Saint-Georges', ['Torcy','Val d\'Europe'] ,   	48.8367012, 2.7104316   , RERA , [RERA,RERA] ) , 
'Val d\'Europe' : Station('Val d\'Europe', ['Bussy-Saint-Georges','Marne-la-Vallee Chessy - Parc Disneyland'] ,   	48.8548178, 2.7724193   , RERA , [RERA,RERA] ) , 
'Marne-la-Vallee Chessy - Parc Disneyland' : Station('Marne-la-Vallee Chessy - Parc Disneyland', ['Val d\'Europe'] ,   	48.8697927, 2.7822376   , RERA , [RERA] )}

RerB = {'Aeroport Charles de Gaulle 2 TGV' : Station('Aeroport Charles de Gaulle 2 TGV', ['Aeroport Charles de Gaulle 1'] , 	49.0040334, 2.5708952 , RERB , [RERB] ) , 
'Aeroport Charles de Gaulle 1' : Station('Aeroport Charles de Gaulle 1', ['Aeroport Charles de Gaulle 2 TGV','Parc des Expositions'] ,    	49.0098, 2.5612866  , RERB , [RERB,RERB] ) , 
'Parc des Expositions' : Station('Parc des Expositions', ['Aeroport Charles de Gaulle 1','Villepinte'] ,  	48.9734537, 2.5144353    , RERB , [RERB,RERB] ) , 
'Villepinte' : Station('Villepinte', ['Parc des Expositions','Sevran - Beaudottes'] ,    	48.9627429, 2.5126385  , RERB , [RERB,RERB] ) , 
'Sevran - Beaudottes' : Station('Sevran - Beaudottes', ['Villepinte','Aulnay-sous-Bois'] ,    	48.947563, 2.5246969  , RERB , [RERB,RERB] ) , 

'Mitry-Claye' : Station('Mitry-Claye', ['Villeparisis-Mitry le Neuf'] ,   	48.9758734, 2.642295   , RERB , [RERB] ) , 
'Villeparisis-Mitry le Neuf' : Station('Villeparisis-Mitry le Neuf', ['Vert-Galant','Mitry-Claye'] ,   	48.9529326, 2.6026233   , RERB , [RERB,RERB] ) , 
'Vert-Galant' : Station('Vert-Galant', ['Sevran-Livry','Villeparisis-Mitry le Neuf'] ,   	48.9443428, 2.5672683   , RERB , [RERB,RERB] ) , 
'Sevran-Livry' : Station('Sevran-Livry', ['Aulnay-sous-Bois','Vert-Galant'] ,   	48.9364113, 2.5348372   , RERB , [RERB,RERB] ) , 

'Aulnay-sous-Bois' : Station('Aulnay-sous-Bois', ['Sevran - Beaudottes','Sevran-Livry','Le Blanc-Mesnil'] ,  	48.9322068, 2.4950402    , RERB , [RERB,RERB,RERB] ) , 
'Le Blanc-Mesnil' : Station('Le Blanc-Mesnil', ['Drancy','Aulnay-sous-Bois'] ,    	48.9324074, 2.4763359  , RERB , [RERB,RERB] ) , 
'Drancy' : Station('Drancy', ['Le Bourget','Le Blanc-Mesnil'] ,   	48.9326839, 2.4548599   , RERB , [RERB,RERB] ) , 
'Le Bourget' : Station('Le Bourget', ['La Courneuve - Aubervilliers','Drancy'] ,   48.9308053, 2.4262059   , RERB , [RERB,RERB] ) , 
'La Courneuve - Aubervilliers' : Station('La Courneuve - Aubervilliers', ['La Plaine Stade de France','Le Bourget'] ,  	48.9244564, 2.386533   , RERB , [RERB,RERB] ) , 
'La Plaine Stade de France' : Station('La Plaine Stade de France', ['Gare du Nord [R]','La Courneuve - Aubervilliers'] ,   	48.9182399, 2.3624012   , RERB , [RERB,RERB] ) , 

'Gare du Nord [R]' : Station('Gare du Nord [R]', ['Chatelet-les-Halles','La Plaine Stade de France','Gare du Nord'] ,   	48.880804, 2.3573389   , RERB , [RERB,RERB,LigneM] ) , 
'Gare du Nord' : Station('Gare du Nord', ['Gare du Nord [R]'] , 	48.8801863, 2.356, LigneM , [LigneM] ) , 
'Chatelet-les-Halles' : Station('Chatelet-les-Halles', ['Saint-Michel Notre-Dame','Gare du Nord [R]'] ,  	48.8618606, 2.3471814    , RERB , [RERB,RERB] ) , 

'Saint-Michel Notre-Dame' : Station('Saint-Michel Notre-Dame', ['Chatelet-les-Halles','Luxembourg','Cluny - La Sorbonne'] ,   	48.8534338, 2.345551   , RERB , [RERB,RERB,LigneM] ) , 
'Cluny - La Sorbonne' : Station('Cluny - La Sorbonne', ['Saint-Michel Notre-Dame'],	48.8508926, 2.3454617 , LigneM , [LigneM] ) , 
'Luxembourg' : Station('Luxembourg', ['Saint-Michel Notre-Dame','Port-Royal'] ,  	48.8466573, 2.3406504    , RERB , [RERB,RERB] ) , 
'Port-Royal' : Station('Port-Royal', ['Luxembourg','Denfert-Rochereau [R]'] ,   	48.8399322, 2.3370615   , RERB , [RERB,RERB] ) , 
'Denfert-Rochereau [R]' : Station('Denfert-Rochereau [R]', ['Port-Royal','Cite Universitaire','Denfert-Rochereau'] ,   	48.8330932, 2.3331828   , RERB , [RERB,RERB,LigneM] ) , 
'Denfert-Rochereau' : Station('Denfert-Rochereau', ['Denfert-Rochereau [R]'] , 48.83375, 2.333, LigneM , [LigneM] ) , 
'Cite Universitaire' : Station('Cite Universitaire', ['Denfert-Rochereau [R]','Gentilly'] ,  	48.8205925, 2.3390267    , RERB , [RERB,RERB] ) , 
'Gentilly' : Station('Gentilly', ['Cite Universitaire','Laplace'] ,    48.816104, 2.340581  , RERB , [RERB,RERB] ) , 
'Laplace' : Station('Laplace', ['Gentilly','Arcueil Cachan'] ,   	48.8078487, 2.333765   , RERB , [RERB,RERB] ) , 
'Arcueil Cachan' : Station('Arcueil Cachan', ['Laplace','Bagneux'] ,   	48.7986051, 2.3281001   , RERB , [RERB,RERB] ) , 
'Bagneux' : Station('Bagneux', ['Arcueil Cachan','Bourg-la-Reine'] ,  	48.7932705, 2.3215943    , RERB , [RERB,RERB] ) , 
'Bourg-la-Reine' : Station('Bourg-la-Reine', ['Bagneux','Sceaux','Parc de Sceaux'] ,   48.780216, 2.312335  , RERB , [RERB,RERB,RERB] ) , 

'Sceaux' : Station('Sceaux', ['Bourg-la-Reine','Fontenay-aux-Roses'] ,  	48.7814841, 2.2973475    , RERB , [RERB,RERB] ) , 
'Fontenay-aux-Roses' : Station('Fontenay-aux-Roses', ['Sceaux','Robinson'] ,    	48.7876484, 2.2922921  , RERB , [RERB,RERB] ) , 
'Robinson' : Station('Robinson', ['Fontenay-aux-Roses'] ,   	48.7800883, 2.2813056   , RERB , [RERB] ) , 

'Parc de Sceaux' : Station('Parc de Sceaux', ['Bourg-la-Reine','La Croix de Berny'] ,  	48.7701979, 2.3101213    , RERB , [RERB,RERB] ) , 
'La Croix de Berny' : Station('La Croix de Berny', ['Parc de Sceaux','Antony'] ,   	48.7621742, 2.3044902   , RERB , [RERB,RERB] ) , 
'Antony' : Station('Antony', ['La Croix de Berny','Fontaine Michalon'] ,   48.754864 , 2.300915   , RERB , [RERB,RERB] ) , 
'Fontaine Michalon' : Station('Fontaine Michalon', ['Antony','Les Baconnets'] ,   	48.7432722, 2.2962791   , RERB , [RERB,RERB] ) , 
'Les Baconnets' : Station('Les Baconnets', ['Fontaine Michalon','Massy-Verrieres'] ,    	48.7395724, 2.2873942  , RERB , [RERB,RERB] ) , 
'Massy-Verrieres' : Station('Massy-Verrieres', ['Les Baconnets','Massy-Palaiseau'] ,   48.734407 , 2.273631 , RERB , [RERB,RERB] ) , 
'Massy-Palaiseau' : Station('Massy-Palaiseau', ['Massy-Verrieres','Palaiseau'] ,   48.724114 , 2.259434   , RERB , [RERB,RERB] ) , 
'Palaiseau' : Station('Palaiseau', ['Massy-Palaiseau','Palaiseau-Villebon'] ,   	48.7178575, 2.2464627  , RERB , [RERB,RERB] ) , 
'Palaiseau-Villebon' : Station('Palaiseau-Villebon', ['Palaiseau','Lozere'] ,   	48.7076819, 2.237149   , RERB , [RERB,RERB] ) , 
'Lozere' : Station('Lozere', ['Palaiseau-Villebon','Le Guichet'] ,   	48.7060013, 2.2116884   , RERB , [RERB,RERB] ) , 
'Le Guichet' : Station('Le Guichet', ['Lozere','Orsay-Ville'] ,   	48.7049598, 2.1917229   , RERB , [RERB,RERB] ) , 
'Orsay-Ville' : Station('Orsay-Ville', ['Le Guichet','Bures-sur-Yvette'] ,    	48.6976144, 2.1817799  , RERB , [RERB,RERB] ) , 
'Bures-sur-Yvette' : Station('Bures-sur-Yvette', ['Orsay-Ville','La Hacquiniere'] ,   	48.695674, 2.1631058   , RERB , [RERB,RERB] ) , 
'La Hacquiniere' : Station('La Hacquiniere', ['Bures-sur-Yvette','Gif-sur-Yvette'] ,  	48.6949696, 2.1526331    , RERB , [RERB,RERB] ) , 
'Gif-sur-Yvette' : Station('Gif-sur-Yvette', ['La Hacquiniere','Courcelle-sur-Yvette'] ,   	48.6981859, 2.1367431   , RERB , [RERB,RERB] ) , 
'Courcelle-sur-Yvette' : Station('Courcelle-sur-Yvette', ['Gif-sur-Yvette','Saint-Remy-les-Chevreuse'] ,    	48.7008969, 2.0990597  , RERB , [RERB,RERB] ) , 
'Saint-Remy-les-Chevreuse' : Station('Saint-Remy-les-Chevreuse', ['Courcelle-sur-Yvette'] ,  	48.7026946, 2.0709319    , RERB , [RERB] )}

RerD = {'Creil' : Station('Creil', ['Chantilly - Gouvieux'] , 49.263832, 2.4688052 , RERD , [RERD] ) ,
'Chantilly - Gouvieux' : Station('Chantilly - Gouvieux', ['Orry-la-Ville - Coye','Creil'] , 	49.1876205, 2.4594655 , RERD , [RERD,RERD] ) ,
'Orry-la-Ville - Coye' : Station('Orry-la-Ville - Coye', ['La Borne Blanche','Chantilly - Gouvieux'] ,	49.13816, 2.4903877  , RERD , [RERD,RERD] ) ,
'La Borne Blanche' : Station('La Borne Blanche', ['Survilliers - Fosses','Orry-la-Ville - Coye'] ,	49.126985, 2.5058656  , RERD , [RERD,RERD] ) ,
'Survilliers - Fosses' : Station('Survilliers - Fosses', ['Louvres','La Borne Blanche'] , 	49.0991631, 2.5255538 , RERD , [RERD,RERD] ) ,
'Louvres' : Station('Louvres', ['Les Noues','Survilliers - Fosses'] , 	49.0496313, 2.5019088 , RERD , [RERD,RERD] ) ,
'Les Noues' : Station('Les Noues', ['Goussainville','Louvres'] , 	49.0323213, 2.4764758 , RERD , [RERD,RERD] ) ,
'Goussainville' : Station('Goussainville', ['Villiers-le-Bel - Gonesse - Arnouville','Les Noues'] ,	49.0240491, 2.4632777  , RERD , [RERD,RERD] ) ,
'Villiers-le-Bel - Gonesse - Arnouville' : Station('Villiers-le-Bel - Gonesse - Arnouville', ['Garges - Sarcelles','Goussainville'] , 	48.9933783, 2.4161529 , RERD , [RERD,RERD] ) ,
'Garges - Sarcelles' : Station('Garges - Sarcelles', ['Pierrefitte - Stains','Villiers-le-Bel - Gonesse - Arnouville'] , 	48.9766899, 2.3906474 , RERD , [RERD,RERD] ) ,
'Pierrefitte - Stains' : Station('Pierrefitte - Stains', ['Saint Denis','Garges - Sarcelles'] , 	48.9639248, 2.3721537 , RERD , [RERD,RERD] ) ,
'Saint Denis' : Station('Saint Denis', ['Stade de France - Saint Denis','Pierrefitte - Stains'] , 	48.9350187, 2.3455189 , RERD , [RERD,RERD] ) ,
'Stade de France - Saint Denis' : Station('Stade de France - Saint Denis', ['Gare du Nord [R]','Saint Denis'] , 	48.9177476, 2.3504555 , RERD , [RERD,RERD] ) ,
'Gare du Nord [R]' : Station('Gare du Nord [R]', ['Chatelet-les-Halles [D]','Stade de France - Saint Denis','Gare du Nord'] ,   	48.880804, 2.3573389   , RERD , [RERD,RERD,LigneM] ) , 
'Gare du Nord' : Station('Gare du Nord', ['Gare du Nord [R]'] , 	48.8801863, 2.356, LigneM , [LigneM] ) , 
'Chatelet-les-Halles [D]' : Station('Chatelet-les-Halles [D]', ['Gare de Lyon [R]','Gare du Nord [R]','Chatelet-les-Halles'] ,  	48.8617606, 2.3478814    , RERD , [RERD,RERD,LigneM] ) , 
'Chatelet-les-Halles' : Station('Chatelet-les-Halles', ['Chatelet-les-Halles [D]'] ,  	48.8618606, 2.3471814    , LigneM , [LigneM] ) , 
'Gare de Lyon [R]' : Station('Gare de Lyon [R]', ['Maisons-Alfort - Alfortville','Chatelet-les-Halles [D]','Gare de Lyon'] ,   48.8448 , 2.3735   , RERD , [RERD,RERD,LigneM] ) , 
'Gare de Lyon' : Station('Gare de Lyon', ['Gare de Lyon [R]'] ,   48.8452 , 2.373   , LigneM , [LigneM] ) , 
'Maisons-Alfort - Alfortville' : Station('Maisons-Alfort - Alfortville', ['Le Vert de Maisons','Gare de Lyon [R]'] , 	48.8019826, 2.4264134 , RERD , [RERD,RERD] ) ,
'Le Vert de Maisons' : Station('Le Vert de Maisons', ['Villeneuve - Prairie','Maisons-Alfort - Alfortville'] , 48.7882986, 2.4321634 , RERD , [RERD,RERD] ) ,
'Villeneuve - Prairie' : Station('Villeneuve - Prairie', ['Villeneuve - Triage','Le Vert de Maisons'] ,48.7640325, 2.4334868  , RERD , [RERD,RERD] ) ,
'Villeneuve - Triage' : Station('Villeneuve - Triage', ['Villeneuve-Saint-Georges','Villeneuve - Prairie'] , 	48.7447669, 2.4384821 , RERD , [RERD,RERD] ) ,

'Villeneuve-Saint-Georges' : Station('Villeneuve-Saint-Georges', ['Montgeron - Crosne','Villeneuve - Triage','Vigneux-sur-Seine'] , 	48.7301511, 2.4461601 , RERD , [RERD,RERD,RERD] ) ,

'Montgeron - Crosne' : Station('Montgeron - Crosne', ['Yerres','Villeneuve-Saint-Georges'] , 	48.7082091, 2.4622634 , RERD , [RERD,RERD] ) ,
'Yerres' : Station('Yerres', ['Brunoy','Montgeron - Crosne'] , 	48.7064508, 2.4833787 , RERD , [RERD,RERD] ) ,
'Brunoy' : Station('Brunoy', ['Boussy-Saint-Antoine','Yerres'] , 	48.6990338, 2.5066895 , RERD , [RERD,RERD] ) ,
'Boussy-Saint-Antoine' : Station('Boussy-Saint-Antoine', ['Combs-la-Ville - Quincy','Brunoy'] , 	48.6810597, 2.5330582 , RERD , [RERD,RERD] ) ,
'Combs-la-Ville - Quincy' : Station('Combs-la-Ville - Quincy', ['Lieusaint - Moissy','Boussy-Saint-Antoine'] , 	48.6683385, 2.5474467 , RERD , [RERD,RERD] ) ,
'Lieusaint - Moissy' : Station('Lieusaint - Moissy', ['Savigny-le-Temple - Nandy','Combs-la-Ville - Quincy'] , 	48.628246, 2.5695709 , RERD , [RERD,RERD] ) ,
'Savigny-le-Temple - Nandy' : Station('Savigny-le-Temple - Nandy', ['Cesson','Lieusaint - Moissy'] , 	48.5955618, 2.5839163 , RERD , [RERD,RERD] ) ,
'Cesson' : Station('Cesson', ['Le Mee-sur-Seine','Savigny-le-Temple - Nandy'] , 	48.5655032, 2.5942856 , RERD , [RERD,RERD] ) ,
'Le Mee-sur-Seine' : Station('Le Mee-sur-Seine', ['Melun','Cesson'] , 	48.5385843, 2.6257568 , RERD , [RERD,RERD] ) ,
'Melun' : Station('Melun', ['Le Mee-sur-Seine','Vosves'] , 	48.5274239, 2.6546474 , RERD , [RERD,RERD] ) ,

'Vigneux-sur-Seine' : Station('Vigneux-sur-Seine', ['Juvisy-sur-Orge','Villeneuve-Saint-Georges'] , 	48.7083345, 2.4143195 , RERD , [RERD,RERD] ) ,
'Juvisy-sur-Orge' : Station('Juvisy-sur-Orge', ['Viry-Chatillon','Vigneux-sur-Seine'] , 48.689097, 2.3828135 , RERD , [RERD,RERD] ) ,
'Viry-Chatillon' : Station('Viry-Chatillon', ['Grigny-Centre','Juvisy-sur-Orge','Ris-Orangis'] , 48.6762006, 2.3866872 , RERD , [RERD,RERD,RERD] ) ,

'Ris-Orangis' : Station('Ris-Orangis', ['Le Grand-Bourg','Viry-Chatillon'] , 	48.6589822, 2.4154085 , RERD , [RERD,RERD] ) ,
'Le Grand-Bourg' : Station('Le Grand-Bourg', ['Evry Val de Seine','Ris-Orangis'] , 	48.648061, 2.4359515 , RERD , [RERD,RERD] ) ,
'Evry Val de Seine' : Station('Evry Val de Seine', ['Corbeil-Essonnes','Le Grand-Bourg'] , 	48.6344947, 2.4522297 , RERD , [RERD,RERD] ) ,

'Grigny-Centre' : Station('Grigny-Centre', ['Orangis - Bois de l\'Epine','Viry-Chatillon'] , 	48.6542109, 2.3965308 , RERD , [RERD,RERD] ) ,
'Orangis - Bois de l\'Epine' : Station('Orangis - Bois de l\'Epine', ['Evry-Courcouronnes Centre','Grigny-Centre'] , 	48.6363475, 2.4077596 , RERD , [RERD,RERD] ) ,
'Evry-Courcouronnes Centre' : Station('Evry-Courcouronnes Centre', ['Le Bras-de-Fer - Evry - Genopole','Orangis - Bois de l\'Epine'] , 	48.6258547, 2.4288843 , RERD , [RERD,RERD] ) ,
'Le Bras-de-Fer - Evry - Genopole' : Station('Le Bras-de-Fer - Evry - Genopole', ['Corbeil-Essonnes','Evry-Courcouronnes Centre'] , 	48.6232855, 2.4520374 , RERD , [RERD,RERD] ) ,

'Corbeil-Essonnes' : Station('Corbeil-Essonnes', ['Moulin-Galant','Le Bras-de-Fer - Evry - Genopole','Essonnes - Robinson','Evry Val de Seine'] , 	48.6140264, 2.4738694 , RERD , [RERD,RERD,RERD,RERD] ) ,

'Essonnes - Robinson' : Station('Essonnes - Robinson', ['Villabe','Corbeil-Essonnes'] , 48.606158, 2.463635 , RERD , [RERD,RERD] ) ,
'Villabe' : Station('Villabe', ['Le Plessis-Chenet','Essonnes - Robinson'] , 	48.5929492, 2.4615679 , RERD , [RERD,RERD] ) ,
'Le Plessis-Chenet' : Station('Le Plessis-Chenet', ['Le Coudray Montceaux','Villabe'] , 	48.5735622, 2.479568 , RERD , [RERD,RERD] ) ,
'Le Coudray Montceaux' : Station('Le Coudray Montceaux', ['Saint Fargeau','Le Plessis-Chenet'] , 	48.5664641, 2.4911383 , RERD , [RERD,RERD] ) ,
'Saint Fargeau' : Station('Saint Fargeau', ['Ponthierry Pringy','Le Coudray Montceaux'] , 	48.5591866, 2.538056 , RERD , [RERD,RERD] ) ,
'Ponthierry Pringy' : Station('Ponthierry Pringy', ['Boissise-le-Roi','Saint Fargeau'] , 	48.5347751, 2.5458171 , RERD , [RERD,RERD] ) ,
'Boissise-le-Roi' : Station('Boissise-le-Roi', ['Vosves','Ponthierry Pringy'] ,	48.5288359, 2.5742339  , RERD , [RERD,RERD] ) ,
'Vosves' : Station('Vosves', ['Melun','Boissise-le-Roi'] , 	48.5152079, 2.5980361 , RERD , [RERD,RERD] ) ,


'Moulin-Galant' : Station('Moulin-Galant', ['Mennecy','Corbeil-Essonnes'] , 	48.5866159, 2.4735267 , RERD , [RERD,RERD] ) ,
'Mennecy' : Station('Mennecy', ['Ballancourt-sur-Essonne','Moulin-Galant'] ,  	48.5710638, 2.4330931, RERD , [RERD,RERD] ) ,
'Ballancourt-sur-Essonne' : Station('Ballancourt-sur-Essonne', ['La Ferte-Alais','Mennecy'] , 	48.5321637, 2.3711049 , RERD , [RERD,RERD] ) ,
'La Ferte-Alais' : Station('La Ferte-Alais', ['Boutigny','Ballancourt-sur-Essonne'] ,	48.484767, 2.3517835  , RERD , [RERD,RERD] ) ,
'Boutigny' : Station('Boutigny', ['Maisse','La Ferte-Alais'] , 	48.4348564, 2.3762291 , RERD , [RERD,RERD] ) ,
'Maisse' : Station('Maisse', ['Buno - Gironville','Boutigny'] , 	48.3936795, 2.393423 , RERD , [RERD,RERD] ) ,
'Buno - Gironville' : Station('Buno - Gironville', ['Boigneville','Maisse'] , 	48.3709213, 2.3869891 , RERD , [RERD,RERD] ) ,
'Boigneville' : Station('Boigneville', ['Malesherbes (R)','Buno - Gironville'] , 	48.344163, 2.3801016 , RERD , [RERD,RERD] ) ,
'Malesherbes (R)' : Station('Malesherbes (R)', ['Boigneville'] , 	48.2934392, 2.4011843 , RERD , [RERD] )}

RerE = {'Haussmann - Saint-Lazare' : Station('Haussmann - Saint-Lazare', ['Magenta'] , 		48.8747218, 2.3271274 , RERE , [RERE] ) ,
'Magenta' : Station('Magenta', ['Pantin','Haussmann - Saint-Lazare','Gare du Nord'] , 		48.879975, 2.3580882 , RERE , [RERE,RERE,LigneM] ) ,
'Gare du Nord' : Station('Gare du Nord', ['Magenta'] , 	48.8801863, 2.356, LigneM , [LigneM] ) , 
'Pantin' : Station('Pantin', ['Noisy-le-Sec','Magenta'] , 	48.8980176, 2.4012745	 , RERE , [RERE,RERE] ) ,
'Noisy-le-Sec' : Station('Noisy-le-Sec', ['Bondy','Pantin','Rosny - Bois Perrier'] , 48.89664 , 2.45967	 , RERE , [RERE,RERE,RERE] ) ,

'Bondy' : Station('Bondy', ['Le Raincy - Villemomble - Montfermeil','Noisy-le-Sec'] , 48.89407, 2.47878	 , RERE , [RERE,RERE] ) ,
'Le Raincy - Villemomble - Montfermeil' : Station('Le Raincy - Villemomble - Montfermeil', ['Gagny','Bondy'] , 		48.888951, 2.5129214 , RERE , [RERE,RERE] ) ,
'Gagny' : Station('Gagny', ['Le Chenay - Gagny','Le Raincy - Villemomble - Montfermeil'] , 		48.8834204, 2.5262117 , RERE , [RERE,RERE] ) ,
'Le Chenay - Gagny' : Station('Le Chenay - Gagny', ['Chelles - Gournay','Gagny'] , 	48.8771405, 2.5531493	 , RERE , [RERE,RERE] ) ,
'Chelles - Gournay' : Station('Chelles - Gournay', ['Le Chenay - Gagny'] , 	48.8743177, 2.5832838	 , RERE , [RERE] ) ,

'Rosny - Bois Perrier' : Station('Rosny - Bois Perrier', ['Rosny-sous-Bois','Noisy-le-Sec'] , 	48.8825092, 2.4812324 , RERE , [RERE,RERE] ) ,
'Rosny-sous-Bois' : Station('Rosny-sous-Bois', ['Val de Fontenay','Rosny - Bois Perrier'] , 	48.8703405, 2.485847	 , RERE , [RERE,RERE] ) ,
'Val de Fontenay' : Station('Val de Fontenay', ['Nogent - Le Perreux','Rosny-sous-Bois'] , 	48.8542977, 2.4891566	 , RERE , [RERE,RERE] ) ,
'Nogent - Le Perreux' : Station('Nogent - Le Perreux', ['Les Boullereaux - Champigny','Val de Fontenay'] , 	48.8390089, 2.4942347	 , RERE , [RERE,RERE] ) ,
'Les Boullereaux - Champigny' : Station('Les Boullereaux - Champigny', ['Villiers-sur-Marne - Le Plessis-Trevise','Nogent - Le Perreux'] , 		48.8248565, 2.511885 , RERE , [RERE,RERE] ) ,
'Villiers-sur-Marne - Le Plessis-Trevise' : Station('Villiers-sur-Marne - Le Plessis-Trevise', ['Les Yvris - Noisy-le-Grand','Les Boullereaux - Champigny'] , 		48.8232568, 2.5425275 , RERE , [RERE,RERE] ) ,
'Les Yvris - Noisy-le-Grand' : Station('Les Yvris - Noisy-le-Grand', ['Emerainville - Pontault-Combault','Villiers-sur-Marne - Le Plessis-Trevise'] , 	48.8230136, 2.5801235	 , RERE , [RERE,RERE] ) ,
'Emerainville - Pontault-Combault' : Station('Emerainville - Pontault-Combault', ['Roissy-en-Brie','Les Yvris - Noisy-le-Grand'] , 	48.8061102, 2.6184322	 , RERE , [RERE,RERE] ) ,
'Roissy-en-Brie' : Station('Roissy-en-Brie', ['Ozoir-la-Ferriere','Emerainville - Pontault-Combault'] , 		48.7956697, 2.6503883 , RERE , [RERE,RERE] ) ,
'Ozoir-la-Ferriere' : Station('Ozoir-la-Ferriere', ['Gretz-Armainvilliers','Roissy-en-Brie'] , 		48.770724, 2.6902929 , RERE , [RERE,RERE] ) ,
'Gretz-Armainvilliers' : Station('Gretz-Armainvilliers', ['Tournan','Ozoir-la-Ferriere'] , 	48.7454489, 2.7285636	 , RERE , [RERE,RERE] ) ,
'Tournan' : Station('Tournan', ['Gretz-Armainvilliers'] , 	48.739528, 2.7587137	 , RERE , [RERE] )}

Rer = [RerA,RerB,RerD,RerE]



station = {'Glaciere' : [999999999,False,[],''] , 
'Victor Hugo' : [999999999,False,[],''] , 
'Saint-Georges' : [999999999,False,[],''] , 
'Les Gobelins' : [999999999,False,[],''] , 
'Jacques Bonsergent ' : [999999999,False,[],''] , 
'Gambetta' : [999999999,False,[],''] , 
'Charonne' : [999999999,False,[],''] , 
'Pigalle' : [999999999,False,[],''] , 
'Porte de Vanves' : [999999999,False,[],''] , 
'Strasbourg - Saint-Denis' : [999999999,False,[],''] , 
'Strasbourg - Saint-Denis [4]' : [999999999,False,[],''] , 
'Strasbourg - Saint-Denis [8]' : [999999999,False,[],''] , 
'Strasbourg - Saint-Denis [9]' : [999999999,False,[],''] , 
'Ecole Militaire' : [999999999,False,[],''] , 
'Volontaires' : [999999999,False,[],''] , 
'Champs-Elysees Clemenceau' : [999999999,False,[],''] , 
'Gare de Lyon' : [999999999,False,[],''] , 
'Gare de Lyon [1]' : [999999999,False,[],''] , 
'Gare de Lyon [q]' : [999999999,False,[],''] , 
'Gare de Lyon [R]' : [999999999,False,[],''] , 
'Porte des Lilas' : [999999999,False,[],''] , 
'Richelieu Drouot' : [999999999,False,[],''] , 
'Filles du Calvaire' : [999999999,False,[],''] , 
'Chateau Rouge' : [999999999,False,[],''] , 
'Porte de Charenton' : [999999999,False,[],''] , 
'Gare d\'Austerlitz' : [999999999,False,[],''] , 
'Argentine' : [999999999,False,[],''] , 
'Reaumur - Sebastopol' : [999999999,False,[],''] , 
'Botzaris' : [999999999,False,[],''] , 
'Les Halles' : [999999999,False,[],''] , 
'Jaures' : [999999999,False,[],''] , 
'Solferino' : [999999999,False,[],''] , 
'Quai de la Gare' : [999999999,False,[],''] , 
'Mabillon' : [999999999,False,[],''] , 
'Lourmel' : [999999999,False,[],''] , 
'George V' : [999999999,False,[],''] , 
'Charles Michels' : [999999999,False,[],''] , 
'Picpus' : [999999999,False,[],''] , 
'Quai de la Rapee' : [999999999,False,[],''] , 
'Corentin Celton' : [999999999,False,[],''] , 
'Vavin' : [999999999,False,[],''] , 
'Saint-Fargeau' : [999999999,False,[],''] , 
'Basilique de Saint Denis' : [999999999,False,[],''] , 
'Telegraphe' : [999999999,False,[],''] , 
'Maisons-Alfort - Stade' : [999999999,False,[],''] , 
'Porte de Clichy' : [999999999,False,[],''] , 
'Mairie d\'Issy' : [999999999,False,[],''] , 
'Boissiere' : [999999999,False,[],''] , 
'Boulogne - Pont de Saint-Cloud' : [999999999,False,[],''] , 
'Saint-Mande - Tourelle' : [999999999,False,[],''] , 
'Gare du Nord [4]' : [999999999,False,[],''] , 
'Gare du Nord [5]' : [999999999,False,[],''] , 
'Gare du Nord [R]' : [999999999,False,[],''] , 
'Gare du Nord' : [999999999,False,[],''] , 
'Malakoff - Rue Etienne Dolet' : [999999999,False,[],''] , 
'Anvers' : [999999999,False,[],''] , 
'Pyramides' : [999999999,False,[],''] , 
'Croix de Chavaux' : [999999999,False,[],''] , 
'Sully - Morland' : [999999999,False,[],''] , 
'Ternes' : [999999999,False,[],''] , 
'Concorde' : [999999999,False,[],''] , 
'Concorde [1]' : [999999999,False,[],''] ,
'Concorde [8]' : [999999999,False,[],''] ,
'Concorde [d]' : [999999999,False,[],''] ,
'Porte de Versailles' : [999999999,False,[],''] , 
'Porte d\'Italie' : [999999999,False,[],''] , 
'Porte de Pantin' : [999999999,False,[],''] , 
'Saint-Marcel' : [999999999,False,[],''] , 
'Rome' : [999999999,False,[],''] , 
'Alma Marceau' : [999999999,False,[],''] , 
'Iena' : [999999999,False,[],''] , 
'Couronnes' : [999999999,False,[],''] , 
'Charles de Gaulle - Etoile' : [999999999,False,[],''] , 
'Rue Saint-Maur' : [999999999,False,[],''] , 
'Miromesnil' : [999999999,False,[],''] , 
'Porte de Saint-Ouen' : [999999999,False,[],''] , 
'Porte de Montreuil' : [999999999,False,[],''] , 
'Saint-Lazare' : [999999999,False,[],''] , 
'Michel Bizot' : [999999999,False,[],''] , 
'Pereire' : [999999999,False,[],''] , 
'Oberkampf' : [999999999,False,[],''] , 
'Galieni' : [999999999,False,[],''] , 
'Pre Saint-Gervais' : [999999999,False,[],''] , 
'Chatillon-Montrouge' : [999999999,False,[],''] , 
'Jules Joffrin' : [999999999,False,[],''] , 
'Bibliotheque Francois Mitterrand' : [999999999,False,[],''] , 
'Saint-Augustin' : [999999999,False,[],''] , 
'Tolbiac' : [999999999,False,[],''] , 
'Colonel Fabien' : [999999999,False,[],''] , 
'Pernety' : [999999999,False,[],''] , 
'Saint Denis Porte de Paris' : [999999999,False,[],''] , 
'Richard Lenoir' : [999999999,False,[],''] , 
'La Muette' : [999999999,False,[],''] , 
'Sentier' : [999999999,False,[],''] , 
'Commerce' : [999999999,False,[],''] , 
'Rue du Bac' : [999999999,False,[],''] , 
'Vaugirard' : [999999999,False,[],''] , 
'Bourse' : [999999999,False,[],''] , 
'Porte de Champerret' : [999999999,False,[],''] , 
'Edgar Quinet' : [999999999,False,[],''] , 
'La Courneuve - 8 mai 1945' : [999999999,False,[],''] , 
'Porte de Saint-Cloud' : [999999999,False,[],''] , 
'Montparnasse Bienvenue' : [999999999,False,[],''] , 
'Liege' : [999999999,False,[],''] , 
'Billancourt' : [999999999,False,[],''] , 
'Montgallet' : [999999999,False,[],''] , 
'Bolivar' : [999999999,False,[],''] , 
'Place Monge' : [999999999,False,[],''] , 
'Cardinal Lemoine' : [999999999,False,[],''] , 
'Pasteur' : [999999999,False,[],''] , 
'Mairie de Saint-Ouen' : [999999999,False,[],''] , 
'Pont Neuf' : [999999999,False,[],''] , 
'Saint-Michel' : [999999999,False,[],''] , 
'Porte de la Villette' : [999999999,False,[],''] , 
'Berault' : [999999999,False,[],''] , 
'Buttes Chaumont' : [999999999,False,[],''] , 
'Bastille' : [999999999,False,[],''] , 
'Saint-Francois-Xavier' : [999999999,False,[],''] , 
'Alesia' : [999999999,False,[],''] , 
'Guy Moquet' : [999999999,False,[],''] , 
'Fort d\'Aubervilliers' : [999999999,False,[],''] , 
'Sevres Babylone' : [999999999,False,[],''] , 
'Saint Denis Universite' : [999999999,False,[],''] , 
'Rue de la Pompe' : [999999999,False,[],''] , 
'Bir-Hakeim' : [999999999,False,[],''] , 
'Maubert Mutualite' : [999999999,False,[],''] , 
'Mairie d\'Ivry' : [999999999,False,[],''] , 
'Brochant' : [999999999,False,[],''] , 
'Duroc' : [999999999,False,[],''] , 
'Marcadet Poissoniers' : [999999999,False,[],''] , 
#'Gare de L'Est (4)' : [999999999,False,[],''] , 
'Gare de L\'Est' : [999999999,False,[],''] , 
'Gaite' : [999999999,False,[],''] , 
'Ledru-RoLin' : [999999999,False,[],''] , 
'Chevaleret' : [999999999,False,[],''] , 
'Cluny - La Sorbonne' : [999999999,False,[],''] , 
'Place de Clichy' : [999999999,False,[],''] , 
'Pelleport' : [999999999,False,[],''] , 
'Mouton-Duvernet' : [999999999,False,[],''] , 
'Trocadero' : [999999999,False,[],''] , 
'Trinite d\'Estienne d\'Orves' : [999999999,False,[],''] , 
'Malakoff - Plateau de Vanves' : [999999999,False,[],''] , 
'Grands Boulevards M8' : [999999999,False,[],''] , 
'Grands Boulevards M9' : [999999999,False,[],''] , 
'Vaneau' : [999999999,False,[],''] , 
'Riquet' : [999999999,False,[],''] , 
'St Jacques' : [999999999,False,[],''] , 
'Convention' : [999999999,False,[],''] , 
'Campo-Formio' : [999999999,False,[],''] , 
'Sevres Lecourbe' : [999999999,False,[],''] , 
'Bercy' : [999999999,False,[],''] , 
'Les Agnettes' : [999999999,False,[],''] , 
'Malesherbes' : [999999999,False,[],''] , 
'Blanche' : [999999999,False,[],''] , 
'Porte de Choisy' : [999999999,False,[],''] , 
'Chaussee d\'Antin (La Fayette)' : [999999999,False,[],''] , 
'Chateau d\'Eau' : [999999999,False,[],''] , 
'Varenne' : [999999999,False,[],''] , 
'Pere Lachaise' : [999999999,False,[],''] , 
'Danube' : [999999999,False,[],''] , 
'Crimee' : [999999999,False,[],''] , 
'Bobigny - Pablo Picasso' : [999999999,False,[],''] , 
'Anatole France' : [999999999,False,[],''] , 
'Felix Faure' : [999999999,False,[],''] , 
'Plaisance' : [999999999,False,[],''] , 
'La Fourche' : [999999999,False,[],''] , 
'Porte de Vincennes' : [999999999,False,[],''] , 
'Notre-Dame de Lorette' : [999999999,False,[],''] , 
'Voltaire' : [999999999,False,[],''] , 
'Chateau de Vincennes' : [999999999,False,[],''] , 
'Le Kremlin-Bicetre' : [999999999,False,[],''] , 
'Boucicaut' : [999999999,False,[],''] , 
'Boulogne - Jean Jaures' : [999999999,False,[],''] , 
'Maraichers' : [999999999,False,[],''] , 
'Madeleine' : [999999999,False,[],''] , 
'Madeleine [8]' : [999999999,False,[],''] , 
'Madeleine [d]' : [999999999,False,[],''] , 
'Madeleine [q]' : [999999999,False,[],''] , 
'Exelmans' : [999999999,False,[],''] , 
'Jasmin' : [999999999,False,[],''] , 
'Temple' : [999999999,False,[],''] , 
'La Motte-Picquet Grenelle' : [999999999,False,[],''] , 
'Europe' : [999999999,False,[],''] , 
'Wagram' : [999999999,False,[],''] , 
'Poissonniere' : [999999999,False,[],''] , 
'Cour Saint-Emilion' : [999999999,False,[],''] , 
'Saint-Paul' : [999999999,False,[],''] , 
'Alexandre Dumas' : [999999999,False,[],''] , 
'Notre-Dame-des-Champs' : [999999999,False,[],''] , 
'Creteil Universite' : [999999999,False,[],''] , 
'Javel - Andre Citroen' : [999999999,False,[],''] , 
'Kleber' : [999999999,False,[],''] , 
'Asnieres - GenneVilliers - Les Courtilles' : [999999999,False,[],''] , 
'Republique' : [999999999,False,[],''] , 
'Republique [b]' : [999999999,False,[],''] , 
'Segur' : [999999999,False,[],''] , 
'Chateau Landon' : [999999999,False,[],''] , 
'Lamarck-Caulaincourt' : [999999999,False,[],''] , 
'Barbes - Rochechouart' : [999999999,False,[],''] , 
'Louise Michel' : [999999999,False,[],''] , 
'Villejuif Leo Lagrange' : [999999999,False,[],''] , 
'Tuileries' : [999999999,False,[],''] , 
'Mairie de Montreuil' : [999999999,False,[],''] , 
'Eglise d\'Auteuil' : [999999999,False,[],''] , 
'Opera' : [999999999,False,[],''] , 
'Assemblee Nationale' : [999999999,False,[],''] , 
'Nationale' : [999999999,False,[],''] , 
'Eglise de Pantin' : [999999999,False,[],''] , 
'Cadet' : [999999999,False,[],''] , 
'Louis Blanc' : [999999999,False,[],''] , 
'Olympiades' : [999999999,False,[],''] , 
'Belleville' : [999999999,False,[],''] , 
'Creteil - L\'Echat' : [999999999,False,[],''] , 
'Creteil - Prefecture (Hotel de Ville)' : [999999999,False,[],''] , 
'Mairie de Clichy' : [999999999,False,[],''] , 
'Esplanade de La Defense' : [999999999,False,[],''] , 
'Arts et Metiers' : [999999999,False,[],''] , 
'La Chapelle' : [999999999,False,[],''] , 
'Denfert-Rochereau' : [999999999,False,[],''] , 
'Denfert-Rochereau [4]' : [999999999,False,[],''] , 
'Denfert-Rochereau [6]' : [999999999,False,[],''] , 
'Denfert-Rochereau [R]' : [999999999,False,[],''] , 
'Charenton - Ecoles (Place Aristide Briand)' : [999999999,False,[],''] , 
'Abbesses' : [999999999,False,[],''] , 
'Parmentier' : [999999999,False,[],''] , 
'Villiers' : [999999999,False,[],''] , 
'Les Sablons' : [999999999,False,[],''] , 
'Liberte' : [999999999,False,[],''] , 
'Bonne Nouvelle M8' : [999999999,False,[],''] , 
'Bonne Nouvelle M9' : [999999999,False,[],''] , 
'Raspail' : [999999999,False,[],''] , 
'Aubervilliers - Pantin - Quatre Chemins' : [999999999,False,[],''] , 
'Porte de la Chapelle' : [999999999,False,[],''] , 
'Quatre-Septembre' : [999999999,False,[],''] , 
'Ourcq' : [999999999,False,[],''] , 
'Saint-Sulpice' : [999999999,False,[],''] , 
'Hotel de Ville' : [999999999,False,[],''] , 
'Odeon' : [999999999,False,[],''] , 
'Le Peletier' : [999999999,False,[],''] , 
'Mirabeau' : [999999999,False,[],''] , 
'Carrefour Pleyel' : [999999999,False,[],''] , 
'Cambronne' : [999999999,False,[],''] , 
'Rue des Boulets' : [999999999,False,[],''] , 
'Villejuif Paul Vaillant Couturier' : [999999999,False,[],''] , 
'Courcelles' : [999999999,False,[],''] , 
'Pierre et Marie Curie' : [999999999,False,[],''] , 
'Menilmontant' : [999999999,False,[],''] , 
'Corentin Cariou' : [999999999,False,[],''] , 
'Hoche' : [999999999,False,[],''] , 
'Robespierre' : [999999999,False,[],''] , 
'Buzenval' : [999999999,False,[],''] , 
'Saint-Germain-des-Pres' : [999999999,False,[],''] , 
'Chemin Vert' : [999999999,False,[],''] , 
'Bobigny-Pantin Raymond Queneau' : [999999999,False,[],''] , 
'Maisons-Alfort - Les Juiliottes' : [999999999,False,[],''] , 
'Pont Marie' : [999999999,False,[],''] , 
'Havre - Caumartin' : [999999999,False,[],''] , 
'Marcel Sembat' : [999999999,False,[],''] , 
'Pont de Sevres' : [999999999,False,[],''] , 
'Cite' : [999999999,False,[],''] , 
'Simplon' : [999999999,False,[],''] , 
'Saint-Ambroise' : [999999999,False,[],''] , 
'Rambuteau' : [999999999,False,[],''] , 
'Marx Dormoy' : [999999999,False,[],''] , 
'Faidherbe-Chaligny' : [999999999,False,[],''] , 
'Chardon Lagache' : [999999999,False,[],''] , 
'Goncourt' : [999999999,False,[],''] , 
'Pont de Levallois' : [999999999,False,[],''] , 
'Censier Daubenton' : [999999999,False,[],''] , 
'Ranelagh' : [999999999,False,[],''] , 
'Philippe Auguste' : [999999999,False,[],''] , 
'Porte de Bagnolet' : [999999999,False,[],''] , 
'Nation' : [999999999,False,[],''] , 
'Franklin D.Roosevelt' : [999999999,False,[],''] , 
'Saint-Sebastien - Froissart' : [999999999,False,[],''] , 
'Stalingrad' : [999999999,False,[],''] ,
'Stalingrad [2]' : [999999999,False,[],''] ,
'Stalingrad [S]' : [999999999,False,[],''] , 
'Mairie des Lilas' : [999999999,False,[],''] , 
'Place des Fetes' : [999999999,False,[],''] , 
'Daumesnil' : [999999999,False,[],''] , 
'Porte Maillot' : [999999999,False,[],''] , 
'Invalides' : [999999999,False,[],''] , 
'Monceau' : [999999999,False,[],''] , 
'Porte Doree' : [999999999,False,[],''] , 
'Balard' : [999999999,False,[],''] , 
'Falguiere' : [999999999,False,[],''] , 
'Avenue Emile Zola' : [999999999,False,[],''] , 
'Porte d\'Orleans' : [999999999,False,[],''] , 
'Louvre - Rivoli' : [999999999,False,[],''] , 
'Pyrenees' : [999999999,False,[],''] , 
'Chatelet' : [999999999,False,[],''] , 
'Chatelet M7 M11' : [999999999,False,[],''] , 
'Avron' : [999999999,False,[],''] , 
'Jussieu' : [999999999,False,[],''] , 
'Corvisart' : [999999999,False,[],''] , 
'Rennes' : [999999999,False,[],''] , 
'Laumiere' : [999999999,False,[],''] , 
'Gabriel Peri' : [999999999,False,[],''] , 
'Michel-Ange - Auteuil' : [999999999,False,[],''] , 
'Bel-Air' : [999999999,False,[],''] , 
'Dupleix' : [999999999,False,[],''] , 
'Porte d\'Auteuil' : [999999999,False,[],''] , 
'Passy' : [999999999,False,[],''] , 
'La Defense - Grande Arche' : [999999999,False,[],''] , 
'La Defense - Grande Arche [M]' : [999999999,False,[],''] , 
'La Defense - Grande Arche [R]' : [999999999,False,[],''] , 
'Place d\'Italie' : [999999999,False,[],''] , 
'Saint-Philippe du Roule' : [999999999,False,[],''] , 
'Saint-Placide' : [999999999,False,[],''] , 
'La Tour Maubourg' : [999999999,False,[],''] , 
'Maison Blanche' : [999999999,False,[],''] , 
'Michel-Ange - Molitor' : [999999999,False,[],''] , 
'Villejuif Louis Aragon' : [999999999,False,[],''] , 
'Breguet-Sabin' : [999999999,False,[],''] , 
'Porte Dauphine' : [999999999,False,[],''] , 
'Porte de Clignancourt' : [999999999,False,[],''] , 
'Jourdain' : [999999999,False,[],''] , 
'Palais Royal - Musee du Louvre' : [999999999,False,[],''] , 
'Etienne Marcel' : [999999999,False,[],''] , 
'Reuilly-Diderot' : [999999999,False,[],''] , 
'Pont de Neuilly' : [999999999,False,[],''] , 
'Dugommier' : [999999999,False,[],''] , 
'Garibaldi' : [999999999,False,[],''] , 
'Ecole Veterinaire de Maisons-Alfort' : [999999999,False,[],''] ,
'Cergy Le Haut' : [999999999,False,[],''] , 
'Cergy Saint-Christophe' : [999999999,False,[],''] , 
'Cergy Prefecture' : [999999999,False,[],''] , 
'Neuville Universite' : [999999999,False,[],''] , 
'Conflans-Fin-d\'Oise' : [999999999,False,[],''] , 
'Acheres - Ville' : [999999999,False,[],''] , 
'Poissy' : [999999999,False,[],''] , 
'Acheres-Grand Cormier' : [999999999,False,[],''] , 
'Maisons-Laffitte' : [999999999,False,[],''] , 
'Sartrouville' : [999999999,False,[],''] , 
'Houilles - Carrieres-Sur-Seine' : [999999999,False,[],''] , 
'Saint-Germain-en-Laye' : [999999999,False,[],''] , 
'Le Vesinet - Le Pecq' : [999999999,False,[],''] , 
'Le Vesinet Centre' : [999999999,False,[],''] , 
'Chatou - Croissy' : [999999999,False,[],''] , 
'Rueil-Malmaison' : [999999999,False,[],''] , 
'Nanterre - Ville' : [999999999,False,[],''] , 
'Nanterre Universite' : [999999999,False,[],''] , 
'Nanterre Prefecture' : [999999999,False,[],''] , 
'Auber' : [999999999,False,[],''] , 
'Vincennes' : [999999999,False,[],''] , 
'Fontenay-sous-Bois' : [999999999,False,[],''] , 
'Nogent-sur-Marne' : [999999999,False,[],''] , 
'Joinville-le-Pont' : [999999999,False,[],''] , 
'Saint-Maur Creteil' : [999999999,False,[],''] , 
'Parc de Saint-Maur' : [999999999,False,[],''] , 
'Champigny - Saint Maur' : [999999999,False,[],''] , 
'La Varenne - Chennevieres' : [999999999,False,[],''] , 
'Sucy - Bonneuil' : [999999999,False,[],''] , 
'Boissy Saint-Leger' : [999999999,False,[],''] , 
'Val de Fontenay' : [999999999,False,[],''] , 
'Neuilly-Plaisance' : [999999999,False,[],''] , 
'Bry-sur-Marne' : [999999999,False,[],''] , 
'Noisy-le-Grand' : [999999999,False,[],''] , 
'Noisy Champs' : [999999999,False,[],''] , 
'Noisiel Le Luzard' : [999999999,False,[],''] , 
'Lognes' : [999999999,False,[],''] , 
'Torcy' : [999999999,False,[],''] , 
'Bussy-Saint-Georges' : [999999999,False,[],''] , 
'Val d\'Europe' : [999999999,False,[],''] , 
'Marne-la-Vallee Chessy - Parc Disneyland' : [999999999,False,[],''] , 
'Aeroport Charles de Gaulle 2 TGV' : [999999999,False,[],''] , 
'Aeroport Charles de Gaulle 1' : [999999999,False,[],''] , 
'Parc des Expositions' : [999999999,False,[],''] , 
'Villepinte' : [999999999,False,[],''] , 
'Sevran - Beaudottes' : [999999999,False,[],''] , 
'Mitry-Claye' : [999999999,False,[],''] , 
'Villeparisis-Mitry le Neuf' : [999999999,False,[],''] , 
'Vert-Galant' : [999999999,False,[],''] , 
'Sevran-Livry' : [999999999,False,[],''] , 
'Aulnay-sous-Bois' : [999999999,False,[],''] , 
'Le Blanc-Mesnil' : [999999999,False,[],''] , 
'Drancy' : [999999999,False,[],''] , 
'Le Bourget' : [999999999,False,[],''] , 
'La Courneuve - Aubervilliers' : [999999999,False,[],''] , 
'La Plaine Stade de France' : [999999999,False,[],''] , 

'Chatelet-les-Halles' : [999999999,False,[],''] , 
'Chatelet-les-Halles [D]' : [999999999,False,[],''] , 
'Saint-Michel Notre-Dame' : [999999999,False,[],''] , 
'Luxembourg' : [999999999,False,[],''] , 
'Port-Royal' : [999999999,False,[],''] , 
'Cite Universitaire' : [999999999,False,[],''] , 
'Gentilly' : [999999999,False,[],''] , 
'Laplace' : [999999999,False,[],''] , 
'Arcueil Cachan' : [999999999,False,[],''] , 
'Bagneux' : [999999999,False,[],''] , 
'Bourg-la-Reine' : [999999999,False,[],''] , 
'Sceaux' : [999999999,False,[],''] , 
'Fontenay-aux-Roses' : [999999999,False,[],''] , 
'Robinson' : [999999999,False,[],''] , 
'Parc de Sceaux' : [999999999,False,[],''] , 
'La Croix de Berny' : [999999999,False,[],''] , 
'Antony' : [999999999,False,[],''] , 
'Fontaine Michalon' : [999999999,False,[],''] , 
'Les Baconnets' : [999999999,False,[],''] , 
'Massy-Verrieres' : [999999999,False,[],''] , 
'Massy-Palaiseau' : [999999999,False,[],''] , 
'Palaiseau' : [999999999,False,[],''] , 
'Palaiseau-Villebon' : [999999999,False,[],''] , 
'Lozere' : [999999999,False,[],''] , 
'Le Guichet' : [999999999,False,[],''] , 
'Orsay-Ville' : [999999999,False,[],''] , 
'Bures-sur-Yvette' : [999999999,False,[],''] , 
'La Hacquiniere' : [999999999,False,[],''] , 
'Gif-sur-Yvette' : [999999999,False,[],''] , 
'Courcelle-sur-Yvette' : [999999999,False,[],''] , 
'Saint-Remy-les-Chevreuse' : [999999999,False,[],''] ,
'Creil' : [999999999,False,[],''] , 
'Chantilly - Gouvieux' : [999999999,False,[],''] , 
'Orry-la-Ville - Coye' : [999999999,False,[],''] , 
'La Borne Blanche' : [999999999,False,[],''] , 
'Survilliers - Fosses' : [999999999,False,[],''] , 
'Louvres' : [999999999,False,[],''] , 
'Les Noues' : [999999999,False,[],''] , 
'Goussainville' : [999999999,False,[],''] , 
'Villiers-le-Bel - Gonesse - Arnouville' : [999999999,False,[],''] , 
'Garges - Sarcelles' : [999999999,False,[],''] , 
'Pierrefitte - Stains' : [999999999,False,[],''] , 
'Saint Denis' : [999999999,False,[],''] , 
'Stade de France - Saint Denis' : [999999999,False,[],''] , 
'Maisons-Alfort - Alfortville' : [999999999,False,[],''] , 
'Le Vert de Maisons' : [999999999,False,[],''] , 
'Villeneuve - Prairie' : [999999999,False,[],''] , 
'Villeneuve - Triage' : [999999999,False,[],''] , 
'Villeneuve-Saint-Georges' : [999999999,False,[],''] , 
'Montgeron - Crosne' : [999999999,False,[],''] , 
'Yerres' : [999999999,False,[],''] , 
'Brunoy' : [999999999,False,[],''] , 
'Boussy-Saint-Antoine' : [999999999,False,[],''] , 
'Combs-la-Ville - Quincy' : [999999999,False,[],''] , 
'Lieusaint - Moissy' : [999999999,False,[],''] , 
'Savigny-le-Temple - Nandy' : [999999999,False,[],''] , 
'Cesson' : [999999999,False,[],''] , 
'Le Mee-sur-Seine' : [999999999,False,[],''] , 
'Melun' : [999999999,False,[],''] , 
'Vigneux-sur-Seine' : [999999999,False,[],''] , 
'Juvisy-sur-Orge' : [999999999,False,[],''] , 
'Viry-Chatillon' : [999999999,False,[],''] , 
'Ris-Orangis' : [999999999,False,[],''] , 
'Le Grand-Bourg' : [999999999,False,[],''] , 
'Evry Val de Seine' : [999999999,False,[],''] , 
'Grigny-Centre' : [999999999,False,[],''] , 
'Orangis - Bois de l\'Epine' : [999999999,False,[],''] , 
'Evry-Courcouronnes Centre' : [999999999,False,[],''] , 
'Le Bras-de-Fer - Evry - Genopole' : [999999999,False,[],''] , 
'Corbeil-Essonnes' : [999999999,False,[],''] , 
'Essonnes - Robinson' : [999999999,False,[],''] , 
'Villabe' : [999999999,False,[],''] , 
'Le Plessis-Chenet' : [999999999,False,[],''] , 
'Le Coudray Montceaux' : [999999999,False,[],''] , 
'Saint Fargeau' : [999999999,False,[],''] , 
'Ponthierry Pringy' : [999999999,False,[],''] , 
'Boissise-le-Roi' : [999999999,False,[],''] , 
'Vosves' : [999999999,False,[],''] , 
'Moulin-Galant' : [999999999,False,[],''] , 
'Mennecy' : [999999999,False,[],''] , 
'Ballancourt-sur-Essonne' : [999999999,False,[],''] , 
'La Ferte-Alais' : [999999999,False,[],''] , 
'Boutigny' : [999999999,False,[],''] , 
'Maisse' : [999999999,False,[],''] , 
'Buno - Gironville' : [999999999,False,[],''] , 
'Boigneville' : [999999999,False,[],''] , 
'Malesherbes (R)' : [999999999,False,[],''] ,
'Haussmann - Saint-Lazare' : [999999999,False,[],''] , 
'Magenta' : [999999999,False,[],''] , 
'Pantin' : [999999999,False,[],''] , 
'Noisy-le-Sec' : [999999999,False,[],''] , 
'Bondy' : [999999999,False,[],''] , 
'Le Raincy - Villemomble - Montfermeil' : [999999999,False,[],''] , 
'Gagny' : [999999999,False,[],''] , 
'Le Chenay - Gagny' : [999999999,False,[],''] , 
'Chelles - Gournay' : [999999999,False,[],''] , 
'Rosny - Bois Perrier' : [999999999,False,[],''] , 
'Rosny-sous-Bois' : [999999999,False,[],''] , 
'Val de Fontenay' : [999999999,False,[],''] , 
'Nogent - Le Perreux' : [999999999,False,[],''] , 
'Les Boullereaux - Champigny' : [999999999,False,[],''] , 
'Villiers-sur-Marne - Le Plessis-Trevise' : [999999999,False,[],''] , 
'Les Yvris - Noisy-le-Grand' : [999999999,False,[],''] , 
'Emerainville - Pontault-Combault' : [999999999,False,[],''] , 
'Roissy-en-Brie' : [999999999,False,[],''] , 
'Ozoir-la-Ferriere' : [999999999,False,[],''] , 
'Gretz-Armainvilliers' : [999999999,False,[],''] , 
'Tournan' : [999999999,False,[],''] }
