#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtXml import *
from PyQt4.QtMaemo5 import *
from PyQt4.QtMobility.QtLocation import *
from PyQt4.QtMobility.QtBearer import *

#from connectivityhelper import ConnectivityHelper

import station
import math
import os
import dijkstra
import classes
import station

import time

_RAYON = station._RAYON
_TEMPS_ANIM = 1000

graph = station.graph


  
            

class Ui_MainWindow(QMainWindow):

    m_logfileInUse = False

    m_latitude = -1000
    m_longitude = -1000
    
    m_accuracy = False


    def closeEvent(self,event):
        self.m_location.stopUpdates()
        self.m_session.close()
#        print 'closing'
        QMainWindow.closeEvent (self, event)


    def __init__(self, parent = None):
        super(Ui_MainWindow, self).__init__()
        # QGeoPositionInfoSource
        self.m_location = QGeoPositionInfoSource.createDefaultSource(self)

        if self.m_location == 0:
            nmeaLocation = QNmeaPositionInfoSource(QNmeaPositionInfoSource.SimulationMode, self)
            logFile = QFile("nmealog.txt", self)
            nmeaLocation.setDevice(logFile)
            self.m_location = nmeaLocation
            self.m_logfileInUse = True
    
        # Listen gps position changes
        self.m_location.positionUpdated.connect(self.positionUpdated)

        if self.m_logfileInUse:
            QMessageBox.information(self, self.tr("Rtap"), self.tr("No GPS support detected, using GPS data from a sample log file instead."))
    
        manager = QNetworkConfigurationManager()
        canStartIAP = (manager.capabilities() and QNetworkConfigurationManager.CanStartAndStopInterfaces)
        cfg = manager.defaultConfiguration()
        if not cfg.isValid() or (not canStartIAP and cfg.state() != QNetworkConfiguration.Active):
            QMessageBox.information(self, self.tr("Rtap"), self.tr("Available Access Points not found."))
            return

        self.m_session = QNetworkSession(cfg, self)
        self.m_session.opened.connect(self.networkSessionOpened)

    # Start listening GPS position updates    
    def networkSessionOpened(self):
#        print 'a'
        self.m_location.startUpdates()
#        print 'b'

    def positionUpdated(self, gpsPos):
        if gpsPos.isValid():
            coord = gpsPos.coordinate()
            self.m_latitude = coord.latitude()
            self.m_longitude = coord.longitude()
            self.gps.setPos( (self.m_longitude*10-20)*500,-(self.m_latitude*10-488)*700)
            graph["GPS"].setPos(self.m_longitude, self.m_latitude)
            if gpsPos.attribute(QGeoPositionInfo.HorizontalAccuracy) < 80 or gpsPos.attribute(QGeoPositionInfo.VerticalAccuracy) < 80:
                self.gpsButton.setPix('Good')
            else:
                self.gpsButton.setPix('On')
    
    def addGPS(self):
        self.scene.addItem(self.gps)
        QObject.disconnect(self.gpsButton, SIGNAL("gpsOn"), self.addGPS)
        
    def closeSession(self):
        self.m_location.stopUpdates()
#        QTimer.singleShot(0, self.m_location.stopUpdates)
        QTimer.singleShot(0, self.m_session.close)
#        self.scene.removeItem(self.gps) 

    def gpsCenter(self):

        self.view.goTo(QPointF(self.gps.x(),self.gps.y()),self.view.getScale())
        self.view.animPar.start()
        
    def play(self):

        n = len(self.Chemin) - 1
        i = 1
        if n == 0:
            return
        else:
            self.panAction.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_video_stop.png"))
            self.view.animSeq.stop()
            self.view.animSeq.clear()
            
            #Anim Center

            animCenter = QPropertyAnimation (self.view, "center")
            animCenter.setDuration(_TEMPS_ANIM*2)
            animCenter.setEasingCurve(QEasingCurve.OutQuad)
            animCenter.setKeyValueAt(0, self.view.getCenter())
            animCenter.setKeyValueAt(1, QPointF(  graph[self.Chemin[0]].posX,  graph[self.Chemin[0]].posY ))


            #Anime Zoom    
            
            val = (5./self.view.getScale())**(.2)
            animZoom = QPropertyAnimation (self.view, "scaling")
            animZoom.setDuration(_TEMPS_ANIM*2)
            animZoom.setEasingCurve(QEasingCurve.Linear)
            animZoom.setKeyValueAt(0, val)
            animZoom.setKeyValueAt(1, val)

            animParIn = QParallelAnimationGroup()
            animParIn.addAnimation(animCenter)
            animParIn.addAnimation(animZoom)

            #Start anim
            self.view.animSeq.addAnimation(animParIn)
            self.view.animSeq.addPause(_TEMPS_ANIM/2)

            #Follow stations
            while i < n+1:
                anim = QPropertyAnimation (self.view, "center")
                anim.setDuration(_TEMPS_ANIM)
                anim.setEasingCurve(QEasingCurve.InOutCubic)
                anim.setKeyValueAt(0, QPointF(  graph[self.Chemin[i-1]].posX,  graph[self.Chemin[i-1]].posY )  )
                anim.setKeyValueAt(1, QPointF(  graph[self.Chemin[i]].posX,  graph[self.Chemin[i]].posY )  )
                self.view.animSeq.addAnimation(anim)
                i += 1
    

            #Anim UnCenter 

            animUnCenter = QPropertyAnimation (self.view, "center")
            animUnCenter.setDuration(_TEMPS_ANIM*2)
            animUnCenter.setEasingCurve(QEasingCurve.OutQuad)
            animUnCenter.setKeyValueAt(0, QPointF(  graph[self.Chemin[-1]].posX,  graph[self.Chemin[-1]].posY ))
            
            dx = abs(graph[self.Chemin[-1]].posX - graph[self.Chemin[0]].posX)
            dy = abs(graph[self.Chemin[-1]].posY - graph[self.Chemin[0]].posY)
            if graph[self.Chemin[-1]].posX - graph[self.Chemin[0]].posX > 0:
                x = graph[self.Chemin[0]].posX + dx/2
            else:
                x = graph[self.Chemin[0]].posX - dx/2

            if graph[self.Chemin[-1]].posY - graph[self.Chemin[0]].posY > 0:
                y = graph[self.Chemin[0]].posY + dy/2
            else:
                y = graph[self.Chemin[0]].posY - dy/2 
            animUnCenter.setKeyValueAt(1, QPointF(  x,  y ))

            #Anime UnZoom    
            
            w = self.width()
            h = self.height()
            Sx = (w/(dx+10))
            Sy = (h/(dy+10))
            S = max(min(Sx,Sy,5.0),.21)
#            print w, h, dx

            val = ((S) /5.)**(.2)
            
            animUnZoom = QPropertyAnimation (self.view, "scaling")
            animUnZoom.setDuration(_TEMPS_ANIM*2)
            animUnZoom.setEasingCurve(QEasingCurve.Linear)
            animUnZoom.setKeyValueAt(0, val)
            animUnZoom.setKeyValueAt(1, val)

            animParOut = QParallelAnimationGroup()
            animParOut.addAnimation(animUnCenter)
            animParOut.addAnimation(animUnZoom)

            self.view.animSeq.addPause(_TEMPS_ANIM/2)
            self.view.animSeq.addAnimation(animParOut)



            QObject.disconnect(self.panAction, SIGNAL("play"), self.play)
            QObject.connect(self.panAction, SIGNAL("play"), self.stop)
            self.view.animSeq.finished.connect(self.stop)
            self.view.animSeq.start()

    def stop(self):
        if self.view.animSeq.state() != QAbstractAnimation.Stopped:
            self.view.animSeq.stop()
        
        self.panAction.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        QObject.disconnect(self.panAction, SIGNAL("play"), self.view.animSeq.stop)
        QObject.connect(self.panAction, SIGNAL("play"), self.play)

        
    def search(self):
        value , ok = QInputDialog.getText( self.view, "Rtap : Recherche", "Saisissez les termes de votre recherche.", )
        result = []
        if ok:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
            for element in graph:
                if str(value) in element:
                    result += [element]
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
            if len(result) == 0:
                QMaemo5InformationBox.information( self, 'La recherche n\'a donn\xe9 aucun r\xe9sultat.' )
            elif len(result) == 1:
                self.setSelec(result[0])
                
                self.view.goTo(graph[result[0]].Pos(),self.view.getScale())
                self.view.animPar.start()
            elif len(result) > 1:
                Selec , ok = QInputDialog.getItem ( self.view, "Rtap : Recherche", "Liste des r\xe9sultats. Choisissez une station :", result, 0, False)
                if ok:
                    self.setSelec(Selec)
                    self.view.goTo(graph[str(Selec)].Pos(),self.view.getScale())
                    self.view.animPar.start()
    
                    if Selec == 'GPS':
                        self.gps.selec()
                        self.gpsCenter()
                    
                

    def setSelec(self,Name):
        
        Nom = str(Name)
        
        w = self.width()
        h = self.height()
        if self.panAction.toggle:
            if self.Selec[0] != Nom and Nom != self.Selec[1]:
                for value in graph:
                    graph[value].deselec()
                self.gps.deselec()
                for item in self.CheminItem:
                    self.scene.removeItem(item)
                self.scene.removeItem(self.rectCalc)
                self.panDepart.playX(w)
                self.panArrivee.playX(w)
                self.panAction.playX(w)
            
                self.Selec = (Nom,'')
            
                self.panDepart.playX(w,Nom)
                graph[Nom].selec() 
            
            self.scene.update()
        else:
            if Nom == self.Selec[0] or Nom == self.Selec[1]:
                self.colorise()
                    
            elif self.Selec[0] == '':
                self.Selec = (Nom,self.Selec[1])
                graph[Nom].selec()
                self.scene.update()

                self.panDepart.playX(w,Nom)
                if self.Selec[1] != '':
                    self.panAction.playX(w,Nom)
            
        
            else:
                if self.Selec[0] != Nom and Nom != self.Selec[1]:
                    self.deselec(self.Selec[1])
                    self.Selec = (self.Selec[0],Nom)
                    
                    graph[Nom].selec()
                    self.scene.update()
                
                    self.panArrivee.playX(w,Nom)
                    self.panAction.playX(w,Nom)
        
    def rectSelec(self,p):
        point = self.view.mapFromScene(p)
        rect = self.view.mapToScene(QRect(point.x()-10.,point.y()-10.,20.,20.))
        liste = self.scene.items(rect)
        listeNom = []
        for element in liste:
            if element.type() == 65536:
                listeNom += [element.name]
            elif element.type() == 4:
                listeNom += ['GPS']

        
        if len(listeNom) == 1:
            self.setSelec(listeNom[0])
            if listeNom[0] == 'GPS':
                self.gps.selec()
        elif len(listeNom) > 1:
            Selec , ok = QInputDialog.getItem ( self.view, 'Liste de stations' , "Choisir la station :", listeNom, 0, False)
            if ok:
                self.setSelec(Selec)
                if Selec == 'GPS':
                    self.gps.selec()
                

    def gpsSearch(self,p):
        point = self.view.mapFromScene(p)
        proche = []
        k = 1
        while proche == []:
            r = QRect(point.x()-k*10.,point.y()-k*10.,k*20.,k*20.)
            rect = self.view.mapToScene(r)
            liste = self.scene.items(rect)
            for element in liste:
                if element.type() == 65536 and element.name != "GPS":
                    proche += [element]
            k += 1
        listeNom = []
        for element in proche:
            if element.type() == 65536:
                listeNom += [element.name]
        if len(listeNom) == 1:
            return listeNom[0]
        elif len(listeNom) > 1:
            Selec , ok = QInputDialog.getItem ( self.view, 'Liste de stations' , "Choisir la station :", listeNom, 0, False)
            if ok:
                return Selec
        
    def deselec(self,Nom):
        w = self.width()
        h = self.height()
        self.scene.removeItem(self.rectCalc)
        for item in self.CheminItem:
            self.scene.removeItem(item)
        
        
        
        for value in graph:
                graph[value].deselec()
        self.scene.update()
        if Nom == self.Selec[0]:
            self.Selec = ('',self.Selec[1])
            if self.Selec[1] != '':
                graph[self.Selec[1]].selec()
            self.panDepart.playX(w)
            self.panAction.playX(w)
        else:
            self.Selec = (self.Selec[0],'')
            if self.Selec[0] != '':
                graph[self.Selec[0]].selec()
            self.panArrivee.playX(w)
            self.panAction.playX(w)
        if Nom == 'GPS':
            self.gps.deselec()
        
        
        
    def colorise(self):
        t0= time.time()
        self.scene.addItem(self.rectCalc)
        self.CheminItem = []
        if self.Selec[0] == 'GPS':
            proche = self.gpsSearch(self.gps.pos())
            graph['GPS'].addCorres(str(proche))
            self.Chemin , tps = dijkstra.algo(str(proche),self.Selec[1])
            self.Chemin = ['GPS'] + self.Chemin
        elif  self.Selec[1] == 'GPS':
            proche = self.gpsSearch(self.gps.pos())
            self.Chemin ,tps = dijkstra.algo(self.Selec[0],str(proche)) 
            self.Chemin += ["GPS"]
            graph[str(proche)].addCorres("GPS")
        else:
            self.Chemin, tps = dijkstra.algo(self.Selec[0],self.Selec[1])

#        print 'tps de calcul', time.time() - t0

        dep = self.Chemin[0]
        for dest in self.Chemin[1:]:
            idx = graph[dep].corres.index(dest)
            line = QGraphicsLineItem ( 
                    graph[dep].posX + _RAYON/2, 
                    graph[dep].posY + _RAYON/2, 
                    graph[dest].posX + _RAYON/2, 
                    graph[dest].posY + _RAYON/2, 
                    )
            line.setPen(QPen(graph[dep].corresColor[idx], _RAYON/2))
            self.CheminItem.append(line)
            dep = dest
        dep = self.Chemin[0]
        for dest in self.Chemin:
            gradient = QRadialGradient(graph[dest].posX,graph[dest].posY, _RAYON*1.5)
            try:
                idx = graph[dest].corres.index(dep)

                gradient.setColorAt(0, graph[dest].corresColor[idx].lighter(200))
                gradient.setColorAt(1, graph[dest].corresColor[idx])
            except ValueError:
                gradient.setColorAt(0, graph[dest].color.color().lighter(200))
                gradient.setColorAt(1, graph[dest].color.color())
            except AttributeError:
                gradient.setColorAt(0, graph[dest].color.color())
                gradient.setColorAt(1, graph[dest].color.color())
                
            ellipse = QGraphicsEllipseItem (graph[dest].posX, graph[dest].posY, _RAYON, _RAYON)

            ellipse.setPen(QPen( gradient, _RAYON/2))
            ellipse.setBrush(QBrush(gradient))
            self.CheminItem.append(ellipse)
            dep = dest
        dep = self.Chemin[0]
        for dest in self.Chemin:
            if not graph[dest].name[:-4] in graph[dep].name or dest == dep:
                if graph[dest].name[-1] == ']':
                    txt = QGraphicsTextItem (graph[dest].name[:-4])
                else:
                    txt = QGraphicsTextItem (graph[dest].name)
                txt.setPos(graph[dest].posX , graph[dest].posY-_RAYON/2)
                txt.setFont(QFont ( "Nokia Sans",_RAYON/2 ,63 ))
    
                try:
                    idx = graph[dest].corres.index(dep)
    
                    txt.setDefaultTextColor(graph[dest].corresColor[idx])
                except ValueError:
                    txt.setDefaultTextColor(graph[dest].color.color())
                except AttributeError:
                    txt.setDefaultTextColor(graph[dest].color.color())
                    
                if graph[dest].name[-1] == ']':
                    txtOmbre = QGraphicsTextItem (graph[dest].name[:-4])
                else:
                    txtOmbre = QGraphicsTextItem (graph[dest].name)
                txtOmbre.setPos(graph[dest].posX-.25, graph[dest].posY-_RAYON/2+.25)
                txtOmbre.setDefaultTextColor(Qt.black)
                txtOmbre.setFont(QFont ( "Nokia Sans",_RAYON/2 ,63 ))
    
                self.CheminItem.append(txtOmbre)
                self.CheminItem.append(txt)
            dep = dest

        for item in self.CheminItem:
            self.scene.addItem(item)
        self.scene.update()
        self.panAction.toggling()
        try:
            graph[str(proche)].removeCorres("GPS")
        except UnboundLocalError:
            return
        
        

    def orientationChanged(self, i):
        self.panArrivee.move(self.panArrivee.x(),app.desktop().screenGeometry().height()-126)
        self.panAction.move(self.panAction.x(),app.desktop().screenGeometry().height()/2-76)
        self.view.translate(-150,200)
        
        self.gpsButton.move(16,app.desktop().screenGeometry().height()-80-56)

        if self.panDepart.state :
            self.panDepart.move(app.desktop().screenGeometry().width()-min(290,self.panDepart.width()),self.panDepart.y())
        if self.panArrivee.state :
            self.panArrivee.move(app.desktop().screenGeometry().width()-min(290,self.panArrivee.width()),self.panArrivee.y())
        if self.panAction.state :
            self.panAction.move(app.desktop().screenGeometry().width()-100,self.panAction.y())
            self.panAction.animMargin.start()


        
    def setupUi(self, App):
        self.setWindowTitle("Rtap")
        self.resize(800,480)
        global app
        app = App

        self.centralWidget = QWidget(self)
        self.Selec = ('','')
        self.CheminItem = []
        self.Chemin = []

        menubar = QMenuBar(self)
        self.setMenuBar(menubar)
        
        menuChercher = QAction("Recherche",self)
        menubar.addAction(menuChercher)
        QObject.connect(menuChercher, SIGNAL("triggered()"), self.search)
        
        self.scene = classes.Carte(self)
        self.scene.setSceneRect(-815.90800894434585, -2585.2493331816809, 5397.5130039461728, 3900.3854289115216)
        
        #Fleuve
        fleuve = QPainterPath()
        fleuve.moveTo(station.SeineX[0], station.SeineY[0])
        l = len(station.SeineX)
        k = 1
        while k != l:
            fleuve.lineTo(station.SeineX[k], station.SeineY[k])
            k += 1

        fleuve.moveTo(station.OiseX[0], station.OiseY[0])
        l = len(station.OiseX)
        k = 1
        while k != l:
            fleuve.lineTo(station.OiseX[k], station.OiseY[k])
            k += 1

        fleuve.moveTo(station.MarneX[0], station.MarneY[0])
        l = len(station.MarneX)
        k = 1
        while k != l:
            fleuve.lineTo(station.MarneX[k], station.MarneY[k])
            k += 1
           
        fleuve.moveTo(station.SeineIleX[0], station.SeineIleY[0])
        l = len(station.SeineIleX)
        k = 1
        while k != l:
            fleuve.lineTo(station.SeineIleX[k], station.SeineIleY[k])
            k += 1
           
        self.scene.addPath(fleuve, QPen( QColor(165,191,221), _RAYON*.8))
        
        #Segment entre stations
        for dep in graph:
            k = 0
            while k < len(graph[dep].corres):
                dest = graph[dep].corres[k]
                
                self.scene.addLine ( 
                    graph[dep].posX + _RAYON/2, 
                    graph[dep].posY + _RAYON/2, 
                    graph[dest].posX + _RAYON/2, 
                    graph[dest].posY + _RAYON/2, 
                    QPen(graph[dep].corresColor[k], _RAYON/4)
                    )        

                try:
                    if graph[dep].corresColor[k] == graph[dep].corresColor[k+1] and graph[dep].corresColor[k] != station.LigneM:
                        k += 2
                    else:
                        k += 1
                except IndexError:
                    k += 1

        #Stations
        for value in graph:
            if graph[value].name[-1] != "]" and graph[value].name != 'GPS':
                self.scene.addItem(graph[value])


        QObject.connect(self.scene, SIGNAL("dblclicked(QPointF)"), self.rectSelec)


        self.scene.setBackgroundBrush(self.palette().shadow().color())
        self.view = classes.Fond(self.scene)
        self.view.setDragMode(1)
        self.view.setVerticalScrollBarPolicy ( Qt.ScrollBarAlwaysOff )
        self.view.setHorizontalScrollBarPolicy ( Qt.ScrollBarAlwaysOff )

        self.rectCalc = QGraphicsRectItem (self.view.sceneRect())
        self.rectCalc.setBrush(QBrush(QColor(0,0,0,153)))

        self.panDepart = classes.PanStation(self.view)
        self.panDepart.setGeometry(900,0,250,180)
        QObject.connect(self.panDepart, SIGNAL("released(QString)"), self.deselec)
        self.panDepart.show()


        self.panArrivee = classes.PanStation(self.view)
        self.panArrivee.setGeometry(900,app.desktop().screenGeometry().height()-126,250,180)
        QObject.connect(self.panArrivee, SIGNAL("released(QString)"), self.deselec)
        self.panArrivee.show()

        self.panAction = classes.PanAction(self.view)
        self.panAction.setGeometry(900,app.desktop().screenGeometry().height()/2-56-20,80,80)
        QObject.connect(self.panAction, SIGNAL("colorise"), self.colorise)
        QObject.connect(self.panAction, SIGNAL("play"), self.play)
        self.panAction.show()
        self.panAction.animMargin.start()

########## GPS

        self.gpsButton = classes.GpsButton(self.view)
        QObject.connect(self.gpsButton, SIGNAL("gpsOn"), self.m_session.open)
        QObject.connect(self.gpsButton, SIGNAL("gpsOn"), self.addGPS)
        QObject.connect(self.gpsButton, SIGNAL("gpsOff"), self.closeSession)
        QObject.connect(self.gpsButton, SIGNAL("gpsCenter"), self.gpsCenter)
        self.gpsButton.setGeometry(16,app.desktop().screenGeometry().height()-80-56,80,80)
        self.gpsButton.show()

#        self.gps = graph["GPS"]
        self.gps = classes.Gps()

#########

        if app.desktop().screenGeometry().width() < app.desktop().screenGeometry().height():
            self.view.centerOn(1900.,-500)        
        else:
            self.view.centerOn(1750.,-400)
        self.view.show()
        self.view.update()

        self.setCentralWidget(self.view)

        QObject.connect(app.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        
        

