#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtXml import *
from PyQt4.QtMobility.QtLocation import *
from PyQt4.QtMobility.QtBearer import *

#from connectivityhelper import ConnectivityHelper

import station
import math
import os
import dijkstra
import classes
import station

_RAYON = station._RAYON
_TEMPS_ANIM = 1000

graph = station.graph


  
def multRayon(x):
    global _RAYON
    _RAYON = _RAYON/x
        
    
    

            

class Ui_MainWindow(QMainWindow):

#    def event_Filter(self, object, event):
#        if event.type() == QEvent.MouseButtonDblClick:
#            object.emit(SIGNAL("doubleClicked()"))
#            return 1
#        elif event.type() == QEvent.MouseButtonRelease:
#            object.emit(SIGNAL("clicked(const QWidget & widget)"), object)
#            return 1
#        elif event.type() == QEvent.MouseButtonPress:
#            object.emit(SIGNAL("clicked(const QWidget & widget)"), object)
#            return 1
#        else:
#            return 0
    m_logfileInUse = False
    m_location = None

    locationLabel = None

    m_session = 0
#    m_connectivityHelper = None

    m_latitude = -1000
    m_longitude = -1000


    def __init__(self, parent = None):
        super(Ui_MainWindow, self).__init__()
        # QGeoPositionInfoSource
        self.m_location = QGeoPositionInfoSource.createDefaultSource(self)

        if self.m_location == 0:
            nmeaLocation = QNmeaPositionInfoSource(QNmeaPositionInfoSource.SimulationMode, self)
            logFile = QFile("nmealog.txt", self)
            nmeaLocation.setDevice(logFile)
            self.m_location = nmeaLocation
            self.m_logfileInUse = True
    
        # Listen gps position changes
        self.m_location.positionUpdated.connect(self.positionUpdated)

        if self.m_logfileInUse:
            QMessageBox.information(self, self.tr("Flickr Demo"), self.tr("No GPS support detected, using GPS data from a sample log file instead."))
    
        manager = QNetworkConfigurationManager()
        canStartIAP = (manager.capabilities() and QNetworkConfigurationManager.CanStartAndStopInterfaces)
        cfg = manager.defaultConfiguration()
        if not cfg.isValid() or (not canStartIAP and cfg.state() != QNetworkConfiguration.Active):
            QMessageBox.information(self, self.tr("Flickr Demo"), self.tr("Available Access Points not found."))
            return
    
        self.m_session = QNetworkSession(cfg, self)
#        self.m_connectivityHelper = ConnectivityHelper(self.m_session, self)
        self.m_session.opened.connect(self.networkSessionOpened)
#        self.connect(self.m_connectivityHelper, SIGNAL('networkingCancelled()'), qApp, SLOT('quit()'))
    
#        self.m_session.open()

    
    def networkSessionOpened(self):
        # Start listening GPS position updates
        self.m_location.startUpdates()

    def positionUpdated(self, gpsPos):
        if gpsPos.isValid():
            coord = gpsPos.coordinate()
            self.m_latitude = coord.latitude()
            self.m_longitude = coord.longitude()
#            print self.m_latitude , self.m_longitude
            self.gps.setPos( (self.m_longitude*10-20)*500,-(self.m_latitude*10-488)*700)
            graph["GPS"].setPos(self.m_longitude, self.m_latitude)

    def openSession(self):
        self.m_session.open()
        self.scene.addItem(self.gps)
        
    def closeSession(self):
        QTimer.singleShot(0, self.m_location.stopUpdates)
        QTimer.singleShot(0, self.m_session.close)
#        self.scene.removeItem(self.gps) 

    def gpsCenter(self):

#        self.view.goTo(QPointF(self.gps.x(),self.gps.y()))

        anim = QPropertyAnimation (self.view, "center")
        anim.setDuration(_TEMPS_ANIM)
        anim.setEasingCurve(QEasingCurve.OutBack)
        anim.setKeyValueAt(0, self.view.getCenter())
        anim.setKeyValueAt(1, QPointF(self.gps.x(),self.gps.y()))
        self.view.anim.addAnimation(anim)
        
        self.view.anim.start()
        
#    def viewCenter(self,point,curve = QEasingCurve.OutBack):
#        self.view.anim.setDuration(_TEMPS_ANIM)
#        self.view.anim.setEasingCurve(curve)
#        self.view.anim.setKeyValueAt(0, self.view.getCenter())
#        self.view.anim.setKeyValueAt(1, point)
#        self.view.anim.start()
        
    def play(self):
        n = len(self.Chemin) - 1
        i = 1
        if n == 0:
            return
        else:
            QObject.disconnect(self.panIti, SIGNAL("inverse"), self.play)
            self.panIti.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_video_stop.png"))
            self.view.anim.stop()
            self.view.anim.clear()
    
            animCenter = QPropertyAnimation (self.view, "center")
            animCenter.setDuration(_TEMPS_ANIM)
            animCenter.setEasingCurve(QEasingCurve.OutQuad)
            animCenter.setKeyValueAt(0, self.view.getCenter())
            animCenter.setKeyValueAt(1, QPointF(  graph[self.Chemin[0]].posX,  graph[self.Chemin[0]].posY ))
            self.view.anim.addAnimation(animCenter)
            
            self.view.anim.addPause(_TEMPS_ANIM/2)
    
    
#            self.viewCenter(QPointF(  graph[self.Chemin[0]].posX,  graph[self.Chemin[0]].posY ))
            scale = 5./ self.view.Scale
            self.view.scale( scale, scale)
            self.view.Scale = 5.
            self.view.update()


            while i < n+1:
                anim = QPropertyAnimation (self.view, "center")
                anim.setDuration(_TEMPS_ANIM)
                anim.setEasingCurve(QEasingCurve.InOutCubic)
                anim.setKeyValueAt(0, QPointF(  graph[self.Chemin[i-1]].posX,  graph[self.Chemin[i-1]].posY )  )
                anim.setKeyValueAt(1, QPointF(  graph[self.Chemin[i]].posX,  graph[self.Chemin[i]].posY )  )
                self.view.anim.addAnimation(anim)
                i += 1
    



            self.view.anim.finished.connect(self.stop)
#            QObject.connect(self.panIti, SIGNAL("inverse"), self.view.anim.stop)
            QObject.connect(self.panIti, SIGNAL("inverse"), self.stop)
            self.view.anim.start()

    def stop(self):
        self.view.anim.stop()
        self.panIti.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        QObject.disconnect(self.panIti, SIGNAL("inverse"), self.view.anim.stop)
        QObject.connect(self.panIti, SIGNAL("inverse"), self.play)


    def setSelec(self,Name):
        
        Nom = str(Name)
        print self.view.mapFromScene(graph[Nom].pos())
        
        w = self.width()
        h = self.height()
        if self.panIti.toggle:
            if self.Selec[0] != Nom and Nom != self.Selec[1]:
                for value in graph:
                    graph[value].deselec()
                self.gps.deselec()
                for item in self.CheminItem:
                    self.scene.removeItem(item)
                self.scene.removeItem(self.rectCalc)
                self.panDepart.playX(w)
                self.panArrivee.playX(w)
                self.panIti.playX(w)
            
                self.Selec = (Nom,'')
            
                self.panDepart.playX(w,Nom)
                graph[Nom].selec() 
            
            self.scene.update()
        else:
            if Nom == self.Selec[0] or Nom == self.Selec[1]:
                self.colorise()
                    
            elif self.Selec[0] == '':
                self.Selec = (Nom,self.Selec[1])
                graph[Nom].selec()
                self.scene.update()

                self.panDepart.playX(w,Nom)
                if self.Selec[1] != '':
                    self.panIti.playX(w,Nom)
            
        
            else:
                if self.Selec[0] != Nom and Nom != self.Selec[1]:
                    self.deselec(self.Selec[1])
                    self.Selec = (self.Selec[0],Nom)
                    
                    graph[Nom].selec()
                    self.scene.update()
                
                    self.panArrivee.playX(w,Nom)
                    self.panIti.playX(w,Nom)

            """else:
            if Nom == self.Selec[0] or Nom == self.Selec[1]:
                if not self.panIti.toggle:
                    self.colorise()

            else:
                if self.panIti.toggle: 
                    for value in graph:
                            graph[value].deselec()
                    self.panDepart.playX(800)
                    self.panArrivee.playX(800)
                    self.panIti.playX(800)
                    self.Selec = (Nom,'')
                    self.panDepart.playX(800,Nom)
                    graph[Nom].selec() 
                    self.scene.update()
                else:
                    for value in graph:
                            graph[value].deselec()
                    self.panArrivee.playX(800)
                    self.Selec = (self.Selec[0],Nom)
                    graph[self.Selec[0]].selec()
                    graph[Nom].selec()
                    self.scene.update()
            
                    self.panArrivee.playX(800,Nom)
                
        if not '' in self.Selec and not self.panIti.toggle:
            self.panIti.playX(800,Nom)"""
        
            #MainWindow.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)


            #MainWindow.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)'''
            
    """def deSelec(self):
        if not self.panIti.toggle:
            for value in graph:
                    graph[value].deselec()
                    #self.scene.update()
            self.Selec = ('','')
            self.panDepart.playX(800)
            self.panArrivee.playX(800)
            self.panIti.playX(800)
        self.scene.update()"""
        
    def rectSelec(self,p):
        point = self.view.mapFromScene(p)
        #print p, point
        r = QRect(point.x()-10.,point.y()-10.,20.,20.)
        rect = self.view.mapToScene(r)
        #print "point vide", point, "carre de selec", rect
        liste = self.scene.items(rect)
        #print liste
        listeNom = []
        for element in liste:
            if element.type() == 65536:
                listeNom += [element.name]
            elif element.type() == 4:
                listeNom += ['GPS']
                
        #print listeNom
#        if "GPS" in listeNom:
#            if listeNom == ["GPS"]:
#                print 'gps tout seul'
#                #self.gpsSearch(point)
#            elif len(listeNom) > 1:
#                listeNom.remove("GPS")
        
        if len(listeNom) == 1:
            self.setSelec(listeNom[0])
            if listeNom[0] == 'GPS':
                self.gps.selec()
        elif len(listeNom) > 1:
            Selec , ok = QInputDialog.getItem ( self.view, 'Liste de stations' , "Choisir la station :", listeNom, 0, False)
            if ok:
                self.setSelec(Selec)
                if Selec == 'GPS':
                    self.gps.selec()
                

    def gpsSearch(self,x,y):
        point = self.view.mapFromScene(x,y)
        proche = []
        k = 1
        while proche == []:
            r = QRect(point.x()-k*10.,point.y()-k*10.,k*20.,k*20.)
            rect = self.view.mapToScene(r)
            liste = self.scene.items(rect)
#            print "proche avant", proche
            for element in liste:
                if element.type() == 65536 and element.name != "GPS":
                    proche += [element]
                    print element.name
#            print 'apres', proche
            k += 1
        print k
        listeNom = []
        for element in proche:
            if element.type() == 65536:
                listeNom += [element.name]
        if len(listeNom) == 1:
            return listeNom[0]
        elif len(listeNom) > 1:
            Selec , ok = QInputDialog.getItem ( self.view, 'Liste de stations' , "Choisir la station :", listeNom, 0, False)
            if ok:
                return Selec
        
    def deselec(self,Nom):
        w = self.width()
        h = self.height()
        self.scene.removeItem(self.rectCalc)
        for item in self.CheminItem:
            self.scene.removeItem(item)
        
        
        
        for value in graph:
                graph[value].deselec()
        self.scene.update()
        if Nom == self.Selec[0]:
            self.Selec = ('',self.Selec[1])
            if self.Selec[1] != '':
                graph[self.Selec[1]].selec()
            self.panDepart.playX(w)
            self.panIti.playX(w)
        else:
            self.Selec = (self.Selec[0],'')
            if self.Selec[0] != '':
                graph[self.Selec[0]].selec()
            self.panArrivee.playX(w)
            self.panIti.playX(w)
        if Nom == 'GPS':
            self.gps.deselec()
        
        
        
    def colorise(self):
        self.scene.addItem(self.rectCalc)
        self.CheminItem = []
        print self.Selec
        if self.Selec[0] == 'GPS':
            proche = self.gpsSearch(self.gps.x(),self.gps.y())
            graph['GPS'].addCorres(str(proche))
            self.Chemin = ['GPS'] + dijkstra.algo(str(proche),self.Selec[1])
        elif  self.Selec[1] == 'GPS':
            proche = self.gpsSearch(self.gps.x(),self.gps.y())
            self.Chemin = dijkstra.algo(self.Selec[0],str(proche)) + ["GPS"]
            graph[str(proche)].addCorres("GPS")
        else:
            self.Chemin = dijkstra.algo(self.Selec[0],self.Selec[1])
        #print 'la liste a colorie ', liste
        #graph[self.Chemin[0]].changeColor(self.palette().midlight().color())
        #graph[self.Chemin[-1]].changeColor(self.palette().light().color())

        dep = self.Chemin[0]
        for dest in self.Chemin[1:]:
            idx = graph[dep].corres.index(dest)
            line = QGraphicsLineItem ( 
                    graph[dep].posX + _RAYON/2, 
                    graph[dep].posY + _RAYON/2, 
                    graph[dest].posX + _RAYON/2, 
                    graph[dest].posY + _RAYON/2, 
                    )
            line.setPen(QPen(graph[dep].corresColor[idx], _RAYON))
            self.CheminItem.append(line)
            dep = dest
        dep = self.Chemin[0]
        for dest in self.Chemin:
            gradient = QRadialGradient(graph[dest].posX,graph[dest].posY, _RAYON*1.5)
            try:
                idx = graph[dest].corres.index(dep)

                gradient.setColorAt(0, graph[dest].corresColor[idx].lighter(200))
                gradient.setColorAt(1, graph[dest].corresColor[idx])
            except ValueError:
                gradient.setColorAt(0, graph[dest].color.color().lighter(200))
                gradient.setColorAt(1, graph[dest].color.color())
            except AttributeError:
                gradient.setColorAt(0, graph[dest].color.color())
                gradient.setColorAt(1, graph[dest].color.color())
                
            ellipse = QGraphicsEllipseItem ( 
                    graph[dest].posX-_RAYON/2, 
                    graph[dest].posY-_RAYON/2, 
                    _RAYON*2, 
                    _RAYON*2, 
                    )
            ellipse.setPen(QPen(Qt.NoPen))
            ellipse.setBrush(QBrush(gradient))
            self.CheminItem.append(ellipse)
            dep = dest
        dep = self.Chemin[0]
        for dest in self.Chemin:
            if not graph[dest].name[:-4] in graph[dep].name or dest == dep:
                if graph[dest].name[-1] == ']':
                    txt = QGraphicsTextItem (graph[dest].name[:-4])
                else:
                    txt = QGraphicsTextItem (graph[dest].name)
                txt.setPos(graph[dest].posX , graph[dest].posY-_RAYON/2)
                txt.setFont(QFont ( "Nokia Sans",_RAYON/2 ,63 ))
    
                try:
                    idx = graph[dest].corres.index(dep)
    
                    txt.setDefaultTextColor(graph[dest].corresColor[idx])
                except ValueError:
                    txt.setDefaultTextColor(graph[dest].color.color())
                except AttributeError:
                    txt.setDefaultTextColor(graph[dest].color.color())
                    
                if graph[dest].name[-1] == ']':
                    txtOmbre = QGraphicsTextItem (graph[dest].name[:-4])
                else:
                    txtOmbre = QGraphicsTextItem (graph[dest].name)
                txtOmbre.setPos(graph[dest].posX-.25, graph[dest].posY-_RAYON/2+.25)
                txtOmbre.setDefaultTextColor(Qt.black)
                txtOmbre.setFont(QFont ( "Nokia Sans",_RAYON/2 ,63 ))
    
                self.CheminItem.append(txtOmbre)
                self.CheminItem.append(txt)
            dep = dest

        for item in self.CheminItem:
            self.scene.addItem(item)
        self.scene.update()
        self.panIti.toggling()
        try:
            graph[str(proche)].removeCorres("GPS")
        except UnboundLocalError:
            print "no GPS"
        
    def inverse(self):
        w = self.width()
        self.panDepart.playX(w)
        self.panArrivee.playX(w)
        self.panIti.playX(w)

        for value in graph:
            graph[value].deselec()
        old = self.Selec
        self.Selec = ('','')
        
        self.setSelec(old[1])
        self.setSelec(old[0])
        
        

    def orientationChanged(self, i):
        self.panArrivee.move(self.panArrivee.x(),app.desktop().screenGeometry().height()-126)
        self.panIti.move(self.panIti.x(),app.desktop().screenGeometry().height()/2-76)
        self.view.translate(-150,200)
        
        self.gpsButton.move(16,app.desktop().screenGeometry().height()-80-56)

        if self.panDepart.state :
            self.panDepart.move(app.desktop().screenGeometry().width()-min(290,self.panDepart.width()),self.panDepart.y())
        if self.panArrivee.state :
            self.panArrivee.move(app.desktop().screenGeometry().width()-min(290,self.panArrivee.width()),self.panArrivee.y())
        if self.panIti.state :
            self.panIti.move(app.desktop().screenGeometry().width()-100,self.panIti.y())
            self.panIti.animMargin.start()



        
    def setupUi(self, App):
        self.setWindowTitle("Rtap")
        self.resize(800,480)
#        MainWindow.setAttribute(Qt.WA_TranslucentBackground,True)
#        MainWindow.eventFilter = self.event_Filter
        global app
        app = App
#        MainWindow = MainWin
        self.centralWidget = QWidget(self)
        self.Selec = ('','')
        self.CheminItem = []
        self.Chemin = []
        
        self.scene = classes.Carte(self)
        self.scene.setSceneRect(-815.90800894434585, -2585.2493331816809, 5397.5130039461728, 3900.3854289115216)
        #path = QPainterPath()
        #path.addEllipse ( 0, 0, _RAYON*2 , _RAYON * 2 )
        #self.scene.setSelectionArea ( path)
        fleuve = QPainterPath()
        fleuve.moveTo(station.SeineX[0], station.SeineY[0])
        l = len(station.SeineX)
        k = 1
        while k != l:
            fleuve.lineTo(station.SeineX[k], station.SeineY[k])
            k += 1

        fleuve.moveTo(station.OiseX[0], station.OiseY[0])
        l = len(station.OiseX)
        k = 1
        while k != l:
            fleuve.lineTo(station.OiseX[k], station.OiseY[k])
            k += 1

        fleuve.moveTo(station.MarneX[0], station.MarneY[0])
        l = len(station.MarneX)
        k = 1
        while k != l:
            fleuve.lineTo(station.MarneX[k], station.MarneY[k])
            k += 1
           
        fleuve.moveTo(station.SeineIleX[0], station.SeineIleY[0])
        l = len(station.SeineIleX)
        k = 1
        while k != l:
            fleuve.lineTo(station.SeineIleX[k], station.SeineIleY[k])
            k += 1
           
        self.scene.addPath(fleuve, QPen( QColor(165,191,221), _RAYON*.8))
        
        for dep in graph:
            k = 0
            while k < len(graph[dep].corres):
                dest = graph[dep].corres[k]
                
                self.scene.addLine ( 
                    graph[dep].posX + _RAYON/2, 
                    graph[dep].posY + _RAYON/2, 
                    graph[dest].posX + _RAYON/2, 
                    graph[dest].posY + _RAYON/2, 
                    QPen(graph[dep].corresColor[k], _RAYON/4)
                    )        

                try:
                    if graph[dep].corresColor[k] == graph[dep].corresColor[k+1] and graph[dep].corresColor[k] != station.LigneM:
                        k += 2
                    else:
                        k += 1
                except IndexError:
                    k += 1

        for value in graph:
            if graph[value].name[-1] != "]" and graph[value].name != 'GPS':
                self.scene.addItem(graph[value])
            #graph[value].setFlag(QGraphicsItem.ItemIsSelectable,True)

        #QObject.connect(self.scene, SIGNAL("clicked(QString,QPointF)"), self.setSelec)
        QObject.connect(self.scene, SIGNAL("unclicked(QPointF)"), self.rectSelec)


        self.scene.setBackgroundBrush(self.palette().shadow().color())
        self.view = classes.Fond(self.scene)
        self.view.setDragMode(1)
        self.view.setVerticalScrollBarPolicy ( Qt.ScrollBarAlwaysOff )
        self.view.setHorizontalScrollBarPolicy ( Qt.ScrollBarAlwaysOff )

        self.rectCalc = QGraphicsRectItem (self.view.sceneRect())
        self.rectCalc.setBrush(QBrush(QColor(0,0,0,153)))

        self.panDepart = classes.PanDepart(self.view)
        self.panDepart.setGeometry(900,0,250,180)
        QObject.connect(self.panDepart, SIGNAL("released(QString)"), self.deselec)
        self.panDepart.show()


        self.panArrivee = classes.PanDepart(self.view)
        self.panArrivee.setGeometry(900,app.desktop().screenGeometry().height()-126,250,180)
        QObject.connect(self.panArrivee, SIGNAL("released(QString)"), self.deselec)
        self.panArrivee.show()

        self.panIti = classes.PanIti(self.view)
        self.panIti.setGeometry(900,app.desktop().screenGeometry().height()/2-56-20,80,80)
        QObject.connect(self.panIti, SIGNAL("colorise"), self.colorise)
        QObject.connect(self.panIti, SIGNAL("inverse"), self.play)
        self.panIti.show()
        self.panIti.animMargin.start()

##########
#        self.locationLabel = QLabel(self.tr("Lat: Long:"),self.view)
#        self.locationLabel.setGeometry(0,0,400,50)
#        self.locationLabel.show()

        self.gpsButton = classes.GpsButton(self.view)
        QObject.connect(self.gpsButton, SIGNAL("gpsOn"), self.openSession)
        QObject.connect(self.gpsButton, SIGNAL("gpsOff"), self.closeSession)
        QObject.connect(self.gpsButton, SIGNAL("gpsCenter"), self.gpsCenter)
        self.gpsButton.setGeometry(16,app.desktop().screenGeometry().height()-80-56,80,80)
        self.gpsButton.show()


#        self.gps = graph["GPS"]
        self.gps = classes.Gps()



#########

        if app.desktop().screenGeometry().width() < app.desktop().screenGeometry().height():
            self.view.centerOn(1900.,-500)        
        else:
            self.view.centerOn(1750.,-400)
        self.view.show()

        self.setCentralWidget(self.view)

        QObject.connect(app.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        
        

