#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
import math
import station

_RAYON = station._RAYON
_TEMPS_ANIM = 1000
_TEMPS_CLICK = 750

class Fond(QGraphicsView):

    def __init__(self, parent=None):
        super(Fond, self).__init__(parent)

        self.Scale = 1.0
        self.myFirstPoint = QPoint(0,0)
        self.myCurrentPoint = QPoint(0,0)
        self.myFirstScale  = 1.0
        self.myOrig = QPointF(400, 200)
        self.moved = False
        self.dblClicked = False

        self.anim = QSequentialAnimationGroup()
        self.anim.finished.connect(self.anim.clear)


    def resizeEvent ( self, event ):
        self.emit(SIGNAL("resized()"))

        
    def mouseDoubleClickEvent(self, event):
        #self.emit(SIGNAL("doubleClicked"))
        self.dblClicked = True
        self.myFirstPoint = event.pos()
        self.myCurrentPoint = event.pos()
        QObject.connect(self, SIGNAL("position(QPointF)"), self.zoom)
        QGraphicsView.mouseDoubleClickEvent (self, event)


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released()"))
        QObject.disconnect(self, SIGNAL("position(QPointF)"), self.zoom)
        if QRect( self.myFirstPoint-QPoint(5,5) , self.myFirstPoint+QPoint(5,5)).contains(self.myCurrentPoint)  and self.dblClicked:
            self.dblClicked = False
            self.scene().doubleClick(self.mapToScene(event.pos()))
        else:
            self.dblClicked = False
            self.moved = False
        #self.myFirstScale = self.Scale
        QGraphicsView.mouseReleaseEvent (self, event)
            

    def mouseMoveEvent(self,event):
        self.moved = True
        self.emit(SIGNAL("position(QPointF)"),event.posF())
        self.myCurrentPoint = event.pos()
        QGraphicsView.mouseMoveEvent (self, event)


    def dist(self,A,B):
        return math.sqrt((A.x() - B.x())**2 + (A.y() - B.y())**2)
        
        
    def zoom(self,point):
        centre = QPointF(0,0)
        scale = self.dist(point,centre) / self.dist(self.myFirstPoint,centre) 
#        print 'scale:' , scale , scale**.2
        self.Scale = max(min(self.Scale * scale**.5, 5.),.21)
        if self.Scale != 5. and self.Scale != .21:
            self.scale( scale**.5, scale**.5)
            self.emit(SIGNAL("zoom(float)"),scale**.5)
            self.update()
        
    def decalage(self,i):
        self.translate(i*2000,200)
        self.update()
        
    def setCenter(self,point):
        self.centerOn(point)
       
    def getCenter(self):
        return self.mapToScene(self.rect().center())

    center = pyqtProperty(QPointF, fget=getCenter, fset=setCenter)
        

#        

class Carte(QGraphicsScene):

    def doubleClick  ( self, p ):
        #print "pos du click", p
        #try:
        #    self.emit(SIGNAL("clicked(QString,QPointF)"), QString(self.itemAt(p).name),p)
            
        #except AttributeError:
        self.emit(SIGNAL("unclicked(QPointF)"),p)
        #QGraphicsScene.mouseDoubleClickEvent (self, e)


        
        
   

        

class PanDepart(QLabel):   
    def __init__(self, parent=None):
        super(PanDepart, self).__init__(parent)

        self.state = False
        self.setFont(QFont ( "Nokia Sans",_RAYON*2  ))
        self.setAlignment(Qt.AlignCenter)
#        self.setAutoFillBackground(True)
#        self.palette().setColor(QPalette.Text,Qt.red)
#        self.palette().setCurrentColorGroup(1)
        self.setStyleSheet("background-color: qlineargradient(x1:-0.5, y1:-0.5, x2:1, y2:1, stop:0 white,  stop:1 palette(highlight)) ; color: palette(highlighted-text) ;border:3px solid gray; border-top-style: none; border-right-style: none")

        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animY = QPropertyAnimation (self, "pos")
        self.animY.setDuration(_TEMPS_ANIM/5)
        self.animY.setEasingCurve(QEasingCurve.OutBack)


    def playX(self,w,text=''):
        
        #print 'clicked', rect.x()+200

        y = self.y()
        if not self.state and text != '':
            size = self.fontMetrics().size(Qt.TextSingleLine,text)
            
            self.resize(size.width()+_RAYON*2,70)
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-min(290,self.width()),y) )
            self.emit(SIGNAL("showing(int)"),-1)
            self.state = True
            self.animX.start()

        elif self.text() != '':
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(w-min(290,self.width()),y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.emit(SIGNAL("showing(int)"),1)
            self.state = False
            self.animX.start()


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released(QString)"),self.text())
        QLabel.mouseReleaseEvent (self, event)


class PanIti(QLabel):   
    def __init__(self, parent=None):
        super(PanIti, self).__init__(parent)
        
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))
        self.setScaledContents( True )
        self.setMargin(0)
        self.toggle = False
        self.text = ''
        self.state = False
        
        
        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animMargin = QPropertyAnimation (self, "margin")
        self.animMargin.setDuration(_TEMPS_ANIM)
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 30)
        self.animMargin.setKeyValueAt(1, 6)


    def mousePressEvent(self,event):
        self.animMargin.setEasingCurve(QEasingCurve.OutElastic)
        self.animMargin.setKeyValueAt(0, 0)
        self.animMargin.start()
        if not self.toggle:
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing.png"))
        QLabel.mousePressEvent (self, event)

        
    def toggling(self):
        self.toggle = True
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 20)
        self.animMargin.start()

    def mouseReleaseEvent(self,event):
        if not self.toggle:
            self.emit(SIGNAL("colorise"))
        else:
            self.emit(SIGNAL("inverse"))
        QLabel.mouseReleaseEvent (self, event)

    def playX(self,w,text=''):
        
        #print 'clicked', rect.x()+200

        y = self.y()
        if not self.state and text != '':
            #size = self.fontMetrics().size(Qt.TextSingleLine,text)
            
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-100,y) )
            self.state = True
            self.animX.start()
            self.animMargin.start()

        elif self.text != '':
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(w-100,y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.state = False
            self.toggle = False
            self.animX.start()
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))


class GpsButton(QLabel):   
    def __init__(self, parent=None):
        super(GpsButton, self).__init__(parent)
        self.pixOn = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_stop_ani.png")
        self.pixOff = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_on")
        self.setPixmap (  self.pixOff)
        self.state = False
        
        self.click = QTimer(self)
        self.click.setSingleShot (True )
        
    def center(self):
        if self.state:
            self.emit(SIGNAL("gpsCenter"))
        self.click.stop()

    def mouseDoubleClickEvent(self, event):
        #self.emit(SIGNAL("doubleClicked"))
        self.changeState()
        QLabel.mouseDoubleClickEvent (self, event)
        
    def mouseReleaseEvent(self,event):
        self.click.stop()
        QLabel.mouseReleaseEvent (self, event)
        

    def mousePressEvent(self,event):
        self.click.stop()
        self.click.start(_TEMPS_CLICK)
        QLabel.mousePressEvent (self, event)
        

    def changeState(self):
        self.click.stop()
        if self.state:
            
            self.emit(SIGNAL("gpsOff"))
            self.setPixmap (  self.pixOff)
            QObject.disconnect(self.click, SIGNAL("timeout()"), self.center)
            self.state = False

        else:
            self.emit(SIGNAL("gpsOn"))
            self.setPixmap (  self.pixOn)
            QObject.connect(self.click, SIGNAL("timeout()"), self.center)
            self.state = True

        
        
class Gps(QGraphicsEllipseItem):
    def __init__(self, parent=None):
        super(Gps, self).__init__()
        
        self.setRect(0.,0., _RAYON*1, _RAYON*1)
        
        self.setBrush(Qt.green)

        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.black)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))
        
    def width(self):
        return self.rect().width()

    def height(self):
        return self.rect().height()

    def selec(self):
        print 'selec gps'
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(0, Qt.white)
        gradient.setColorAt(1, Qt.red)
        self.setPen(QPen( gradient, _RAYON))
        
   
    def deselec(self):
        print 'deselec gps'
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.black)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))


