/*
    This file belongs to rs (Remote security) package for Nokia N900
    Copyright (C) 2009  Pavan Patale <pavan.patale@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <glib.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>

#include "rs-utils.h"

static DBusConnection *con = NULL;

static DBusConnection *dbus_get_system_bus (void)
{ 
    DBusError error;
  
    if (con != NULL)
        return con;
  
    dbus_error_init (&error);
    con = dbus_bus_get (DBUS_BUS_SYSTEM, &error);
    if (dbus_error_is_set(&error))
    {
        g_print ("Failed to initialize dbus system bus: '%s'",
             error.message);
        dbus_error_free(&error);
        return NULL;
    }
  
    /* while dbus is under construction, do this */
    dbus_connection_setup_with_g_main (con, NULL);
  
    return con;
}

static DBusMessage *dbus_get_reply_msg(DBusMessage *msg)
{

    DBusError dbus_error;
    DBusMessage *reply = NULL;
  
    if (dbus_message_get_type (msg) != DBUS_MESSAGE_TYPE_METHOD_CALL)
    {
        g_print ("dbus message %p is not a method call", msg);
        return NULL;
    }
    
    dbus_error_init (&dbus_error);
    reply = dbus_connection_send_with_reply_and_block (dbus_get_system_bus(),
                                                     msg, 5000, &dbus_error);
    if (reply == NULL)
    {
        g_print ("Failed DBUS method call with error '%s': %s", dbus_error.name,
             dbus_error.message);
        dbus_error_free (&dbus_error);
    } 
    
    return reply;
}


const gchar *rs_utils_phone_get_current_imsi()
{
    DBusMessage* msg;
    DBusMessage* reply = NULL;
    gchar *imsi = NULL;
    DBusError error;

    con = dbus_get_system_bus ();

    msg = dbus_message_new_method_call("com.nokia.phone.SIM", // target for the method call
                                       "/com/nokia/phone/SIM", // object to call on
                                       "Phone.Sim", // interface to call on
                                       "get_imsi"); // method name

    if(msg)
    {
        reply = dbus_get_reply_msg(msg);
        if (reply)
            dbus_message_get_args (reply, NULL,
                             DBUS_TYPE_STRING, &imsi,
                             DBUS_TYPE_INT32,  &error,
                             DBUS_TYPE_INVALID);
    }

    if (msg != NULL) 
        dbus_message_unref (msg);
    if (reply != NULL)
	dbus_message_unref (reply);

    return imsi;
}
