#ifndef _OPLTABLES_H_
#define _OPLTABLES_H_

/* Precalculated emu8950 tables for use in Rockbox, 
   Calculated for 44Khz sampling rate */

static const short ar_adjust_coeff[] = {
 	 255,  227,  210,  198,  189,  181,  175,  170,  165,  161,  157, 
	 153,  150,  147,  144,  141,  139,  136,  134,  132,  130,  128, 
	 126,  125,  123,  121,  120,  118,  117,  115,  114,  113,  112, 
	 110,  109,  108,  107,  106,  105,  104,  103,  102,  101,  100, 
	  99,   98,   97,   96,   95,   94,   94,   93,   92,   91,   91, 
	  90,   89,   88,   88,   87,   86,   86,   85,   84,   84,   83, 
	  82,   82,   81,   81,   80,   79,   79,   78,   78,   77,   77, 
	  76,   76,   75,   75,   74,   74,   73,   73,   72,   72,   71, 
	  71,   70,   70,   69,   69,   69,   68,   68,   67,   67,   66, 
	  66,   66,   65,   65,   64,   64,   64,   63,   63,   62,   62, 
	  62,   61,   61,   61,   60,   60,   60,   59,   59,   59,   58, 
	  58,   58,   57,   57,   57,   56,   56,   56,   55,   55,   55, 
	  54,   54,   54,   53,   53,   53,   53,   52,   52,   52,   51, 
	  51,   51,   50,   50,   50,   50,   49,   49,   49,   49,   48, 
	  48,   48,   48,   47,   47,   47,   46,   46,   46,   46,   45, 
	  45,   45,   45,   44,   44,   44,   44,   44,   43,   43,   43, 
	  43,   42,   42,   42,   42,   41,   41,   41,   41,   41,   40, 
	  40,   40,   40,   39,   39,   39,   39,   39,   38,   38,   38, 
	  38,   38,   37,   37,   37,   37,   37,   36,   36,   36,   36, 
	  36,   35,   35,   35,   35,   35,   34,   34,   34,   34,   34, 
	  33,   33,   33,   33,   33,   33,   32,   32,   32,   32,   32, 
	  31,   31,   31,   31,   31,   31,   30,   30,   30,   30,   30, 
	  30,   29,   29,   29,   29,   29,   29,   28,   28,   28,   28, 
	  28,   28,   27,   27,   27,   27,   27,   27,   26,   26,   26, 
	  26,   26,   26,   26,   25,   25,   25,   25,   25,   25,   25, 
	  24,   24,   24,   24,   24,   24,   23,   23,   23,   23,   23, 
	  23,   23,   22,   22,   22,   22,   22,   22,   22,   21,   21, 
	  21,   21,   21,   21,   21,   21,   20,   20,   20,   20,   20, 
	  20,   20,   19,   19,   19,   19,   19,   19,   19,   19,   18, 
	  18,   18,   18,   18,   18,   18,   18,   17,   17,   17,   17, 
	  17,   17,   17,   17,   16,   16,   16,   16,   16,   16,   16, 
	  16,   15,   15,   15,   15,   15,   15,   15,   15,   14,   14, 
	  14,   14,   14,   14,   14,   14,   14,   13,   13,   13,   13, 
	  13,   13,   13,   13,   13,   12,   12,   12,   12,   12,   12, 
	  12,   12,   12,   11,   11,   11,   11,   11,   11,   11,   11, 
	  11,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10, 
	   9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    8, 
	   8,    8,    8,    8,    8,    8,    8,    8,    8,    7,    7, 
	   7,    7,    7,    7,    7,    7,    7,    7,    6,    6,    6, 
	   6,    6,    6,    6,    6,    6,    6,    5,    5,    5,    5, 
	   5,    5,    5,    5,    5,    5,    5,    4,    4,    4,    4, 
	   4,    4,    4,    4,    4,    4,    4,    3,    3,    3,    3, 
	   3,    3,    3,    3,    3,    3,    3,    3,    2,    2,    2, 
	   2,    2,    2,    2,    2,    2,    2,    2,    1,    1,    1, 
	   1,    1,    1,    1,    1,    1,    1,    1,    1,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0
};
   
static const short db2lin_coeff[] = {
	2047, 2003, 1960, 1918, 1877, 1837, 1798, 1759, 1722, 1685, 1649, 
	1614, 1579, 1546, 1513, 1480, 1449, 1418, 1387, 1358, 1329, 1300, 
	1273, 1245, 1219, 1193, 1167, 1142, 1118, 1094, 1071, 1048, 1025, 
	1004,  982,  961,  941,  920,  901,  882,  863,  844,  826,  809, 
	 791,  774,  758,  742,  726,  710,  695,  680,  666,  651,  638, 
	 624,  611,  598,  585,  572,  560,  548,  536,  525,  514,  503, 
	 492,  481,  471,  461,  451,  442,  432,  423,  414,  405,  396, 
	 388,  380,  371,  364,  356,  348,  341,  333,  326,  319,  312, 
	 306,  299,  293,  287,  280,  274,  269,  263,  257,  252,  246, 
	 241,  236,  231,  226,  221,  216,  212,  207,  203,  198,  194, 
	 190,  186,  182,  178,  174,  170,  167,  163,  160,  156,  153, 
	 150,  147,  143,  140,  137,  134,  131,  129,  126,  123,  121, 
	 118,  115,  113,  111,  108,  106,  104,  101,   99,   97,   95, 
	  93,   91,   89,   87,   85,   83,   82,   80,   78,   76,   75, 
	  73,   72,   70,   69,   67,   66,   64,   63,   61,   60,   59, 
	  58,   56,   55,   54,   53,   52,   51,   49,   48,   47,   46, 
	  45,   44,   43,   42,   42,   41,   40,   39,   38,   37,   36, 
	  36,   35,   34,   33,   33,   32,   31,   31,   30,   29,   29, 
	  28,   27,   27,   26,   26,   25,   25,   24,   23,   23,   22, 
	  22,   21,   21,   21,   20,   20,   19,   19,   18,   18,   18, 
	  17,   17,   16,   16,   16,   15,   15,   15,   14,   14,   14, 
	  13,   13,   13,   13,   12,   12,   12,   12,   11,   11,   11, 
	  11,   10,   10,   10,   10,    9,    9,    9,    9,    9,    8, 
	   8,    8,    8,    8,    7,    7,    7,    7,    7,    7,    7, 
	   6,    6,    6,    6,    6,    6,    6,    5,    5,    5,    5, 
	   5,    5,    5,    5,    4,    4,    4,    4,    4,    4,    4, 
	   4,    4,    4,    3,    3,    3,    3,    3,    3,    3,    3, 
	   3,    3,    3,    3,    3,    3,    2,    2,    2,    2,    2, 
	   2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2, 
	   2,    2,    2,    1,    1,    1,    1,    1,    1,    1,    1, 
	   1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1, 
	   1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1, 
	   1,    1,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
  	   0,    0,    0,    0,    0,    0
};

static const short sin_coeff[] = {
	 511,  235,  203,  185,  171,  161,  152,  145,  139,  134,  129, 
 	 124,  120,  117,  113,  110,  107,  104,  102,   99,   97,   95, 
	  92,   90,   88,   87,   85,   83,   81,   80,   78,   77,   75, 
	  74,   72,   71,   70,   69,   67,   66,   65,   64,   63,   62, 
	  61,   60,   59,   58,   57,   56,   55,   54,   53,   52,   52, 
	  51,   50,   49,   48,   48,   47,   46,   45,   45,   44,   43, 
	  43,   42,   41,   41,   40,   39,   39,   38,   38,   37,   37, 
	  36,   35,   35,   34,   34,   33,   33,   32,   32,   31,   31, 
	  30,   30,   29,   29,   28,   28,   28,   27,   27,   26,   26, 
	  25,   25,   25,   24,   24,   23,   23,   23,   22,   22,   22, 
	  21,   21,   21,   20,   20,   20,   19,   19,   19,   18,   18, 
	  18,   17,   17,   17,   16,   16,   16,   16,   15,   15,   15, 
	  14,   14,   14,   14,   13,   13,   13,   13,   12,   12,   12, 
	  12,   11,   11,   11,   11,   11,   10,   10,   10,   10,    9, 
	   9,    9,    9,    9,    8,    8,    8,    8,    8,    7,    7, 
	   7,    7,    7,    7,    6,    6,    6,    6,    6,    6,    5, 
	   5,    5,    5,    5,    5,    5,    4,    4,    4,    4,    4, 
	   4,    4,    4,    3,    3,    3,    3,    3,    3,    3,    3, 
	   2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2, 
	   1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1, 
	   1,    1,    1,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0, 
};

static const short pm0_coeff[] = {
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
 	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  257,  257,  257,  257,  257,  257,  257,  257,  257, 
	 257,  257,  257,  257,  257,  257,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  254, 
	 254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254, 
	 254,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255, 
};

static const short pm1_coeff[] = {
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
 	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  257, 
	 257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257, 
	 257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257, 
	 257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257, 
	 257,  258,  258,  258,  258,  258,  258,  258,  258,  258,  258, 
	 258,  258,  258,  258,  258,  258,  258,  257,  257,  257,  257, 
	 257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257, 
	 257,  257,  257,  257,  257,  257,  257,  257,  257,  257,  257, 
	 257,  257,  257,  257,  257,  257,  257,  257,  257,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
	 256,  256,  256,  256,  256,  256,  256,  256,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  254,  254,  254,  254,  254, 
	 254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254, 
	 254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254, 
	 254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  253, 
	 253,  253,  253,  253,  253,  253,  253,  253,  253,  253,  253, 
	 253,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254, 
	 254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254, 
	 254,  254,  254,  254,  254,  254,  254,  254,  254,  254,  254, 
	 254,  254,  254,  254,  254,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255,  255,  255,  255,  255,  255,  255,  255,  255, 
	 255,  255,  255, 
};

static const short am0_coeff[] = {
	   2,    2,    2,    2,    2,    2,    3,    3,    3,    3,    3, 
	   3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3, 
	   4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4, 
	   4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4, 
	   5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5, 
	   5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5, 
	   5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5, 
	   5,    5,    5,    5,    5,    5,    5,    5,    4,    4,    4, 
	   4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4, 
	   4,    4,    4,    4,    4,    4,    4,    4,    3,    3,    3, 
	   3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3, 
	   3,    3,    2,    2,    2,    2,    2,    2,    2,    2,    2, 
	   2,    2,    2,    2,    2,    2,    2,    1,    1,    1,    1, 
	   1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1, 
	   1,    1,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    1, 
	   1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1, 
	   1,    1,    1,    1,    2,    2,    2,    2,    2,    2,    2, 
	   2,    2,    2, 
};

static const short am1_coeff[] = {
	  12,   13,   13,   13,   14,   14,   14,   14,   15,   15,   15, 
	  16,   16,   16,   17,   17,   17,   17,   18,   18,   18,   19, 
	  19,   19,   19,   20,   20,   20,   20,   21,   21,   21,   21, 
	  22,   22,   22,   22,   22,   23,   23,   23,   23,   23,   23, 
	  24,   24,   24,   24,   24,   24,   24,   24,   25,   25,   25, 
	  25,   25,   25,   25,   25,   25,   25,   25,   25,   25,   25, 
	  25,   25,   25,   25,   25,   25,   25,   25,   25,   25,   25, 
	  24,   24,   24,   24,   24,   24,   24,   24,   23,   23,   23, 
	  23,   23,   23,   22,   22,   22,   22,   22,   21,   21,   21, 
	  21,   20,   20,   20,   20,   19,   19,   19,   19,   18,   18, 
	  18,   17,   17,   17,   17,   16,   16,   16,   15,   15,   15, 
	  14,   14,   14,   14,   13,   13,   13,   12,   12,   12,   11, 
	  11,   11,   10,   10,   10,    9,    9,    9,    9,    8,    8, 
	   8,    7,    7,    7,    7,    6,    6,    6,    5,    5,    5, 
	   5,    4,    4,    4,    4,    3,    3,    3,    3,    3,    2, 
	   2,    2,    2,    2,    1,    1,    1,    1,    1,    1,    1, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
	   1,    1,    1,    1,    1,    1,    1,    2,    2,    2,    2, 
	   2,    3,    3,    3,    3,    3,    4,    4,    4,    4,    5, 
	   5,    5,    5,    6,    6,    6,    7,    7,    7,    7,    8, 
	   8,    8,    9,    9,    9,    9,   10,   10,   10,   11,   11, 
	  11,   12,   12, 
};

#endif
