/*
 * Copyright 2007 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License.  You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#include <linux/mm.h>
#include <linux/init.h>
#include <asm/hardware.h>
#include <asm/pgtable.h>
#include <asm/mach/map.h>

/*!
 * @file mach-mx37/mm.c
 *
 * @brief This file creates static mapping between physical to virtual memory.
 *
 * @ingroup Memory_MX37
 */

/*!
 * This structure defines the MX37 memory map.
 */
static struct map_desc mxc_io_desc[] __initdata = {
	{
	 .virtual = IRAM_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(IRAM_BASE_ADDR),
	 .length = IRAM_SIZE,
	 .type = MT_NONSHARED_DEVICE},
	{
	 .virtual = PLATFORM_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(PLATFORM_BASE_ADDR),
	 .length = PLATFORM_SIZE,
	 .type = MT_DEVICE},
	{
	 .virtual = DEBUG_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(DEBUG_BASE_ADDR),
	 .length = DEBUG_SIZE,
	 .type = MT_NONSHARED_DEVICE},
	{
	 .virtual = TZIC_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(TZIC_BASE_ADDR),
	 .length = TZIC_SIZE,
	 .type = MT_NONSHARED_DEVICE},
	{
	 .virtual = AIPS1_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(AIPS1_BASE_ADDR),
	 .length = AIPS1_SIZE,
	 .type = MT_NONSHARED_DEVICE},
	{
	 .virtual = SPBA0_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(SPBA0_BASE_ADDR),
	 .length = SPBA0_SIZE,
	 .type = MT_NONSHARED_DEVICE},
	{
	 .virtual = AIPS2_BASE_ADDR_VIRT,
	 .pfn = __phys_to_pfn(AIPS2_BASE_ADDR),
	 .length = AIPS2_SIZE,
	 .type = MT_NONSHARED_DEVICE},
	{
	 .virtual = NFC_BASE_ADDR_AXI_VIRT,
	 .pfn = __phys_to_pfn(NFC_BASE_ADDR_AXI),
	 .length = NFC_AXI_SIZE,
	 .type = MT_DEVICE},
};

/*!
 * This function initializes the memory map. It is called during the
 * system startup to create static physical to virtual memory map for
 * the IO modules.
 */
void __init mxc_map_io(void)
{
	iotable_init(mxc_io_desc, ARRAY_SIZE(mxc_io_desc));
}
