/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2011 by Amaury Pouly
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/
#ifndef POWERMGMT_IMX233_H
#define POWERMGMT_IMX233_H

#include "config.h"
#include "powermgmt.h"

void powermgmt_init_target(void);
void charging_algorithm_step(void);
void charging_algorithm_close(void);

struct imx233_powermgmt_info_t
{
    enum charge_state_type state;
    int charging_timeout; /* time in tick before timeout, -1 if n/a */
    int topoff_timeout; /* ditto */
    int incr_4p2_ilimit_timeout; /* ditto */
};

struct imx233_powermgmt_info_t imx233_powermgmt_get_info(void);

#endif /*  POWERMGMT_IMX233_H */
