/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2010 Robert Bieber
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

#ifndef RBTOUCHAREA_H
#define RBTOUCHAREA_H

#include <QGraphicsItem>

#include "rbrenderinfo.h"
#include "devicestate.h"

class RBTouchArea : public QGraphicsItem
{
public:
    RBTouchArea(int width, int height, QString action,
                const RBRenderInfo& info, QGraphicsItem* parent = 0);
    virtual ~RBTouchArea();

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);

    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    QRectF size;
    QString action;
    DeviceState* device;
    bool debug;
};

#endif // RBTOUCHAREA_H
