/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2009 by Michael Sevakis
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

/*
 * Taken from from the Linux BSP provided by Freescale.
 * Copyright 2004-2008 Freescale Semiconductor, Inc. All Rights Reserved.
 */

#ifndef __SDMA_SCRIPT_CODE_H__
#define __SDMA_SCRIPT_CODE_H__

/* REV 2 (for i.MX system revision > 1.0) */
/*!
* Following define start address of signature script
*/
#define signature_ADDR_2    1023
/*!
* Following define size of signature script
*/
#define signature_SIZE_2    1

/*!
* Following define start address of start script
*/
#define start_ADDR_2    0
/*!
* Following define size of start script
*/
#define start_SIZE_2    20

/*!
* Following define start address of core script
*/
#define core_ADDR_2 80
/*!
* Following define size of core script
*/
#define core_SIZE_2 152

/*!
* Following define start address of common script
*/
#define common_ADDR_2   232
/*!
* Following define size of common script
*/
#define common_SIZE_2   191

/*!
* Following define start address of ap_2_ap script
*/
#define ap_2_ap_ADDR_2  423
/*!
* Following define size of ap_2_ap script
*/
#define ap_2_ap_SIZE_2  294

/*!
* Following define start address of bp_2_bp script
*/
#define bp_2_bp_ADDR_2  717
/*!
* Following define size of bp_2_bp script
*/
#define bp_2_bp_SIZE_2  112

/*!
* Following define start address of ap_2_bp script
*/
#define ap_2_bp_ADDR_2  829
/*!
* Following define size of ap_2_bp script
*/
#define ap_2_bp_SIZE_2  200

/*!
* Following define start address of bp_2_ap script
*/
#define bp_2_ap_ADDR_2  1029
/*!
* Following define size of bp_2_ap script
*/
#define bp_2_ap_SIZE_2  223

/*!
* Following define start address of app_2_mcu script
*/
#define app_2_mcu_ADDR_2    1252
/*!
* Following define size of app_2_mcu script
*/
#define app_2_mcu_SIZE_2    101

/*!
* Following define start address of mcu_2_app script
*/
#define mcu_2_app_ADDR_2    1353
/*!
* Following define size of mcu_2_app script
*/
#define mcu_2_app_SIZE_2    127

/*!
* Following define start address of uart_2_mcu script
*/
#define uart_2_mcu_ADDR_2   1480
/*!
* Following define size of uart_2_mcu script
*/
#define uart_2_mcu_SIZE_2   105

/*!
* Following define start address of uartsh_2_mcu script
*/
#define uartsh_2_mcu_ADDR_2 1585
/*!
* Following define size of uartsh_2_mcu script
*/
#define uartsh_2_mcu_SIZE_2 98

/*!
* Following define start address of mcu_2_shp script
*/
#define mcu_2_shp_ADDR_2    1683
/*!
* Following define size of mcu_2_shp script
*/
#define mcu_2_shp_SIZE_2    123

/*!
* Following define start address of shp_2_mcu script
*/
#define shp_2_mcu_ADDR_2    1806
/*!
* Following define size of shp_2_mcu script
*/
#define shp_2_mcu_SIZE_2    101

/*!
* Following define start address of error script
*/
#define error_ADDR_2    1907
/*!
* Following define size of error script
*/
#define error_SIZE_2    73

/*!
* Following define start address of test script
*/
#define test_ADDR_2 1980
/*!
* Following define size of test script
*/
#define test_SIZE_2 63

/*!
* SDMA RAM scripts start addresses and sizes
*/

/*!
* Following define start address of app_2_mcu_patched script
*/
#define app_2_mcu_patched_ADDR_2    6144
/*!
* Following define size of app_2_mcu_patched script
*/
#define app_2_mcu_patched_SIZE_2    104

/*!
* Following define start address of ata_2_mcu script
*/
#define ata_2_mcu_ADDR_2    6248
/*!
* Following define size of ata_2_mcu script
*/
#define ata_2_mcu_SIZE_2    110

/*!
* Following define start address of firi_2_mcu script
*/
#define firi_2_mcu_ADDR_2   6358
/*!
* Following define size of firi_2_mcu script
*/
#define firi_2_mcu_SIZE_2   114

/*!
* Following define start address of mcu_2_app_patched script
*/
#define mcu_2_app_patched_ADDR_2    6472
/*!
* Following define size of mcu_2_app_patched script
*/
#define mcu_2_app_patched_SIZE_2    129

/*!
* Following define start address of mcu_2_ata script
*/
#define mcu_2_ata_ADDR_2    6601
/*!
* Following define size of mcu_2_ata script
*/
#define mcu_2_ata_SIZE_2    87
/*!
* Following define start address of mcu_2_firi script
*/
#define mcu_2_firi_ADDR_2   6688
/*!
* Following define size of mcu_2_firi script
*/
#define mcu_2_firi_SIZE_2   77
/*!
* Following define start address of mcu_2_shp_patched script
*/
#define mcu_2_shp_patched_ADDR_2    6765
/*!
* Following define size of mcu_2_shp_patched script
*/
#define mcu_2_shp_patched_SIZE_2    125

/*!
* Following define start address of per_2_shp script
*/
#define per_2_shp_ADDR_2    6890
/*!
* Following define size of per_2_shp script
*/
#define per_2_shp_SIZE_2    131

/*!
* Following define start address of shp_2_mcu_patched script
*/
#define shp_2_mcu_patched_ADDR_2    7021
/*!
* Following define size of shp_2_mcu_patched script
*/
#define shp_2_mcu_patched_SIZE_2    104

/*!
* Following define start address of shp_2_per script
*/
#define shp_2_per_ADDR_2    7125
/*!
* Following define size of shp_2_per script
*/
#define shp_2_per_SIZE_2    106
/*!
* Following define start address of uart_2_mcu_patched script
*/
#define uart_2_mcu_patched_ADDR_2   7231
/*!
* Following define size of uart_2_mcu_patched script
*/
#define uart_2_mcu_patched_SIZE_2   106

/*!
* Following define start address of uartsh_2_mcu_patched script
*/
#define uartsh_2_mcu_patched_ADDR_2 7337
/*!
* Following define size of uartsh_2_mcu_patched script
*/
#define uartsh_2_mcu_patched_SIZE_2 99

/*!
* Following define the start address of sdma ram
*/

#define RAM_CODE_START_ADDR_2       6144
/*!
* Following define the size of sdma ram
*/
#define RAM_CODE_SIZE_2         1292

/*!
 * Code download
 */
static __attribute__((aligned(4))) INITDATA_ATTR
    const short sdma_code_2[RAM_CODE_SIZE_2] =
{
    0x0870, 0x0011, 0x5010, 0xc0ec, 0x7d61, 0x5ac0, 0x5bc8, 0x5ef8,
    0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9806, 0x6ec3, 0x6d07, 0x5df0,
    0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d45, 0x0b70, 0x0311,
    0x522b, 0x5313, 0x02b9, 0x4a00, 0x7c04, 0x6a28, 0x7f3b, 0x0400,
    0x9816, 0x008f, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x0a03, 0x0212,
    0x02bc, 0x0210, 0x4a00, 0x7d1c, 0x4a02, 0x7d20, 0x4a01, 0x7d23,
    0x0b70, 0x0311, 0x53eb, 0x62c8, 0x7e25, 0x0360, 0x7d02, 0x0210,
    0x0212, 0x6a09, 0x7f1f, 0x0212, 0x6a09, 0x7f1c, 0x0212, 0x6a09,
    0x7f19, 0x2003, 0x4800, 0x7cef, 0x0b70, 0x0311, 0x5313, 0x9857,
    0x0015, 0x0015, 0x7802, 0x62c8, 0x6a0b, 0x9856, 0x0015, 0x7802,
    0x62c8, 0x6a0a, 0x9856, 0x7802, 0x62c8, 0x6a09, 0x7c03, 0x6a28,
    0x0000, 0x9814, 0xc77b, 0x6a28, 0x7ffd, 0x0870, 0x0011, 0x5010,
    0x52c0, 0x53c8, 0xc10d, 0x7da2, 0x0200, 0x9806, 0x0200, 0x9803,
    0xc19d, 0xc0ec, 0x7d69, 0x0c70, 0x0411, 0x5414, 0x5ac4, 0x028c,
    0x58da, 0x5efa, 0xc0fe, 0x56fa, 0x7d02, 0x0200, 0x9871, 0x6d07,
    0x5bca, 0x5cd2, 0x0bff, 0x0311, 0x1bff, 0x04bb, 0x0415, 0x53da,
    0x4c00, 0x7d47, 0x0a70, 0x0211, 0x552a, 0x5212, 0x008d, 0x00bb,
    0x4800, 0x7c07, 0x05b9, 0x4d00, 0x7c13, 0x6928, 0x7f2d, 0x0400,
    0x9882, 0x008f, 0x0015, 0x04d8, 0x7d01, 0x008c, 0x04a0, 0x0015,
    0x7802, 0x55c6, 0x6d0b, 0x7e29, 0x6d28, 0x7f1e, 0x0000, 0x9880,
    0x1e20, 0x5506, 0x2620, 0x008d, 0x0560, 0x7c08, 0x065f, 0x55c6,
    0x063f, 0x7e1b, 0x6d0a, 0x7f10, 0x4c00, 0x7d1b, 0x04d8, 0x7d02,
    0x008c, 0x0020, 0x04a0, 0x0015, 0x7802, 0x55c6, 0x6d0b, 0x7e0d,
    0x6d28, 0x7f02, 0x0000, 0x98c9, 0x0007, 0x680c, 0x6d0c, 0x6507,
    0x6d07, 0x6d2b, 0x6d28, 0x0007, 0x680c, 0x0007, 0x54d2, 0x0454,
    0x98cc, 0x6928, 0x7ff1, 0x54d2, 0x008a, 0x52c0, 0x53c8, 0xc10d,
    0x0288, 0x7d9f, 0x0200, 0x9871, 0x0200, 0x9869, 0x1e10, 0x0870,
    0x0011, 0x5010, 0xc0ec, 0x7d39, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe,
    0x56f8, 0x7d02, 0x0200, 0x98dd, 0x6d07, 0x5df0, 0x0dff, 0x0511,
    0x1dff, 0x05bc, 0x4d00, 0x7d17, 0x6ec3, 0x62c8, 0x7e28, 0x0264,
    0x7d08, 0x0b70, 0x0311, 0x522b, 0x02b9, 0x4a00, 0x7c18, 0x0400,
    0x98ec, 0x0212, 0x3aff, 0x008a, 0x05d8, 0x7d01, 0x008d, 0x0a10,
    0x6ed3, 0x6ac8, 0xd927, 0x6a28, 0x7f17, 0x0b70, 0x0311, 0x5013,
    0xd93f, 0x52c0, 0x53c8, 0xc10d, 0x7dd0, 0x0200, 0x98dd, 0x008f,
    0x00d5, 0x7d01, 0x008d, 0xd927, 0x98ea, 0x0200, 0x98da, 0x0007,
    0x68cc, 0x6a28, 0x7f01, 0x9925, 0x0007, 0x6a0c, 0x6a0c, 0x6207,
    0x6a07, 0x6a2b, 0x6a28, 0x0007, 0x680c, 0x0454, 0x9903, 0x05a0,
    0x1e08, 0x6ec3, 0x0388, 0x3b03, 0x0015, 0x0015, 0x7802, 0x62c8,
    0x6a0b, 0x7ee5, 0x6a28, 0x7fe8, 0x0000, 0x6ec1, 0x008b, 0x7802,
    0x62c8, 0x6a09, 0x7edc, 0x6a28, 0x7fdf, 0x2608, 0x0006, 0x55f0,
    0x6207, 0x02a5, 0x0dff, 0x0511, 0x1dff, 0x04b5, 0x049a, 0x0006,
    0x0870, 0x0011, 0x5010, 0xc0ec, 0x7d7a, 0x5ac0, 0x5bc8, 0x5ef8,
    0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x994e, 0x6d03, 0x6ed3, 0x0dff,
    0x0511, 0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d5e, 0x0b70, 0x0311,
    0x522b, 0x5313, 0x02b9, 0x4a00, 0x7c04, 0x62ff, 0x7e3f, 0x0400,
    0x995e, 0x008f, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x5ddb, 0x0d03,
    0x0512, 0x05bc, 0x0510, 0x5dd3, 0x4d00, 0x7d27, 0x4d02, 0x7d20,
    0x4d01, 0x7d1a, 0x0b70, 0x0311, 0x53eb, 0x0360, 0x7d05, 0x6509,
    0x7e25, 0x620a, 0x7e23, 0x9988, 0x620a, 0x7e20, 0x6509, 0x7e1e,
    0x0512, 0x0512, 0x02ad, 0x6ac8, 0x7f19, 0x2003, 0x4800, 0x7ced,
    0x0b70, 0x0311, 0x5313, 0x99a3, 0x7802, 0x6209, 0x6ac8, 0x99a2,
    0x0015, 0x7802, 0x620a, 0x6ac8, 0x99a2, 0x0015, 0x0015, 0x7802,
    0x620b, 0x6ac8, 0x7c03, 0x0000, 0x55db, 0x995c, 0x0007, 0x68cc,
    0x680c, 0x55d3, 0x4d00, 0x7d03, 0x4d02, 0x7d02, 0x99b1, 0x0017,
    0x0017, 0x55db, 0x009d, 0x55fb, 0x05a0, 0x08ff, 0x0011, 0x18ff,
    0x0010, 0x04b8, 0x04ad, 0x0454, 0x62ff, 0x7ee8, 0x0870, 0x0011,
    0x5010, 0x52c0, 0x53c8, 0xc10d, 0x7d89, 0x0200, 0x994e, 0x0200,
    0x994b, 0xc19d, 0xc0ec, 0x7d52, 0x0c70, 0x0411, 0x5414, 0x5ac4,
    0x028c, 0x58da, 0x5efa, 0xc0fe, 0x56fa, 0x7d02, 0x0200, 0x99d2,
    0x6d03, 0x5bca, 0x5cd2, 0x0bff, 0x0311, 0x1bff, 0x04bb, 0x0415,
    0x53da, 0x0a70, 0x0211, 0x4c00, 0x7d28, 0x552a, 0x05bb, 0x4d00,
    0x7c02, 0x0400, 0x99e5, 0x4c01, 0x7d0f, 0x008f, 0x0015, 0x04d8,
    0x7d01, 0x008c, 0x0020, 0x04a0, 0x0015, 0x7802, 0x650b, 0x5d06,
    0x0000, 0x7e0c, 0x7f0d, 0x99e3, 0x650a, 0x7e08, 0x008d, 0x0011,
    0x0010, 0x05a8, 0x065f, 0x5d06, 0x063f, 0x7f02, 0x0007, 0x680c,
    0x0007, 0x5012, 0x54d0, 0x0454, 0x9a0f, 0x5012, 0x54d0, 0x0473,
    0x7c06, 0x552a, 0x05b9, 0x4d00, 0x7c02, 0x0400, 0x9a11, 0x52c0,
    0x53c8, 0xc10d, 0x0288, 0x7db6, 0x0200, 0x99d2, 0x0200, 0x99ca,
    0x0870, 0x0011, 0x5010, 0xc0ec, 0x7d46, 0x5ac0, 0x5bc8, 0x5ef8,
    0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9a26, 0x0b70, 0x0311, 0x6ed3,
    0x6d03, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d2b, 0x522b,
    0x02b9, 0x4a00, 0x7c04, 0x62c8, 0x7e1f, 0x0400, 0x9a37, 0x008f,
    0x00d5, 0x7d01, 0x008d, 0x05a0, 0x0060, 0x7c05, 0x6edd, 0x6209,
    0x7e16, 0x6ac8, 0x7f11, 0x0015, 0x0060, 0x7c05, 0x6ede, 0x620a,
    0x7e0e, 0x6ac8, 0x7f09, 0x6edf, 0x0015, 0x7802, 0x620b, 0x6ac8,
    0x0000, 0x7e05, 0x7f01, 0x9a35, 0x0007, 0x68cc, 0x9a61, 0x0007,
    0x6a0c, 0x0454, 0x62c8, 0x7ef8, 0x5013, 0x52c0, 0x53c8, 0xc10d,
    0x7dbd, 0x0200, 0x9a26, 0x0200, 0x9a23, 0xc19d, 0x0870, 0x0011,
    0xc0ec, 0x7d76, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8,
    0x7d02, 0x0200, 0x9a74, 0x6d03, 0x0d03, 0x0512, 0x05bc, 0x0510,
    0x5dd0, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d57,
    0x0a70, 0x0211, 0x532a, 0x5212, 0x03b9, 0x4b00, 0x7c02, 0x0400,
    0x9a88, 0x008f, 0x05d8, 0x7d01, 0x008d, 0x05a0, 0x5dda, 0x55d2,
    0x4d00, 0x7d27, 0x4d02, 0x7d20, 0x4d01, 0x7d1a, 0x0a70, 0x0211,
    0x52ea, 0x0260, 0x7d05, 0x6509, 0x7e25, 0x630a, 0x7e23, 0x9aac,
    0x630a, 0x7e20, 0x6509, 0x7e1e, 0x0512, 0x0512, 0x03ad, 0x5b06,
    0x7f19, 0x2003, 0x4800, 0x7ced, 0x0a70, 0x0211, 0x5212, 0x9ac7,
    0x7802, 0x6309, 0x5b06, 0x9ac6, 0x0015, 0x7802, 0x630a, 0x5b06,
    0x9ac6, 0x0015, 0x0015, 0x7802, 0x630b, 0x5b06, 0x7c03, 0x55da,
    0x0000, 0x9a86, 0x0007, 0x680c, 0x55d2, 0x4d00, 0x7d03, 0x4d02,
    0x7d02, 0x9ad4, 0x0017, 0x0017, 0x55da, 0x009d, 0x55fa, 0x05a0,
    0x08ff, 0x0011, 0x18ff, 0x0010, 0x04b8, 0x04ad, 0x0454, 0x0870,
    0x0011, 0x5010, 0x52c0, 0x53c8, 0xc10d, 0x7d8e, 0x0200, 0x9a74,
    0x0200, 0x9a70, 0xc19d, 0x0870, 0x0011, 0xc0ec, 0x7d7c, 0x5010,
    0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9af1,
    0x6dc5, 0x0d03, 0x0512, 0x05bc, 0x0510, 0x5dd0, 0x0dff, 0x0511,
    0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d5d, 0x0a70, 0x0211, 0x532a,
    0x5212, 0x03b9, 0x4b00, 0x7c02, 0x0400, 0x9b05, 0x008f, 0x05d8,
    0x7d01, 0x008d, 0x05a0, 0x5dda, 0x55d2, 0x4d00, 0x7d2c, 0x4d02,
    0x7d24, 0x4d01, 0x7d1e, 0x59e2, 0x0a70, 0x0211, 0x52ea, 0x61c8,
    0x7e2c, 0x63c8, 0x7e2a, 0x65c8, 0x7e28, 0x0260, 0x7d03, 0x0112,
    0x0112, 0x9b2c, 0x0512, 0x0512, 0x0311, 0x03a9, 0x03ad, 0x5b06,
    0x7f1c, 0x2003, 0x4800, 0x7ceb, 0x0a70, 0x0211, 0x5212, 0x51e2,
    0x9b4a, 0x7802, 0x63c8, 0x5b06, 0x9b49, 0x6dce, 0x0015, 0x7802,
    0x63c8, 0x5b06, 0x9b49, 0x6dcf, 0x0015, 0x0015, 0x7802, 0x63c8,
    0x5b06, 0x7c03, 0x55da, 0x0000, 0x9b03, 0x0007, 0x68ff, 0x55d2,
    0x4d00, 0x7d03, 0x4d02, 0x7d02, 0x9b57, 0x0017, 0x0017, 0x55da,
    0x009d, 0x55fa, 0x05a0, 0x08ff, 0x0011, 0x18ff, 0x0010, 0x04b8,
    0x04ad, 0x0454, 0x0870, 0x0011, 0x5010, 0x52c0, 0x53c8, 0xc10d,
    0x7d88, 0x0200, 0x9af1, 0x0200, 0x9aed, 0xc19d, 0x0870, 0x0011,
    0xc0ec, 0x7d61, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8,
    0x7d02, 0x0200, 0x9b74, 0x6d07, 0x5df0, 0x0dff, 0x0511, 0x1dff,
    0x05bc, 0x4d00, 0x7d45, 0x0a70, 0x0211, 0x532a, 0x5212, 0x03b9,
    0x4b00, 0x7c04, 0x6a28, 0x7f3b, 0x0400, 0x9b83, 0x008f, 0x05d8,
    0x7d01, 0x008d, 0x05a0, 0x0b03, 0x0312, 0x03bc, 0x0310, 0x4b00,
    0x7d1c, 0x4b02, 0x7d20, 0x4b01, 0x7d23, 0x0a70, 0x0211, 0x52ea,
    0x5306, 0x7e25, 0x0260, 0x7d02, 0x0310, 0x0312, 0x6b09, 0x7f1f,
    0x0312, 0x6b09, 0x7f1c, 0x0312, 0x6b09, 0x7f19, 0x2003, 0x4800,
    0x7cef, 0x0a70, 0x0211, 0x5212, 0x9bc4, 0x0015, 0x0015, 0x7802,
    0x5306, 0x6b0b, 0x9bc3, 0x0015, 0x7802, 0x5306, 0x6b0a, 0x9bc3,
    0x7802, 0x5306, 0x6b09, 0x7c03, 0x6b28, 0x0000, 0x9b81, 0xc77b,
    0x6928, 0x7ffd, 0x0870, 0x0011, 0x5010, 0x52c0, 0x53c8, 0xc10d,
    0x7da3, 0x0200, 0x9b74, 0x0200, 0x9b70, 0xc19d, 0x0870, 0x0011,
    0xc0ec, 0x7d63, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8,
    0x7d02, 0x0200, 0x9bdc, 0x6dd7, 0x5df0, 0x0dff, 0x0511, 0x1dff,
    0x05bc, 0x4d00, 0x7d47, 0x0a70, 0x0211, 0x532a, 0x5212, 0x03b9,
    0x4b00, 0x7c04, 0x63c8, 0x7e3d, 0x0400, 0x9beb, 0x008f, 0x05d8,
    0x7d01, 0x008d, 0x05a0, 0x0b03, 0x0312, 0x03bc, 0x0310, 0x4b00,
    0x7d28, 0x4b02, 0x7d20, 0x4b01, 0x7d19, 0x6ddd, 0x0a70, 0x0211,
    0x52ea, 0x5306, 0x7e26, 0x0260, 0x7d02, 0x0310, 0x0312, 0x6bc8,
    0x7f20, 0x0312, 0x6bc8, 0x7f1d, 0x0312, 0x6bc8, 0x7f1a, 0x2003,
    0x4800, 0x7cef, 0x0a70, 0x0211, 0x5212, 0x9c2f, 0x6ddd, 0x7802,
    0x5306, 0x6bc8, 0x9c2e, 0x6dde, 0x0015, 0x7802, 0x5306, 0x6bc8,
    0x9c2e, 0x0015, 0x0015, 0x7802, 0x5306, 0x6bc8, 0x7c02, 0x0000,
    0x9be9, 0xc777, 0x63c8, 0x7efd, 0x0870, 0x0011, 0x5010, 0x52c0,
    0x53c8, 0xc10d, 0x7da1, 0x0200, 0x9bdc, 0x0200, 0x9bd8, 0x0870,
    0x0011, 0x5010, 0xc0ec, 0x7d5c, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe,
    0x56f8, 0x7d02, 0x0200, 0x9c45, 0x0b70, 0x0311, 0x6ec3, 0x6d07,
    0x5df0, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d3e, 0x522b,
    0x02b9, 0x4a00, 0x7c04, 0x6a28, 0x7f34, 0x0400, 0x9c57, 0x028e,
    0x1a94, 0x6ac3, 0x62c8, 0x0269, 0x7d1b, 0x1e94, 0x6ec3, 0x6ed3,
    0x62c8, 0x0248, 0x6ac8, 0x2694, 0x6ec3, 0x62c8, 0x026e, 0x7d32,
    0x6a09, 0x7f1f, 0x2501, 0x4d00, 0x7d20, 0x028e, 0x1a98, 0x6ac3,
    0x62c8, 0x6ec3, 0x0260, 0x7df1, 0x6a28, 0x7f13, 0xc7af, 0x9c97,
    0x6ee3, 0x008f, 0x2001, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x62c8,
    0x026e, 0x7d18, 0x6a09, 0x7f05, 0x2001, 0x7cf9, 0x6a28, 0x0000,
    0x9c55, 0x0289, 0xc77b, 0x018a, 0x9ca6, 0x6a28, 0x7ffa, 0x0b70,
    0x0311, 0x5013, 0x52c0, 0x53c8, 0xc10d, 0x7da7, 0x0200, 0x9c45,
    0x0200, 0x9c42, 0x6a28, 0x7fed, 0xc7af, 0x9ca6, 0x0458, 0x0454,
    0x9c97, 0xc19d, 0x0870, 0x0011, 0xc0ec, 0x7d55, 0x5010, 0x5ac0,
    0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9cb0, 0x0b70,
    0x0311, 0x6d07, 0x5df0, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00,
    0x7d37, 0x522b, 0x02b9, 0x4a00, 0x7c04, 0x6928, 0x7f2d, 0x0400,
    0x9cc1, 0x028e, 0x1a94, 0x5202, 0x0269, 0x7d16, 0x1e94, 0x5206,
    0x0248, 0x5a06, 0x2694, 0x5206, 0x026e, 0x7d2f, 0x6a09, 0x7f1c,
    0x2501, 0x4d00, 0x7d1d, 0x028e, 0x1a98, 0x5202, 0x0260, 0x7df3,
    0x6a28, 0x7f12, 0xc7af, 0x9cfa, 0x008f, 0x2001, 0x00d5, 0x7d01,
    0x008d, 0x05a0, 0x5206, 0x026e, 0x7d18, 0x6a09, 0x7f05, 0x2001,
    0x7cf9, 0x6a28, 0x0000, 0x9cbf, 0x0289, 0xc77b, 0x018a, 0x9d09,
    0x6928, 0x7ffa, 0x0b70, 0x0311, 0x5013, 0x52c0, 0x53c8, 0xc10d,
    0x7daf, 0x0200, 0x9cb0, 0x0200, 0x9cac, 0x6a28, 0x7fed, 0xc7af,
    0x9d09, 0x0458, 0x0454, 0x9cfa
};


/*!
 * SDMA script code info
 */

/* script addresses in SDMA halfword space */
#define AP_2_AP_ADDR                ap_2_ap_ADDR_2
#define AP_2_BP_ADDR                ap_2_bp_ADDR_2
#define APP_2_MCU_ADDR              app_2_mcu_patched_ADDR_2
#define APP_2_PER_ADDR              (-1)
#define ATA_2_MCU_ADDR              ata_2_mcu_ADDR_2
#define BP_2_AP_ADDR                bp_2_ap_ADDR_2
#define DPTC_DVFS_ADDR              (-1)
#define FIRI_2_MCU_ADDR             firi_2_mcu_ADDR_2
#define FIRI_2_PER_ADDR             (-1)
#define LOOPBACK_ON_DSP_SIDE_ADDR   (-1)
#define MCU_2_APP_ADDR              mcu_2_app_patched_ADDR_2
#define MCU_2_ATA_ADDR              mcu_2_ata_ADDR_2
#define MCU_2_FIRI_ADDR             mcu_2_firi_ADDR_2
#define MCU_2_MSHC_ADDR             (-1)
#define MCU_2_SHP_ADDR              mcu_2_shp_patched_ADDR_2
#define MCU_INTERRUPT_ONLY_ADDR     (-1)
#define MSHC_2_MCU_ADDR             (-1)
#define PER_2_APP_ADDR              (-1)
#define PER_2_FIRI_ADDR             (-1)
#define PER_2_SHP_ADDR              per_2_shp_ADDR_2
#define SHP_2_MCU_ADDR              shp_2_mcu_patched_ADDR_2
#define SHP_2_PER_ADDR              shp_2_per_ADDR_2
#define UART_2_MCU_ADDR             uart_2_mcu_patched_ADDR_2
#define UART_2_PER_ADDR             (-1)
#define UARTSH_2_MCU_ADDR           uartsh_2_mcu_patched_ADDR_2
#define UARTSH_2_PER_ADDR           (-1)

/* address where ram code starts (in SDMA halfword space) */
#define RAM_CODE_START_ADDR         RAM_CODE_START_ADDR_2
/* size of the ram code (in halfwords) */
#define RAM_CODE_SIZE               RAM_CODE_SIZE_2
/* RAM image address on AP */
#define MCU_START_ADDR              ((unsigned long)sdma_code_2)

#endif /*__SDMA_SCRIPT_CODE_H__ */
