#include "wmaprodec.h"
#include <inttypes.h>
  
/* Tables for fixed-point trig tables for windowing and mdct */

/* Windowing trig tables in s.31 format */
const int32_t sine_4096[] = {
    0xFFF9B782, 0xFFED2685, 0xFFE09587, 0xFFD4048A, 0xFFC7738D, 0xFFBAE291, 
    0xFFAE5196, 0xFFA1C09B, 0xFF952FA1, 0xFF889EA8, 0xFF7C0DB1, 0xFF6F7CBB, 
    0xFF62EBC5, 0xFF565AD3, 0xFF49C9E1, 0xFF3D38F0, 0xFF30A803, 0xFF241716, 
    0xFF17862C, 0xFF0AF545, 0xFEFE645F, 0xFEF1D37C, 0xFEE5429B, 0xFED8B1BD, 
    0xFECC20E4, 0xFEBF900C, 0xFEB2FF37, 0xFEA66E65, 0xFE99DD96, 0xFE8D4CCB, 
    0xFE80BC06, 0xFE742B42, 0xFE679A82, 0xFE5B09C6, 0xFE4E790E, 0xFE41E85A, 
    0xFE3557AD, 0xFE28C702, 0xFE1C365B, 0xFE0FA5B9, 0xFE03151C, 0xFDF68484, 
    0xFDE9F3F3, 0xFDDD6363, 0xFDD0D2DC, 0xFDC4425A, 0xFDB7B1DB, 0xFDAB2164, 
    0xFD9E90F0, 0xFD920085, 0xFD85701D, 0xFD78DFBE, 0xFD6C4F66, 0xFD5FBF10, 
    0xFD532EC5, 0xFD469E7C, 0xFD3A0E3E, 0xFD2D7E07, 0xFD20EDD2, 0xFD145DA9, 
    0xFD07CD83, 0xFCFB3D68, 0xFCEEAD51, 0xFCE21D46, 0xFCD58D42, 0xFCC8FD41, 
    0xFCBC6D4D, 0xFCAFDD5D, 0xFCA34D79, 0xFC96BD9D, 0xFC8A2DC6, 0xFC7D9DFB, 
    0xFC710E35, 0xFC647E7C, 0xFC57EEC8, 0xFC4B5F20, 0xFC3ECF82, 0xFC323FE9, 
    0xFC25B05D, 0xFC1920D7, 0xFC0C915F, 0xFC0001F0, 0xFBF37287, 0xFBE6E329, 
    0xFBDA53DC, 0xFBCDC491, 0xFBC13551, 0xFBB4A624, 0xFBA816F8, 0xFB9B87D8, 
    0xFB8EF8C3, 0xFB8269C0, 0xFB75DAC1, 0xFB694BCC, 0xFB5CBCEB, 0xFB502E0E, 
    0xFB439F3C, 0xFB371076, 0xFB2A81C3, 0xFB1DF315, 0xFB116472, 0xFB04D5E4, 
    0xFAF8475A, 0xFAEBB8DC, 0xFADF2A73, 0xFAD29C0F, 0xFAC60DB7, 0xFAB97F6C, 
    0xFAACF137, 0xFAA06306, 0xFA93D4E3, 0xFA8746D5, 0xFA7AB8CC, 0xFA6E2AD1, 
    0xFA619CE4, 0xFA550F0D, 0xFA48813C, 0xFA3BF379, 0xFA2F65CC, 0xFA22D825, 
    0xFA164A8D, 0xFA09BD04, 0xF9FD2F91, 0xF9F0A225, 0xF9E414C8, 0xF9D78782, 
    0xF9CAFA43, 0xF9BE6D14, 0xF9B1DFFC, 0xF9A552EB, 0xF998C5EB, 0xF98C38FA, 
    0xF97FAC21, 0xF9731F50, 0xF966928F, 0xF95A05E6, 0xF94D7946, 0xF940ECB6, 
    0xF9346037, 0xF927D3D1, 0xF91B4774, 0xF90EBB28, 0xF9022EF4, 0xF8F5A2CA, 
    0xF8E916B2, 0xF8DC8AAB, 0xF8CFFEBD, 0xF8C372DA, 0xF8B6E708, 0xF8AA5B50, 
    0xF89DCFA2, 0xF8914407, 0xF884B885, 0xF8782D0F, 0xF86BA1AA, 0xF85F1659, 
    0xF8528B22, 0xF845FFF6, 0xF83974DE, 0xF82CE9E0, 0xF8205EEE, 0xF813D40F, 
    0xF8074944, 0xF7FABE95, 0xF7EE33F1, 0xF7E1A961, 0xF7D51EE5, 0xF7C8947E, 
    0xF7BC0A3A, 0xF7AF7FFB, 0xF7A2F5D1, 0xF7966BBB, 0xF789E1BA, 0xF77D57CE, 
    0xF770CDF7, 0xF7644445, 0xF757BA98, 0xF74B3100, 0xF73EA77E, 0xF7321E12, 
    0xF72594BB, 0xF7190B7B, 0xF70C8260, 0xF6FFF94B, 0xF6F3704C, 0xF6E6E764, 
    0xF6DA5E92, 0xF6CDD5D7, 0xF6C14D43, 0xF6B4C4B5, 0xF6A83C3E, 0xF69BB3DE, 
    0xF68F2B96, 0xF682A365, 0xF6761B4B, 0xF6699358, 0xF65D0B6E, 0xF650839B, 
    0xF643FBE0, 0xF637743D, 0xF62AECB2, 0xF61E6540, 0xF611DDF5, 0xF60556B4, 
    0xF5F8CF8B, 0xF5EC487A, 0xF5DFC183, 0xF5D33AA4, 0xF5C6B3DF, 0xF5BA2D43, 
    0xF5ADA6B0, 0xF5A12037, 0xF59499D7, 0xF5881391, 0xF57B8D65, 0xF56F0753, 
    0xF562816B, 0xF555FB8D, 0xF54975C9, 0xF53CF020, 0xF5306A91, 0xF523E51D, 
    0xF5175FC4, 0xF50ADA96, 0xF4FE5572, 0xF4F1D06A, 0xF4E54B7D, 0xF4D8C6AC, 
    0xF4CC41F6, 0xF4BFBD5C, 0xF4B338ED, 0xF4A6B48B, 0xF49A3044, 0xF48DAC1A, 
    0xF481280B, 0xF474A41A, 0xF4682054, 0xF45B9C9B, 0xF44F18FF, 0xF4429580, 
    0xF436121E, 0xF4298ED9, 0xF41D0BB1, 0xF41088B6, 0xF40405C9, 0xF3F782F9, 
    0xF3EB0047, 0xF3DE7DB3, 0xF3D1FB3D, 0xF3C578E5, 0xF3B8F6BB, 0xF3AC749F, 
    0xF39FF2A2, 0xF39370C3, 0xF386EF03, 0xF37A6D62, 0xF36DEBE0, 0xF3616A8C, 
    0xF354E948, 0xF3486823, 0xF33BE71E, 0xF32F6638, 0xF322E571, 0xF31664CA, 
    0xF309E453, 0xF2FD63ED, 0xF2F0E3A6, 0xF2E4637F, 0xF2D7E379, 0xF2CB6393, 
    0xF2BEE3CE, 0xF2B2643A, 0xF2A5E4B6, 0xF2996553, 0xF28CE612, 0xF28066F1, 
    0xF273E7F2, 0xF2676924, 0xF25AEA68, 0xF24E6BCE, 0xF241ED55, 0xF2356EFE, 
    0xF228F0C9, 0xF21C72B7, 0xF20FF4D6, 0xF2037708, 0xF1F6F95D, 0xF1EA7BD4, 
    0xF1DDFE6E, 0xF1D1812B, 0xF1C5040B, 0xF1B8871D, 0xF1AC0A43, 0xF19F8D8D, 
    0xF19310FA, 0xF186948A, 0xF17A183F, 0xF16D9C17, 0xF1612023, 0xF154A443, 
    0xF1482887, 0xF13BACF0, 0xF12F317D, 0xF122B62F, 0xF1163B05, 0xF109C010, 
    0xF0FD4530, 0xF0F0CA75, 0xF0E44FDF, 0xF0D7D56F, 0xF0CB5B24, 0xF0BEE0FE, 
    0xF0B2670E, 0xF0A5ED34, 0xF0997380, 0xF08CF9F1, 0xF0808089, 0xF0740747, 
    0xF0678E2C, 0xF05B1546, 0xF04E9C78, 0xF04223D0, 0xF035AB4F, 0xF02932F5, 
    0xF01CBAC2, 0xF01042C6, 0xF003CAE2, 0xEFF75325, 0xEFEADB90, 0xEFDE6422, 
    0xEFD1ECDC, 0xEFC575BE, 0xEFB8FEC8, 0xEFAC87FB, 0xEFA01155, 0xEF939AD8, 
    0xEF8724A3, 0xEF7AAE77, 0xEF6E3874, 0xEF61C29A, 0xEF554CE9, 0xEF48D761, 
    0xEF3C6202, 0xEF2FECCC, 0xEF2377C0, 0xEF1702DE, 0xEF0A8E25, 0xEEFE1996, 
    0xEEF1A531, 0xEEE53116, 0xEED8BD06, 0xEECC491F, 0xEEBFD563, 0xEEB361D2, 
    0xEEA6EE6C, 0xEE9A7B30, 0xEE8E081F, 0xEE819539, 0xEE75227E, 0xEE68AFEF, 
    0xEE5C3D8B, 0xEE4FCB53, 0xEE435946, 0xEE36E784, 0xEE2A75CF, 0xEE1E0446, 
    0xEE1192E9, 0xEE0521B8, 0xEDF8B0B4, 0xEDEC3FDC, 0xEDDFCF31, 0xEDD35EB2, 
    0xEDC6EE60, 0xEDBA7E3C, 0xEDAE0E44, 0xEDA19E79, 0xED952EDC, 0xED88BF8C, 
    0xED7C504A, 0xED6FE135, 0xED63724F, 0xED570396, 0xED4A950B, 0xED3E26AF, 
    0xED31B880, 0xED254A80, 0xED18DCAF, 0xED0C6F0C, 0xED000198, 0xECF39453, 
    0xECE7273D, 0xECDABA76, 0xECCE4DBE, 0xECC1E136, 0xECB574DD, 0xECA908B4, 
    0xEC9C9CBA, 0xEC9030F0, 0xEC83C557, 0xEC7759ED, 0xEC6AEEB3, 0xEC5E83AA, 
    0xEC5218D1, 0xEC45AE29, 0xEC3943D1, 0xEC2CD98B, 0xEC206F75, 0xEC140590, 
    0xEC079BDD, 0xEBFB325A, 0xEBEEC909, 0xEBE25FEA, 0xEBD5F6FC, 0xEBC98E40, 
    0xEBBD25B6, 0xEBB0BD5E, 0xEBA45538, 0xEB97ED44, 0xEB8B85A2, 0xEB7F1E13, 
    0xEB72B6B7, 0xEB664F8D, 0xEB59E896, 0xEB4D81D2, 0xEB411B41, 0xEB34B4E4, 
    0xEB284EB9, 0xEB1BE8C2, 0xEB0F82FF, 0xEB031D6F, 0xEAF6B813, 0xEAEA52EB, 
    0xEADDEE17, 0xEAD18957, 0xEAC524CB, 0xEAB8C074, 0xEAAC5C51, 0xEA9FF863, 
    0xEA9394AA, 0xEA873126, 0xEA7ACDD6, 0xEA6E6ABC, 0xEA6207D6, 0xEA55A527, 
    0xEA4942AC, 0xEA3CE087, 0xEA307E78, 0xEA241C9E, 0xEA17BAFB, 0xEA0B598E, 
    0xE9FEF857, 0xE9F29756, 0xE9E6368B, 0xE9D9D5F7, 0xE9CD759A, 0xE9C11574, 
    0xE9B4B584, 0xE9A855CC, 0xE99BF64A, 0xE98F971F, 0xE983380D, 0xE976D931, 
    0xE96A7A8D, 0xE95E1C21, 0xE951BDED, 0xE9455FF1, 0xE939022D, 0xE92CA4A1, 
    0xE920474D, 0xE913EA32, 0xE9078D50, 0xE8FB30A6, 0xE8EED434, 0xE8E2781C, 
    0xE8D61C1C, 0xE8C9C056, 0xE8BD64CA, 0xE8B10976, 0xE8A4AE5C, 0xE898537C, 
    0xE88BF8D6, 0xE87F9E69, 0xE8734436, 0xE866EA3E, 0xE85A9080, 0xE84E36FC, 
    0xE841DDD2, 0xE83584C3, 0xE8292BEF, 0xE81CD355, 0xE8107AF7, 0xE80422D3, 
    0xE7F7CAEB, 0xE7EB733E, 0xE7DF1BCD, 0xE7D2C497, 0xE7C66D9C, 0xE7BA16DE, 
    0xE7ADC05B, 0xE7A16A15, 0xE795142A, 0xE788BE5B, 0xE77C68C9, 0xE7701374, 
    0xE763BE5B, 0xE757697F, 0xE74B14E0, 0xE73EC07E, 0xE7326C58, 0xE7261871, 
    0xE719C4C6, 0xE70D7159, 0xE7011E29, 0xE6F4CB37, 0xE6E878A2, 0xE6DC262C, 
    0xE6CFD3F4, 0xE6C381F9, 0xE6B7303E, 0xE6AADEC0, 0xE69E8D81, 0xE6923C81, 
    0xE685EBBF, 0xE6799B3D, 0xE66D4AF9, 0xE660FAF4, 0xE654AB2F, 0xE6485BA9, 
    0xE63C0C81, 0xE62FBD7A, 0xE6236EB3, 0xE617202B, 0xE60AD1E4, 0xE5FE83DC, 
    0xE5F23615, 0xE5E5E88E, 0xE5D99B47, 0xE5CD4E41, 0xE5C1017B, 0xE5B4B4F6, 
    0xE5A868B2, 0xE59C1CCF, 0xE58FD10D, 0xE583858C, 0xE5773A4D, 0xE56AEF4F, 
    0xE55EA493, 0xE5525A19, 0xE5460FE0, 0xE539C5EA, 0xE52D7C35, 0xE52132C2, 
    0xE514E992, 0xE508A0A5, 0xE4FC57F9, 0xE4F00FB0, 0xE4E3C78A, 0xE4D77FA8, 
    0xE4CB3808, 0xE4BEF0AB, 0xE4B2A992, 0xE4A662BB, 0xE49A1C29, 0xE48DD5DA, 
    0xE4818FCE, 0xE4754A07, 0xE4690483, 0xE45CBF44, 0xE4507A49, 0xE44435B1, 
    0xE437F13F, 0xE42BAD11, 0xE41F6927, 0xE4132583, 0xE406E223, 0xE3FA9F09, 
    0xE3EE5C33, 0xE3E219A3, 0xE3D5D758, 0xE3C99553, 0xE3BD5393, 0xE3B11219, 
    0xE3A4D104, 0xE3989016, 0xE38C4F6E, 0xE3800F0C, 0xE373CEF1, 0xE3678F1C, 
    0xE35B4F8D, 0xE34F1045, 0xE342D144, 0xE336928A, 0xE32A5417, 0xE31E15EB, 
    0xE311D806, 0xE3059A69, 0xE2F95D32, 0xE2ED2024, 0xE2E0E35D, 0xE2D4A6DF, 
    0xE2C86AA8, 0xE2BC2EB9, 0xE2AFF313, 0xE2A3B7B5, 0xE2977C9F, 0xE28B41D2, 
    0xE27F074E, 0xE272CD13, 0xE2669320, 0xE25A5976, 0xE24E2035, 0xE241E71E, 
    0xE235AE50, 0xE22975CC, 0xE21D3D91, 0xE21105A0, 0xE204CDF9, 0xE1F8969C, 
    0xE1EC5F89, 0xE1E028C0, 0xE1D3F242, 0xE1C7BC0E, 0xE1BB8624, 0xE1AF50A5, 
    0xE1A31B51, 0xE196E648, 0xE18AB18A, 0xE17E7D17, 0xE17248EF, 0xE1661513, 
    0xE159E182, 0xE14DAE3D, 0xE1417B44, 0xE1354896, 0xE1291635, 0xE11CE41F, 
    0xE110B256, 0xE10480F8, 0xE0F84FC8, 0xE0EC1EE4, 0xE0DFEE4D, 0xE0D3BE03, 
    0xE0C78E05, 0xE0BB5E55, 0xE0AF2EF1, 0xE0A2FFDB, 0xE096D113, 0xE08AA298, 
    0xE07E746A, 0xE072468A, 0xE06618F9, 0xE059EBD4, 0xE04DBEDE, 0xE0419236, 
    0xE03565DD, 0xE02939D2, 0xE01D0E16, 0xE010E2A8, 0xE004B789, 0xDFF88CB9, 
    0xDFEC6238, 0xDFE03807, 0xDFD40E24, 0xDFC7E491, 0xDFBBBB4D, 0xDFAF9259, 
    0xDFA369B5, 0xDF974161, 0xDF8B195C, 0xDF7EF1A8, 0xDF72CA44, 0xDF66A36E, 
    0xDF5A7CAB, 0xDF4E5638, 0xDF423015, 0xDF360A44, 0xDF29E4C4, 0xDF1DBF94, 
    0xDF119AB6, 0xDF057629, 0xDEF951ED, 0xDEED2E03, 0xDEE10A6A, 0xDED4E723, 
    0xDEC8C42E, 0xDEBCA18B, 0xDEB07F3A, 0xDEA45D3B, 0xDE983B8F, 0xDE8C1A35, 
    0xDE7FF92D, 0xDE73D878, 0xDE67B816, 0xDE5B9807, 0xDE4F784B, 0xDE4358E2, 
    0xDE3739CC, 0xDE2B1B09, 0xDE1EFC9A, 0xDE12DEBD, 0xDE06C0F5, 0xDDFAA381, 
    0xDDEE8661, 0xDDE26995, 0xDDD64D1D, 0xDDCA30FA, 0xDDBE152B, 0xDDB1F9B1, 
    0xDDA5DE8B, 0xDD99C3BA, 0xDD8DA93D, 0xDD818F16, 0xDD757544, 0xDD695BC7, 
    0xDD5D42A0, 0xDD5129CE, 0xDD451151, 0xDD38F92B, 0xDD2CE15A, 0xDD20C9DF, 
    0xDD14B2BA, 0xDD089BEB, 0xDCFC8572, 0xDCF06F50, 0xDCE45984, 0xDCD8440F, 
    0xDCCC2F2E, 0xDCC01A67, 0xDCB405F7, 0xDCA7F1DD, 0xDC9BDE1B, 0xDC8FCAB0, 
    0xDC83B79D, 0xDC77A4E1, 0xDC6B927D, 0xDC5F8070, 0xDC536EBC, 0xDC475D5F, 
    0xDC3B4C5B, 0xDC2F3BAF, 0xDC232B5B, 0xDC171B60, 0xDC0B0BBE, 0xDBFEFC74, 
    0xDBF2ED83, 0xDBE6DEEB, 0xDBDAD0AC, 0xDBCEC2C6, 0xDBC2B539, 0xDBB6A806, 
    0xDBAA9B2D, 0xDB9E8EAD, 0xDB928287, 0xDB8676BA, 0xDB7A6B85, 0xDB6E606D, 
    0xDB6255AF, 0xDB564B4C, 0xDB4A4143, 0xDB3E3794, 0xDB322E40, 0xDB262547, 
    0xDB1A1CA9, 0xDB0E1466, 0xDB020C7E, 0xDAF604F1, 0xDAE9FDC0, 0xDADDF6EA, 
    0xDAD1F070, 0xDAC5EA52, 0xDAB9E48F, 0xDAADDF29, 0xDAA1DA1E, 0xDA95D570, 
    0xDA89D11E, 0xDA7DCD29, 0xDA71C990, 0xDA65C653, 0xDA59C374, 0xDA4DC0F1, 
    0xDA41BECB, 0xDA35BD40, 0xDA29BBD5, 0xDA1DBAC7, 0xDA11BA17, 0xDA05B9C4, 
    0xD9F9B9CF, 0xD9EDBA37, 0xD9E1BAFE, 0xD9D5BC23, 0xD9C9BDA6, 0xD9BDBF87, 
    0xD9B1C1C6, 0xD9A5C464, 0xD999C761, 0xD98DCABC, 0xD981CE77, 0xD975D290, 
    0xD969D708, 0xD95DDBE0, 0xD951E117, 0xD945E6AD, 0xD939ECA3, 0xD92DF2F9, 
    0xD921F9AE, 0xD91600C3, 0xD90A0839, 0xD8FE100E, 0xD8F21881, 0xD8E62117, 
    0xD8DA2A0D, 0xD8CE3364, 0xD8C23D1C, 0xD8B64735, 0xD8AA51AE, 0xD89E5C89, 
    0xD89267C5, 0xD8867362, 0xD87A7F60, 0xD86E8BC0, 0xD8629882, 0xD856A5A5, 
    0xD84AB32A, 0xD83EC112, 0xD832CF5B, 0xD826DE06, 0xD81AED14, 0xD80EFC84, 
    0xD8030C57, 0xD7F71C8D, 0xD7EB2D25, 0xD7DF3E20, 0xD7D34F7E, 0xD7C76140, 
    0xD7BB7364, 0xD7AF85EC, 0xD7A39914, 0xD797AC63, 0xD78BC016, 0xD77FD42C, 
    0xD773E8A7, 0xD767FD85, 0xD75C12C8, 0xD750286F, 0xD7443E7A, 0xD73854EA, 
    0xD72C6BBE, 0xD72082F7, 0xD7149A95, 0xD708B298, 0xD6FCCB00, 0xD6F0E3CE, 
    0xD6E4FD00, 0xD6D91698, 0xD6CD3096, 0xD6C14AF9, 0xD6B565C2, 0xD6A980F0, 
    0xD69D9C85, 0xD691B880, 0xD685D4E1, 0xD679F1A9, 0xD66E0ED7, 0xD6622CA8, 
    0xD6564AA3, 0xD64A6905, 0xD63E87CE, 0xD632A6FE, 0xD626C695, 0xD61AE693, 
    0xD60F06F9, 0xD60327C6, 0xD5F748FB, 0xD5EB6A98, 0xD5DF8C9C, 0xD5D3AF08, 
    0xD5C7D1DD, 0xD5BBF519, 0xD5B018BE, 0xD5A43CCB, 0xD5986141, 0xD58C861F, 
    0xD580AB66, 0xD574D116, 0xD568F72F, 0xD55D1DB1, 0xD551449C, 0xD5456BF1, 
    0xD53993AF, 0xD52DBBD6, 0xD521E468, 0xD5160D9F, 0xD50A3704, 0xD4FE60D2, 
    0xD4F28B0B, 0xD4E6B5AF, 0xD4DAE0BC, 0xD4CF0C34, 0xD4C33817, 0xD4B76464, 
    0xD4AB911C, 0xD49FBE3F, 0xD493EBCD, 0xD48819C6, 0xD47C482A, 0xD47076FA, 
    0xD464A635, 0xD458D5DC, 0xD44D05EE, 0xD441366D, 0xD4356757, 0xD42998AD, 
    0xD41DCA70, 0xD411FC9E, 0xD4062F3A, 0xD3FA6241, 0xD3EE95B6, 0xD3E2C997, 
    0xD3D6FE21, 0xD3CB32DB, 0xD3BF6803, 0xD3B39D98, 0xD3A7D39B, 0xD39C0A0B, 
    0xD39040E8, 0xD3847833, 0xD378AFEC, 0xD36CE812, 0xD36120A7, 0xD35559A9, 
    0xD349931A, 0xD33DCCFA, 0xD3320747, 0xD3264203, 0xD31A7D2E, 0xD30EB8C8, 
    0xD302F4D0, 0xD2F73148, 0xD2EB6E2F, 0xD2DFAB85, 0xD2D3E94A, 0xD2C8277F, 
    0xD2BC6623, 0xD2B0A537, 0xD2A4E4BB, 0xD29924EA, 0xD28D654E, 0xD281A622, 
    0xD275E766, 0xD26A291A, 0xD25E6B3F, 0xD252ADD4, 0xD246F0DB, 0xD23B3452, 
    0xD22F783A, 0xD223BC93, 0xD218015D, 0xD20C4698, 0xD2008C45, 0xD1F4D263, 
    0xD1E918F3, 0xD1DD5FF5, 0xD1D1A768, 0xD1C5EF4E, 0xD1BA37A5, 0xD1AE806F, 
    0xD1A2C9AB, 0xD1971359, 0xD18B5D7A, 0xD17FA80E, 0xD173F314, 0xD1683E8D, 
    0xD15C8A79, 0xD150D714, 0xD14523E6, 0xD139712C, 0xD12DBEE5, 0xD1220D11, 
    0xD1165BB1, 0xD10AAAC5, 0xD0FEFA4D, 0xD0F34A49, 0xD0E79AB9, 0xD0DBEB9D, 
    0xD0D03CF5, 0xD0C48EC2, 0xD0B8E103, 0xD0AD33B9, 0xD0A186E4, 0xD095DA84, 
    0xD08A2E98, 0xD07E8322, 0xD072D821, 0xD0672D95, 0xD05B837F, 0xD04FD9DE, 
    0xD04430B3, 0xD03887FE, 0xD02CDFBF, 0xD02137F5, 0xD01590DD, 0xD009EA00, 
    0xCFFE439A, 0xCFF29DA9, 0xCFE6F830, 0xCFDB532D, 0xCFCFAEA1, 0xCFC40A8B, 
    0xCFB866ED, 0xCFACC3C6, 0xCFA12116, 0xCF957EDD, 0xCF89DD1C, 0xCF7E3BD3, 
    0xCF729B01, 0xCF66FAA7, 0xCF5B5AC5, 0xCF4FBB5A, 0xCF441C68, 0xCF387DEF, 
    0xCF2CDFED, 0xCF214264, 0xCF15A554, 0xCF0A08BC, 0xCEFE6C9E, 0xCEF2D0F8, 
    0xCEE735CB, 0xCEDB9B17, 0xCED00118, 0xCEC46757, 0xCEB8CE0F, 0xCEAD3541, 
    0xCEA19CED, 0xCE960512, 0xCE8A6DB1, 0xCE7ED6CB, 0xCE73405E, 0xCE67AA6C, 
    0xCE5C14F4, 0xCE507FF7, 0xCE44EB74, 0xCE39576C, 0xCE2DC3DF, 0xCE2230CD, 
    0xCE169E36, 0xCE0B0C1A, 0xCDFF7A79, 0xCDF3E953, 0xCDE858A9, 0xCDDCC87B, 
    0xCDD138C8, 0xCDC5A992, 0xCDBA1AD7, 0xCDAE8C98, 0xCDA2FED5, 0xCD9771C9, 
    0xCD8BE4FF, 0xCD8058B2, 0xCD74CCE1, 0xCD69418D, 0xCD5DB6B5, 0xCD522C5B, 
    0xCD46A27D, 0xCD3B191D, 0xCD2F903A, 0xCD2407D4, 0xCD187FEC, 0xCD0CF882, 
    0xCD017195, 0xCCF5EB26, 0xCCEA6535, 0xCCDEDFC2, 0xCCD35ACD, 0xCCC7D656, 
    0xCCBC525E, 0xCCB0CEE4, 0xCCA54BE9, 0xCC99C96D, 0xCC8E476F, 0xCC82C5F1, 
    0xCC7744F1, 0xCC6BC470, 0xCC6044AA, 0xCC54C528, 0xCC494626, 0xCC3DC7A3, 
    0xCC3249A0, 0xCC26CC1D, 0xCC1B4F19, 0xCC0FD296, 0xCC045693, 0xCBF8DB10, 
    0xCBED600E, 0xCBE1E58C, 0xCBD66B8B, 0xCBCAF20A, 0xCBBF790A, 0xCBB4008B, 
    0xCBA8888D, 0xCB9D1111, 0xCB919A15, 0xCB86239B, 0xCB7AADA2, 0xCB6F382B, 
    0xCB63C336, 0xCB584EC3, 0xCB4CDAD1, 0xCB416761, 0xCB35F474, 0xCB2A8209, 
    0xCB1F105A, 0xCB139EF4, 0xCB082E10, 0xCAFCBDAF, 0xCAF14DD1, 0xCAE5DE76, 
    0xCADA6F9D, 0xCACF0148, 0xCAC39376, 0xCAB82628, 0xCAACB95D, 0xCAA14D15, 
    0xCA95E151, 0xCA8A7611, 0xCA7F0B55, 0xCA73A11D, 0xCA683769, 0xCA5CCE39, 
    0xCA51658E, 0xCA45FD67, 0xCA3A95C4, 0xCA2F2EA7, 0xCA23C80E, 0xCA1861FA, 
    0xCA0CFC6B, 0xCA019761, 0xC9F632DC, 0xC9EACF17, 0xC9DF6B9D, 0xC9D408A8, 
    0xC9C8A63A, 0xC9BD4451, 0xC9B1E2EE, 0xC9A68211, 0xC99B21BA, 0xC98FC1E9, 
    0xC984629E, 0xC97903DA, 0xC96DA59D, 0xC96247E6, 0xC956EAB6, 0xC94B8E0D, 
    0xC94031EB, 0xC934D650, 0xC9297B3C, 0xC91E20AF, 0xC912C6AA, 0xC9076D2C, 
    0xC8FC1436, 0xC8F0BBC8, 0xC8E563E2, 0xC8DA0C83, 0xC8CEB5AD, 0xC8C35F5F, 
    0xC8B80999, 0xC8ACB495, 0xC8A15FE0, 0xC8960BB4, 0xC88AB810, 0xC87F64F5, 
    0xC8741263, 0xC868C05B, 0xC85D6EDB, 0xC8521DE5, 0xC846CD78, 0xC83B7D94, 
    0xC8302E3A, 0xC824DF6A, 0xC8199124, 0xC80E4367, 0xC802F635, 0xC7F7A98D, 
    0xC7EC5D6F, 0xC7E111DB, 0xC7D5C6D2, 0xC7CA7C53, 0xC7BF325F, 0xC7B3E8F6, 
    0xC7A8A018, 0xC79D57C5, 0xC7920FFD, 0xC786C8C0, 0xC77B8248, 0xC7703C22, 
    0xC764F688, 0xC759B179, 0xC74E6CF6, 0xC74328FF, 0xC737E594, 0xC72CA2B5, 
    0xC7216062, 0xC7161E9C, 0xC70ADD62, 0xC6FF9CB4, 0xC6F45C93, 0xC6E91CFF, 
    0xC6DDDDF8, 0xC6D29F7E, 0xC6C76190, 0xC6BC2430, 0xC6B0E75E, 0xC6A5AB18, 
    0xC69A6F61, 0xC68F3436, 0xC683F99A, 0xC678BF8B, 0xC66D860B, 0xC6624D18, 
    0xC65714B4, 0xC64BDD17, 0xC640A5CF, 0xC6356F16, 0xC62A38EB, 0xC61F034F, 
    0xC613CE42, 0xC60899C3, 0xC5FD65D4, 0xC5F23274, 0xC5E6FFA3, 0xC5DBCD62, 
    0xC5D09BB0, 0xC5C56A8D, 0xC5BA39FA, 0xC5AF09F7, 0xC5A3DA84, 0xC598ABA1, 
    0xC58D7D4E, 0xC5824F8B, 0xC5772258, 0xC56BF5B6, 0xC560C9A5, 0xC5559E24, 
    0xC54A7334, 0xC53F48D5, 0xC5341F06, 0xC528F5C9, 0xC51DCD1D, 0xC512A53B, 
    0xC5077DB2, 0xC4FC56BA, 0xC4F13053, 0xC4E60A7F, 0xC4DAE53C, 0xC4CFC08B, 
    0xC4C49C6D, 0xC4B978E0, 0xC4AE55E6, 0xC4A3337E, 0xC49811A8, 0xC48CF065, 
    0xC481CFB5, 0xC476AF98, 0xC46B900D, 0xC4607116, 0xC45552B1, 0xC44A34E0, 
    0xC43F17A2, 0xC433FAF8, 0xC428DEE1, 0xC41DC35E, 0xC412A86E, 0xC4078E12, 
    0xC3FC744B, 0xC3F15B17, 0xC3E642B0, 0xC3DB2AA5, 0xC3D0132F, 0xC3C4FC4C, 
    0xC3B9E5FF, 0xC3AED046, 0xC3A3BB22, 0xC398A693, 0xC38D9299, 0xC3827F34, 
    0xC3776C64, 0xC36C5A2A, 0xC3614885, 0xC3563776, 0xC34B26FC, 0xC3401719, 
    0xC33507CB, 0xC329F913, 0xC31EEAF1, 0xC313DD66, 0xC308D070, 0xC2FDC412, 
    0xC2F2B849, 0xC2E7AD18, 0xC2DCA27D, 0xC2D19879, 0xC2C68F0C, 0xC2BB8636, 
    0xC2B07E2F, 0xC2A57687, 0xC29A6F77, 0xC28F68FF, 0xC284631E, 0xC2795DD4, 
    0xC26E5923, 0xC2635509, 0xC2585187, 0xC24D4E9E, 0xC2424C4C, 0xC2374A94, 
    0xC22C4973, 0xC22148EB, 0xC21648FC, 0xC20B49A5, 0xC2004AE8, 0xC1F54CC3, 
    0xC1EA4F37, 0xC1DF5245, 0xC1D455EC, 0xC1C95A2C, 0xC1BE5F06, 0xC1B36479, 
    0xC1A86A87, 0xC19D712E, 0xC192786E, 0xC1878049, 0xC17C88BE, 0xC17191CE, 
    0xC1669B77, 0xC15BA5BC, 0xC150B09A, 0xC145BC14, 0xC13AC828, 0xC12FD4D7, 
    0xC124E221, 0xC119F006, 0xC10EFE86, 0xC1040DA2, 0xC0F91D59, 0xC0EE2E1B, 
    0xC0E33F09, 0xC0D85093, 0xC0CD62B8, 0xC0C2757A, 0xC0B788D8, 0xC0AC9CD1, 
    0xC0A1B167, 0xC096C69A, 0xC08BDC69, 0xC080F2D4, 0xC07609DC, 0xC06B2181, 
    0xC06039C3, 0xC05552A2, 0xC04A6C1D, 0xC03F8636, 0xC034A0ED, 0xC029BC40, 
    0xC01ED832, 0xC013F4C1, 0xC00911ED, 0xBFFE2FB8, 0xBFF34E20, 0xBFE86D26, 
    0xBFDD8CCB, 0xBFD2AD0E, 0xBFC7CDEF, 0xBFBCEF6E, 0xBFB2118C, 0xBFA73449, 
    0xBF9C57A5, 0xBF917B9F, 0xBF86A039, 0xBF7BC571, 0xBF70EB49, 0xBF6611C0, 
    0xBF5B38D6, 0xBF50608C, 0xBF4588E2, 0xBF3AB1D7, 0xBF2FDB6C, 0xBF2505A1, 
    0xBF1A3076, 0xBF0F5BEB, 0xBF048800, 0xBEF9B4B6, 0xBEEEE20C, 0xBEE41003, 
    0xBED93E9A, 0xBECE6DD2, 0xBEC39DAB, 0xBEB8CE25, 0xBEADFF40, 0xBEA330FC, 
    0xBE9863C8, 0xBE8D96C6, 0xBE82CA67, 0xBE77FEA9, 0xBE6D338C, 0xBE626911, 
    0xBE579F39, 0xBE4CD602, 0xBE420D6D, 0xBE37457B, 0xBE2C7E2B, 0xBE21B77D, 
    0xBE16F172, 0xBE0C2C09, 0xBE016744, 0xBDF6A321, 0xBDEBDFA1, 0xBDE11CC4, 
    0xBDD65A8A, 0xBDCB98F3, 0xBDC0D800, 0xBDB617B0, 0xBDAB5804, 0xBDA098FB, 
    0xBD95DA97, 0xBD8B1CD6, 0xBD805FB9, 0xBD75A340, 0xBD6AE76B, 0xBD602C3B, 
    0xBD5571AF, 0xBD4AB7C7, 0xBD3FFE84, 0xBD3545E6, 0xBD2A8DED, 0xBD1FD698, 
    0xBD151FE9, 0xBD0A69DE, 0xBCFFB479, 0xBCF4FFB9, 0xBCEA4B9F, 0xBCDF982A, 
    0xBCD4E55B, 0xBCCA3331, 0xBCBF81AE, 0xBCB4D0D0, 0xBCAA2098, 0xBC9F7107, 
    0xBC94C21B, 0xBC8A13D6, 0xBC7F6638, 0xBC74B940, 0xBC6A0CEE, 0xBC5F6144, 
    0xBC54B6AD, 0xBC4A0C50, 0xBC3F629B, 0xBC34B98C, 0xBC2A1125, 0xBC1F6965, 
    0xBC14C24D, 0xBC0A1BDC, 0xBBFF7613, 0xBBF4D0F1, 0xBBEA2C78, 0xBBDF88A7, 
    0xBBD4E57D, 0xBBCA42FC, 0xBBBFA123, 0xBBB4FFF3, 0xBBAA5F6B, 0xBB9FBF8C, 
    0xBB952055, 0xBB8A81C8, 0xBB7FE3E3, 0xBB7546A7, 0xBB6AAA14, 0xBB600E2B, 
    0xBB5572EB, 0xBB4AD854, 0xBB403E67, 0xBB35A523, 0xBB2B0C89, 0xBB207499, 
    0xBB15DD53, 0xBB0B46B7, 0xBB00B0C5, 0xBAF61B7E, 0xBAEB86E0, 0xBAE0F2EE, 
    0xBAD65FA5, 0xBACBCD08, 0xBAC13B15, 0xBAB6A9CD, 0xBAAC1930, 0xBAA1893E, 
    0xBA96F9F7, 0xBA8C6B5B, 0xBA81DD6B, 0xBA775026, 0xBA6CC38D, 0xBA6237A0, 
    0xBA57AC5E, 0xBA4D21C8, 0xBA4297DE, 0xBA380EA1, 0xBA2D860F, 0xBA22FE2A, 
    0xBA1876F1, 0xBA0DF0CF, 0xBA036AEF, 0xB9F8E5BC, 0xB9EE6136, 0xB9E3DD5C, 
    0xB9D95A30, 0xB9CED7B0, 0xB9C455DE, 0xB9B9D4B9, 0xB9AF5441, 0xB9A4D477, 
    0xB99A555B, 0xB98FD6EC, 0xB985592B, 0xB97ADC18, 0xB9705FB3, 0xB965E3FC, 
    0xB95B68F3, 0xB950EE99, 0xB94674EC, 0xB93BFBEF, 0xB93183A0, 0xB9270C00, 
    0xB91C950E, 0xB9121ECC, 0xB907A938, 0xB8FD3454, 0xB8F2C01F, 0xB8E84C99, 
    0xB8DDD9C2, 0xB8D3679B, 0xB8C8F624, 0xB8BE855C, 0xB8B41545, 0xB8A9A5DD, 
    0xB89F3725, 0xB894C91D, 0xB88A5BC6, 0xB87FEF1E, 0xB8758328, 0xB86B17E1, 
    0xB860AD4C, 0xB8564367, 0xB84BDA33, 0xB84171B0, 0xB83709DE, 0xB82CA2BD, 
    0xB8223C4D, 0xB817D68E, 0xB80D7181, 0xB8030D26, 0xB7F8A97C, 0xB7EE4684, 
    0xB7E3E43D, 0xB7D982A9, 0xB7CF2230, 0xB7C4C200, 0xB7BA6282, 0xB7B003B6, 
    0xB7A5A59D, 0xB79B4836, 0xB790EB82, 0xB7868F80, 0xB77C3432, 0xB771D996, 
    0xB7677FAD, 0xB75D2678, 0xB752CDF5, 0xB7487626, 0xB73E1F0B, 0xB733C8A3, 
    0xB72972EE, 0xB71F1DEE, 0xB714C9A1, 0xB70A7608, 0xB7002323, 0xB6F5D0F2, 
    0xB6EB7F75, 0xB6E12EAD, 0xB6D6DE99, 0xB6CC8F3A, 0xB6C2408F, 0xB6B7F299, 
    0xB6ADA558, 0xB6A358CB, 0xB6990CF4, 0xB68EC1D2, 0xB6847765, 0xB67A2DAD, 
    0xB66FE4AB, 0xB6659C5E, 0xB65B54C7, 0xB6510DE6, 0xB646C7BA, 0xB63C8245, 
    0xB6323D85, 0xB627F97B, 0xB61DB628, 0xB613738B, 0xB60931A4, 0xB5FEF074, 
    0xB5F4AFFA, 0xB5EA7038, 0xB5E0312C, 0xB5D5F2D6, 0xB5CBB538, 0xB5C17851, 
    0xB5B73C21, 0xB5AD00A9, 0xB5A2C5E7, 0xB5988C46, 0xB58E52F4, 0xB5841A59, 
    0xB579E276, 0xB56FAB4B, 0xB56574D9, 0xB55B3F1E, 0xB5510A1B, 0xB546D5D1, 
    0xB53CA23F, 0xB5326F65, 0xB5283D45, 0xB51E0BDC, 0xB513DB2D, 0xB509AB36, 
    0xB4FF7BF9, 0xB4F54D74, 0xB4EB1FA9, 0xB4E0F296, 0xB4D6C63E, 0xB4CC9A9E, 
    0xB4C26FB8, 0xB4B8458C, 0xB4AE1C1A, 0xB4A3F361, 0xB499CB63, 0xB48FA41E, 
    0xB4857D94, 0xB47B57C3, 0xB47132AE, 0xB4670E52, 0xB45CEAB1, 0xB452C7CB, 
    0xB448A59F, 0xB43E842F, 0xB4346379, 0xB42A437E, 0xB420243E, 0xB41605BA, 
    0xB40BE7F1, 0xB401CAE3, 0xB3F7AE91, 0xB3ED92FA, 0xB3E3781F, 0xB3D95E00, 
    0xB3CF449D, 0xB3C52BF6, 0xB3BB140A, 0xB3B0FCDB, 0xB3A6E669, 0xB39CD0B2, 
    0xB392BBB9, 0xB388A77B, 0xB37E93FB, 0xB3748137, 0xB36A6F97, 0xB3605E4D, 
    0xB3564DC0, 0xB34C3DF0, 0xB3422EDD, 0xB3382088, 0xB32E12F1, 0xB3240616, 
    0xB319F9FA, 0xB30FEE9B, 0xB305E3FA, 0xB2FBDA17, 0xB2F1D0F2, 0xB2E7C88B, 
    0xB2DDC0E3, 0xB2D3B9F8, 0xB2C9B3CC, 0xB2BFAE5F, 0xB2B5A9B0, 0xB2ABA5C0, 
    0xB2A1A28F, 0xB297A01D, 0xB28D9E69, 0xB2839D75, 0xB2799D40, 0xB26F9DCA, 
    0xB2659F14, 0xB25BA11D, 0xB251A3E5, 0xB247A76E, 0xB23DABB6, 0xB233B0BE, 
    0xB229B686, 0xB21FBD0E, 0xB215C456, 0xB20BCC5E, 0xB201D527, 0xB1F7DEB0, 
    0xB1EDE8FA, 0xB1E3F404, 0xB1D9FFCF, 0xB1D00C5B, 0xB1C619A8, 0xB1BC27B6, 
    0xB1B23685, 0xB1A84615, 0xB19E5666, 0xB1946779, 0xB18A794D, 0xB1808BE3, 
    0xB1769F3B, 0xB16CB354, 0xB162C830, 0xB158DDCD, 0xB14EF491, 0xB1450BB3, 
    0xB13B2396, 0xB1313C3C, 0xB12755A5, 0xB11D6FD0, 0xB1138ABE, 0xB109A66E, 
    0xB0FFC2E1, 0xB0F5E018, 0xB0EBFE11, 0xB0E21CCD, 0xB0D83C4D, 0xB0CE5C90, 
    0xB0C47D96, 0xB0BA9F60, 0xB0B0C1ED, 0xB0A6E53E, 0xB09D0953, 0xB0932E2C, 
    0xB08953C8, 0xB07F7A29, 0xB075A14E, 0xB06BC937, 0xB061F1E5, 0xB0581B57, 
    0xB04E458D, 0xB0447088, 0xB03A9C48, 0xB030C8CD, 0xB026F617, 0xB01D2425, 
    0xB01352F9, 0xB0098292, 0xAFFFB2F1, 0xAFF5E414, 0xAFEC15FD, 0xAFE248AC, 
    0xAFD87C21, 0xAFCEB05B, 0xAFC4E55B, 0xAFBB1B21, 0xAFB151AD, 0xAFA788FF, 
    0xAF9DC118, 0xAF93F9F7, 0xAF8A339C, 0xAF806E08, 0xAF76A93A, 0xAF6CE533, 
    0xAF6321F3, 0xAF595F7A, 0xAF4F9DC8, 0xAF45DCDD, 0xAF3C1CB9, 0xAF325DC0, 
    0xAF289F2B, 0xAF1EE15D, 0xAF152457, 0xAF0B6818, 0xAF01ACA2, 0xAEF7F1F3, 
    0xAEEE380C, 0xAEE47EED, 0xAEDAC696, 0xAED10F07, 0xAEC75841, 0xAEBDA243, 
    0xAEB3ED0E, 0xAEAA38A1, 0xAEA084FD, 0xAE96D221, 0xAE8D200F, 0xAE836EC5, 
    0xAE79BE45, 0xAE700E8E, 0xAE665FA0, 0xAE5CB17B, 0xAE530420, 0xAE49578E, 
    0xAE3FABC6, 0xAE3600C7, 0xAE2C5693, 0xAE22AD28, 0xAE190487, 0xAE0F5CB1, 
    0xAE05B5A4, 0xADFC0F62, 0xADF269EA, 0xADE8C53D, 0xADDF215A, 0xADD57E42, 
    0xADCBDBF5, 0xADC23A72, 0xADB899BB, 0xADAEF9CE, 0xADA55AAC, 0xAD9BBC56, 
    0xAD921ECB, 0xAD88820B, 0xAD7EE617, 0xAD754AEF, 0xAD6BB092, 0xAD621701, 
    0xAD587E3B, 0xAD4EE642, 0xAD454F15, 0xAD3BB8B3, 0xAD32231E, 0xAD288E56, 
    0xAD1EFABB, 0xAD15678B, 0xAD0BD528, 0xAD024392, 0xACF8B2C8, 0xACEF22CB, 
    0xACE5939B, 0xACDC0538, 0xACD277A2, 0xACC8EADA, 0xACBF5EDF, 0xACB5D3B1, 
    0xACAC4951, 0xACA2BFBE, 0xAC9936F9, 0xAC8FAF02, 0xAC8627D9, 0xAC7CA17D, 
    0xAC731BF0, 0xAC699731, 0xAC601340, 0xAC56901D, 0xAC4D0DC9, 0xAC438C44, 
    0xAC3A0B8D, 0xAC308BA5, 0xAC270C8B, 0xAC1D8E41, 0xAC1410C5, 0xAC0A9418, 
    0xAC01183B, 0xABF79D2D, 0xABEE22EE, 0xABE4A97F, 0xABDB30DF, 0xABD1B90F, 
    0xABC8420E, 0xABBECBDE, 0xABB5567D, 0xABABE1EC, 0xABA26E2B, 0xAB98FB3B, 
    0xAB8F891A, 0xAB8617CA, 0xAB7CA74B, 0xAB73379C, 0xAB69C8BE, 0xAB605AB0, 
    0xAB56ED73, 0xAB4D8107, 0xAB44156C, 0xAB3AAAA2, 0xAB3140A9, 0xAB27D782, 
    0xAB1E6F2C, 0xAB150807, 0xAB0BA153, 0xAB023B72, 0xAAF8D662, 0xAAEF7224, 
    0xAAE60EB8, 0xAADCAC1D, 0xAAD34A55, 0xAAC9E95F, 0xAAC0893C, 0xAAB729EA, 
    0xAAADCB6B, 0xAAA46DBF, 0xAA9B10E5, 0xAA91B4DE, 0xAA8859A9, 0xAA7EFF48, 
    0xAA75A5BA, 0xAA6C4CFE, 0xAA62F516, 0xAA599E01, 0xAA5047BF, 0xAA46F251, 
    0xAA3D9DB6, 0xAA3449EF, 0xAA2AF6FC, 0xAA21A4DC, 0xAA185390, 0xAA0F0318, 
    0xAA05B374, 0xA9FC64A5, 0xA9F316A9, 0xA9E9C982, 0xA9E07D30, 0xA9D731B2, 
    0xA9CDE708, 0xA9C49D33, 0xA9BB5433, 0xA9B20C08, 0xA9A8C4B1, 0xA99F7E30, 
    0xA9963884, 0xA98CF3AD, 0xA983AFAB, 0xA97A6C7F, 0xA9712A28, 0xA967E8A7, 
    0xA95EA7FC, 0xA9556826, 0xA94C2926, 0xA942EAFC, 0xA939ADA8, 0xA930712A, 
    0xA9273583, 0xA91DFAB1, 0xA914C114, 0xA90B87F0, 0xA9024FA2, 0xA8F9182A, 
    0xA8EFE18A, 0xA8E6ABC0, 0xA8DD76CD, 0xA8D442B1, 0xA8CB0F6C, 0xA8C1DCFF, 
    0xA8B8AB68, 0xA8AF7AA9, 0xA8A64AC2, 0xA89D1BB2, 0xA893ED79, 0xA88AC018, 
    0xA881938F, 0xA87867DE, 0xA86F3D05, 0xA8661304, 0xA85CE9DB, 0xA853C18B, 
    0xA84A9A13, 0xA8417373, 0xA8384DAB, 0xA82F28BC, 0xA82604A6, 0xA81CE169, 
    0xA813BF04, 0xA80A9D79, 0xA8017CC6, 0xA7F85CED, 0xA7EF3DED, 0xA7E61FC6, 
    0xA7DD0278, 0xA7D3E604, 0xA7CACA6A, 0xA7C1AFA9, 0xA7B895C2, 0xA7AF7CB4, 
    0xA7A66481, 0xA79D4D28, 0xA79436A8, 0xA78B2103, 0xA7820C38, 0xA778F848, 
    0xA76FE532, 0xA766D2F6, 0xA75DC195, 0xA754B10F, 0xA74BA163, 0xA7429293, 
    0xA739849D, 0xA7307782, 0xA7276B9F, 0xA71E603B, 0xA71555B2, 0xA70C4C04, 
    0xA7034332, 0xA6FA3B3C, 0xA6F13421, 0xA6E82DE2, 0xA6DF287E, 0xA6D623F7, 
    0xA6CD204B, 0xA6C41D7C, 0xA6BB1B89, 0xA6B21A72, 0xA6A91A38, 0xA6A01AD9, 
    0xA6971C58, 0xA68E1EB3, 0xA68521EB, 0xA67C25FF, 0xA6732AF1, 0xA66A30BF, 
    0xA661376A, 0xA6583EF3, 0xA64F4759, 0xA646509C, 0xA63D5ABC, 0xA63465BA, 
    0xA62B7196, 0xA6227E4F, 0xA6198BE6, 0xA6109A5A, 0xA607A9AD, 0xA5FEB9DE, 
    0xA5F5CAEC, 0xA5ECDCD9, 0xA5E3EFA4, 0xA5DB034E, 0xA5D217D5, 0xA5C92D3C, 
    0xA5C04381, 0xA5B75AA4, 0xA5AE72A7, 0xA5A58B88, 0xA59CA548, 0xA593BFE7, 
    0xA58ADB66, 0xA581F7C3, 0xA5791500, 0xA570331C, 0xA5675218, 0xA55E71F3, 
    0xA55592AE, 0xA54CB448, 0xA543D6C3, 0xA53AFA77, 0xA5321EB1, 0xA52943CB, 
    0xA52069C6, 0xA51790A0, 0xA50EB85B, 0xA505E0F6, 0xA4FD0A72, 0xA4F434CE, 
    0xA4EB600B, 0xA4E28C29, 0xA4D9B927, 0xA4D0E707, 0xA4C815C7, 0xA4BF4569, 
    0xA4B675EB, 0xA4ADA74F, 0xA4A4D994, 0xA49C0CBB, 0xA49340C3, 0xA48A75AC, 
    0xA481AB78, 0xA478E225, 0xA47019B4, 0xA4675225, 0xA45E8B77, 0xA455C5AC, 
    0xA44D00C3, 0xA4443CBD, 0xA43B7999, 0xA432B757, 0xA429F5F7, 0xA421357B, 
    0xA41875E1, 0xA40FB729, 0xA406F955, 0xA3FE3C63, 0xA3F58055, 0xA3ECC529, 
    0xA3E40AE1, 0xA3DB517C, 0xA3D298FB, 0xA3C9E15D, 0xA3C12AA2, 0xA3B874CB, 
    0xA3AFBFD8, 0xA3A70BC8, 0xA39E589C, 0xA395A655, 0xA38CF4F1, 0xA3844471, 
    0xA37B94D6, 0xA372E61F, 0xA36A384C, 0xA3618B5E, 0xA358DFAC, 0xA3503487, 
    0xA3478A47, 0xA33EE0EB, 0xA3363874, 0xA32D90E2, 0xA324EA35, 0xA31C446E, 
    0xA3139F8B, 0xA30AFB8E, 0xA3025876, 0xA2F9B643, 0xA2F114F6, 0xA2E8748F, 
    0xA2DFD50D, 0xA2D73671, 0xA2CE98BB, 0xA2C5FBEB, 0xA2BD6001, 0xA2B4C4FD, 
    0xA2AC2AE0, 0xA2A391A8, 0xA29AF957, 0xA29261ED, 0xA289CB68, 0xA28135CB, 
    0xA278A114, 0xA2700D44, 0xA2677A5B, 0xA25EE859, 0xA256573D, 0xA24DC709, 
    0xA24537BC, 0xA23CA957, 0xA2341BD8, 0xA22B8F42, 0xA2230392, 0xA21A78CA, 
    0xA211EEEA, 0xA20965F2, 0xA200DDE2, 0xA1F856B9, 0xA1EFD079, 0xA1E74B20, 
    0xA1DEC6B0, 0xA1D64328, 0xA1CDC088, 0xA1C53ED1, 0xA1BCBE02, 0xA1B43E1C, 
    0xA1ABBF1F, 0xA1A3410A, 0xA19AC3DE, 0xA192479B, 0xA189CC41, 0xA1815226, 
    0xA178D89F, 0xA1706000, 0xA167E84B, 0xA15F717F, 0xA156FB9D, 0xA14E86A4, 
    0xA1461295, 0xA13D9F6F, 0xA1352D34, 0xA12CBBE2, 0xA1244B7A, 0xA11BDBFD, 
    0xA1136D69, 0xA10AFFC0, 0xA1029301, 0xA0FA272C, 0xA0F1BC42, 0xA0E95242, 
    0xA0E0E92D, 0xA0D88103, 0xA0D019C3, 0xA0C7B36F, 0xA0BF4E05, 0xA0B6E986, 
    0xA0AE85F3, 0xA0A6234A, 0xA09DC18D, 0xA09560BC, 0xA08D00D5, 0xA084A1DA, 
    0xA07C43CB, 0xA073E6A8, 0xA06B8A70, 0xA0632F24, 0xA05AD4C4, 0xA0527B50, 
    0xA04A22C8, 0xA041CB2C, 0xA039747C, 0xA0311EB9, 0xA028C9E2, 0xA02075F8, 
    0xA01822FA, 0xA00FD0E9, 0xA0077FC4, 0x9FFF2F8D, 0x9FF6E042, 0x9FEE91E4, 
    0x9FE64473, 0x9FDDF7F0, 0x9FD5AC59, 0x9FCD61B0, 0x9FC517F4, 0x9FBCCF26, 
    0x9FB48799, 0x9FAC40A6, 0x9FA3FAA0, 0x9F9BB588, 0x9F93715E, 0x9F8B2E22, 
    0x9F82EBD4, 0x9F7AAA74, 0x9F726A02, 0x9F6A2A7F, 0x9F61EBE9, 0x9F59AE42, 
    0x9F51718A, 0x9F4935C0, 0x9F40FAE5, 0x9F38C0F8, 0x9F3087FA, 0x9F284FEC, 
    0x9F2018CC, 0x9F17E29B, 0x9F0FAD59, 0x9F077906, 0x9EFF45A3, 0x9EF7132F, 
    0x9EEEE1AA, 0x9EE6B115, 0x9EDE8170, 0x9ED652BA, 0x9ECE24F4, 0x9EC5F81E, 
    0x9EBDCC37, 0x9EB5A141, 0x9EAD773B, 0x9EA54E24, 0x9E9D25FE, 0x9E94FEC9, 
    0x9E8CD883, 0x9E84B32E, 0x9E7C8ECA, 0x9E746B56, 0x9E6C48D3, 0x9E642741, 
    0x9E5C06A0, 0x9E53E6EF, 0x9E4BC82F, 0x9E43AA61, 0x9E3B8D84, 0x9E337198, 
    0x9E2B569D, 0x9E233C94, 0x9E1B237C, 0x9E130B55, 0x9E0AF421, 0x9E02DDDE, 
    0x9DFAC88C, 0x9DF2B47F, 0x9DEAA112, 0x9DE28E96, 0x9DDA7D0D, 0x9DD26C76, 
    0x9DCA5CD1, 0x9DC24E1E, 0x9DBA405E, 0x9DB23390, 0x9DAA27B5, 0x9DA21CCC, 
    0x9D9A12D6, 0x9D9209D3, 0x9D8A01C3, 0x9D81FAA6, 0x9D79F47B, 0x9D71EF44, 
    0x9D69EB00, 0x9D61E7AF, 0x9D59E552, 0x9D51E3E8, 0x9D49E372, 0x9D41E3EF, 
    0x9D39E55F, 0x9D31E7C4, 0x9D29EB1C, 0x9D21EF68, 0x9D19F4A8, 0x9D11FADC, 
    0x9D0A0204, 0x9D020A21, 0x9CFA1331, 0x9CF21D36, 0x9CEA282F, 0x9CE2341D, 
    0x9CDA4100, 0x9CD24ED7, 0x9CCA5DA2, 0x9CC26D63, 0x9CBA7E18, 0x9CB28FC2, 
    0x9CAAA262, 0x9CA2B5F6, 0x9C9ACA80, 0x9C92DFFF, 0x9C8AF673, 0x9C830DDC, 
    0x9C7B263C, 0x9C733F90, 0x9C6B59DA, 0x9C63751A, 0x9C5B9150, 0x9C53AE7C, 
    0x9C4BCC9D, 0x9C43EC05, 0x9C3C0C13, 0x9C342D16, 0x9C2C4F10, 0x9C247201, 
    0x9C1C95E7, 0x9C14BAC5, 0x9C0CE098, 0x9C050763, 0x9BFD2F24, 0x9BF557DB, 
    0x9BED818A, 0x9BE5AC30, 0x9BDDD7CC, 0x9BD60460, 0x9BCE31EA, 0x9BC6606C, 
    0x9BBE8FE6, 0x9BB6C056, 0x9BAEF1BE, 0x9BA7241E, 0x9B9F5775, 0x9B978BC4, 
    0x9B8FC10B, 0x9B87F749, 0x9B802E80, 0x9B7866AE, 0x9B709FD4, 0x9B68D9F3, 
    0x9B61150A, 0x9B595119, 0x9B518E20, 0x9B49CC20, 0x9B420B18, 0x9B3A4B09, 
    0x9B328BF2, 0x9B2ACDD4, 0x9B2310AF, 0x9B1B5483, 0x9B139950, 0x9B0BDF16, 
    0x9B0425D5, 0x9AFC6D8D, 0x9AF4B63E, 0x9AECFFE9, 0x9AE54A8D, 0x9ADD962A, 
    0x9AD5E2C1, 0x9ACE3052, 0x9AC67EDC, 0x9ABECE61, 0x9AB71EDF, 0x9AAF7056, 
    0x9AA7C2C8, 0x9AA01634, 0x9A986AE8, 0x9A90C049, 0x9A8916A3, 0x9A816DF8, 
    0x9A79C647, 0x9A721F91, 0x9A6A79D5, 0x9A62D514, 0x9A5B314E, 0x9A538E83, 
    0x9A4BECB2, 0x9A444BDC, 0x9A3CAC02, 0x9A350D22, 0x9A2D6F3E, 0x9A25D255,
    0x9A1E3667, 0x9A169B74, 0x9A0F017D, 0x9A076882, 0x99FFD082, 0x99F8397E, 
    0x99F0A375, 0x99E90E69, 0x99E17A58, 0x99D9E743, 0x99D2552B, 0x99CAC40E, 
    0x99C333EE, 0x99BBA4CA, 0x99B416A2, 0x99AC8976, 0x99A4FD48, 0x999D7215, 
    0x9995E7DF, 0x998E5EA6, 0x9986D66A, 0x997F4F2B, 0x9977C8E8, 0x997043A3, 
    0x9968BF5A, 0x99613C0F, 0x9959B9C1, 0x99523870, 0x994AB81D, 0x994338C7, 
    0x993BBA6E, 0x99343D13, 0x992CC0B6, 0x99254556, 0x991DCAF4, 0x99165190, 
    0x990ED92A, 0x990761C2, 0x98FFEB58, 0x98F87638, 0x98F101CB, 0x98E98E5B, 
    0x98E21BEA, 0x98DAAA78, 0x98D33A04, 0x98CBCA8E, 0x98C45C17, 0x98BCEE9F, 
    0x98B58226, 0x98AE16AB, 0x98A6AC30, 0x989F42B3, 0x9897DA36, 0x989072B7, 
    0x98890C38, 0x9881A6B9, 0x987A4238, 0x9872DEB7, 0x986B7C36, 0x98641AB4, 
    0x985CBA31, 0x98555AAF, 0x984DFC2C, 0x98469EA9, 0x983F4226, 0x9837E6A3, 
    0x98308C20, 0x9829329D, 0x9821DA1B, 0x981A8299, 0x98132C17, 0x980BD695, 
    0x98048214, 0x97FD2E94, 0x97F5DC14, 0x97EE8A95, 0x97E73A17, 0x97DFEA99, 
    0x97D89C1D, 0x97D14EA1, 0x97CA0226, 0x97C2B6AD, 0x97BB6C35, 0x97B422BE, 
    0x97ACDA49, 0x97A592D4, 0x979E4C62, 0x979706F1, 0x978FC281, 0x97887F13, 
    0x97813CA7, 0x9779FB3D, 0x9772BAD5, 0x976B7B6F, 0x97643D54, 0x975CFFF2, 
    0x9755C392, 0x974E8834, 0x97474DD9, 0x97401480, 0x9738DC29, 0x9731A4D5, 
    0x972A6E84, 0x97233935, 0x971C04E9, 0x9714D1A0, 0x970D9F59, 0x97066E16, 
    0x96FF3DD6, 0x96F80E98, 0x96F0E05E, 0x96E9B327, 0x96E286F4, 0x96DB5BC3, 
    0x96D43196, 0x96CD086D, 0x96C5E047, 0x96BEB925, 0x96B79307, 0x96B06DEC, 
    0x96A949D5, 0x96A226C3, 0x969B04B4, 0x9693E3A9, 0x968CC3A2, 0x9685A49F, 
    0x967E86A1, 0x967769A7, 0x96704DB2, 0x966932C1, 0x966218D4, 0x965AFFEC, 
    0x9653E809, 0x964CD12A, 0x9645BB51, 0x963EA67C, 0x963792AC, 0x96307FE1, 
    0x96296E1B, 0x96225D5A, 0x961B4D9F, 0x96143EE9, 0x960D3138, 0x9606248C, 
    0x95FF18E6, 0x95F80E46, 0x95F104AB, 0x95E9FC16, 0x95E2F487, 0x95DBEE45, 
    0x95D4E8C1, 0x95CDE444, 0x95C6E0CC, 0x95BFDE5A, 0x95B8DCEF, 0x95B1DC8A, 
    0x95AADD2B, 0x95A3DED2, 0x959CE180, 0x9595E535, 0x958EE9F0, 0x9587EFB1, 
    0x9580F67A, 0x9579FE49, 0x9573071F, 0x956C10FC, 0x95651BE0, 0x955E27CB, 
    0x955734BC, 0x955042B6, 0x954951B6, 0x954261BE, 0x953B72CD, 0x953484E3, 
    0x952D9801, 0x9526AC27, 0x951FC154, 0x9518D789, 0x9511EEC6, 0x950B070A, 
    0x95042057, 0x94FD3AAB, 0x94F65608, 0x94EF726C, 0x94E88FD9, 0x94E1AE4E, 
    0x94DACDCB, 0x94D3EE51, 0x94CD0FDF, 0x94C63276, 0x94BF5615, 0x94B87ABD, 
    0x94B1A06D, 0x94AAC727, 0x94A3EEE9, 0x949D17B4, 0x94964188, 0x948F6C65, 
    0x9488984B, 0x9481C53A, 0x947AF333, 0x94742235, 0x946D5240, 0x9466839A, 
    0x945FB5B8, 0x9458E8E0, 0x94521D11, 0x944B524C, 0x9444884B, 0x943DBF9A, 
    0x9436F7F2, 0x94303155, 0x94296BC1, 0x9422A738, 0x941BE3B8, 0x94152143, 
    0x940E5FD8, 0x94079F78, 0x9400E021, 0x93FA21D6, 0x93F36495, 0x93ECA85E, 
    0x93E5ED32, 0x93DF3311, 0x93D879FB, 0x93D1C1EF, 0x93CB0AEF, 0x93C454F9, 
    0x93BDA00F, 0x93B6EC2F, 0x93B0395B, 0x93A9881B, 0x93A2D75D, 0x939C27AB, 
    0x93957904, 0x938ECB68, 0x93881ED9, 0x93817354, 0x937AC8DC, 0x93741F6F, 
    0x936D770E, 0x9366CFB9, 0x93602970, 0x93598433, 0x9352E003, 0x934C3CDE, 
    0x93459AC5, 0x933EF9B9, 0x933859B9, 0x9331BAC6, 0x932B1CDE, 0x93248004, 
    0x931DE436, 0x93174975, 0x9310AFC0, 0x930A1718, 0x93037F7E, 0x92FCE8F0, 
    0x92F6536F, 0x92EFBEFB, 0x92E92B94, 0x92E2993A, 0x92DC07EE, 0x92D577AE, 
    0x92CEE87D, 0x92C85A58, 0x92C1CD41, 0x92BB4138, 0x92B4B63C, 0x92AE2C4E, 
    0x92A7A36E, 0x92A11B9B, 0x929A94D7, 0x92940F20, 0x928D8A77, 0x928706DC, 
    0x92808450, 0x927A02D1, 0x92738261, 0x926D02FF, 0x926684AC, 0x92600767, 
    0x92598B30, 0x92531008, 0x924C95EF, 0x92461CE4, 0x923FA4E8, 0x92392DFB, 
    0x9232B81C, 0x922C434D, 0x9225CF8D, 0x921F5CDB, 0x9218EB39, 0x92127AA6, 
    0x920C0B22, 0x92059CAD, 0x91FF2F48, 0x91F8C2F3, 0x91F257AC, 0x91EBED76, 
    0x91E5844E, 0x91DF1C37, 0x91D8B52F, 0x91D24F37, 0x91CBEA4F, 0x91C58677, 
    0x91BF23AF, 0x91B8C1F7, 0x91B2614F, 0x91AC01B7, 0x91A5A32F, 0x919F45B8, 
    0x9198E951, 0x91928DFA, 0x918C33B4, 0x9185DA7F, 0x917F825A, 0x91792B45, 
    0x9172D542, 0x916C804F, 0x91662C6D, 0x915FD99C, 0x915987DC, 0x9153372C, 
    0x914CE78E, 0x91469901, 0x91404B86, 0x9139FF1B, 0x9133B3C2, 0x912D697A, 
    0x91272044, 0x9120D81F, 0x911A910C, 0x91144B0B, 0x910E061B, 0x9107C23C, 
    0x91017F70, 0x90FB3DB6, 0x90F4FD0D, 0x90EEBD77, 0x90E87F71, 0x90E241FF, 
    0x90DC059E, 0x90D5CA50, 0x90CF9014, 0x90C956EB, 0x90C31ED4, 0x90BCE7CF, 
    0x90B6B1DD, 0x90B07CFE, 0x90AA4931, 0x90A41677, 0x909DE4D0, 0x9097B43B, 
    0x909184BA, 0x908B564B, 0x908528EF, 0x907EFCA7, 0x9078D171, 0x9072A74F, 
    0x906C7E40, 0x90665644, 0x90602F5C, 0x905A0987, 0x9053E4C5, 0x904DC118, 
    0x90479E7D, 0x90417CF7, 0x903B5C84, 0x90353D25, 0x902F1ED9, 0x902901A2, 
    0x9022E57E, 0x901CCA6F, 0x9016B074, 0x9010978C, 0x900A7FB9, 0x900468FA, 
    0x8FFE5350, 0x8FF83EBA, 0x8FF22B38, 0x8FEC18CB, 0x8FE60772, 0x8FDFF72E, 
    0x8FD9E7FF, 0x8FD3D9E4, 0x8FCDCCDE, 0x8FC7C0ED, 0x8FC1B611, 0x8FBBAC4A, 
    0x8FB5A397, 0x8FAF9BFA, 0x8FA99572, 0x8FA38FFF, 0x8F9D8BA2, 0x8F978859, 
    0x8F918626, 0x8F8B8509, 0x8F858501, 0x8F7F860E, 0x8F798831, 0x8F738B6A, 
    0x8F6D8FB8, 0x8F67951D, 0x8F619B96, 0x8F5BA326, 0x8F55ABCC, 0x8F4FB588, 
    0x8F49C05A, 0x8F43CC42, 0x8F3DD940, 0x8F37E754, 0x8F31F67F, 0x8F2C06C0, 
    0x8F261817, 0x8F202A85, 0x8F1A3E09, 0x8F1452A4, 0x8F0E6855, 0x8F087F1E, 
    0x8F0296FC, 0x8EFCAFF2, 0x8EF6C9FF, 0x8EF0E522, 0x8EEB015D, 0x8EE51EAE, 
    0x8EDF3D16, 0x8ED95C96, 0x8ED37D2D, 0x8ECD9EDB, 0x8EC7C1A0, 0x8EC1E57D, 
    0x8EBC0A71, 0x8EB6307D, 0x8EB057A0, 0x8EAA7FDB, 0x8EA4A92D, 0x8E9ED397, 
    0x8E98FF19, 0x8E932BB3, 0x8E8D5964, 0x8E87882E, 0x8E81B80F, 0x8E7BE909, 
    0x8E761B1A, 0x8E704E44, 0x8E6A8286, 0x8E64B7E0, 0x8E5EEE52, 0x8E5925DD, 
    0x8E535EF6, 0x8E4D98B2, 0x8E47D386, 0x8E420F73, 0x8E3C4C78, 0x8E368A96, 
    0x8E30C9CD, 0x8E2B0A1D, 0x8E254B86, 0x8E1F8E07, 0x8E19D1A2, 0x8E141655, 
    0x8E0E5C22, 0x8E08A308, 0x8E02EB06, 0x8DFD341F, 0x8DF77E50, 0x8DF1C99B, 
    0x8DEC15FF, 0x8DE6637D, 0x8DE0B215, 0x8DDB01C6, 0x8DD55290, 0x8DCFA474, 
    0x8DC9F772, 0x8DC44B8A, 0x8DBEA0BC, 0x8DB8F708, 0x8DB34E6D, 0x8DADA6ED, 
    0x8DA80086, 0x8DA25B3A, 0x8D9CB708, 0x8D9713F0, 0x8D9171F3, 0x8D8BD110, 
    0x8D863147, 0x8D809299, 0x8D7AF505, 0x8D75588C, 0x8D6FBD2D, 0x8D6A22EA, 
    0x8D6489C0, 0x8D5EF1B2, 0x8D595ABE, 0x8D53C4E6, 0x8D4E3028, 0x8D489C85, 
    0x8D4309FE, 0x8D3D7891, 0x8D37E840, 0x8D32590A, 0x8D2CCAEF, 0x8D273DEF, 
    0x8D21B20B, 0x8D1C2742, 0x8D169D95, 0x8D111503, 0x8D0B8D8D, 0x8D060733, 
    0x8D0081F4, 0x8CFAFDD1, 0x8CF57ACA, 0x8CEFF8DE, 0x8CEA780F, 0x8CE4F85B, 
    0x8CDF79C4, 0x8CD9FC48, 0x8CD47FE9, 0x8CCF04A6, 0x8CC98A7F, 0x8CC41174, 
    0x8CBE9986, 0x8CB922B4, 0x8CB3ACFE, 0x8CAE3865, 0x8CA8C4E9, 0x8CA35289, 
    0x8C9DE145, 0x8C98711F, 0x8C930215, 0x8C8D9428, 0x8C882758, 0x8C82BBA5, 
    0x8C7D510E, 0x8C77E795, 0x8C727F39, 0x8C6D17FA, 0x8C67B1D8, 0x8C624CD3, 
    0x8C5CE8EC, 0x8C578622, 0x8C522475, 0x8C4CC3E6, 0x8C476474, 0x8C42061F, 
    0x8C3CA8E9, 0x8C374CD0, 0x8C31F1D4, 0x8C2C97F7, 0x8C273F37, 0x8C21E795, 
    0x8C1C9111, 0x8C173BAA, 0x8C11E762, 0x8C0C9438, 0x8C07422C, 0x8C01F13E, 
    0x8BFCA16F, 0x8BF752BD, 0x8BF20596, 0x8BECB921, 0x8BE76DCB, 0x8BE22393, 
    0x8BDCDA79, 0x8BD7927E, 0x8BD24BA2, 0x8BCD05E4, 0x8BC7C145, 0x8BC27DC5, 
    0x8BBD3B64, 0x8BB7FA21, 0x8BB2B9FE, 0x8BAD7AF9, 0x8BA83D14, 0x8BA3004D, 
    0x8B9DC4A6, 0x8B988A1D, 0x8B9350B4, 0x8B8E186B, 0x8B88E140, 0x8B83AB35, 
    0x8B7E7649, 0x8B79427D, 0x8B740FD0, 0x8B6EDE43, 0x8B69ADD6, 0x8B647E88, 
    0x8B5F505A, 0x8B5A234C, 0x8B54F75D, 0x8B4FCC8E, 0x8B4AA2E0, 0x8B457A51, 
    0x8B4052E2, 0x8B3B2C93, 0x8B360765, 0x8B30E357, 0x8B2BC068, 0x8B269E9A, 
    0x8B217DED, 0x8B1C5E60, 0x8B173FF3, 0x8B1222A6, 0x8B0D067B, 0x8B07EB6F, 
    0x8B02D185, 0x8AFDB8BB, 0x8AF8A111, 0x8AF38A89, 0x8AEE7521, 0x8AE960DA, 
    0x8AE44DB4, 0x8ADF3BAF, 0x8ADA2ACB, 0x8AD51B08, 0x8AD00C66, 0x8ACAFEE6, 
    0x8AC5F286, 0x8AC0E748, 0x8ABBDD2B, 0x8AB6D42F, 0x8AB1CC55, 0x8AACC59C, 
    0x8AA7C005, 0x8AA2BB8F, 0x8A9DB83B, 0x8A98B609, 0x8A93B4F8, 0x8A8EB509, 
    0x8A89B63B, 0x8A84B890, 0x8A7FBC06, 0x8A7AC09E, 0x8A75C659, 0x8A70CD35, 
    0x8A6BD533, 0x8A66DE54, 0x8A61E896, 0x8A5CF3FB, 0x8A580082, 0x8A530E2C, 
    0x8A4E1CF7, 0x8A492CE5, 0x8A443DF6, 0x8A3F5029, 0x8A3A637F, 0x8A3577F7, 
    0x8A308D92, 0x8A2BA44F, 0x8A26BC30, 0x8A21D533, 0x8A1CEF59, 0x8A180AA2, 
    0x8A13270D, 0x8A0E449C, 0x8A09634E, 0x8A048322, 0x89FFA41A, 0x89FAC635, 
    0x89F5E974, 0x89F10DD5, 0x89EC335A, 0x89E75A02, 0x89E281CD, 0x89DDAABC, 
    0x89D8D4CF, 0x89D40005, 0x89CF2C5E, 0x89CA5A3E, 0x89C588DF, 0x89C0B8A3, 
    0x89BBE98B, 0x89B71B97, 0x89B24EC7, 0x89AD831B, 0x89A8B893, 0x89A3EF2F, 
    0x899F26EF, 0x899A5FD2, 0x899599DA, 0x8990D507, 0x898C1157, 0x89874ECC, 
    0x89828D65, 0x897DCD22, 0x89790E04, 0x8974500A, 0x896F9335, 0x896AD784, 
    0x89661CF8, 0x89616391, 0x895CAB4E, 0x8957F430, 0x89533E37, 0x894E8962, 
    0x8949D5B3, 0x89452328, 0x894071C2, 0x893BC182, 0x89371266, 0x8932646F, 
    0x892DB79E, 0x89290BF2, 0x8924616B, 0x891FB809, 0x891B0FCC, 0x891668B5, 
    0x8911C2C4, 0x890D1DF7, 0x89087A51, 0x8903D7D0, 0x88FF3674, 0x88FA963E, 
    0x88F5F72E, 0x88F15943, 0x88ECBC7E, 0x88E820DF, 0x88E38666, 0x88DEED13, 
    0x88DA54E6, 0x88D5BDDE, 0x88D127FD, 0x88CC9342, 0x88C7FFAD, 0x88C36D3E, 
    0x88BEDBF5, 0x88BA4BD2, 0x88B5BCD6, 0x88B12F00, 0x88ACA251, 0x88A816C8, 
    0x88A38C65, 0x889F0329, 0x889A7B14, 0x8895F425, 0x88916E5C, 0x888CE9BB, 
    0x88886640, 0x8883E3EC, 0x887F62BF, 0x887AE2B8, 0x887663D9, 0x8871E620, 
    0x886D698F, 0x8868EE24, 0x886473E1, 0x885FFAC5, 0x885B82CF, 0x88570C01, 
    0x8852965B, 0x884E21DB, 0x8849AE83, 0x88453C53, 0x8840CB49, 0x883C5B68, 
    0x8837ECAD, 0x88337F1B, 0x882F12AF, 0x882AA76C, 0x88263D50, 0x8821D45C, 
    0x881D6C90, 0x881905EB, 0x8814A06E, 0x88103C1A, 0x880BD8ED, 0x880776E8, 
    0x8803160B, 0x87FEB656, 0x87FA57CA, 0x87F5FA65, 0x87F19E29, 0x87ED4315, 
    0x87E8E929, 0x87E49065, 0x87E038CA, 0x87DBE257, 0x87D78D0D, 0x87D33943, 
    0x87CEE64A, 0x87CA9479, 0x87C643D0, 0x87C1F451, 0x87BDA5FA, 0x87B958CB, 
    0x87B50CC6, 0x87B0C1E9, 0x87AC7836, 0x87A82FAB, 0x87A3E849, 0x879FA210, 
    0x879B5D00, 0x87971919, 0x8792D65B, 0x878E94C6, 0x878A545B, 0x87861519, 
    0x8781D700, 0x877D9A10, 0x87795E4A, 0x877523AD, 0x8770EA39, 0x876CB1EF, 
    0x87687ACF, 0x876444D8, 0x8760100A, 0x875BDC66, 0x8757A9EC, 0x8753789C, 
    0x874F4875, 0x874B1978, 0x8746EBA5, 0x8742BEFC, 0x873E937D, 0x873A6928, 
    0x87363FFD, 0x873217FB, 0x872DF124, 0x8729CB77, 0x8725A6F4, 0x8721839B, 
    0x871D616D, 0x87194069, 0x8715208F, 0x871101DF, 0x870CE45A, 0x8708C800, 
    0x8704ACCF, 0x870092CA, 0x86FC79EE, 0x86F8623E, 0x86F44BB8, 0x86F0365D, 
    0x86EC222C, 0x86E80F26, 0x86E3FD4B, 0x86DFEC9B, 0x86DBDD16, 0x86D7CEBB, 
    0x86D3C18C, 0x86CFB587, 0x86CBAAAE, 0x86C7A0FF, 0x86C3987C, 0x86BF9124, 
    0x86BB8AF7, 0x86B785F5, 0x86B3821F, 0x86AF7F73, 0x86AB7DF4, 0x86A77D9F, 
    0x86A37E76, 0x869F8078, 0x869B83A6, 0x869787FF, 0x86938D84, 0x868F9435, 
    0x868B9C11, 0x8687A519, 0x8683AF4C, 0x867FBAAC, 0x867BC737, 0x8677D4EE, 
    0x8673E3D1, 0x866FF3DF, 0x866C051A, 0x86681781, 0x86642B13, 0x86603FD2, 
    0x865C55BD, 0x86586CD4, 0x86548517, 0x86509E86, 0x864CB922, 0x8648D4EA, 
    0x8644F1DE, 0x86410FFE, 0x863D2F4B, 0x86394FC5, 0x8635716B, 0x8631943D, 
    0x862DB83C, 0x8629DD67, 0x862603BF, 0x86222B44, 0x861E53F6, 0x861A7DD4, 
    0x8616A92D, 0x8612D565, 0x860F02C9, 0x860B315A, 0x86076119, 0x86039204, 
    0x85FFC41C, 0x85FBF762, 0x85F82BD4, 0x85F46173, 0x85F09840, 0x85ECD03A, 
    0x85E90961, 0x85E543B5, 0x85E17F36, 0x85DDBBE5, 0x85D9F9C2, 0x85D638CB, 
    0x85D27902, 0x85CEBA67, 0x85CAFCF8, 0x85C740B8, 0x85C385A5, 0x85BFCBC0, 
    0x85BC1308, 0x85B85B7E, 0x85B4A522, 0x85B0EFF3, 0x85AD3BF2, 0x85A98920, 
    0x85A5D77A, 0x85A22703, 0x859E77BA, 0x859AC99F, 0x85971CB1, 0x859370F2, 
    0x858FC661, 0x858C1CFE, 0x858874C9, 0x8584CDC2, 0x858127EA, 0x857D833F, 
    0x8579DFC3, 0x85763D76, 0x85729C56, 0x856EFC66, 0x856B5DA3, 0x8567C00F, 
    0x856423A9, 0x85608872, 0x855CEE6A, 0x85595590, 0x8555BDE5, 0x85522768, 
    0x854E921A, 0x854AFDFB, 0x85476B0B, 0x8543D949, 0x854048B6, 0x853CB952, 
    0x85392B1D, 0x85359E17, 0x85321240, 0x852E8798, 0x852AFE1F, 0x852775D5, 
    0x8523EEBA, 0x852068CF, 0x851CE412, 0x85196085, 0x8515DE27, 0x85125CF8, 
    0x850EDCF9, 0x850B5E29, 0x8507E088, 0x85046417, 0x8500E8D5, 0x84FD6EC3, 
    0x84F9F5E0, 0x84F67E2C, 0x84F307A9, 0x84EF9255, 0x84EC1E30, 0x84E8AB3C, 
    0x84E53976, 0x84E1C8E1, 0x84DE597C, 0x84DAEB46, 0x84D77E40, 0x84D4126A, 
    0x84D0A7C4, 0x84CD3E4E, 0x84C9D608, 0x84C66EF2, 0x84C3090C, 0x84BFA456, 
    0x84BC40D0, 0x84B8DE7A, 0x84B57D55, 0x84B21D60, 0x84AEBE9A, 0x84AB6106, 
    0x84A804A1, 0x84A4A96D, 0x84A14F69, 0x849DF696, 0x849A9EF3, 0x84974880, 
    0x8493F33E, 0x84909F2D, 0x848D4C90, 0x8489FADF, 0x8486AA60, 0x84835B11, 
    0x84800CF2, 0x847CC005, 0x84797448, 0x847629BC, 0x8472E060, 0x846F9836, 
    0x846C513C, 0x84690B74, 0x8465C6DC, 0x84628375, 0x845F4140, 0x845C003B, 
    0x8458C067, 0x845581C5, 0x84524453, 0x844F0813, 0x844BCD04, 0x84489327, 
    0x84455A7A, 0x844222FF, 0x843EECB5, 0x843BB79C, 0x843883B5, 0x84355100, 
    0x84321F7B, 0x842EEF28, 0x842BC007, 0x84289217, 0x84256559, 0x842239CD, 
    0x841F0F72, 0x841BE648, 0x8418BE51, 0x8415978B, 0x841271F7, 0x840F4D94, 
    0x840C2A64, 0x84090865, 0x8405E798, 0x8402C7FD, 0x83FFA994, 0x83FC8C5D, 
    0x83F97058, 0x83F65585, 0x83F33BE4, 0x83F02375, 0x83ED0C38, 0x83E9F62E, 
    0x83E6E155, 0x83E3CDAF, 0x83E0BB3B, 0x83DDA9F9, 0x83DA99EA, 0x83D78B0D, 
    0x83D47D62, 0x83D170E9, 0x83CE65A3, 0x83CB5B90, 0x83C852AF, 0x83C54B00, 
    0x83C24484, 0x83BF3F3A, 0x83BC3B23, 0x83B9383F, 0x83B6368D, 0x83B3360E, 
    0x83B036C2, 0x83AD38A8, 0x83AA3BC2, 0x83A7400E, 0x83A4458C, 0x83A14C3E, 
    0x839E5422, 0x839B5D3A, 0x83986784, 0x83957301, 0x83927FB2, 0x838F8D95, 
    0x838C9CAB, 0x8389ACF4, 0x8386BE71, 0x8383D121, 0x8380E503, 0x837DFA19, 
    0x837B1062, 0x837827DF, 0x8375408E, 0x83725A71, 0x836F7588, 0x836C91D1, 
    0x8369AF4E, 0x8366CDFF, 0x8363EDE3, 0x83610EFA, 0x835E3145, 0x835B54C3, 
    0x83587975, 0x83559F5A, 0x8352C674, 0x834FEEC0, 0x834D1841, 0x834A42F5, 
    0x83476EDC, 0x83449BF8, 0x8341CA47, 0x833EF9CA, 0x833C2ABA, 0x83395CA5, 
    0x83368FC3, 0x8333C416, 0x8330F99C, 0x832E3056, 0x832B6844, 0x8328A167, 
    0x8325DBBD, 0x83231747, 0x83205406, 0x831D91F8, 0x831AD11F, 0x8318117A, 
    0x83155309, 0x831295CC, 0x830FD9C4, 0x830D1EF0, 0x830A6550, 0x8307ACE4, 
    0x8304F5AD, 0x83023FAA, 0x82FF8ADC, 0x82FCD742, 0x82FA24DC, 0x82F773AB, 
    0x82F4C3AF, 0x82F214E7, 0x82EF6753, 0x82ECBAF4, 0x82EA0FCA, 0x82E765D4, 
    0x82E4BD13, 0x82E21587, 0x82DF6F30, 0x82DCCA0D, 0x82DA261F, 0x82D78365, 
    0x82D4E1E1, 0x82D24191, 0x82CFA277, 0x82CD0491, 0x82CA67E0, 0x82C7CC64, 
    0x82C5321D, 0x82C2990B, 0x82C0012E, 0x82BD6A86, 0x82BAD513, 0x82B840D5, 
    0x82B5ADCD, 0x82B31BF9, 0x82B08B5B, 0x82ADFBF2, 0x82AB6DBE, 0x82A8E0BF, 
    0x82A654F6, 0x82A3CA62, 0x82A14103, 0x829EB8D9, 0x829C31E5, 0x8299AC26, 
    0x8297279D, 0x8294A449, 0x8292222B, 0x828FA142, 0x828D218E, 0x828AA311, 
    0x828825C8, 0x8285A9B6, 0x82832ED8, 0x8280B531, 0x827E3CBF, 0x827BC583, 
    0x82794F7C, 0x8276DAAC, 0x82746711, 0x8271F4AB, 0x826F837C, 0x826D1382, 
    0x826AA4BF, 0x82683731, 0x8265CAD9, 0x82635FB6, 0x8260F5CA, 0x825E8D14, 
    0x825C2594, 0x8259BF4A, 0x82575A35, 0x8254F657, 0x825293AF, 0x8250323D, 
    0x824DD201, 0x824B72FC, 0x8249152C, 0x8246B893, 0x82445D30, 0x82420303, 
    0x823FAA0C, 0x823D524C, 0x823AFBC2, 0x8238A66E, 0x82365251, 0x8233FF6A, 
    0x8231ADB9, 0x822F5D3F, 0x822D0DFB, 0x822ABFEE, 0x82287317, 0x822627A5, 
    0x8223DD3C, 0x82219408, 0x821F4C0B, 0x821D0545, 0x821ABFB6, 0x82187B5D, 
    0x8216383B, 0x8213F64F, 0x8211B59A, 0x820F761C, 0x820D37D5, 0x820AFAC4, 
    0x8208BEEA, 0x82068447, 0x82044ADB, 0x820212A5, 0x81FFDBA7, 0x81FDA5DF, 
    0x81FB714F, 0x81F93DF5, 0x81F70BD2, 0x81F4DAE6, 0x81F2AB32, 0x81F07CB4, 
    0x81EE4F6D, 0x81EC235D, 0x81E9F885, 0x81E7CEE3, 0x81E5A679, 0x81E37F46, 
    0x81E1594A, 0x81DF3485, 0x81DD10F7, 0x81DAEEA1, 0x81D8CD82, 0x81D6AD9A, 
    0x81D48EE9, 0x81D27170, 0x81D0552E, 0x81CE3A24, 0x81CC2050, 0x81CA07B5, 
    0x81C7F050, 0x81C5DA23, 0x81C3C52E, 0x81C1B170, 0x81BF9EE9, 0x81BD8D9A, 
    0x81BB7D83, 0x81B96EA3, 0x81B760FA, 0x81B5548A, 0x81B34950, 0x81B13F4F, 
    0x81AF3685, 0x81AD2EF3, 0x81AB2898, 0x81A92376, 0x81A71F8A, 0x81A51CD7, 
    0x81A31B5C, 0x81A11B18, 0x819F1C0C, 0x819D1E38, 0x819B219C, 0x81992637, 
    0x81972C0B, 0x81953316, 0x81933B59, 0x819144D5, 0x818F4F88, 0x818D5B73, 
    0x818B6896, 0x818976F2, 0x81878685, 0x81859750, 0x8183A954, 0x8181BC8F, 
    0x817FD103, 0x817DE6AE, 0x817BFD92, 0x817A15AE, 0x81782F02, 0x8176498F, 
    0x81746554, 0x81728250, 0x8170A086, 0x816EBFF3, 0x816CE099, 0x816B0277, 
    0x8169258D, 0x816749DC, 0x81656F63, 0x81639622, 0x8161BE1A, 0x815FE74A, 
    0x815E11B3, 0x815C3D54, 0x815A6A2E, 0x81589840, 0x8156C78B, 0x8154F80E, 
    0x815329CA, 0x81515CBE, 0x814F90EB, 0x814DC650, 0x814BFCEE, 0x814A34C5, 
    0x81486DD4, 0x8146A840, 0x8144E3C1, 0x8143207A, 0x81415E6C, 0x813F9D97, 
    0x813DDDFA, 0x813C1F97, 0x813A626C, 0x8138A679, 0x8136EBC0, 0x81353240, 
    0x813379F8, 0x8131C2E9, 0x81300D13, 0x812E5876, 0x812CA512, 0x812AF2E7, 
    0x812941F5, 0x8127923B, 0x8125E3BB, 0x81243674, 0x81228A65, 0x8120DF90, 
    0x811F35F4, 0x811D8D91, 0x811BE667, 0x811A4076, 0x81189BBE, 0x8116F83F, 
    0x811555F9, 0x8113B4ED, 0x8112151A, 0x81107680, 0x810ED91F, 0x810D3CF7, 
    0x810BA209, 0x810A0853, 0x81086FD7, 0x8106D895, 0x8105428B, 0x8103ADBB, 
    0x81021A25, 0x810087C7, 0x80FEF6A3, 0x80FD66B9, 0x80FBD807, 0x80FA4A90, 
    0x80F8BE51, 0x80F7334C, 0x80F5A981, 0x80F420EE, 0x80F29996, 0x80F11377, 
    0x80EF8E91, 0x80EE0AE5, 0x80EC8872, 0x80EB0739, 0x80E9873A, 0x80E80874, 
    0x80E68AE8, 0x80E50E95, 0x80E3937C, 0x80E2199D, 0x80E0A0F7, 0x80DF298B, 
    0x80DDB358, 0x80DC3E5F, 0x80DACAA0, 0x80D9581B, 0x80D7E6D0, 0x80D676BE, 
    0x80D507E6, 0x80D39A47, 0x80D22DE3, 0x80D0C2B8, 0x80CF58C7, 0x80CDF010, 
    0x80CC8893, 0x80CB2250, 0x80C9BD46, 0x80C85977, 0x80C6F6E1, 0x80C59585, 
    0x80C43563, 0x80C2D67B, 0x80C178CD, 0x80C01C59, 0x80BEC11F, 0x80BD671F, 
    0x80BC0E59, 0x80BAB6CD, 0x80B9607B, 0x80B80B63, 0x80B6B785, 0x80B564E2, 
    0x80B41378, 0x80B2C348, 0x80B17453, 0x80B02697, 0x80AEDA16, 0x80AD8ECF, 
    0x80AC44C2, 0x80AAFBEF, 0x80A9B456, 0x80A86DF8, 0x80A728D4, 0x80A5E4EA, 
    0x80A4A23A, 0x80A360C4, 0x80A22089, 0x80A0E1A1, 0x809FA3DA, 0x809E674E, 
    0x809D2BFC, 0x809BF1E4, 0x809AB906, 0x80998163, 0x80984AFA, 0x809715CB, 
    0x8095E1D7, 0x8094AF1D, 0x80937D9E, 0x80924D59, 0x80911E4E, 0x808FF07E, 
    0x808EC3E8, 0x808D988D, 0x808C6E6C, 0x808B4586, 0x808A1DDA, 0x8088F769, 
    0x8087D232, 0x8086AE36, 0x80858B74, 0x808469ED, 0x808349A0, 0x80822A8E, 
    0x80810CB6, 0x807FF019, 0x807ED4B7, 0x807DBA8F, 0x807CA1A2, 0x807B89F0, 
    0x807A7378, 0x80795E3B, 0x80784A38, 0x80773770, 0x807625E3, 0x80751590, 
    0x80740679, 0x8072F89B, 0x8071EBF9, 0x8070E091, 0x806FD664, 0x806ECD72, 
    0x806DC5BB, 0x806CBF3E, 0x806BB9FC, 0x806AB5F5, 0x8069B329, 0x8068B198, 
    0x8067B141, 0x8066B225, 0x8065B444, 0x8064B79E, 0x8063BC33, 0x8062C202, 
    0x8061C90D, 0x8060D152, 0x805FDAD3, 0x805EE58E, 0x805DF184, 0x805CFEB5, 
    0x805C0D21, 0x805B1CC8, 0x805A2DA9, 0x80593FC6, 0x8058531E, 0x805767B1, 
    0x80567D7F, 0x80559487, 0x8054ACCB, 0x8053C64A, 0x8052E104, 0x8051FCF8, 
    0x80511A28, 0x80503893, 0x804F5839, 0x804E791A, 0x804D9B36, 0x804CBE8D, 
    0x804BE31F, 0x804B08ED, 0x804A2FF5, 0x80495839, 0x804881B8, 0x8047AC71, 
    0x8046D866, 0x80460596, 0x80453402, 0x804463A8, 0x8043948A, 0x8042C6A6, 
    0x8041F9FE, 0x80412E92, 0x80406460, 0x803F9B69, 0x803ED3AE, 0x803E0D2E, 
    0x803D47E9, 0x803C83E0, 0x803BC112, 0x803AFF7F, 0x803A3F27, 0x8039800A, 
    0x8038C229, 0x80380583, 0x80374A18, 0x80368FE9, 0x8035D704, 0x80351F4B, 
    0x803468CD, 0x8033B38B, 0x8032FF84, 0x80324CB9, 0x80319B28, 0x8030EAD4, 
    0x80303BBA, 0x802F8DDC, 0x802EE139, 0x802E35D2, 0x802D8BA6, 0x802CE2B5, 
    0x802C3B00, 0x802B9486, 0x802AEF48, 0x802A4B45, 0x8029A87D, 0x802906F1, 
    0x802866A0, 0x8027C78B, 0x802729B1, 0x80268D13, 0x8025F1B0, 0x80255789, 
    0x8024BE9D, 0x802426EC, 0x80239077, 0x8022FB3E, 0x80226740, 0x8021D47D, 
    0x802142F6, 0x8020B2AB, 0x8020239B, 0x801F95C6, 0x801F092D, 0x801E7DD0, 
    0x801DF3AE, 0x801D6AC7, 0x801CE31D, 0x801C5CAD, 0x801BD77A, 0x801B5381, 
    0x801AD0C5, 0x801A4F44, 0x8019CEFE, 0x80194FF5, 0x8018D226, 0x80185594, 
    0x8017DA3D, 0x80176021, 0x8016E741, 0x80166F9D, 0x8015F934, 0x80158407, 
    0x80151016, 0x80149D60, 0x80142BE6, 0x8013BBA7, 0x80134CA4, 0x8012DEDD, 
    0x80127252, 0x80120702, 0x80119CED, 0x80113415, 0x8010CC78, 0x80106616, 
    0x801000F1, 0x800F9D07, 0x800F3A58, 0x800ED8E6, 0x800E78AF, 0x800E19B4, 
    0x800DBBF4, 0x800D5F70, 0x800D0428, 0x800CAA1C, 0x800C514B, 0x800BF9B6, 
    0x800BA35D, 0x800B4E3F, 0x800AFA5D, 0x800AA7B7, 0x800A564D, 0x800A061E, 
    0x8009B72B, 0x80096974, 0x80091CF8, 0x8008D1B9, 0x800887B5, 0x80083EEC, 
    0x8007F760, 0x8007B10F, 0x80076BFA, 0x80072821, 0x8006E584, 0x8006A422, 
    0x800663FC, 0x80062512, 0x8005E763, 0x8005AAF1, 0x80056FBA, 0x800535BF, 
    0x8004FCFF, 0x8004C57C, 0x80048F34, 0x80045A28, 0x80042658, 0x8003F3C4, 
    0x8003C26F, 0x80039252, 0x80036371, 0x800335CC, 0x80030962, 0x8002DE35, 
    0x8002B443, 0x80028B8D, 0x80026412, 0x80023DD4, 0x800218D1, 0x8001F50A, 
    0x8001D27F, 0x8001B130, 0x8001911C, 0x80017245, 0x800154A9, 0x80013849, 
    0x80011D25, 0x8001033D, 0x8000EA90, 0x8000D31F, 0x8000BCEA, 0x8000A7F1, 
    0x80009434, 0x800081B3, 0x8000706D, 0x80006063, 0x80005195, 0x80004403, 
    0x800037AD, 0x80002C92, 0x800022B4, 0x80001A11, 0x800012AA, 0x80000C7F, 
    0x8000078F, 0x800003DC, 0x80000164, 0x80000028
};

const int32_t sine_2048[] ICONST_ATTR_WMAPRO_WIN_VS_TMP = {
    0xFFF36F03, 0xFFDA4D09, 0xFFC12B0F, 0xFFA80918, 0xFF8EE725, 0xFF75C536, 
    0xFF5CA34B, 0xFF438168, 0xFF2A5F8C, 0xFF113DB7, 0xFEF81BEE, 0xFEDEFA2D, 
    0xFEC5D876, 0xFEACB6CE, 0xFE939531, 0xFE7A73A2, 0xFE615224, 0xFE4830B4, 
    0xFE2F0F55, 0xFE15EE0A, 0xFDFCCCD0, 0xFDE3ABAA, 0xFDCA8A98, 0xFDB1699D, 
    0xFD9848BC, 0xFD7F27EF, 0xFD66073A, 0xFD4CE69F, 0xFD33C61F, 0xFD1AA5BB, 
    0xFD018577, 0xFCE8654C, 0xFCCF4541, 0xFCB62554, 0xFC9D0588, 0xFC83E5DE, 
    0xFC6AC65A, 0xFC51A6F5, 0xFC3887B4, 0xFC1F6899, 0xFC0649A4, 0xFBED2AD7, 
    0xFBD40C35, 0xFBBAEDB5, 0xFBA1CF67, 0xFB88B144, 0xFB6F9345, 0xFB56757B, 
    0xFB3D57D7, 0xFB243A6A, 0xFB0B1D25, 0xFAF20019, 0xFAD8E33F, 0xFABFC690, 
    0xFAA6AA1D, 0xFA8D8DD6, 0xFA7471CD, 0xFA5B55FB, 0xFA423A59, 0xFA291EF7, 
    0xFA1003C7, 0xF9F6E8D9, 0xF9DDCE1F, 0xF9C4B3AA, 0xF9AB9972, 0xF9927F70, 
    0xF97965B6, 0xF9604C34, 0xF94732FC, 0xF92E1A06, 0xF915014C, 0xF8FBE8DD, 
    0xF8E2D0AC, 0xF8C9B8C9, 0xF8B0A126, 0xF89789D2, 0xF87E72C8, 0xF8655BFF, 
    0xF84C458A, 0xF8332F59, 0xF81A197C, 0xF80103EE, 0xF7E7EEA7, 0xF7CED9AF, 
    0xF7B5C518, 0xF79CB0C3, 0xF7839CC1, 0xF76A8923, 0xF75175C9, 0xF73862C5, 
    0xF71F5018, 0xF7063DD2, 0xF6ED2BD5, 0xF6D41A32, 0xF6BB08F9, 0xF6A1F80B, 
    0xF688E77A, 0xF66FD747, 0xF656C781, 0xF63DB80B, 0xF624A8F6, 0xF60B9A51, 
    0xF5F28BFF, 0xF5D97E11, 0xF5C07096, 0xF5A76370, 0xF58E56B1, 0xF5754A59, 
    0xF55C3E78, 0xF54332F1, 0xF52A27D4, 0xF5111D31, 0xF4F812EB, 0xF4DF0911, 
    0xF4C5FFA6, 0xF4ACF6B9, 0xF493EE2B, 0xF47AE60F, 0xF461DE74, 0xF448D73C, 
    0xF42FD078, 0xF416CA28, 0xF3FDC45D, 0xF3E4BEFA, 0xF3CBBA0D, 0xF3B2B5A9, 
    0xF399B1AF, 0xF380AE2F, 0xF367AB3A, 0xF34EA8B2, 0xF335A6A7, 0xF31CA51A, 
    0xF303A41C, 0xF2EAA38E, 0xF2D1A382, 0xF2B8A408, 0xF29FA500, 0xF286A67D, 
    0xF26DA87F, 0xF254AB17, 0xF23BAE25, 0xF222B1BC, 0xF209B5EB, 0xF1F0BA94, 
    0xF1D7BFC8, 0xF1BEC588, 0xF1A5CBE4, 0xF18CD2BE, 0xF173DA26, 0xF15AE22E, 
    0xF141EAB7, 0xF128F3D1, 0xF10FFD8E, 0xF0F707CE, 0xF0DE12A2, 0xF0C51E0C, 
    0xF0AC2A1C, 0xF09336B4, 0xF07A43E3, 0xF06151BC, 0xF048601F, 0xF02F6F1D, 
    0xF0167EB8, 0xEFFD8EFF, 0xEFE49FD4, 0xEFCBB148, 0xEFB2C35C, 0xEF99D612, 
    0xEF80E988, 0xEF67FD82, 0xEF4F121F, 0xEF362762, 0xEF1D3D4A, 0xEF0453D8, 
    0xEEEB6B0F, 0xEED2830D, 0xEEB99B95, 0xEEA0B4C8, 0xEE87CEA7, 0xEE6EE931, 
    0xEE560469, 0xEE3D2050, 0xEE243D05, 0xEE0B5A4B, 0xEDF27842, 0xEDD996EC, 
    0xEDC0B648, 0xEDA7D659, 0xED8EF73E, 0xED7618BA, 0xED5D3AED, 0xED445DD7, 
    0xED2B817B, 0xED12A5D8, 0xECF9CAF0, 0xECE0F0E3, 0xECC81774, 0xECAF3EC2, 
    0xEC9666CF, 0xEC7D8F9C, 0xEC64B929, 0xEC4BE377, 0xEC330EA8, 0xEC1A3A7C, 
    0xEC016715, 0xEBE89473, 0xEBCFC298, 0xEBB6F184, 0xEB9E2138, 0xEB8551D4, 
    0xEB6C831B, 0xEB53B52E, 0xEB3AE80C, 0xEB221BB7, 0xEB095031, 0xEAF08579, 
    0xEAD7BBB0, 0xEABEF299, 0xEAA62A54, 0xEA8D62E1, 0xEA749C42, 0xEA5BD678, 
    0xEA431183, 0xEA2A4D84, 0xEA118A3E, 0xE9F8C7CF, 0xE9E0063B, 0xE9C74580, 
    0xE9AE85A1, 0xE995C69E, 0xE97D0898, 0xE9644B50, 0xE94B8EE8, 0xE932D360, 
    0xE91A18B9, 0xE9015EF3, 0xE8E8A631, 0xE8CFEE32, 0xE8B73719, 0xE89E80E5, 
    0xE885CB98, 0xE86D1733, 0xE85463B6, 0xE83BB143, 0xE822FF9A, 0xE80A4EDE, 
    0xE7F19F0D, 0xE7D8F02A, 0xE7C04236, 0xE7A79530, 0xE78EE93B, 0xE7763E17, 
    0xE75D93E6, 0xE744EAA7, 0xE72C425D, 0xE7139B08, 0xE6FAF4A8, 0xE6E24F5F, 
    0xE6C9AAEF, 0xE6B10777, 0xE69864F9, 0xE67FC376, 0xE66722EF, 0xE64E8364, 
    0xE635E4F6, 0xE61D4767, 0xE604AAD8, 0xE5EC0F49, 0xE5D374BC, 0xE5BADB31, 
    0xE5A242A9, 0xE589AB45, 0xE57114C6, 0xE5587F4E, 0xE53FEADD, 0xE5275773, 
    0xE50EC513, 0xE4F633DC, 0xE4DDA391, 0xE4C51451, 0xE4AC861E, 0xE493F8F9, 
    0xE47B6CE2, 0xE462E1DB, 0xE44A5804, 0xE431CF1F, 0xE419474D, 0xE400C08D, 
    0xE3E83AE3, 0xE3CFB64D, 0xE3B732CE, 0xE39EB085, 0xE3862F34, 0xE36DAEFD, 
    0xE3552FE0, 0xE33CB1DE, 0xE32434F8, 0xE30BB92F, 0xE2F33EA2, 0xE2DAC515, 
    0xE2C24CA8, 0xE2A9D55B, 0xE2915F30, 0xE278EA27, 0xE2607642, 0xE24803A0, 
    0xE22F9205, 0xE217218F, 0xE1FEB241, 0xE1E6441B, 0xE1CDD71E, 0xE1B56B4C, 
    0xE19D00C3, 0xE1849747, 0xE16C2EF8, 0xE153C7D6, 0xE13B61E4, 0xE122FD21, 
    0xE10A998E, 0xE0F2374C, 0xE0D9D61E, 0xE0C17623, 0xE0A9175D, 0xE090B9CC, 
    0xE0785D71, 0xE060026C, 0xE047A880, 0xE02F4FCE, 0xE016F855, 0xDFFEA217, 
    0xDFE64D16, 0xDFCDF951, 0xDFB5A6C9, 0xDF9D5581, 0xDF850578, 0xDF6CB6B0, 
    0xDF546967, 0xDF3C1D23, 0xDF23D222, 0xDF0B8865, 0xDEF33FEE, 0xDEDAF8BD, 
    0xDEC2B2D2, 0xDEAA6E30, 0xDE922AD7, 0xDE79E8C8, 0xDE61A804, 0xDE49688C, 
    0xDE312A60, 0xDE18EDC0, 0xDE00B230, 0xDDE877F1, 0xDDD03F01, 0xDDB80763, 
    0xDD9FD118, 0xDD879C1F, 0xDD6F687B, 0xDD57362C, 0xDD3F0533, 0xDD26D591, 
    0xDD0EA747, 0xDCF67A56, 0xDCDE4EBF, 0xDCC624C0, 0xDCADFBDF, 0xDC95D45B, 
    0xDC7DAE34, 0xDC65896C, 0xDC4D6603, 0xDC3543FA, 0xDC1D2353, 0xDC05040E, 
    0xDBECE62C, 0xDBD4C9AE, 0xDBBCAE95, 0xDBA494E1, 0xDB8C7C95, 0xDB7465EE, 
    0xDB5C5072, 0xDB443C60, 0xDB2C29B8, 0xDB14187C, 0xDAFC08AC, 0xDAE3FA4A, 
    0xDACBED56, 0xDAB3E1D1, 0xDA9BD7BC, 0xDA83CF18, 0xDA6BC7E6, 0xDA53C227, 
    0xDA3BBDDC, 0xDA23BB42, 0xDA0BB9E1, 0xD9F3B9F7, 0xD9DBBB85, 0xD9C3BE8A, 
    0xD9ABC309, 0xD993C903, 0xD97BD077, 0xD963D968, 0xD94BE3D6, 0xD933EFC2, 
    0xD91BFD2D, 0xD9040C17, 0xD8EC1CC0, 0xD8D42EAD, 0xD8BC421C, 0xD8A4570F, 
    0xD88C6D87, 0xD8748584, 0xD85C9F07, 0xD844BA12, 0xD82CD6A4, 0xD814F4C0, 
    0xD7FD1466, 0xD7E53596, 0xD7CD5853, 0xD7B57C9C, 0xD79DA2AF, 0xD785CA15, 
    0xD76DF309, 0xD7561D8F, 0xD73E49A5, 0xD726774E, 0xD70EA68A, 0xD6F6D75A, 
    0xD6DF09BF, 0xD6C73DBA, 0xD6AF734C, 0xD697AA76, 0xD67FE338, 0xD6681D94, 
    0xD65059C7, 0xD6389759, 0xD620D687, 0xD6091753, 0xD5F159BC, 0xD5D99DC5, 
    0xD5C1E36E, 0xD5AA2AB7, 0xD59273A3, 0xD57ABE31, 0xD5630A63, 0xD54B5839, 
    0xD533A7B5, 0xD51BF914, 0xD5044BDE, 0xD4ECA050, 0xD4D4F66B, 0xD4BD4E30, 
    0xD4A5A7A0, 0xD48E02BC, 0xD4765F85, 0xD45EBDFB, 0xD4471E20, 0xD42F7FF5, 
    0xD417E37A, 0xD40048B0, 0xD3E8AF98, 0xD3D11870, 0xD3B982C0, 0xD3A1EEC5, 
    0xD38A5C80, 0xD372CBF1, 0xD35B3D1A, 0xD343AFFC, 0xD32C2497, 0xD3149AED, 
    0xD2FD12FE, 0xD2E58CCC, 0xD2CE0856, 0xD2B6859F, 0xD29F04A6, 0xD28785AA, 
    0xD2700832, 0xD2588C7C, 0xD2411288, 0xD2299A58, 0xD21223EC, 0xD1FAAF46, 
    0xD1E33C66, 0xD1CBCB4D, 0xD1B45BFC, 0xD19CEE74, 0xD18582B6, 0xD16E18C2, 
    0xD156B0D6, 0xD13F4A7A, 0xD127E5EC, 0xD110832D, 0xD0F9223C, 0xD0E1C31C, 
    0xD0CA65CD, 0xD0B30A50, 0xD09BB0A5, 0xD08458CF, 0xD06D02CD, 0xD055AEA0, 
    0xD03E5C4A, 0xD0270BCB, 0xD00FBD60, 0xCFF87093, 0xCFE1259F, 0xCFC9DC87, 
    0xCFB2954B, 0xCF9B4FEB, 0xCF840C68, 0xCF6CCAC5, 0xCF558B01, 0xCF3E4D1D, 
    0xCF27111A, 0xCF0FD6F9, 0xCEF89EBC, 0xCEE16862, 0xCECA3428, 0xCEB30199, 
    0xCE9BD0F0, 0xCE84A22F, 0xCE6D7556, 0xCE564A66, 0xCE3F2161, 0xCE27FA47, 
    0xCE10D518, 0xCDF9B1D7, 0xCDE29083, 0xCDCB711D, 0xCDB453A8, 0xCD9D3822, 
    0xCD861EC9, 0xCD6F0727, 0xCD57F178, 0xCD40DDBE, 0xCD29CBF8, 0xCD12BC27, 
    0xCCFBAE4E, 0xCCE4A26C, 0xCCCD9882, 0xCCB69091, 0xCC9F8A9B, 0xCC8886A0, 
    0xCC7184A1, 0xCC5A84D9, 0xCC4386D4, 0xCC2C8ACE, 0xCC1590C8, 0xCBFE98C2, 
    0xCBE7A2BD, 0xCBD0AEBA, 0xCBB9BCBB, 0xCBA2CCBF, 0xCB8BDEC8, 0xCB74F2D7, 
    0xCB5E08EC, 0xCB472109, 0xCB303B2E, 0xCB195797, 0xCB0275CF, 0xCAEB9613, 
    0xCAD4B862, 0xCABDDCBF, 0xCAA70328, 0xCA902BA1, 0xCA795628, 0xCA6282C0, 
    0xCA4BB16A, 0xCA34E225, 0xCA1E14F3, 0xCA0749D5, 0xC9F080CC, 0xC9D9BA12, 
    0xC9C2F534, 0xC9AC326E, 0xC99571C0, 0xC97EB32C, 0xC967F6B1, 0xC9513C51, 
    0xC93A840C, 0xC923CDE5, 0xC90D19DA, 0xC8F667EE, 0xC8DFB822, 0xC8C90A75, 
    0xC8B25F23, 0xC89BB5B9, 0xC8850E72, 0xC86E694E, 0xC857C64F, 0xC8412575, 
    0xC82A86C1, 0xC813EA34, 0xC7FD4FD0, 0xC7E6B794, 0xC7D02181, 0xC7B98D9A, 
    0xC7A2FBDD, 0xC78C6C4D, 0xC775DF24, 0xC75F53EF, 0xC748CAE9, 0xC7324413, 
    0xC71BBF6D, 0xC7053CF9, 0xC6EEBCB8, 0xC6D83EA9, 0xC6C1C2CF, 0xC6AB4929, 
    0xC694D1BA, 0xC67E5C81, 0xC667E980, 0xC65178B7, 0xC63B0A60, 0xC6249E0B, 
    0xC60E33F1, 0xC5F7CC12, 0xC5E16670, 0xC5CB030C, 0xC5B4A1E7, 0xC59E4300, 
    0xC587E65A, 0xC5718BF5, 0xC55B33D2, 0xC544DDF2, 0xC52E8A55, 0xC5183936, 
    0xC501EA23, 0xC4EB9D57, 0xC4D552D1, 0xC4BF0A94, 0xC4A8C49F, 0xC49280F4, 
    0xC47C3F94, 0xC466007F, 0xC44FC3B6, 0xC439893A, 0xC423510D, 0xC40D1B2E, 
    0xC3F6E79F, 0xC3E0B698, 0xC3CA87AB, 0xC3B45B10, 0xC39E30C8, 0xC38808D4, 
    0xC371E335, 0xC35BBFEB, 0xC3459EF8, 0xC32F805C, 0xC3196419, 0xC3034A2E, 
    0xC2ED329E, 0xC2D71D68, 0xC2C10A8E, 0xC2AAFA48, 0xC294EC28, 0xC27EE066, 
    0xC268D703, 0xC252CFFF, 0xC23CCB5D, 0xC226C91C, 0xC210C93D, 0xC1FACBC2, 
    0xC1E4D0AB, 0xC1CED7F9, 0xC1B8E1AD, 0xC1A2EDC7, 0xC18CFC49, 0xC1770D33, 
    0xC1612086, 0xC14B3644, 0xC1354E6C, 0xC11F6900, 0xC1098601, 0xC0F3A5DE, 
    0xC0DDC7BA, 0xC0C7EC06, 0xC0B212C1, 0xC09C3BED, 0xC086678B, 0xC070959B, 
    0xC05AC61F, 0xC044F916, 0xC02F2E83, 0xC0196665, 0xC003A0BF, 0xBFEDDD8F, 
    0xBFD81CD8, 0xBFC25E9B, 0xBFACA2D7, 0xBF96E98E, 0xBF8132C1, 0xBF6B7E71, 
    0xBF55CC9D, 0xBF401D48, 0xBF2A7072, 0xBF14C61C, 0xBEFF1E47, 0xBEE978F3, 
    0xBED3D622, 0xBEBE35D4, 0xBEA8980A, 0xBE92FD33, 0xBE7D6473, 0xBE67CE3B, 
    0xBE523A89, 0xBE3CA960, 0xBE271AC0, 0xBE118EA9, 0xBDFC051E, 0xBDE67E1E, 
    0xBDD0F9AA, 0xBDBB77C4, 0xBDA5F86B, 0xBD907BA2, 0xBD7B0168, 0xBD6589BE, 
    0xBD5014A6, 0xBD3AA221, 0xBD25322E, 0xBD0FC4CF, 0xBCFA5A05, 0xBCE4F1D0, 
    0xBCCF8C31, 0xBCBA292A, 0xBCA4C8BB, 0xBC8F6AE4, 0xBC7A0FA7, 0xBC64B704, 
    0xBC4F616A, 0xBC3A0DFE, 0xBC24BD30, 0xBC0F6EFF, 0xBBFA236D, 0xBBE4DA7A, 
    0xBBCF9428, 0xBBBA5076, 0xBBA50F66, 0xBB8FD0F9, 0xBB7A9530, 0xBB655C0A, 
    0xBB50258A, 0xBB3AF1B0, 0xBB25C07C, 0xBB1091F0, 0xBAFB660C, 0xBAE63CD2, 
    0xBAD11641, 0xBABBF25B, 0xBAA6D121, 0xBA91B294, 0xBA7C96B3, 0xBA677D81, 
    0xBA5266FE, 0xBA3D532A, 0xBA284207, 0xBA133395, 0xB9FE2840, 0xB9E91F33, 
    0xB9D418DA, 0xB9BF1536, 0xB9AA1447, 0xB995160E, 0xB9801A8C, 0xB96B21C2, 
    0xB9562BB0, 0xB9413858, 0xB92C47BA, 0xB91759D7, 0xB9026EB0, 0xB8ED8646, 
    0xB8D8A099, 0xB8C3BDAA, 0xB8AEDD7B, 0xB89A000B, 0xB885255C, 0xB8704D6F, 
    0xB85B7843, 0xB846A5DB, 0xB831D637, 0xB81D0957, 0xB8083F3D, 0xB7F377E9, 
    0xB7DEB35D, 0xB7C9F202, 0xB7B53306, 0xB7A076D3, 0xB78BBD6B, 0xB77706CD, 
    0xB76252FC, 0xB74DA1F7, 0xB738F3C0, 0xB7244857, 0xB70F9FBE, 0xB6FAF9F4, 
    0xB6E656FB, 0xB6D1B6D3, 0xB6BD197D, 0xB6A87EFB, 0xB693E74C, 0xB67F5273, 
    0xB66AC06E, 0xB6563140, 0xB641A4E9, 0xB62D1B69, 0xB61894C3, 0xB60410F5, 
    0xB5EF9002, 0xB5DB11EA, 0xB5C696AE, 0xB5B21E4E, 0xB59DA934, 0xB589368F, 
    0xB574C6CA, 0xB56059E4, 0xB54BEFDF, 0xB53788BB, 0xB5232479, 0xB50EC31A, 
    0xB4FA649F, 0xB4E60908, 0xB4D1B057, 0xB4BD5A8B, 0xB4A907A6, 0xB494B7A9, 
    0xB4806A94, 0xB46C2068, 0xB457D927, 0xB44394D0, 0xB42F5364, 0xB41B14E5, 
    0xB406D952, 0xB3F2A0AE, 0xB3DE6AF8, 0xB3CA3832, 0xB3B6085B, 0xB3A1DB76, 
    0xB38DB182, 0xB3798A81, 0xB36566DA, 0xB35145C0, 0xB33D279B, 0xB3290C6C, 
    0xB314F433, 0xB300DEF1, 0xB2ECCCA7, 0xB2D8BD56, 0xB2C4B0FE, 0xB2B0A7A0, 
    0xB29CA13E, 0xB2889DD7, 0xB2749D6D, 0xB260A000, 0xB24CA592, 0xB238AE22, 
    0xB224B9B2, 0xB210C842, 0xB1FCD9D3, 0xB1E8EE67, 0xB1D505FD, 0xB1C12097, 
    0xB1AD3E35, 0xB1995ED7, 0xB1858280, 0xB171A92F, 0xB15DD2E6, 0xB14A000A, 
    0xB1362FD1, 0xB12262A2, 0xB10E987D, 0xB0FAD164, 0xB0E70D57, 0xB0D34C56, 
    0xB0BF8E62, 0xB0ABD37D, 0xB0981BA7, 0xB08466E0, 0xB070B52A, 0xB05D0685, 
    0xB0495AF2, 0xB035B272, 0xB0220D05, 0xB00E6AAD, 0xAFFACB6A, 0xAFE72F3C, 
    0xAFD39625, 0xAFC00025, 0xAFAC6D3E, 0xAF98DD6F, 0xAF8550B9, 0xAF71C71E, 
    0xAF5E409E, 0xAF4ABD3A, 0xAF373CF2, 0xAF23C02B, 0xAF10461F, 0xAEFCCF31, 
    0xAEE95B63, 0xAED5EAB5, 0xAEC27D29, 0xAEAF12BE, 0xAE9BAB76, 0xAE884751, 
    0xAE74E650, 0xAE618874, 0xAE4E2DBE, 0xAE3AD62D, 0xAE2781C4, 0xAE143083, 
    0xAE00E26A, 0xADED977A, 0xADDA4FB5, 0xADC70B1A, 0xADB3C9AB, 0xADA08B68, 
    0xAD8D5052, 0xAD7A186A, 0xAD66E3B0, 0xAD53B225, 0xAD4083CB, 0xAD2D58A1, 
    0xAD1A310A, 0xAD070C43, 0xACF3EAB0, 0xACE0CC50, 0xACCDB124, 0xACBA992E, 
    0xACA7846E, 0xAC9472E4, 0xAC816491, 0xAC6E5977, 0xAC5B5195, 0xAC484CED, 
    0xAC354B7F, 0xAC224D4C, 0xAC0F5255, 0xABFC5A9A, 0xABE9661D, 0xABD674DD, 
    0xABC386DC, 0xABB09C1A, 0xAB9DB499, 0xAB8AD058, 0xAB77EF59, 0xAB65119D, 
    0xAB523723, 0xAB3F5FED, 0xAB2C8BFB, 0xAB19BBAF, 0xAB06EE48, 0xAAF42429, 
    0xAAE15D50, 0xAACE99C0, 0xAABBD979, 0xAAA91C7B, 0xAA9662C7, 0xAA83AC5E, 
    0xAA70F941, 0xAA5E4971, 0xAA4B9CEE, 0xAA38F3B8, 0xAA264DD1, 0xAA13AB3A, 
    0xAA010BF2, 0xA9EE6FFB, 0xA9DBD756, 0xA9C94203, 0xA9B6B003, 0xA9A42156, 
    0xA99195FE, 0xA97F0DFB, 0xA96C894D, 0xA95A07F6, 0xA94789F6, 0xA9350F4E, 
    0xA92297FF, 0xA9102467, 0xA8FDB3CB, 0xA8EB468A, 0xA8D8DCA4, 0xA8C6761A, 
    0xA8B412EE, 0xA8A1B31F, 0xA88F56AE, 0xA87CFD9C, 0xA86AA7EA, 0xA8585598, 
    0xA84606A8, 0xA833BB19, 0xA82172ED, 0xA80F2E24, 0xA7FCECBF, 0xA7EAAEBE, 
    0xA7D87423, 0xA7C63CEE, 0xA7B40920, 0xA7A1D8B9, 0xA78FABBB, 0xA77D8225, 
    0xA76B5BF9, 0xA7593937, 0xA74719E0, 0xA734FDF4, 0xA722E5D2, 0xA710D0C0, 
    0xA6FEBF1B, 0xA6ECB0E6, 0xA6DAA61F, 0xA6C89EC8, 0xA6B69AE2, 0xA6A49A6D, 
    0xA6929D6A, 0xA680A3D9, 0xA66EADBC, 0xA65CBB13, 0xA64ACBDF, 0xA638E020, 
    0xA626F7D7, 0xA6151304, 0xA60331AA, 0xA5F153C7, 0xA5DF795D, 0xA5CDA26D, 
    0xA5BBCEF7, 0xA5A9FEFC, 0xA598327C, 0xA5866979, 0xA574A3F2, 0xA562E1EA, 
    0xA551235F, 0xA53F6854, 0xA52DB122, 0xA51BFD17, 0xA50A4C8D, 0xA4F89F84, 
    0xA4E6F5FE, 0xA4D54FFB, 0xA4C3AD7C, 0xA4B20E81, 0xA4A0730B, 0xA48EDB1B, 
    0xA47D46B2, 0xA46BB5D0, 0xA45A2876, 0xA4489EA4, 0xA437185B, 0xA425959D, 
    0xA4141669, 0xA4029AC0, 0xA3F122A3, 0xA3DFAE12, 0xA3CE3D0F, 0xA3BCCF9A, 
    0xA3AB65B3, 0xA399FF5C, 0xA3889C95, 0xA3773D5E, 0xA365E1B8, 0xA35489FD, 
    0xA343357C, 0xA331E48F, 0xA3209735, 0xA30F4D70, 0xA2FE0740, 0xA2ECC4A6, 
    0xA2DB85A3, 0xA2CA4A37, 0xA2B91263, 0xA2A7DE27, 0xA296AD85, 0xA285807D, 
    0xA274570F, 0xA263313D, 0xA2520F06, 0xA240F06D, 0xA22FD570, 0xA21EBE11, 
    0xA20DAA51, 0xA1FC9A30, 0xA1EB8DAF, 0xA1DA84CF, 0xA1C97F90, 0xA1B87DF2, 
    0xA1A77FF7, 0xA196859F, 0xA1858F42, 0xA1749C32, 0xA163ACC8, 0xA152C103, 
    0xA141D8E5, 0xA130F46E, 0xA120139E, 0xA10F3677, 0xA0FE5CF9, 0xA0ED8725, 
    0xA0DCB4FB, 0xA0CBE67C, 0xA0BB1BA8, 0xA0AA5481, 0xA0999107, 0xA088D13A, 
    0xA078151C, 0xA0675CAC, 0xA056A7EC, 0xA045F6DC, 0xA035497D, 0xA0249FD0, 
    0xA013F9D4, 0xA003578B, 0x9FF2B8F5, 0x9FE21E14, 0x9FD186E7, 0x9FC0F36F, 
    0x9FB06402, 0x9F9FD7F7, 0x9F8F4FA3, 0x9F7ECB06, 0x9F6E4A23, 0x9F5DCCF8, 
    0x9F4D5387, 0x9F3CDDD1, 0x9F2C6BD5, 0x9F1BFD95, 0x9F0B9312, 0x9EFB2C4B, 
    0x9EEAC942, 0x9EDA69F7, 0x9ECA0E6B, 0x9EB9B69E, 0x9EA96291, 0x9E991245, 
    0x9E88C5BB, 0x9E787CF2, 0x9E6837EC, 0x9E57F6A9, 0x9E47B92A, 0x9E377F70, 
    0x9E27497A, 0x9E17174A, 0x9E06E8E1, 0x9DF6BE91, 0x9DE697B6, 0x9DD674A3, 
    0x9DC65559, 0x9DB639D8, 0x9DA62222, 0x9D960E36, 0x9D85FE16, 0x9D75F1C1, 
    0x9D65E939, 0x9D55E47F, 0x9D45E392, 0x9D35E673, 0x9D25ED23, 0x9D15F7A4, 
    0x9D0605F4, 0x9CF61815, 0x9CE62E08, 0x9CD647CC, 0x9CC66564, 0x9CB686CF, 
    0x9CA6AC0D, 0x9C96D521, 0x9C870209, 0x9C7732C7, 0x9C67675C, 0x9C579FC7, 
    0x9C47DC0A, 0x9C381C76, 0x9C28606A, 0x9C18A837, 0x9C08F3DF, 0x9BF94361, 
    0x9BE996BE, 0x9BD9EDF7, 0x9BCA490D, 0x9BBAA7FF, 0x9BAB0ACF, 0x9B9B717E, 
    0x9B8BDC0B, 0x9B7C4A78, 0x9B6CBCC5, 0x9B5D32F2, 0x9B4DAD01, 0x9B3E2AF1, 
    0x9B2EACC4, 0x9B1F327A, 0x9B0FBC14, 0x9B004992, 0x9AF0DAF4, 0x9AE1703C, 
    0x9AD2096B, 0x9AC2A67F, 0x9AB3477B, 0x9AA3EC5F, 0x9A949579, 0x9A85422E, 
    0x9A75F2CD, 0x9A66A755, 0x9A575FC9, 0x9A481C28, 0x9A38DC72, 0x9A29A0AA, 
    0x9A1A68CE, 0x9A0B34E0, 0x99FC04E0, 0x99ECD8D0, 0x99DDB0AE, 0x99CE8C7D, 
    0x99BF6C3C, 0x99B04FED, 0x99A1378F, 0x99922323, 0x998312AB, 0x99740626, 
    0x9964FD95, 0x9955F8F9, 0x9946F852, 0x9937FBA1, 0x992902E6, 0x991A0E23, 
    0x990B1D57, 0x98FC30CF, 0x98ED47F3, 0x98DE6311, 0x98CF8229, 0x98C0A53B, 
    0x98B1CC49, 0x98A2F752, 0x98942657, 0x98855959, 0x98769058, 0x9867CB55, 
    0x98590A50, 0x984A4D4B, 0x983B9445, 0x982CDF3F, 0x981E2E3A, 0x980F8136, 
    0x9800D834, 0x97F23334, 0x97E39238, 0x97D4F53F, 0x97C65C4A, 0x97B7C759, 
    0x97A9366E, 0x979AA989, 0x978C20AA, 0x977D9BD2, 0x976F1B02, 0x97609E83, 
    0x975225C3, 0x9743B10C, 0x9735405F, 0x9726D3BC, 0x97186B24, 0x970A0697, 
    0x96FBA617, 0x96ED49A2, 0x96DEF13B, 0x96D09CE1, 0x96C24C96, 0x96B40059, 
    0x96A5B82B, 0x9697740E, 0x96893400, 0x967AF804, 0x966CC019, 0x965E8C40, 
    0x96505C79, 0x964230C5, 0x96340926, 0x9625E59A, 0x9617C623, 0x9609AAC1, 
    0x95FB9375, 0x95ED8040, 0x95DF7169, 0x95D16662, 0x95C35F72, 0x95B55C9C, 
    0x95A75DDE, 0x9599633A, 0x958B6CB0, 0x957D7A41, 0x956F8BEC, 0x9561A1B4, 
    0x9553BB98, 0x9545D999, 0x9537FBB7, 0x952A21F3, 0x951C4C4E, 0x950E7AC7, 
    0x9500AD60, 0x94F2E419, 0x94E51EF3, 0x94D75DED, 0x94C9A10A, 0x94BBE848, 
    0x94AE33A9, 0x94A0832D, 0x9492D6D5, 0x94852EA2, 0x94778A93, 0x9469EAA9, 
    0x945C4F2B, 0x944EB78D, 0x94412416, 0x943394C7, 0x942609A0, 0x941882A1, 
    0x940AFFCB, 0x93FD811F, 0x93F0069D, 0x93E29045, 0x93D51E18, 0x93C7B017, 
    0x93BA4642, 0x93ACE09A, 0x939F7F1E, 0x939221D1, 0x9384C8B1, 0x937773C0, 
    0x936A22FF, 0x935CD66D, 0x934F8E0B, 0x934249DA, 0x933509DA, 0x9327CE0C, 
    0x931A9671, 0x930D6308, 0x930033D2, 0x92F308D0, 0x92E5E202, 0x92D8BF69, 
    0x92CBA106, 0x92BE86D8, 0x92B170E1, 0x92A45F20, 0x92975197, 0x928A4846, 
    0x927D432D, 0x9270424C, 0x926345A5, 0x92564D38, 0x92495906, 0x923C6991, 
    0x922F7DD5, 0x92229654, 0x9215B30F, 0x9208D407, 0x91FBF93D, 0x91EF22B0, 
    0x91E25062, 0x91D58252, 0x91C8B882, 0x91BBF2F2, 0x91AF31A2, 0x91A27492, 
    0x9195BBC4, 0x91890738, 0x917C56EE, 0x916FAAE7, 0x91630323, 0x91565FA2, 
    0x9149C066, 0x913D256E, 0x91308EBC, 0x9123FC50, 0x91176E29, 0x910AE449, 
    0x90FE5EB0, 0x90F1DD5F, 0x90E56056, 0x90D8E796, 0x90CC731E, 0x90C002F0, 
    0x90B3970C, 0x90A72F73, 0x909ACC24, 0x908E6D21, 0x9082126A, 0x9075BBFF, 
    0x906969E1, 0x905D1C10, 0x9050D28E, 0x90448D59, 0x90384C73, 0x902C0FDD, 
    0x901FD796, 0x9013A39F, 0x900773F9, 0x8FFB48A4, 0x8FEF21A1, 0x8FE2FEF0, 
    0x8FD6E091, 0x8FCAC685, 0x8FBEB0CD, 0x8FB29F69, 0x8FA69259, 0x8F9A899E, 
    0x8F8E85B2, 0x8F8285A2, 0x8F7689E8, 0x8F6A9285, 0x8F5E9F78, 0x8F52B0C4, 
    0x8F46C668, 0x8F3AE064, 0x8F2EFEB9, 0x8F232167, 0x8F174870, 0x8F0B73D3, 
    0x8EFFA391, 0x8EF3D7AA, 0x8EE8101E, 0x8EDC4CEF, 0x8ED08E1D, 0x8EC4D3A8, 
    0x8EB91D90, 0x8EAD6BD6, 0x8EA1BE7B, 0x8E96157E, 0x8E8A70E1, 0x8E7ED0A4, 
    0x8E7334C7, 0x8E679D4B, 0x8E5C0A30, 0x8E507B76, 0x8E44F11F, 0x8E396B2A, 
    0x8E2DE997, 0x8E226C69, 0x8E16F39E, 0x8E0B7F37, 0x8E000F35, 0x8DF4A398, 
    0x8DE93C61, 0x8DDDD990, 0x8DD27B25, 0x8DC72121, 0x8DBBCB85, 0x8DB07A50, 
    0x8DA52D83, 0x8D99E520, 0x8D8EA125, 0x8D836193, 0x8D78266C, 0x8D6CEFAF, 
    0x8D61BD5D, 0x8D568F76, 0x8D4B65FB, 0x8D4040EB, 0x8D352049, 0x8D2A0413, 
    0x8D1EECBC, 0x8D13D961, 0x8D08CA75, 0x8CFDBFF7, 0x8CF2B9E8, 0x8CE7B849, 
    0x8CDCBB1A, 0x8CD1C25B, 0x8CC6CE0D, 0x8CBBDE31, 0x8CB0F2C6, 0x8CA60BCC, 
    0x8C9B2946, 0x8C904B32, 0x8C857192, 0x8C7A9C65, 0x8C6FCBAD, 0x8C64FF69, 
    0x8C5A379A, 0x8C4F7440, 0x8C44B55D, 0x8C39FAEF, 0x8C2F44F8, 0x8C249378, 
    0x8C19E670, 0x8C0F3DE0, 0x8C0499C8, 0x8BF9FA28, 0x8BEF5F02, 0x8BE4C855, 
    0x8BDA3622, 0x8BCFA86A, 0x8BC51F2C, 0x8BBA9A69, 0x8BB01A22, 0x8BA59E57, 
    0x8B9B2708, 0x8B90B436, 0x8B8645E2, 0x8B7BDC0A, 0x8B7176B1, 0x8B6715D6, 
    0x8B5CB97A, 0x8B52619D, 0x8B480E40, 0x8B3DBF62, 0x8B337505, 0x8B292F29, 
    0x8B1EEDCE, 0x8B14B0F4, 0x8B0A789D, 0x8B0044C8, 0x8AF61575, 0x8AEBEAA6, 
    0x8AE1C45A, 0x8AD7A2F9, 0x8ACD85B5, 0x8AC36CF6, 0x8AB958BC, 0x8AAF4908, 
    0x8AA53DD9, 0x8A9B3731, 0x8A91350F, 0x8A873774, 0x8A7D3E61, 0x8A7349D5, 
    0x8A6959D2, 0x8A5F6E57, 0x8A558765, 0x8A4BA4FC, 0x8A41C71E, 0x8A37EDC9, 
    0x8A2E18FE, 0x8A2448BF, 0x8A1A7D0B, 0x8A10B5E2, 0x8A06F345, 0x89FD3535, 
    0x89F37BB1, 0x89E9C6BB, 0x89E01652, 0x89D66A77, 0x89CCC32A, 0x89C3206B, 
    0x89B9823C, 0x89AFE89C, 0x89A6538C, 0x899CC30B, 0x8993371B, 0x8989AFBC, 
    0x89802CEF, 0x8976AEB2, 0x896D3508, 0x8963BFF0, 0x895A4F6A, 0x8950E378, 
    0x89477C19, 0x893E194E, 0x8934BB16, 0x892B6174, 0x89220C66, 0x8918BBED, 
    0x890F700A, 0x890628BC, 0x88FCE605, 0x88F3A7E5, 0x88EA6E5B, 0x88E13969, 
    0x88D8090E, 0x88CEDD4C, 0x88C5B67F, 0x88BC93ED, 0x88B375F5, 0x88AA5C96, 
    0x88A147D1, 0x889837A5, 0x888F2C15, 0x8886251F, 0x887D22C5, 0x88742505, 
    0x886B2BE2, 0x8862375B, 0x88594771, 0x88505C24, 0x88477573, 0x883E9361, 
    0x8835B5EC, 0x882CDD16, 0x882408DE, 0x881B3945, 0x88126E4C, 0x8809A7F2, 
    0x8800E638, 0x87F8291F, 0x87EF70A6, 0x87E6BCCE, 0x87DE0D98, 0x87D56303, 
    0x87CCBD10, 0x87C41BC0, 0x87BB7F12, 0x87B2E707, 0x87AA539F, 0x87A1C4DC, 
    0x87993ABC, 0x8790B540, 0x87883469, 0x877FB837, 0x877740AB, 0x876ECDC4, 
    0x87665F83, 0x875DF5E8, 0x875590F4, 0x874D30A7, 0x8744D501, 0x873C7E03, 
    0x87342BAC, 0x872BDDFE, 0x872394F8, 0x871B509C, 0x871310E8, 0x870AD5DE, 
    0x87029F7D, 0x86FA6DC7, 0x86F240BB, 0x86EA18AD, 0x86E1F4F7, 0x86D9D5EC, 
    0x86D1BB8D, 0x86C9A5DA, 0x86C194D4, 0x86B9887A, 0x86B180CC, 0x86A97DCD, 
    0x86A17F7A, 0x869985D6, 0x869190E0, 0x8689A098, 0x8681B4FF, 0x8679CE15, 
    0x8671EBDB, 0x866A0E50, 0x86623575, 0x865A614B, 0x865291D1, 0x864AC708, 
    0x864300F0, 0x863B3F8A, 0x863382D5, 0x862BCAD3, 0x86241783, 0x861C68E6, 
    0x8614BEFC, 0x860D19C5, 0x86057942, 0x85FDDD73, 0x85F64657, 0x85EEB3F1, 
    0x85E7263F, 0x85DF9D42, 0x85D818FA, 0x85D09968, 0x85C91E8C, 0x85C1A867, 
    0x85BA36F7, 0x85B2CA3F, 0x85AB623E, 0x85A3FEF4, 0x859CA061, 0x85954687, 
    0x858DF164, 0x8586A0FB, 0x857F554A, 0x85780E52, 0x8570CC13, 0x85698E8E, 
    0x856255C3, 0x855B21B2, 0x8553F25C, 0x854CC7C0, 0x8545A228, 0x853E8103, 
    0x85376499, 0x85304CEA, 0x852939F8, 0x85222BC3, 0x851B224A, 0x85141D8D, 
    0x850D1D8E, 0x8506224D, 0x84FF2BC9, 0x84F83A03, 0x84F14CFC, 0x84EA64B3, 
    0x84E38129, 0x84DCA25E, 0x84D5C852, 0x84CEF306, 0x84C8227A, 0x84C156AD, 
    0x84BA8FA2, 0x84B3CD57, 0x84AD0FCC, 0x84A65703, 0x849FA2FC, 0x8498F3B6, 
    0x84924932, 0x848BA370, 0x84850270, 0x847E6634, 0x8477CEBA, 0x84713C04, 
    0x846AAE11, 0x846424E1, 0x845DA076, 0x845720CF, 0x8450A5EC, 0x844A2FCE, 
    0x8443BE75, 0x843D51E2, 0x8436EA14, 0x8430870B, 0x842A28C9, 0x8423CF4C, 
    0x841D7A97, 0x84172AA7, 0x8410DF7F, 0x840A991E, 0x84045785, 0x83FE1AB3, 
    0x83F7E2A9, 0x83F1AF67, 0x83EB80ED, 0x83E5573D, 0x83DF3293, 0x83D91274, 
    0x83D2F71E, 0x83CCE092, 0x83C6CED0, 0x83C0C1D8, 0x83BAB9AA, 0x83B4B646, 
    0x83AEB7AD, 0x83A8BDE0, 0x83A2C8DD, 0x839CD8A6, 0x8396ED3A, 0x8391069B, 
    0x838B24C7, 0x838547C0, 0x837F6F86, 0x83799C18, 0x8373CD77, 0x836E03A4, 
    0x83683E9D, 0x83627E65, 0x835CC2FB, 0x83570C5E, 0x83515A90, 0x834BAD91, 
    0x83460560, 0x834061FF, 0x833AC36C, 0x833529A9, 0x832F94B6, 0x832A0493, 
    0x8324793F, 0x831EF2BC, 0x8319710A, 0x8313F428, 0x830E7C17, 0x830908D8, 
    0x83039A69, 0x82FE30CD, 0x82F8CC02, 0x82F36C09, 0x82EE10E2, 0x82E8BA8D, 
    0x82E3690C, 0x82DE1C5D, 0x82D8D481, 0x82D39178, 0x82CE5343, 0x82C919E1, 
    0x82C3E553, 0x82BEB599, 0x82B98AB3, 0x82B464A2, 0x82AF4366, 0x82AA2732, 
    0x82A50F9F, 0x829FFCE1, 0x829AEEF9, 0x8295E5E6, 0x8290E1A9, 0x828BE242, 
    0x8286E7B1, 0x8281F1F7, 0x827D0113, 0x82781506, 0x82732DD0, 0x826E4B71, 
    0x82696DEA, 0x82649539, 0x825FC161, 0x825AF260, 0x82562838, 0x825162E8, 
    0x824CA270, 0x8247E6D1, 0x8243300A, 0x823E7E1D, 0x8239D109, 0x823528CE, 
    0x8230856D, 0x822BE6E5, 0x82274D37, 0x8222B864, 0x821E286A, 0x82199D4B, 
    0x82151707, 0x8210959D, 0x820C190F, 0x8207A15B, 0x82032E83, 0x81FEC086, 
    0x81FA5764, 0x81F5F31F, 0x81F193B6, 0x81ED3928, 0x81E8E377, 0x81E492A3, 
    0x81E046AB, 0x81DBFF8F, 0x81D7BD51, 0x81D37FF0, 0x81CF476C, 0x81CB13C6, 
    0x81C6E4FD, 0x81C2BB13, 0x81BE9606, 0x81BA75D7, 0x81B65A86, 0x81B24414, 
    0x81AE32AA, 0x81AA25F5, 0x81A61E1E, 0x81A21B27, 0x819E1D0F, 0x819A23D7, 
    0x81962F7D, 0x81924004, 0x818E556A, 0x818A6FB1, 0x81868ED7, 0x8182B2DE, 
    0x817EDBC5, 0x817B098D, 0x81773C35, 0x817373BE, 0x816FB028, 0x816BF174, 
    0x816837A0, 0x816482AE, 0x8160D29E, 0x815D276F, 0x81598123, 0x8155DFB8, 
    0x8152432F, 0x814EAB89, 0x814B18C5, 0x81478AE3, 0x814401E5, 0x81407DC9, 
    0x813CFE90, 0x8139843A, 0x81360EC7, 0x81329E38, 0x812F328C, 0x812BCBC4, 
    0x812869E0, 0x81250CDF, 0x8121B4C3, 0x811E618A, 0x811B1336, 0x8117C9C7, 
    0x8114853B, 0x81114595, 0x810E0AD3, 0x810AD4F6, 0x8107A3FF, 0x810477EC, 
    0x810150BF, 0x80FE2E77, 0x80FB1114, 0x80F7F898, 0x80F4E501, 0x80F1D650, 
    0x80EECC84, 0x80EBC7BE, 0x80E8C7BF, 0x80E5CCA6, 0x80E2D674, 0x80DFE528, 
    0x80DCF8C3, 0x80DA1145, 0x80D72EAE, 0x80D450FE, 0x80D17835, 0x80CEA453, 
    0x80CBD558, 0x80C90B45, 0x80C6461A, 0x80C385D6, 0x80C0CA7A, 0x80BE1406, 
    0x80BB627A, 0x80B8B5D6, 0x80B60E1A, 0x80B36B46, 0x80B0CD5B, 0x80AE3458, 
    0x80ABA03E, 0x80A9110D, 0x80A686C4, 0x80A40165, 0x80A180EE, 0x809F0560, 
    0x809C8EBC, 0x809A1D01, 0x8097B02F, 0x80954847, 0x8092E548, 0x80908733, 
    0x808E2E08, 0x808BD9C6, 0x80898A6F, 0x80874001, 0x8084FA7D, 0x8082B9E4, 
    0x80807E35, 0x807E4771, 0x807C1596, 0x8079E8A7, 0x8077C0A2, 0x80759D87, 
    0x80737F58, 0x80716613, 0x806F51B9, 0x806D424B, 0x806B37C7, 0x8069322F, 
    0x80673182, 0x806535C0, 0x80633EFD, 0x80614D12, 0x805F6013, 0x805D77FF, 
    0x805B94D6, 0x8059B69A, 0x8057DD49, 0x805608E5, 0x8054396C, 0x80526EE0, 
    0x8050A93F, 0x804EE88B, 0x804D2CC3, 0x804B75E7, 0x8049C3F8, 0x804816F6, 
    0x80466EDF, 0x8044CBB6, 0x80432D79, 0x80419429, 0x803FFFC5, 0x803E704F, 
    0x803CE5C5, 0x803B6028, 0x8039DF79, 0x803863B6, 0x8036ECE1, 0x80357AF8, 
    0x80340DFE, 0x8032A5F0, 0x803142D0, 0x802FE49D, 0x802E8B57, 0x802D36FF, 
    0x802BE795, 0x802A9D18, 0x80295789, 0x802816E8, 0x8026DB35, 0x8025A46F, 
    0x80247297, 0x802345AD, 0x80221DB1, 0x8020FAA3, 0x801FDC83, 0x801EC351, 
    0x801DAF0E, 0x801C9FB8, 0x801B9551, 0x801A8FD8, 0x80198F4D, 0x801893B1, 
    0x80179D02, 0x8016AB43, 0x8015BE7B, 0x8014D698, 0x8013F3A4, 0x8013159E, 
    0x80123C86, 0x8011685E, 0x80109924, 0x800FCED8, 0x800F097C, 0x800E490E, 
    0x800D8D8E, 0x800CD6FE, 0x800C255D, 0x800B78AA, 0x800AD0E6, 0x800A2E11, 
    0x8009902B, 0x8008F734, 0x8008632C, 0x8007D413, 0x800749E9, 0x8006C4AE, 
    0x80064462, 0x8005C905, 0x80055297, 0x8004E118, 0x80047489, 0x80040CE8, 
    0x8003AA37, 0x80034C75, 0x8002F3A2, 0x80029FBE, 0x800250CA, 0x800206C5, 
    0x8001C1AF, 0x80018188, 0x80014650, 0x80011008, 0x8000DEAF, 0x8000B246, 
    0x80008ACB, 0x80006840, 0x80004AA4, 0x800031F8, 0x80001E3B, 0x80000F6D, 
    0x8000058E, 0x8000009F
};

const int32_t sine_1024[] = {
    0xFFE6DE06, 0xFFB49A13, 0xFF82562D, 0xFF501259, 0xFF1DCEA1, 0xFEEB8B0C, 
    0xFEB947A0, 0xFE870468, 0xFE54C16A, 0xFE227EAD, 0xFDF03C3D, 0xFDBDFA1A, 
    0xFD8BB850, 0xFD5976EC, 0xFD2735EC, 0xFCF4F55C, 0xFCC2B548, 0xFC9075B1, 
    0xFC5E36A1, 0xFC2BF824, 0xFBF9BA3B, 0xFBC77CF0, 0xFB95404C, 0xFB630456, 
    0xFB30C91F, 0xFAFE8E9D, 0xFACC54E1, 0xFA9A1BF3, 0xFA67E3D9, 0xFA35AC9C, 
    0xFA03764C, 0xF9D140E1, 0xF99F0C69, 0xF96CD8ED, 0xF93AA675, 0xF9087508, 
    0xF8D644B6, 0xF8A41577, 0xF871E75A, 0xF83FBA68, 0xF80D8EA7, 0xF7DB6421, 
    0xF7A93AE4, 0xF77712E0, 0xF744EC3D, 0xF712C6F2, 0xF6E0A2F8, 0xF6AE8077, 
    0xF67C5F55, 0xF64A3FBA, 0xF618218F, 0xF5E604FC, 0xF5B3E9F6, 0xF581D078, 
    0xF54FB8A7, 0xF51DA26D, 0xF4EB8DF0, 0xF4B97B29, 0xF4876A0F, 0xF4555ACA, 
    0xF4234D41, 0xF3F1419D, 0xF3BF37C4, 0xF38D2FE0, 0xF35B29E6, 0xF32925D0, 
    0xF2F723C5, 0xF2C523AD, 0xF29325AE, 0xF26129C2, 0xF22F2FDF, 0xF1FD382E, 
    0xF1CB4296, 0xF1994F3F, 0xF1675E10, 0xF1356F32, 0xF103829B, 0xF0D19845, 
    0xF09FB055, 0xF06DCAB5, 0xF03BE78B, 0xF00A06CF, 0xEFD8287A, 0xEFA64CA3, 
    0xEF747371, 0xEF429CAC, 0xEF10C87C, 0xEEDEF709, 0xEEAD2819, 0xEE7B5BD6, 
    0xEE499247, 0xEE17CB92, 0xEDE60781, 0xEDB4463A, 0xED8287E5, 0xED50CC4B, 
    0xED1F1392, 0xECED5DC2, 0xECBBAB03, 0xEC89FB1D, 0xEC584E38, 0xEC26A47A, 
    0xEBF4FDAC, 0xEBC359F5, 0xEB91B97C, 0xEB601C0B, 0xEB2E81C8, 0xEAFCEABB, 
    0xEACB570B, 0xEA99C680, 0xEA683942, 0xEA36AF79, 0xEA0528EB, 0xE9D3A5C2, 
    0xE9A22604, 0xE970A9D8, 0xE93F3108, 0xE90DBBBA, 0xE8DC4A15, 0xE8AADBE2, 
    0xE8797148, 0xE8480A50, 0xE816A71F, 0xE7E5477E, 0xE7B3EB95, 0xE782938B, 
    0xE7513F28, 0xE71FEE94, 0xE6EEA1F4, 0xE6BD5914, 0xE68C1418, 0xE65AD30A, 
    0xE629960F, 0xE5F85CF0, 0xE5C727D6, 0xE595F6E6, 0xE564C9E9, 0xE533A107, 
    0xE5027C47, 0xE4D15BCF, 0xE4A03F6A, 0xE46F273D, 0xE43E136F, 0xE40D03CA, 
    0xE3DBF875, 0xE3AAF177, 0xE379EEF6, 0xE348F0BC, 0xE317F6F0, 0xE2E701B8, 
    0xE2B610DD, 0xE2852487, 0xE2543CDC, 0xE22359A5, 0xE1F27B09, 0xE1C1A110, 
    0xE190CBDF, 0xE15FFB41, 0xE12F2F5C, 0xE0FE6857, 0xE0CDA5FA, 0xE09CE86D, 
    0xE06C2FB8, 0xE03B7C00, 0xE00ACD0F, 0xDFDA230B, 0xDFA97DFD, 0xDF78DDEC, 
    0xDF48431C, 0xDF17AD1B, 0xDEE71C2C, 0xDEB69058, 0xDE8609A7, 0xDE55881E, 
    0xDE250BC7, 0xDDF494E6, 0xDDC42308, 0xDD93B671, 0xDD634F29, 0xDD32ED37, 
    0xDD0290A4, 0xDCD23975, 0xDCA1E7F1, 0xDC719BA4, 0xDC4154D2, 0xDC111384, 
    0xDBE0D7C0, 0xDBB0A18E, 0xDB807133, 0xDB50463C, 0xDB2020ED, 0xDAF0014D, 
    0xDABFE765, 0xDA8FD33B, 0xDA5FC4D8, 0xDA2FBC7F, 0xD9FFB9BD, 0xD9CFBCD8, 
    0xD99FC5D7, 0xD96FD4C0, 0xD93FE99C, 0xD9100472, 0xD8E02586, 0xD8B04C65, 
    0xD8807955, 0xD850AC5C, 0xD820E581, 0xD7F124CD, 0xD7C16A46, 0xD791B630, 
    0xD762081A, 0xD7326047, 0xD702BEC0, 0xD6D3238A, 0xD6A38EAE, 0xD6740033, 
    0xD644785D, 0xD614F6B9, 0xD5E57B8D, 0xD5B606DE, 0xD58698B6, 0xD557311A, 
    0xD527D012, 0xD4F875E2, 0xD4C92218, 0xD499D4F8, 0xD46A8E8A, 0xD43B4ED4, 
    0xD40C15DE, 0xD3DCE3B0, 0xD3ADB88C, 0xD37E9401, 0xD34F7654, 0xD3205F8B, 
    0xD2F14FAD, 0xD2C246C3, 0xD293450E, 0xD2644A1E, 0xD2355638, 0xD2066961, 
    0xD1D783A0, 0xD1A8A4FF, 0xD179CD82, 0xD14AFD6E, 0xD11C3453, 0xD0ED7272, 
    0xD0BEB7D4, 0xD090047F, 0xD061587C, 0xD032B3D0, 0xD00416BE, 0xCFD580D8, 
    0xCFA6F25F, 0xCF786B5B, 0xCF49EBD2, 0xCF1B73CD, 0xCEED0352, 0xCEBE9AA4, 
    0xCE903952, 0xCE61DFA1, 0xCE338D96, 0xCE05433A, 0xCDD70092, 0xCDA8C5A7, 
    0xCD7A92BA, 0xCD4C675C, 0xCD1E43D1, 0xCCF0281E, 0xCCC2144A, 0xCC94085E, 
    0xCC660460, 0xCC380891, 0xCC0A1485, 0xCBDC287B, 0xCBAE447C, 0xCB80688F, 
    0xCB5294BA, 0xCB24C93F, 0xCAF705B0, 0xCAC94A4F, 0xCA9B9723, 0xCA6DEC32, 
    0xCA404985, 0xCA12AF21, 0xC9E51D49, 0xC9B7938E, 0xC98A1233, 0xC95C993D, 
    0xC92F28B5, 0xC901C0A0, 0xC8D46107, 0xC8A70A2A, 0xC879BB9B, 0xC84C759D, 
    0xC81F3836, 0xC7F2036C, 0xC7C4D748, 0xC797B3D0, 0xC76A9944, 0xC73D8738, 
    0xC7107DED, 0xC6E37D6A, 0xC6B685B5, 0xC68996D6, 0xC65CB0D4, 0xC62FD3EE, 
    0xC602FFBA, 0xC5D63477, 0xC5A9722C, 0xC57CB8E0, 0xC550089A, 0xC5236161, 
    0xC4F6C374, 0xC4CA2E6A, 0xC49DA281, 0xC4711FC0, 0xC444A62F, 0xC41835D3, 
    0xC3EBCEB5, 0xC3BF7113, 0xC3931C83, 0xC366D145, 0xC33A8F5F, 0xC30E56D8, 
    0xC2E227B7, 0xC2B6023C, 0xC289E5FB, 0xC25DD335, 0xC231C9F0, 0xC205CA33, 
    0xC1D9D405, 0xC1ADE76D, 0xC1820471, 0xC1562B18, 0xC12A5B68, 0xC0FE956A, 
    0xC0D2D992, 0xC0A72709, 0xC07B7E45, 0xC04FDF4C, 0xC0244A25, 0xBFF8BED8, 
    0xBFCD3D6A, 0xBFA1C5E3, 0xBF765849, 0xBF4AF4A3, 0xBF1F9AF7, 0xBEF44B4D, 
    0xBEC905AB, 0xBE9DCA85, 0xBE729906, 0xBE4771A3, 0xBE1C5463, 0xBDF1414C, 
    0xBDC63865, 0xBD9B39B4, 0xBD704541, 0xBD455B11, 0xBD1A7B2C, 0xBCEFA597, 
    0xBCC4DA5B, 0xBC9A197C, 0xBC6F6302, 0xBC44B760, 0xBC1A15C4, 0xBBEF7EA0, 
    0xBBC4F1FB, 0xBB9A6FDB, 0xBB6FF848, 0xBB458B48, 0xBB1B28E1, 0xBAF0D11A, 
    0xBAC683F9, 0xBA9C4185, 0xBA7209C4, 0xBA47DCBE, 0xBA1DBA78, 0xB9F3A363, 
    0xB9C996B1, 0xB99F94D3, 0xB9759DD0, 0xB94BB1AD, 0xB921D071, 0xB8F7FA23, 
    0xB8CE2ECA, 0xB8A46E6B, 0xB87AB90D, 0xB8510EB7, 0xB8276F6E, 0xB7FDDB3B, 
    0xB7D45221, 0xB7AAD493, 0xB78161C3, 0xB757FA20, 0xB72E9DB2, 0xB7054C7F, 
    0xB6DC068C, 0xB6B2CBE2, 0xB6899C85, 0xB660787C, 0xB6375FCE, 0xB60E5281, 
    0xB5E5509B, 0xB5BC5A22, 0xB5936F86, 0xB56A8FFB, 0xB541BBF1, 0xB518F36D, 
    0xB4F03677, 0xB4C78514, 0xB49EDF4B, 0xB4764521, 0xB44DB69E, 0xB42533C7, 
    0xB3FCBCA2, 0xB3D45137, 0xB3ABF18B, 0xB3839DA3, 0xB35B55EF, 0xB33319A5, 
    0xB30AE933, 0xB2E2C49F, 0xB2BAABF0, 0xB2929F2B, 0xB26A9E57, 0xB242A97A, 
    0xB21AC09A, 0xB1F2E3BD, 0xB1CB12E9, 0xB1A34E25, 0xB17B9577, 0xB153E8E4, 
    0xB12C48D8, 0xB104B48F, 0xB0DD2C75, 0xB0B5B08E, 0xB08E40E1, 0xB066DD75, 
    0xB03F8650, 0xB0183B77, 0xAFF0FCF0, 0xAFC9CAC2, 0xAFA2A4F3, 0xAF7B8B88, 
    0xAF547E88, 0xAF2D7E5C, 0xAF068A44, 0xAEDFA2A8, 0xAEB8C78F, 0xAE91F8FF, 
    0xAE6B36FD, 0xAE448191, 0xAE1DD8BE, 0xADF73C8D, 0xADD0AD02, 0xADAA2A24, 
    0xAD83B3F8, 0xAD5D4A85, 0xAD36EDCF, 0xAD109E40, 0xACEA5B19, 0xACC424C3, 
    0xAC9DFB42, 0xAC77DE9D, 0xAC51CEDA, 0xAC2BCBFE, 0xAC05D610, 0xABDFED15, 
    0xABBA1113, 0xAB944211, 0xAB6E8013, 0xAB48CB1F, 0xAB23233D, 0xAAFD88D0, 
    0xAAD7FB1F, 0xAAB27A90, 0xAA8D0729, 0xAA67A0F0, 0xAA4247E9, 0xAA1CFC1B, 
    0xA9F7BD8D, 0xA9D28C42, 0xA9AD6842, 0xA9885191, 0xA9634837, 0xA93E4C37, 
    0xA9195DF7, 0xA8F47CBF, 0xA8CFA8F4, 0xA8AAE29A, 0xA88629B9, 0xA8617E55, 
    0xA83CE074, 0xA818501C, 0xA7F3CD52, 0xA7CF581C, 0xA7AAF080, 0xA7869682, 
    0xA7624A2A, 0xA73E0B7D, 0xA719DADB, 0xA6F5B793, 0xA6D1A206, 0xA6AD9A39, 
    0xA689A033, 0xA665B3F9, 0xA641D590, 0xA61E04FF, 0xA5FA4249, 0xA5D68D76, 
    0xA5B2E68A, 0xA58F4D8B, 0xA56BC27E, 0xA548456A, 0xA524D6AD, 0xA5017598, 
    0xA4DE228C, 0xA4BADD8E, 0xA497A6A3, 0xA4747DD0, 0xA451631C, 0xA42E568B, 
    0xA40B5823, 0xA3E867E9, 0xA3C585E3, 0xA3A2B216, 0xA37FEC87, 0xA35D353C, 
    0xA33A8C93, 0xA317F1E0, 0xA2F56580, 0xA2D2E77A, 0xA2B077D2, 0xA28E168E, 
    0xA26BC3B3, 0xA2497F46, 0xA227494D, 0xA20521CD, 0xA1E308CB, 0xA1C0FE4D, 
    0xA19F0257, 0xA17D1545, 0xA15B3671, 0xA1396634, 0xA117A496, 0xA0F5F19A, 
    0xA0D44D46, 0xA0B2B79F, 0xA09130AB, 0xA06FB86E, 0xA04E4EEE, 0xA02CF430, 
    0xA00BA839, 0x9FEA6B0E, 0x9FC93CB4, 0x9FA81D85, 0x9F870CDE, 0x9F660B16, 
    0x9F451835, 0x9F24343E, 0x9F035F37, 0x9EE29925, 0x9EC1E20C, 0x9EA139F3, 
    0x9E80A0DE, 0x9E6016D2, 0x9E3F9BD4, 0x9E1F2FE9, 0x9DFED317, 0x9DDE85B3, 
    0x9DBE471F, 0x9D9E17B3, 0x9D7DF772, 0x9D5DE662, 0x9D3DE489, 0x9D1DF1EA, 
    0x9CFE0E8A, 0x9CDE3A70, 0x9CBE759F, 0x9C9EC01C, 0x9C7F19ED, 0x9C5F8316, 
    0x9C3FFBED, 0x9C2083D5, 0x9C011B24, 0x9BE1C1DF, 0x9BC2780A, 0x9BA33DAB, 
    0x9B8412C6, 0x9B64F75F, 0x9B45EB7D, 0x9B26EF23, 0x9B080256, 0x9AE9251C, 
    0x9ACA5778, 0x9AAB9970, 0x9A8CEB57, 0x9A6E4C94, 0x9A4FBD7B, 0x9A313E10, 
    0x9A12CE59, 0x99F46E5A, 0x99D61E17, 0x99B7DD96, 0x9999ACDB, 0x997B8BEA, 
    0x995D7AC8, 0x993F797B, 0x99218806, 0x9903A66D, 0x98E5D503, 0x98C81333, 
    0x98AA614E, 0x988CBF58, 0x986F2D56, 0x9851AB4D, 0x98343942, 0x9816D738, 
    0x97F98534, 0x97DC433B, 0x97BF1151, 0x97A1EF7B, 0x9784DDBD, 0x9767DC66, 
    0x974AEAE6, 0x972E098C, 0x9711385C, 0x96F4775B, 0x96D7C68C, 0x96BB25F6, 
    0x969E959B, 0x96821580, 0x9665A5AA, 0x9649461D, 0x962CF6DD, 0x9610B7EF, 
    0x95F48958, 0x95D86B62, 0x95BC5D84, 0x95A06009, 0x958472F5, 0x9568964D, 
    0x954CCA15, 0x95310E51, 0x95156307, 0x94F9C839, 0x94DE3DEC, 0x94C2C424, 
    0x94A75AE7, 0x948C0237, 0x9470BA19, 0x945582D7, 0x943A5BEA, 0x941F459B, 
    0x94043FF0, 0x93E94AEB, 0x93CE6692, 0x93B392E8, 0x9398CFF2, 0x937E1DB3, 
    0x93637C30, 0x9348EB6C, 0x932E6B6D, 0x9313FC36, 0x92F99DCA, 0x92DF502F, 
    0x92C51368, 0x92AAE77A, 0x9290CC67, 0x9276C235, 0x925CC8E8, 0x9242E106, 
    0x9229098D, 0x920F4304, 0x91F58D6F, 0x91DBE8D2, 0x91C25532, 0x91A8D292, 
    0x918F60F6, 0x91760062, 0x915CB0DA, 0x91437262, 0x912A44FD, 0x911128B0, 
    0x90F81D7F, 0x90DF236D, 0x90C63A7E, 0x90AD62B6, 0x90949C19, 0x907BE6AB, 
    0x9063426F, 0x904AAF69, 0x90322D9E, 0x9019BD11, 0x90015DC5, 0x8FE90FBE, 
    0x8FD0D301, 0x8FB8A790, 0x8FA08D71, 0x8F88851F, 0x8F708DAB, 0x8F58A793, 
    0x8F40D2DB, 0x8F290F85, 0x8F115D96, 0x8EF9BD12, 0x8EE22DFB, 0x8ECAB057, 
    0x8EB34427, 0x8E9BE971, 0x8E84A037, 0x8E6D687D, 0x8E564247, 0x8E3F2D98, 
    0x8E282A74, 0x8E1138DE, 0x8DFA58DA, 0x8DE38A6C, 0x8DCCCD96, 0x8DB6225D, 
    0x8D9F88C4, 0x8D8900CF, 0x8D728A80, 0x8D5C25DC, 0x8D45D2E6, 0x8D2F91A0, 
    0x8D196281, 0x8D0344A8, 0x8CED388B, 0x8CD73E2D, 0x8CC15591, 0x8CAB7EBB, 
    0x8C95B9AE, 0x8C80066D, 0x8C6A64FC, 0x8C54D55E, 0x8C3F5797, 0x8C29EBA9, 
    0x8C149199, 0x8BFF4969, 0x8BEA131C, 0x8BD4EEB7, 0x8BBFDC3B, 0x8BAADBAD, 
    0x8B95ED10, 0x8B811066, 0x8B6C45B4, 0x8B578CFC, 0x8B42E641, 0x8B2E5187, 
    0x8B19CED1, 0x8B055E22, 0x8AF0FF7D, 0x8ADCB2E5, 0x8AC878C5, 0x8AB45051, 
    0x8AA039F4, 0x8A8C35B1, 0x8A78438A, 0x8A646383, 0x8A50959F, 0x8A3CD9E2, 
    0x8A29304D, 0x8A1598E5, 0x8A0213AC, 0x89EEA0A4, 0x89DB3FD2, 0x89C7F139, 
    0x89B4B4DA, 0x89A18AB9, 0x898E72DA, 0x897B6D3E, 0x896879EA, 0x895598DF, 
    0x8942CA21, 0x89300DB2, 0x891D6397, 0x890ACBD0, 0x88F84662, 0x88E5D34F, 
    0x88D3729A, 0x88C124A3, 0x88AEE8B2, 0x889CBF28, 0x888AA807, 0x8878A352, 
    0x8866B10B, 0x8854D137, 0x884303D6, 0x883148ED, 0x881FA07E, 0x880E0A8B, 
    0x87FC8717, 0x87EB1626, 0x87D9B7B9, 0x87C86BD3, 0x87B73278, 0x87A60BA9, 
    0x8794F769, 0x8783F5BC, 0x877306A3, 0x87622A21, 0x87516039, 0x8740A8ED, 
    0x87300440, 0x871F7235, 0x870EF2CE, 0x86FE860D, 0x86EE2C49, 0x86DDE4DC, 
    0x86CDB01E, 0x86BD8E11, 0x86AD7EB7, 0x869D8212, 0x868D9826, 0x867DC0F4, 
    0x866DFC7F, 0x865E4ACA, 0x864EABD6, 0x863F1FA7, 0x862FA63E, 0x86203F9E, 
    0x8610EBCA, 0x8601AAC4, 0x85F27C8E, 0x85E3612A, 0x85D4589B, 0x85C562E3, 
    0x85B68004, 0x85A7B002, 0x8598F2DD, 0x858A4899, 0x857BB137, 0x856D2CBA, 
    0x855EBB24, 0x85505C77, 0x854210FE, 0x8533D82A, 0x8525B246, 0x85179F54, 
    0x85099F56, 0x84FBB24F, 0x84EDD840, 0x84E0112B, 0x84D25D14, 0x84C4BBFC, 
    0x84B72DE4, 0x84A9B2D0, 0x849C4AC0, 0x848EF5B8, 0x8481B3BA, 0x847484C6, 
    0x846768E0, 0x845A600A, 0x844D6A45, 0x84408793, 0x8433B7F7, 0x8426FB72, 
    0x841A5206, 0x840DBBB6, 0x84013883, 0x83F4C86F, 0x83E86B7C, 0x83DC21EA, 
    0x83CFEB3F, 0x83C3C7BB, 0x83B7B75F, 0x83ABBA2D, 0x839FD028, 0x8393F951, 
    0x838835AA, 0x837C8535, 0x8370E7F4, 0x83655DE8, 0x8359E713, 0x834E8377, 
    0x83433316, 0x8337F5F1, 0x832CCC0A, 0x8321B564, 0x8316B1FF, 0x830BC1DD, 
    0x8300E501, 0x82F61B6B, 0x82EB651D, 0x82E0C21A, 0x82D63262, 0x82CBB5F7, 
    0x82C14CDC, 0x82B6F710, 0x82ACB497, 0x82A285A5, 0x829869D5, 0x828E615B, 
    0x82846C39, 0x827A8A72, 0x8270BC06, 0x826700F7, 0x825D5946, 0x8253C4F5, 
    0x824A4405, 0x8240D679, 0x82377C50, 0x822E358E, 0x82250232, 0x821BE240, 
    0x8212D5B7, 0x8209DC99, 0x8200F6E9, 0x81F824A6, 0x81EF65D3, 0x81E6BA71, 
    0x81DE2281, 0x81D59E05, 0x81CD2CFE, 0x81C4CF6C, 0x81BC8552, 0x81B44EB1, 
    0x81AC2BB3, 0x81A41C07, 0x819C1FD7, 0x81943725, 0x818C61F2, 0x8184A03E, 
    0x817CF20D, 0x8175575D, 0x816DD032, 0x81665C8B, 0x815EFC6A, 0x8157AFD1, 
    0x815076C0, 0x81495138, 0x81423F3A, 0x813B40C8, 0x813455E3, 0x812D7E8C, 
    0x8126BAC3, 0x81200A8A, 0x81196DE2, 0x8112E4CC, 0x810C6F48, 0x81060D59, 
    0x80FFBEFE, 0x80F98439, 0x80F35D0B, 0x80ED4994, 0x80E74996, 0x80E15D31, 
    0x80DB8468, 0x80D5BF39, 0x80D00DA7, 0x80CA6FB2, 0x80C4E55B, 0x80BF6EA3, 
    0x80BA0B8B, 0x80B4BC13, 0x80AF803D, 0x80AA5808, 0x80A54377, 0x80A0428A, 
    0x809B5541, 0x80967B9E, 0x8091B5A0, 0x808D034A, 0x8088649A, 0x8083D994, 
    0x807F6236, 0x807AFE81, 0x8076AE77, 0x80727218, 0x806E4965, 0x806A345E, 
    0x80663303, 0x8062456A, 0x805E6B6B, 0x805AA51B, 0x8056F27A, 0x80535388, 
    0x804FC848, 0x804C50B8, 0x8048ECD9, 0x80459CAD, 0x80426033, 0x803F376C, 
    0x803C2259, 0x803920FA, 0x8036334F, 0x80335959, 0x80309318, 0x802DE08E, 
    0x802B41B9, 0x8028B69B, 0x80263F34, 0x8023DB84, 0x80218B8C, 0x801F4F4D, 
    0x801D26C5, 0x801B11F7, 0x801910E1, 0x80172385, 0x801549EC, 0x80138403, 
    0x8011D1D4, 0x80103360, 0x800EA8A7, 0x800D31A8, 0x800BCE65, 0x800A7EDE, 
    0x80094312, 0x80081B02, 0x800706AD, 0x80060616, 0x8005193A, 0x8004401B, 
    0x80037AB8, 0x8002C912, 0x80022B29, 0x8001A0FD, 0x80012A8E, 0x8000C7DC, 
    0x800078E8, 0x80003DB0, 0x80001636, 0x80000279
};

const int32_t sine_512[] = {
    0xFFCDBC0C, 0xFF693440, 0xFF04ACD1, 0xFEA025FE, 0xFE3BA003, 0xFDD71B21, 
    0xFD72978F, 0xFD0E1595, 0xFCA9956C, 0xFC45174E, 0xFBE09B85, 0xFB7C223F, 
    0xFB17ABC2, 0xFAB33854, 0xFA4EC823, 0xF9EA5B74, 0xF985F28F, 0xF9218DA0, 
    0xF8BD2CEF, 0xF858D0BF, 0xF7F47940, 0xF79026B8, 0xF72BD964, 0xF6C79182, 
    0xF6634F60, 0xF5FF131C, 0xF59ADD04, 0xF536AD55, 0xF4D2844E, 0xF46E622B, 
    0xF40A473C, 0xF3A6339D, 0xF342279C, 0xF2DE2378, 0xF27A276D, 0xF21633BA, 
    0xF1B248AC, 0xF14E6661, 0xF0EA8D26, 0xF086BD38, 0xF022F6D7, 0xEFBF3A3E, 
    0xEF5B87BC, 0xEEF7DF5E, 0xEE9441A2, 0xEE30AEA4, 0xEDCD2684, 0xED69A9BC, 
    0xED06384C, 0xECA2D2B1, 0xEC3F78E7, 0xEBDC2B6D, 0xEB78EA5E, 0xEB15B5DA, 
    0xEAB28E5C, 0xEA4F73E3, 0xE9EC66EA, 0xE989678F, 0xE92675F0, 0xE8C39289, 
    0xE860BD57, 0xE7FDF6D8, 0xE79B3F08, 0xE7389663, 0xE6D5FD08, 0xE6737313, 
    0xE610F900, 0xE5AE8ECC, 0xE54C34F4, 0xE4E9EB95, 0xE487B2CC, 0xE4258B13, 
    0xE3C3746A, 0xE3616F4C, 0xE2FF7BB5, 0xE29D9A21, 0xE23BCAAE, 0xE1DA0D78, 
    0xE17862F9, 0xE116CB31, 0xE0B54699, 0xE053D54F, 0xDFF2776F, 0xDF912D55, 
    0xDF2FF77A, 0xDECED59F, 0xDE6DC83D, 0xDE0CCFCE, 0xDDABEC13, 0xDD4B1D85, 
    0xDCEA645F, 0xDC89C11C, 0xDC29337A, 0xDBC8BBF4, 0xDB685B03, 0xDB081067, 
    0xDAA7DC98, 0xDA47BFD3, 0xD9E7BA8F, 0xD987CC8E, 0xD927F647, 0xD8C83834, 
    0xD8689215, 0xD8090462, 0xD7A98F92, 0xD74A3368, 0xD6EAF05A, 0xD68BC6A4, 
    0xD62CB6BD, 0xD5CDC065, 0xD56EE416, 0xD5102244, 0xD4B17AB2, 0xD452EDD8, 
    0xD3F47BEE, 0xD396256B, 0xD337EA13, 0xD2D9CA59, 0xD27BC6B6, 0xD21DDEEA, 
    0xD1C0136B, 0xD1626475, 0xD104D27B, 0xD0A75D40, 0xD04A053A, 0xCFECCADE, 
    0xCF8FADEE, 0xCF32AEDF, 0xCED5CE26, 0xCE790B85, 0xCE1C6772, 0xCDBFE225, 
    0xCD637C11, 0xCD0734FC, 0xCCAB0D57, 0xCC4F0597, 0xCBF31D7F, 0xCB975583, 
    0xCB3BADDB, 0xCAE026F9, 0xCA84C0A3, 0xCA297B4A, 0xC9CE5760, 0xC97354AB, 
    0xC918739C, 0xC8BDB46B, 0xC863178A, 0xC8089CBD, 0xC7AE4476, 0xC7540F26, 
    0xC6F9FC92, 0xC6A00D2B, 0xC6464161, 0xC5EC98FA, 0xC5931465, 0xC539B3DB, 
    0xC4E077CB, 0xC4875FFB, 0xC42E6CDA, 0xC3D59ED7, 0xC37CF5B9, 0xC32471EF, 
    0xC2CC13AF, 0xC273DB68, 0xC21BC8E0, 0xC1C3DC86, 0xC16C168F, 0xC1147733, 
    0xC0BCFF15, 0xC065AD8E, 0xC00E8343, 0xBFB7806A, 0xBF60A537, 0xBF09F1E2, 
    0xBEB3669E, 0xBE5D0411, 0xBE06C992, 0xBDB0B7C6, 0xBD5ACEE0, 0xBD050F17, 
    0xBCAF789F, 0xBC5A0BAD, 0xBC04C8E2, 0xBBAFAF9A, 0xBB5AC075, 0xBB05FBA9, 
    0xBAB16169, 0xBA5CF1E9, 0xBA08ADCA, 0xB9B49467, 0xB960A662, 0xB90CE3EC, 
    0xB8B94D3B, 0xB865E281, 0xB812A3F2, 0xB7BF922B, 0xB76CAC8B, 0xB719F3B1, 
    0xB6C767CE, 0xB6750916, 0xB622D7BB, 0xB5D0D3F0, 0xB57EFE51, 0xB52D563E, 
    0xB4DBDC53, 0xB48A90C2, 0xB43973BC, 0xB3E88575, 0xB397C61E, 0xB347364F, 
    0xB2F6D56D, 0xB2A6A410, 0xB256A269, 0xB206D0AB, 0xB1B72F05, 0xB167BDAA, 
    0xB1187D2E, 0xB0C96CFA, 0xB07A8DA3, 0xB02BDF59, 0xAFDD624E, 0xAF8F16B1, 
    0xAF40FCB2, 0xAEF314E6, 0xAEA55EB6, 0xAE57DAB4, 0xAE0A8911, 0xADBD69FD, 
    0xAD707DA7, 0xAD23C43E, 0xACD73E54, 0xAC8AEB53, 0xAC3ECBCF, 0xABF2DFF4, 
    0xABA727F2, 0xAB5BA3F7, 0xAB105493, 0xAAC53933, 0xAA7A5266, 0xAA2FA05B, 
    0xA9E5233E, 0xA99ADB3F, 0xA950C88B, 0xA906EBAE, 0xA8BD4418, 0xA873D257, 
    0xA82A9696, 0xA7E19104, 0xA798C1CD, 0xA750291E, 0xA707C780, 0xA6BF9C67, 
    0xA677A85C, 0xA62FEB8C, 0xA5E86623, 0xA5A1184C, 0xA55A0235, 0xA5132462, 
    0xA4CC7E4B, 0xA4861076, 0xA43FDB0E, 0xA3F9DE40, 0xA3B41A35, 0xA36E8F19, 
    0xA3293D6F, 0xA2E424B1, 0xA29F4563, 0xA25A9FAE, 0xA21633BD, 0xA1D201BB, 
    0xA18E09D1, 0xA14A4C7F, 0xA106C943, 0xA0C3809D, 0xA08072B5, 0xA03D9FB7, 
    0x9FFB07CA, 0x9FB8AB6C, 0x9F768A1D, 0x9F34A45B, 0x9EF2FA4F, 0x9EB18C20, 
    0x9E7059F7, 0x9E2F63FC, 0x9DEEAAAA, 0x9DAE2D84, 0x9D6DED04, 0x9D2DE951, 
    0x9CEE2294, 0x9CAE98F3, 0x9C6F4C97, 0x9C303DF5, 0x9BF16C94, 0x9BB2D8EB, 
    0x9B748322, 0x9B366B5E, 0x9AF891C6, 0x9ABAF680, 0x9A7D9A00, 0x9A407BD0, 
    0x9A039C62, 0x99C6FBDE, 0x998A9A69, 0x994E7827, 0x9912953E, 0x98D6F21E, 
    0x989B8E55, 0x98606A53, 0x9825863C, 0x97EAE236, 0x97B07E63, 0x97765AE9, 
    0x973C7834, 0x9702D5D5, 0x96C9743A, 0x96905385, 0x965773DA, 0x961ED55C, 
    0x95E6782E, 0x95AE5CBA, 0x95768293, 0x953EEA24, 0x95079390, 0x94D07EF7, 
    0x9499AC7D, 0x94631C88, 0x942CCEAF, 0x93F6C359, 0x93C0FAA7, 0x938B74BB, 
    0x935631B6, 0x932131B8, 0x92EC74E3, 0x92B7FB56, 0x9283C532, 0x924FD298, 
    0x921C242A, 0x91E8B901, 0x91B591C2, 0x9182AE8B, 0x91500F7C, 0x911DB4B3, 
    0x90EB9E52, 0x90B9CC75, 0x90883F3C, 0x9056F6C5, 0x9025F32F, 0x8FF53499, 
    0x8FC4BB1F, 0x8F94875A, 0x8F649874, 0x8F34EF03, 0x8F058B26, 0x8ED66CFA, 
    0x8EA7949D, 0x8E79022A, 0x8E4AB5BE, 0x8E1CAF77, 0x8DEEEF70, 0x8DC175C6, 
    0x8D944295, 0x8D6755F9, 0x8D3AB00D, 0x8D0E515D, 0x8CE23924, 0x8CB667ED, 
    0x8C8ADDD4, 0x8C5F9AF3, 0x8C349F65, 0x8C09EB45, 0x8BDF7EAC, 0x8BB559B6, 
    0x8B8B7C7C, 0x8B61E718, 0x8B3899A4, 0x8B0F9438, 0x8AE6D6EF, 0x8ABE6249, 
    0x8A96358F, 0x8A6E5142, 0x8A46B57C, 0x8A1F6253, 0x89F857E2, 0x89D1963E, 
    0x89AB1D82, 0x8984EDC3, 0x895F071B, 0x8939699F, 0x89141569, 0x88EF0A8D, 
    0x88CA4924, 0x88A5D1A0, 0x8881A35E, 0x885DBED3, 0x883A2413, 0x8816D335, 
    0x87F3CC4E, 0x87D10F75, 0x87AE9CBF, 0x878C7440, 0x876A960F, 0x8749023F, 
    0x8727B8E6, 0x8706BA18, 0x86E6063D, 0x86C59CC1, 0x86A57E0E, 0x8685AA35, 
    0x8666214C, 0x8646E366, 0x8627F095, 0x860948ED, 0x85EAEC81, 0x85CCDB64, 
    0x85AF15A7, 0x85919B5F, 0x85746C9B, 0x85578970, 0x853AF236, 0x851EA66F, 
    0x8502A673, 0x84E6F256, 0x84CB8A28, 0x84B06DF9, 0x84959DDB, 0x847B19DE, 
    0x8460E213, 0x8446F689, 0x842D5751, 0x8414047A, 0x83FAFE15, 0x83E24430, 
    0x83C9D718, 0x83B1B660, 0x8399E257, 0x83825B09, 0x836B2087, 0x835432DE, 
    0x833D921C, 0x83273E4F, 0x83113786, 0x82FB7DCD, 0x82E61132, 0x82D0F1C3, 
    0x82BC1F8C, 0x82A79ACE, 0x8293632D, 0x827F78EA, 0x826BDC12, 0x82588CB1, 
    0x82458AD3, 0x8232D682, 0x82206FCC, 0x820E56BB, 0x81FC8B5A, 0x81EB0DB4, 
    0x81D9DDD5, 0x81C8FBC6, 0x81B86793, 0x81A8216E, 0x8198290E, 0x81887EA8, 
    0x81792245, 0x816A13EE, 0x815B53AD, 0x814CE18A, 0x813EBD90, 0x8130E7C6, 
    0x81236034, 0x811626E4, 0x81093BDE, 0x80FC9F29, 0x80F050CD, 0x80E450F0, 
    0x80D89F5D, 0x80CD3C39, 0x80C2278B, 0x80B7615B, 0x80ACE9AE, 0x80A2C08C, 
    0x8098E5FB, 0x808F5A00, 0x80861CA2, 0x807D2DE6, 0x80748DD2, 0x806C3C6C, 
    0x806439CB, 0x805C85CD, 0x8055208B, 0x804E0A09, 0x8047424D, 0x8040C959, 
    0x803A9F33, 0x8034C3DD, 0x802F375C, 0x8029F9B3, 0x80250AE5, 0x80206AF5, 
    0x801C19E7, 0x801817BC, 0x80146480, 0x80110023, 0x800DEAB0, 0x800B242A, 
    0x8008AC92, 0x800683EA, 0x8004AA33, 0x80031F6E, 0x8001E39C, 0x8000F6BE, 
    0x800058D4, 0x800009DF
};

const int32_t sine_256[] ICONST_ATTR_WMAPRO_WIN_VS_TMP = {
    0xFF9B781E, 0xFED26950, 0xFE095D6B, 0xFD40565E, 0xFC775617, 0xFBAE5E8D, 
    0xFAE571A2, 0xFA1C9157, 0xF953BF94, 0xF88AFE40, 0xF7C24F61, 0xF6F9B4C9, 
    0xF6313075, 0xF568C463, 0xF4A07264, 0xF3D83C74, 0xF3102493, 0xF2482C8D, 
    0xF1805660, 0xF0B8A409, 0xEFF11756, 0xEF29B241, 0xEE6276B8, 0xED9B66A5, 
    0xECD48414, 0xEC0DD0B0, 0xEB474E83, 0xEA80FF77, 0xE9BAE575, 0xE8F50266, 
    0xE82F5851, 0xE769E8E0, 0xE6A4B619, 0xE5DFC1E2, 0xE51B0E22, 0xE4569CBE, 
    0xE3926FB9, 0xE2CE88BA, 0xE20AE9C3, 0xE14794B7, 0xE0848B77, 0xDFC1CFE5, 
    0xDEFF6401, 0xDE3D494C, 0xDD7B8223, 0xDCBA1024, 0xDBF8F4F0, 0xDB3832DF, 
    0xDA77CB50, 0xD9B7C09B, 0xD8F8141D, 0xD838C82A, 0xD779DE5D, 0xD6BB5850, 
    0xD5FD3854, 0xD53F7FC3, 0xD48230EB, 0xD3C54D62, 0xD308D6BE, 0xD24CCF4A, 
    0xD191385B, 0xD0D6143A, 0xD01B643D, 0xCF612AA7, 0xCEA76907, 0xCDEE20EF, 
    0xCD35549C, 0xCC7D0561, 0xCBC5357A, 0xCB0DE672, 0xCA5719D3, 0xC9A0D1D4, 
    0xC8EB0FC4, 0xC835D5D6, 0xC7812556, 0xC6CD0075, 0xC61968B6, 0xC5665F9C, 
    0xC4B3E751, 0xC402011C, 0xC350AF27, 0xC29FF2EC, 0xC1EFCDEA, 0xC140420A, 
    0xC091516E, 0xBFE2FCE5, 0xBF35468E, 0xBE883082, 0xBDDBBB92, 0xBD2FE9D5, 
    0xBC84BCF2, 0xBBDA36FD, 0xBB3058C1, 0xBA87244E, 0xB9DE9BB0, 0xB936BFB2, 
    0xB88F925B, 0xB7E9154A, 0xB7434A82, 0xB69E32C9, 0xB5F9D020, 0xB5562485, 
    0xB4B330BC, 0xB410F6BE, 0xB36F7882, 0xB2CEB6CB, 0xB22EB38A, 0xB18F704B, 
    0xB0F0EEFC, 0xB0533059, 0xAFB6364E, 0xAF1A02C1, 0xAE7E966C, 0xADE3F332, 
    0xAD4A1A92, 0xACB10E67, 0xAC18CF69, 0xAB815F71, 0xAAEAC054, 0xAA54F2C6, 
    0xA9BFF898, 0xA92BD33C, 0xA898847A, 0xA8060D04, 0xA7746EA1, 0xA6E3AB14, 
    0xA653C30A, 0xA5C4B842, 0xA5368C78, 0xA4A94055, 0xA41CD591, 0xA3914D86, 
    0xA306A9E5, 0xA27CEB53, 0xA1F4137C, 0xA16C2408, 0xA0E51D9A, 0xA05F01D6, 
    0x9FD9D207, 0x9F558FC8, 0x9ED23BB9, 0x9E4FD771, 0x9DCE6485, 0x9D4DE38E, 
    0x9CCE561E, 0x9C4FBD6E, 0x9BD21B06, 0x9B556F7D, 0x9AD9BC57, 0x9A5F0312, 
    0x99E54441, 0x996C815F, 0x98F4BBE2, 0x987DF458, 0x98082C35, 0x97936499, 
    0x971F9EEF, 0x96ACDBC0, 0x963B1C73, 0x95CA6267, 0x955AAE23, 0x94EC0102, 
    0x947E5C15, 0x9411C0B1, 0x93A62F56, 0x933BA954, 0x92D22FB1, 0x9269C372, 
    0x9202661A, 0x919C17A3, 0x9136D98D, 0x90D2ACD1, 0x906F9266, 0x900D8B42, 
    0x8FAC9856, 0x8F4CBB0B, 0x8EEDF358, 0x8E9042A4, 0x8E33A9D4, 0x8DD829CE, 
    0x8D7DC372, 0x8D2477A1, 0x8CCC47A6, 0x8C75337A, 0x8C1F3C65, 0x8BCA633B, 
    0x8B76A8CE, 0x8B240DEB, 0x8AD293C7, 0x8A823A59, 0x8A3302D2, 0x89E4EDF5, 
    0x8997FC81, 0x894C2F36, 0x890186CE, 0x88B8045E, 0x886FA7E0, 0x88287266, 
    0x87E2649F, 0x879D7F37, 0x8759C2D9, 0x8717302D, 0x86D5C827, 0x86958AC5, 
    0x865678F8, 0x8618935B, 0x85DBDA87, 0x85A04F13, 0x8565F192, 0x852CC2DA, 
    0x84F4C2E8, 0x84BDF28F, 0x84885258, 0x8453E2C5, 0x8420A459, 0x83EE9791, 
    0x83BDBD27, 0x838E1518, 0x835FA016, 0x83325E96, 0x83065106, 0x82DB77D4, 
    0x82B1D369, 0x8289645F, 0x82622AB2, 0x823C26F8, 0x8217598E, 0x81F3C2CF, 
    0x81D16313, 0x81B03AAE, 0x81904A1B, 0x81719157, 0x815410D7, 0x8137C8E4, 
    0x811CB9C4, 0x8102E3B9, 0x80EA4722, 0x80D2E3FC, 0x80BCBAA3, 0x80A7CB4B, 
    0x8094162A, 0x80819B6F, 0x80705B49, 0x806055F5, 0x80518B72, 0x8043FBFA, 
    0x8037A7AE, 0x802C8EAD, 0x8022B111, 0x801A0EF5, 0x8012A874, 0x800C7D90, 
    0x80078E60, 0x8003DAF2, 0x8001634E, 0x8000277B
};

const int32_t sine_128[] ICONST_ATTR = {
    0xFF36F079, 0xFDA4D929, 0xFC12D91C, 0xFA80FFCF, 0xF8EF5CBC, 0xF75DFF6C, 
    0xF5CCF73F, 0xF43C53CB, 0xF2AC2474, 0xF11C7895, 0xEF8D5FC8, 0xEDFEE931, 
    0xEC71244A, 0xEAE4208A, 0xE957ED00, 0xE7CC9912, 0xE642341D, 0xE4B8CD16, 
    0xE3307348, 0xE1A935F1, 0xE02323EA, 0xDE9E4C5B, 0xDD1ABE41, 0xDB98888E, 
    0xDA17BA63, 0xD898621B, 0xD71A8EBA, 0xD59E4EF9, 0xD423B181, 0xD2AAC4EB, 
    0xD13397FA, 0xCFBE38AD, 0xCE4AB5A6, 0xCCD91D38, 0xCB697DA1, 0xC9FBE50E, 
    0xC89061D1, 0xC727017A, 0xC5BFD232, 0xC45AE1D1, 0xC2F83E1B, 0xC197F4BB, 
    0xC03A137E, 0xBEDEA73A, 0xBD85BE33, 0xBC2F6544, 0xBADBA934, 0xB98A97F6, 
    0xB83C3DB0, 0xB6F0A81D, 0xB5A7E331, 0xB461FC6A, 0xB31EFFF0, 0xB1DEF9D2, 
    0xB0A1F730, 0xAF68037B, 0xAE312B94, 0xACFD7B13, 0xABCCFD75, 0xAA9FBF37, 
    0xA975CB39, 0xA84F2DB4, 0xA72BF147, 0xA60C21E8, 0xA4EFCA51, 0xA3D6F51F, 
    0xA2C1ADDA, 0xA1AFFE80, 0xA0A1F24E, 0x9F979356, 0x9E90EB88, 0x9D8E05AD, 
    0x9C8EEB1A, 0x9B93A649, 0x9A9C4048, 0x99A8C33F, 0x98B93843, 0x97CDA844, 
    0x96E61CED, 0x96029E99, 0x9523369D, 0x9447ED4D, 0x9370CADA, 0x929DD7D5, 
    0x91CF1CE2, 0x9104A0F4, 0x903E6C5C, 0x8F7C873A, 0x8EBEF810, 0x8E05C6AA, 
    0x8D50FA2B, 0x8CA099FB, 0x8BF4AC06, 0x8B4D375E, 0x8AAA42E0, 0x8A0BD402, 
    0x8971F14B, 0x88DCA0A9, 0x884BE838, 0x87BFCCD4, 0x87385443, 0x86B5840D, 
    0x86376099, 0x85BDEF18, 0x85493481, 0x84D934C0, 0x846DF472, 0x840777B8, 
    0x83A5C2C5, 0x8348D8DF, 0x82F0BDDB, 0x829D7552, 0x824F0211, 0x82056753, 
    0x81C0A7F0, 0x8180C6B5, 0x8145C5C8, 0x810FA798, 0x80DE6E59, 0x80B21BB4, 
    0x808AB17D, 0x8068313B, 0x804A9C52, 0x8031F3C2, 0x801E3892, 0x800F6B8C, 
    0x80058D30, 0x80009DEA
};

const int32_t *sine_windows[6] = {
    sine_128, sine_256, sine_512, sine_1024, sine_2048, sine_4096
};


/* mdct trig table. 
   the table should be in s.31 format, but in wma pro, all the tables are scaled
   down to preserve energy in the signal, so this downscaling is equivalent to 
   having the tables in ~s15.16 instead. */
/* rockbox: not used
const int32_t sincos_lookup_wmap[8064] = {
    0x0000011C, 0x00016A09, 0x000009FE, 0x000169E6, 
    0x000012DF, 0x0001698B, 0x00001BBD, 0x000168F9, 
    0x00002497, 0x0001682F, 0x00002D6B, 0x0001672D, 
    0x00003638, 0x000165F4, 0x00003EFD, 0x00016484, 
    0x000047B8, 0x000162DD, 0x00005068, 0x000160FF, 
    0x0000590B, 0x00015EEA, 0x000061A1, 0x00015CA0, 
    0x00006A28, 0x00015A20, 0x0000729E, 0x0001576A, 
    0x00007B03, 0x0001547F, 0x00008354, 0x00015160, 
    0x00008B92, 0x00014E0D, 0x000093BA, 0x00014A87, 
    0x00009BCB, 0x000146CD, 0x0000A3C4, 0x000142E1, 
    0x0000ABA4, 0x00013EC3, 0x0000B369, 0x00013A74, 
    0x0000BB13, 0x000135F5, 0x0000C2A0, 0x00013146, 
    0x0000CA0F, 0x00012C67, 0x0000D15F, 0x0001275B, 
    0x0000D88E, 0x00012221, 0x0000DF9C, 0x00011CBA, 
    0x0000E688, 0x00011727, 0x0000ED50, 0x00011169, 
    0x0000F3F3, 0x00010B81, 0x0000FA71, 0x00010570, 
    0x000100C8, 0x0000FF36, 0x000106F8, 0x0000F8D5, 
    0x00010CFF, 0x0000F24E, 0x000112DC, 0x0000EBA1, 
    0x00011890, 0x0000E4D0, 0x00011E18, 0x0000DDDC, 
    0x00012373, 0x0000D6C5, 0x000128A2, 0x0000CF8E, 
    0x00012DA3, 0x0000C836, 0x00013276, 0x0000C0C0, 
    0x00013719, 0x0000B92B, 0x00013B8D, 0x0000B17B, 
    0x00013FCF, 0x0000A9AE, 0x000143E1, 0x0000A1C8, 
    0x000147C0, 0x000099C9, 0x00014B6D, 0x000091B2, 
    0x00014EE7, 0x00008984, 0x0001522D, 0x00008142, 
    0x0001553F, 0x000078EB, 0x0001581C, 0x00007082, 
    0x00015AC5, 0x00006807, 0x00015D38, 0x00005F7D, 
    0x00015F75, 0x000056E3, 0x0001617B, 0x00004E3D, 
    0x0001634C, 0x0000458A, 0x000164E5, 0x00003CCC, 
    0x00016648, 0x00003405, 0x00016773, 0x00002B36, 
    0x00016867, 0x00002261, 0x00016923, 0x00001986, 
    0x000169A7, 0x000010A7, 0x000169F4, 0x000007C6, 
    0x00000064, 0x0000FFFF, 0x00000388, 0x0000FFF9, 
    0x000006AC, 0x0000FFE9, 0x000009D0, 0x0000FFCF, 
    0x00000CF4, 0x0000FFAC, 0x00001017, 0x0000FF7E, 
    0x00001339, 0x0000FF46, 0x0000165A, 0x0000FF05, 
    0x0000197B, 0x0000FEBA, 0x00001C9B, 0x0000FE65, 
    0x00001FBA, 0x0000FE06, 0x000022D7, 0x0000FD9E, 
    0x000025F3, 0x0000FD2B, 0x0000290E, 0x0000FCAF, 
    0x00002C27, 0x0000FC29, 0x00002F3E, 0x0000FB9A, 
    0x00003254, 0x0000FB01, 0x00003567, 0x0000FA5E, 
    0x00003879, 0x0000F9B1, 0x00003B88, 0x0000F8FB, 
    0x00003E95, 0x0000F83B, 0x000041A0, 0x0000F772, 
    0x000044A8, 0x0000F69F, 0x000047AD, 0x0000F5C2, 
    0x00004AB0, 0x0000F4DC, 0x00004DB0, 0x0000F3ED, 
    0x000050AC, 0x0000F2F4, 0x000053A6, 0x0000F1F2, 
    0x0000569D, 0x0000F0E7, 0x00005990, 0x0000EFD2, 
    0x00005C7F, 0x0000EEB4, 0x00005F6B, 0x0000ED8D, 
    0x00006254, 0x0000EC5C, 0x00006539, 0x0000EB23, 
    0x00006819, 0x0000E9E0, 0x00006AF6, 0x0000E895, 
    0x00006DCF, 0x0000E740, 0x000070A3, 0x0000E5E3, 
    0x00007373, 0x0000E47D, 0x0000763F, 0x0000E30D, 
    0x00007906, 0x0000E196, 0x00007BC8, 0x0000E015, 
    0x00007E86, 0x0000DE8C, 0x0000813E, 0x0000DCFA, 
    0x000083F2, 0x0000DB60, 0x000086A1, 0x0000D9BD, 
    0x0000894A, 0x0000D812, 0x00008BEE, 0x0000D65F, 
    0x00008E8D, 0x0000D4A3, 0x00009126, 0x0000D2DF, 
    0x000093BA, 0x0000D113, 0x00009648, 0x0000CF3F, 
    0x000098D0, 0x0000CD63, 0x00009B52, 0x0000CB7F, 
    0x00009DCF, 0x0000C993, 0x0000A045, 0x0000C79F, 
    0x0000A2B5, 0x0000C5A4, 0x0000A51F, 0x0000C3A1, 
    0x0000A782, 0x0000C196, 0x0000A9DF, 0x0000BF84, 
    0x0000AC35, 0x0000BD6B, 0x0000AE85, 0x0000BB4A, 
    0x0000B0CE, 0x0000B922, 0x0000B310, 0x0000B6F3, 
    0x0000B54B, 0x0000B4BD, 0x0000B780, 0x0000B280, 
    0x0000B9AD, 0x0000B03C, 0x0000BBD3, 0x0000ADF2, 
    0x0000BDF2, 0x0000ABA0, 0x0000C009, 0x0000A948, 
    0x0000C21A, 0x0000A6EA, 0x0000C422, 0x0000A485, 
    0x0000C623, 0x0000A219, 0x0000C81D, 0x00009FA8, 
    0x0000CA0E, 0x00009D30, 0x0000CBF8, 0x00009AB2, 
    0x0000CDDA, 0x0000982E, 0x0000CFB4, 0x000095A5, 
    0x0000D187, 0x00009315, 0x0000D351, 0x00009080, 
    0x0000D512, 0x00008DE6, 0x0000D6CC, 0x00008B46, 
    0x0000D87E, 0x000088A0, 0x0000DA27, 0x000085F5, 
    0x0000DBC7, 0x00008345, 0x0000DD5F, 0x00008090, 
    0x0000DEEF, 0x00007DD7, 0x0000E076, 0x00007B18, 
    0x0000E1F4, 0x00007854, 0x0000E36A, 0x0000758C, 
    0x0000E4D7, 0x000072BF, 0x0000E63B, 0x00006FEE, 
    0x0000E796, 0x00006D19, 0x0000E8E9, 0x00006A3F, 
    0x0000EA32, 0x00006761, 0x0000EB72, 0x00006480, 
    0x0000ECA9, 0x0000619A, 0x0000EDD7, 0x00005EB1, 
    0x0000EEFC, 0x00005BC4, 0x0000F018, 0x000058D3, 
    0x0000F12A, 0x000055DF, 0x0000F233, 0x000052E8, 
    0x0000F333, 0x00004FED, 0x0000F42A, 0x00004CF0, 
    0x0000F517, 0x000049EF, 0x0000F5FA, 0x000046EC, 
    0x0000F6D4, 0x000043E6, 0x0000F7A5, 0x000040DD, 
    0x0000F86C, 0x00003DD2, 0x0000F929, 0x00003AC4, 
    0x0000F9DD, 0x000037B4, 0x0000FA87, 0x000034A2, 
    0x0000FB28, 0x0000318E, 0x0000FBBF, 0x00002E78, 
    0x0000FC4C, 0x00002B61, 0x0000FCCF, 0x00002847, 
    0x0000FD49, 0x0000252C, 0x0000FDB9, 0x00002210, 
    0x0000FE1F, 0x00001EF2, 0x0000FE7B, 0x00001BD3, 
    0x0000FECE, 0x000018B3, 0x0000FF16, 0x00001592, 
    0x0000FF55, 0x00001270, 0x0000FF8A, 0x00000F4E, 
    0x0000FFB5, 0x00000C2B, 0x0000FFD7, 0x00000907, 
    0x0000FFEE, 0x000005E3, 0x0000FFFC, 0x000002BF, 
    0x00000023, 0x0000B504, 0x0000013F, 0x0000B503, 
    0x0000025C, 0x0000B501, 0x00000378, 0x0000B4FC, 
    0x00000494, 0x0000B4F6, 0x000005B1, 0x0000B4EE, 
    0x000006CD, 0x0000B4E4, 0x000007E9, 0x0000B4D8, 
    0x00000905, 0x0000B4CB, 0x00000A21, 0x0000B4BC, 
    0x00000B3D, 0x0000B4AB, 0x00000C58, 0x0000B499, 
    0x00000D74, 0x0000B484, 0x00000E8F, 0x0000B46E, 
    0x00000FAB, 0x0000B457, 0x000010C6, 0x0000B43D, 
    0x000011E1, 0x0000B422, 0x000012FC, 0x0000B405, 
    0x00001417, 0x0000B3E6, 0x00001531, 0x0000B3C6, 
    0x0000164B, 0x0000B3A4, 0x00001765, 0x0000B380, 
    0x0000187F, 0x0000B35A, 0x00001999, 0x0000B333, 
    0x00001AB2, 0x0000B30A, 0x00001BCB, 0x0000B2DF, 
    0x00001CE4, 0x0000B2B2, 0x00001DFD, 0x0000B284, 
    0x00001F15, 0x0000B254, 0x0000202D, 0x0000B222, 
    0x00002145, 0x0000B1EF, 0x0000225C, 0x0000B1BA, 
    0x00002373, 0x0000B183, 0x0000248A, 0x0000B14B, 
    0x000025A0, 0x0000B110, 0x000026B6, 0x0000B0D4, 
    0x000027CC, 0x0000B097, 0x000028E1, 0x0000B057, 
    0x000029F6, 0x0000B016, 0x00002B0A, 0x0000AFD3, 
    0x00002C1E, 0x0000AF8F, 0x00002D31, 0x0000AF49, 
    0x00002E45, 0x0000AF01, 0x00002F57, 0x0000AEB8, 
    0x00003069, 0x0000AE6C, 0x0000317B, 0x0000AE1F, 
    0x0000328D, 0x0000ADD1, 0x0000339D, 0x0000AD81, 
    0x000034AE, 0x0000AD2F, 0x000035BD, 0x0000ACDB, 
    0x000036CD, 0x0000AC86, 0x000037DB, 0x0000AC2F, 
    0x000038EA, 0x0000ABD6, 0x000039F7, 0x0000AB7C, 
    0x00003B04, 0x0000AB20, 0x00003C11, 0x0000AAC3, 
    0x00003D1D, 0x0000AA64, 0x00003E28, 0x0000AA03, 
    0x00003F33, 0x0000A9A0, 0x0000403D, 0x0000A93C, 
    0x00004147, 0x0000A8D6, 0x0000424F, 0x0000A86F, 
    0x00004358, 0x0000A806, 0x0000445F, 0x0000A79C, 
    0x00004566, 0x0000A72F, 0x0000466D, 0x0000A6C2, 
    0x00004772, 0x0000A652, 0x00004877, 0x0000A5E1, 
    0x0000497B, 0x0000A56E, 0x00004A7F, 0x0000A4FA, 
    0x00004B82, 0x0000A484, 0x00004C84, 0x0000A40D, 
    0x00004D85, 0x0000A394, 0x00004E86, 0x0000A319, 
    0x00004F85, 0x0000A29D, 0x00005084, 0x0000A220, 
    0x00005183, 0x0000A1A0, 0x00005280, 0x0000A120, 
    0x0000537D, 0x0000A09D, 0x00005479, 0x0000A019, 
    0x00005574, 0x00009F94, 0x0000566E, 0x00009F0D, 
    0x00005767, 0x00009E84, 0x00005860, 0x00009DFA, 
    0x00005958, 0x00009D6F, 0x00005A4F, 0x00009CE2, 
    0x00005B45, 0x00009C53, 0x00005C3A, 0x00009BC3, 
    0x00005D2E, 0x00009B31, 0x00005E21, 0x00009A9E, 
    0x00005F14, 0x00009A09, 0x00006005, 0x00009973, 
    0x000060F6, 0x000098DC, 0x000061E5, 0x00009843, 
    0x000062D4, 0x000097A8, 0x000063C2, 0x0000970C, 
    0x000064AF, 0x0000966F, 0x0000659B, 0x000095D0, 
    0x00006685, 0x00009530, 0x0000676F, 0x0000948E, 
    0x00006858, 0x000093EB, 0x00006940, 0x00009346, 
    0x00006A27, 0x000092A0, 0x00006B0D, 0x000091F9, 
    0x00006BF1, 0x00009150, 0x00006CD5, 0x000090A5, 
    0x00006DB8, 0x00008FFA, 0x00006E99, 0x00008F4D, 
    0x00006F7A, 0x00008E9E, 0x00007059, 0x00008DEF, 
    0x00007138, 0x00008D3D, 0x00007215, 0x00008C8B, 
    0x000072F1, 0x00008BD7, 0x000073CC, 0x00008B22, 
    0x000074A6, 0x00008A6B, 0x0000757F, 0x000089B3, 
    0x00007657, 0x000088FA, 0x0000772E, 0x00008840, 
    0x00007803, 0x00008784, 0x000078D7, 0x000086C6, 
    0x000079AB, 0x00008608, 0x00007A7C, 0x00008548, 
    0x00007B4D, 0x00008487, 0x00007C1D, 0x000083C5, 
    0x00007CEB, 0x00008301, 0x00007DB8, 0x0000823C, 
    0x00007E84, 0x00008176, 0x00007F4F, 0x000080AF, 
    0x00008019, 0x00007FE6, 0x000080E1, 0x00007F1D, 
    0x000081A8, 0x00007E51, 0x0000826E, 0x00007D85, 
    0x00008332, 0x00007CB8, 0x000083F6, 0x00007BE9, 
    0x000084B8, 0x00007B19, 0x00008578, 0x00007A48, 
    0x00008638, 0x00007976, 0x000086F6, 0x000078A2, 
    0x000087B3, 0x000077CE, 0x0000886E, 0x000076F8, 
    0x00008928, 0x00007621, 0x000089E1, 0x00007549, 
    0x00008A99, 0x00007470, 0x00008B4F, 0x00007396, 
    0x00008C04, 0x000072BA, 0x00008CB8, 0x000071DE, 
    0x00008D6A, 0x00007100, 0x00008E1B, 0x00007022, 
    0x00008ECA, 0x00006F42, 0x00008F78, 0x00006E61, 
    0x00009025, 0x00006D7F, 0x000090D0, 0x00006C9C, 
    0x0000917A, 0x00006BB8, 0x00009223, 0x00006AD3, 
    0x000092CA, 0x000069ED, 0x0000936F, 0x00006906, 
    0x00009414, 0x0000681E, 0x000094B6, 0x00006735, 
    0x00009558, 0x0000664B, 0x000095F8, 0x00006560, 
    0x00009696, 0x00006474, 0x00009733, 0x00006387, 
    0x000097CF, 0x00006299, 0x00009869, 0x000061AA, 
    0x00009902, 0x000060BA, 0x00009999, 0x00005FC9, 
    0x00009A2F, 0x00005ED7, 0x00009AC3, 0x00005DE5, 
    0x00009B56, 0x00005CF1, 0x00009BE7, 0x00005BFD, 
    0x00009C77, 0x00005B07, 0x00009D05, 0x00005A11, 
    0x00009D92, 0x0000591A, 0x00009E1D, 0x00005822, 
    0x00009EA7, 0x00005729, 0x00009F2F, 0x00005630, 
    0x00009FB5, 0x00005535, 0x0000A03A, 0x0000543A, 
    0x0000A0BE, 0x0000533E, 0x0000A140, 0x00005241, 
    0x0000A1C0, 0x00005143, 0x0000A23F, 0x00005045, 
    0x0000A2BD, 0x00004F45, 0x0000A338, 0x00004E45, 
    0x0000A3B2, 0x00004D45, 0x0000A42B, 0x00004C43, 
    0x0000A4A2, 0x00004B41, 0x0000A517, 0x00004A3E, 
    0x0000A58B, 0x0000493A, 0x0000A5FD, 0x00004836, 
    0x0000A66E, 0x00004731, 0x0000A6DD, 0x0000462B, 
    0x0000A74B, 0x00004525, 0x0000A7B6, 0x0000441D, 
    0x0000A821, 0x00004316, 0x0000A889, 0x0000420D, 
    0x0000A8F0, 0x00004104, 0x0000A955, 0x00003FFB, 
    0x0000A9B9, 0x00003EF0, 0x0000AA1B, 0x00003DE5, 
    0x0000AA7C, 0x00003CDA, 0x0000AADA, 0x00003BCE, 
    0x0000AB37, 0x00003AC1, 0x0000AB93, 0x000039B4, 
    0x0000ABED, 0x000038A6, 0x0000AC45, 0x00003798, 
    0x0000AC9B, 0x00003689, 0x0000ACF0, 0x00003579, 
    0x0000AD43, 0x0000346A, 0x0000AD95, 0x00003359, 
    0x0000ADE5, 0x00003248, 0x0000AE33, 0x00003137, 
    0x0000AE7F, 0x00003025, 0x0000AECA, 0x00002F13, 
    0x0000AF13, 0x00002E00, 0x0000AF5B, 0x00002CED, 
    0x0000AFA0, 0x00002BD9, 0x0000AFE4, 0x00002AC5, 
    0x0000B027, 0x000029B0, 0x0000B067, 0x0000289B, 
    0x0000B0A6, 0x00002786, 0x0000B0E3, 0x00002671, 
    0x0000B11F, 0x0000255A, 0x0000B159, 0x00002444, 
    0x0000B191, 0x0000232D, 0x0000B1C7, 0x00002216, 
    0x0000B1FC, 0x000020FF, 0x0000B22F, 0x00001FE7, 
    0x0000B260, 0x00001ECF, 0x0000B290, 0x00001DB7, 
    0x0000B2BE, 0x00001C9E, 0x0000B2EA, 0x00001B85, 
    0x0000B314, 0x00001A6C, 0x0000B33D, 0x00001953, 
    0x0000B364, 0x00001839, 0x0000B389, 0x0000171F, 
    0x0000B3AC, 0x00001605, 0x0000B3CE, 0x000014EB, 
    0x0000B3EE, 0x000013D0, 0x0000B40C, 0x000012B5, 
    0x0000B429, 0x0000119A, 0x0000B444, 0x0000107F, 
    0x0000B45D, 0x00000F64, 0x0000B474, 0x00000E49, 
    0x0000B489, 0x00000D2D, 0x0000B49D, 0x00000C11, 
    0x0000B4AF, 0x00000AF6, 0x0000B4C0, 0x000009DA, 
    0x0000B4CE, 0x000008BE, 0x0000B4DB, 0x000007A2, 
    0x0000B4E6, 0x00000686, 0x0000B4F0, 0x00000569, 
    0x0000B4F7, 0x0000044D, 0x0000B4FD, 0x00000331, 
    0x0000B501, 0x00000215, 0x0000B504, 0x000000F8, 
    0x0000000C, 0x00007FFF, 0x00000071, 0x00007FFF, 
    0x000000D5, 0x00007FFF, 0x0000013A, 0x00007FFE, 
    0x0000019E, 0x00007FFD, 0x00000203, 0x00007FFB, 
    0x00000267, 0x00007FFA, 0x000002CC, 0x00007FF8, 
    0x00000330, 0x00007FF5, 0x00000395, 0x00007FF3, 
    0x000003F9, 0x00007FF0, 0x0000045E, 0x00007FEC, 
    0x000004C2, 0x00007FE9, 0x00000527, 0x00007FE5, 
    0x0000058B, 0x00007FE1, 0x000005EF, 0x00007FDC, 
    0x00000654, 0x00007FD7, 0x000006B8, 0x00007FD2, 
    0x0000071D, 0x00007FCD, 0x00000781, 0x00007FC7, 
    0x000007E5, 0x00007FC1, 0x0000084A, 0x00007FBB, 
    0x000008AE, 0x00007FB4, 0x00000912, 0x00007FAD, 
    0x00000977, 0x00007FA6, 0x000009DB, 0x00007F9E, 
    0x00000A3F, 0x00007F96, 0x00000AA3, 0x00007F8E, 
    0x00000B07, 0x00007F86, 0x00000B6C, 0x00007F7D, 
    0x00000BD0, 0x00007F74, 0x00000C34, 0x00007F6A, 
    0x00000C98, 0x00007F60, 0x00000CFC, 0x00007F56, 
    0x00000D60, 0x00007F4C, 0x00000DC4, 0x00007F41, 
    0x00000E28, 0x00007F36, 0x00000E8C, 0x00007F2B, 
    0x00000EF0, 0x00007F20, 0x00000F53, 0x00007F14, 
    0x00000FB7, 0x00007F08, 0x0000101B, 0x00007EFB, 
    0x0000107F, 0x00007EEE, 0x000010E2, 0x00007EE1, 
    0x00001146, 0x00007ED4, 0x000011A9, 0x00007EC6, 
    0x0000120D, 0x00007EB8, 0x00001271, 0x00007EAA, 
    0x000012D4, 0x00007E9B, 0x00001337, 0x00007E8C, 
    0x0000139B, 0x00007E7D, 0x000013FE, 0x00007E6D, 
    0x00001461, 0x00007E5D, 0x000014C5, 0x00007E4D, 
    0x00001528, 0x00007E3D, 0x0000158B, 0x00007E2C, 
    0x000015EE, 0x00007E1B, 0x00001651, 0x00007E0A, 
    0x000016B4, 0x00007DF8, 0x00001717, 0x00007DE6, 
    0x0000177A, 0x00007DD4, 0x000017DD, 0x00007DC1, 
    0x0000183F, 0x00007DAE, 0x000018A2, 0x00007D9B, 
    0x00001905, 0x00007D87, 0x00001967, 0x00007D74, 
    0x000019CA, 0x00007D60, 0x00001A2C, 0x00007D4B, 
    0x00001A8E, 0x00007D36, 0x00001AF1, 0x00007D21, 
    0x00001B53, 0x00007D0C, 0x00001BB5, 0x00007CF6, 
    0x00001C17, 0x00007CE1, 0x00001C79, 0x00007CCA, 
    0x00001CDB, 0x00007CB4, 0x00001D3D, 0x00007C9D, 
    0x00001D9F, 0x00007C86, 0x00001E01, 0x00007C6E, 
    0x00001E62, 0x00007C57, 0x00001EC4, 0x00007C3F, 
    0x00001F26, 0x00007C26, 0x00001F87, 0x00007C0E, 
    0x00001FE9, 0x00007BF5, 0x0000204A, 0x00007BDC, 
    0x000020AB, 0x00007BC2, 0x0000210C, 0x00007BA8, 
    0x0000216D, 0x00007B8E, 0x000021CE, 0x00007B74, 
    0x0000222F, 0x00007B59, 0x00002290, 0x00007B3E, 
    0x000022F1, 0x00007B23, 0x00002352, 0x00007B07, 
    0x000023B2, 0x00007AEB, 0x00002413, 0x00007ACF, 
    0x00002473, 0x00007AB3, 0x000024D3, 0x00007A96, 
    0x00002534, 0x00007A79, 0x00002594, 0x00007A5C, 
    0x000025F4, 0x00007A3E, 0x00002654, 0x00007A20, 
    0x000026B4, 0x00007A02, 0x00002713, 0x000079E3, 
    0x00002773, 0x000079C4, 0x000027D3, 0x000079A5, 
    0x00002832, 0x00007986, 0x00002892, 0x00007966, 
    0x000028F1, 0x00007946, 0x00002950, 0x00007926, 
    0x000029AF, 0x00007905, 0x00002A0E, 0x000078E4, 
    0x00002A6D, 0x000078C3, 0x00002ACC, 0x000078A2, 
    0x00002B2B, 0x00007880, 0x00002B89, 0x0000785E, 
    0x00002BE8, 0x0000783B, 0x00002C46, 0x00007819, 
    0x00002CA4, 0x000077F6, 0x00002D02, 0x000077D3, 
    0x00002D60, 0x000077AF, 0x00002DBE, 0x0000778B, 
    0x00002E1C, 0x00007767, 0x00002E7A, 0x00007743, 
    0x00002ED8, 0x0000771E, 0x00002F35, 0x000076F9, 
    0x00002F92, 0x000076D4, 0x00002FF0, 0x000076AF, 
    0x0000304D, 0x00007689, 0x000030AA, 0x00007663, 
    0x00003107, 0x0000763C, 0x00003164, 0x00007616, 
    0x000031C0, 0x000075EF, 0x0000321D, 0x000075C8, 
    0x00003279, 0x000075A0, 0x000032D6, 0x00007578, 
    0x00003332, 0x00007550, 0x0000338E, 0x00007528, 
    0x000033EA, 0x000074FF, 0x00003446, 0x000074D6, 
    0x000034A1, 0x000074AD, 0x000034FD, 0x00007484, 
    0x00003558, 0x0000745A, 0x000035B4, 0x00007430, 
    0x0000360F, 0x00007406, 0x0000366A, 0x000073DB, 
    0x000036C5, 0x000073B0, 0x00003720, 0x00007385, 
    0x0000377A, 0x00007359, 0x000037D5, 0x0000732E, 
    0x0000382F, 0x00007302, 0x0000388A, 0x000072D5, 
    0x000038E4, 0x000072A9, 0x0000393E, 0x0000727C, 
    0x00003998, 0x0000724F, 0x000039F1, 0x00007222, 
    0x00003A4B, 0x000071F4, 0x00003AA4, 0x000071C6, 
    0x00003AFE, 0x00007198, 0x00003B57, 0x00007169, 
    0x00003BB0, 0x0000713B, 0x00003C09, 0x0000710C, 
    0x00003C61, 0x000070DC, 0x00003CBA, 0x000070AD, 
    0x00003D12, 0x0000707D, 0x00003D6B, 0x0000704D, 
    0x00003DC3, 0x0000701D, 0x00003E1B, 0x00006FEC, 
    0x00003E73, 0x00006FBB, 0x00003ECA, 0x00006F8A, 
    0x00003F22, 0x00006F58, 0x00003F79, 0x00006F27, 
    0x00003FD0, 0x00006EF5, 0x00004027, 0x00006EC2, 
    0x0000407E, 0x00006E90, 0x000040D5, 0x00006E5D, 
    0x0000412C, 0x00006E2A, 0x00004182, 0x00006DF7, 
    0x000041D8, 0x00006DC3, 0x0000422F, 0x00006D8F, 
    0x00004284, 0x00006D5B, 0x000042DA, 0x00006D27, 
    0x00004330, 0x00006CF2, 0x00004385, 0x00006CBD, 
    0x000043DB, 0x00006C88, 0x00004430, 0x00006C53, 
    0x00004485, 0x00006C1D, 0x000044DA, 0x00006BE7, 
    0x0000452E, 0x00006BB1, 0x00004583, 0x00006B7A, 
    0x000045D7, 0x00006B44, 0x0000462B, 0x00006B0D, 
    0x0000467F, 0x00006AD5, 0x000046D3, 0x00006A9E, 
    0x00004727, 0x00006A66, 0x0000477A, 0x00006A2E, 
    0x000047CE, 0x000069F6, 0x00004821, 0x000069BD, 
    0x00004874, 0x00006985, 0x000048C7, 0x0000694B, 
    0x00004919, 0x00006912, 0x0000496C, 0x000068D9, 
    0x000049BE, 0x0000689F, 0x00004A10, 0x00006865, 
    0x00004A62, 0x0000682B, 0x00004AB4, 0x000067F0, 
    0x00004B05, 0x000067B5, 0x00004B56, 0x0000677A, 
    0x00004BA8, 0x0000673F, 0x00004BF9, 0x00006703, 
    0x00004C49, 0x000066C8, 0x00004C9A, 0x0000668B, 
    0x00004CEB, 0x0000664F, 0x00004D3B, 0x00006613, 
    0x00004D8B, 0x000065D6, 0x00004DDB, 0x00006599, 
    0x00004E2A, 0x0000655C, 0x00004E7A, 0x0000651E, 
    0x00004EC9, 0x000064E0, 0x00004F18, 0x000064A2, 
    0x00004F67, 0x00006464, 0x00004FB6, 0x00006426, 
    0x00005005, 0x000063E7, 0x00005053, 0x000063A8, 
    0x000050A1, 0x00006369, 0x000050EF, 0x00006329, 
    0x0000513D, 0x000062EA, 0x0000518B, 0x000062AA, 
    0x000051D8, 0x00006269, 0x00005225, 0x00006229, 
    0x00005272, 0x000061E8, 0x000052BF, 0x000061A8, 
    0x0000530C, 0x00006166, 0x00005358, 0x00006125, 
    0x000053A4, 0x000060E4, 0x000053F0, 0x000060A2, 
    0x0000543C, 0x00006060, 0x00005488, 0x0000601D, 
    0x000054D3, 0x00005FDB, 0x0000551E, 0x00005F98, 
    0x00005569, 0x00005F55, 0x000055B4, 0x00005F12, 
    0x000055FE, 0x00005ECF, 0x00005649, 0x00005E8B, 
    0x00005693, 0x00005E47, 0x000056DD, 0x00005E03, 
    0x00005727, 0x00005DBF, 0x00005770, 0x00005D7A, 
    0x000057B9, 0x00005D35, 0x00005803, 0x00005CF0, 
    0x0000584B, 0x00005CAB, 0x00005894, 0x00005C66, 
    0x000058DD, 0x00005C20, 0x00005925, 0x00005BDA, 
    0x0000596D, 0x00005B94, 0x000059B5, 0x00005B4D, 
    0x000059FC, 0x00005B07, 0x00005A44, 0x00005AC0, 
    0x00005A8B, 0x00005A79, 0x00005AD2, 0x00005A32, 
    0x00005B19, 0x000059EA, 0x00005B5F, 0x000059A3, 
    0x00005BA5, 0x0000595B, 0x00005BEB, 0x00005913, 
    0x00005C31, 0x000058CB, 0x00005C77, 0x00005882, 
    0x00005CBC, 0x00005839, 0x00005D01, 0x000057F0, 
    0x00005D46, 0x000057A7, 0x00005D8B, 0x0000575E, 
    0x00005DD0, 0x00005714, 0x00005E14, 0x000056CA, 
    0x00005E58, 0x00005680, 0x00005E9C, 0x00005636, 
    0x00005EDF, 0x000055EC, 0x00005F23, 0x000055A1, 
    0x00005F66, 0x00005556, 0x00005FA9, 0x0000550B, 
    0x00005FEC, 0x000054C0, 0x0000602E, 0x00005475, 
    0x00006070, 0x00005429, 0x000060B2, 0x000053DD, 
    0x000060F4, 0x00005391, 0x00006135, 0x00005345, 
    0x00006177, 0x000052F8, 0x000061B8, 0x000052AC, 
    0x000061F9, 0x0000525F, 0x00006239, 0x00005212, 
    0x0000627A, 0x000051C5, 0x000062BA, 0x00005177, 
    0x000062F9, 0x0000512A, 0x00006339, 0x000050DC, 
    0x00006378, 0x0000508E, 0x000063B8, 0x00005040, 
    0x000063F7, 0x00004FF1, 0x00006435, 0x00004FA2, 
    0x00006474, 0x00004F54, 0x000064B2, 0x00004F05, 
    0x000064F0, 0x00004EB6, 0x0000652D, 0x00004E66, 
    0x0000656B, 0x00004E17, 0x000065A8, 0x00004DC7, 
    0x000065E5, 0x00004D77, 0x00006622, 0x00004D27, 
    0x0000665E, 0x00004CD6, 0x0000669B, 0x00004C86, 
    0x000066D6, 0x00004C35, 0x00006712, 0x00004BE4, 
    0x0000674E, 0x00004B93, 0x00006789, 0x00004B42, 
    0x000067C4, 0x00004AF1, 0x000067FF, 0x00004A9F, 
    0x00006839, 0x00004A4D, 0x00006873, 0x000049FB, 
    0x000068AD, 0x000049A9, 0x000068E7, 0x00004957, 
    0x00006921, 0x00004905, 0x0000695A, 0x000048B2, 
    0x00006993, 0x0000485F, 0x000069CB, 0x0000480C, 
    0x00006A04, 0x000047B9, 0x00006A3C, 0x00004766, 
    0x00006A74, 0x00004712, 0x00006AAC, 0x000046BE, 
    0x00006AE3, 0x0000466A, 0x00006B1A, 0x00004616, 
    0x00006B51, 0x000045C2, 0x00006B88, 0x0000456E, 
    0x00006BBE, 0x00004519, 0x00006BF5, 0x000044C5, 
    0x00006C2A, 0x00004470, 0x00006C60, 0x0000441B, 
    0x00006C95, 0x000043C5, 0x00006CCA, 0x00004370, 
    0x00006CFF, 0x0000431B, 0x00006D34, 0x000042C5, 
    0x00006D68, 0x0000426F, 0x00006D9C, 0x00004219, 
    0x00006DD0, 0x000041C3, 0x00006E04, 0x0000416D, 
    0x00006E37, 0x00004116, 0x00006E6A, 0x000040BF, 
    0x00006E9C, 0x00004069, 0x00006ECF, 0x00004012, 
    0x00006F01, 0x00003FBB, 0x00006F33, 0x00003F63, 
    0x00006F65, 0x00003F0C, 0x00006F96, 0x00003EB4, 
    0x00006FC7, 0x00003E5D, 0x00006FF8, 0x00003E05, 
    0x00007029, 0x00003DAD, 0x00007059, 0x00003D55, 
    0x00007089, 0x00003CFC, 0x000070B9, 0x00003CA4, 
    0x000070E8, 0x00003C4B, 0x00007117, 0x00003BF2, 
    0x00007146, 0x00003B99, 0x00007175, 0x00003B40, 
    0x000071A3, 0x00003AE7, 0x000071D2, 0x00003A8E, 
    0x000071FF, 0x00003A34, 0x0000722D, 0x000039DB, 
    0x0000725A, 0x00003981, 0x00007287, 0x00003927, 
    0x000072B4, 0x000038CD, 0x000072E1, 0x00003873, 
    0x0000730D, 0x00003819, 0x00007339, 0x000037BE, 
    0x00007364, 0x00003764, 0x00007390, 0x00003709, 
    0x000073BB, 0x000036AE, 0x000073E6, 0x00003653, 
    0x00007410, 0x000035F8, 0x0000743A, 0x0000359D, 
    0x00007464, 0x00003542, 0x0000748E, 0x000034E6, 
    0x000074B7, 0x0000348B, 0x000074E1, 0x0000342F, 
    0x00007509, 0x000033D3, 0x00007532, 0x00003377, 
    0x0000755A, 0x0000331B, 0x00007582, 0x000032BF, 
    0x000075AA, 0x00003262, 0x000075D1, 0x00003206, 
    0x000075F9, 0x000031A9, 0x0000761F, 0x0000314C, 
    0x00007646, 0x000030F0, 0x0000766C, 0x00003093, 
    0x00007692, 0x00003036, 0x000076B8, 0x00002FD8, 
    0x000076DD, 0x00002F7B, 0x00007703, 0x00002F1E, 
    0x00007727, 0x00002EC0, 0x0000774C, 0x00002E63, 
    0x00007770, 0x00002E05, 0x00007794, 0x00002DA7, 
    0x000077B8, 0x00002D49, 0x000077DB, 0x00002CEB, 
    0x000077FF, 0x00002C8D, 0x00007821, 0x00002C2E, 
    0x00007844, 0x00002BD0, 0x00007866, 0x00002B71, 
    0x00007888, 0x00002B13, 0x000078AA, 0x00002AB4, 
    0x000078CB, 0x00002A55, 0x000078EC, 0x000029F6, 
    0x0000790D, 0x00002997, 0x0000792E, 0x00002938, 
    0x0000794E, 0x000028D9, 0x0000796E, 0x0000287A, 
    0x0000798E, 0x0000281A, 0x000079AD, 0x000027BB, 
    0x000079CC, 0x0000275B, 0x000079EB, 0x000026FB, 
    0x00007A09, 0x0000269C, 0x00007A27, 0x0000263C, 
    0x00007A45, 0x000025DC, 0x00007A63, 0x0000257C, 
    0x00007A80, 0x0000251C, 0x00007A9D, 0x000024BB, 
    0x00007ABA, 0x0000245B, 0x00007AD6, 0x000023FA, 
    0x00007AF2, 0x0000239A, 0x00007B0E, 0x00002339, 
    0x00007B2A, 0x000022D9, 0x00007B45, 0x00002278, 
    0x00007B60, 0x00002217, 0x00007B7A, 0x000021B6, 
    0x00007B95, 0x00002155, 0x00007BAF, 0x000020F4, 
    0x00007BC9, 0x00002093, 0x00007BE2, 0x00002032, 
    0x00007BFB, 0x00001FD0, 0x00007C14, 0x00001F6F, 
    0x00007C2D, 0x00001F0D, 0x00007C45, 0x00001EAC, 
    0x00007C5D, 0x00001E4A, 0x00007C74, 0x00001DE8, 
    0x00007C8C, 0x00001D87, 0x00007CA3, 0x00001D25, 
    0x00007CB9, 0x00001CC3, 0x00007CD0, 0x00001C61, 
    0x00007CE6, 0x00001BFF, 0x00007CFC, 0x00001B9D, 
    0x00007D11, 0x00001B3A, 0x00007D27, 0x00001AD8, 
    0x00007D3C, 0x00001A76, 0x00007D50, 0x00001A13, 
    0x00007D65, 0x000019B1, 0x00007D79, 0x0000194E, 
    0x00007D8C, 0x000018EC, 0x00007DA0, 0x00001889, 
    0x00007DB3, 0x00001827, 0x00007DC6, 0x000017C4, 
    0x00007DD8, 0x00001761, 0x00007DEA, 0x000016FE, 
    0x00007DFC, 0x0000169B, 0x00007E0E, 0x00001638, 
    0x00007E1F, 0x000015D5, 0x00007E30, 0x00001572, 
    0x00007E41, 0x0000150F, 0x00007E51, 0x000014AC, 
    0x00007E61, 0x00001449, 0x00007E71, 0x000013E5, 
    0x00007E81, 0x00001382, 0x00007E90, 0x0000131F, 
    0x00007E9F, 0x000012BB, 0x00007EAD, 0x00001258, 
    0x00007EBB, 0x000011F4, 0x00007EC9, 0x00001191, 
    0x00007ED7, 0x0000112D, 0x00007EE4, 0x000010C9, 
    0x00007EF1, 0x00001066, 0x00007EFE, 0x00001002, 
    0x00007F0B, 0x00000F9E, 0x00007F17, 0x00000F3A, 
    0x00007F23, 0x00000ED7, 0x00007F2E, 0x00000E73, 
    0x00007F39, 0x00000E0F, 0x00007F44, 0x00000DAB, 
    0x00007F4F, 0x00000D47, 0x00007F59, 0x00000CE3, 
    0x00007F63, 0x00000C7F, 0x00007F6D, 0x00000C1B, 
    0x00007F76, 0x00000BB7, 0x00007F7F, 0x00000B53, 
    0x00007F88, 0x00000AEE, 0x00007F90, 0x00000A8A, 
    0x00007F98, 0x00000A26, 0x00007FA0, 0x000009C2, 
    0x00007FA8, 0x0000095E, 0x00007FAF, 0x000008F9, 
    0x00007FB6, 0x00000895, 0x00007FBC, 0x00000831, 
    0x00007FC3, 0x000007CC, 0x00007FC9, 0x00000768, 
    0x00007FCE, 0x00000704, 0x00007FD4, 0x0000069F, 
    0x00007FD9, 0x0000063B, 0x00007FDD, 0x000005D6, 
    0x00007FE2, 0x00000572, 0x00007FE6, 0x0000050D, 
    0x00007FEA, 0x000004A9, 0x00007FED, 0x00000445, 
    0x00007FF0, 0x000003E0, 0x00007FF3, 0x0000037C, 
    0x00007FF6, 0x00000317, 0x00007FF8, 0x000002B3, 
    0x00007FFA, 0x0000024E, 0x00007FFC, 0x000001EA, 
    0x00007FFD, 0x00000185, 0x00007FFE, 0x00000121, 
    0x00007FFF, 0x000000BC, 0x00007FFF, 0x00000057, 
    0x00000004, 0x00005A82, 0x00000027, 0x00005A82, 
    0x0000004B, 0x00005A82, 0x0000006F, 0x00005A82, 
    0x00000092, 0x00005A82, 0x000000B6, 0x00005A81, 
    0x000000D9, 0x00005A81, 0x000000FD, 0x00005A81, 
    0x00000120, 0x00005A80, 0x00000144, 0x00005A80, 
    0x00000167, 0x00005A7F, 0x0000018B, 0x00005A7F, 
    0x000001AE, 0x00005A7E, 0x000001D2, 0x00005A7D, 
    0x000001F6, 0x00005A7D, 0x00000219, 0x00005A7C, 
    0x0000023D, 0x00005A7B, 0x00000260, 0x00005A7A, 
    0x00000284, 0x00005A79, 0x000002A7, 0x00005A78, 
    0x000002CB, 0x00005A77, 0x000002EE, 0x00005A76, 
    0x00000312, 0x00005A75, 0x00000335, 0x00005A73, 
    0x00000359, 0x00005A72, 0x0000037C, 0x00005A71, 
    0x000003A0, 0x00005A6F, 0x000003C3, 0x00005A6E, 
    0x000003E7, 0x00005A6C, 0x0000040A, 0x00005A6B, 
    0x0000042E, 0x00005A69, 0x00000451, 0x00005A68, 
    0x00000475, 0x00005A66, 0x00000498, 0x00005A64, 
    0x000004BC, 0x00005A62, 0x000004DF, 0x00005A60, 
    0x00000503, 0x00005A5E, 0x00000526, 0x00005A5C, 
    0x0000054A, 0x00005A5A, 0x0000056D, 0x00005A58, 
    0x00000591, 0x00005A56, 0x000005B4, 0x00005A54, 
    0x000005D8, 0x00005A52, 0x000005FB, 0x00005A4F, 
    0x0000061F, 0x00005A4D, 0x00000642, 0x00005A4A, 
    0x00000666, 0x00005A48, 0x00000689, 0x00005A45, 
    0x000006AC, 0x00005A43, 0x000006D0, 0x00005A40, 
    0x000006F3, 0x00005A3E, 0x00000717, 0x00005A3B, 
    0x0000073A, 0x00005A38, 0x0000075E, 0x00005A35, 
    0x00000781, 0x00005A32, 0x000007A4, 0x00005A2F, 
    0x000007C8, 0x00005A2C, 0x000007EB, 0x00005A29, 
    0x0000080F, 0x00005A26, 0x00000832, 0x00005A23, 
    0x00000855, 0x00005A1F, 0x00000879, 0x00005A1C, 
    0x0000089C, 0x00005A19, 0x000008C0, 0x00005A15, 
    0x000008E3, 0x00005A12, 0x00000906, 0x00005A0E, 
    0x0000092A, 0x00005A0B, 0x0000094D, 0x00005A07, 
    0x00000970, 0x00005A04, 0x00000994, 0x00005A00, 
    0x000009B7, 0x000059FC, 0x000009DA, 0x000059F8, 
    0x000009FE, 0x000059F4, 0x00000A21, 0x000059F0, 
    0x00000A44, 0x000059EC, 0x00000A68, 0x000059E8, 
    0x00000A8B, 0x000059E4, 0x00000AAE, 0x000059E0, 
    0x00000AD2, 0x000059DC, 0x00000AF5, 0x000059D8, 
    0x00000B18, 0x000059D3, 0x00000B3B, 0x000059CF, 
    0x00000B5F, 0x000059CA, 0x00000B82, 0x000059C6, 
    0x00000BA5, 0x000059C1, 0x00000BC9, 0x000059BD, 
    0x00000BEC, 0x000059B8, 0x00000C0F, 0x000059B3, 
    0x00000C32, 0x000059AF, 0x00000C55, 0x000059AA, 
    0x00000C79, 0x000059A5, 0x00000C9C, 0x000059A0, 
    0x00000CBF, 0x0000599B, 0x00000CE2, 0x00005996, 
    0x00000D05, 0x00005991, 0x00000D29, 0x0000598C, 
    0x00000D4C, 0x00005987, 0x00000D6F, 0x00005981, 
    0x00000D92, 0x0000597C, 0x00000DB5, 0x00005977, 
    0x00000DD8, 0x00005971, 0x00000DFB, 0x0000596C, 
    0x00000E1F, 0x00005966, 0x00000E42, 0x00005961, 
    0x00000E65, 0x0000595B, 0x00000E88, 0x00005955, 
    0x00000EAB, 0x00005950, 0x00000ECE, 0x0000594A, 
    0x00000EF1, 0x00005944, 0x00000F14, 0x0000593E, 
    0x00000F37, 0x00005938, 0x00000F5A, 0x00005932, 
    0x00000F7D, 0x0000592C, 0x00000FA0, 0x00005926, 
    0x00000FC3, 0x00005920, 0x00000FE6, 0x0000591A, 
    0x00001009, 0x00005913, 0x0000102C, 0x0000590D, 
    0x0000104F, 0x00005907, 0x00001072, 0x00005900, 
    0x00001095, 0x000058FA, 0x000010B8, 0x000058F3, 
    0x000010DB, 0x000058ED, 0x000010FE, 0x000058E6, 
    0x00001121, 0x000058DF, 0x00001144, 0x000058D8, 
    0x00001166, 0x000058D2, 0x00001189, 0x000058CB, 
    0x000011AC, 0x000058C4, 0x000011CF, 0x000058BD, 
    0x000011F2, 0x000058B6, 0x00001215, 0x000058AF, 
    0x00001238, 0x000058A8, 0x0000125A, 0x000058A1, 
    0x0000127D, 0x00005899, 0x000012A0, 0x00005892, 
    0x000012C3, 0x0000588B, 0x000012E5, 0x00005883, 
    0x00001308, 0x0000587C, 0x0000132B, 0x00005874, 
    0x0000134E, 0x0000586D, 0x00001370, 0x00005865, 
    0x00001393, 0x0000585D, 0x000013B6, 0x00005856, 
    0x000013D9, 0x0000584E, 0x000013FB, 0x00005846, 
    0x0000141E, 0x0000583E, 0x00001440, 0x00005836, 
    0x00001463, 0x0000582E, 0x00001486, 0x00005826, 
    0x000014A8, 0x0000581E, 0x000014CB, 0x00005816, 
    0x000014EE, 0x0000580E, 0x00001510, 0x00005806, 
    0x00001533, 0x000057FD, 0x00001555, 0x000057F5, 
    0x00001578, 0x000057ED, 0x0000159A, 0x000057E4, 
    0x000015BD, 0x000057DC, 0x000015DF, 0x000057D3, 
    0x00001602, 0x000057CB, 0x00001624, 0x000057C2, 
    0x00001647, 0x000057B9, 0x00001669, 0x000057B0, 
    0x0000168C, 0x000057A8, 0x000016AE, 0x0000579F, 
    0x000016D0, 0x00005796, 0x000016F3, 0x0000578D, 
    0x00001715, 0x00005784, 0x00001738, 0x0000577B, 
    0x0000175A, 0x00005771, 0x0000177C, 0x00005768, 
    0x0000179F, 0x0000575F, 0x000017C1, 0x00005756, 
    0x000017E3, 0x0000574C, 0x00001805, 0x00005743, 
    0x00001828, 0x00005739, 0x0000184A, 0x00005730, 
    0x0000186C, 0x00005726, 0x0000188E, 0x0000571D, 
    0x000018B1, 0x00005713, 0x000018D3, 0x00005709, 
    0x000018F5, 0x00005700, 0x00001917, 0x000056F6, 
    0x00001939, 0x000056EC, 0x0000195B, 0x000056E2, 
    0x0000197D, 0x000056D8, 0x000019A0, 0x000056CE, 
    0x000019C2, 0x000056C4, 0x000019E4, 0x000056BA, 
    0x00001A06, 0x000056B0, 0x00001A28, 0x000056A5, 
    0x00001A4A, 0x0000569B, 0x00001A6C, 0x00005691, 
    0x00001A8E, 0x00005686, 0x00001AB0, 0x0000567C, 
    0x00001AD2, 0x00005671, 0x00001AF4, 0x00005667, 
    0x00001B16, 0x0000565C, 0x00001B37, 0x00005651, 
    0x00001B59, 0x00005647, 0x00001B7B, 0x0000563C, 
    0x00001B9D, 0x00005631, 0x00001BBF, 0x00005626, 
    0x00001BE1, 0x0000561B, 0x00001C03, 0x00005610, 
    0x00001C24, 0x00005605, 0x00001C46, 0x000055FA, 
    0x00001C68, 0x000055EF, 0x00001C8A, 0x000055E4, 
    0x00001CAB, 0x000055D9, 0x00001CCD, 0x000055CD, 
    0x00001CEF, 0x000055C2, 0x00001D10, 0x000055B7, 
    0x00001D32, 0x000055AB, 0x00001D54, 0x000055A0, 
    0x00001D75, 0x00005594, 0x00001D97, 0x00005589, 
    0x00001DB8, 0x0000557D, 0x00001DDA, 0x00005571, 
    0x00001DFC, 0x00005566, 0x00001E1D, 0x0000555A, 
    0x00001E3F, 0x0000554E, 0x00001E60, 0x00005542, 
    0x00001E82, 0x00005536, 0x00001EA3, 0x0000552A, 
    0x00001EC4, 0x0000551E, 0x00001EE6, 0x00005512, 
    0x00001F07, 0x00005506, 0x00001F29, 0x000054F9, 
    0x00001F4A, 0x000054ED, 0x00001F6B, 0x000054E1, 
    0x00001F8D, 0x000054D5, 0x00001FAE, 0x000054C8, 
    0x00001FCF, 0x000054BC, 0x00001FF1, 0x000054AF, 
    0x00002012, 0x000054A3, 0x00002033, 0x00005496, 
    0x00002054, 0x00005489, 0x00002075, 0x0000547D, 
    0x00002097, 0x00005470, 0x000020B8, 0x00005463, 
    0x000020D9, 0x00005456, 0x000020FA, 0x00005449, 
    0x0000211B, 0x0000543C, 0x0000213C, 0x0000542F, 
    0x0000215D, 0x00005422, 0x0000217E, 0x00005415, 
    0x0000219F, 0x00005408, 0x000021C0, 0x000053FB, 
    0x000021E1, 0x000053ED, 0x00002202, 0x000053E0, 
    0x00002223, 0x000053D3, 0x00002244, 0x000053C5, 
    0x00002265, 0x000053B8, 0x00002286, 0x000053AA, 
    0x000022A7, 0x0000539D, 0x000022C7, 0x0000538F, 
    0x000022E8, 0x00005381, 0x00002309, 0x00005373, 
    0x0000232A, 0x00005366, 0x0000234A, 0x00005358, 
    0x0000236B, 0x0000534A, 0x0000238C, 0x0000533C, 
    0x000023AD, 0x0000532E, 0x000023CD, 0x00005320, 
    0x000023EE, 0x00005312, 0x0000240E, 0x00005304, 
    0x0000242F, 0x000052F6, 0x00002450, 0x000052E7, 
    0x00002470, 0x000052D9, 0x00002491, 0x000052CB, 
    0x000024B1, 0x000052BC, 0x000024D2, 0x000052AE, 
    0x000024F2, 0x0000529F, 0x00002513, 0x00005291, 
    0x00002533, 0x00005282, 0x00002553, 0x00005274, 
    0x00002574, 0x00005265, 0x00002594, 0x00005256, 
    0x000025B4, 0x00005248, 0x000025D5, 0x00005239, 
    0x000025F5, 0x0000522A, 0x00002615, 0x0000521B, 
    0x00002635, 0x0000520C, 0x00002656, 0x000051FD, 
    0x00002676, 0x000051EE, 0x00002696, 0x000051DF, 
    0x000026B6, 0x000051CF, 0x000026D6, 0x000051C0, 
    0x000026F6, 0x000051B1, 0x00002716, 0x000051A2, 
    0x00002736, 0x00005192, 0x00002757, 0x00005183, 
    0x00002777, 0x00005173, 0x00002796, 0x00005164, 
    0x000027B6, 0x00005154, 0x000027D6, 0x00005145, 
    0x000027F6, 0x00005135, 0x00002816, 0x00005125, 
    0x00002836, 0x00005115, 0x00002856, 0x00005106, 
    0x00002876, 0x000050F6, 0x00002895, 0x000050E6, 
    0x000028B5, 0x000050D6, 0x000028D5, 0x000050C6, 
    0x000028F5, 0x000050B6, 0x00002914, 0x000050A6, 
    0x00002934, 0x00005096, 0x00002954, 0x00005085, 
    0x00002973, 0x00005075, 0x00002993, 0x00005065, 
    0x000029B2, 0x00005054, 0x000029D2, 0x00005044, 
    0x000029F1, 0x00005034, 0x00002A11, 0x00005023, 
    0x00002A30, 0x00005013, 0x00002A50, 0x00005002, 
    0x00002A6F, 0x00004FF1, 0x00002A8F, 0x00004FE1, 
    0x00002AAE, 0x00004FD0, 0x00002ACD, 0x00004FBF, 
    0x00002AED, 0x00004FAE, 0x00002B0C, 0x00004F9D, 
    0x00002B2B, 0x00004F8D, 0x00002B4A, 0x00004F7C, 
    0x00002B69, 0x00004F6B, 0x00002B89, 0x00004F59, 
    0x00002BA8, 0x00004F48, 0x00002BC7, 0x00004F37, 
    0x00002BE6, 0x00004F26, 0x00002C05, 0x00004F15, 
    0x00002C24, 0x00004F03, 0x00002C43, 0x00004EF2, 
    0x00002C62, 0x00004EE1, 0x00002C81, 0x00004ECF, 
    0x00002CA0, 0x00004EBE, 0x00002CBF, 0x00004EAC, 
    0x00002CDE, 0x00004E9A, 0x00002CFD, 0x00004E89, 
    0x00002D1C, 0x00004E77, 0x00002D3A, 0x00004E65, 
    0x00002D59, 0x00004E54, 0x00002D78, 0x00004E42, 
    0x00002D97, 0x00004E30, 0x00002DB5, 0x00004E1E, 
    0x00002DD4, 0x00004E0C, 0x00002DF3, 0x00004DFA, 
    0x00002E11, 0x00004DE8, 0x00002E30, 0x00004DD6, 
    0x00002E4E, 0x00004DC4, 0x00002E6D, 0x00004DB1, 
    0x00002E8B, 0x00004D9F, 0x00002EAA, 0x00004D8D, 
    0x00002EC8, 0x00004D7B, 0x00002EE7, 0x00004D68, 
    0x00002F05, 0x00004D56, 0x00002F23, 0x00004D43, 
    0x00002F42, 0x00004D31, 0x00002F60, 0x00004D1E, 
    0x00002F7E, 0x00004D0B, 0x00002F9D, 0x00004CF9, 
    0x00002FBB, 0x00004CE6, 0x00002FD9, 0x00004CD3, 
    0x00002FF7, 0x00004CC0, 0x00003015, 0x00004CAE, 
    0x00003033, 0x00004C9B, 0x00003051, 0x00004C88, 
    0x0000306F, 0x00004C75, 0x0000308D, 0x00004C62, 
    0x000030AB, 0x00004C4F, 0x000030C9, 0x00004C3C, 
    0x000030E7, 0x00004C28, 0x00003105, 0x00004C15, 
    0x00003123, 0x00004C02, 0x00003141, 0x00004BEF, 
    0x0000315F, 0x00004BDB, 0x0000317C, 0x00004BC8, 
    0x0000319A, 0x00004BB4, 0x000031B8, 0x00004BA1, 
    0x000031D6, 0x00004B8D, 0x000031F3, 0x00004B7A, 
    0x00003211, 0x00004B66, 0x0000322E, 0x00004B52, 
    0x0000324C, 0x00004B3F, 0x0000326A, 0x00004B2B, 
    0x00003287, 0x00004B17, 0x000032A5, 0x00004B03, 
    0x000032C2, 0x00004AEF, 0x000032DF, 0x00004ADB, 
    0x000032FD, 0x00004AC7, 0x0000331A, 0x00004AB3, 
    0x00003337, 0x00004A9F, 0x00003355, 0x00004A8B, 
    0x00003372, 0x00004A77, 0x0000338F, 0x00004A63, 
    0x000033AC, 0x00004A4E, 0x000033CA, 0x00004A3A, 
    0x000033E7, 0x00004A26, 0x00003404, 0x00004A11, 
    0x00003421, 0x000049FD, 0x0000343E, 0x000049E8, 
    0x0000345B, 0x000049D4, 0x00003478, 0x000049BF, 
    0x00003495, 0x000049AB, 0x000034B2, 0x00004996, 
    0x000034CF, 0x00004981, 0x000034EB, 0x0000496C, 
    0x00003508, 0x00004958, 0x00003525, 0x00004943, 
    0x00003542, 0x0000492E, 0x0000355F, 0x00004919, 
    0x0000357B, 0x00004904, 0x00003598, 0x000048EF, 
    0x000035B5, 0x000048DA, 0x000035D1, 0x000048C5, 
    0x000035EE, 0x000048B0, 0x0000360A, 0x0000489A, 
    0x00003627, 0x00004885, 0x00003643, 0x00004870, 
    0x00003660, 0x0000485A, 0x0000367C, 0x00004845, 
    0x00003698, 0x00004830, 0x000036B5, 0x0000481A, 
    0x000036D1, 0x00004805, 0x000036ED, 0x000047EF, 
    0x0000370A, 0x000047DA, 0x00003726, 0x000047C4, 
    0x00003742, 0x000047AE, 0x0000375E, 0x00004799, 
    0x0000377A, 0x00004783, 0x00003796, 0x0000476D, 
    0x000037B2, 0x00004757, 0x000037CE, 0x00004741, 
    0x000037EA, 0x0000472B, 0x00003806, 0x00004715, 
    0x00003822, 0x000046FF, 0x0000383E, 0x000046E9, 
    0x0000385A, 0x000046D3, 0x00003875, 0x000046BD, 
    0x00003891, 0x000046A7, 0x000038AD, 0x00004691, 
    0x000038C9, 0x0000467A, 0x000038E4, 0x00004664, 
    0x00003900, 0x0000464E, 0x0000391C, 0x00004637, 
    0x00003937, 0x00004621, 0x00003953, 0x0000460A, 
    0x0000396E, 0x000045F4, 0x0000398A, 0x000045DD, 
    0x000039A5, 0x000045C7, 0x000039C0, 0x000045B0, 
    0x000039DC, 0x00004599, 0x000039F7, 0x00004582, 
    0x00003A12, 0x0000456C, 0x00003A2E, 0x00004555, 
    0x00003A49, 0x0000453E, 0x00003A64, 0x00004527, 
    0x00003A7F, 0x00004510, 0x00003A9A, 0x000044F9, 
    0x00003AB5, 0x000044E2, 0x00003AD0, 0x000044CB, 
    0x00003AEB, 0x000044B4, 0x00003B06, 0x0000449D, 
    0x00003B21, 0x00004485, 0x00003B3C, 0x0000446E, 
    0x00003B57, 0x00004457, 0x00003B72, 0x00004440, 
    0x00003B8D, 0x00004428, 0x00003BA7, 0x00004411, 
    0x00003BC2, 0x000043F9, 0x00003BDD, 0x000043E2, 
    0x00003BF7, 0x000043CA, 0x00003C12, 0x000043B3, 
    0x00003C2C, 0x0000439B, 0x00003C47, 0x00004384, 
    0x00003C62, 0x0000436C, 0x00003C7C, 0x00004354, 
    0x00003C96, 0x0000433C, 0x00003CB1, 0x00004325, 
    0x00003CCB, 0x0000430D, 0x00003CE5, 0x000042F5, 
    0x00003D00, 0x000042DD, 0x00003D1A, 0x000042C5, 
    0x00003D34, 0x000042AD, 0x00003D4E, 0x00004295, 
    0x00003D68, 0x0000427D, 0x00003D83, 0x00004265, 
    0x00003D9D, 0x0000424C, 0x00003DB7, 0x00004234, 
    0x00003DD1, 0x0000421C, 0x00003DEB, 0x00004204, 
    0x00003E04, 0x000041EB, 0x00003E1E, 0x000041D3, 
    0x00003E38, 0x000041BB, 0x00003E52, 0x000041A2, 
    0x00003E6C, 0x0000418A, 0x00003E85, 0x00004171, 
    0x00003E9F, 0x00004158, 0x00003EB9, 0x00004140, 
    0x00003ED2, 0x00004127, 0x00003EEC, 0x0000410F, 
    0x00003F05, 0x000040F6, 0x00003F1F, 0x000040DD, 
    0x00003F38, 0x000040C4, 0x00003F52, 0x000040AB, 
    0x00003F6B, 0x00004092, 0x00003F85, 0x0000407A, 
    0x00003F9E, 0x00004061, 0x00003FB7, 0x00004048, 
    0x00003FD0, 0x0000402F, 0x00003FE9, 0x00004015, 
    0x00004003, 0x00003FFC, 0x0000401C, 0x00003FE3, 
    0x00004035, 0x00003FCA, 0x0000404E, 0x00003FB1, 
    0x00004067, 0x00003F98, 0x00004080, 0x00003F7E, 
    0x00004099, 0x00003F65, 0x000040B2, 0x00003F4B, 
    0x000040CA, 0x00003F32, 0x000040E3, 0x00003F19, 
    0x000040FC, 0x00003EFF, 0x00004115, 0x00003EE6, 
    0x0000412D, 0x00003ECC, 0x00004146, 0x00003EB2, 
    0x0000415F, 0x00003E99, 0x00004177, 0x00003E7F, 
    0x00004190, 0x00003E65, 0x000041A8, 0x00003E4B, 
    0x000041C1, 0x00003E32, 0x000041D9, 0x00003E18, 
    0x000041F1, 0x00003DFE, 0x0000420A, 0x00003DE4, 
    0x00004222, 0x00003DCA, 0x0000423A, 0x00003DB0, 
    0x00004252, 0x00003D96, 0x0000426B, 0x00003D7C, 
    0x00004283, 0x00003D62, 0x0000429B, 0x00003D48, 
    0x000042B3, 0x00003D2E, 0x000042CB, 0x00003D13, 
    0x000042E3, 0x00003CF9, 0x000042FB, 0x00003CDF, 
    0x00004313, 0x00003CC5, 0x0000432B, 0x00003CAA, 
    0x00004342, 0x00003C90, 0x0000435A, 0x00003C75, 
    0x00004372, 0x00003C5B, 0x00004389, 0x00003C40, 
    0x000043A1, 0x00003C26, 0x000043B9, 0x00003C0B, 
    0x000043D0, 0x00003BF1, 0x000043E8, 0x00003BD6, 
    0x000043FF, 0x00003BBB, 0x00004417, 0x00003BA1, 
    0x0000442E, 0x00003B86, 0x00004445, 0x00003B6B, 
    0x0000445D, 0x00003B50, 0x00004474, 0x00003B35, 
    0x0000448B, 0x00003B1A, 0x000044A2, 0x00003B00, 
    0x000044BA, 0x00003AE5, 0x000044D1, 0x00003ACA, 
    0x000044E8, 0x00003AAF, 0x000044FF, 0x00003A93, 
    0x00004516, 0x00003A78, 0x0000452D, 0x00003A5D, 
    0x00004544, 0x00003A42, 0x0000455B, 0x00003A27, 
    0x00004571, 0x00003A0C, 0x00004588, 0x000039F0, 
    0x0000459F, 0x000039D5, 0x000045B6, 0x000039BA, 
    0x000045CC, 0x0000399E, 0x000045E3, 0x00003983, 
    0x000045F9, 0x00003967, 0x00004610, 0x0000394C, 
    0x00004626, 0x00003930, 0x0000463D, 0x00003915, 
    0x00004653, 0x000038F9, 0x0000466A, 0x000038DD, 
    0x00004680, 0x000038C2, 0x00004696, 0x000038A6, 
    0x000046AC, 0x0000388A, 0x000046C3, 0x0000386F, 
    0x000046D9, 0x00003853, 0x000046EF, 0x00003837, 
    0x00004705, 0x0000381B, 0x0000471B, 0x000037FF, 
    0x00004731, 0x000037E3, 0x00004747, 0x000037C7, 
    0x0000475D, 0x000037AB, 0x00004772, 0x0000378F, 
    0x00004788, 0x00003773, 0x0000479E, 0x00003757, 
    0x000047B4, 0x0000373B, 0x000047C9, 0x0000371F, 
    0x000047DF, 0x00003702, 0x000047F5, 0x000036E6, 
    0x0000480A, 0x000036CA, 0x00004820, 0x000036AE, 
    0x00004835, 0x00003691, 0x0000484A, 0x00003675, 
    0x00004860, 0x00003659, 0x00004875, 0x0000363C, 
    0x0000488A, 0x00003620, 0x000048A0, 0x00003603, 
    0x000048B5, 0x000035E7, 0x000048CA, 0x000035CA, 
    0x000048DF, 0x000035AD, 0x000048F4, 0x00003591, 
    0x00004909, 0x00003574, 0x0000491E, 0x00003557, 
    0x00004933, 0x0000353B, 0x00004948, 0x0000351E, 
    0x0000495D, 0x00003501, 0x00004972, 0x000034E4, 
    0x00004986, 0x000034C7, 0x0000499B, 0x000034AB, 
    0x000049B0, 0x0000348E, 0x000049C4, 0x00003471, 
    0x000049D9, 0x00003454, 0x000049ED, 0x00003437, 
    0x00004A02, 0x0000341A, 0x00004A16, 0x000033FD, 
    0x00004A2B, 0x000033DF, 0x00004A3F, 0x000033C2, 
    0x00004A53, 0x000033A5, 0x00004A68, 0x00003388, 
    0x00004A7C, 0x0000336B, 0x00004A90, 0x0000334D, 
    0x00004AA4, 0x00003330, 0x00004AB8, 0x00003313, 
    0x00004ACC, 0x000032F5, 0x00004AE0, 0x000032D8, 
    0x00004AF4, 0x000032BB, 0x00004B08, 0x0000329D, 
    0x00004B1C, 0x00003280, 0x00004B30, 0x00003262, 
    0x00004B44, 0x00003245, 0x00004B57, 0x00003227, 
    0x00004B6B, 0x00003209, 0x00004B7F, 0x000031EC, 
    0x00004B92, 0x000031CE, 0x00004BA6, 0x000031B0, 
    0x00004BB9, 0x00003193, 0x00004BCD, 0x00003175, 
    0x00004BE0, 0x00003157, 0x00004BF3, 0x00003139, 
    0x00004C07, 0x0000311C, 0x00004C1A, 0x000030FE, 
    0x00004C2D, 0x000030E0, 0x00004C40, 0x000030C2, 
    0x00004C53, 0x000030A4, 0x00004C67, 0x00003086, 
    0x00004C7A, 0x00003068, 0x00004C8D, 0x0000304A, 
    0x00004C9F, 0x0000302C, 0x00004CB2, 0x0000300E, 
    0x00004CC5, 0x00002FF0, 0x00004CD8, 0x00002FD1, 
    0x00004CEB, 0x00002FB3, 0x00004CFD, 0x00002F95, 
    0x00004D10, 0x00002F77, 0x00004D23, 0x00002F58, 
    0x00004D35, 0x00002F3A, 0x00004D48, 0x00002F1C, 
    0x00004D5A, 0x00002EFD, 0x00004D6D, 0x00002EDF, 
    0x00004D7F, 0x00002EC1, 0x00004D91, 0x00002EA2, 
    0x00004DA4, 0x00002E84, 0x00004DB6, 0x00002E65, 
    0x00004DC8, 0x00002E47, 0x00004DDA, 0x00002E28, 
    0x00004DEC, 0x00002E0A, 0x00004DFF, 0x00002DEB, 
    0x00004E11, 0x00002DCC, 0x00004E22, 0x00002DAE, 
    0x00004E34, 0x00002D8F, 0x00004E46, 0x00002D70, 
    0x00004E58, 0x00002D51, 0x00004E6A, 0x00002D33, 
    0x00004E7C, 0x00002D14, 0x00004E8D, 0x00002CF5, 
    0x00004E9F, 0x00002CD6, 0x00004EB0, 0x00002CB7, 
    0x00004EC2, 0x00002C98, 0x00004ED4, 0x00002C79, 
    0x00004EE5, 0x00002C5A, 0x00004EF6, 0x00002C3B, 
    0x00004F08, 0x00002C1C, 0x00004F19, 0x00002BFD, 
    0x00004F2A, 0x00002BDE, 0x00004F3B, 0x00002BBF, 
    0x00004F4D, 0x00002BA0, 0x00004F5E, 0x00002B81, 
    0x00004F6F, 0x00002B62, 0x00004F80, 0x00002B42, 
    0x00004F91, 0x00002B23, 0x00004FA2, 0x00002B04, 
    0x00004FB3, 0x00002AE5, 0x00004FC3, 0x00002AC5, 
    0x00004FD4, 0x00002AA6, 0x00004FE5, 0x00002A87, 
    0x00004FF6, 0x00002A67, 0x00005006, 0x00002A48, 
    0x00005017, 0x00002A28, 0x00005027, 0x00002A09, 
    0x00005038, 0x000029EA, 0x00005048, 0x000029CA, 
    0x00005059, 0x000029AA, 0x00005069, 0x0000298B, 
    0x00005079, 0x0000296B, 0x00005089, 0x0000294C, 
    0x0000509A, 0x0000292C, 0x000050AA, 0x0000290C, 
    0x000050BA, 0x000028ED, 0x000050CA, 0x000028CD, 
    0x000050DA, 0x000028AD, 0x000050EA, 0x0000288D, 
    0x000050FA, 0x0000286E, 0x0000510A, 0x0000284E, 
    0x00005119, 0x0000282E, 0x00005129, 0x0000280E, 
    0x00005139, 0x000027EE, 0x00005149, 0x000027CE, 
    0x00005158, 0x000027AE, 0x00005168, 0x0000278E, 
    0x00005177, 0x0000276F, 0x00005187, 0x0000274F, 
    0x00005196, 0x0000272E, 0x000051A5, 0x0000270E, 
    0x000051B5, 0x000026EE, 0x000051C4, 0x000026CE, 
    0x000051D3, 0x000026AE, 0x000051E2, 0x0000268E, 
    0x000051F2, 0x0000266E, 0x00005201, 0x0000264E, 
    0x00005210, 0x0000262D, 0x0000521F, 0x0000260D, 
    0x0000522E, 0x000025ED, 0x0000523C, 0x000025CD, 
    0x0000524B, 0x000025AC, 0x0000525A, 0x0000258C, 
    0x00005269, 0x0000256C, 0x00005277, 0x0000254B, 
    0x00005286, 0x0000252B, 0x00005295, 0x0000250A, 
    0x000052A3, 0x000024EA, 0x000052B2, 0x000024CA, 
    0x000052C0, 0x000024A9, 0x000052CE, 0x00002489, 
    0x000052DD, 0x00002468, 0x000052EB, 0x00002447, 
    0x000052F9, 0x00002427, 0x00005307, 0x00002406, 
    0x00005315, 0x000023E6, 0x00005324, 0x000023C5, 
    0x00005332, 0x000023A4, 0x00005340, 0x00002384, 
    0x0000534D, 0x00002363, 0x0000535B, 0x00002342, 
    0x00005369, 0x00002322, 0x00005377, 0x00002301, 
    0x00005385, 0x000022E0, 0x00005392, 0x000022BF, 
    0x000053A0, 0x0000229E, 0x000053AD, 0x0000227E, 
    0x000053BB, 0x0000225D, 0x000053C8, 0x0000223C, 
    0x000053D6, 0x0000221B, 0x000053E3, 0x000021FA, 
    0x000053F1, 0x000021D9, 0x000053FE, 0x000021B8, 
    0x0000540B, 0x00002197, 0x00005418, 0x00002176, 
    0x00005425, 0x00002155, 0x00005432, 0x00002134, 
    0x0000543F, 0x00002113, 0x0000544C, 0x000020F2, 
    0x00005459, 0x000020D1, 0x00005466, 0x000020AF, 
    0x00005473, 0x0000208E, 0x00005480, 0x0000206D, 
    0x0000548C, 0x0000204C, 0x00005499, 0x0000202B, 
    0x000054A6, 0x00002009, 0x000054B2, 0x00001FE8, 
    0x000054BF, 0x00001FC7, 0x000054CB, 0x00001FA6, 
    0x000054D8, 0x00001F84, 0x000054E4, 0x00001F63, 
    0x000054F0, 0x00001F42, 0x000054FD, 0x00001F20, 
    0x00005509, 0x00001EFF, 0x00005515, 0x00001EDE, 
    0x00005521, 0x00001EBC, 0x0000552D, 0x00001E9B, 
    0x00005539, 0x00001E79, 0x00005545, 0x00001E58, 
    0x00005551, 0x00001E36, 0x0000555D, 0x00001E15, 
    0x00005568, 0x00001DF3, 0x00005574, 0x00001DD2, 
    0x00005580, 0x00001DB0, 0x0000558C, 0x00001D8E, 
    0x00005597, 0x00001D6D, 0x000055A3, 0x00001D4B, 
    0x000055AE, 0x00001D2A, 0x000055BA, 0x00001D08, 
    0x000055C5, 0x00001CE6, 0x000055D0, 0x00001CC5, 
    0x000055DC, 0x00001CA3, 0x000055E7, 0x00001C81, 
    0x000055F2, 0x00001C5F, 0x000055FD, 0x00001C3E, 
    0x00005608, 0x00001C1C, 0x00005613, 0x00001BFA, 
    0x0000561E, 0x00001BD8, 0x00005629, 0x00001BB6, 
    0x00005634, 0x00001B95, 0x0000563F, 0x00001B73, 
    0x00005649, 0x00001B51, 0x00005654, 0x00001B2F, 
    0x0000565F, 0x00001B0D, 0x00005669, 0x00001AEB, 
    0x00005674, 0x00001AC9, 0x0000567E, 0x00001AA7, 
    0x00005689, 0x00001A85, 0x00005693, 0x00001A63, 
    0x0000569E, 0x00001A41, 0x000056A8, 0x00001A1F, 
    0x000056B2, 0x000019FD, 0x000056BC, 0x000019DB, 
    0x000056C6, 0x000019B9, 0x000056D0, 0x00001997, 
    0x000056DA, 0x00001975, 0x000056E4, 0x00001953, 
    0x000056EE, 0x00001931, 0x000056F8, 0x0000190F, 
    0x00005702, 0x000018EC, 0x0000570C, 0x000018CA, 
    0x00005716, 0x000018A8, 0x0000571F, 0x00001886, 
    0x00005729, 0x00001864, 0x00005732, 0x00001841, 
    0x0000573C, 0x0000181F, 0x00005745, 0x000017FD, 
    0x0000574F, 0x000017DB, 0x00005758, 0x000017B8, 
    0x00005761, 0x00001796, 0x0000576B, 0x00001774, 
    0x00005774, 0x00001751, 0x0000577D, 0x0000172F, 
    0x00005786, 0x0000170D, 0x0000578F, 0x000016EA, 
    0x00005798, 0x000016C8, 0x000057A1, 0x000016A5, 
    0x000057AA, 0x00001683, 0x000057B3, 0x00001661, 
    0x000057BB, 0x0000163E, 0x000057C4, 0x0000161C, 
    0x000057CD, 0x000015F9, 0x000057D5, 0x000015D7, 
    0x000057DE, 0x000015B4, 0x000057E6, 0x00001592, 
    0x000057EF, 0x0000156F, 0x000057F7, 0x0000154D, 
    0x000057FF, 0x0000152A, 0x00005808, 0x00001507, 
    0x00005810, 0x000014E5, 0x00005818, 0x000014C2, 
    0x00005820, 0x000014A0, 0x00005828, 0x0000147D, 
    0x00005830, 0x0000145A, 0x00005838, 0x00001438, 
    0x00005840, 0x00001415, 0x00005848, 0x000013F3, 
    0x00005850, 0x000013D0, 0x00005858, 0x000013AD, 
    0x0000585F, 0x0000138A, 0x00005867, 0x00001368, 
    0x0000586F, 0x00001345, 0x00005876, 0x00001322, 
    0x0000587E, 0x00001300, 0x00005885, 0x000012DD, 
    0x0000588C, 0x000012BA, 0x00005894, 0x00001297, 
    0x0000589B, 0x00001274, 0x000058A2, 0x00001252, 
    0x000058A9, 0x0000122F, 0x000058B1, 0x0000120C, 
    0x000058B8, 0x000011E9, 0x000058BF, 0x000011C6, 
    0x000058C6, 0x000011A3, 0x000058CD, 0x00001181, 
    0x000058D3, 0x0000115E, 0x000058DA, 0x0000113B, 
    0x000058E1, 0x00001118, 0x000058E8, 0x000010F5, 
    0x000058EE, 0x000010D2, 0x000058F5, 0x000010AF, 
    0x000058FB, 0x0000108C, 0x00005902, 0x00001069, 
    0x00005908, 0x00001046, 0x0000590F, 0x00001023, 
    0x00005915, 0x00001000, 0x0000591B, 0x00000FDD, 
    0x00005921, 0x00000FBA, 0x00005928, 0x00000F97, 
    0x0000592E, 0x00000F74, 0x00005934, 0x00000F51, 
    0x0000593A, 0x00000F2E, 0x00005940, 0x00000F0B, 
    0x00005945, 0x00000EE8, 0x0000594B, 0x00000EC5, 
    0x00005951, 0x00000EA2, 0x00005957, 0x00000E7F, 
    0x0000595C, 0x00000E5C, 0x00005962, 0x00000E39, 
    0x00005968, 0x00000E16, 0x0000596D, 0x00000DF3, 
    0x00005973, 0x00000DCF, 0x00005978, 0x00000DAC, 
    0x0000597D, 0x00000D89, 0x00005983, 0x00000D66, 
    0x00005988, 0x00000D43, 0x0000598D, 0x00000D20, 
    0x00005992, 0x00000CFD, 0x00005997, 0x00000CD9, 
    0x0000599C, 0x00000CB6, 0x000059A1, 0x00000C93, 
    0x000059A6, 0x00000C70, 0x000059AB, 0x00000C4D, 
    0x000059B0, 0x00000C29, 0x000059B5, 0x00000C06, 
    0x000059B9, 0x00000BE3, 0x000059BE, 0x00000BC0, 
    0x000059C2, 0x00000B9C, 0x000059C7, 0x00000B79, 
    0x000059CB, 0x00000B56, 0x000059D0, 0x00000B33, 
    0x000059D4, 0x00000B0F, 0x000059D9, 0x00000AEC, 
    0x000059DD, 0x00000AC9, 0x000059E1, 0x00000AA6, 
    0x000059E5, 0x00000A82, 0x000059E9, 0x00000A5F, 
    0x000059ED, 0x00000A3C, 0x000059F1, 0x00000A18, 
    0x000059F5, 0x000009F5, 0x000059F9, 0x000009D2, 
    0x000059FD, 0x000009AE, 0x00005A01, 0x0000098B, 
    0x00005A04, 0x00000968, 0x00005A08, 0x00000944, 
    0x00005A0C, 0x00000921, 0x00005A0F, 0x000008FE, 
    0x00005A13, 0x000008DA, 0x00005A16, 0x000008B7, 
    0x00005A1A, 0x00000893, 0x00005A1D, 0x00000870, 
    0x00005A20, 0x0000084D, 0x00005A24, 0x00000829, 
    0x00005A27, 0x00000806, 0x00005A2A, 0x000007E2, 
    0x00005A2D, 0x000007BF, 0x00005A30, 0x0000079C, 
    0x00005A33, 0x00000778, 0x00005A36, 0x00000755, 
    0x00005A39, 0x00000731, 0x00005A3B, 0x0000070E, 
    0x00005A3E, 0x000006EA, 0x00005A41, 0x000006C7, 
    0x00005A44, 0x000006A4, 0x00005A46, 0x00000680, 
    0x00005A49, 0x0000065D, 0x00005A4B, 0x00000639, 
    0x00005A4E, 0x00000616, 0x00005A50, 0x000005F2, 
    0x00005A52, 0x000005CF, 0x00005A54, 0x000005AB, 
    0x00005A57, 0x00000588, 0x00005A59, 0x00000564, 
    0x00005A5B, 0x00000541, 0x00005A5D, 0x0000051D, 
    0x00005A5F, 0x000004FA, 0x00005A61, 0x000004D6, 
    0x00005A63, 0x000004B3, 0x00005A65, 0x0000048F, 
    0x00005A66, 0x0000046C, 0x00005A68, 0x00000448, 
    0x00005A6A, 0x00000425, 0x00005A6B, 0x00000401, 
    0x00005A6D, 0x000003DE, 0x00005A6E, 0x000003BA, 
    0x00005A70, 0x00000397, 0x00005A71, 0x00000373, 
    0x00005A72, 0x00000350, 0x00005A74, 0x0000032C, 
    0x00005A75, 0x00000309, 0x00005A76, 0x000002E5, 
    0x00005A77, 0x000002C2, 0x00005A78, 0x0000029E, 
    0x00005A79, 0x0000027B, 0x00005A7A, 0x00000257, 
    0x00005A7B, 0x00000234, 0x00005A7C, 0x00000210, 
    0x00005A7D, 0x000001ED, 0x00005A7D, 0x000001C9, 
    0x00005A7E, 0x000001A6, 0x00005A7F, 0x00000182, 
    0x00005A7F, 0x0000015E, 0x00005A80, 0x0000013B, 
    0x00005A80, 0x00000117, 0x00005A81, 0x000000F4, 
    0x00005A81, 0x000000D0, 0x00005A81, 0x000000AD, 
    0x00005A82, 0x00000089, 0x00005A82, 0x00000066, 
    0x00005A82, 0x00000042, 0x00005A82, 0x0000001F, 
    0x00000001, 0x00004000, 0x0000000E, 0x00003FFF, 
    0x0000001A, 0x00003FFF, 0x00000027, 0x00003FFF, 
    0x00000033, 0x00003FFF, 0x00000040, 0x00003FFF, 
    0x0000004C, 0x00003FFF, 0x00000059, 0x00003FFF, 
    0x00000066, 0x00003FFF, 0x00000072, 0x00003FFF, 
    0x0000007F, 0x00003FFF, 0x0000008B, 0x00003FFF, 
    0x00000098, 0x00003FFF, 0x000000A4, 0x00003FFF, 
    0x000000B1, 0x00003FFF, 0x000000BE, 0x00003FFE, 
    0x000000CA, 0x00003FFE, 0x000000D7, 0x00003FFE, 
    0x000000E3, 0x00003FFE, 0x000000F0, 0x00003FFE, 
    0x000000FC, 0x00003FFE, 0x00000109, 0x00003FFD, 
    0x00000116, 0x00003FFD, 0x00000122, 0x00003FFD, 
    0x0000012F, 0x00003FFD, 0x0000013B, 0x00003FFC, 
    0x00000148, 0x00003FFC, 0x00000154, 0x00003FFC, 
    0x00000161, 0x00003FFC, 0x0000016D, 0x00003FFB, 
    0x0000017A, 0x00003FFB, 0x00000187, 0x00003FFB, 
    0x00000193, 0x00003FFB, 0x000001A0, 0x00003FFA, 
    0x000001AC, 0x00003FFA, 0x000001B9, 0x00003FFA, 
    0x000001C5, 0x00003FF9, 0x000001D2, 0x00003FF9, 
    0x000001DF, 0x00003FF8, 0x000001EB, 0x00003FF8, 
    0x000001F8, 0x00003FF8, 0x00000204, 0x00003FF7, 
    0x00000211, 0x00003FF7, 0x0000021D, 0x00003FF7, 
    0x0000022A, 0x00003FF6, 0x00000236, 0x00003FF6, 
    0x00000243, 0x00003FF5, 0x00000250, 0x00003FF5, 
    0x0000025C, 0x00003FF4, 0x00000269, 0x00003FF4, 
    0x00000275, 0x00003FF3, 0x00000282, 0x00003FF3, 
    0x0000028E, 0x00003FF2, 0x0000029B, 0x00003FF2, 
    0x000002A7, 0x00003FF1, 0x000002B4, 0x00003FF1, 
    0x000002C1, 0x00003FF0, 0x000002CD, 0x00003FF0, 
    0x000002DA, 0x00003FEF, 0x000002E6, 0x00003FEF, 
    0x000002F3, 0x00003FEE, 0x000002FF, 0x00003FED, 
    0x0000030C, 0x00003FED, 0x00000318, 0x00003FEC, 
    0x00000325, 0x00003FEC, 0x00000332, 0x00003FEB, 
    0x0000033E, 0x00003FEA, 0x0000034B, 0x00003FEA, 
    0x00000357, 0x00003FE9, 0x00000364, 0x00003FE8, 
    0x00000370, 0x00003FE8, 0x0000037D, 0x00003FE7, 
    0x00000389, 0x00003FE6, 0x00000396, 0x00003FE6, 
    0x000003A2, 0x00003FE5, 0x000003AF, 0x00003FE4, 
    0x000003BC, 0x00003FE4, 0x000003C8, 0x00003FE3, 
    0x000003D5, 0x00003FE2, 0x000003E1, 0x00003FE1, 
    0x000003EE, 0x00003FE1, 0x000003FA, 0x00003FE0, 
    0x00000407, 0x00003FDF, 0x00000413, 0x00003FDE, 
    0x00000420, 0x00003FDD, 0x0000042C, 0x00003FDD, 
    0x00000439, 0x00003FDC, 0x00000446, 0x00003FDB, 
    0x00000452, 0x00003FDA, 0x0000045F, 0x00003FD9, 
    0x0000046B, 0x00003FD8, 0x00000478, 0x00003FD7, 
    0x00000484, 0x00003FD7, 0x00000491, 0x00003FD6, 
    0x0000049D, 0x00003FD5, 0x000004AA, 0x00003FD4, 
    0x000004B6, 0x00003FD3, 0x000004C3, 0x00003FD2, 
    0x000004CF, 0x00003FD1, 0x000004DC, 0x00003FD0, 
    0x000004E8, 0x00003FCF, 0x000004F5, 0x00003FCE, 
    0x00000502, 0x00003FCD, 0x0000050E, 0x00003FCC, 
    0x0000051B, 0x00003FCB, 0x00000527, 0x00003FCA, 
    0x00000534, 0x00003FC9, 0x00000540, 0x00003FC8, 
    0x0000054D, 0x00003FC7, 0x00000559, 0x00003FC6, 
    0x00000566, 0x00003FC5, 0x00000572, 0x00003FC4, 
    0x0000057F, 0x00003FC3, 0x0000058B, 0x00003FC2, 
    0x00000598, 0x00003FC1, 0x000005A4, 0x00003FC0, 
    0x000005B1, 0x00003FBF, 0x000005BD, 0x00003FBD, 
    0x000005CA, 0x00003FBC, 0x000005D6, 0x00003FBB, 
    0x000005E3, 0x00003FBA, 0x000005EF, 0x00003FB9, 
    0x000005FC, 0x00003FB8, 0x00000608, 0x00003FB6, 
    0x00000615, 0x00003FB5, 0x00000621, 0x00003FB4, 
    0x0000062E, 0x00003FB3, 0x0000063A, 0x00003FB2, 
    0x00000647, 0x00003FB0, 0x00000653, 0x00003FAF, 
    0x00000660, 0x00003FAE, 0x0000066C, 0x00003FAD, 
    0x00000679, 0x00003FAB, 0x00000685, 0x00003FAA, 
    0x00000692, 0x00003FA9, 0x0000069E, 0x00003FA8, 
    0x000006AB, 0x00003FA6, 0x000006B7, 0x00003FA5, 
    0x000006C4, 0x00003FA4, 0x000006D0, 0x00003FA2, 
    0x000006DD, 0x00003FA1, 0x000006E9, 0x00003FA0, 
    0x000006F6, 0x00003F9E, 0x00000702, 0x00003F9D, 
    0x0000070F, 0x00003F9B, 0x0000071B, 0x00003F9A, 
    0x00000728, 0x00003F99, 0x00000734, 0x00003F97, 
    0x00000741, 0x00003F96, 0x0000074D, 0x00003F94, 
    0x0000075A, 0x00003F93, 0x00000766, 0x00003F92, 
    0x00000773, 0x00003F90, 0x0000077F, 0x00003F8F, 
    0x0000078C, 0x00003F8D, 0x00000798, 0x00003F8C, 
    0x000007A5, 0x00003F8A, 0x000007B1, 0x00003F89, 
    0x000007BE, 0x00003F87, 0x000007CA, 0x00003F86, 
    0x000007D7, 0x00003F84, 0x000007E3, 0x00003F83, 
    0x000007F0, 0x00003F81, 0x000007FC, 0x00003F7F, 
    0x00000809, 0x00003F7E, 0x00000815, 0x00003F7C, 
    0x00000821, 0x00003F7B, 0x0000082E, 0x00003F79, 
    0x0000083A, 0x00003F77, 0x00000847, 0x00003F76, 
    0x00000853, 0x00003F74, 0x00000860, 0x00003F73, 
    0x0000086C, 0x00003F71, 0x00000879, 0x00003F6F, 
    0x00000885, 0x00003F6E, 0x00000892, 0x00003F6C, 
    0x0000089E, 0x00003F6A, 0x000008AA, 0x00003F69, 
    0x000008B7, 0x00003F67, 0x000008C3, 0x00003F65, 
    0x000008D0, 0x00003F63, 0x000008DC, 0x00003F62, 
    0x000008E9, 0x00003F60, 0x000008F5, 0x00003F5E, 
    0x00000902, 0x00003F5C, 0x0000090E, 0x00003F5B, 
    0x0000091A, 0x00003F59, 0x00000927, 0x00003F57, 
    0x00000933, 0x00003F55, 0x00000940, 0x00003F53, 
    0x0000094C, 0x00003F52, 0x00000959, 0x00003F50, 
    0x00000965, 0x00003F4E, 0x00000972, 0x00003F4C, 
    0x0000097E, 0x00003F4A, 0x0000098A, 0x00003F48, 
    0x00000997, 0x00003F46, 0x000009A3, 0x00003F45, 
    0x000009B0, 0x00003F43, 0x000009BC, 0x00003F41, 
    0x000009C8, 0x00003F3F, 0x000009D5, 0x00003F3D, 
    0x000009E1, 0x00003F3B, 0x000009EE, 0x00003F39, 
    0x000009FA, 0x00003F37, 0x00000A07, 0x00003F35, 
    0x00000A13, 0x00003F33, 0x00000A1F, 0x00003F31, 
    0x00000A2C, 0x00003F2F, 0x00000A38, 0x00003F2D, 
    0x00000A45, 0x00003F2B, 0x00000A51, 0x00003F29, 
    0x00000A5D, 0x00003F27, 0x00000A6A, 0x00003F25, 
    0x00000A76, 0x00003F23, 0x00000A83, 0x00003F21, 
    0x00000A8F, 0x00003F1F, 0x00000A9B, 0x00003F1D, 
    0x00000AA8, 0x00003F1B, 0x00000AB4, 0x00003F19, 
    0x00000AC1, 0x00003F17, 0x00000ACD, 0x00003F14, 
    0x00000AD9, 0x00003F12, 0x00000AE6, 0x00003F10, 
    0x00000AF2, 0x00003F0E, 0x00000AFE, 0x00003F0C, 
    0x00000B0B, 0x00003F0A, 0x00000B17, 0x00003F08, 
    0x00000B24, 0x00003F05, 0x00000B30, 0x00003F03, 
    0x00000B3C, 0x00003F01, 0x00000B49, 0x00003EFF, 
    0x00000B55, 0x00003EFD, 0x00000B61, 0x00003EFA, 
    0x00000B6E, 0x00003EF8, 0x00000B7A, 0x00003EF6, 
    0x00000B87, 0x00003EF4, 0x00000B93, 0x00003EF1, 
    0x00000B9F, 0x00003EEF, 0x00000BAC, 0x00003EED, 
    0x00000BB8, 0x00003EEA, 0x00000BC4, 0x00003EE8, 
    0x00000BD1, 0x00003EE6, 0x00000BDD, 0x00003EE3, 
    0x00000BE9, 0x00003EE1, 0x00000BF6, 0x00003EDF, 
    0x00000C02, 0x00003EDC, 0x00000C0E, 0x00003EDA, 
    0x00000C1B, 0x00003ED8, 0x00000C27, 0x00003ED5, 
    0x00000C33, 0x00003ED3, 0x00000C40, 0x00003ED1, 
    0x00000C4C, 0x00003ECE, 0x00000C58, 0x00003ECC, 
    0x00000C65, 0x00003EC9, 0x00000C71, 0x00003EC7, 
    0x00000C7D, 0x00003EC4, 0x00000C8A, 0x00003EC2, 
    0x00000C96, 0x00003EBF, 0x00000CA2, 0x00003EBD, 
    0x00000CAF, 0x00003EBA, 0x00000CBB, 0x00003EB8, 
    0x00000CC7, 0x00003EB5, 0x00000CD4, 0x00003EB3, 
    0x00000CE0, 0x00003EB0, 0x00000CEC, 0x00003EAE, 
    0x00000CF9, 0x00003EAB, 0x00000D05, 0x00003EA9, 
    0x00000D11, 0x00003EA6, 0x00000D1D, 0x00003EA4, 
    0x00000D2A, 0x00003EA1, 0x00000D36, 0x00003E9F, 
    0x00000D42, 0x00003E9C, 0x00000D4F, 0x00003E99, 
    0x00000D5B, 0x00003E97, 0x00000D67, 0x00003E94, 
    0x00000D74, 0x00003E91, 0x00000D80, 0x00003E8F, 
    0x00000D8C, 0x00003E8C, 0x00000D98, 0x00003E89, 
    0x00000DA5, 0x00003E87, 0x00000DB1, 0x00003E84, 
    0x00000DBD, 0x00003E81, 0x00000DC9, 0x00003E7F, 
    0x00000DD6, 0x00003E7C, 0x00000DE2, 0x00003E79, 
    0x00000DEE, 0x00003E77, 0x00000DFB, 0x00003E74, 
    0x00000E07, 0x00003E71, 0x00000E13, 0x00003E6E, 
    0x00000E1F, 0x00003E6C, 0x00000E2C, 0x00003E69, 
    0x00000E38, 0x00003E66, 0x00000E44, 0x00003E63, 
    0x00000E50, 0x00003E60, 0x00000E5D, 0x00003E5E, 
    0x00000E69, 0x00003E5B, 0x00000E75, 0x00003E58, 
    0x00000E81, 0x00003E55, 0x00000E8E, 0x00003E52, 
    0x00000E9A, 0x00003E4F, 0x00000EA6, 0x00003E4C, 
    0x00000EB2, 0x00003E4A, 0x00000EBE, 0x00003E47, 
    0x00000ECB, 0x00003E44, 0x00000ED7, 0x00003E41, 
    0x00000EE3, 0x00003E3E, 0x00000EEF, 0x00003E3B, 
    0x00000EFC, 0x00003E38, 0x00000F08, 0x00003E35, 
    0x00000F14, 0x00003E32, 0x00000F20, 0x00003E2F, 
    0x00000F2C, 0x00003E2C, 0x00000F39, 0x00003E29, 
    0x00000F45, 0x00003E26, 0x00000F51, 0x00003E23, 
    0x00000F5D, 0x00003E20, 0x00000F69, 0x00003E1D, 
    0x00000F76, 0x00003E1A, 0x00000F82, 0x00003E17, 
    0x00000F8E, 0x00003E14, 0x00000F9A, 0x00003E11, 
    0x00000FA6, 0x00003E0E, 0x00000FB3, 0x00003E0B, 
    0x00000FBF, 0x00003E08, 0x00000FCB, 0x00003E05, 
    0x00000FD7, 0x00003E02, 0x00000FE3, 0x00003DFF, 
    0x00000FEF, 0x00003DFB, 0x00000FFC, 0x00003DF8, 
    0x00001008, 0x00003DF5, 0x00001014, 0x00003DF2, 
    0x00001020, 0x00003DEF, 0x0000102C, 0x00003DEC, 
    0x00001038, 0x00003DE8, 0x00001045, 0x00003DE5, 
    0x00001051, 0x00003DE2, 0x0000105D, 0x00003DDF, 
    0x00001069, 0x00003DDC, 0x00001075, 0x00003DD8, 
    0x00001081, 0x00003DD5, 0x0000108D, 0x00003DD2, 
    0x0000109A, 0x00003DCF, 0x000010A6, 0x00003DCB, 
    0x000010B2, 0x00003DC8, 0x000010BE, 0x00003DC5, 
    0x000010CA, 0x00003DC2, 0x000010D6, 0x00003DBE, 
    0x000010E2, 0x00003DBB, 0x000010EE, 0x00003DB8, 
    0x000010FB, 0x00003DB4, 0x00001107, 0x00003DB1, 
    0x00001113, 0x00003DAE, 0x0000111F, 0x00003DAA, 
    0x0000112B, 0x00003DA7, 0x00001137, 0x00003DA3, 
    0x00001143, 0x00003DA0, 0x0000114F, 0x00003D9D, 
    0x0000115B, 0x00003D99, 0x00001168, 0x00003D96, 
    0x00001174, 0x00003D92, 0x00001180, 0x00003D8F, 
    0x0000118C, 0x00003D8C, 0x00001198, 0x00003D88, 
    0x000011A4, 0x00003D85, 0x000011B0, 0x00003D81, 
    0x000011BC, 0x00003D7E, 0x000011C8, 0x00003D7A, 
    0x000011D4, 0x00003D77, 0x000011E0, 0x00003D73, 
    0x000011EC, 0x00003D70, 0x000011F8, 0x00003D6C, 
    0x00001205, 0x00003D69, 0x00001211, 0x00003D65, 
    0x0000121D, 0x00003D62, 0x00001229, 0x00003D5E, 
    0x00001235, 0x00003D5A, 0x00001241, 0x00003D57, 
    0x0000124D, 0x00003D53, 0x00001259, 0x00003D50, 
    0x00001265, 0x00003D4C, 0x00001271, 0x00003D48, 
    0x0000127D, 0x00003D45, 0x00001289, 0x00003D41, 
    0x00001295, 0x00003D3E, 0x000012A1, 0x00003D3A, 
    0x000012AD, 0x00003D36, 0x000012B9, 0x00003D33, 
    0x000012C5, 0x00003D2F, 0x000012D1, 0x00003D2B, 
    0x000012DD, 0x00003D27, 0x000012E9, 0x00003D24, 
    0x000012F5, 0x00003D20, 0x00001301, 0x00003D1C, 
    0x0000130D, 0x00003D19, 0x00001319, 0x00003D15, 
    0x00001325, 0x00003D11, 0x00001331, 0x00003D0D, 
    0x0000133D, 0x00003D0A, 0x00001349, 0x00003D06, 
    0x00001355, 0x00003D02, 0x00001361, 0x00003CFE, 
    0x0000136D, 0x00003CFA, 0x00001379, 0x00003CF7, 
    0x00001385, 0x00003CF3, 0x00001391, 0x00003CEF, 
    0x0000139D, 0x00003CEB, 0x000013A9, 0x00003CE7, 
    0x000013B5, 0x00003CE3, 0x000013C1, 0x00003CDF, 
    0x000013CD, 0x00003CDC, 0x000013D9, 0x00003CD8, 
    0x000013E5, 0x00003CD4, 0x000013F1, 0x00003CD0, 
    0x000013FC, 0x00003CCC, 0x00001408, 0x00003CC8, 
    0x00001414, 0x00003CC4, 0x00001420, 0x00003CC0, 
    0x0000142C, 0x00003CBC, 0x00001438, 0x00003CB8, 
    0x00001444, 0x00003CB4, 0x00001450, 0x00003CB0, 
    0x0000145C, 0x00003CAC, 0x00001468, 0x00003CA8, 
    0x00001474, 0x00003CA4, 0x00001480, 0x00003CA0, 
    0x0000148C, 0x00003C9C, 0x00001497, 0x00003C98, 
    0x000014A3, 0x00003C94, 0x000014AF, 0x00003C90, 
    0x000014BB, 0x00003C8C, 0x000014C7, 0x00003C88, 
    0x000014D3, 0x00003C84, 0x000014DF, 0x00003C80, 
    0x000014EB, 0x00003C7C, 0x000014F7, 0x00003C78, 
    0x00001502, 0x00003C73, 0x0000150E, 0x00003C6F, 
    0x0000151A, 0x00003C6B, 0x00001526, 0x00003C67, 
    0x00001532, 0x00003C63, 0x0000153E, 0x00003C5F, 
    0x0000154A, 0x00003C5A, 0x00001555, 0x00003C56, 
    0x00001561, 0x00003C52, 0x0000156D, 0x00003C4E, 
    0x00001579, 0x00003C4A, 0x00001585, 0x00003C45, 
    0x00001591, 0x00003C41, 0x0000159C, 0x00003C3D, 
    0x000015A8, 0x00003C39, 0x000015B4, 0x00003C34, 
    0x000015C0, 0x00003C30, 0x000015CC, 0x00003C2C, 
    0x000015D8, 0x00003C28, 0x000015E3, 0x00003C23, 
    0x000015EF, 0x00003C1F, 0x000015FB, 0x00003C1B, 
    0x00001607, 0x00003C16, 0x00001613, 0x00003C12, 
    0x0000161E, 0x00003C0E, 0x0000162A, 0x00003C09, 
    0x00001636, 0x00003C05, 0x00001642, 0x00003C01, 
    0x0000164D, 0x00003BFC, 0x00001659, 0x00003BF8, 
    0x00001665, 0x00003BF4, 0x00001671, 0x00003BEF, 
    0x0000167D, 0x00003BEB, 0x00001688, 0x00003BE6, 
    0x00001694, 0x00003BE2, 0x000016A0, 0x00003BDD, 
    0x000016AC, 0x00003BD9, 0x000016B7, 0x00003BD5, 
    0x000016C3, 0x00003BD0, 0x000016CF, 0x00003BCC, 
    0x000016DB, 0x00003BC7, 0x000016E6, 0x00003BC3, 
    0x000016F2, 0x00003BBE, 0x000016FE, 0x00003BBA, 
    0x00001709, 0x00003BB5, 0x00001715, 0x00003BB1, 
    0x00001721, 0x00003BAC, 0x0000172D, 0x00003BA7, 
    0x00001738, 0x00003BA3, 0x00001744, 0x00003B9E, 
    0x00001750, 0x00003B9A, 0x0000175B, 0x00003B95, 
    0x00001767, 0x00003B91, 0x00001773, 0x00003B8C, 
    0x0000177F, 0x00003B87, 0x0000178A, 0x00003B83, 
    0x00001796, 0x00003B7E, 0x000017A2, 0x00003B7A, 
    0x000017AD, 0x00003B75, 0x000017B9, 0x00003B70, 
    0x000017C5, 0x00003B6C, 0x000017D0, 0x00003B67, 
    0x000017DC, 0x00003B62, 0x000017E8, 0x00003B5E, 
    0x000017F3, 0x00003B59, 0x000017FF, 0x00003B54, 
    0x0000180B, 0x00003B4F, 0x00001816, 0x00003B4B, 
    0x00001822, 0x00003B46, 0x0000182D, 0x00003B41, 
    0x00001839, 0x00003B3C, 0x00001845, 0x00003B38, 
    0x00001850, 0x00003B33, 0x0000185C, 0x00003B2E, 
    0x00001868, 0x00003B29, 0x00001873, 0x00003B25, 
    0x0000187F, 0x00003B20, 0x0000188A, 0x00003B1B, 
    0x00001896, 0x00003B16, 0x000018A2, 0x00003B11, 
    0x000018AD, 0x00003B0C, 0x000018B9, 0x00003B08, 
    0x000018C4, 0x00003B03, 0x000018D0, 0x00003AFE, 
    0x000018DC, 0x00003AF9, 0x000018E7, 0x00003AF4, 
    0x000018F3, 0x00003AEF, 0x000018FE, 0x00003AEA, 
    0x0000190A, 0x00003AE5, 0x00001915, 0x00003AE0, 
    0x00001921, 0x00003ADC, 0x0000192D, 0x00003AD7, 
    0x00001938, 0x00003AD2, 0x00001944, 0x00003ACD, 
    0x0000194F, 0x00003AC8, 0x0000195B, 0x00003AC3, 
    0x00001966, 0x00003ABE, 0x00001972, 0x00003AB9, 
    0x0000197D, 0x00003AB4, 0x00001989, 0x00003AAF, 
    0x00001994, 0x00003AAA, 0x000019A0, 0x00003AA5, 
    0x000019AB, 0x00003AA0, 0x000019B7, 0x00003A9B, 
    0x000019C2, 0x00003A96, 0x000019CE, 0x00003A91, 
    0x000019D9, 0x00003A8B, 0x000019E5, 0x00003A86, 
    0x000019F0, 0x00003A81, 0x000019FC, 0x00003A7C, 
    0x00001A07, 0x00003A77, 0x00001A13, 0x00003A72, 
    0x00001A1E, 0x00003A6D, 0x00001A2A, 0x00003A68, 
    0x00001A35, 0x00003A63, 0x00001A41, 0x00003A5D, 
    0x00001A4C, 0x00003A58, 0x00001A58, 0x00003A53, 
    0x00001A63, 0x00003A4E, 0x00001A6F, 0x00003A49, 
    0x00001A7A, 0x00003A44, 0x00001A85, 0x00003A3E, 
    0x00001A91, 0x00003A39, 0x00001A9C, 0x00003A34, 
    0x00001AA8, 0x00003A2F, 0x00001AB3, 0x00003A29, 
    0x00001ABF, 0x00003A24, 0x00001ACA, 0x00003A1F, 
    0x00001AD5, 0x00003A1A, 0x00001AE1, 0x00003A14, 
    0x00001AEC, 0x00003A0F, 0x00001AF8, 0x00003A0A, 
    0x00001B03, 0x00003A05, 0x00001B0E, 0x000039FF, 
    0x00001B1A, 0x000039FA, 0x00001B25, 0x000039F5, 
    0x00001B31, 0x000039EF, 0x00001B3C, 0x000039EA, 
    0x00001B47, 0x000039E5, 0x00001B53, 0x000039DF, 
    0x00001B5E, 0x000039DA, 0x00001B69, 0x000039D4, 
    0x00001B75, 0x000039CF, 0x00001B80, 0x000039CA, 
    0x00001B8B, 0x000039C4, 0x00001B97, 0x000039BF, 
    0x00001BA2, 0x000039B9, 0x00001BAD, 0x000039B4, 
    0x00001BB9, 0x000039AF, 0x00001BC4, 0x000039A9, 
    0x00001BCF, 0x000039A4, 0x00001BDB, 0x0000399E, 
    0x00001BE6, 0x00003999, 0x00001BF1, 0x00003993, 
    0x00001BFD, 0x0000398E, 0x00001C08, 0x00003988, 
    0x00001C13, 0x00003983, 0x00001C1E, 0x0000397D, 
    0x00001C2A, 0x00003978, 0x00001C35, 0x00003972, 
    0x00001C40, 0x0000396D, 0x00001C4C, 0x00003967, 
    0x00001C57, 0x00003961, 0x00001C62, 0x0000395C, 
    0x00001C6D, 0x00003956, 0x00001C79, 0x00003951, 
    0x00001C84, 0x0000394B, 0x00001C8F, 0x00003946, 
    0x00001C9A, 0x00003940, 0x00001CA6, 0x0000393A, 
    0x00001CB1, 0x00003935, 0x00001CBC, 0x0000392F, 
    0x00001CC7, 0x00003929, 0x00001CD3, 0x00003924, 
    0x00001CDE, 0x0000391E, 0x00001CE9, 0x00003918, 
    0x00001CF4, 0x00003913, 0x00001CFF, 0x0000390D, 
    0x00001D0B, 0x00003907, 0x00001D16, 0x00003902, 
    0x00001D21, 0x000038FC, 0x00001D2C, 0x000038F6, 
    0x00001D37, 0x000038F0, 0x00001D43, 0x000038EB, 
    0x00001D4E, 0x000038E5, 0x00001D59, 0x000038DF, 
    0x00001D64, 0x000038D9, 0x00001D6F, 0x000038D4, 
    0x00001D7A, 0x000038CE, 0x00001D86, 0x000038C8, 
    0x00001D91, 0x000038C2, 0x00001D9C, 0x000038BC, 
    0x00001DA7, 0x000038B7, 0x00001DB2, 0x000038B1, 
    0x00001DBD, 0x000038AB, 0x00001DC8, 0x000038A5, 
    0x00001DD3, 0x0000389F, 0x00001DDF, 0x00003899, 
    0x00001DEA, 0x00003894, 0x00001DF5, 0x0000388E, 
    0x00001E00, 0x00003888, 0x00001E0B, 0x00003882, 
    0x00001E16, 0x0000387C, 0x00001E21, 0x00003876, 
    0x00001E2C, 0x00003870, 0x00001E37, 0x0000386A, 
    0x00001E42, 0x00003864, 0x00001E4D, 0x0000385E, 
    0x00001E59, 0x00003858, 0x00001E64, 0x00003852, 
    0x00001E6F, 0x0000384C, 0x00001E7A, 0x00003846, 
    0x00001E85, 0x00003840, 0x00001E90, 0x0000383A, 
    0x00001E9B, 0x00003834, 0x00001EA6, 0x0000382E, 
    0x00001EB1, 0x00003828, 0x00001EBC, 0x00003822, 
    0x00001EC7, 0x0000381C, 0x00001ED2, 0x00003816, 
    0x00001EDD, 0x00003810, 0x00001EE8, 0x0000380A, 
    0x00001EF3, 0x00003804, 0x00001EFE, 0x000037FE, 
    0x00001F09, 0x000037F8, 0x00001F14, 0x000037F2, 
    0x00001F1F, 0x000037EC, 0x00001F2A, 0x000037E6, 
    0x00001F35, 0x000037E0, 0x00001F40, 0x000037D9, 
    0x00001F4B, 0x000037D3, 0x00001F56, 0x000037CD, 
    0x00001F61, 0x000037C7, 0x00001F6C, 0x000037C1, 
    0x00001F77, 0x000037BB, 0x00001F82, 0x000037B4, 
    0x00001F8D, 0x000037AE, 0x00001F97, 0x000037A8, 
    0x00001FA2, 0x000037A2, 0x00001FAD, 0x0000379C, 
    0x00001FB8, 0x00003795, 0x00001FC3, 0x0000378F, 
    0x00001FCE, 0x00003789, 0x00001FD9, 0x00003783, 
    0x00001FE4, 0x0000377C, 0x00001FEF, 0x00003776, 
    0x00001FFA, 0x00003770, 0x00002004, 0x0000376A, 
    0x0000200F, 0x00003763, 0x0000201A, 0x0000375D, 
    0x00002025, 0x00003757, 0x00002030, 0x00003750, 
    0x0000203B, 0x0000374A, 0x00002046, 0x00003744, 
    0x00002051, 0x0000373D, 0x0000205B, 0x00003737, 
    0x00002066, 0x00003731, 0x00002071, 0x0000372A, 
    0x0000207C, 0x00003724, 0x00002087, 0x0000371E, 
    0x00002092, 0x00003717, 0x0000209C, 0x00003711, 
    0x000020A7, 0x0000370A, 0x000020B2, 0x00003704, 
    0x000020BD, 0x000036FD, 0x000020C8, 0x000036F7, 
    0x000020D2, 0x000036F1, 0x000020DD, 0x000036EA, 
    0x000020E8, 0x000036E4, 0x000020F3, 0x000036DD, 
    0x000020FD, 0x000036D7, 0x00002108, 0x000036D0, 
    0x00002113, 0x000036CA, 0x0000211E, 0x000036C3, 
    0x00002128, 0x000036BD, 0x00002133, 0x000036B6, 
    0x0000213E, 0x000036B0, 0x00002149, 0x000036A9, 
    0x00002153, 0x000036A3, 0x0000215E, 0x0000369C, 
    0x00002169, 0x00003696, 0x00002174, 0x0000368F, 
    0x0000217E, 0x00003688, 0x00002189, 0x00003682, 
    0x00002194, 0x0000367B, 0x0000219E, 0x00003675, 
    0x000021A9, 0x0000366E, 0x000021B4, 0x00003667, 
    0x000021BE, 0x00003661, 0x000021C9, 0x0000365A, 
    0x000021D4, 0x00003654, 0x000021DE, 0x0000364D, 
    0x000021E9, 0x00003646, 0x000021F4, 0x00003640, 
    0x000021FE, 0x00003639, 0x00002209, 0x00003632, 
    0x00002214, 0x0000362C, 0x0000221E, 0x00003625, 
    0x00002229, 0x0000361E, 0x00002234, 0x00003617, 
    0x0000223E, 0x00003611, 0x00002249, 0x0000360A, 
    0x00002253, 0x00003603, 0x0000225E, 0x000035FD, 
    0x00002269, 0x000035F6, 0x00002273, 0x000035EF, 
    0x0000227E, 0x000035E8, 0x00002288, 0x000035E1, 
    0x00002293, 0x000035DB, 0x0000229E, 0x000035D4, 
    0x000022A8, 0x000035CD, 0x000022B3, 0x000035C6, 
    0x000022BD, 0x000035BF, 0x000022C8, 0x000035B9, 
    0x000022D2, 0x000035B2, 0x000022DD, 0x000035AB, 
    0x000022E7, 0x000035A4, 0x000022F2, 0x0000359D, 
    0x000022FC, 0x00003596, 0x00002307, 0x00003590, 
    0x00002312, 0x00003589, 0x0000231C, 0x00003582, 
    0x00002327, 0x0000357B, 0x00002331, 0x00003574, 
    0x0000233C, 0x0000356D, 0x00002346, 0x00003566, 
    0x00002350, 0x0000355F, 0x0000235B, 0x00003558, 
    0x00002365, 0x00003551, 0x00002370, 0x0000354A, 
    0x0000237A, 0x00003543, 0x00002385, 0x0000353C, 
    0x0000238F, 0x00003535, 0x0000239A, 0x0000352E, 
    0x000023A4, 0x00003527, 0x000023AF, 0x00003520, 
    0x000023B9, 0x00003519, 0x000023C3, 0x00003512, 
    0x000023CE, 0x0000350B, 0x000023D8, 0x00003504, 
    0x000023E3, 0x000034FD, 0x000023ED, 0x000034F6, 
    0x000023F7, 0x000034EF, 0x00002402, 0x000034E8, 
    0x0000240C, 0x000034E1, 0x00002417, 0x000034DA, 
    0x00002421, 0x000034D3, 0x0000242B, 0x000034CC, 
    0x00002436, 0x000034C5, 0x00002440, 0x000034BE, 
    0x0000244A, 0x000034B6, 0x00002455, 0x000034AF, 
    0x0000245F, 0x000034A8, 0x00002469, 0x000034A1, 
    0x00002474, 0x0000349A, 0x0000247E, 0x00003493, 
    0x00002488, 0x0000348C, 0x00002493, 0x00003484, 
    0x0000249D, 0x0000347D, 0x000024A7, 0x00003476, 
    0x000024B2, 0x0000346F, 0x000024BC, 0x00003468, 
    0x000024C6, 0x00003460, 0x000024D1, 0x00003459, 
    0x000024DB, 0x00003452, 0x000024E5, 0x0000344B, 
    0x000024EF, 0x00003443, 0x000024FA, 0x0000343C, 
    0x00002504, 0x00003435, 0x0000250E, 0x0000342E, 
    0x00002518, 0x00003426, 0x00002523, 0x0000341F, 
    0x0000252D, 0x00003418, 0x00002537, 0x00003410, 
    0x00002541, 0x00003409, 0x0000254B, 0x00003402, 
    0x00002556, 0x000033FA, 0x00002560, 0x000033F3, 
    0x0000256A, 0x000033EC, 0x00002574, 0x000033E4, 
    0x0000257E, 0x000033DD, 0x00002589, 0x000033D6, 
    0x00002593, 0x000033CE, 0x0000259D, 0x000033C7, 
    0x000025A7, 0x000033C0, 0x000025B1, 0x000033B8, 
    0x000025BB, 0x000033B1, 0x000025C6, 0x000033A9, 
    0x000025D0, 0x000033A2, 0x000025DA, 0x0000339B, 
    0x000025E4, 0x00003393, 0x000025EE, 0x0000338C, 
    0x000025F8, 0x00003384, 0x00002602, 0x0000337D, 
    0x0000260D, 0x00003375, 0x00002617, 0x0000336E, 
    0x00002621, 0x00003366, 0x0000262B, 0x0000335F, 
    0x00002635, 0x00003357, 0x0000263F, 0x00003350, 
    0x00002649, 0x00003348, 0x00002653, 0x00003341, 
    0x0000265D, 0x00003339, 0x00002667, 0x00003332, 
    0x00002671, 0x0000332A, 0x0000267B, 0x00003323, 
    0x00002685, 0x0000331B, 0x0000268F, 0x00003313, 
    0x00002699, 0x0000330C, 0x000026A3, 0x00003304, 
    0x000026AD, 0x000032FD, 0x000026B7, 0x000032F5, 
    0x000026C1, 0x000032EE, 0x000026CB, 0x000032E6, 
    0x000026D5, 0x000032DE, 0x000026DF, 0x000032D7, 
    0x000026E9, 0x000032CF, 0x000026F3, 0x000032C7, 
    0x000026FD, 0x000032C0, 0x00002707, 0x000032B8, 
    0x00002711, 0x000032B0, 0x0000271B, 0x000032A9, 
    0x00002725, 0x000032A1, 0x0000272F, 0x00003299, 
    0x00002739, 0x00003292, 0x00002743, 0x0000328A, 
    0x0000274D, 0x00003282, 0x00002757, 0x0000327B, 
    0x00002761, 0x00003273, 0x0000276B, 0x0000326B, 
    0x00002774, 0x00003263, 0x0000277E, 0x0000325C, 
    0x00002788, 0x00003254, 0x00002792, 0x0000324C, 
    0x0000279C, 0x00003244, 0x000027A6, 0x0000323C, 
    0x000027B0, 0x00003235, 0x000027BA, 0x0000322D, 
    0x000027C3, 0x00003225, 0x000027CD, 0x0000321D, 
    0x000027D7, 0x00003215, 0x000027E1, 0x0000320E, 
    0x000027EB, 0x00003206, 0x000027F5, 0x000031FE, 
    0x000027FE, 0x000031F6, 0x00002808, 0x000031EE, 
    0x00002812, 0x000031E6, 0x0000281C, 0x000031DF, 
    0x00002826, 0x000031D7, 0x0000282F, 0x000031CF, 
    0x00002839, 0x000031C7, 0x00002843, 0x000031BF, 
    0x0000284D, 0x000031B7, 0x00002856, 0x000031AF, 
    0x00002860, 0x000031A7, 0x0000286A, 0x0000319F, 
    0x00002874, 0x00003197, 0x0000287D, 0x0000318F, 
    0x00002887, 0x00003187, 0x00002891, 0x0000317F, 
    0x0000289B, 0x00003178, 0x000028A4, 0x00003170, 
    0x000028AE, 0x00003168, 0x000028B8, 0x00003160, 
    0x000028C1, 0x00003158, 0x000028CB, 0x00003150, 
    0x000028D5, 0x00003148, 0x000028DE, 0x00003140, 
    0x000028E8, 0x00003137, 0x000028F2, 0x0000312F, 
    0x000028FB, 0x00003127, 0x00002905, 0x0000311F, 
    0x0000290F, 0x00003117, 0x00002918, 0x0000310F, 
    0x00002922, 0x00003107, 0x0000292C, 0x000030FF, 
    0x00002935, 0x000030F7, 0x0000293F, 0x000030EF, 
    0x00002948, 0x000030E7, 0x00002952, 0x000030DF, 
    0x0000295C, 0x000030D7, 0x00002965, 0x000030CE, 
    0x0000296F, 0x000030C6, 0x00002978, 0x000030BE, 
    0x00002982, 0x000030B6, 0x0000298C, 0x000030AE, 
    0x00002995, 0x000030A6, 0x0000299F, 0x0000309E, 
    0x000029A8, 0x00003095, 0x000029B2, 0x0000308D, 
    0x000029BB, 0x00003085, 0x000029C5, 0x0000307D, 
    0x000029CE, 0x00003075, 0x000029D8, 0x0000306C, 
    0x000029E1, 0x00003064, 0x000029EB, 0x0000305C, 
    0x000029F4, 0x00003054, 0x000029FE, 0x0000304B, 
    0x00002A07, 0x00003043, 0x00002A11, 0x0000303B, 
    0x00002A1A, 0x00003033, 0x00002A24, 0x0000302A, 
    0x00002A2D, 0x00003022, 0x00002A37, 0x0000301A, 
    0x00002A40, 0x00003012, 0x00002A49, 0x00003009, 
    0x00002A53, 0x00003001, 0x00002A5C, 0x00002FF9, 
    0x00002A66, 0x00002FF0, 0x00002A6F, 0x00002FE8, 
    0x00002A79, 0x00002FE0, 0x00002A82, 0x00002FD7, 
    0x00002A8B, 0x00002FCF, 0x00002A95, 0x00002FC7, 
    0x00002A9E, 0x00002FBE, 0x00002AA7, 0x00002FB6, 
    0x00002AB1, 0x00002FAD, 0x00002ABA, 0x00002FA5, 
    0x00002AC4, 0x00002F9D, 0x00002ACD, 0x00002F94, 
    0x00002AD6, 0x00002F8C, 0x00002AE0, 0x00002F83, 
    0x00002AE9, 0x00002F7B, 0x00002AF2, 0x00002F73, 
    0x00002AFB, 0x00002F6A, 0x00002B05, 0x00002F62, 
    0x00002B0E, 0x00002F59, 0x00002B17, 0x00002F51, 
    0x00002B21, 0x00002F48, 0x00002B2A, 0x00002F40, 
    0x00002B33, 0x00002F37, 0x00002B3C, 0x00002F2F, 
    0x00002B46, 0x00002F26, 0x00002B4F, 0x00002F1E, 
    0x00002B58, 0x00002F15, 0x00002B62, 0x00002F0D, 
    0x00002B6B, 0x00002F04, 0x00002B74, 0x00002EFC, 
    0x00002B7D, 0x00002EF3, 0x00002B86, 0x00002EEB, 
    0x00002B90, 0x00002EE2, 0x00002B99, 0x00002EDA, 
    0x00002BA2, 0x00002ED1, 0x00002BAB, 0x00002EC9, 
    0x00002BB4, 0x00002EC0, 0x00002BBE, 0x00002EB7, 
    0x00002BC7, 0x00002EAF, 0x00002BD0, 0x00002EA6, 
    0x00002BD9, 0x00002E9E, 0x00002BE2, 0x00002E95, 
    0x00002BEB, 0x00002E8C, 0x00002BF4, 0x00002E84, 
    0x00002BFE, 0x00002E7B, 0x00002C07, 0x00002E72, 
    0x00002C10, 0x00002E6A, 0x00002C19, 0x00002E61, 
    0x00002C22, 0x00002E58, 0x00002C2B, 0x00002E50, 
    0x00002C34, 0x00002E47, 0x00002C3D, 0x00002E3E, 
    0x00002C46, 0x00002E36, 0x00002C4F, 0x00002E2D, 
    0x00002C59, 0x00002E24, 0x00002C62, 0x00002E1C, 
    0x00002C6B, 0x00002E13, 0x00002C74, 0x00002E0A, 
    0x00002C7D, 0x00002E01, 0x00002C86, 0x00002DF9, 
    0x00002C8F, 0x00002DF0, 0x00002C98, 0x00002DE7, 
    0x00002CA1, 0x00002DDE, 0x00002CAA, 0x00002DD6, 
    0x00002CB3, 0x00002DCD, 0x00002CBC, 0x00002DC4, 
    0x00002CC5, 0x00002DBB, 0x00002CCE, 0x00002DB3, 
    0x00002CD7, 0x00002DAA, 0x00002CE0, 0x00002DA1, 
    0x00002CE9, 0x00002D98, 0x00002CF2, 0x00002D8F, 
    0x00002CFB, 0x00002D87, 0x00002D03, 0x00002D7E, 
    0x00002D0C, 0x00002D75, 0x00002D15, 0x00002D6C, 
    0x00002D1E, 0x00002D63, 0x00002D27, 0x00002D5A, 
    0x00002D30, 0x00002D51, 0x00002D39, 0x00002D49, 
    0x00002D42, 0x00002D40, 0x00002D4B, 0x00002D37, 
    0x00002D54, 0x00002D2E, 0x00002D5C, 0x00002D25, 
    0x00002D65, 0x00002D1C, 0x00002D6E, 0x00002D13, 
    0x00002D77, 0x00002D0A, 0x00002D80, 0x00002D01, 
    0x00002D89, 0x00002CF8, 0x00002D92, 0x00002CEF, 
    0x00002D9A, 0x00002CE6, 0x00002DA3, 0x00002CDD, 
    0x00002DAC, 0x00002CD4, 0x00002DB5, 0x00002CCC, 
    0x00002DBE, 0x00002CC3, 0x00002DC6, 0x00002CBA, 
    0x00002DCF, 0x00002CB1, 0x00002DD8, 0x00002CA8, 
    0x00002DE1, 0x00002C9F, 0x00002DE9, 0x00002C96, 
    0x00002DF2, 0x00002C8D, 0x00002DFB, 0x00002C84, 
    0x00002E04, 0x00002C7A, 0x00002E0C, 0x00002C71, 
    0x00002E15, 0x00002C68, 0x00002E1E, 0x00002C5F, 
    0x00002E27, 0x00002C56, 0x00002E2F, 0x00002C4D, 
    0x00002E38, 0x00002C44, 0x00002E41, 0x00002C3B, 
    0x00002E49, 0x00002C32, 0x00002E52, 0x00002C29, 
    0x00002E5B, 0x00002C20, 0x00002E63, 0x00002C17, 
    0x00002E6C, 0x00002C0E, 0x00002E75, 0x00002C04, 
    0x00002E7D, 0x00002BFB, 0x00002E86, 0x00002BF2, 
    0x00002E8F, 0x00002BE9, 0x00002E97, 0x00002BE0, 
    0x00002EA0, 0x00002BD7, 0x00002EA8, 0x00002BCE, 
    0x00002EB1, 0x00002BC4, 0x00002EBA, 0x00002BBB, 
    0x00002EC2, 0x00002BB2, 0x00002ECB, 0x00002BA9, 
    0x00002ED3, 0x00002BA0, 0x00002EDC, 0x00002B97, 
    0x00002EE4, 0x00002B8D, 0x00002EED, 0x00002B84, 
    0x00002EF5, 0x00002B7B, 0x00002EFE, 0x00002B72, 
    0x00002F07, 0x00002B68, 0x00002F0F, 0x00002B5F, 
    0x00002F18, 0x00002B56, 0x00002F20, 0x00002B4D, 
    0x00002F29, 0x00002B43, 0x00002F31, 0x00002B3A, 
    0x00002F3A, 0x00002B31, 0x00002F42, 0x00002B28, 
    0x00002F4A, 0x00002B1E, 0x00002F53, 0x00002B15, 
    0x00002F5B, 0x00002B0C, 0x00002F64, 0x00002B02, 
    0x00002F6C, 0x00002AF9, 0x00002F75, 0x00002AF0, 
    0x00002F7D, 0x00002AE7, 0x00002F86, 0x00002ADD, 
    0x00002F8E, 0x00002AD4, 0x00002F96, 0x00002ACB, 
    0x00002F9F, 0x00002AC1, 0x00002FA7, 0x00002AB8, 
    0x00002FB0, 0x00002AAE, 0x00002FB8, 0x00002AA5, 
    0x00002FC0, 0x00002A9C, 0x00002FC9, 0x00002A92, 
    0x00002FD1, 0x00002A89, 0x00002FD9, 0x00002A80, 
    0x00002FE2, 0x00002A76, 0x00002FEA, 0x00002A6D, 
    0x00002FF2, 0x00002A63, 0x00002FFB, 0x00002A5A, 
    0x00003003, 0x00002A51, 0x0000300B, 0x00002A47, 
    0x00003014, 0x00002A3E, 0x0000301C, 0x00002A34, 
    0x00003024, 0x00002A2B, 0x0000302C, 0x00002A21, 
    0x00003035, 0x00002A18, 0x0000303D, 0x00002A0E, 
    0x00003045, 0x00002A05, 0x0000304E, 0x000029FB, 
    0x00003056, 0x000029F2, 0x0000305E, 0x000029E8, 
    0x00003066, 0x000029DF, 0x0000306E, 0x000029D5, 
    0x00003077, 0x000029CC, 0x0000307F, 0x000029C2, 
    0x00003087, 0x000029B9, 0x0000308F, 0x000029AF, 
    0x00003097, 0x000029A6, 0x000030A0, 0x0000299C, 
    0x000030A8, 0x00002993, 0x000030B0, 0x00002989, 
    0x000030B8, 0x00002980, 0x000030C0, 0x00002976, 
    0x000030C8, 0x0000296C, 0x000030D0, 0x00002963, 
    0x000030D9, 0x00002959, 0x000030E1, 0x00002950, 
    0x000030E9, 0x00002946, 0x000030F1, 0x0000293C, 
    0x000030F9, 0x00002933, 0x00003101, 0x00002929, 
    0x00003109, 0x00002920, 0x00003111, 0x00002916, 
    0x00003119, 0x0000290C, 0x00003121, 0x00002903, 
    0x00003129, 0x000028F9, 0x00003131, 0x000028EF, 
    0x00003139, 0x000028E6, 0x00003142, 0x000028DC, 
    0x0000314A, 0x000028D2, 0x00003152, 0x000028C9, 
    0x0000315A, 0x000028BF, 0x00003162, 0x000028B5, 
    0x0000316A, 0x000028AC, 0x00003172, 0x000028A2, 
    0x0000317A, 0x00002898, 0x00003181, 0x0000288E, 
    0x00003189, 0x00002885, 0x00003191, 0x0000287B, 
    0x00003199, 0x00002871, 0x000031A1, 0x00002868, 
    0x000031A9, 0x0000285E, 0x000031B1, 0x00002854, 
    0x000031B9, 0x0000284A, 0x000031C1, 0x00002841, 
    0x000031C9, 0x00002837, 0x000031D1, 0x0000282D, 
    0x000031D9, 0x00002823, 0x000031E0, 0x00002819, 
    0x000031E8, 0x00002810, 0x000031F0, 0x00002806, 
    0x000031F8, 0x000027FC, 0x00003200, 0x000027F2, 
    0x00003208, 0x000027E8, 0x00003210, 0x000027DF, 
    0x00003217, 0x000027D5, 0x0000321F, 0x000027CB, 
    0x00003227, 0x000027C1, 0x0000322F, 0x000027B7, 
    0x00003237, 0x000027AD, 0x0000323E, 0x000027A3, 
    0x00003246, 0x0000279A, 0x0000324E, 0x00002790, 
    0x00003256, 0x00002786, 0x0000325E, 0x0000277C, 
    0x00003265, 0x00002772, 0x0000326D, 0x00002768, 
    0x00003275, 0x0000275E, 0x0000327C, 0x00002754, 
    0x00003284, 0x0000274A, 0x0000328C, 0x00002740, 
    0x00003294, 0x00002737, 0x0000329B, 0x0000272D, 
    0x000032A3, 0x00002723, 0x000032AB, 0x00002719, 
    0x000032B2, 0x0000270F, 0x000032BA, 0x00002705, 
    0x000032C2, 0x000026FB, 0x000032C9, 0x000026F1, 
    0x000032D1, 0x000026E7, 0x000032D9, 0x000026DD, 
    0x000032E0, 0x000026D3, 0x000032E8, 0x000026C9, 
    0x000032EF, 0x000026BF, 0x000032F7, 0x000026B5, 
    0x000032FF, 0x000026AB, 0x00003306, 0x000026A1, 
    0x0000330E, 0x00002697, 0x00003315, 0x0000268D, 
    0x0000331D, 0x00002683, 0x00003325, 0x00002679, 
    0x0000332C, 0x0000266F, 0x00003334, 0x00002665, 
    0x0000333B, 0x0000265B, 0x00003343, 0x00002651, 
    0x0000334A, 0x00002647, 0x00003352, 0x0000263C, 
    0x00003359, 0x00002632, 0x00003361, 0x00002628, 
    0x00003368, 0x0000261E, 0x00003370, 0x00002614, 
    0x00003377, 0x0000260A, 0x0000337F, 0x00002600, 
    0x00003386, 0x000025F6, 0x0000338E, 0x000025EC, 
    0x00003395, 0x000025E2, 0x0000339C, 0x000025D7, 
    0x000033A4, 0x000025CD, 0x000033AB, 0x000025C3, 
    0x000033B3, 0x000025B9, 0x000033BA, 0x000025AF, 
    0x000033C1, 0x000025A5, 0x000033C9, 0x0000259A, 
    0x000033D0, 0x00002590, 0x000033D8, 0x00002586, 
    0x000033DF, 0x0000257C, 0x000033E6, 0x00002572, 
    0x000033EE, 0x00002568, 0x000033F5, 0x0000255D, 
    0x000033FC, 0x00002553, 0x00003404, 0x00002549, 
    0x0000340B, 0x0000253F, 0x00003412, 0x00002535, 
    0x0000341A, 0x0000252A, 0x00003421, 0x00002520, 
    0x00003428, 0x00002516, 0x0000342F, 0x0000250C, 
    0x00003437, 0x00002501, 0x0000343E, 0x000024F7, 
    0x00003445, 0x000024ED, 0x0000344C, 0x000024E3, 
    0x00003454, 0x000024D8, 0x0000345B, 0x000024CE, 
    0x00003462, 0x000024C4, 0x00003469, 0x000024B9, 
    0x00003471, 0x000024AF, 0x00003478, 0x000024A5, 
    0x0000347F, 0x0000249B, 0x00003486, 0x00002490, 
    0x0000348D, 0x00002486, 0x00003495, 0x0000247C, 
    0x0000349C, 0x00002471, 0x000034A3, 0x00002467, 
    0x000034AA, 0x0000245D, 0x000034B1, 0x00002452, 
    0x000034B8, 0x00002448, 0x000034BF, 0x0000243E, 
    0x000034C6, 0x00002433, 0x000034CE, 0x00002429, 
    0x000034D5, 0x0000241E, 0x000034DC, 0x00002414, 
    0x000034E3, 0x0000240A, 0x000034EA, 0x000023FF, 
    0x000034F1, 0x000023F5, 0x000034F8, 0x000023EA, 
    0x000034FF, 0x000023E0, 0x00003506, 0x000023D6, 
    0x0000350D, 0x000023CB, 0x00003514, 0x000023C1, 
    0x0000351B, 0x000023B6, 0x00003522, 0x000023AC, 
    0x00003529, 0x000023A2, 0x00003530, 0x00002397, 
    0x00003537, 0x0000238D, 0x0000353E, 0x00002382, 
    0x00003545, 0x00002378, 0x0000354C, 0x0000236D, 
    0x00003553, 0x00002363, 0x0000355A, 0x00002358, 
    0x00003561, 0x0000234E, 0x00003568, 0x00002343, 
    0x0000356F, 0x00002339, 0x00003576, 0x0000232E, 
    0x0000357D, 0x00002324, 0x00003583, 0x00002319, 
    0x0000358A, 0x0000230F, 0x00003591, 0x00002304, 
    0x00003598, 0x000022FA, 0x0000359F, 0x000022EF, 
    0x000035A6, 0x000022E5, 0x000035AD, 0x000022DA, 
    0x000035B4, 0x000022D0, 0x000035BA, 0x000022C5, 
    0x000035C1, 0x000022BB, 0x000035C8, 0x000022B0, 
    0x000035CF, 0x000022A5, 0x000035D6, 0x0000229B, 
    0x000035DC, 0x00002290, 0x000035E3, 0x00002286, 
    0x000035EA, 0x0000227B, 0x000035F1, 0x00002271, 
    0x000035F7, 0x00002266, 0x000035FE, 0x0000225B, 
    0x00003605, 0x00002251, 0x0000360C, 0x00002246, 
    0x00003612, 0x0000223C, 0x00003619, 0x00002231, 
    0x00003620, 0x00002226, 0x00003627, 0x0000221C, 
    0x0000362D, 0x00002211, 0x00003634, 0x00002206, 
    0x0000363B, 0x000021FC, 0x00003641, 0x000021F1, 
    0x00003648, 0x000021E6, 0x0000364F, 0x000021DC, 
    0x00003655, 0x000021D1, 0x0000365C, 0x000021C6, 
    0x00003662, 0x000021BC, 0x00003669, 0x000021B1, 
    0x00003670, 0x000021A6, 0x00003676, 0x0000219C, 
    0x0000367D, 0x00002191, 0x00003684, 0x00002186, 
    0x0000368A, 0x0000217C, 0x00003691, 0x00002171, 
    0x00003697, 0x00002166, 0x0000369E, 0x0000215B, 
    0x000036A4, 0x00002151, 0x000036AB, 0x00002146, 
    0x000036B1, 0x0000213B, 0x000036B8, 0x00002131, 
    0x000036BE, 0x00002126, 0x000036C5, 0x0000211B, 
    0x000036CB, 0x00002110, 0x000036D2, 0x00002106, 
    0x000036D8, 0x000020FB, 0x000036DF, 0x000020F0, 
    0x000036E5, 0x000020E5, 0x000036EC, 0x000020DA, 
    0x000036F2, 0x000020D0, 0x000036F9, 0x000020C5, 
    0x000036FF, 0x000020BA, 0x00003706, 0x000020AF, 
    0x0000370C, 0x000020A4, 0x00003712, 0x0000209A, 
    0x00003719, 0x0000208F, 0x0000371F, 0x00002084, 
    0x00003726, 0x00002079, 0x0000372C, 0x0000206E, 
    0x00003732, 0x00002064, 0x00003739, 0x00002059, 
    0x0000373F, 0x0000204E, 0x00003745, 0x00002043, 
    0x0000374C, 0x00002038, 0x00003752, 0x0000202D, 
    0x00003758, 0x00002022, 0x0000375F, 0x00002018, 
    0x00003765, 0x0000200D, 0x0000376B, 0x00002002, 
    0x00003771, 0x00001FF7, 0x00003778, 0x00001FEC, 
    0x0000377E, 0x00001FE1, 0x00003784, 0x00001FD6, 
    0x0000378A, 0x00001FCB, 0x00003791, 0x00001FC0, 
    0x00003797, 0x00001FB5, 0x0000379D, 0x00001FAB, 
    0x000037A3, 0x00001FA0, 0x000037AA, 0x00001F95, 
    0x000037B0, 0x00001F8A, 0x000037B6, 0x00001F7F, 
    0x000037BC, 0x00001F74, 0x000037C2, 0x00001F69, 
    0x000037C8, 0x00001F5E, 0x000037CF, 0x00001F53, 
    0x000037D5, 0x00001F48, 0x000037DB, 0x00001F3D, 
    0x000037E1, 0x00001F32, 0x000037E7, 0x00001F27, 
    0x000037ED, 0x00001F1C, 0x000037F3, 0x00001F11, 
    0x000037F9, 0x00001F06, 0x00003800, 0x00001EFB, 
    0x00003806, 0x00001EF0, 0x0000380C, 0x00001EE5, 
    0x00003812, 0x00001EDA, 0x00003818, 0x00001ECF, 
    0x0000381E, 0x00001EC4, 0x00003824, 0x00001EB9, 
    0x0000382A, 0x00001EAE, 0x00003830, 0x00001EA3, 
    0x00003836, 0x00001E98, 0x0000383C, 0x00001E8D, 
    0x00003842, 0x00001E82, 0x00003848, 0x00001E77, 
    0x0000384E, 0x00001E6C, 0x00003854, 0x00001E61, 
    0x0000385A, 0x00001E56, 0x00003860, 0x00001E4B, 
    0x00003866, 0x00001E40, 0x0000386C, 0x00001E35, 
    0x00003872, 0x00001E29, 0x00003878, 0x00001E1E, 
    0x0000387D, 0x00001E13, 0x00003883, 0x00001E08, 
    0x00003889, 0x00001DFD, 0x0000388F, 0x00001DF2, 
    0x00003895, 0x00001DE7, 0x0000389B, 0x00001DDC, 
    0x000038A1, 0x00001DD1, 0x000038A7, 0x00001DC6, 
    0x000038AC, 0x00001DBA, 0x000038B2, 0x00001DAF, 
    0x000038B8, 0x00001DA4, 0x000038BE, 0x00001D99, 
    0x000038C4, 0x00001D8E, 0x000038CA, 0x00001D83, 
    0x000038CF, 0x00001D78, 0x000038D5, 0x00001D6C, 
    0x000038DB, 0x00001D61, 0x000038E1, 0x00001D56, 
    0x000038E6, 0x00001D4B, 0x000038EC, 0x00001D40, 
    0x000038F2, 0x00001D35, 0x000038F8, 0x00001D29, 
    0x000038FD, 0x00001D1E, 0x00003903, 0x00001D13, 
    0x00003909, 0x00001D08, 0x0000390E, 0x00001CFD, 
    0x00003914, 0x00001CF1, 0x0000391A, 0x00001CE6, 
    0x0000391F, 0x00001CDB, 0x00003925, 0x00001CD0, 
    0x0000392B, 0x00001CC5, 0x00003930, 0x00001CB9, 
    0x00003936, 0x00001CAE, 0x0000393C, 0x00001CA3, 
    0x00003941, 0x00001C98, 0x00003947, 0x00001C8C, 
    0x0000394D, 0x00001C81, 0x00003952, 0x00001C76, 
    0x00003958, 0x00001C6B, 0x0000395D, 0x00001C5F, 
    0x00003963, 0x00001C54, 0x00003968, 0x00001C49, 
    0x0000396E, 0x00001C3E, 0x00003974, 0x00001C32, 
    0x00003979, 0x00001C27, 0x0000397F, 0x00001C1C, 
    0x00003984, 0x00001C10, 0x0000398A, 0x00001C05, 
    0x0000398F, 0x00001BFA, 0x00003995, 0x00001BEE, 
    0x0000399A, 0x00001BE3, 0x000039A0, 0x00001BD8, 
    0x000039A5, 0x00001BCD, 0x000039AA, 0x00001BC1, 
    0x000039B0, 0x00001BB6, 0x000039B5, 0x00001BAB, 
    0x000039BB, 0x00001B9F, 0x000039C0, 0x00001B94, 
    0x000039C6, 0x00001B89, 0x000039CB, 0x00001B7D, 
    0x000039D0, 0x00001B72, 0x000039D6, 0x00001B67, 
    0x000039DB, 0x00001B5B, 0x000039E0, 0x00001B50, 
    0x000039E6, 0x00001B44, 0x000039EB, 0x00001B39, 
    0x000039F1, 0x00001B2E, 0x000039F6, 0x00001B22, 
    0x000039FB, 0x00001B17, 0x00003A01, 0x00001B0C, 
    0x00003A06, 0x00001B00, 0x00003A0B, 0x00001AF5, 
    0x00003A10, 0x00001AE9, 0x00003A16, 0x00001ADE, 
    0x00003A1B, 0x00001AD3, 0x00003A20, 0x00001AC7, 
    0x00003A25, 0x00001ABC, 0x00003A2B, 0x00001AB0, 
    0x00003A30, 0x00001AA5, 0x00003A35, 0x00001A99, 
    0x00003A3A, 0x00001A8E, 0x00003A40, 0x00001A83, 
    0x00003A45, 0x00001A77, 0x00003A4A, 0x00001A6C, 
    0x00003A4F, 0x00001A60, 0x00003A54, 0x00001A55, 
    0x00003A5A, 0x00001A49, 0x00003A5F, 0x00001A3E, 
    0x00003A64, 0x00001A32, 0x00003A69, 0x00001A27, 
    0x00003A6E, 0x00001A1B, 0x00003A73, 0x00001A10, 
    0x00003A78, 0x00001A05, 0x00003A7D, 0x000019F9, 
    0x00003A83, 0x000019EE, 0x00003A88, 0x000019E2, 
    0x00003A8D, 0x000019D7, 0x00003A92, 0x000019CB, 
    0x00003A97, 0x000019C0, 0x00003A9C, 0x000019B4, 
    0x00003AA1, 0x000019A9, 0x00003AA6, 0x0000199D, 
    0x00003AAB, 0x00001992, 0x00003AB0, 0x00001986, 
    0x00003AB5, 0x0000197A, 0x00003ABA, 0x0000196F, 
    0x00003ABF, 0x00001963, 0x00003AC4, 0x00001958, 
    0x00003AC9, 0x0000194C, 0x00003ACE, 0x00001941, 
    0x00003AD3, 0x00001935, 0x00003AD8, 0x0000192A, 
    0x00003ADD, 0x0000191E, 0x00003AE2, 0x00001913, 
    0x00003AE7, 0x00001907, 0x00003AEC, 0x000018FB, 
    0x00003AF0, 0x000018F0, 0x00003AF5, 0x000018E4, 
    0x00003AFA, 0x000018D9, 0x00003AFF, 0x000018CD, 
    0x00003B04, 0x000018C2, 0x00003B09, 0x000018B6, 
    0x00003B0E, 0x000018AA, 0x00003B12, 0x0000189F, 
    0x00003B17, 0x00001893, 0x00003B1C, 0x00001888, 
    0x00003B21, 0x0000187C, 0x00003B26, 0x00001870, 
    0x00003B2B, 0x00001865, 0x00003B2F, 0x00001859, 
    0x00003B34, 0x0000184D, 0x00003B39, 0x00001842, 
    0x00003B3E, 0x00001836, 0x00003B42, 0x0000182B, 
    0x00003B47, 0x0000181F, 0x00003B4C, 0x00001813, 
    0x00003B51, 0x00001808, 0x00003B55, 0x000017FC, 
    0x00003B5A, 0x000017F0, 0x00003B5F, 0x000017E5, 
    0x00003B63, 0x000017D9, 0x00003B68, 0x000017CD, 
    0x00003B6D, 0x000017C2, 0x00003B71, 0x000017B6, 
    0x00003B76, 0x000017AA, 0x00003B7B, 0x0000179F, 
    0x00003B7F, 0x00001793, 0x00003B84, 0x00001787, 
    0x00003B89, 0x0000177C, 0x00003B8D, 0x00001770, 
    0x00003B92, 0x00001764, 0x00003B96, 0x00001759, 
    0x00003B9B, 0x0000174D, 0x00003BA0, 0x00001741, 
    0x00003BA4, 0x00001735, 0x00003BA9, 0x0000172A, 
    0x00003BAD, 0x0000171E, 0x00003BB2, 0x00001712, 
    0x00003BB6, 0x00001707, 0x00003BBB, 0x000016FB, 
    0x00003BBF, 0x000016EF, 0x00003BC4, 0x000016E3, 
    0x00003BC8, 0x000016D8, 0x00003BCD, 0x000016CC, 
    0x00003BD1, 0x000016C0, 0x00003BD6, 0x000016B4, 
    0x00003BDA, 0x000016A9, 0x00003BDF, 0x0000169D, 
    0x00003BE3, 0x00001691, 0x00003BE7, 0x00001685, 
    0x00003BEC, 0x0000167A, 0x00003BF0, 0x0000166E, 
    0x00003BF5, 0x00001662, 0x00003BF9, 0x00001656, 
    0x00003BFD, 0x0000164B, 0x00003C02, 0x0000163F, 
    0x00003C06, 0x00001633, 0x00003C0B, 0x00001627, 
    0x00003C0F, 0x0000161B, 0x00003C13, 0x00001610, 
    0x00003C18, 0x00001604, 0x00003C1C, 0x000015F8, 
    0x00003C20, 0x000015EC, 0x00003C24, 0x000015E0, 
    0x00003C29, 0x000015D5, 0x00003C2D, 0x000015C9, 
    0x00003C31, 0x000015BD, 0x00003C36, 0x000015B1, 
    0x00003C3A, 0x000015A5, 0x00003C3E, 0x00001599, 
    0x00003C42, 0x0000158E, 0x00003C47, 0x00001582, 
    0x00003C4B, 0x00001576, 0x00003C4F, 0x0000156A, 
    0x00003C53, 0x0000155E, 0x00003C57, 0x00001552, 
    0x00003C5C, 0x00001547, 0x00003C60, 0x0000153B, 
    0x00003C64, 0x0000152F, 0x00003C68, 0x00001523, 
    0x00003C6C, 0x00001517, 0x00003C70, 0x0000150B, 
    0x00003C74, 0x000014FF, 0x00003C79, 0x000014F4, 
    0x00003C7D, 0x000014E8, 0x00003C81, 0x000014DC, 
    0x00003C85, 0x000014D0, 0x00003C89, 0x000014C4, 
    0x00003C8D, 0x000014B8, 0x00003C91, 0x000014AC, 
    0x00003C95, 0x000014A0, 0x00003C99, 0x00001494, 
    0x00003C9D, 0x00001489, 0x00003CA1, 0x0000147D, 
    0x00003CA5, 0x00001471, 0x00003CA9, 0x00001465, 
    0x00003CAD, 0x00001459, 0x00003CB1, 0x0000144D, 
    0x00003CB5, 0x00001441, 0x00003CB9, 0x00001435, 
    0x00003CBD, 0x00001429, 0x00003CC1, 0x0000141D, 
    0x00003CC5, 0x00001411, 0x00003CC9, 0x00001405, 
    0x00003CCD, 0x000013F9, 0x00003CD1, 0x000013EE, 
    0x00003CD5, 0x000013E2, 0x00003CD9, 0x000013D6, 
    0x00003CDD, 0x000013CA, 0x00003CE0, 0x000013BE, 
    0x00003CE4, 0x000013B2, 0x00003CE8, 0x000013A6, 
    0x00003CEC, 0x0000139A, 0x00003CF0, 0x0000138E, 
    0x00003CF4, 0x00001382, 0x00003CF8, 0x00001376, 
    0x00003CFB, 0x0000136A, 0x00003CFF, 0x0000135E, 
    0x00003D03, 0x00001352, 0x00003D07, 0x00001346, 
    0x00003D0B, 0x0000133A, 0x00003D0E, 0x0000132E, 
    0x00003D12, 0x00001322, 0x00003D16, 0x00001316, 
    0x00003D1A, 0x0000130A, 0x00003D1D, 0x000012FE, 
    0x00003D21, 0x000012F2, 0x00003D25, 0x000012E6, 
    0x00003D28, 0x000012DA, 0x00003D2C, 0x000012CE, 
    0x00003D30, 0x000012C2, 0x00003D33, 0x000012B6, 
    0x00003D37, 0x000012AA, 0x00003D3B, 0x0000129E, 
    0x00003D3E, 0x00001292, 0x00003D42, 0x00001286, 
    0x00003D46, 0x0000127A, 0x00003D49, 0x0000126E, 
    0x00003D4D, 0x00001262, 0x00003D51, 0x00001256, 
    0x00003D54, 0x0000124A, 0x00003D58, 0x0000123E, 
    0x00003D5B, 0x00001232, 0x00003D5F, 0x00001226, 
    0x00003D62, 0x0000121A, 0x00003D66, 0x0000120E, 
    0x00003D6A, 0x00001202, 0x00003D6D, 0x000011F5, 
    0x00003D71, 0x000011E9, 0x00003D74, 0x000011DD, 
    0x00003D78, 0x000011D1, 0x00003D7B, 0x000011C5, 
    0x00003D7F, 0x000011B9, 0x00003D82, 0x000011AD, 
    0x00003D86, 0x000011A1, 0x00003D89, 0x00001195, 
    0x00003D8C, 0x00001189, 0x00003D90, 0x0000117D, 
    0x00003D93, 0x00001171, 0x00003D97, 0x00001165, 
    0x00003D9A, 0x00001158, 0x00003D9E, 0x0000114C, 
    0x00003DA1, 0x00001140, 0x00003DA4, 0x00001134, 
    0x00003DA8, 0x00001128, 0x00003DAB, 0x0000111C, 
    0x00003DAE, 0x00001110, 0x00003DB2, 0x00001104, 
    0x00003DB5, 0x000010F8, 0x00003DB8, 0x000010EB, 
    0x00003DBC, 0x000010DF, 0x00003DBF, 0x000010D3, 
    0x00003DC2, 0x000010C7, 0x00003DC6, 0x000010BB, 
    0x00003DC9, 0x000010AF, 0x00003DCC, 0x000010A3, 
    0x00003DCF, 0x00001097, 0x00003DD3, 0x0000108A, 
    0x00003DD6, 0x0000107E, 0x00003DD9, 0x00001072, 
    0x00003DDC, 0x00001066, 0x00003DE0, 0x0000105A, 
    0x00003DE3, 0x0000104E, 0x00003DE6, 0x00001042, 
    0x00003DE9, 0x00001035, 0x00003DEC, 0x00001029, 
    0x00003DF0, 0x0000101D, 0x00003DF3, 0x00001011, 
    0x00003DF6, 0x00001005, 0x00003DF9, 0x00000FF9, 
    0x00003DFC, 0x00000FEC, 0x00003DFF, 0x00000FE0, 
    0x00003E02, 0x00000FD4, 0x00003E05, 0x00000FC8, 
    0x00003E09, 0x00000FBC, 0x00003E0C, 0x00000FB0, 
    0x00003E0F, 0x00000FA3, 0x00003E12, 0x00000F97, 
    0x00003E15, 0x00000F8B, 0x00003E18, 0x00000F7F, 
    0x00003E1B, 0x00000F73, 0x00003E1E, 0x00000F66, 
    0x00003E21, 0x00000F5A, 0x00003E24, 0x00000F4E, 
    0x00003E27, 0x00000F42, 0x00003E2A, 0x00000F36, 
    0x00003E2D, 0x00000F29, 0x00003E30, 0x00000F1D, 
    0x00003E33, 0x00000F11, 0x00003E36, 0x00000F05, 
    0x00003E39, 0x00000EF9, 0x00003E3C, 0x00000EEC, 
    0x00003E3F, 0x00000EE0, 0x00003E42, 0x00000ED4, 
    0x00003E45, 0x00000EC8, 0x00003E47, 0x00000EBB, 
    0x00003E4A, 0x00000EAF, 0x00003E4D, 0x00000EA3, 
    0x00003E50, 0x00000E97, 0x00003E53, 0x00000E8A, 
    0x00003E56, 0x00000E7E, 0x00003E59, 0x00000E72, 
    0x00003E5B, 0x00000E66, 0x00003E5E, 0x00000E59, 
    0x00003E61, 0x00000E4D, 0x00003E64, 0x00000E41, 
    0x00003E67, 0x00000E35, 0x00003E69, 0x00000E28, 
    0x00003E6C, 0x00000E1C, 0x00003E6F, 0x00000E10, 
    0x00003E72, 0x00000E04, 0x00003E74, 0x00000DF7, 
    0x00003E77, 0x00000DEB, 0x00003E7A, 0x00000DDF, 
    0x00003E7D, 0x00000DD3, 0x00003E7F, 0x00000DC6, 
    0x00003E82, 0x00000DBA, 0x00003E85, 0x00000DAE, 
    0x00003E87, 0x00000DA2, 0x00003E8A, 0x00000D95, 
    0x00003E8D, 0x00000D89, 0x00003E8F, 0x00000D7D, 
    0x00003E92, 0x00000D70, 0x00003E95, 0x00000D64, 
    0x00003E97, 0x00000D58, 0x00003E9A, 0x00000D4C, 
    0x00003E9D, 0x00000D3F, 0x00003E9F, 0x00000D33, 
    0x00003EA2, 0x00000D27, 0x00003EA4, 0x00000D1A, 
    0x00003EA7, 0x00000D0E, 0x00003EA9, 0x00000D02, 
    0x00003EAC, 0x00000CF5, 0x00003EAF, 0x00000CE9, 
    0x00003EB1, 0x00000CDD, 0x00003EB4, 0x00000CD1, 
    0x00003EB6, 0x00000CC4, 0x00003EB9, 0x00000CB8, 
    0x00003EBB, 0x00000CAC, 0x00003EBE, 0x00000C9F, 
    0x00003EC0, 0x00000C93, 0x00003EC3, 0x00000C87, 
    0x00003EC5, 0x00000C7A, 0x00003EC7, 0x00000C6E, 
    0x00003ECA, 0x00000C62, 0x00003ECC, 0x00000C55, 
    0x00003ECF, 0x00000C49, 0x00003ED1, 0x00000C3D, 
    0x00003ED4, 0x00000C30, 0x00003ED6, 0x00000C24, 
    0x00003ED8, 0x00000C18, 0x00003EDB, 0x00000C0B, 
    0x00003EDD, 0x00000BFF, 0x00003EDF, 0x00000BF3, 
    0x00003EE2, 0x00000BE6, 0x00003EE4, 0x00000BDA, 
    0x00003EE6, 0x00000BCE, 0x00003EE9, 0x00000BC1, 
    0x00003EEB, 0x00000BB5, 0x00003EED, 0x00000BA9, 
    0x00003EF0, 0x00000B9C, 0x00003EF2, 0x00000B90, 
    0x00003EF4, 0x00000B83, 0x00003EF6, 0x00000B77, 
    0x00003EF9, 0x00000B6B, 0x00003EFB, 0x00000B5E, 
    0x00003EFD, 0x00000B52, 0x00003EFF, 0x00000B46, 
    0x00003F02, 0x00000B39, 0x00003F04, 0x00000B2D, 
    0x00003F06, 0x00000B21, 0x00003F08, 0x00000B14, 
    0x00003F0A, 0x00000B08, 0x00003F0C, 0x00000AFB, 
    0x00003F0F, 0x00000AEF, 0x00003F11, 0x00000AE3, 
    0x00003F13, 0x00000AD6, 0x00003F15, 0x00000ACA, 
    0x00003F17, 0x00000ABD, 0x00003F19, 0x00000AB1, 
    0x00003F1B, 0x00000AA5, 0x00003F1D, 0x00000A98, 
    0x00003F1F, 0x00000A8C, 0x00003F21, 0x00000A7F, 
    0x00003F24, 0x00000A73, 0x00003F26, 0x00000A67, 
    0x00003F28, 0x00000A5A, 0x00003F2A, 0x00000A4E, 
    0x00003F2C, 0x00000A41, 0x00003F2E, 0x00000A35, 
    0x00003F30, 0x00000A29, 0x00003F32, 0x00000A1C, 
    0x00003F34, 0x00000A10, 0x00003F36, 0x00000A03, 
    0x00003F38, 0x000009F7, 0x00003F3A, 0x000009EB, 
    0x00003F3B, 0x000009DE, 0x00003F3D, 0x000009D2, 
    0x00003F3F, 0x000009C5, 0x00003F41, 0x000009B9, 
    0x00003F43, 0x000009AD, 0x00003F45, 0x000009A0, 
    0x00003F47, 0x00000994, 0x00003F49, 0x00000987, 
    0x00003F4B, 0x0000097B, 0x00003F4D, 0x0000096E, 
    0x00003F4E, 0x00000962, 0x00003F50, 0x00000956, 
    0x00003F52, 0x00000949, 0x00003F54, 0x0000093D, 
    0x00003F56, 0x00000930, 0x00003F57, 0x00000924, 
    0x00003F59, 0x00000917, 0x00003F5B, 0x0000090B, 
    0x00003F5D, 0x000008FE, 0x00003F5F, 0x000008F2, 
    0x00003F60, 0x000008E6, 0x00003F62, 0x000008D9, 
    0x00003F64, 0x000008CD, 0x00003F66, 0x000008C0, 
    0x00003F67, 0x000008B4, 0x00003F69, 0x000008A7, 
    0x00003F6B, 0x0000089B, 0x00003F6C, 0x0000088E, 
    0x00003F6E, 0x00000882, 0x00003F70, 0x00000876, 
    0x00003F71, 0x00000869, 0x00003F73, 0x0000085D, 
    0x00003F75, 0x00000850, 0x00003F76, 0x00000844, 
    0x00003F78, 0x00000837, 0x00003F79, 0x0000082B, 
    0x00003F7B, 0x0000081E, 0x00003F7D, 0x00000812, 
    0x00003F7E, 0x00000805, 0x00003F80, 0x000007F9, 
    0x00003F81, 0x000007EC, 0x00003F83, 0x000007E0, 
    0x00003F84, 0x000007D4, 0x00003F86, 0x000007C7, 
    0x00003F88, 0x000007BB, 0x00003F89, 0x000007AE, 
    0x00003F8B, 0x000007A2, 0x00003F8C, 0x00000795, 
    0x00003F8E, 0x00000789, 0x00003F8F, 0x0000077C, 
    0x00003F90, 0x00000770, 0x00003F92, 0x00000763, 
    0x00003F93, 0x00000757, 0x00003F95, 0x0000074A, 
    0x00003F96, 0x0000073E, 0x00003F98, 0x00000731, 
    0x00003F99, 0x00000725, 0x00003F9A, 0x00000718, 
    0x00003F9C, 0x0000070C, 0x00003F9D, 0x000006FF, 
    0x00003F9F, 0x000006F3, 0x00003FA0, 0x000006E6, 
    0x00003FA1, 0x000006DA, 0x00003FA3, 0x000006CD, 
    0x00003FA4, 0x000006C1, 0x00003FA5, 0x000006B4, 
    0x00003FA7, 0x000006A8, 0x00003FA8, 0x0000069B, 
    0x00003FA9, 0x0000068F, 0x00003FAA, 0x00000682, 
    0x00003FAC, 0x00000676, 0x00003FAD, 0x00000669, 
    0x00003FAE, 0x0000065D, 0x00003FB0, 0x00000650, 
    0x00003FB1, 0x00000644, 0x00003FB2, 0x00000637, 
    0x00003FB3, 0x0000062B, 0x00003FB4, 0x0000061E, 
    0x00003FB6, 0x00000612, 0x00003FB7, 0x00000605, 
    0x00003FB8, 0x000005F9, 0x00003FB9, 0x000005EC, 
    0x00003FBA, 0x000005E0, 0x00003FBB, 0x000005D3, 
    0x00003FBD, 0x000005C7, 0x00003FBE, 0x000005BA, 
    0x00003FBF, 0x000005AE, 0x00003FC0, 0x000005A1, 
    0x00003FC1, 0x00000595, 0x00003FC2, 0x00000588, 
    0x00003FC3, 0x0000057C, 0x00003FC4, 0x0000056F, 
    0x00003FC5, 0x00000563, 0x00003FC6, 0x00000556, 
    0x00003FC7, 0x0000054A, 0x00003FC8, 0x0000053D, 
    0x00003FCA, 0x00000531, 0x00003FCB, 0x00000524, 
    0x00003FCC, 0x00000517, 0x00003FCD, 0x0000050B, 
    0x00003FCE, 0x000004FE, 0x00003FCE, 0x000004F2, 
    0x00003FCF, 0x000004E5, 0x00003FD0, 0x000004D9, 
    0x00003FD1, 0x000004CC, 0x00003FD2, 0x000004C0, 
    0x00003FD3, 0x000004B3, 0x00003FD4, 0x000004A7, 
    0x00003FD5, 0x0000049A, 0x00003FD6, 0x0000048E, 
    0x00003FD7, 0x00000481, 0x00003FD8, 0x00000475, 
    0x00003FD9, 0x00000468, 0x00003FD9, 0x0000045B, 
    0x00003FDA, 0x0000044F, 0x00003FDB, 0x00000442, 
    0x00003FDC, 0x00000436, 0x00003FDD, 0x00000429, 
    0x00003FDE, 0x0000041D, 0x00003FDE, 0x00000410, 
    0x00003FDF, 0x00000404, 0x00003FE0, 0x000003F7, 
    0x00003FE1, 0x000003EB, 0x00003FE2, 0x000003DE, 
    0x00003FE2, 0x000003D2, 0x00003FE3, 0x000003C5, 
    0x00003FE4, 0x000003B8, 0x00003FE4, 0x000003AC, 
    0x00003FE5, 0x0000039F, 0x00003FE6, 0x00000393, 
    0x00003FE7, 0x00000386, 0x00003FE7, 0x0000037A, 
    0x00003FE8, 0x0000036D, 0x00003FE9, 0x00000361, 
    0x00003FE9, 0x00000354, 0x00003FEA, 0x00000348, 
    0x00003FEB, 0x0000033B, 0x00003FEB, 0x0000032E, 
    0x00003FEC, 0x00000322, 0x00003FEC, 0x00000315, 
    0x00003FED, 0x00000309, 0x00003FEE, 0x000002FC, 
    0x00003FEE, 0x000002F0, 0x00003FEF, 0x000002E3, 
    0x00003FEF, 0x000002D7, 0x00003FF0, 0x000002CA, 
    0x00003FF0, 0x000002BD, 0x00003FF1, 0x000002B1, 
    0x00003FF2, 0x000002A4, 0x00003FF2, 0x00000298, 
    0x00003FF3, 0x0000028B, 0x00003FF3, 0x0000027F, 
    0x00003FF4, 0x00000272, 0x00003FF4, 0x00000266, 
    0x00003FF4, 0x00000259, 0x00003FF5, 0x0000024C, 
    0x00003FF5, 0x00000240, 0x00003FF6, 0x00000233, 
    0x00003FF6, 0x00000227, 0x00003FF7, 0x0000021A, 
    0x00003FF7, 0x0000020E, 0x00003FF7, 0x00000201, 
    0x00003FF8, 0x000001F5, 0x00003FF8, 0x000001E8, 
    0x00003FF9, 0x000001DB, 0x00003FF9, 0x000001CF, 
    0x00003FF9, 0x000001C2, 0x00003FFA, 0x000001B6, 
    0x00003FFA, 0x000001A9, 0x00003FFA, 0x0000019D, 
    0x00003FFB, 0x00000190, 0x00003FFB, 0x00000183, 
    0x00003FFB, 0x00000177, 0x00003FFB, 0x0000016A, 
    0x00003FFC, 0x0000015E, 0x00003FFC, 0x00000151, 
    0x00003FFC, 0x00000145, 0x00003FFD, 0x00000138, 
    0x00003FFD, 0x0000012C, 0x00003FFD, 0x0000011F, 
    0x00003FFD, 0x00000112, 0x00003FFD, 0x00000106, 
    0x00003FFE
};
*/
