#!/bin/sh
#             __________               __   ___.
#   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
#   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
#   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
#   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
#                     \/            \/     \/    \/            \/

# Usage: genversion.sh destination-dir path-to-version.sh [source-root]

# Generate version.h file

# XXX DO NOT TWEAK VERSION HERE, EDIT version.sh INSTEAD

VERSION=`$2 $3`

cat > "$1/_version.h" << EOF
/* Generated by genversion.sh */
extern const char rbversion[];
#define RBVERSION "$VERSION"
EOF

if [ -f "$1/version.h" ]
    then if diff "$1/_version.h" "$1/version.h" > /dev/null
        then rm -f "$1/_version.h"
        else mv "$1/_version.h" "$1/version.h"
    fi
    else mv "$1/_version.h" "$1/version.h"
fi
