"""Module for speed camera database download and import"""
import pycurl
from tempfile import mkdtemp
import sys
import zipfile
import os.path
import string
import gtk
from lxml import etree

import db

ZIP_FILE = """http://www.alertegps.com/down_file_zip.asp?id_matos=112&nomfichier=Viamichelin.zip&log=False"""

def download_file(mfile):
    """Download speed camera files"""
    
    print("Download file... %s " % mfile)
    
    try:
        fp = open(mfile, "wb")
    except:
        return (1, "Error when creating tempfile %s" % mfile)
    curl = pycurl.Curl()
    curl.setopt(pycurl.URL, ZIP_FILE)
    curl.setopt(pycurl.FOLLOWLOCATION, 1)
    curl.setopt(pycurl.MAXREDIRS, 5)
    curl.setopt(pycurl.CONNECTTIMEOUT, 30)
    curl.setopt(pycurl.TIMEOUT, 300)
    curl.setopt(pycurl.NOSIGNAL, 1)
    curl.setopt(pycurl.WRITEDATA, fp)

    try:
        curl.perform()
    except:
        error_message = curl.errstr()
        print("Error : %s" % error_message)
        curl.close()
        fp.close()
        return (2, error_message)

    curl.close()
    fp.close()

    print("Download finished successfully")
    return (0,  mfile)
    
    
def extract_zip(tmpzipfile):
    """Extract speed camera zip file"""
    
    try:
        myzipfile = zipfile.ZipFile(tmpzipfile,  "r")
    except:
        return (3,  "Error when opening zip file %s" % tmpzipfile)
    for name in myzipfile.namelist():
        if ".asc" in name:
            print("Extracting %s" % name)
            try:
                destfile = open(os.path.dirname(tmpzipfile) + "/" + os.path.basename(name), 'w')
                print "Extracing %s" % destfile
                destfile.write(myzipfile.read(name))
                destfile.close()
            except IOError, err:
                return (1,  "Error %s, %s" % (err.errno, err.strerror))
            except:
                return (2,  "Unknown error when extracting %s" % name)

    return (0,  None)
    
    
def import_ascfile(ascfile, pb):
    """Import asc files in the database"""
    
    print "Importing %s" % ascfile
    mydb = db.radar_db()
    fd=open(ascfile, "r")
    
    radar_total=0
    for line in fd.readlines():
        radar_total += 1
    print ("Radar count : %s" % radar_total)
    import_step = 1.0/radar_total

    progress_status = 0.0
    i=0
    fd.seek(0)
    for line in fd.readlines():
        (longitude,  latitude, data) = string.split(line,  ",")
        mydb.insert_radar(latitude[1:],  longitude, data[2:-3])
        #print data[2:-3]
        progress_status+=import_step
        i+=1
        pb.set_fraction(progress_status)
        pb.set_text("%s / %s" %(i, radar_total))

        while gtk.events_pending():
            gtk.main_iteration(False)
    fd.close()
    
    
def import_csvfile(csvfile, pb):
    """Import csv files in the database"""
    
    print "Importing %s" % csvfile
    mydb = db.radar_db()
    fd=open(csvfile, "r")
    
    radar_total=0
    for line in fd.readlines():
        radar_total += 1
    print ("Radar count : %s" % radar_total)
    import_step = 1.0/radar_total

    progress_status = 0.0
    i=0
    fd.seek(0)
    for line in fd.readlines():
        if line[0]==";": continue
        if len(line)<5: continue
        (longitude,  latitude, data) = string.split(line,  ",")
        mydb.insert_radar(latitude.strip(),  longitude.strip(), data.strip().replace ("\"", ""))
        progress_status+=import_step
        i+=1
        pb.set_fraction(progress_status)
        pb.set_text("%s / %s" %(i, radar_total))

        while gtk.events_pending():
            gtk.main_iteration(False)
    fd.close()


def import_gpxfile(gpxfile, pb):
    """Import gpx files in the database"""
    
    print "Importing %s" % gpxfile
    mydb = db.radar_db()
    
    doc = etree.parse(gpxfile)
    root = doc.getroot()

    radar_total=0
    for wpt in root:
        radar_total += 1
    print ("Radar count : %s" % radar_total)
    import_step = 1.0/radar_total
    
    progress_status = 0.0
    i=0
    for wpt in root:
        print (wpt.attrib['lat'],  wpt.attrib['lon'], wpt.find(root.tag[:-3] + 'name').text)
        mydb.insert_radar(wpt.attrib['lat'],  wpt.attrib['lon'], wpt.find(root.tag[:-3] + 'name').text)
        progress_status+=import_step
        i+=1
        pb.set_fraction(progress_status)
        pb.set_text("%s / %s" %(i, radar_total))
        #print("%s/%s" % ( i,  radar_total))
        while gtk.events_pending():
            gtk.main_iteration(False)
            
    
if __name__ == "__main__":
    #download_file("/root/roadrunner/radars.zip")
    #(result,  message) = extract_zip("/var/tmp/tmpUS8i6Croadrunner/radars.zip")
    #print message
    #import_ascfile('/var/tmp/tmpUS8i6Croadrunner/RFR.asc',  db)
    import_gpxfile("test/speedcamera.gpx", None)
    
    
