/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class ColorTabs {
    private static final int JND = 4;
    private static final int DARKEN_LOWEST_COLOR = 0;
    private static final int DARKEN_HIGHEST_COLOR = 150;
    private static final int DARKEN_RANGE = 150;
    private static final float DARKEN_RATIO = 0.5905512f;
    private static final int MUTE_LOWEST_COLOR = 150;
    private static final int MUTE_HIGHEST_COLOR = 230;
    private static final int MUTE_RANGE = 80;
    private static final float MUTE_RATIO = 0.31496063f;
    private static ColorTabs colorTabs = null;
    private boolean enabled = false;
    private boolean selectedColorized = true;
    private boolean selectedForegroundColorized = false;
    private boolean foregroundColorized = false;
    private boolean muteColors = true;
    private boolean colorVariation = true;
    private List<ColorEntry> colors;
    private final Map<String, Color> colorsAssigned = new HashMap<String, Color>();
    private final Object lock = new Object();
    private Random rnd = null;

    private ColorTabs() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSelectedColorized() {
        return this.selectedColorized;
    }

    public void setSelectedColorized(boolean selectedColorized) {
        this.selectedColorized = selectedColorized;
    }

    public boolean isForegroundColorized() {
        return this.foregroundColorized;
    }

    public boolean isSelectedForegroundColorized() {
        return this.selectedForegroundColorized;
    }

    public void setForegroundColorized(boolean foregroundColorized) {
        this.foregroundColorized = foregroundColorized;
    }

    public void setSelectedForegroundColorized(boolean foregroundColorized) {
        this.selectedForegroundColorized = foregroundColorized;
    }

    public boolean hasMuteColors() {
        return this.muteColors;
    }

    public void setMuteColors(boolean muteColors) {
        this.muteColors = muteColors;
    }

    public boolean hasColorVariation() {
        return this.colorVariation;
    }

    public void setColorVariation(boolean colorVariation) {
        this.colorVariation = colorVariation;
    }

    Color alterColorDarken(Color color) {
        if (color == null) {
            return Color.black;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = (int)(150.0f - (float)r * 0.5905512f);
        g = (int)(150.0f - (float)g * 0.5905512f);
        b = (int)(150.0f - (float)b * 0.5905512f);
        if (this.hasColorVariation()) {
            r -= this.rnd.nextInt(5) * 4;
            g -= this.rnd.nextInt(5) * 4;
            b -= this.rnd.nextInt(5) * 4;
            r = r / 4 * 4;
            g = g / 4 * 4;
            b = b / 4 * 4;
        }
        r = Math.max(0, Math.min(r, 150));
        g = Math.max(0, Math.min(g, 150));
        b = Math.max(0, Math.min(b, 150));
        return new Color(r, g, b);
    }

    Color alterColorHighlight(Color color) {
        if (color == null) {
            return Color.lightGray;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        float s = hsb[1];
        float v = hsb[2];
        s = (float)((double)s * 0.6);
        s = Math.max(0.0f, Math.min(s, 1.0f));
        v = (float)((double)v * 1.6);
        v = Math.max(0.0f, Math.min(v, 0.8f));
        return Color.getHSBColor(hsb[0], s, v);
    }

    Color alterColorMute(Color color) {
        if (color == null) {
            return Color.gray;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = (int)(150.0f + (float)r * 0.31496063f);
        g = (int)(150.0f + (float)g * 0.31496063f);
        b = (int)(150.0f + (float)b * 0.31496063f);
        if (this.hasColorVariation()) {
            r += this.rnd.nextInt(5) * 4;
            g += this.rnd.nextInt(5) * 4;
            b += this.rnd.nextInt(5) * 4;
            r = r / 4 * 4;
            g = g / 4 * 4;
            b = b / 4 * 4;
        }
        r = Math.max(150, Math.min(r, 230));
        g = Math.max(150, Math.min(g, 230));
        b = Math.max(150, Math.min(b, 230));
        return new Color(r, g, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getDefaultColorFor(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (this.colors == null) {
                this.loadColors();
            }
            if (this.colorsAssigned.containsKey(name)) {
                return this.colorsAssigned.get(name);
            }
            for (int i = 0; i < this.colors.size(); ++i) {
                ColorEntry entry = this.colors.get(i);
                if (!entry.re.matcher(name).matches()) continue;
                Color newColor = null;
                newColor = this.hasMuteColors() ? (this.isForegroundColorized() ? this.alterColorDarken(entry.color) : this.alterColorMute(entry.color)) : entry.color;
                this.colorsAssigned.put(name, newColor);
                return newColor;
            }
            return null;
        }
    }

    public static ColorTabs instance() {
        if (colorTabs == null) {
            colorTabs = new ColorTabs();
        }
        return colorTabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColors() {
        Object object = this.lock;
        synchronized (object) {
            String glob;
            this.colors = new ArrayList<ColorEntry>();
            if (!jEdit.getBooleanProperty((String)"vfs.browser.colorize")) {
                return;
            }
            int i = 0;
            while ((glob = jEdit.getProperty((String)("vfs.browser.colors." + i + ".glob"))) != null) {
                try {
                    this.colors.add(new ColorEntry(Pattern.compile(StandardUtilities.globToRE((String)glob)), jEdit.getColorProperty((String)("vfs.browser.colors." + i + ".color"), (Color)Color.black)));
                    ++i;
                }
                catch (PatternSyntaxException e) {
                    Log.log((int)9, ColorTabs.class, (Object)("Invalid regular expression: " + glob));
                }
            }
        }
    }

    public void propertiesChanged() {
        this.loadColors();
        this.colorsAssigned.clear();
        this.rnd = new Random(20020212L);
    }

    static class ColorEntry {
        Color color;
        Pattern re;

        ColorEntry(Pattern re, Color color) {
            this.re = re;
            this.color = color;
        }
    }
}

