/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import whitespace.BlockHighlight;
import whitespace.DocumentUtilities;
import whitespace.FoldHighlight;
import whitespace.WhiteSpaceDefaults;
import whitespace.WhiteSpaceHighlight;
import whitespace.WhiteSpaceModel;

public class WhiteSpacePlugin
extends EBPlugin {
    public void start() {
        WhiteSpaceDefaults.editorStarted();
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.addHighlightsTo(panes[i]);
            }
        }
    }

    public void stop() {
        int i;
        Log.log((int)1, (Object)((Object)this), (Object)"removing all highlights");
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (i = 0; i < panes.length; ++i) {
                BlockHighlight.removeHighlightFrom(panes[i]);
                WhiteSpaceHighlight.removeHighlightFrom(panes[i]);
                FoldHighlight.removeHighlightFrom(panes[i]);
            }
        }
        Log.log((int)1, (Object)((Object)this), (Object)"removing WhiteSpaceModel properties");
        Buffer[] buffers = jEdit.getBuffers();
        for (i = 0; i < buffers.length; ++i) {
            buffers[i].setProperty("white-space.model", null);
        }
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)message;
            EditPane editPane = (EditPane)epu.getSource();
            View view = editPane.getView();
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                this.addHighlightsTo(editPane);
            } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                BlockHighlight.removeHighlightFrom(editPane);
                WhiteSpaceHighlight.removeHighlightFrom(editPane);
                FoldHighlight.removeHighlightFrom(editPane);
            }
        } else if (message instanceof PropertiesChanged) {
            BlockHighlight.propertiesChanged();
            FoldHighlight.propertiesChanged();
            WhiteSpaceHighlight.propertiesChanged();
        } else if (message instanceof BufferUpdate) {
            BufferUpdate bu = (BufferUpdate)message;
            if (bu.getWhat() == BufferUpdate.SAVING) {
                this.bufferSaving((JEditBuffer)bu.getBuffer());
            } else if (bu.getWhat() == BufferUpdate.CREATED || bu.getWhat() == BufferUpdate.DIRTY_CHANGED) {
                WhiteSpaceDefaults.bufferCreated((JEditBuffer)bu.getBuffer());
            }
        }
    }

    private void addHighlightsTo(EditPane editPane) {
        BlockHighlight.addHighlightTo(editPane);
        WhiteSpaceHighlight.addHighlightTo(editPane);
        FoldHighlight.addHighlightTo(editPane);
    }

    private void bufferSaving(JEditBuffer buffer) {
        WhiteSpaceModel model = (WhiteSpaceModel)buffer.getProperty((Object)"white-space.model");
        if (model == null) {
            return;
        }
        boolean removeTrailingWhitespace = model.getRemoveTrailingWhitespace().isEnabled();
        boolean softTabifyLeadingWhitespace = model.getSoftTabifyLeadingWhitespace().isEnabled();
        boolean tabifyLeadingWhitespace = false;
        boolean untabifyLeadingWhitespace = false;
        if (softTabifyLeadingWhitespace) {
            boolean noTabs = buffer.getBooleanProperty("noTabs");
            tabifyLeadingWhitespace = !noTabs;
            untabifyLeadingWhitespace = noTabs;
        } else {
            tabifyLeadingWhitespace = model.getTabifyLeadingWhitespace().isEnabled();
            untabifyLeadingWhitespace = model.getUntabifyLeadingWhitespace().isEnabled();
        }
        if (!(removeTrailingWhitespace || tabifyLeadingWhitespace || untabifyLeadingWhitespace)) {
            return;
        }
        long start = System.currentTimeMillis();
        buffer.beginCompoundEdit();
        if (removeTrailingWhitespace) {
            String escapeChars = jEdit.getProperty((String)"white-space.escape-chars", (String)"");
            DocumentUtilities.removeTrailingWhiteSpace(buffer, escapeChars);
        }
        if (tabifyLeadingWhitespace != untabifyLeadingWhitespace) {
            if (tabifyLeadingWhitespace) {
                DocumentUtilities.tabifyLeading(buffer, buffer.getTabSize());
            }
            if (untabifyLeadingWhitespace) {
                DocumentUtilities.untabifyLeading(buffer, buffer.getTabSize());
            }
        }
        buffer.endCompoundEdit();
        long end = System.currentTimeMillis();
        Log.log((int)1, (Object)((Object)this), (Object)("bufferSaving: " + (end - start) + " ms"));
    }
}

