/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLUtilities {
    public static String charsToEntities(String str, boolean xml11) {
        StringBuilder buf = new StringBuilder(str.length());
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (xml11 && ch < ' ' && ch != '\r' && ch != '\n' && ch != '\t') {
                buf.append("&#").append((int)ch).append(';');
                continue;
            }
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean parseXML(InputStream in, DefaultHandler handler) throws IOException {
        block15: {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            InputSource isrc = new InputSource(new BufferedInputStream(in));
            isrc.setSystemId("jedit.jar");
            parser.setContentHandler(handler);
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.parse(isrc);
            Object var6_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block15;
            }
            catch (IOException io) {
                Log.log(9, XMLUtilities.class, io);
            }
            break block15;
            {
                catch (SAXParseException se) {
                    int line = se.getLineNumber();
                    Log.log(9, XMLUtilities.class, "while parsing from " + in + ": SAXParseException: line " + line + ": ", se);
                    boolean bl = true;
                    Object var6_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException io) {
                        Log.log(9, XMLUtilities.class, io);
                    }
                    return bl;
                }
                catch (SAXException e) {
                    boolean bl;
                    try {
                        Log.log(9, XMLUtilities.class, e);
                        bl = true;
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException io) {
                            Log.log(9, XMLUtilities.class, io);
                        }
                        throw throwable;
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException io) {
                        Log.log(9, XMLUtilities.class, io);
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    public static InputSource findEntity(String systemId, String test, Class where) {
        if (systemId != null && systemId.endsWith(test)) {
            try {
                return new InputSource(new BufferedInputStream(where.getResourceAsStream(test)));
            }
            catch (Exception e) {
                Log.log(9, XMLUtilities.class, "Error while opening " + test + ':');
                Log.log(9, XMLUtilities.class, e);
            }
        }
        return null;
    }

    private XMLUtilities() {
    }
}

