/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;

public class TextAreaTransferHandler
extends TransferHandler {
    private static JEditTextArea dragSource;
    private static boolean compoundEdit;
    private static boolean sameTextArea;
    private static int insertPos;
    private static int insertOffset;

    protected Transferable createTransferable(JComponent c) {
        Log.log(1, this, "createTransferable()");
        JEditTextArea textArea = (JEditTextArea)c;
        if (textArea.getSelectionCount() == 0) {
            return null;
        }
        dragSource = textArea;
        return new TextAreaSelection(textArea);
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    public boolean importData(JComponent c, Transferable t) {
        boolean returnValue;
        Log.log(1, this, "Import data");
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                returnValue = this.importFile(c, t);
            } else {
                DataFlavor uriListStringDataFlavor = null;
                DataFlavor[] dataFlavors = t.getTransferDataFlavors();
                for (int i = 0; i < dataFlavors.length; ++i) {
                    DataFlavor dataFlavor = dataFlavors[i];
                    if (!"text".equals(dataFlavor.getPrimaryType()) || !"uri-list".equals(dataFlavor.getSubType()) || dataFlavor.getRepresentationClass() != String.class) continue;
                    uriListStringDataFlavor = dataFlavor;
                    break;
                }
                returnValue = uriListStringDataFlavor != null && t.isDataFlavorSupported(uriListStringDataFlavor) ? this.importURIList(c, t, uriListStringDataFlavor) : this.importText(c, t);
            }
        }
        catch (Exception e) {
            Log.log(9, this, e);
            returnValue = false;
        }
        GUIUtilities.getView(c).toFront();
        GUIUtilities.getView(c).requestFocus();
        c.requestFocus();
        return returnValue;
    }

    private boolean importFile(JComponent c, Transferable t) throws Exception {
        Log.log(1, this, "=> File list");
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(c, EditPane.class);
        View view = editPane.getView();
        Buffer buffer = null;
        List data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        boolean browsedDirectory = false;
        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
        for (File file : data) {
            if (file.isDirectory()) {
                if (browsedDirectory) continue;
                VFSBrowser.browseDirectory(view, file.getPath());
                browsedDirectory = true;
                continue;
            }
            Buffer _buffer = jEdit.openFile(view, file.getPath());
            if (_buffer == null) continue;
            buffer = _buffer;
            bufferSetManager.addBuffer(editPane, buffer);
        }
        if (buffer != null) {
            editPane.setBuffer(buffer);
        }
        view.toFront();
        view.requestFocus();
        editPane.requestFocus();
        return true;
    }

    private boolean importURIList(JComponent c, Transferable t, DataFlavor uriListStringDataFlavor) throws Exception {
        String str = (String)t.getTransferData(uriListStringDataFlavor);
        Log.log(1, this, "=> URIList \"" + str + '\"');
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(c, EditPane.class);
        View view = editPane.getView();
        JEditTextArea textArea = (JEditTextArea)c;
        if (dragSource == null) {
            boolean found = false;
            String[] components = str.split("\r\n");
            boolean browsedDirectory = false;
            for (int i = 0; i < components.length; ++i) {
                String str0 = components[i];
                if (str0.length() > 0) {
                    URI uri = new URI(str0);
                    if ("file".equals(uri.getScheme())) {
                        File file = new File(uri.getPath());
                        if (file.isDirectory()) {
                            if (!browsedDirectory) {
                                VFSBrowser.browseDirectory(view, file.getPath());
                                browsedDirectory = true;
                            }
                        } else {
                            VFSManager.runInWorkThread(new DraggedURLLoader(textArea, uri.getPath()));
                        }
                        found = true;
                        continue;
                    }
                    Log.log(1, this, "I do not know how to handle this URI " + uri + ", ignoring.");
                    continue;
                }
                if (i == components.length - 1) continue;
                Log.log(1, this, "Odd: there is an empty line in the uri list which is not the last line.");
            }
            if (found) {
                return true;
            }
        }
        return true;
    }

    private boolean importText(JComponent c, Transferable t) throws Exception {
        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
        str = str.trim();
        Log.log(1, this, "=> String \"" + str + '\"');
        JEditTextArea textArea = (JEditTextArea)c;
        if (dragSource == null) {
            boolean found = false;
            String[] components = str.split("\n");
            for (int i = 0; i < components.length; ++i) {
                String str0 = components[i];
                VFS vfs = VFSManager.getVFSForPath(str0);
                if (!(vfs instanceof FileVFS) || str.startsWith("file://")) {
                    if (str0.startsWith("file://")) {
                        str0 = str0.substring(7);
                    }
                    VFSManager.runInWorkThread(new DraggedURLLoader(textArea, str0));
                }
                found = true;
            }
            if (found) {
                return true;
            }
        }
        if (dragSource != null && textArea.getBuffer() == dragSource.getBuffer()) {
            compoundEdit = true;
            textArea.getBuffer().beginCompoundEdit();
        }
        sameTextArea = textArea == dragSource;
        int caret = textArea.getCaretPosition();
        Selection s = textArea.getSelectionAtOffset(caret);
        if (s != null) {
            if (sameTextArea) {
                return false;
            }
            int startPos = s.start;
            textArea.setSelectedText(s, str);
            textArea.setSelection(new Selection.Range(startPos, startPos + str.length()));
        } else if (sameTextArea) {
            insertPos = caret;
            insertOffset = 0;
            Selection[] selections = textArea.getSelection();
            for (int i = 0; i < selections.length; ++i) {
                if (selections[i].end >= insertPos + insertOffset) continue;
                insertOffset -= selections[i].end - selections[i].start;
            }
        } else {
            textArea.getBuffer().insert(caret, str);
            textArea.setSelection(new Selection.Range(caret, caret + str.length()));
        }
        textArea.scrollToCaret(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportDone(JComponent c, Transferable t, int action) {
        JEditTextArea textArea;
        block12: {
            Log.log(1, this, "Export done");
            textArea = (JEditTextArea)c;
            try {
                if (action == 0) {
                    Log.log(1, this, "Export impossible");
                    Object var7_5 = null;
                    if (compoundEdit) {
                        compoundEdit = false;
                        textArea.getBuffer().endCompoundEdit();
                    }
                    return;
                }
                if (t == null) {
                    Log.log(1, this, "=> Null transferrable");
                    textArea.selectNone();
                    break block12;
                }
                if (!t.isDataFlavorSupported(DataFlavor.stringFlavor)) break block12;
                Log.log(1, this, "=> String");
                if (sameTextArea) {
                    if (action == 2) {
                        textArea.setSelectedText(null, false);
                        insertPos += insertOffset;
                    }
                    try {
                        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                        textArea.getBuffer().insert(insertPos, str);
                        textArea.setSelection(new Selection.Range(insertPos, insertPos + str.length()));
                    }
                    catch (Exception e) {
                        Log.log(1, this, "exportDone in sameTextArea");
                        Log.log(1, this, e);
                    }
                    break block12;
                }
                if (action == 2) {
                    textArea.setSelectedText(null, false);
                    break block12;
                }
                textArea.selectNone();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (compoundEdit) {
                    compoundEdit = false;
                    textArea.getBuffer().endCompoundEdit();
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (compoundEdit) {
            compoundEdit = false;
            textArea.getBuffer().endCompoundEdit();
        }
        dragSource = null;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        JEditTextArea textArea = (JEditTextArea)c;
        boolean returnValue = false;
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                returnValue = true;
                continue;
            }
            if (flavors[i].equals(DataFlavor.stringFlavor)) {
                if (!textArea.isEditable()) continue;
                returnValue = true;
                continue;
            }
            if (!flavors[i].getRepresentationClass().equals(InputStream.class)) continue;
            returnValue = true;
            break;
        }
        Log.log(1, this, "canImport() returning " + returnValue);
        return returnValue;
    }

    private static class DraggedURLLoader
    extends WorkRequest {
        private final JEditTextArea textArea;
        private final String url;

        DraggedURLLoader(JEditTextArea textArea, String url) {
            this.textArea = textArea;
            this.url = url;
        }

        public void run() {
            jEdit.openFile(this.textArea.getView(), this.url);
        }
    }

    private static class TextAreaSelection
    extends StringSelection {
        final JEditTextArea textArea;

        TextAreaSelection(JEditTextArea textArea) {
            super(textArea.getSelectedText());
            this.textArea = textArea;
        }
    }
}

