/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.StandardUtilities;

public class TextAreaMouseHandler
extends MouseInputAdapter {
    protected final TextArea textArea;
    protected int dragStartLine;
    protected int dragStartOffset;
    protected int dragStart;
    protected int clickCount;
    protected boolean dragged;
    protected boolean quickCopyDrag;
    protected boolean control;
    protected boolean ctrlForRectangularSelection;
    protected boolean maybeDragAndDrop;

    TextAreaMouseHandler(TextArea textArea) {
        this.textArea = textArea;
    }

    public void mousePressed(MouseEvent evt) {
        this.showCursor();
        this.control = OperatingSystem.isMacOS() && evt.isMetaDown() || !OperatingSystem.isMacOS() && evt.isControlDown();
        this.ctrlForRectangularSelection = true;
        this.textArea.getInputHandler().resetLastActionCount();
        boolean bl = this.quickCopyDrag = this.textArea.isQuickCopyEnabled() && TextAreaMouseHandler.isMiddleButton(evt.getModifiers());
        if (!this.quickCopyDrag) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        this.dragStart = this.textArea.xyToOffset(x, y, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        this.dragStartLine = this.textArea.getLineOfOffset(this.dragStart);
        this.dragStartOffset = this.dragStart - this.textArea.getLineStartOffset(this.dragStartLine);
        this.dragged = false;
        this.textArea.blink = true;
        this.textArea.invalidateLine(this.textArea.getCaretLine());
        this.clickCount = evt.getClickCount();
        if (this.textArea.isDragEnabled() && this.textArea.selectionManager.insideSelection(x, y) && this.clickCount == 1 && !evt.isShiftDown()) {
            this.maybeDragAndDrop = true;
            this.textArea.moveCaretPosition(this.dragStart, false);
            return;
        }
        this.maybeDragAndDrop = false;
        if (this.quickCopyDrag) {
            this.doSingleClick(evt);
        } else {
            switch (this.clickCount) {
                case 1: {
                    this.doSingleClick(evt);
                    break;
                }
                case 2: {
                    this.doDoubleClick();
                    break;
                }
                default: {
                    this.doTripleClick();
                }
            }
        }
    }

    protected void doSingleClick(MouseEvent evt) {
        int x = evt.getX();
        int extraEndVirt = 0;
        if (this.textArea.chunkCache.getLineInfo((int)this.textArea.getLastScreenLine()).lastSubregion) {
            float dragStartLineWidth;
            int dragStart = this.textArea.xyToOffset(x, evt.getY(), !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
            int screenLine = this.textArea.getScreenLineOfOffset(dragStart);
            ChunkCache.LineInfo lineInfo = this.textArea.chunkCache.getLineInfo(screenLine);
            int offset = this.textArea.getScreenLineEndOffset(screenLine);
            if (1 != offset - dragStart || lineInfo.lastSubregion) {
                --offset;
            }
            if ((float)x > (dragStartLineWidth = (float)this.textArea.offsetToXY((int)offset).x)) {
                extraEndVirt = (int)(((float)x - dragStartLineWidth) / (float)this.textArea.charWidth);
                if (!this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled() && (x - this.textArea.getHorizontalOffset()) % this.textArea.charWidth > this.textArea.charWidth / 2) {
                    ++extraEndVirt;
                }
            }
        }
        if ((this.control && this.ctrlForRectangularSelection || this.textArea.isRectangularSelectionEnabled()) && this.textArea.isEditable()) {
            int screenLine = evt.getY() / this.textArea.getPainter().getFontMetrics().getHeight();
            if (screenLine > this.textArea.getLastScreenLine()) {
                screenLine = this.textArea.getLastScreenLine();
            }
            ChunkCache.LineInfo info = this.textArea.chunkCache.getLineInfo(screenLine);
            if (info.lastSubregion && extraEndVirt != 0) {
                String whitespace = StandardUtilities.createWhiteSpace(extraEndVirt, 0);
                this.textArea.getBuffer().insert(this.dragStart, whitespace);
                this.dragStart += whitespace.length();
            }
        }
        if (evt.isShiftDown()) {
            this.textArea.resizeSelection(this.textArea.getMarkPosition(), this.dragStart, extraEndVirt, this.textArea.isRectangularSelectionEnabled() || this.control && this.ctrlForRectangularSelection);
            if (!this.quickCopyDrag) {
                this.textArea.moveCaretPosition(this.dragStart, false);
            }
            this.dragStartLine = this.textArea.getMarkLine();
            this.dragStart = this.textArea.getMarkPosition();
            this.dragStartOffset = this.dragStart - this.textArea.getLineStartOffset(this.dragStartLine);
            this.dragged = true;
            return;
        }
        if (!this.quickCopyDrag) {
            this.textArea.moveCaretPosition(this.dragStart, false);
        }
        if (!this.textArea.isMultipleSelectionEnabled() && !this.quickCopyDrag) {
            this.textArea.selectNone();
        }
    }

    protected void doDoubleClick() {
        if (this.textArea.getLineLength(this.dragStartLine) == 0) {
            return;
        }
        String lineText = this.textArea.getLineText(this.dragStartLine);
        String noWordSep = this.textArea.getBuffer().getStringProperty("noWordSep");
        if (this.dragStartOffset == this.textArea.getLineLength(this.dragStartLine)) {
            --this.dragStartOffset;
        }
        boolean joinNonWordChars = this.textArea.getJoinNonWordChars();
        int wordStart = TextUtilities.findWordStart(lineText, this.dragStartOffset, noWordSep, joinNonWordChars, false, false);
        int wordEnd = TextUtilities.findWordEnd(lineText, this.dragStartOffset + 1, noWordSep, joinNonWordChars, false, false);
        int lineStart = this.textArea.getLineStartOffset(this.dragStartLine);
        Selection.Range sel = new Selection.Range(lineStart + wordStart, lineStart + wordEnd);
        if (this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.addToSelection(sel);
        } else {
            this.textArea.setSelection(sel);
        }
        if (this.quickCopyDrag) {
            this.quickCopyDrag = false;
        }
        this.textArea.moveCaretPosition(lineStart + wordEnd, false);
        this.dragged = true;
    }

    protected void doTripleClick() {
        int newCaret = this.textArea.getLineEndOffset(this.dragStartLine);
        if (this.dragStartLine == this.textArea.getLineCount() - 1) {
            --newCaret;
        }
        Selection.Range sel = new Selection.Range(this.textArea.getLineStartOffset(this.dragStartLine), newCaret);
        if (this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.addToSelection(sel);
        } else {
            this.textArea.setSelection(sel);
        }
        if (this.quickCopyDrag) {
            this.quickCopyDrag = false;
        }
        this.textArea.moveCaretPosition(newCaret, false);
        this.dragged = true;
    }

    public void mouseMoved(MouseEvent evt) {
        this.showCursor();
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.maybeDragAndDrop) {
            this.textArea.startDragAndDrop(evt, this.control);
            return;
        }
        if (this.textArea.isDragInProgress()) {
            return;
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        TextAreaPainter painter = this.textArea.getPainter();
        if (evt.getY() < 0) {
            int delta = Math.min(-1, evt.getY() / painter.getFontMetrics().getHeight());
            this.textArea.setFirstLine(this.textArea.getFirstLine() + delta);
        } else if (evt.getY() >= painter.getHeight()) {
            int delta = Math.max(1, (evt.getY() - painter.getHeight()) / painter.getFontMetrics().getHeight());
            if (this.textArea.lastLinePartial) {
                --delta;
            }
            this.textArea.setFirstLine(this.textArea.getFirstLine() + delta);
        }
        switch (this.clickCount) {
            case 1: {
                this.doSingleDrag(evt);
                break;
            }
            case 2: {
                this.doDoubleDrag(evt);
                break;
            }
            default: {
                this.doTripleDrag(evt);
            }
        }
    }

    private void doSingleDrag(MouseEvent evt) {
        this.dragged = true;
        TextAreaPainter painter = this.textArea.getPainter();
        int x = evt.getX();
        int y = evt.getY();
        if (y < 0) {
            y = 0;
        } else if (y >= painter.getHeight()) {
            y = painter.getHeight() - 1;
        }
        int dot = this.textArea.xyToOffset(x, y, !painter.isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled() || this.quickCopyDrag);
        int dotLine = this.textArea.getLineOfOffset(dot);
        int extraEndVirt = 0;
        if (this.textArea.chunkCache.getLineInfo((int)this.textArea.getLastScreenLine()).lastSubregion) {
            float dotLineWidth;
            int screenLine = this.textArea.getScreenLineOfOffset(dot);
            ChunkCache.LineInfo lineInfo = this.textArea.chunkCache.getLineInfo(screenLine);
            int offset = this.textArea.getScreenLineEndOffset(screenLine);
            if (1 != offset - dot || lineInfo.lastSubregion) {
                --offset;
            }
            if ((float)x > (dotLineWidth = (float)this.textArea.offsetToXY((int)offset).x)) {
                extraEndVirt = (int)(((float)x - dotLineWidth) / (float)this.textArea.charWidth);
                if (!painter.isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled() && (x - this.textArea.getHorizontalOffset()) % this.textArea.charWidth > this.textArea.charWidth / 2) {
                    ++extraEndVirt;
                }
            }
        }
        this.textArea.resizeSelection(this.dragStart, dot, extraEndVirt, this.textArea.isRectangularSelectionEnabled() || this.control && this.ctrlForRectangularSelection);
        if (this.quickCopyDrag) {
            this.textArea.scrollTo(dotLine, dot - this.textArea.getLineStartOffset(dotLine), false);
        } else {
            if (dot != this.textArea.getCaretPosition()) {
                this.textArea.moveCaretPosition(dot, false);
            }
            if (this.textArea.isRectangularSelectionEnabled() && extraEndVirt != 0) {
                this.textArea.scrollTo(dotLine, dot - this.textArea.getLineStartOffset(dotLine) + extraEndVirt, false);
            }
        }
    }

    private void doDoubleDrag(MouseEvent evt) {
        int markLineStart = this.textArea.getLineStartOffset(this.dragStartLine);
        int markLineLength = this.textArea.getLineLength(this.dragStartLine);
        int mark = this.dragStartOffset;
        TextAreaPainter painter = this.textArea.getPainter();
        int pos = this.textArea.xyToOffset(evt.getX(), Math.max(0, Math.min(painter.getHeight(), evt.getY())), !painter.isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        int line = this.textArea.getLineOfOffset(pos);
        int lineStart = this.textArea.getLineStartOffset(line);
        int lineLength = this.textArea.getLineLength(line);
        int offset = pos - lineStart;
        String lineText = this.textArea.getLineText(line);
        String markLineText = this.textArea.getLineText(this.dragStartLine);
        String noWordSep = this.textArea.getBuffer().getStringProperty("noWordSep");
        boolean joinNonWordChars = this.textArea.getJoinNonWordChars();
        if (markLineStart + this.dragStartOffset > lineStart + offset) {
            if (offset != 0 && offset != lineLength) {
                offset = TextUtilities.findWordStart(lineText, offset, noWordSep, joinNonWordChars);
            }
            if (markLineLength != 0) {
                mark = TextUtilities.findWordEnd(markLineText, mark, noWordSep, joinNonWordChars);
            }
        } else {
            if (offset != 0 && lineLength != 0) {
                offset = TextUtilities.findWordEnd(lineText, offset, noWordSep, joinNonWordChars);
            }
            if (mark != 0 && mark != markLineLength) {
                mark = TextUtilities.findWordStart(markLineText, mark, noWordSep, joinNonWordChars);
            }
        }
        if (lineStart + offset == this.textArea.getCaretPosition()) {
            return;
        }
        this.textArea.resizeSelection(markLineStart + mark, lineStart + offset, 0, false);
        this.textArea.moveCaretPosition(lineStart + offset, false);
        this.dragged = true;
    }

    private void doTripleDrag(MouseEvent evt) {
        int mouse;
        int mark;
        TextAreaPainter painter = this.textArea.getPainter();
        int offset = this.textArea.xyToOffset(evt.getX(), Math.max(0, Math.min(painter.getHeight(), evt.getY())), false);
        int mouseLine = this.textArea.getLineOfOffset(offset);
        if (this.dragStartLine > mouseLine) {
            mark = this.textArea.getLineEndOffset(this.dragStartLine) - 1;
            mouse = offset == this.textArea.getLineEndOffset(mouseLine) - 1 ? offset : this.textArea.getLineStartOffset(mouseLine);
        } else {
            mark = this.textArea.getLineStartOffset(this.dragStartLine);
            mouse = offset == this.textArea.getLineStartOffset(mouseLine) ? offset : (offset == this.textArea.getLineEndOffset(mouseLine) - 1 && mouseLine != this.textArea.getLineCount() - 1 ? this.textArea.getLineEndOffset(mouseLine) : this.textArea.getLineEndOffset(mouseLine) - 1);
        }
        mouse = Math.min(this.textArea.getBuffer().getLength(), mouse);
        if (mouse == this.textArea.getCaretPosition()) {
            return;
        }
        this.textArea.resizeSelection(mark, mouse, 0, false);
        this.textArea.moveCaretPosition(mouse, false);
        this.dragged = true;
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.dragged && this.textArea.isQuickCopyEnabled() && TextAreaMouseHandler.isMiddleButton(evt.getModifiers())) {
            this.textArea.requestFocus();
            TextArea.focusedComponent = this.textArea;
            this.textArea.setCaretPosition(this.dragStart, false);
        } else if (this.maybeDragAndDrop && !this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.dragged = false;
    }

    public static boolean isPopupTrigger(MouseEvent evt) {
        return TextAreaMouseHandler.isRightButton(evt.getModifiers());
    }

    public static boolean isMiddleButton(int modifiers) {
        if (OperatingSystem.isMacOS()) {
            if ((modifiers & 0x10) != 0) {
                return (modifiers & 8) != 0;
            }
            return (modifiers & 8) != 0;
        }
        return (modifiers & 8) != 0;
    }

    public static boolean isRightButton(int modifiers) {
        if (OperatingSystem.isMacOS()) {
            if ((modifiers & 0x10) != 0) {
                return (modifiers & 2) != 0;
            }
            return (modifiers & 4) != 0;
        }
        return (modifiers & 4) != 0;
    }

    protected void showCursor() {
        this.textArea.getPainter().setCursor(Cursor.getPredefinedCursor(2));
    }
}

