/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

class FastRepaintManager {
    private final TextArea textArea;
    private final TextAreaPainter painter;
    private Graphics2D gfx;
    private Image img;
    private boolean fastScroll;
    private int firstLine;

    FastRepaintManager(TextArea textArea, TextAreaPainter painter) {
        this.textArea = textArea;
        this.painter = painter;
    }

    void updateGraphics() {
        if (this.gfx != null) {
            this.gfx.dispose();
        }
        int width = this.painter.getWidth();
        int height = this.painter.getHeight();
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        this.img = this.painter.getGraphicsConfiguration().createCompatibleImage(width, height, 1);
        this.gfx = (Graphics2D)this.img.getGraphics();
        this.gfx.clipRect(0, 0, this.painter.getWidth(), this.painter.getHeight());
        this.fastScroll = false;
    }

    Graphics2D getGraphics() {
        return this.gfx;
    }

    RepaintLines prepareGraphics(Rectangle clipRect, int firstLine, Graphics2D gfx) {
        int visibleLines;
        int lineDelta;
        gfx.setFont(this.painter.getFont());
        gfx.setColor(this.painter.getBackground());
        int lineHeight = gfx.getFontMetrics().getHeight();
        if (this.fastScroll && (lineDelta = this.firstLine - firstLine) > -(visibleLines = this.textArea.getVisibleLines()) && lineDelta < visibleLines) {
            int yDelta = lineDelta * lineHeight;
            if (lineDelta < 0) {
                gfx.copyArea(0, -yDelta, this.painter.getWidth(), this.painter.getHeight() + yDelta, 0, yDelta);
                return new RepaintLines(visibleLines + this.firstLine - firstLine - 1, visibleLines - 1);
            }
            if (lineDelta > 0) {
                gfx.copyArea(0, 0, this.painter.getWidth(), this.painter.getHeight() - yDelta, 0, yDelta);
                return new RepaintLines(0, this.firstLine - firstLine);
            }
        }
        return new RepaintLines(clipRect.y / lineHeight, (clipRect.y + clipRect.height - 1) / lineHeight);
    }

    void paint(Graphics g) {
        this.firstLine = this.textArea.getFirstLine();
        g.drawImage(this.img, 0, 0, null);
    }

    void setFastScroll(boolean fastScroll) {
        this.fastScroll = fastScroll;
    }

    static class RepaintLines {
        final int first;
        final int last;

        RepaintLines(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public String toString() {
            return "RepaintLines[" + this.first + ',' + this.last + ']';
        }
    }
}

