/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.Iterator;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.FirstLine;
import org.gjt.sp.jedit.textarea.ScrollLineCount;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

class BufferHandler
implements BufferListener {
    private final DisplayManager displayManager;
    private final TextArea textArea;
    private final JEditBuffer buffer;
    private boolean delayedUpdate;
    private boolean delayedMultilineUpdate;
    private int delayedUpdateStart;
    private int delayedUpdateEnd;

    BufferHandler(DisplayManager displayManager, TextArea textArea, JEditBuffer buffer) {
        this.displayManager = displayManager;
        this.textArea = textArea;
        this.buffer = buffer;
    }

    public void bufferLoaded(JEditBuffer buffer) {
        this.displayManager.bufferLoaded();
    }

    public void foldHandlerChanged(JEditBuffer buffer) {
        this.displayManager.foldHandlerChanged();
    }

    public void foldLevelChanged(JEditBuffer buffer, int start, int end) {
        if (this.textArea.getDisplayManager() == this.displayManager && end != 0 && !buffer.isLoading()) {
            this.textArea.invalidateLineRange(start - 1, this.textArea.getLastPhysicalLine());
        }
    }

    public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (buffer.isLoading()) {
            return;
        }
        this.displayManager.screenLineMgr.contentInserted(startLine, numLines);
        int endLine = startLine + numLines;
        if (numLines != 0) {
            this.delayedMultilineUpdate = true;
        }
        this.displayManager.folds.contentInserted(startLine, numLines);
        FirstLine firstLine = this.displayManager.firstLine;
        ScrollLineCount scrollLineCount = this.displayManager.scrollLineCount;
        if (this.textArea.getDisplayManager() == this.displayManager) {
            if (numLines != 0) {
                firstLine.contentInserted(startLine, numLines);
                scrollLineCount.contentInserted(startLine, numLines);
            }
            if (this.delayedUpdateEnd >= startLine) {
                this.delayedUpdateEnd += numLines;
            }
            this.delayUpdate(startLine, endLine);
            Iterator<Selection> iter = this.textArea.getSelectionIterator();
            while (iter.hasNext()) {
                Selection s = iter.next();
                if (!s.contentInserted(buffer, startLine, offset, numLines, length)) continue;
                this.delayUpdate(s.startLine, s.endLine);
            }
            int caret = this.textArea.getCaretPosition();
            if (caret >= offset) {
                int scrollMode = this.textArea.caretAutoScroll() ? 2 : 0;
                this.textArea.moveCaretPosition(caret + length, scrollMode);
            } else {
                int scrollMode = this.textArea.caretAutoScroll() ? 1 : 0;
                this.textArea.moveCaretPosition(caret, scrollMode);
            }
        } else {
            firstLine.callReset = true;
            scrollLineCount.callReset = true;
        }
    }

    public void preContentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (this.textArea.getDisplayManager() == this.displayManager && numLines != 0 && buffer.isFoldStart(startLine)) {
            this.displayManager.expandFold(startLine, false);
        }
    }

    public void preContentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (buffer.isLoading()) {
            return;
        }
        FirstLine firstLine = this.displayManager.firstLine;
        ScrollLineCount scrollLineCount = this.displayManager.scrollLineCount;
        if (this.textArea.getDisplayManager() == this.displayManager) {
            int endLine = startLine + numLines;
            if (buffer.isFoldStart(endLine)) {
                if (numLines == 0) {
                    int lineStartOffset;
                    String endLineText = buffer.getLineText(endLine);
                    int i = endLineText.indexOf("{{{");
                    if (i != -1 && offset < (lineStartOffset = buffer.getLineStartOffset(endLine)) + i + 3 && offset + length > lineStartOffset + i) {
                        this.displayManager.expandFold(endLine, false);
                    }
                } else {
                    this.displayManager.expandFold(endLine, false);
                }
            }
            if (numLines != 0) {
                firstLine.preContentRemoved(startLine, offset, numLines);
                scrollLineCount.preContentRemoved(startLine, offset, numLines);
            }
            if (this.delayedUpdateEnd >= startLine) {
                this.delayedUpdateEnd -= numLines;
            }
            this.delayUpdate(startLine, startLine);
        } else {
            firstLine.callReset = true;
            scrollLineCount.callReset = true;
        }
        this.displayManager.screenLineMgr.contentRemoved(startLine, numLines);
        if (numLines == 0) {
            return;
        }
        this.delayedMultilineUpdate = true;
        if (this.displayManager.folds.preContentRemoved(startLine, numLines)) {
            this.displayManager.folds.reset(buffer.getLineCount());
            firstLine.callReset = true;
            scrollLineCount.callReset = true;
        }
        if (firstLine.physicalLine <= this.displayManager.getLastVisibleLine() && firstLine.physicalLine >= this.displayManager.getFirstVisibleLine() && !this.displayManager.isLineVisible(firstLine.physicalLine)) {
            firstLine.physicalLine = this.displayManager.getNextVisibleLine(firstLine.physicalLine);
        }
    }

    public void contentRemoved(JEditBuffer buffer, int startLine, int start, int numLines, int length) {
        if (buffer.isLoading()) {
            return;
        }
        if (this.textArea.getDisplayManager() == this.displayManager) {
            int nSel = this.textArea.getSelectionCount();
            Iterator<Selection> iter = this.textArea.getSelectionIterator();
            while (iter.hasNext()) {
                Selection s = iter.next();
                if (!s.contentRemoved(buffer, startLine, start, numLines, length)) continue;
                this.delayUpdate(s.startLine, s.endLine);
                if (nSel != 1 || s.start != s.end) continue;
                iter.remove();
            }
            int caret = this.textArea.getCaretPosition();
            if (caret >= start + length) {
                int scrollMode = this.textArea.caretAutoScroll() ? 2 : 0;
                this.textArea.moveCaretPosition(caret - length, scrollMode);
            } else if (caret >= start) {
                int scrollMode = this.textArea.caretAutoScroll() ? 2 : 0;
                this.textArea.moveCaretPosition(start, scrollMode);
            } else {
                int scrollMode = this.textArea.caretAutoScroll() ? 1 : 0;
                this.textArea.moveCaretPosition(caret, scrollMode);
            }
        }
    }

    public void transactionComplete(JEditBuffer buffer) {
        if (this.textArea.getDisplayManager() != this.displayManager) {
            this.delayedUpdate = false;
            return;
        }
        if (this.delayedUpdate) {
            this.doDelayedUpdate();
        }
        this.textArea._finishCaretUpdate();
        this.delayedUpdate = false;
        if (Debug.SCROLL_VERIFY) {
            int line = this.delayedUpdateStart;
            if (!this.displayManager.isLineVisible(line)) {
                line = this.displayManager.getNextVisibleLine(line);
            }
            System.err.println(this.delayedUpdateStart + ":" + this.delayedUpdateEnd + ':' + this.textArea.getLineCount());
            int scrollLineCount = 0;
            while (line != -1 && line <= this.delayedUpdateEnd) {
                scrollLineCount += this.displayManager.getScreenLineCount(line);
                line = this.displayManager.getNextVisibleLine(line);
            }
            if (scrollLineCount != this.displayManager.getScrollLineCount()) {
                throw new InternalError(scrollLineCount + " != " + this.displayManager.getScrollLineCount());
            }
        }
    }

    private void doDelayedUpdate() {
        int line = this.delayedUpdateStart;
        if (!this.displayManager.isLineVisible(line)) {
            line = this.displayManager.getNextVisibleLine(line);
        }
        while (line != -1 && line <= this.delayedUpdateEnd) {
            this.displayManager.updateScreenLineCount(line);
            line = this.displayManager.getNextVisibleLine(line);
        }
        this.displayManager.notifyScreenLineChanges();
        if (this.delayedMultilineUpdate) {
            this.textArea.invalidateScreenLineRange(this.textArea.chunkCache.getScreenLineOfOffset(this.delayedUpdateStart, 0), this.textArea.getVisibleLines());
            this.delayedMultilineUpdate = false;
        } else {
            this.textArea.invalidateLineRange(this.delayedUpdateStart, this.delayedUpdateEnd);
        }
        int visibleLines = this.textArea.getVisibleLines();
        if (visibleLines != 0) {
            this.textArea.chunkCache.getLineInfo(visibleLines - 1);
        }
        this.buffer.getFoldLevel(this.delayedUpdateEnd);
    }

    private void delayUpdate(int startLine, int endLine) {
        this.textArea.chunkCache.invalidateChunksFromPhys(startLine);
        this.textArea.repaintMgr.setFastScroll(false);
        if (!this.delayedUpdate) {
            this.delayedUpdateStart = startLine;
            this.delayedUpdateEnd = endLine;
            this.delayedUpdate = true;
        } else {
            this.delayedUpdateStart = Math.min(this.delayedUpdateStart, startLine);
            this.delayedUpdateEnd = Math.max(this.delayedUpdateEnd, endLine);
        }
    }
}

