/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XModeHandler
extends DefaultHandler {
    private String modeName;
    private final TokenMarker marker;
    private KeywordMap keywords;
    private Stack<TagDecl> stateStack;
    private String propName;
    private String propValue;
    private Hashtable<String, String> props;
    private Hashtable<String, String> modeProps;
    private ParserRuleSet rules;
    private Vector<Mode> reloadModes;

    public XModeHandler(String modeName) {
        this.modeName = modeName;
        this.marker = new TokenMarker();
        this.marker.addRuleSet(new ParserRuleSet(modeName, "MAIN"));
        this.stateStack = new Stack();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "xmode.dtd", XModeHandler.class);
    }

    @Override
    public void characters(char[] c, int off, int len) {
        this.peekElement().setText(c, off, len);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        TagDecl tag = this.pushElement(qName, attrs);
        if (qName.equals("WHITESPACE")) {
            Log.log(7, this, this.modeName + ": WHITESPACE rule " + "no longer needed");
        } else if (qName.equals("KEYWORDS")) {
            this.keywords = new KeywordMap(this.rules.getIgnoreCase());
        } else if (qName.equals("RULES")) {
            if (tag.lastSetName == null) {
                tag.lastSetName = "MAIN";
            }
            this.rules = this.marker.getRuleSet(tag.lastSetName);
            if (this.rules == null) {
                this.rules = new ParserRuleSet(this.modeName, tag.lastSetName);
                this.marker.addRuleSet(this.rules);
            }
            this.rules.setIgnoreCase(tag.lastIgnoreCase);
            this.rules.setHighlightDigits(tag.lastHighlightDigits);
            if (tag.lastDigitRE != null) {
                try {
                    this.rules.setDigitRegexp(Pattern.compile(tag.lastDigitRE, tag.lastIgnoreCase ? 2 : 0));
                }
                catch (PatternSyntaxException e) {
                    this.error("regexp", e);
                }
            }
            if (tag.lastEscape != null) {
                this.rules.setEscapeRule(ParserRule.createEscapeRule(tag.lastEscape));
            }
            this.rules.setDefault(tag.lastDefaultID);
            this.rules.setNoWordSep(tag.lastNoWordSep);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        block52: {
            TagDecl tag = this.popElement();
            if (name.equals(tag.tagName)) {
                byte token;
                Mode mode;
                if (!(tag.lastDelegateSet == null || tag.tagName.equals("IMPORT") || tag.lastDelegateSet.getModeName().equals(this.modeName) || this.reloadModes.contains(mode = ModeProvider.instance.getMode(tag.lastDelegateSet.getModeName())))) {
                    this.reloadModes.add(mode);
                }
                if (tag.tagName.equals("PROPERTY")) {
                    this.props.put(this.propName, this.propValue);
                } else if (tag.tagName.equals("PROPS")) {
                    if (this.peekElement().tagName.equals("RULES")) {
                        this.rules.setProperties(this.props);
                    } else {
                        this.modeProps = this.props;
                    }
                    this.props = new Hashtable();
                } else if (tag.tagName.equals("RULES")) {
                    this.rules.setKeywords(this.keywords);
                    this.keywords = null;
                    this.rules = null;
                } else if (tag.tagName.equals("IMPORT")) {
                    if (!this.rules.equals(tag.lastDelegateSet)) {
                        this.rules.addRuleSet(tag.lastDelegateSet);
                    }
                } else if (tag.tagName.equals("TERMINATE")) {
                    this.rules.setTerminateChar(tag.termChar);
                } else if (tag.tagName.equals("SEQ")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "SEQ");
                        return;
                    }
                    this.rules.addRule(ParserRule.createSequenceRule(tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastDelegateSet, tag.lastTokenID));
                } else if (tag.tagName.equals("SEQ_REGEXP")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "SEQ_REGEXP");
                        return;
                    }
                    try {
                        if (null != tag.lastHashChars) {
                            this.rules.addRule(ParserRule.createRegexpSequenceRule(tag.lastStartPosMatch, tag.lastHashChars.toCharArray(), tag.lastStart.toString(), tag.lastDelegateSet, tag.lastTokenID, this.findParent((String)"RULES").lastIgnoreCase));
                            break block52;
                        }
                        this.rules.addRule(ParserRule.createRegexpSequenceRule(tag.lastHashChar, tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastDelegateSet, tag.lastTokenID, this.findParent((String)"RULES").lastIgnoreCase));
                    }
                    catch (PatternSyntaxException re) {
                        this.error("regexp", re);
                    }
                } else if (tag.tagName.equals("SPAN")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "BEGIN");
                        return;
                    }
                    if (tag.lastEnd == null) {
                        this.error("empty-tag", "END");
                        return;
                    }
                    this.rules.addRule(ParserRule.createSpanRule(tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastEndPosMatch, tag.lastEnd.toString(), tag.lastDelegateSet, tag.lastTokenID, tag.lastMatchType, tag.lastNoLineBreak, tag.lastNoWordBreak, tag.lastEscape));
                } else if (tag.tagName.equals("SPAN_REGEXP")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "BEGIN");
                        return;
                    }
                    if (tag.lastEnd == null) {
                        this.error("empty-tag", "END");
                        return;
                    }
                    try {
                        if (null != tag.lastHashChars) {
                            this.rules.addRule(ParserRule.createRegexpSpanRule(tag.lastStartPosMatch, tag.lastHashChars.toCharArray(), tag.lastStart.toString(), tag.lastEndPosMatch, tag.lastEnd.toString(), tag.lastDelegateSet, tag.lastTokenID, tag.lastMatchType, tag.lastNoLineBreak, tag.lastNoWordBreak, this.findParent((String)"RULES").lastIgnoreCase, tag.lastEscape));
                            break block52;
                        }
                        this.rules.addRule(ParserRule.createRegexpSpanRule(tag.lastHashChar, tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastEndPosMatch, tag.lastEnd.toString(), tag.lastDelegateSet, tag.lastTokenID, tag.lastMatchType, tag.lastNoLineBreak, tag.lastNoWordBreak, this.findParent((String)"RULES").lastIgnoreCase, tag.lastEscape));
                    }
                    catch (PatternSyntaxException re) {
                        this.error("regexp", re);
                    }
                } else if (tag.tagName.equals("EOL_SPAN")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "EOL_SPAN");
                        return;
                    }
                    this.rules.addRule(ParserRule.createEOLSpanRule(tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastDelegateSet, tag.lastTokenID, tag.lastMatchType));
                } else if (tag.tagName.equals("EOL_SPAN_REGEXP")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "EOL_SPAN_REGEXP");
                        return;
                    }
                    try {
                        if (null != tag.lastHashChars) {
                            this.rules.addRule(ParserRule.createRegexpEOLSpanRule(tag.lastStartPosMatch, tag.lastHashChars.toCharArray(), tag.lastStart.toString(), tag.lastDelegateSet, tag.lastTokenID, tag.lastMatchType, this.findParent((String)"RULES").lastIgnoreCase));
                            break block52;
                        }
                        this.rules.addRule(ParserRule.createRegexpEOLSpanRule(tag.lastHashChar, tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastDelegateSet, tag.lastTokenID, tag.lastMatchType, this.findParent((String)"RULES").lastIgnoreCase));
                    }
                    catch (PatternSyntaxException re) {
                        this.error("regexp", re);
                    }
                } else if (tag.tagName.equals("MARK_FOLLOWING")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "MARK_FOLLOWING");
                        return;
                    }
                    this.rules.addRule(ParserRule.createMarkFollowingRule(tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastTokenID, tag.lastMatchType));
                } else if (tag.tagName.equals("MARK_PREVIOUS")) {
                    if (tag.lastStart == null) {
                        this.error("empty-tag", "MARK_PREVIOUS");
                        return;
                    }
                    this.rules.addRule(ParserRule.createMarkPreviousRule(tag.lastStartPosMatch, tag.lastStart.toString(), tag.lastTokenID, tag.lastMatchType));
                } else if (!(tag.tagName.equals("END") || tag.tagName.equals("BEGIN") || tag.tagName.equals("KEYWORDS") || tag.tagName.equals("MODE") || (token = Token.stringToToken(tag.tagName)) == -1)) {
                    this.addKeyword(tag.lastKeyword.toString(), token);
                }
            } else {
                throw new InternalError();
            }
        }
    }

    @Override
    public void startDocument() {
        this.props = new Hashtable();
        this.pushElement(null, null);
        this.reloadModes = new Vector();
    }

    @Override
    public void endDocument() {
        ParserRuleSet[] rulesets = this.marker.getRuleSets();
        for (int i = 0; i < rulesets.length; ++i) {
            rulesets[i].resolveImports();
        }
        for (Mode mode : this.reloadModes) {
            mode.setTokenMarker(null);
            mode.loadIfNecessary();
        }
    }

    public TokenMarker getTokenMarker() {
        return this.marker;
    }

    public Hashtable<String, String> getModeProperties() {
        return this.modeProps;
    }

    protected abstract void error(String var1, Object var2);

    protected abstract TokenMarker getTokenMarker(String var1);

    private void addKeyword(String k, byte id) {
        if (k == null) {
            this.error("empty-keyword", null);
            return;
        }
        if (this.keywords == null) {
            return;
        }
        this.keywords.add(k, id);
    }

    private TagDecl pushElement(String name, Attributes attrs) {
        if (name != null) {
            TagDecl tag = new TagDecl(name, attrs);
            this.stateStack.push(tag);
            return tag;
        }
        this.stateStack.push(null);
        return null;
    }

    private TagDecl peekElement() {
        return this.stateStack.peek();
    }

    private TagDecl popElement() {
        return this.stateStack.pop();
    }

    private TagDecl findParent(String tagName) {
        for (int idx = this.stateStack.size() - 1; idx >= 0; --idx) {
            TagDecl tag = (TagDecl)this.stateStack.get(idx);
            if (!tag.tagName.equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    private class TagDecl {
        public String tagName;
        public StringBuffer lastStart;
        public StringBuffer lastEnd;
        public StringBuffer lastKeyword;
        public String lastSetName;
        public String lastEscape;
        public ParserRuleSet lastDelegateSet;
        public String lastNoWordSep = "_";
        public ParserRuleSet rules;
        public byte lastDefaultID = 0;
        public byte lastTokenID;
        public byte lastMatchType;
        public int termChar = -1;
        public boolean lastNoLineBreak;
        public boolean lastNoWordBreak;
        public boolean lastIgnoreCase = true;
        public boolean lastHighlightDigits;
        public boolean lastAtLineStart;
        public boolean lastAtWhitespaceEnd;
        public boolean lastAtWordStart;
        public int lastStartPosMatch;
        public int lastEndPosMatch;
        public String lastDigitRE;
        public String lastHashChar;
        public String lastHashChars;

        public TagDecl(String tagName, Attributes attrs) {
            this.tagName = tagName;
            XModeHandler.this.propName = attrs.getValue("NAME");
            XModeHandler.this.propValue = attrs.getValue("VALUE");
            String tmp = attrs.getValue("TYPE");
            if (tmp != null) {
                this.lastTokenID = Token.stringToToken(tmp);
                if (this.lastTokenID == -1) {
                    XModeHandler.this.error("token-invalid", tmp);
                }
            }
            this.lastMatchType = (byte)-2;
            tmp = attrs.getValue("EXCLUDE_MATCH");
            if (tmp != null) {
                Log.log(7, this, XModeHandler.this.modeName + ": EXCLUDE_MATCH is deprecated");
                if ("TRUE".equalsIgnoreCase(tmp)) {
                    this.lastMatchType = (byte)-1;
                }
            }
            if ((tmp = attrs.getValue("MATCH_TYPE")) != null) {
                if ("CONTEXT".equals(tmp)) {
                    this.lastMatchType = (byte)-1;
                } else if ("RULE".equals(tmp)) {
                    this.lastMatchType = (byte)-2;
                } else {
                    this.lastMatchType = Token.stringToToken(tmp);
                    if (this.lastMatchType == -1) {
                        XModeHandler.this.error("token-invalid", tmp);
                    }
                }
            }
            this.lastAtLineStart = "TRUE".equals(attrs.getValue("AT_LINE_START"));
            this.lastAtWhitespaceEnd = "TRUE".equals(attrs.getValue("AT_WHITESPACE_END"));
            this.lastAtWordStart = "TRUE".equals(attrs.getValue("AT_WORD_START"));
            this.lastNoLineBreak = "TRUE".equals(attrs.getValue("NO_LINE_BREAK"));
            this.lastNoWordBreak = "TRUE".equals(attrs.getValue("NO_WORD_BREAK"));
            this.lastIgnoreCase = attrs.getValue("IGNORE_CASE") == null || "TRUE".equals(attrs.getValue("IGNORE_CASE"));
            this.lastHighlightDigits = "TRUE".equals(attrs.getValue("HIGHLIGHT_DIGITS"));
            this.lastDigitRE = attrs.getValue("DIGIT_RE");
            tmp = attrs.getValue("NO_WORD_SEP");
            if (tmp != null) {
                this.lastNoWordSep = tmp;
            }
            if ((tmp = attrs.getValue("AT_CHAR")) != null) {
                try {
                    this.termChar = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    XModeHandler.this.error("termchar-invalid", tmp);
                    this.termChar = -1;
                }
            }
            this.lastEscape = attrs.getValue("ESCAPE");
            this.lastSetName = attrs.getValue("SET");
            tmp = attrs.getValue("DELEGATE");
            if (tmp != null) {
                String delegateSetName;
                String delegateMode;
                int index = tmp.indexOf("::");
                if (index != -1) {
                    delegateMode = tmp.substring(0, index);
                    delegateSetName = tmp.substring(index + 2);
                } else {
                    delegateMode = XModeHandler.this.modeName;
                    delegateSetName = tmp;
                }
                TokenMarker delegateMarker = XModeHandler.this.getTokenMarker(delegateMode);
                if (delegateMarker == null) {
                    XModeHandler.this.error("delegate-invalid", tmp);
                } else {
                    this.lastDelegateSet = delegateMarker.getRuleSet(delegateSetName);
                    if (delegateMarker == XModeHandler.this.marker && this.lastDelegateSet == null) {
                        this.lastDelegateSet = new ParserRuleSet(delegateMode, delegateSetName);
                        this.lastDelegateSet.setDefault((byte)7);
                        XModeHandler.this.marker.addRuleSet(this.lastDelegateSet);
                    } else if (this.lastDelegateSet == null) {
                        XModeHandler.this.error("delegate-invalid", tmp);
                    }
                }
            }
            if ((tmp = attrs.getValue("DEFAULT")) != null) {
                this.lastDefaultID = Token.stringToToken(tmp);
                if (this.lastDefaultID == -1) {
                    XModeHandler.this.error("token-invalid", tmp);
                    this.lastDefaultID = 0;
                }
            }
            this.lastHashChar = attrs.getValue("HASH_CHAR");
            this.lastHashChars = attrs.getValue("HASH_CHARS");
            if (null != this.lastHashChar && null != this.lastHashChars) {
                XModeHandler.this.error("hash-char-and-hash-chars-mutually-exclusive", null);
                this.lastHashChars = null;
            }
        }

        public void setText(char[] c, int off, int len) {
            if (this.tagName.equals("EOL_SPAN") || this.tagName.equals("EOL_SPAN_REGEXP") || this.tagName.equals("MARK_PREVIOUS") || this.tagName.equals("MARK_FOLLOWING") || this.tagName.equals("SEQ") || this.tagName.equals("SEQ_REGEXP") || this.tagName.equals("BEGIN")) {
                TagDecl target = this;
                if (this.tagName.equals("BEGIN")) {
                    target = (TagDecl)XModeHandler.this.stateStack.get(XModeHandler.this.stateStack.size() - 2);
                }
                if (target.lastStart == null) {
                    target.lastStart = new StringBuffer();
                    target.lastStart.append(c, off, len);
                    target.lastStartPosMatch = (target.lastAtLineStart ? 2 : 0) | (target.lastAtWhitespaceEnd ? 4 : 0) | (target.lastAtWordStart ? 8 : 0);
                    target.lastAtLineStart = false;
                    target.lastAtWordStart = false;
                    target.lastAtWhitespaceEnd = false;
                } else {
                    target.lastStart.append(c, off, len);
                }
            } else if (this.tagName.equals("END")) {
                TagDecl target = (TagDecl)XModeHandler.this.stateStack.get(XModeHandler.this.stateStack.size() - 2);
                if (target.lastEnd == null) {
                    target.lastEnd = new StringBuffer();
                    target.lastEnd.append(c, off, len);
                    target.lastEndPosMatch = (this.lastAtLineStart ? 2 : 0) | (this.lastAtWhitespaceEnd ? 4 : 0) | (this.lastAtWordStart ? 8 : 0);
                    target.lastAtLineStart = false;
                    target.lastAtWordStart = false;
                    target.lastAtWhitespaceEnd = false;
                } else {
                    target.lastEnd.append(c, off, len);
                }
            } else {
                if (this.lastKeyword == null) {
                    this.lastKeyword = new StringBuffer();
                }
                this.lastKeyword.append(c, off, len);
            }
        }
    }
}

