/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRuleSet {
    private static ParserRuleSet[] standard = new ParserRuleSet[19];
    private String modeName;
    private String setName;
    private Hashtable<String, String> props;
    private KeywordMap keywords;
    private int ruleCount;
    private Map<Character, List<ParserRule>> ruleMap;
    private final List<ParserRuleSet> imports;
    private int terminateChar = -1;
    private boolean ignoreCase = true;
    private byte defaultToken;
    private ParserRule escapeRule;
    private boolean highlightDigits;
    private Pattern digitRE;
    private String _noWordSep;
    private String noWordSep;
    private boolean builtIn;

    public static ParserRuleSet getStandardRuleSet(byte id) {
        return standard[id];
    }

    public ParserRuleSet(String modeName, String setName) {
        this.modeName = modeName;
        this.setName = setName;
        this.ruleMap = new HashMap<Character, List<ParserRule>>();
        this.imports = new ArrayList<ParserRuleSet>();
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getName() {
        return this.modeName + "::" + this.setName;
    }

    public Hashtable<String, String> getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable<String, String> props) {
        this.props = props;
        this._noWordSep = null;
    }

    public void resolveImports() {
        for (ParserRuleSet ruleset : this.imports) {
            if (!ruleset.imports.isEmpty()) {
                ruleset.imports.remove(this);
                ruleset.resolveImports();
            }
            for (List<ParserRule> rules : ruleset.ruleMap.values()) {
                for (ParserRule rule : rules) {
                    this.addRule(rule);
                }
            }
            if (ruleset.keywords == null) continue;
            if (this.keywords == null) {
                this.keywords = new KeywordMap(this.ignoreCase);
            }
            this.keywords.add(ruleset.keywords);
        }
        this.imports.clear();
    }

    public void addRuleSet(ParserRuleSet ruleset) {
        this.imports.add(ruleset);
    }

    public void addRule(ParserRule r) {
        Character[] keys;
        ++this.ruleCount;
        if (null == r.upHashChars) {
            keys = new Character[1];
            keys[0] = null == r.upHashChar || 0 >= r.upHashChar.length() ? null : Character.valueOf(r.upHashChar.charAt(0));
        } else {
            keys = new Character[r.upHashChars.length];
            int i = 0;
            for (char upHashChar : r.upHashChars) {
                keys[i++] = Character.valueOf(upHashChar);
            }
        }
        for (Character key : keys) {
            List<ParserRule> rules = this.ruleMap.get(key);
            if (null == rules) {
                rules = new ArrayList<ParserRule>();
                this.ruleMap.put(key, rules);
            }
            int ruleAmount = rules.size();
            rules.add(r);
            if (ruleAmount <= 0) continue;
            rules.get((int)ruleAmount).next = r;
        }
    }

    @Deprecated
    public ParserRule getRules(char ch) {
        List<ParserRule> rules = this.getRules(Character.valueOf(ch));
        return rules.get(0);
    }

    public List<ParserRule> getRules(Character key) {
        List<ParserRule> nullRules;
        Character upperKey = null == key ? null : Character.valueOf(Character.toUpperCase(key.charValue()));
        List<ParserRule> rules = this.ruleMap.get(upperKey);
        rules = null == rules ? new ArrayList<ParserRule>() : new ArrayList<ParserRule>(rules);
        if (null != upperKey && null != (nullRules = this.ruleMap.get(null))) {
            int rulesSize = rules.size();
            if (0 < rulesSize && 0 < nullRules.size()) {
                rules.get((int)(rulesSize - 1)).next = nullRules.get(0);
            }
            rules.addAll(nullRules);
        }
        return rules;
    }

    public int getRuleCount() {
        return this.ruleCount;
    }

    public int getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(int atChar) {
        this.terminateChar = atChar >= 0 ? atChar : -1;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public KeywordMap getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordMap km) {
        this.keywords = km;
        this._noWordSep = null;
    }

    public boolean getHighlightDigits() {
        return this.highlightDigits;
    }

    public void setHighlightDigits(boolean highlightDigits) {
        this.highlightDigits = highlightDigits;
    }

    public Pattern getDigitRegexp() {
        return this.digitRE;
    }

    public void setDigitRegexp(Pattern digitRE) {
        this.digitRE = digitRE;
    }

    public ParserRule getEscapeRule() {
        return this.escapeRule;
    }

    public void setEscapeRule(ParserRule escapeRule) {
        this.escapeRule = escapeRule;
    }

    public byte getDefault() {
        return this.defaultToken;
    }

    public void setDefault(byte def) {
        this.defaultToken = def;
    }

    public String getNoWordSep() {
        if (this._noWordSep == null) {
            this._noWordSep = this.noWordSep;
            if (this.noWordSep == null) {
                this.noWordSep = "";
            }
            if (this.keywords != null) {
                this.noWordSep = this.noWordSep + this.keywords.getNonAlphaNumericChars();
            }
        }
        return this.noWordSep;
    }

    public void setNoWordSep(String noWordSep) {
        this.noWordSep = noWordSep;
        this._noWordSep = null;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.modeName + "::" + this.setName + ']';
    }

    static {
        for (byte i = 0; i < 19; i = (byte)(i + 1)) {
            ParserRuleSet.standard[i] = new ParserRuleSet(null, null);
            standard[i].setDefault(i);
            ParserRuleSet.standard[i].builtIn = true;
        }
    }
}

