/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchFileNode;
import org.gjt.sp.jedit.search.HyperSearchOperationNode;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

class HyperSearchRequest
extends WorkRequest {
    private View view;
    private SearchMatcher matcher;
    private HyperSearchResults results;
    private DefaultMutableTreeNode rootSearchNode;
    private Selection[] selection;
    private String searchString;
    private DefaultMutableTreeNode selectNode;

    HyperSearchRequest(View view, SearchMatcher matcher, HyperSearchResults results, Selection[] selection) {
        this.view = view;
        this.matcher = matcher;
        this.results = results;
        this.searchString = SearchAndReplace.getSearchString();
        this.rootSearchNode = new DefaultMutableTreeNode(new HyperSearchOperationNode(this.searchString, matcher));
        this.selection = selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setStatus(jEdit.getProperty("hypersearch-status"));
        SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
        String[] files = fileset.getFiles(this.view);
        if (files == null || files.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIUtilities.error(HyperSearchRequest.this.view, "empty-fileset", null);
                    HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode);
                }
            });
            return;
        }
        this.setMaximum(fileset.getFileCount(this.view));
        String searchingCaption = jEdit.getProperty("hypersearch-results.searching", new String[]{SearchAndReplace.getSearchString()}) + ' ';
        try {
            try {
                if (this.selection != null) {
                    Buffer buffer = this.view.getBuffer();
                    this.searchInSelection(buffer);
                }
                int current = 0;
                long lastStatusTime = 0L;
                int resultCount = 0;
                boolean asked = false;
                int maxResults = jEdit.getIntegerProperty("hypersearch.maxWarningResults");
                for (int i = 0; i < files.length; ++i) {
                    Buffer buffer;
                    if (!asked && resultCount > maxResults && maxResults != 0) {
                        Log.log(1, this, "Search in progress, " + resultCount + " occurrences found, asking the user to stop");
                        asked = true;
                        int ret = GUIUtilities.confirm(this.view, "hypersearch.tooManyResults", new Object[]{resultCount}, 0, 3);
                        if (ret == 0) {
                            Log.log(3, this, "Search stopped by user action");
                            break;
                        }
                    }
                    String file = files[i];
                    ++current;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastStatusTime > 250L) {
                        this.setValue(current);
                        lastStatusTime = currentTime;
                        this.results.setSearchStatus(searchingCaption + file);
                    }
                    if ((buffer = jEdit.openTemporary(null, null, file, false)) == null) continue;
                    resultCount += this.doHyperSearch(buffer, 0, buffer.getLength());
                }
                Log.log(3, this, resultCount + " OCCURENCES");
            }
            catch (Exception e) {
                Log.log(9, this, e);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchAndReplace.handleError(HyperSearchRequest.this.view, e);
                    }
                });
                Object var16_18 = null;
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode, HyperSearchRequest.this.selectNode);
                    }
                });
                return;
            }
            catch (WorkThread.Abort a) {
                Object var16_19 = null;
                VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchInSelection(Buffer buffer) throws Exception {
        this.setAbortable(false);
        int resultCount = 0;
        try {
            buffer.readLock();
            for (int i = 0; i < this.selection.length; ++i) {
                Selection s = this.selection[i];
                if (s instanceof Selection.Rect) {
                    for (int j = s.getStartLine(); j <= s.getEndLine(); ++j) {
                        resultCount += this.doHyperSearch(buffer, s.getStart(buffer, j), s.getEnd(buffer, j));
                    }
                    continue;
                }
                resultCount += this.doHyperSearch(buffer, s.getStart(), s.getEnd());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            buffer.readUnlock();
            throw throwable;
        }
        buffer.readUnlock();
        this.setAbortable(true);
        return resultCount;
    }

    private int doHyperSearch(Buffer buffer, int start, int end) throws Exception {
        this.setAbortable(false);
        HyperSearchFileNode hyperSearchFileNode = new HyperSearchFileNode(buffer.getPath());
        DefaultMutableTreeNode bufferNode = new DefaultMutableTreeNode(hyperSearchFileNode);
        int resultCount = this.doHyperSearch(buffer, start, end, bufferNode);
        hyperSearchFileNode.setCount(resultCount);
        if (resultCount != 0) {
            this.rootSearchNode.insert(bufferNode, this.rootSearchNode.getChildCount());
        }
        this.setAbortable(true);
        return resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doHyperSearch(Buffer buffer, int start, int end, DefaultMutableTreeNode bufferNode) {
        int resultCount = 0;
        JEditTextArea textArea = jEdit.getActiveView().getTextArea();
        int caretLine = textArea.getBuffer() == buffer ? textArea.getCaretLine() : -1;
        try {
            buffer.readLock();
            boolean endOfLine = buffer.getLineEndOffset(buffer.getLineOfOffset(end)) - 1 == end;
            int offset = start;
            HyperSearchResult lastResult = null;
            int counter = 0;
            while (true) {
                boolean startOfLine = buffer.getLineStartOffset(buffer.getLineOfOffset(offset)) == offset;
                SearchMatcher.Match match = this.matcher.nextMatch(buffer.getSegment(offset, end - offset), startOfLine, endOfLine, counter == 0, false);
                if (match == null) break;
                int newLine = buffer.getLineOfOffset(offset + match.start);
                if (lastResult == null || lastResult.line != newLine) {
                    lastResult = new HyperSearchResult(buffer, newLine);
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(lastResult, false);
                    if (lastResult.line == caretLine) {
                        this.selectNode = child;
                    }
                    bufferNode.add(child);
                }
                lastResult.addOccur(offset + match.start, offset + match.end);
                offset += match.end;
                if (this.matcher.isMatchingEOL()) {
                    if (offset >= buffer.getLength()) break;
                    ++offset;
                }
                ++resultCount;
                ++counter;
            }
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            buffer.readUnlock();
            throw throwable;
        }
        buffer.readUnlock();
        return resultCount;
    }
}

