/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkRequest;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class PluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    final List<Plugin> plugins = new ArrayList<Plugin>();
    final Map<String, Plugin> pluginHash = new HashMap<String, Plugin>();
    final List<PluginSet> pluginSets = new ArrayList<PluginSet>();
    private final String id = jEdit.getProperty("plugin-manager.mirror.id");
    private String cachedURL;
    private WorkRequest workRequest;
    String gzipURL;

    PluginList(WorkRequest workRequest) {
        this.workRequest = workRequest;
        this.readPluginList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readPluginList(boolean allowRetry) {
        boolean downloadIt;
        this.gzipURL = jEdit.getProperty("plugin-manager.export-url");
        if (!this.id.equals("NONE")) {
            this.gzipURL = this.gzipURL + "?mirror=" + this.id;
        }
        String path = null;
        if (jEdit.getSettingsDirectory() == null) {
            this.cachedURL = this.gzipURL;
        } else {
            path = jEdit.getSettingsDirectory() + File.separator + "pluginMgr-Cached.xml.gz";
            this.cachedURL = "file:///" + path;
        }
        boolean bl = downloadIt = !this.id.equals(jEdit.getProperty("plugin-manager.mirror.cached-id"));
        if (path != null) {
            try {
                long interval;
                long currentTime;
                long age;
                File f = new File(path);
                if (!f.canRead()) {
                    downloadIt = true;
                }
                if ((age = (currentTime = System.currentTimeMillis()) - f.lastModified()) > (interval = (long)(jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 5) * 60 * 1000))) {
                    Log.log(3, this, "PluginList cached copy too old. Downloading from mirror. ");
                    downloadIt = true;
                }
            }
            catch (Exception e) {
                Log.log(3, this, "No cached copy. Downloading from mirror. ");
                downloadIt = true;
            }
        }
        if (downloadIt && this.cachedURL != this.gzipURL) {
            this.downloadPluginList();
        }
        FilterInputStream in = null;
        InputStream inputStream = null;
        try {
            try {
                if (this.cachedURL != this.gzipURL) {
                    Log.log(3, this, "Using cached pluginlist");
                }
                inputStream = new URL(this.cachedURL).openStream();
                XMLReader parser = XMLReaderFactory.createXMLReader();
                PluginListHandler handler = new PluginListHandler(this, this.cachedURL);
                in = new BufferedInputStream(inputStream);
                if (((InputStream)in).markSupported()) {
                    ((InputStream)in).mark(2);
                    int b1 = ((InputStream)in).read();
                    int b2 = ((InputStream)in).read();
                    ((InputStream)in).reset();
                    if (b1 == 31 && b2 == 139) {
                        in = new GZIPInputStream(in);
                    }
                }
                InputSource isrc = new InputSource(new InputStreamReader((InputStream)in, "UTF8"));
                isrc.setSystemId("jedit.jar");
                parser.setContentHandler(handler);
                parser.setDTDHandler(handler);
                parser.setEntityResolver(handler);
                parser.setErrorHandler(handler);
                parser.parse(isrc);
            }
            catch (Exception e) {
                Log.log(9, this, "readpluginlist: error", e);
                if (this.cachedURL.startsWith("file:///")) {
                    Log.log(1, this, "Unable to read plugin list, deleting cached file and try again");
                    new File(this.cachedURL.substring(8)).delete();
                    if (allowRetry) {
                        this.plugins.clear();
                        this.pluginHash.clear();
                        this.pluginSets.clear();
                        this.readPluginList(false);
                    }
                }
                Object var12_17 = null;
                IOUtilities.closeQuietly(in);
                IOUtilities.closeQuietly(inputStream);
                return;
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            IOUtilities.closeQuietly(in);
            IOUtilities.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(in);
        IOUtilities.closeQuietly(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadPluginList() {
        BufferedInputStream is = null;
        BufferedOutputStream out = null;
        try {
            try {
                this.workRequest.setStatus(jEdit.getProperty("plugin-manager.list-download"));
                InputStream inputStream = new URL(this.gzipURL).openStream();
                String fileName = this.cachedURL.replaceFirst("file:///", "");
                out = new BufferedOutputStream(new FileOutputStream(fileName));
                long start = System.currentTimeMillis();
                is = new BufferedInputStream(inputStream);
                IOUtilities.copyStream(4096, null, is, out, false);
                jEdit.setProperty("plugin-manager.mirror.cached-id", this.id);
                Log.log(3, this, "Updated cached pluginlist " + (System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                Log.log(9, this, "CacheRemotePluginList: error", e);
                Object var8_8 = null;
                IOUtilities.closeQuietly(out);
                IOUtilities.closeQuietly(is);
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtilities.closeQuietly(out);
            IOUtilities.closeQuietly(is);
            throw throwable;
        }
        IOUtilities.closeQuietly(out);
        IOUtilities.closeQuietly(is);
    }

    void addPlugin(Plugin plugin) {
        plugin.checkIfInstalled();
        this.plugins.add(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet set) {
        this.pluginSets.add(set);
    }

    void finished() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = this.plugins.get(i);
            for (int j = 0; j < plugin.branches.size(); ++j) {
                Branch branch = plugin.branches.get(j);
                for (int k = 0; k < branch.deps.size(); ++k) {
                    Dependency dep = branch.deps.get(k);
                    if (!dep.what.equals("plugin")) continue;
                    dep.plugin = this.pluginHash.get(dep.pluginName);
                }
            }
        }
    }

    void dump() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            System.err.println(this.plugins.get(i));
            System.err.println();
        }
    }

    String getMirrorId() {
        return this.id;
    }

    static class Dependency {
        final String what;
        final String from;
        final String to;
        final String pluginName;
        Plugin plugin;

        Dependency(String what, String from, String to, String pluginName) {
            this.what = what;
            this.from = from;
            this.to = to;
            this.pluginName = pluginName;
        }

        boolean isSatisfied() {
            if (this.what.equals("plugin")) {
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    String installedVersion = this.plugin.getInstalledVersion();
                    if (installedVersion == null || this.from != null && StandardUtilities.compareStrings(installedVersion, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(installedVersion, this.to, false) > 0) continue;
                    return true;
                }
                return false;
            }
            if (this.what.equals("jdk")) {
                String javaVersion = System.getProperty("java.version").substring(0, 3);
                return !(this.from != null && StandardUtilities.compareStrings(javaVersion, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(javaVersion, this.to, false) > 0);
            }
            if (this.what.equals("jedit")) {
                String build = jEdit.getBuild();
                return !(this.from != null && StandardUtilities.compareStrings(build, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(build, this.to, false) > 0);
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String installDirectory, boolean downloadSource) {
            if (this.what.equals("plugin")) {
                String installedVersion = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = this.plugin.branches.get(i);
                    if (installedVersion != null && StandardUtilities.compareStrings(installedVersion, branch.version, false) >= 0 || this.from != null && StandardUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, installDirectory, downloadSource);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + ']';
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        final List<Dependency> deps = new ArrayList<Dependency>();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dep = this.deps.get(i);
                if (dep.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String installDirectory, boolean downloadSource) {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dep = this.deps.get(i);
                dep.satisfy(roster, installDirectory, downloadSource);
            }
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + ']';
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        final List<Branch> branches = new ArrayList<Branch>();

        void checkIfInstalled() {
        }

        String getInstalledVersion() {
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                EditPlugin plugin = jars[i].getPlugin();
                if (plugin != null) {
                    return jEdit.getProperty("plugin." + plugin.getClassName() + ".version");
                }
                return null;
            }
            return null;
        }

        String getInstalledPath() {
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                return path;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (int i = 0; i < this.branches.size(); ++i) {
                Branch branch = this.branches.get(i);
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String installDirectory, boolean downloadSource) {
            String installed = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (installed != null) {
                    roster.addRemove(installed);
                }
                return;
            }
            if (installed != null) {
                installDirectory = MiscUtilities.getParentOfPath(installed);
            }
            roster.addInstall(installed, downloadSource ? branch.downloadSource : branch.download, installDirectory, downloadSource ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        String description;
        final List<String> plugins = new ArrayList<String>();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

