/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.html.HTMLEditorKit;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class InstallPanel
extends JPanel
implements EBComponent {
    private final JTable table;
    private JScrollPane scrollpane;
    private PluginTableModel pluginModel;
    private PluginManager window;
    private PluginInfoBox infoBox;
    private ChoosePluginSet chooseButton;
    private boolean updates;
    private final Set<String> pluginSet = new HashSet<String>();
    static final Icon ASC_ICON = GUIUtilities.loadIcon("arrow-asc.png");
    static final Icon DESC_ICON = GUIUtilities.loadIcon("arrow-desc.png");

    InstallPanel(PluginManager window, boolean updates) {
        super(new BorderLayout(12, 12));
        this.window = window;
        this.updates = updates;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JSplitPane split = new JSplitPane(0, jEdit.getBooleanProperty("appearance.continuousLayout"));
        split.setResizeWeight(0.75);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        this.table.addFocusListener(new TableFocusHandler());
        InputMap tableInputMap = this.table.getInputMap(0);
        ActionMap tableActionMap = this.table.getActionMap();
        tableInputMap.put(KeyStroke.getKeyStroke(9, 0), "tabOutForward");
        tableActionMap.put("tabOutForward", new KeyboardAction(KeyboardCommand.TAB_OUT_FORWARD));
        tableInputMap.put(KeyStroke.getKeyStroke(9, 1), "tabOutBack");
        tableActionMap.put("tabOutBack", new KeyboardAction(KeyboardCommand.TAB_OUT_BACK));
        tableInputMap.put(KeyStroke.getKeyStroke(32, 0), "editPlugin");
        tableActionMap.put("editPlugin", new KeyboardAction(KeyboardCommand.EDIT_PLUGIN));
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0), "closePluginManager");
        tableActionMap.put("closePluginManager", new KeyboardAction(KeyboardCommand.CLOSE_PLUGIN_MANAGER));
        TableColumn col1 = this.table.getColumnModel().getColumn(0);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        TableColumn col3 = this.table.getColumnModel().getColumn(2);
        TableColumn col4 = this.table.getColumnModel().getColumn(3);
        TableColumn col5 = this.table.getColumnModel().getColumn(4);
        col1.setPreferredWidth(30);
        col1.setMinWidth(30);
        col1.setMaxWidth(30);
        col1.setResizable(false);
        col2.setPreferredWidth(180);
        col3.setPreferredWidth(130);
        col4.setPreferredWidth(70);
        col5.setPreferredWidth(70);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        header.addMouseListener(new HeaderMouseHandler());
        header.setDefaultRenderer(new HeaderRenderer((DefaultTableCellRenderer)header.getDefaultRenderer()));
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getViewport().setBackground(this.table.getBackground());
        split.setTopComponent(this.scrollpane);
        this.infoBox = new PluginInfoBox();
        JScrollPane infoPane = new JScrollPane(this.infoBox);
        infoPane.setPreferredSize(new Dimension(500, 100));
        split.setBottomComponent(infoPane);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                split.setDividerLocation(0.75);
            }
        });
        this.add("Center", split);
        Box buttons = new Box(0);
        buttons.add(new InstallButton());
        buttons.add(Box.createHorizontalStrut(12));
        buttons.add(new SelectallButton());
        this.chooseButton = new ChoosePluginSet();
        buttons.add(this.chooseButton);
        buttons.add(new ClearPluginSet());
        buttons.add(Box.createGlue());
        buttons.add(new SizeLabel());
        this.add("South", buttons);
        String path = jEdit.getProperty("plugin-manager.pluginset.path", "");
        if (!path.equals("")) {
            this.loadPluginSet(path);
        }
    }

    boolean loadPluginSet(String path) {
        VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        try {
            InputStream is = vfs._createInputStream(session, path, false, this);
            XMLUtilities.parseXML(is, new StringMapHandler());
        }
        catch (Exception e) {
            Log.log(9, this, "Loading Pluginset Error", e);
            return false;
        }
        this.pluginModel.update();
        return true;
    }

    public void updateModel() {
        final HashSet<String> savedChecked = new HashSet<String>();
        final HashSet<String> savedSelection = new HashSet<String>();
        this.pluginModel.saveSelection(savedChecked, savedSelection);
        this.pluginModel.clear();
        this.infoBox.setText(jEdit.getProperty("plugin-manager.list-download"));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                InstallPanel.this.infoBox.setText(null);
                InstallPanel.this.pluginModel.update();
                InstallPanel.this.pluginModel.restoreSelection(savedChecked, savedSelection);
            }
        });
    }

    public void handleMessage(EBMessage message) {
        if (message.getSource() == PluginManager.getInstance()) {
            this.chooseButton.path = jEdit.getProperty("plugin-manager.pluginset.path", "");
            if (this.chooseButton.path.length() > 0) {
                this.loadPluginSet(this.chooseButton.path);
                this.pluginModel.restoreSelection(new HashSet<String>(), new HashSet<String>());
                this.chooseButton.updateUI();
            }
        }
    }

    private static String formatSize(int size) {
        NumberFormat df = NumberFormat.getInstance();
        df.setMaximumFractionDigits(1);
        df.setMinimumFractionDigits(0);
        String sizeText = size < 0x100000 ? (size >> 10) + "KB" : df.format((double)size / 1048576.0) + "MB";
        return sizeText;
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private DefaultTableCellRenderer tcr;

        HeaderRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            PluginTableModel model = (PluginTableModel)table.getModel();
            Icon icon = column == model.sortType ? (model.sortDirection == 1 ? ASC_ICON : DESC_ICON) : null;
            l.setIcon(icon);
            return l;
        }
    }

    private class TableFocusHandler
    extends FocusAdapter {
        private TableFocusHandler() {
        }

        public void focusGained(FocusEvent fe) {
            if (-1 == InstallPanel.this.table.getSelectedRow() && InstallPanel.this.table.getRowCount() > 0) {
                InstallPanel.this.table.setRowSelectionInterval(0, 0);
                JScrollBar scrollbar = InstallPanel.this.scrollpane.getVerticalScrollBar();
                scrollbar.setValue(scrollbar.getMinimum());
            }
            if (-1 == InstallPanel.this.table.getSelectedColumn()) {
                InstallPanel.this.table.setColumnSelectionInterval(0, 0);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardCommand command = KeyboardCommand.NONE;

        KeyboardAction(KeyboardCommand command) {
            this.command = command;
        }

        public void actionPerformed(ActionEvent evt) {
            switch (this.command) {
                case TAB_OUT_FORWARD: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    break;
                }
                case TAB_OUT_BACK: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    break;
                }
                case EDIT_PLUGIN: {
                    int i;
                    int[] rows = InstallPanel.this.table.getSelectedRows();
                    Object[] state = new Object[rows.length];
                    for (i = 0; i < rows.length; ++i) {
                        state[i] = InstallPanel.this.pluginModel.getValueAt(rows[i], 0);
                    }
                    for (i = 0; i < rows.length; ++i) {
                        InstallPanel.this.pluginModel.setValueAt(state[i].equals(Boolean.FALSE), rows[i], 0);
                    }
                    break;
                }
                case CLOSE_PLUGIN_MANAGER: {
                    InstallPanel.this.window.ok();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }

    private static class TextRenderer
    extends DefaultTableCellRenderer {
        private DefaultTableCellRenderer tcr;

        TextRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 5) {
                this.tcr.setHorizontalAlignment(11);
            } else {
                this.tcr.setHorizontalAlignment(10);
            }
            return this.tcr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int column = InstallPanel.this.table.getTableHeader().columnAtPoint(evt.getPoint());
            ((InstallPanel)InstallPanel.this).pluginModel.sortDirection *= -1;
            InstallPanel.this.pluginModel.sort(column);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryCompare
    implements Comparator<Entry> {
        private static final int COLUMN_INSTALL = 0;
        private static final int COLUMN_NAME = 1;
        private static final int COLUMN_CATEGORY = 2;
        private static final int COLUMN_VERSION = 3;
        private static final int COLUMN_SIZE = 4;
        private static final int COLUMN_RELEASE = 5;
        private int type;
        private int sortDirection;

        EntryCompare(int type, int sortDirection) {
            this.type = type;
            this.sortDirection = sortDirection;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            int result;
            switch (this.type) {
                case 0: {
                    result = e1.install == e2.install ? 0 : (e1.install ? 1 : -1);
                    break;
                }
                case 1: {
                    result = e1.name.compareToIgnoreCase(e2.name);
                    break;
                }
                case 2: {
                    result = e1.set.compareToIgnoreCase(e2.set);
                    if (result != 0) break;
                    result = e1.name.compareToIgnoreCase(e2.name);
                    break;
                }
                case 3: {
                    if (e1.version == e2.version) {
                        result = 0;
                        break;
                    }
                    if (e1.version == null) {
                        result = -1;
                        break;
                    }
                    if (e2.version == null) {
                        result = 1;
                        break;
                    }
                    result = StandardUtilities.compareStrings(e1.version, e2.version, true);
                    break;
                }
                case 4: {
                    result = e1.size < e2.size ? -1 : (e1.size == e2.size ? 0 : 1);
                    break;
                }
                case 5: {
                    result = e1.timestamp < e2.timestamp ? -1 : (e1.timestamp == e2.timestamp ? 0 : 1);
                    break;
                }
                default: {
                    result = 0;
                }
            }
            return result * this.sortDirection;
        }
    }

    private class InstallButton
    extends JButton
    implements ActionListener,
    TableModelListener {
        InstallButton() {
            super(jEdit.getProperty("install-plugins.install"));
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent evt) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            boolean downloadSource = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            boolean installUser = jEdit.getBooleanProperty("plugin-manager.installUser");
            Roster roster = new Roster();
            String installDirectory = installUser ? MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars") : MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            int length = InstallPanel.this.pluginModel.getRowCount();
            int instcount = 0;
            for (int i = 0; i < length; ++i) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                if (!entry.install) continue;
                entry.plugin.install(roster, installDirectory, downloadSource);
                if (InstallPanel.this.updates) {
                    entry.plugin.getCompatibleBranch().satisfyDependencies(roster, installDirectory, downloadSource);
                }
                ++instcount;
            }
            if (roster.isEmpty()) {
                return;
            }
            boolean cancel = false;
            if (InstallPanel.this.updates && roster.getOperationCount() > instcount && GUIUtilities.confirm(InstallPanel.this.window, "install-plugins.depend", null, 2, 2) == 2) {
                cancel = true;
            }
            if (!cancel) {
                new PluginManagerProgress(InstallPanel.this.window, roster);
                roster.performOperationsInAWTThread(InstallPanel.this.window);
                InstallPanel.this.pluginModel.update();
            }
        }

        public void tableChanged(TableModelEvent e) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            if (e.getType() == 0) {
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    if (!((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setEnabled(true);
                    return;
                }
                this.setEnabled(false);
            }
        }
    }

    private class ClearPluginSet
    extends RolloverButton
    implements ActionListener {
        ClearPluginSet() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("install-plugins.clear-plugin-set.icon")));
            this.setToolTipText("clear plugin set");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            InstallPanel.this.pluginSet.clear();
            InstallPanel.this.pluginModel.restoreSelection(new HashSet<String>(), new HashSet<String>());
            jEdit.unsetProperty("plugin-manager.pluginset.path");
            InstallPanel.this.chooseButton.updateUI();
        }
    }

    private class ChoosePluginSet
    extends RolloverButton
    implements ActionListener {
        private String path;

        ChoosePluginSet() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("install-plugins.choose-plugin-set.icon")));
            this.addActionListener(this);
            this.updateUI();
        }

        public void updateUI() {
            this.path = jEdit.getProperty("plugin-manager.pluginset.path", "");
            if (this.path.length() < 1) {
                this.setToolTipText("Click here to choose a predefined plugin set");
            } else {
                this.setToolTipText("Choose pluginset (" + this.path + ')');
            }
            super.updateUI();
        }

        public void actionPerformed(ActionEvent ae) {
            this.path = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            String[] selectedFiles = GUIUtilities.showVFSFileDialog(InstallPanel.this.window, jEdit.getActiveView(), this.path, 0, false);
            if (selectedFiles == null || selectedFiles.length != 1) {
                return;
            }
            this.path = selectedFiles[0];
            boolean success = InstallPanel.this.loadPluginSet(this.path);
            if (success) {
                jEdit.setProperty("plugin-manager.pluginset.path", this.path);
            }
            this.updateUI();
        }
    }

    private class StringMapHandler
    extends DefaultHandler {
        StringMapHandler() {
            InstallPanel.this.pluginSet.clear();
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (localName.equals("plugin")) {
                InstallPanel.this.pluginSet.add(attrs.getValue("name"));
            }
        }
    }

    private class SelectallButton
    extends JCheckBox
    implements ActionListener,
    TableModelListener {
        SelectallButton() {
            super(jEdit.getProperty("install-plugins.select-all"));
            this.addActionListener(this);
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent evt) {
            InstallPanel.this.pluginModel.setSelectAll(this.isSelected());
        }

        public void tableChanged(TableModelEvent e) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            this.setEnabled(InstallPanel.this.pluginModel.getRowCount() != 0);
            if (e.getType() == 0) {
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    if (((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setSelected(false);
                    return;
                }
                if (length > 0) {
                    this.setSelected(true);
                }
            }
        }
    }

    private class SizeLabel
    extends JLabel
    implements TableModelListener {
        private int size = 0;

        SizeLabel() {
            this.setText(jEdit.getProperty("install-plugins.totalSize") + InstallPanel.formatSize(this.size));
            InstallPanel.this.pluginModel.addTableModelListener(this);
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                if (InstallPanel.this.pluginModel.isDownloadingList()) {
                    return;
                }
                this.size = 0;
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                    if (!entry.install) continue;
                    this.size += entry.size;
                }
                this.setText(jEdit.getProperty("install-plugins.totalSize") + InstallPanel.formatSize(this.size));
            }
        }
    }

    private class PluginInfoBox
    extends JTextPane
    implements ListSelectionListener {
        private final String[] params;

        PluginInfoBox() {
            this.setBackground(jEdit.getColorProperty("view.bgColor"));
            this.setForeground(jEdit.getColorProperty("view.fgColor"));
            this.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.setEditable(false);
            this.setEditorKit(new HTMLEditorKit());
            this.params = new String[3];
            InstallPanel.this.table.getSelectionModel().addListSelectionListener(this);
        }

        public void valueChanged(ListSelectionEvent e) {
            String text = "";
            if (InstallPanel.this.table.getSelectedRowCount() == 1) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(InstallPanel.this.table.getSelectedRow());
                this.params[0] = entry.author;
                this.params[1] = entry.date;
                this.params[2] = entry.description;
                text = jEdit.getProperty("install-plugins.info", this.params);
                text = text.replace("\n", "<br>");
                text = "<html>" + text + "</html>";
            }
            this.setText(text);
            this.setCaretPosition(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        String name;
        String installedVersion;
        String version;
        String author;
        String date;
        String description;
        String set;
        long timestamp;
        int size;
        boolean install;
        PluginList.Plugin plugin;
        List<Entry> parents = new LinkedList<Entry>();

        Entry(PluginList.Plugin plugin, String set) {
            PluginList.Branch branch = plugin.getCompatibleBranch();
            boolean downloadSource = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            int size = downloadSource ? branch.downloadSourceSize : branch.downloadSize;
            this.name = plugin.name;
            this.author = plugin.author;
            this.installedVersion = plugin.getInstalledVersion();
            this.version = branch.version;
            this.size = size;
            this.date = branch.date;
            this.description = plugin.description;
            this.set = set;
            this.install = false;
            this.plugin = plugin;
            SimpleDateFormat format = new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH);
            try {
                this.timestamp = format.parse(this.date).getTime();
            }
            catch (ParseException e) {
                Log.log(9, this, e);
            }
        }

        private void getParents(List<Entry> list) {
            for (Entry entry : this.parents) {
                if (!entry.install || list.contains(entry)) continue;
                list.add(entry);
                entry.getParents(list);
            }
        }

        Entry[] getParents() {
            ArrayList<Entry> list = new ArrayList<Entry>();
            this.getParents(list);
            Entry[] array = list.toArray(new Entry[list.size()]);
            Arrays.sort(array, new StandardUtilities.StringCompare(true));
            return array;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginTableModel
    extends AbstractTableModel {
        private List entries = new ArrayList();
        private int sortType = 1;
        int sortDirection = 1;

        private PluginTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return Object.class;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return ' ' + jEdit.getProperty("install-plugins.info.name");
                }
                case 2: {
                    return ' ' + jEdit.getProperty("install-plugins.info.category");
                }
                case 3: {
                    return ' ' + jEdit.getProperty("install-plugins.info.version");
                }
                case 4: {
                    return ' ' + jEdit.getProperty("install-plugins.info.size");
                }
                case 5: {
                    return " Release date";
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object obj = this.entries.get(rowIndex);
            if (obj instanceof String) {
                if (columnIndex == 1) {
                    return obj;
                }
                return null;
            }
            Entry entry = (Entry)obj;
            switch (columnIndex) {
                case 0: {
                    return entry.install;
                }
                case 1: {
                    return entry.name;
                }
                case 2: {
                    return entry.set;
                }
                case 3: {
                    if (InstallPanel.this.updates) {
                        return entry.installedVersion + "->" + entry.version;
                    }
                    return entry.version;
                }
                case 4: {
                    return InstallPanel.formatSize(entry.size);
                }
                case 5: {
                    return entry.date;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setSelectAll(boolean b) {
            if (this.isDownloadingList()) {
                return;
            }
            int length = this.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (b) {
                    this.setValueAt(Boolean.TRUE, i, 0);
                    continue;
                }
                Entry entry = (Entry)this.entries.get(i);
                entry.parents = new LinkedList<Entry>();
                entry.install = false;
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void setSortType(int type) {
            this.sortType = type;
            this.sort(type);
        }

        private void deselectParents(Entry entry) {
            Object[] parents = entry.getParents();
            if (parents.length == 0) {
                return;
            }
            String[] args = new String[]{entry.name};
            int result = GUIUtilities.listConfirm(InstallPanel.this.window, "plugin-manager.dependency", args, parents);
            if (result != 0) {
                entry.install = true;
                return;
            }
            for (int i = 0; i < parents.length; ++i) {
                ((Entry)parents[i]).install = false;
            }
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column != 0) {
                return;
            }
            Object obj = this.entries.get(row);
            if (obj instanceof String) {
                return;
            }
            Entry entry = (Entry)obj;
            entry.install = Boolean.TRUE.equals(aValue);
            if (!entry.install) {
                this.deselectParents(entry);
            }
            List<PluginList.Dependency> deps = entry.plugin.getCompatibleBranch().deps;
            for (int i = 0; i < deps.size(); ++i) {
                PluginList.Dependency dep = deps.get(i);
                if (!dep.what.equals("plugin")) continue;
                for (int j = 0; j < this.entries.size(); ++j) {
                    Entry temp = (Entry)this.entries.get(j);
                    if (temp.plugin != dep.plugin) continue;
                    if (entry.install) {
                        temp.parents.add(entry);
                        this.setValueAt(Boolean.TRUE, j, 0);
                        continue;
                    }
                    temp.parents.remove(entry);
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        public void sort(int type) {
            HashSet<String> savedChecked = new HashSet<String>();
            HashSet<String> savedSelection = new HashSet<String>();
            this.saveSelection(savedChecked, savedSelection);
            if (this.sortType != type) {
                this.sortDirection = 1;
            }
            this.sortType = type;
            if (this.isDownloadingList()) {
                return;
            }
            Collections.sort(this.entries, new EntryCompare(type, this.sortDirection));
            this.fireTableChanged(new TableModelEvent(this));
            this.restoreSelection(savedChecked, savedSelection);
            InstallPanel.this.table.getTableHeader().repaint();
        }

        private boolean isDownloadingList() {
            return this.entries.size() == 1 && this.entries.get(0) instanceof String;
        }

        public void clear() {
            this.entries = new ArrayList();
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void update() {
            HashSet<String> savedChecked = new HashSet<String>();
            HashSet<String> savedSelection = new HashSet<String>();
            this.saveSelection(savedChecked, savedSelection);
            PluginList pluginList = InstallPanel.this.window.getPluginList();
            if (pluginList == null) {
                return;
            }
            this.entries = new ArrayList();
            for (int i = 0; i < pluginList.pluginSets.size(); ++i) {
                PluginList.PluginSet set = pluginList.pluginSets.get(i);
                for (int j = 0; j < set.plugins.size(); ++j) {
                    PluginList.Plugin plugin = pluginList.pluginHash.get(set.plugins.get(j));
                    PluginList.Branch branch = plugin.getCompatibleBranch();
                    String installedVersion = plugin.getInstalledVersion();
                    if (InstallPanel.this.updates) {
                        if (branch == null || !branch.canSatisfyDependencies() || installedVersion == null || StandardUtilities.compareStrings(branch.version, installedVersion, false) <= 0) continue;
                        this.entries.add(new Entry(plugin, set.name));
                        continue;
                    }
                    if (installedVersion != null || !plugin.canBeInstalled()) continue;
                    this.entries.add(new Entry(plugin, set.name));
                }
            }
            this.sort(this.sortType);
            this.fireTableChanged(new TableModelEvent(this));
            this.restoreSelection(savedChecked, savedSelection);
        }

        public void saveSelection(Set<String> savedChecked, Set<String> savedSelection) {
            if (this.entries.isEmpty()) {
                return;
            }
            int c = this.getRowCount();
            for (int i = 0; i < c; ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                savedChecked.add(this.entries.get(i).toString());
            }
            int[] rows = InstallPanel.this.table.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                savedSelection.add(this.entries.get(rows[i]).toString());
            }
        }

        public void restoreSelection(Set<String> savedChecked, Set<String> savedSelection) {
            String name;
            int i;
            int c = this.getRowCount();
            for (i = 0; i < c; ++i) {
                name = this.entries.get(i).toString();
                if (InstallPanel.this.pluginSet.contains(name)) {
                    this.setValueAt(true, i, 0);
                    continue;
                }
                this.setValueAt(savedChecked.contains(name), i, 0);
            }
            if (null != InstallPanel.this.table) {
                InstallPanel.this.table.setColumnSelectionInterval(0, 0);
                if (!savedSelection.isEmpty()) {
                    int rowCount = this.getRowCount();
                    for (i = 0; i < rowCount; ++i) {
                        name = this.entries.get(i).toString();
                        if (!savedSelection.contains(name)) continue;
                        InstallPanel.this.table.setRowSelectionInterval(i, i);
                        break;
                    }
                    ListSelectionModel lsm = InstallPanel.this.table.getSelectionModel();
                    while (i < rowCount) {
                        String name2 = this.entries.get(i).toString();
                        if (savedSelection.contains(name2)) {
                            lsm.addSelectionInterval(i, i);
                        }
                        ++i;
                    }
                } else {
                    if (InstallPanel.this.table.getRowCount() != 0) {
                        InstallPanel.this.table.setRowSelectionInterval(0, 0);
                    }
                    JScrollBar scrollbar = InstallPanel.this.scrollpane.getVerticalScrollBar();
                    scrollbar.setValue(scrollbar.getMinimum());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyboardCommand {
        NONE,
        TAB_OUT_FORWARD,
        TAB_OUT_BACK,
        EDIT_PLUGIN,
        CLOSE_PLUGIN_MANAGER;

    }
}

