/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.JCheckBoxList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class EncodingsOptionPane
extends AbstractOptionPane {
    private JComboBox defaultEncoding;
    private JCheckBox encodingAutodetect;
    private JTextField encodingDetectors;
    private JTextField fallbackEncodings;
    private JCheckBoxList encodingsList;
    private JButton selectAllButton;
    private JButton selectNoneButton;

    public EncodingsOptionPane() {
        super("encodings");
    }

    protected void _init() {
        String[] encodings = MiscUtilities.getEncodings(true);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        this.defaultEncoding = new JComboBox<String>(encodings);
        this.defaultEncoding.setEditable(true);
        this.defaultEncoding.setSelectedItem(jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
        this.addComponent(jEdit.getProperty("options.general.encoding"), (Component)this.defaultEncoding);
        this.encodingAutodetect = new JCheckBox(jEdit.getProperty("options.general.encodingAutodetect"));
        this.encodingAutodetect.setSelected(jEdit.getBooleanProperty("buffer.encodingAutodetect"));
        this.addComponent((Component)this.encodingAutodetect, 1);
        this.encodingDetectors = new JTextField(jEdit.getProperty("encodingDetectors", "BOM XML-PI"));
        this.addComponent(jEdit.getProperty("options.general.encodingDetectors"), (Component)this.encodingDetectors);
        this.fallbackEncodings = new JTextField(jEdit.getProperty("fallbackEncodings", ""));
        this.fallbackEncodings.setToolTipText(jEdit.getProperty("options.general.fallbackEncodings.tooltip"));
        this.addComponent(jEdit.getProperty("options.general.fallbackEncodings"), (Component)this.fallbackEncodings);
        encodings = MiscUtilities.getEncodings(false);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        Vector<JCheckBoxList.Entry> encodingEntriesVector = new Vector<JCheckBoxList.Entry>();
        boolean enableSelectAll = false;
        boolean enableSelectNone = false;
        for (String encoding : encodings) {
            boolean selected = !jEdit.getBooleanProperty("encoding.opt-out." + encoding, false);
            enableSelectAll = enableSelectAll || !selected;
            enableSelectNone = enableSelectNone || selected;
            encodingEntriesVector.add(new JCheckBoxList.Entry(selected, encoding));
        }
        this.encodingsList = new JCheckBoxList(encodingEntriesVector);
        this.encodingsList.getModel().addTableModelListener(new TableModelHandler());
        JScrollPane encodingsScrollPane = new JScrollPane(this.encodingsList);
        encodingsScrollPane.setBorder(new TitledBorder(jEdit.getProperty("options.encodings.selectEncodings")));
        Dimension d = this.encodingsList.getPreferredSize();
        d.height = Math.min(d.height, 200);
        encodingsScrollPane.setPreferredSize(d);
        this.addComponent((Component)encodingsScrollPane, 1);
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.add(Box.createHorizontalStrut(12));
        ActionHandler actionHandler = new ActionHandler();
        this.selectAllButton = new JButton(jEdit.getProperty("options.encodings.selectAll"));
        this.selectAllButton.addActionListener(actionHandler);
        this.selectAllButton.setEnabled(enableSelectAll);
        buttonsBox.add(this.selectAllButton);
        buttonsBox.add(Box.createHorizontalStrut(12));
        this.selectNoneButton = new JButton(jEdit.getProperty("options.encodings.selectNone"));
        this.selectNoneButton.addActionListener(actionHandler);
        this.selectNoneButton.setEnabled(enableSelectNone);
        buttonsBox.add(this.selectNoneButton);
        buttonsBox.add(Box.createHorizontalStrut(12));
        this.addComponent(buttonsBox);
    }

    protected void _save() {
        jEdit.setProperty("buffer.encoding", (String)this.defaultEncoding.getSelectedItem());
        jEdit.setBooleanProperty("buffer.encodingAutodetect", this.encodingAutodetect.isSelected());
        jEdit.setProperty("encodingDetectors", this.encodingDetectors.getText());
        jEdit.setProperty("fallbackEncodings", this.fallbackEncodings.getText());
        for (JCheckBoxList.Entry entry : this.encodingsList.getValues()) {
            if (entry.isChecked()) {
                jEdit.unsetProperty("encoding.opt-out." + entry.getValue());
                continue;
            }
            jEdit.setBooleanProperty("encoding.opt-out." + entry.getValue(), true);
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tme) {
            int checkedAmount = EncodingsOptionPane.this.encodingsList.getCheckedValues().length;
            if (0 == checkedAmount) {
                EncodingsOptionPane.this.selectNoneButton.setEnabled(false);
            } else {
                EncodingsOptionPane.this.selectNoneButton.setEnabled(true);
            }
            if (EncodingsOptionPane.this.encodingsList.getValues().length == checkedAmount) {
                EncodingsOptionPane.this.selectAllButton.setEnabled(false);
            } else {
                EncodingsOptionPane.this.selectAllButton.setEnabled(true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == EncodingsOptionPane.this.selectAllButton) {
                EncodingsOptionPane.this.encodingsList.selectAll();
            } else if (source == EncodingsOptionPane.this.selectNoneButton) {
                int c = EncodingsOptionPane.this.encodingsList.getRowCount();
                for (int i = 0; i < c; ++i) {
                    EncodingsOptionPane.this.encodingsList.setValueAt(false, i, 0);
                }
            }
        }
    }
}

