/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.Encoding;
import org.gjt.sp.jedit.io.EncodingDetector;

public class EncodingWithBOM
implements Encoding {
    private static final int BOM16 = 65279;
    private static final byte[] UTF8BOM = new byte[]{-17, -69, -65};
    private static final Map<String, byte[]> bomMap = new HashMap<String, byte[]>();
    private final CharsetEncoding plain;
    private final byte[] bom;

    public EncodingWithBOM(String plain) {
        byte[] bom = bomMap.get(plain);
        if (bom == null) {
            throw new UnsupportedCharsetException(plain + " with BOM");
        }
        this.plain = new CharsetEncoding(plain);
        this.bom = bom;
    }

    public Reader getTextReader(InputStream in) throws IOException {
        byte[] actualMark = new byte[this.bom.length];
        int count = in.read(actualMark);
        if (count < this.bom.length || !Arrays.equals(actualMark, this.bom)) {
            throw new MalformedInputException(0);
        }
        return this.plain.getTextReader(in);
    }

    public Writer getTextWriter(OutputStream out) throws IOException {
        out.write(this.bom);
        return this.plain.getTextWriter(out);
    }

    public Reader getPermissiveTextReader(InputStream in) throws IOException {
        byte[] actualMark = new byte[this.bom.length];
        int count = in.read(actualMark);
        if (count < this.bom.length || !Arrays.equals(actualMark, this.bom)) {
            in = new SequenceInputStream(new ByteArrayInputStream(actualMark, 0, count), in);
        }
        return this.plain.getPermissiveTextReader(in);
    }

    static {
        bomMap.put("UTF-8", UTF8BOM);
        byte low = -1;
        byte high = -2;
        bomMap.put("UTF-16LE", new byte[]{low, high});
        bomMap.put("UTF-16BE", new byte[]{high, low});
        bomMap.put("UTF-32LE", new byte[]{low, high, 0, 0});
        bomMap.put("UTF-32BE", new byte[]{0, 0, high, low});
    }

    public static class Detector
    implements EncodingDetector {
        public String detectEncoding(InputStream sample) throws IOException {
            byte[] mark = new byte[4];
            int count = sample.read(mark);
            byte low = -1;
            byte high = -2;
            if (count >= 4) {
                if (mark[0] == low && mark[1] == high && mark[2] == 0 && mark[3] == 0) {
                    return "X-UTF-32LE-BOM";
                }
                if (mark[0] == 0 && mark[1] == 0 && mark[2] == high && mark[3] == low) {
                    return "X-UTF-32BE-BOM";
                }
            }
            if (count >= 2) {
                if (mark[0] == low && mark[1] == high) {
                    return "x-UTF-16LE-BOM";
                }
                if (mark[0] == high && mark[1] == low) {
                    return "UTF-16";
                }
            }
            if (count >= UTF8BOM.length) {
                int i;
                for (i = 0; i < UTF8BOM.length && mark[i] == UTF8BOM[i]; ++i) {
                }
                if (i == UTF8BOM.length) {
                    return "UTF-8Y";
                }
            }
            return null;
        }
    }
}

